/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.ColorCmp;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.swing.ChipsBoxContainer;
import com.iscobol.gui.client.swing.Etichetta;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.net.URL;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ChipsBoxElement
extends JPanel
implements MouseListener {
    protected int strokeSize = 1;
    protected Color shadowColor = Color.black;
    protected boolean shady = false;
    protected boolean highQuality = true;
    protected Dimension arcs = null;
    protected int shadowGap = 5;
    protected int shadowOffset = 4;
    protected int shadowAlpha = 150;
    protected boolean isbackgroundset;
    protected boolean isforegroundset;
    protected boolean isrolloverbackgroundset;
    protected boolean isrolloverforegroundset;
    private Color cbbordercolor = null;
    private boolean cbhasborder = false;
    private Color rollovercbbordercolor = null;
    private boolean cbhasrolloverborder = false;
    private JLabel imgl;
    private JLabel l;
    private Etichetta b;
    private JPanel f;
    private Color color;
    private String text;
    private int a;
    private Component f1;
    private Component f2;
    private Component f3;
    private Component f4;
    private Component f5;
    private Component f6;
    private ChipsBoxContainer parent;
    private ColorCmp cbcolor = null;
    private ColorCmp rollovercbcolor = null;
    private Color rolloverbackground = null;
    private Color rolloverforeground = null;
    private int chipstype = 1;
    private int textwidth;
    private int textheight;
    private int FOO = 15;
    private int FOOHEIGHT = 16;
    private Image bitmaporig = null;
    private int bitmapnumber = -1;
    private int bitmapwidth = -1;
    private int bitmapid = -1;
    private int colorfgbg = 0;
    private int colorfg = 0;
    private int colorfgrgb = 0;
    private int colorbg = 0;
    private int colorbgrgb = 0;
    private int rollovercolorfgbg = 0;
    private int rollovercolorfg = 0;
    private int rollovercolorfgrgb = 0;
    private int rollovercolorbg = 0;
    private int rollovercolorbgrgb = 0;
    private int bordercolor = 0;
    private int bordercolorrgb = 0;
    private int rolloverbordercolor = 0;
    private int rolloverbordercolorrgb = 0;
    private int chipsradius = 100;
    private int radiusvalue = 0;
    private Object hiddendata;
    private boolean mouseentered = false;
    private int chipsborderwidth = -1;
    private int chipsrolloverborderwidth = -1;

    public ChipsBoxElement(ChipsBoxContainer chipsBoxContainer, JPanel jPanel, String string, int n2, int n3, Image image, Image image2, int n4, int n5, int n6, int n7) {
        this.parent = chipsBoxContainer;
        this.f = jPanel;
        this.chipstype = n4;
        this.text = string;
        this.textwidth = n2;
        this.textheight = n3;
        this.chipsborderwidth = n6;
        this.chipsrolloverborderwidth = n7;
        this.setLayout(new BoxLayout(this, 0));
        if (this.chipsradius != n5 && n5 >= 0 && n5 <= 100) {
            this.setChipsRadius(n5);
        } else {
            this.setChipsRadius(this.chipsradius);
        }
        this.color = Color.white;
        this.l = new JLabel();
        this.l.setAlignmentY(0.5f);
        if (n4 == 2) {
            this.b = new Etichetta(this, jPanel, image, image2);
            this.b.setAlignmentY(0.5f);
        }
        this.setOpaque(false);
        this.l.setText(string);
        this.f1 = Box.createRigidArea(new Dimension(10, 0));
        this.f2 = Box.createRigidArea(new Dimension(10, 0));
        this.f3 = Box.createRigidArea(new Dimension(10, 0));
        this.f4 = Box.createRigidArea(new Dimension(10, 0));
        this.add(this.f1);
        this.add(this.l);
        if (n4 == 2) {
            this.add(this.f3);
            this.add(this.b);
        }
        this.add(this.f4);
        this.addMouseListener(this);
        this.doLayout();
    }

    public void setBackgroundAndCheck(Color color) {
        if (!(color instanceof SystemColor)) {
            super.setBackground(color);
            this.isbackgroundset = color != null;
        }
    }

    public void setForegroundAndCheck(Color color) {
        super.setForeground(color);
        this.l.setForeground(color);
        this.isforegroundset = color != null;
    }

    public void setBitmapNumber(int n2) {
        this.bitmapnumber = n2;
        this.setBitmap(this.bitmapid, this.bitmaporig, false);
    }

    public int getBitmapNumber() {
        return this.bitmapnumber;
    }

    public void setBitmapWidth(int n2) {
        this.bitmapwidth = n2;
        this.setBitmap(this.bitmapid, this.bitmaporig, false);
    }

    public int getBitmapWidth() {
        return this.bitmapwidth;
    }

    public int getBitmap() {
        return this.bitmapid;
    }

    private Image loadBitmap() {
        Image image = this.bitmaporig;
        if (this.bitmapnumber > 0 || this.bitmapwidth > 0) {
            image = ScreenUtility.getImage(this.bitmapwidth, -1, image, this.bitmapnumber);
        }
        return image;
    }

    public void setBitmap(int n2, Image image, boolean bl) {
        this.bitmaporig = image;
        Image image2 = this.loadBitmap();
        if (image2 != null) {
            this.bitmapid = n2;
            ImageIcon imageIcon = new ImageIcon(image2);
            RGBImageFilter rGBImageFilter = new RGBImageFilter(){
                int transparentColor = Color.white.getRGB() | 0xFF000000;

                @Override
                public final int filterRGB(int n2, int n3, int n4) {
                    if ((n4 | 0xFF000000) == this.transparentColor) {
                        return 0xFFFFFF & n4;
                    }
                    return n4;
                }
            };
            FilteredImageSource filteredImageSource = new FilteredImageSource(imageIcon.getImage().getSource(), rGBImageFilter);
            Image image3 = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
            if (this.imgl == null) {
                this.imgl = new JLabel();
                this.imgl.setAlignmentY(0.5f);
            }
            int n3 = imageIcon.getIconWidth();
            int n4 = imageIcon.getIconHeight();
            Dimension dimension = new Dimension(n3, n4);
            this.imgl.setPreferredSize(dimension);
            this.imgl.setMinimumSize(dimension);
            this.imgl.setMaximumSize(dimension);
            this.imgl.setSize(dimension);
            this.imgl.setIcon(new ImageIcon(image3));
            if (bl) {
                this.add(this.imgl);
                this.add(this.f2);
            } else if (this.getComponentCount() == 7) {
                this.remove(1);
                this.remove(1);
                this.add((Component)this.imgl, 1);
                this.add(this.f2, 2);
            } else {
                this.add((Component)this.imgl, 1);
                this.add(this.f2, 2);
            }
        } else if (!bl && this.getComponentCount() == 7) {
            this.imgl = null;
            this.remove(1);
            this.remove(2);
        }
        this.resizeok();
        this.repaint();
        this.doLayout();
        this.validate();
        this.parent.repaint();
        this.parent.doLayout();
        this.parent.validate();
    }

    void resizeok() {
        String string = this.l.getText();
        Font font = this.getFont();
        FontMetrics fontMetrics = this.l.getFontMetrics(this.l.getFont());
        this.textheight = fontMetrics.getHeight();
        this.radiusvalue = this.getRadiusValue(this.chipsradius);
        int n2 = 0;
        n2 = this.l.getWidth();
        int n3 = -1;
        int n4 = 0;
        if (this.imgl != null) {
            n4 = this.imgl.getWidth();
        }
        n3 = this.b != null ? this.FOO * 2 + n2 + 20 + this.b.getWidth() + n4 : this.FOO * 2 + n2 + n4;
        this.FOO = 0;
        n3 = 0;
        Component[] componentArray = this.getComponents();
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            if (componentArray[i2].getPreferredSize().getWidth() == 0.0) {
                n3 += 10;
                continue;
            }
            n3 = (int)((double)n3 + componentArray[i2].getPreferredSize().getWidth());
        }
        this.setPreferredSize(new Dimension(n3, this.textheight + this.FOOHEIGHT));
        this.setMinimumSize(new Dimension(n3, this.textheight + this.FOOHEIGHT));
        this.validate();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.parent.getMouseListener() != null) {
            this.parent.getMouseListener().mousePressed(mouseEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.parent.sendClicked(this);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseentered = true;
        this.repaint();
        this.parent.sendMouseEntered(this);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseentered = false;
        this.repaint();
        Rectangle rectangle = this.getBounds();
        Point point = this.getLocationOnScreen();
        rectangle.x = point.x;
        rectangle.y = point.y;
        Point point2 = mouseEvent.getLocationOnScreen();
        if (!rectangle.contains(point2.getX(), point2.getY())) {
            this.parent.sendMouseExited(this);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        int n4 = this.shadowGap;
        Color color = new Color(this.shadowColor.getRed(), this.shadowColor.getGreen(), this.shadowColor.getBlue(), this.shadowAlpha);
        this.arcs = new Dimension(this.radiusvalue, this.radiusvalue);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.highQuality) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.shady) {
            graphics2D.setColor(color);
            graphics2D.fillRoundRect(this.shadowOffset, this.shadowOffset, n2 - this.strokeSize - this.shadowOffset, n3 - this.strokeSize - this.shadowOffset, this.arcs.width, this.arcs.height);
        } else {
            n4 = 1;
        }
        Color color2 = null;
        if (this.mouseentered && this.isrolloverbackgroundset) {
            color2 = this.rolloverbackground;
        }
        if (color2 == null) {
            color2 = this.isbackgroundset ? this.getBackground() : this.color;
        }
        graphics2D.setColor(color2);
        graphics2D.fillRoundRect(0, 0, n2 - n4, n3 - n4, this.arcs.width, this.arcs.height);
        Color color3 = null;
        if (this.mouseentered && this.cbhasrolloverborder) {
            color3 = this.rollovercbbordercolor;
        } else if (this.cbhasborder) {
            color3 = this.cbbordercolor;
        }
        if (color3 != null) {
            graphics2D.setColor(color3);
        }
        int n5 = 0;
        if (this.mouseentered && this.chipsrolloverborderwidth > 0) {
            n5 = this.chipsrolloverborderwidth;
        } else if (this.cbhasborder) {
            if (this.chipsborderwidth > 0) {
                n5 = this.chipsborderwidth;
            } else {
                graphics2D.drawRoundRect(0, 0, n2 - n4, n3 - n4, this.arcs.width, this.arcs.height);
            }
        }
        if (n5 > 0) {
            graphics2D.fillRoundRect(0, 0, n2 - n4, n3 - n4, this.arcs.width, this.arcs.height);
            graphics2D.setColor(color2);
            graphics2D.fillRoundRect(n5, n5, n2 - n4 - n5 * 2, n3 - n4 - n5 * 2, this.arcs.width - n5, this.arcs.height - n5);
        }
        Color color4 = null;
        if (this.mouseentered && this.isrolloverforegroundset) {
            color4 = this.rolloverforeground;
        }
        if (color4 == null) {
            color4 = this.getForeground();
        }
        this.l.setForeground(color4);
        graphics2D.setColor(color4);
        graphics2D.setStroke(new BasicStroke(this.strokeSize));
        graphics2D.setStroke(new BasicStroke());
    }

    public ImageIcon createImageIcon(String string) {
        URL uRL = this.getClass().getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        System.err.println("Couldn't find file: " + string);
        return null;
    }

    public String getItemText() {
        return this.text;
    }

    public void setItemText(String string, int n2, int n3) {
        this.text = string;
        this.textwidth = n2;
        this.textheight = n3;
        this.l.setText(string);
        this.resizeok();
        this.l.repaint();
        this.l.validate();
        this.validate();
        this.parent.repaint();
        this.parent.doLayout();
    }

    public void setTextHeight(int n2) {
        this.textheight = n2;
        this.radiusvalue = this.getRadiusValue(this.chipsradius);
        this.resizeok();
    }

    @Override
    public void setFont(Font font) {
        if (this.l != null) {
            this.l.setFont(font);
            this.resizeok();
            this.validate();
            this.parent.repaint();
            this.parent.doLayout();
        }
    }

    public ColorCmp getCBColor() {
        return this.cbcolor;
    }

    public int getCBColor(boolean bl, boolean bl2, boolean bl3) {
        if (!(bl || bl2 || bl3)) {
            return this.colorfgbg;
        }
        if (bl && bl2 && !bl3) {
            if (this.cbcolor == null || !this.cbcolor.isBackgroundSet()) {
                return this.colorbg;
            }
            return this.cbcolor.getBackground();
        }
        if (bl && bl2 && bl3) {
            return this.colorbgrgb;
        }
        if (bl && !bl2 && !bl3) {
            if (this.cbcolor == null || !this.cbcolor.isForegroundSet()) {
                return this.colorfg;
            }
            return this.cbcolor.getForeground();
        }
        if (bl && !bl2 && bl3) {
            return this.colorfgrgb;
        }
        return -1;
    }

    public void setCBColor(ColorCmp colorCmp, int n2, boolean bl, boolean bl2, boolean bl3) {
        int n3;
        if (!(bl || bl2 || bl3)) {
            this.colorfgbg = n2;
        } else if (bl && bl2 && !bl3) {
            this.colorbg = n2;
        } else if (bl && bl2 && bl3) {
            this.colorbgrgb = n2;
        } else if (bl && !bl2 && !bl3) {
            this.colorfg = n2;
        } else if (bl && !bl2 && bl3) {
            this.colorfgrgb = n2;
        }
        ColorCmp colorCmp2 = this.cbcolor;
        if (colorCmp2 == null) {
            colorCmp2 = new ColorCmp();
        }
        Color color = null;
        int n4 = -1;
        if (colorCmp != null && colorCmp.isBackgroundSet()) {
            n3 = colorCmp.getBackground();
            if (ColorCmp.isRGB(n3)) {
                colorCmp2.setBackRGB(n3);
            } else {
                colorCmp2.setBackground(n3);
            }
            n4 = ColorCmp.getRealColor(colorCmp2.getBackground(), colorCmp2.isBackIntensitySet());
            color = this.parent.getColor(n4);
            this.setBackgroundAndCheck(color);
        }
        if (colorCmp != null && colorCmp.isForegroundSet()) {
            n3 = colorCmp.getForeground();
            if (ColorCmp.isRGB(n3)) {
                colorCmp2.setForeRGB(n3);
            } else {
                colorCmp2.setForeground(n3);
            }
            n4 = ColorCmp.getRealColor(colorCmp2.getForeground(), colorCmp2.isForeIntensitySet());
            color = this.parent.getColor(n4);
            this.setForegroundAndCheck(color);
        }
        this.cbcolor = colorCmp2;
    }

    public ColorCmp getCBRolloverColor() {
        return this.rollovercbcolor;
    }

    public int getCBRolloverColor(boolean bl, boolean bl2, boolean bl3) {
        if (!(bl || bl2 || bl3)) {
            return this.rollovercolorfgbg;
        }
        if (bl && bl2 && !bl3) {
            if (this.rollovercbcolor == null || !this.rollovercbcolor.isBackgroundSet()) {
                return this.rollovercolorbg;
            }
            return this.rollovercbcolor.getBackground();
        }
        if (bl && bl2 && bl3) {
            return this.rollovercolorbgrgb;
        }
        if (bl && !bl2 && !bl3) {
            if (this.rollovercbcolor == null || !this.rollovercbcolor.isForegroundSet()) {
                return this.rollovercolorfg;
            }
            return this.rollovercbcolor.getForeground();
        }
        if (bl && !bl2 && bl3) {
            return this.rollovercolorfgrgb;
        }
        return -1;
    }

    public void setCBRolloverColor(ColorCmp colorCmp, int n2, boolean bl, boolean bl2, boolean bl3) {
        int n3;
        if (!(bl || bl2 || bl3)) {
            this.rollovercolorfgbg = n2;
        } else if (bl && bl2 && !bl3) {
            this.rollovercolorbg = n2;
        } else if (bl && bl2 && bl3) {
            this.rollovercolorbgrgb = n2;
        } else if (bl && !bl2 && !bl3) {
            this.rollovercolorfg = n2;
        } else if (bl && !bl2 && bl3) {
            this.rollovercolorfgrgb = n2;
        }
        ColorCmp colorCmp2 = this.rollovercbcolor;
        if (colorCmp2 == null) {
            colorCmp2 = new ColorCmp();
        }
        Object var7_7 = null;
        int n4 = -1;
        if (colorCmp != null && colorCmp.isBackgroundSet()) {
            n3 = colorCmp.getBackground();
            if (ColorCmp.isRGB(n3)) {
                colorCmp2.setBackRGB(n3);
            } else {
                colorCmp2.setBackground(n3);
            }
            n4 = ColorCmp.getRealColor(colorCmp2.getBackground(), colorCmp2.isBackIntensitySet());
            this.rolloverbackground = this.parent.getColor(n4);
            this.isrolloverbackgroundset = true;
        }
        if (colorCmp != null && colorCmp.isForegroundSet()) {
            n3 = colorCmp.getForeground();
            if (ColorCmp.isRGB(n3)) {
                colorCmp2.setForeRGB(n3);
            } else {
                colorCmp2.setForeground(n3);
            }
            n4 = ColorCmp.getRealColor(colorCmp2.getForeground(), colorCmp2.isForeIntensitySet());
            this.rolloverforeground = this.parent.getColor(n4);
            this.isrolloverforegroundset = true;
        }
        this.rollovercbcolor = colorCmp2;
    }

    public void setCBBorderColor(Color color, int n2, boolean bl) {
        if (n2 < 0 || bl) {
            this.bordercolorrgb = n2;
        } else {
            this.bordercolor = n2;
        }
        if (color != null) {
            this.cbhasborder = true;
        }
        this.cbbordercolor = color;
        this.repaint();
    }

    public int getCBBorderColor(boolean bl) {
        if (bl) {
            return this.bordercolorrgb;
        }
        return this.bordercolor;
    }

    public void setCBRolloverBorderColor(Color color, int n2, boolean bl) {
        if (n2 < 0 || bl) {
            this.rolloverbordercolorrgb = n2;
        } else {
            this.rolloverbordercolor = n2;
        }
        if (color != null) {
            this.cbhasrolloverborder = true;
        }
        this.rollovercbbordercolor = color;
        this.repaint();
    }

    public int getCBRolloverBorderColor(boolean bl) {
        if (bl) {
            return this.rolloverbordercolorrgb;
        }
        return this.rolloverbordercolor;
    }

    public void sendClose() {
        this.parent.sendClose(this);
    }

    public void sendmousePressed(MouseEvent mouseEvent) {
        if (this.parent.getMouseListener() != null) {
            this.parent.getMouseListener().mousePressed(mouseEvent);
        }
    }

    public void setChipsRadius(int n2) {
        if (this.chipsradius != n2 && n2 >= 0 && n2 <= 100) {
            this.chipsradius = n2;
            this.radiusvalue = this.getRadiusValue(n2);
            this.validate();
            this.repaint();
            this.doLayout();
            this.validate();
        }
    }

    private int getRadiusValue(int n2) {
        Double d2 = new Double(n2);
        Double d3 = new Double(this.textheight + this.FOOHEIGHT);
        Double d4 = d2 / 100.0 * d3;
        return d4.intValue();
    }

    public void setHiddenData(Object object) {
        this.hiddendata = object;
    }

    public Object getHiddenData() {
        return this.hiddendata;
    }

    public void setMouseentered(boolean bl) {
        this.mouseentered = bl;
    }
}

