/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.client.swing.EditableTextField;
import com.iscobol.gui.client.swing.FromToTransferHandler;
import com.iscobol.gui.client.swing.OutAcceptEvent;
import com.iscobol.gui.client.swing.OutAcceptListener;
import com.iscobol.gui.client.swing.OutDragListener;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.SwingWorker;
import com.iscobol.rts.Factory;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class ComboBox
extends JComboBox
implements EditableTextField {
    private static final long serialVersionUID = 1L;
    private static final int OK = 0;
    private static final int ABORT = 1;
    private static final int ENTER_KEY = 2;
    private static final int OK_KEY_PRESSED = 3;
    private static final Border NATIVE_BORDER = BorderFactory.createEmptyBorder(0, 2, 0, 0);
    protected String name;
    protected boolean iscontroleditor;
    private int upperLowerMethod;
    private boolean defaultShortcutsEnabled = true;
    private int maxText;
    private boolean upper;
    private boolean lower;
    private boolean fireActionEvent = true;
    protected OutAcceptListener oaListener;
    private boolean drawBorder = true;
    private JComponent editor;
    private ArrayList editorKeyListeners = new ArrayList();
    private LabelCellRenderer renderer = new LabelCellRenderer();
    private boolean isEditable;
    private Color disabledBackground;
    private Color disabledForeground;
    private Color background;
    private Color foreground;
    private boolean f4DropsCombo = true;
    private JList popupList;
    private boolean documentListenerEnabled = true;
    private boolean textChanged;
    private long time;
    private StringBuffer prefix = new StringBuffer();
    private boolean bufferSelectionKeys;
    private final Long timeFactor = (Long)UIManager.get("ComboBox.timeFactor");
    private boolean isNative;
    private Color selBG;
    private Color selFG;
    private Color noSelBG;
    private Color noSelFG;
    private final UndoManager undoManager = new UndoManager();
    private char[] acceptedControlChars;
    private boolean checkItemIdentity;
    private FromToTransferHandler ftth = null;
    private String inputFilter;

    public ComboBox(boolean bl, boolean bl2) {
        this.isNative = bl;
        this.bufferSelectionKeys = bl2;
        JTextField jTextField = new JTextField();
        this.selBG = jTextField.getSelectionColor();
        this.selFG = jTextField.getSelectedTextColor();
        this.noSelBG = jTextField.getBackground();
        this.noSelFG = jTextField.getForeground();
        super.setRenderer(this.renderer);
        super.setEditable(!bl);
        if (this.name != null) {
            this.setName(this.name);
        }
        if (this.bufferSelectionKeys) {
            this.setKeySelectionManager(new JComboBox.KeySelectionManager(){

                public int selectionForKey(char c2, ComboBoxModel comboBoxModel) {
                    int n2;
                    if (ComboBox.this.prefix.length() > 0) {
                        JList jList = ComboBox.this.popupList != null && ComboBox.this.isPopupVisible() ? ComboBox.this.popupList : new JList(comboBoxModel);
                        n2 = jList.getNextMatch(ComboBox.this.prefix.toString(), 0, Position.Bias.Forward);
                    } else {
                        n2 = -1;
                    }
                    return n2;
                }
            });
        }
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                if (ComboBox.this.isEditable) {
                    ComboBox.this.selectAll();
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        if (ComboBox.isWindowsLaf()) {
            try {
                this.setUI((ComboBoxUI)Class.forName("com.iscobol.gui.client.swing.IscobolWindowsComboBoxUI").newInstance());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public boolean isNative() {
        return this.isNative;
    }

    public void addItem(Object object) {
        this.documentListenerEnabled = false;
        super.addItem(new Item(object.toString()));
        this.documentListenerEnabled = true;
    }

    public void insertItemAt(Object object, int n2) {
        this.documentListenerEnabled = false;
        super.insertItemAt(new Item(object.toString()), n2);
        this.documentListenerEnabled = true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    private int intProcessEvent(AWTEvent aWTEvent) {
        int n2 = 1;
        block0 : switch (aWTEvent.getID()) {
            case 401: {
                KeyEvent keyEvent = (KeyEvent)aWTEvent;
                switch (keyEvent.getKeyCode()) {
                    case 38: 
                    case 40: {
                        if (keyEvent.isAltDown()) {
                            n2 = 3;
                            break;
                        }
                        int n3 = this.getSelectedIndex();
                        if (this.textChanged) {
                            int n4 = this.itemToIndex(this.getText());
                            if (n3 >= 0 && n3 == n4) {
                                this.select(-1);
                            }
                            this.setSelectedIndex(n4);
                            this.textChanged = false;
                            break;
                        }
                        if (keyEvent.getKeyCode() == 38) {
                            if (n3 <= 0) break block0;
                            this.setSelectedIndex(n3 - 1);
                            break;
                        }
                        if (n3 >= this.getItemCount() - 1) break block0;
                        this.setSelectedIndex(n3 + 1);
                        break;
                    }
                    case 10: {
                        int n5;
                        n2 = 2;
                        if (!this.isPopupVisible() || this.popupList == null || (n5 = this.popupList.getSelectedIndex()) < 0) break block0;
                        this.setSelectedIndex(n5);
                        break;
                    }
                    case 115: {
                        if (this.isF4DropsCombo()) {
                            n2 = 3;
                            break;
                        }
                        ListIterator listIterator = this.editorKeyListeners.listIterator();
                        while (listIterator.hasNext()) {
                            KeyListener keyListener = (KeyListener)listIterator.next();
                            keyListener.keyPressed((KeyEvent)aWTEvent);
                        }
                        break block0;
                    }
                    default: {
                        if (this.bufferSelectionKeys) {
                            if (ComboBox.isPrintableChar(keyEvent.getKeyChar())) {
                                long l2;
                                long l3 = keyEvent.getWhen();
                                long l4 = l2 = this.timeFactor != null ? this.timeFactor : 1000L;
                                if (this.time > 0L && l3 - this.time >= l2) {
                                    this.prefix = new StringBuffer();
                                }
                                this.time = l3;
                                this.prefix.append(keyEvent.getKeyChar());
                            } else {
                                this.time = 0L;
                                this.prefix = new StringBuffer();
                            }
                        }
                        n2 = 3;
                        break;
                    }
                }
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    @Override
    public void setEditable(boolean bl) {
        this.isEditable = bl;
        if (this.isNative && this.isEditable) {
            super.setEditable(true);
        }
        this.editor = this.isEditable ? new EditableComboBoxEditor() : (!this.isNative ? new UneditableComboBoxEditor() : null);
        if (this.editor != null) {
            super.setEditor((ComboBoxEditor)((Object)this.editor));
            this.editor.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 115 && !ComboBox.this.iscontroleditor) {
                        final boolean bl = !ComboBox.this.isPopupVisible();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ComboBox.this.setPopupVisible(bl);
                            }
                        });
                    }
                }
            });
        }
    }

    @Override
    protected void processEvent(AWTEvent aWTEvent) {
        if (this.getOutAcceptListener() != null && this.getOutAcceptListener().bufferedOutAcceptEvent(new OutAcceptEvent(aWTEvent))) {
            return;
        }
        if (this.editor == null && this.isNative) {
            switch (this.intProcessEvent(aWTEvent)) {
                case 0: 
                case 3: {
                    super.processEvent(aWTEvent);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    this.fireActionEvent = false;
                    super.processEvent(aWTEvent);
                    this.fireActionEvent = true;
                }
            }
        } else {
            super.processEvent(aWTEvent);
        }
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        if (this.editor == null) {
            super.addKeyListener(keyListener);
            if (this.isNative) {
                this.editorKeyListeners.add(keyListener);
            }
        } else {
            this.editor.addKeyListener(keyListener);
            this.editorKeyListeners.add(keyListener);
        }
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        if (this.editor == null) {
            super.removeKeyListener(keyListener);
            if (this.isNative) {
                this.editorKeyListeners.remove(keyListener);
            }
        } else {
            this.editor.removeKeyListener(keyListener);
            this.editorKeyListeners.remove(keyListener);
        }
    }

    @Override
    public void removeAllItems() {
        this.fireActionEvent = false;
        super.removeAllItems();
        this.fireActionEvent = true;
    }

    @Override
    public void removeItemAt(int n2) {
        if (this.getSelectedIndex() == -1 || this.getSelectedIndex() == n2) {
            this.fireActionEvent = false;
            super.removeItemAt(n2);
            this.fireActionEvent = true;
        } else {
            super.removeItemAt(n2);
        }
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
        if (this.editor == null) {
            super.addFocusListener(focusListener);
        } else {
            this.editor.addFocusListener(focusListener);
        }
    }

    @Override
    public void removeFocusListener(FocusListener focusListener) {
        if (this.editor == null) {
            super.removeFocusListener(focusListener);
        } else {
            this.editor.removeFocusListener(focusListener);
        }
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
        Component[] componentArray = this.getComponents();
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            componentArray[i2].addMouseListener(mouseListener);
        }
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        super.removeMouseListener(mouseListener);
        Component[] componentArray = this.getComponents();
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            componentArray[i2].removeMouseListener(mouseListener);
        }
    }

    protected Color background() {
        return this.background;
    }

    @Override
    public void setBackground(Color color) {
        this.background = color;
        this.intSetBackground(color);
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean bl) {
        this.drawBorder = bl;
        if (this.isEditable) {
            ((EditableComboBoxEditor)this.editor).setBorder();
        } else if (this.editor != null) {
            ((UneditableComboBoxEditor)this.editor).setBorder();
        }
    }

    private void intSetBackground(Color color) {
        if (this.editor != null) {
            this.editor.setBackground(color);
        }
        if (this.renderer != null) {
            this.renderer.setNoSelBG(color);
        }
        if (this.isNative && !this.isEditable) {
            super.setBackground(color);
        }
    }

    protected Color foreground() {
        return this.foreground;
    }

    @Override
    public void setForeground(Color color) {
        this.foreground = color;
        this.intSetForeground(color);
    }

    private void intSetForeground(Color color) {
        if (this.editor != null) {
            this.editor.setForeground(color);
        }
        if (this.renderer != null) {
            this.renderer.setNoSelFG(color);
        }
        if (this.isNative && !this.isEditable) {
            super.setForeground(color);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.editor != null) {
            this.editor.setFont(font);
        }
        if (this.renderer != null) {
            this.renderer.setFont(font);
        }
    }

    @Override
    protected void fireActionEvent() {
        if (this.fireActionEvent) {
            super.fireActionEvent();
        }
    }

    void select(int n2) {
        this.fireActionEvent = false;
        this.setSelectedIndex(n2);
        this.fireActionEvent = true;
    }

    @Override
    public int getSelectedIndex() {
        boolean bl = this.checkItemIdentity;
        this.checkItemIdentity = true;
        int n2 = super.getSelectedIndex();
        this.checkItemIdentity = bl;
        return n2;
    }

    @Override
    public void setSelectedIndex(int n2) {
        this.documentListenerEnabled = false;
        boolean bl = this.checkItemIdentity;
        this.checkItemIdentity = true;
        super.setSelectedIndex(n2);
        this.checkItemIdentity = bl;
        if (n2 < 0) {
            this.clearSelection();
            if (this.editor != null) {
                ((ComboBoxEditor)((Object)this.editor)).setItem(null);
            }
        }
        if (this.isNative) {
            this.repaint();
        }
        this.documentListenerEnabled = true;
    }

    int itemToIndex(String string) {
        int n2;
        int n3 = this.getItemCount();
        for (n2 = 0; n2 < n3; ++n2) {
            if (!this.getItemAt(n2).toString().equals(string)) continue;
            return n2;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (!this.getItemAt(n2).toString().equalsIgnoreCase(string)) continue;
            return n2;
        }
        string = string.toLowerCase();
        for (n2 = 0; n2 < n3; ++n2) {
            if (!this.getItemAt(n2).toString().toLowerCase().startsWith(string)) continue;
            return n2;
        }
        return -1;
    }

    public int setSelectedItem(String string) {
        this.documentListenerEnabled = false;
        int n2 = this.itemToIndex(string);
        if (n2 >= 0) {
            this.setSelectedIndex(n2);
        }
        this.documentListenerEnabled = true;
        return n2;
    }

    @Override
    public void selectAll() {
        if (this.editor != null) {
            this.documentListenerEnabled = false;
            ((ComboBoxEditor)((Object)this.editor)).selectAll();
            this.documentListenerEnabled = true;
        } else if (this.isNative) {
            super.setBackground(this.selBG);
            super.setForeground(this.selFG);
        }
    }

    public boolean isF4DropsCombo() {
        return this.f4DropsCombo;
    }

    public void setF4DropsCombo(boolean bl) {
        this.f4DropsCombo = bl;
    }

    public void clearSelection() {
        if (this.isEditable) {
            this.documentListenerEnabled = false;
            ((EditableComboBoxEditor)this.editor).select(0, 0);
            this.documentListenerEnabled = true;
        } else if (this.editor != null) {
            ((UneditableComboBoxEditor)this.editor).clearSelection();
        } else if (this.isNative) {
            Color color = this.getDisabledBackground();
            Color color2 = this.getDisabledForeground();
            super.setBackground(!this.isEnabled() && color != null ? color : this.background);
            super.setForeground(!this.isEnabled() && color2 != null ? color2 : this.foreground);
        }
    }

    public void setMaxText(int n2) {
        this.maxText = n2;
    }

    public void setCaretPosition(int n2) {
        if (this.isEditable) {
            ((EditableComboBoxEditor)this.editor).setCaretPosition(n2);
        }
    }

    public int getCaretPosition() {
        return this.isEditable ? ((EditableComboBoxEditor)this.editor).getCaretPosition() : -1;
    }

    @Override
    public String getText() {
        if (this.isEditable) {
            return ((EditableComboBoxEditor)this.editor).getText();
        }
        if (this.editor != null) {
            return ((UneditableComboBoxEditor)this.editor).label.getText();
        }
        int n2 = this.getSelectedIndex();
        if (n2 >= 0) {
            return this.getItemAt(n2).toString();
        }
        return "";
    }

    public void setText(String string) {
        if (this.isEditable) {
            this.documentListenerEnabled = false;
            ((EditableComboBoxEditor)this.editor).setText(string);
            this.documentListenerEnabled = true;
        }
    }

    public void setUpper(boolean bl) {
        this.upper = bl;
    }

    public void setLower(boolean bl) {
        this.lower = bl;
    }

    public void modifyItemAt(int n2, String string) {
        if (n2 >= 0 && n2 < this.getItemCount()) {
            Item item = (Item)this.getItemAt(n2);
            item.setText(string);
        }
    }

    public void modifyItemAt(int n2, Icon icon) {
        if (n2 >= 0 && n2 < this.getItemCount()) {
            Item item = (Item)this.getItemAt(n2);
            item.setIcon(icon);
            if (this.getSelectedIndex() == n2) {
                DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.getModel();
                defaultComboBoxModel.removeElement(item);
                defaultComboBoxModel.insertElementAt(item, n2);
                this.setSelectedIndex(n2);
            }
        }
    }

    public void modifyItemAt(int n2, String string, Icon icon) {
        if (n2 >= 0 && n2 < this.getItemCount()) {
            Item item = (Item)this.getItemAt(n2);
            item.setText(string);
            item.setIcon(icon);
        }
    }

    public void setHiddenDataAt(int n2, Object object) {
        Item item;
        if (n2 >= 0 && n2 < this.getItemCount() && (item = (Item)this.getItemAt(n2)) != null) {
            item.setHiddenData(object);
        }
    }

    public Object getHiddenDataAt(int n2) {
        Item item;
        Object object = null;
        if (n2 >= 0 && n2 < this.getItemCount() && (item = (Item)this.getItemAt(n2)) != null && item.getHiddenData() != null) {
            object = item.getHiddenData();
        }
        return object;
    }

    public void setColorAt(int n2, int n3, Color color, Color color2) {
        Item item;
        if (n2 >= 0 && n2 < this.getItemCount() && (item = (Item)this.getItemAt(n2)) != null) {
            item.setColor(n3);
            item.setBackground(color);
            item.setForeground(color2);
        }
    }

    public void setBackgroundColorAt(int n2, int n3, Color color) {
        Item item;
        if (n2 >= 0 && n2 < this.getItemCount() && (item = (Item)this.getItemAt(n2)) != null) {
            item.setBackgroundColor(n3);
            item.setBackground(color);
        }
    }

    public void setForegroundColorAt(int n2, int n3, Color color) {
        Item item;
        if (n2 >= 0 && n2 < this.getItemCount() && (item = (Item)this.getItemAt(n2)) != null) {
            item.setForegroundColor(n3);
            item.setForeground(color);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl && this.getItemCount() == 0) {
            this.revalidate();
            this.doLayout();
        }
    }

    public OutAcceptListener getOutAcceptListener() {
        return this.oaListener;
    }

    public boolean hasFocusEditor() {
        return this.editor != null && this.editor.hasFocus();
    }

    public Color getDisabledBackground() {
        return this.disabledBackground;
    }

    public void setDisabledBackground(Color color) {
        this.disabledBackground = color;
    }

    public Color getDisabledForeground() {
        return this.disabledForeground;
    }

    public void setDisabledForeground(Color color) {
        this.disabledForeground = color;
    }

    public void myshowPopup() {
        new SwingWorker(false){

            @Override
            public void launch() {
                ComboBox.this.setPopupVisible(true);
            }
        }.start();
    }

    private boolean hasBorder() {
        Insets insets;
        Border border;
        return this.isDrawBorder() && (border = this.getBorder()) != null && (insets = border.getBorderInsets(this)) != null && !insets.equals(new Insets(0, 0, 0, 0));
    }

    @Override
    public void setToolTipText(String string) {
        super.setToolTipText(string);
        if (this.editor != null) {
            this.editor.setToolTipText(string);
        }
    }

    private static boolean isPrintableChar(int n2) {
        return n2 >= 32 && n2 <= 126;
    }

    public void copyItems(ComboBox comboBox) {
        int n2 = comboBox.getItemCount();
        Item item = null;
        Item item2 = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            item2 = (Item)comboBox.getItemAt(i2);
            item = new Item(item2.getText(), item2.getIcon());
            super.addItem(item);
        }
    }

    @Override
    public void cut() {
        if (this.isEditable) {
            ((EditableComboBoxEditor)this.editor).cut();
        }
    }

    @Override
    public void copy() {
        if (this.isEditable) {
            ((EditableComboBoxEditor)this.editor).copy();
        }
    }

    @Override
    public void paste() {
        if (this.isEditable) {
            Clipboard clipboard = this.getToolkit().getSystemClipboard();
            Transferable transferable = clipboard.getContents(this);
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                EditableComboBoxEditor editableComboBoxEditor = (EditableComboBoxEditor)this.editor;
                if (this.hasSelection()) {
                    editableComboBoxEditor.replaceSelection(string);
                } else {
                    editableComboBoxEditor.getDocument().insertString(editableComboBoxEditor.getCaretPosition(), string, null);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void replaceSelection(String string) {
        if (this.isEditable) {
            ((EditableComboBoxEditor)this.editor).replaceSelection(string);
        }
    }

    @Override
    public boolean hasSelection() {
        if (this.isEditable) {
            EditableComboBoxEditor editableComboBoxEditor = (EditableComboBoxEditor)this.editor;
            return editableComboBoxEditor.getSelectionStart() != editableComboBoxEditor.getSelectionEnd();
        }
        return false;
    }

    @Override
    public void undo() {
        if (this.isEditable && this.undoManager.canUndo()) {
            try {
                this.undoManager.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                System.err.println(cannotUndoException);
            }
        }
    }

    @Override
    public void redo() {
        if (this.isEditable && this.undoManager.canRedo()) {
            try {
                this.undoManager.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                System.err.println(cannotRedoException);
            }
        }
    }

    @Override
    public boolean canUndo() {
        return this.isEditable && this.undoManager.canUndo();
    }

    @Override
    public boolean canRedo() {
        return this.isEditable && this.undoManager.canRedo();
    }

    void setPlaceholder(String string) {
        if (this.editor != null && this.editor instanceof EditableComboBoxEditor) {
            ((EditableComboBoxEditor)this.editor).placeholder = string;
            this.repaint();
        }
    }

    void setPlaceholderColor(Color color) {
        if (this.editor != null && this.editor instanceof EditableComboBoxEditor) {
            ((EditableComboBoxEditor)this.editor).placeholderColor = color;
            this.repaint();
        }
    }

    @Override
    public void setName(String string) {
        this.name = string;
        if (this.editor != null) {
            this.editor.setName(this.name);
        } else {
            super.setName(this.name);
        }
    }

    public void setControlEditor(boolean bl) {
        this.iscontroleditor = bl;
    }

    public int getUpperLowerMethod() {
        return this.upperLowerMethod;
    }

    public void setUpperLowerMethod(int n2) {
        this.upperLowerMethod = n2;
    }

    public boolean isDefaultShortcutsEnabled() {
        return this.defaultShortcutsEnabled;
    }

    public void setDefaultShortcutsEnabled(boolean bl) {
        this.defaultShortcutsEnabled = bl;
    }

    protected void setAcceptedControlCharacters(String string) {
        this.acceptedControlChars = string != null ? string.toCharArray() : null;
    }

    public void setSelectionBackground(Color color) {
        this.renderer.setSelBG(color);
    }

    public Color getSelectionBackground() {
        return this.renderer.rendererSelBackground;
    }

    public void setSelectionForeground(Color color) {
        this.renderer.setSelFG(color);
    }

    public Color getSelectionForeground() {
        return this.renderer.rendererSelForeground;
    }

    private static boolean isWindowsLaf() {
        return "com.sun.java.swing.plaf.windows.WindowsLookAndFeel".equals(UIManager.getLookAndFeel().getClass().getName());
    }

    public JComponent getDragDropComponent() {
        return this.editor;
    }

    public void setDragComponent(OutDragListener outDragListener) {
        if (this.isEditable && this.editor != null) {
            if (outDragListener != null) {
                ((EditableComboBoxEditor)this.editor).setDropMode(DropMode.INSERT);
                ((EditableComboBoxEditor)this.editor).setDragEnabled(true);
                this.ftth = new FromToTransferHandler(outDragListener, 1);
                ((EditableComboBoxEditor)this.editor).setTransferHandler(this.ftth);
            } else {
                ((EditableComboBoxEditor)this.editor).setDragEnabled(false);
                if (this.ftth != null) {
                    ((EditableComboBoxEditor)this.editor).setTransferHandler(null);
                }
            }
        }
    }

    public void setInputFilter(String string) {
        if (this.inputFilter == null || !this.inputFilter.equals(string)) {
            this.inputFilter = string;
        }
    }

    public boolean hasInputFilter() {
        return this.inputFilter != null && this.inputFilter.length() > 0;
    }

    public boolean charInInputFilter(char c2) {
        boolean bl = false;
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(this.inputFilter);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return bl;
        }
        Matcher matcher = pattern.matcher("");
        matcher.reset(String.valueOf(c2));
        bl = matcher.find();
        return bl;
    }

    private String checkInInputFilter(String string) {
        String string2 = "";
        if (string != null && string.length() > 0 && this.hasInputFilter()) {
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                if (!this.charInInputFilter(c2)) continue;
                string2 = string2 + c2;
            }
        } else {
            string2 = string;
        }
        return string2;
    }

    private class Item {
        String text;
        Icon icon;
        Object hiddendata;
        private int color;
        private int backgroundColor;
        private int foregroundColor;
        private Color foreground;
        private Color background;

        Item(String string) {
            this.text = string;
        }

        Item(String string, Icon icon) {
            this.text = string;
            this.icon = icon;
        }

        public String toString() {
            return this.text;
        }

        public void setText(String string) {
            this.text = string;
        }

        public void setHiddenData(Object object) {
            this.hiddendata = object;
        }

        public Object getHiddenData() {
            return this.hiddendata;
        }

        public String getText() {
            return this.text;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public boolean equals(Object object) {
            if (ComboBox.this.checkItemIdentity) {
                return object == this;
            }
            if (!(object instanceof Item)) {
                return false;
            }
            Item item = (Item)object;
            boolean bl = true;
            bl = this.text != null ? (item.text != null ? (bl &= this.text.equals(item.text)) : false) : (bl &= item.text == null);
            bl = this.icon != null ? (item.icon != null ? (bl &= this.icon.equals(item.icon)) : false) : (bl &= item.icon == null);
            return bl;
        }

        public Color getForeground() {
            return this.foreground;
        }

        public Color getBackground() {
            return this.background;
        }

        public void setColor(int n2) {
            this.color = n2;
        }

        public void setBackgroundColor(int n2) {
            this.backgroundColor = n2;
        }

        public void setForegroundColor(int n2) {
            this.foregroundColor = n2;
        }

        public void setForeground(Color color) {
            this.foreground = color;
        }

        public void setBackground(Color color) {
            this.background = color;
        }
    }

    private class LabelCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;
        private Color rendererBackground;
        private Color rendererForeground;
        private Color rendererSelBackground;
        private Color rendererSelForeground;
        private Item currItem;

        public LabelCellRenderer() {
            this.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 0));
        }

        void setNoSelBG(Color color) {
            this.rendererBackground = color;
        }

        void setNoSelFG(Color color) {
            this.rendererForeground = color;
        }

        void setSelBG(Color color) {
            this.rendererSelBackground = color;
        }

        void setSelFG(Color color) {
            this.rendererSelForeground = color;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
            ComboBox.this.popupList = jList;
            this.setOpaque(true);
            if (object != null) {
                this.currItem = (Item)object;
                String string = this.currItem.getText();
                string = ComboBox.this.checkInInputFilter(string);
                if (ComboBox.this.upper) {
                    string = Factory.toUpperCase(string, ComboBox.this.upperLowerMethod);
                } else if (ComboBox.this.lower) {
                    string = Factory.toLowerCase(string, ComboBox.this.upperLowerMethod);
                }
                this.setText(string);
                this.setIcon(this.currItem.getIcon());
                if (bl) {
                    this.setBackground(this.rendererSelBackground != null ? this.rendererSelBackground : jList.getSelectionBackground());
                    this.setForeground(this.rendererSelForeground != null ? this.rendererSelForeground : jList.getSelectionForeground());
                } else {
                    this.setBackground(this.currItem.getBackground() != null ? this.currItem.getBackground() : this.rendererBackground);
                    this.setForeground(this.currItem.getForeground() != null ? this.currItem.getForeground() : this.rendererForeground);
                }
            } else {
                this.setText("");
                this.setIcon(null);
            }
            return this;
        }

        @Override
        public void setBounds(int n2, int n3, int n4, int n5) {
            String string;
            if (n4 > 0 && ComboBox.this.editor == null && ComboBox.this.isNative && this.currItem != null && !(string = this.getText()).toLowerCase().startsWith("<html>")) {
                int n6 = string.length();
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                int n7 = fontMetrics.stringWidth(string);
                int n8 = this.currItem.getIcon() != null ? this.currItem.getIcon().getIconWidth() : 0;
                n8 += this.getIconTextGap();
                int n9 = n7 + (n8 += this.getInsets().left + this.getInsets().right);
                while (n9 >= n4 && string.length() > 1) {
                    string = string.substring(0, string.length() - 1);
                    n7 = fontMetrics.stringWidth(string);
                    n9 = n7 + n8;
                }
                if (string.length() < n6) {
                    this.setText(string);
                }
            }
            super.setBounds(n2, n3, n4, n5);
        }
    }

    private class UneditableComboBoxEditor
    extends JPanel
    implements ComboBoxEditor {
        private static final long serialVersionUID = 1L;
        private Object origItem;
        JLabel label;
        private FontMetrics fm;

        public UneditableComboBoxEditor() {
            this.setLayout(null);
            this.label = new JLabel(){

                @Override
                public Color getBackground() {
                    if (ComboBox.this.isEnabled() || ComboBox.this.disabledBackground == null) {
                        return super.getBackground();
                    }
                    return ComboBox.this.disabledBackground;
                }

                @Override
                public Color getForeground() {
                    if (ComboBox.this.isEnabled() || ComboBox.this.disabledForeground == null) {
                        return super.getForeground();
                    }
                    return ComboBox.this.disabledForeground;
                }

                @Override
                public boolean isEnabled() {
                    return ComboBox.this.isEnabled() || ComboBox.this.disabledForeground != null;
                }
            };
            this.label.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (ComboBox.this.isEnabled()) {
                        UneditableComboBoxEditor.this.showPopup();
                        UneditableComboBoxEditor.this.requestFocusInWindow();
                    }
                }
            });
            this.label.setOpaque(true);
            this.setBorder();
            this.add(this.label);
        }

        @Override
        public void setToolTipText(String string) {
            super.setToolTipText(string);
            if (this.label != null) {
                this.label.setToolTipText(string);
            }
        }

        private void setBorder() {
            if (!ComboBox.this.hasBorder()) {
                this.label.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 0, Color.lightGray));
            }
        }

        @Override
        public void addMouseListener(MouseListener mouseListener) {
            if (this.label != null) {
                this.label.addMouseListener(mouseListener);
            } else {
                super.addMouseListener(mouseListener);
            }
        }

        @Override
        public void removeMouseListener(MouseListener mouseListener) {
            if (this.label != null) {
                this.label.removeMouseListener(mouseListener);
            } else {
                super.removeMouseListener(mouseListener);
            }
        }

        private void showPopup() {
            if (this.label.isEnabled()) {
                ComboBox.this.setPopupVisible(!ComboBox.this.isPopupVisible());
            }
        }

        @Override
        public void setFont(Font font) {
            super.setFont(font);
            if (this.label != null) {
                this.label.setFont(font);
            }
            this.fm = this.getFontMetrics(font);
        }

        @Override
        public void setBounds(int n2, int n3, int n4, int n5) {
            super.setBounds(n2, n3, n4, n5);
            this.label.setSize(this.getPreferredWidth(n4), n5);
        }

        @Override
        protected void processEvent(AWTEvent aWTEvent) {
            if (ComboBox.this.getOutAcceptListener() != null && ComboBox.this.getOutAcceptListener().bufferedOutAcceptEvent(new OutAcceptEvent(aWTEvent))) {
                return;
            }
            switch (ComboBox.this.intProcessEvent(aWTEvent)) {
                case 3: {
                    super.processEvent(aWTEvent);
                    aWTEvent.setSource(ComboBox.this);
                    ComboBox.this.processEvent(aWTEvent);
                    break;
                }
                case 0: {
                    super.processEvent(aWTEvent);
                    break;
                }
                case 128: {
                    break;
                }
                case 2: {
                    ComboBox.this.fireActionEvent = false;
                    super.processEvent(aWTEvent);
                    ComboBox.this.fireActionEvent = true;
                }
            }
        }

        @Override
        public Component getEditorComponent() {
            return this;
        }

        @Override
        public Object getItem() {
            return this.origItem;
        }

        @Override
        public void setItem(Object object) {
            if (object != null) {
                Item item = (Item)object;
                String string = item.getText();
                if (string == null) {
                    string = "";
                }
                if (!string.equals(this.label.getText())) {
                    string = ComboBox.this.checkInInputFilter(string);
                    if (ComboBox.this.upper) {
                        string = Factory.toUpperCase(string, ComboBox.this.upperLowerMethod);
                    } else if (ComboBox.this.lower) {
                        string = Factory.toLowerCase(string, ComboBox.this.upperLowerMethod);
                    }
                    this.label.setText(string);
                    this.label.setIcon(item.getIcon());
                    this.origItem = new Item(item.text, item.icon);
                }
            } else {
                this.label.setText("");
                this.origItem = null;
            }
        }

        private int getPreferredWidth(int n2) {
            if (ComboBox.this.getSelectedIndex() == -1) {
                return n2;
            }
            int n3 = 0;
            n3 += this.fm.stringWidth(this.label.getText()) + 10;
            if (this.label.getIcon() != null) {
                n3 += this.label.getIcon().getIconWidth();
                n3 += this.label.getIconTextGap();
            }
            return Math.max(n2, n3);
        }

        @Override
        public void addActionListener(ActionListener actionListener) {
        }

        @Override
        public void removeActionListener(ActionListener actionListener) {
        }

        @Override
        public Color getBackground() {
            if (ComboBox.this.noSelBG != null) {
                return ComboBox.this.noSelBG;
            }
            return super.getBackground();
        }

        @Override
        public void setBackground(Color color) {
            if (this.label != null) {
                this.label.setBackground(color);
            } else {
                super.setBackground(color);
            }
            ComboBox.this.noSelBG = color;
        }

        @Override
        public void setForeground(Color color) {
            if (this.label != null) {
                this.label.setForeground(color);
            } else {
                super.setForeground(color);
            }
            ComboBox.this.noSelFG = color;
        }

        @Override
        public Color getForeground() {
            if (ComboBox.this.noSelFG != null) {
                return ComboBox.this.noSelFG;
            }
            return super.getForeground();
        }

        @Override
        public void selectAll() {
            if (this.label != null) {
                if (ComboBox.this.selBG != null) {
                    this.label.setBackground(ComboBox.this.selBG);
                }
                if (ComboBox.this.selFG != null) {
                    this.label.setForeground(ComboBox.this.selFG);
                }
            }
        }

        public void clearSelection() {
            this.label.setBackground(ComboBox.this.noSelBG);
            this.label.setForeground(ComboBox.this.noSelFG);
        }
    }

    private class EditableComboBoxEditor
    extends JTextField
    implements ComboBoxEditor {
        private static final long serialVersionUID = 1L;
        private Object origItem;
        private String placeholder;
        private Color placeholderColor;
        private final UndoableEditListener undoEditListener = new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                ComboBox.this.undoManager.addEdit(undoableEditEvent.getEdit());
            }
        };
        private final KeyListener undoKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 90 && keyEvent.isControlDown()) {
                    ComboBox.this.undo();
                }
                if (keyEvent.getKeyCode() == 89 && keyEvent.isControlDown()) {
                    ComboBox.this.redo();
                }
            }
        };

        public EditableComboBoxEditor() {
            this.setDocument(new PlainDocument(){
                private static final long serialVersionUID = 1L;

                @Override
                public void insertString(int n2, String string, AttributeSet attributeSet) throws BadLocationException {
                    EditableComboBoxEditor editableComboBoxEditor = EditableComboBoxEditor.this;
                    if (ComboBox.this.maxText == 0 || editableComboBoxEditor.getDocument().getLength() < ComboBox.this.maxText) {
                        string = ComboBox.this.checkInInputFilter(string);
                        if (ComboBox.this.upper) {
                            string = Factory.toUpperCase(string, ComboBox.this.upperLowerMethod);
                        } else if (ComboBox.this.lower) {
                            string = Factory.toLowerCase(string, ComboBox.this.upperLowerMethod);
                        }
                        super.insertString(n2, string, attributeSet);
                    }
                }
            });
            this.getDocument().addDocumentListener(new DocumentListener(){

                private void handleDocumentEvent() {
                    ComboBox.this.textChanged = true;
                    if (ComboBox.this.popupList == null || !ComboBox.this.isPopupVisible()) {
                        return;
                    }
                    String string = EditableComboBoxEditor.this.getText().toLowerCase();
                    ComboBox comboBox = ComboBox.this;
                    int n2 = comboBox.getItemCount();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        Item item = (Item)ComboBox.this.getItemAt(i2);
                        if (!item.text.toLowerCase().startsWith(string)) continue;
                        int n3 = ComboBox.this.popupList.getFirstVisibleIndex();
                        if (i2 != n3) {
                            int n4 = i2 < n3 ? i2 : Math.min(n2, i2 + ComboBox.this.getMaximumRowCount()) - 1;
                            ComboBox.this.popupList.ensureIndexIsVisible(n4);
                        }
                        return;
                    }
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    if (ComboBox.this.documentListenerEnabled) {
                        this.handleDocumentEvent();
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    if (ComboBox.this.documentListenerEnabled) {
                        this.handleDocumentEvent();
                    }
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                }
            });
            this.getDocument().addUndoableEditListener(this.undoEditListener);
            this.addKeyListener(this.undoKeyListener);
            this.setBorder();
            if (!ComboBox.this.defaultShortcutsEnabled) {
                RemoteBaseGUIControl.disableDefaultShortcuts(this.getKeymap());
            }
        }

        @Override
        public Color getBackground() {
            if (ComboBox.this.isEnabled() || ComboBox.this.disabledBackground == null) {
                return super.getBackground();
            }
            return ComboBox.this.disabledBackground;
        }

        @Override
        public Color getForeground() {
            if (ComboBox.this.isEnabled() || ComboBox.this.disabledForeground == null) {
                return super.getForeground();
            }
            return ComboBox.this.disabledForeground;
        }

        @Override
        public Color getDisabledTextColor() {
            return ComboBox.this.disabledForeground != null ? ComboBox.this.disabledForeground : super.getDisabledTextColor();
        }

        private void setBorder() {
            if (ComboBox.this.isNative) {
                this.setBorder(NATIVE_BORDER);
            } else if (ComboBox.this.hasBorder()) {
                this.setBorder(null);
            }
        }

        @Override
        protected void processEvent(AWTEvent aWTEvent) {
            if (ComboBox.this.getOutAcceptListener() != null && ComboBox.this.getOutAcceptListener().bufferedOutAcceptEvent(new OutAcceptEvent(aWTEvent))) {
                return;
            }
            switch (ComboBox.this.intProcessEvent(aWTEvent)) {
                case 0: 
                case 3: {
                    if (aWTEvent.getID() == 400) {
                        RemoteBaseGUIControl.checkControlCharacter((KeyEvent)aWTEvent, ComboBox.this.acceptedControlChars, this);
                    }
                    super.processEvent(aWTEvent);
                    break;
                }
                case 128: {
                    break;
                }
                case 2: {
                    ComboBox.this.fireActionEvent = false;
                    super.processEvent(aWTEvent);
                    ComboBox.this.fireActionEvent = true;
                }
            }
        }

        @Override
        public Component getEditorComponent() {
            return this;
        }

        @Override
        public Object getItem() {
            return this.origItem;
        }

        @Override
        public void setItem(Object object) {
            this.getDocument().removeUndoableEditListener(this.undoEditListener);
            if (object != null) {
                Item item = (Item)object;
                String string = item.text;
                if (string == null) {
                    string = "";
                }
                if (!string.equals(this.getText())) {
                    int n2 = ComboBox.this.maxText;
                    ComboBox.this.maxText = 0;
                    this.setText(item.toString());
                    ComboBox.this.maxText = n2;
                    this.origItem = new Item(item.text, item.icon);
                }
            } else {
                this.setText("");
                this.origItem = null;
            }
            this.getDocument().addUndoableEditListener(this.undoEditListener);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.placeholder == null || this.placeholder.length() == 0 || this.getText().length() > 0) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(this.placeholderColor != null ? this.placeholderColor : this.getDisabledTextColor());
            graphics2D.drawString(this.placeholder, this.getInsets().left, graphics.getFontMetrics().getMaxAscent() + this.getInsets().top);
        }
    }
}

