/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.PicobolWidget;
import com.iscobol.gui.client.swing.MultilineLabel;
import com.iscobol.gui.client.swing.PicobolLabel;
import com.iscobol.gui.client.swing.PicobolMultilineLabel;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import java.awt.AWTEvent;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleKeyBinding;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleText;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class CompositeLabel
extends JComponent
implements PicobolWidget,
Accessible {
    private PicobolMultilineLabel mylabel;
    private PicobolLabel label;
    private CardLayout layout;
    private PicobolWidget shownLabel;
    private boolean vertical;
    private String text;
    private boolean noKeyLetter;
    private boolean left;
    private boolean right;
    private boolean center;
    private final boolean alwaysShowPicobolLabel;
    private final Color disabledTextColor;
    private boolean enabled = true;
    private Color foreground;

    public CompositeLabel(boolean bl) {
        this.alwaysShowPicobolLabel = bl;
        Color color = UIManager.getColor("Label.disabledForeground");
        if (color == null) {
            color = UIManager.getColor("Label.disabledText");
        }
        this.disabledTextColor = color;
        this.layout = new CardLayout(0, 0);
        this.label = new PicobolLabel();
        if (this.alwaysShowPicobolLabel) {
            this.label.setMultiline(true);
        }
        this.mylabel = new PicobolMultilineLabel();
        this.foreground = this.label.getForeground();
        this.setLayout(this.layout);
        this.add((Component)this.mylabel, "mylabel");
        this.add((Component)this.label, "label");
        if (this.alwaysShowPicobolLabel) {
            this.showPicobolLabel();
        } else {
            this.showMultilineLabel();
        }
    }

    public void showPicobolLabel() {
        this.layout.show(this, "label");
        this.shownLabel = this.label;
    }

    public void showMultilineLabel() {
        this.layout.show(this, "mylabel");
        this.shownLabel = this.mylabel;
    }

    private boolean shouldShowPicobolLabel() {
        return this.alwaysShowPicobolLabel || this.vertical || this.text != null && RemoteBaseGUIControl.isHtml(this.text);
    }

    public void setVertical(boolean bl) {
        boolean bl2 = this.shouldShowPicobolLabel();
        this.vertical = bl;
        this.updateShownLabel(bl2);
        this.label.setVertical(bl);
    }

    private void updateShownLabel(boolean bl) {
        if (bl != this.shouldShowPicobolLabel()) {
            if (bl) {
                this.showMultilineLabel();
            } else {
                this.showPicobolLabel();
            }
        }
    }

    public void setTop(boolean bl) {
        boolean bl2 = this.shouldShowPicobolLabel();
        this.vertical = bl;
        this.updateShownLabel(bl2);
        this.label.setTop(bl);
    }

    public void setBottom(boolean bl) {
        boolean bl2 = this.shouldShowPicobolLabel();
        this.vertical = bl;
        this.updateShownLabel(bl2);
        this.label.setBottom(bl);
    }

    public void setCentered(boolean bl) {
        this.center = bl;
        this.label.setCentered(bl);
        this.mylabel.setTextAlignment(bl ? 0 : 2);
    }

    public void setLeft(boolean bl) {
        this.left = bl;
        this.label.setLeft(bl);
        this.mylabel.setTextAlignment(2);
    }

    public void setRight(boolean bl) {
        this.right = bl;
        this.label.setRight(bl);
        this.mylabel.setTextAlignment(bl ? 4 : 2);
    }

    public void setTransparent(boolean bl) {
        this.label.setTransparent(bl);
        this.mylabel.setTransparent(bl);
    }

    public void setTitle(String string) {
        boolean bl = this.shouldShowPicobolLabel();
        this.text = string;
        this.updateShownLabel(bl);
        if (string != null && (this.right || this.center || this.left)) {
            string = CompositeLabel.mytrim(string);
        }
        this.label.setTitle(string);
        this.mysetTitle(string);
    }

    private void mysetTitle(String string) {
        if (string == null) {
            string = "";
        }
        int n2 = -1;
        if (!this.noKeyLetter) {
            StringBuffer stringBuffer = new StringBuffer(string);
            n2 = ScreenUtility.getMnemonicIdx(stringBuffer);
            string = stringBuffer.toString();
        }
        this.mylabel.setText(string);
        this.mylabel.setMnemonicIndex(n2);
    }

    public void setNoKeyLetter(boolean bl) {
        this.noKeyLetter = bl;
        this.label.setNoKeyLetter(bl);
        String string = this.text;
        if (string != null && (this.right || this.center || this.left)) {
            string = CompositeLabel.mytrim(string);
        }
        this.mysetTitle(string);
    }

    private static String mytrim(String string) {
        int n2;
        int n3 = string.length();
        for (n2 = 0; n2 < n3 && string.charAt(n2) == ' '; ++n2) {
        }
        --n3;
        while (n3 > n2 && string.charAt(n3) == ' ') {
            --n3;
        }
        return string.substring(n2, n3 + 1);
    }

    public Icon getIcon() {
        return this.label.getIcon();
    }

    public PicobolLabel getPicobolLabel() {
        return this.label;
    }

    public MultilineLabel getMultilineLabel() {
        return this.mylabel;
    }

    @Override
    public void setActiveAccept(boolean bl) {
        this.shownLabel.setActiveAccept(bl);
    }

    @Override
    public boolean getActiveAccept() {
        return this.shownLabel.getActiveAccept();
    }

    @Override
    public void setSelfAct(boolean bl) {
    }

    @Override
    public boolean getSelfAct() {
        return false;
    }

    @Override
    public void asyncProcessEvent(AWTEvent aWTEvent) {
        this.shownLabel.asyncProcessEvent(aWTEvent);
    }

    public void setBorder(boolean bl) {
        super.setBorder(bl ? BorderFactory.createLineBorder(Color.black) : null);
        this.label.updateAlignment();
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.label != null) {
            if (bl != this.enabled) {
                this.enabled = bl;
                this.label.setEnabled(bl);
                this.mylabel.setEnabled(bl);
                if (bl) {
                    this.label.setForeground(this.foreground);
                    this.mylabel.setForeground(this.foreground);
                } else {
                    this.label.setForeground(this.disabledTextColor);
                    this.mylabel.setForeground(this.disabledTextColor);
                }
            }
        } else {
            super.setEnabled(bl);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.label != null) {
            this.label.setBackground(color);
            this.mylabel.setBackground(color);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.label != null) {
            this.foreground = color;
            if (this.enabled) {
                this.label.setForeground(color);
                this.mylabel.setForeground(color);
            }
        }
    }

    @Override
    public void setFont(Font font) {
        Font font2 = super.getFont();
        if (font2 != null && font != null && font2.getName() == font.getName() && font2.getStyle() == font.getStyle() && font2.getSize() == font.getSize()) {
            return;
        }
        super.setFont(font);
        if (this.label != null) {
            this.label.setFont(font);
            this.mylabel.setFont(font);
        }
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        if (this.label != null) {
            this.label.addMouseListener(mouseListener);
            this.mylabel.addMouseListener(mouseListener);
        } else {
            super.addMouseListener(mouseListener);
        }
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (this.label != null) {
            this.label.addMouseMotionListener(mouseMotionListener);
            this.mylabel.addMouseMotionListener(mouseMotionListener);
        } else {
            super.addMouseMotionListener(mouseMotionListener);
        }
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        if (this.label != null) {
            this.label.removeMouseListener(mouseListener);
            this.mylabel.removeMouseListener(mouseListener);
        } else {
            super.removeMouseListener(mouseListener);
        }
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (this.label != null) {
            this.label.removeMouseMotionListener(mouseMotionListener);
            this.mylabel.removeMouseMotionListener(mouseMotionListener);
        } else {
            super.removeMouseMotionListener(mouseMotionListener);
        }
    }

    @Override
    public void setToolTipText(String string) {
        if (this.label != null) {
            this.label.setToolTipText(string);
            this.mylabel.setToolTipText(string);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.shownLabel != null) {
            return this.shownLabel.getPreferredSize();
        }
        return super.getPreferredSize();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleCompositeLabel();
        }
        return this.accessibleContext;
    }

    private class AccessibleCompositeLabel
    extends JComponent.AccessibleJComponent {
        private AccessibleCompositeLabel() {
            super(CompositeLabel.this);
        }

        @Override
        public String getAccessibleName() {
            String string = this.accessibleName;
            if (string == null) {
                string = (String)CompositeLabel.this.getClientProperty("AccessibleName");
            }
            if (string == null) {
                string = CompositeLabel.this.text;
            }
            if (string == null) {
                string = super.getAccessibleName();
            }
            return string;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }

        @Override
        public AccessibleIcon[] getAccessibleIcon() {
            return null;
        }

        @Override
        public AccessibleText getAccessibleText() {
            return null;
        }

        @Override
        public String getToolTipText() {
            return CompositeLabel.this.label != null ? CompositeLabel.this.label.getToolTipText() : null;
        }

        @Override
        public String getTitledBorderText() {
            return null;
        }

        @Override
        public AccessibleKeyBinding getAccessibleKeyBinding() {
            return null;
        }
    }
}

