/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.IsguiUtility;
import com.iscobol.gui.client.swing.DateEntryChangeListener;
import com.iscobol.gui.client.swing.DateEntryEvent;
import com.iscobol.gui.client.swing.DateEntryListener;
import com.iscobol.gui.client.swing.DateEntryVetoException;
import com.iscobol.gui.client.swing.FromToTransferHandler;
import com.iscobol.gui.client.swing.OutAcceptEvent;
import com.iscobol.gui.client.swing.OutAcceptListener;
import com.iscobol.gui.client.swing.OutDragListener;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.toedter.calendar.IDateEditor;
import com.toedter.calendar.JCalendar;
import com.toedter.calendar.JDateChooser;
import com.toedter.calendar.JSpinnerDateEditor;
import com.toedter.calendar.JTextFieldDateEditor;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.border.Border;
import javax.swing.text.DateFormatter;
import javax.swing.text.InternationalFormatter;

public class DateEntry
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int SPINNER_STYLE = 0;
    public static final int TEXT_FIELD_STYLE = 1;
    private static final String SPINNER_DEFAULT_PATTERN = "d-MMM-yyyy";
    private static final String TEXT_FIELD_DEFAULT_PATTERN = "dd-MM-yyyy";
    private boolean allowEmpty;
    private int style = 0;
    private JCheckBox showNoneCheckBox;
    private JPanel showNonePanel;
    protected MyDateEntry dateEntry;
    protected DateEntryListener deListener;
    private String dateFormatString = "d-MMM-yyyy";
    private DateEntryChangeListener changeListener;
    protected Date oldDate;
    private Date illegalDate;
    private boolean showNone;
    protected OutAcceptListener oaListener;
    private boolean readOnly;
    private Calendar _2DigitsYearStartDate;
    private IDateEditor editor;
    private JFormattedTextField textFieldEditor;
    private KeyEventPostProcessor kepp;
    private String name;
    private Color disabledBackground;
    private Color disabledForeground;
    private KeyListener keyListener;
    private KeyListener keyListenerProxy;
    private ActionListener dayListener;
    private FromToTransferHandler ftth = null;
    private boolean defaultShortcutsEnabled = true;
    private FocusListener focusListener = new FocusListener(){

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (DateEntry.this.textFieldEditor.getCaret() != null) {
                DateEntry.this.textFieldEditor.getCaret().setVisible(false);
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (DateEntry.this.textFieldEditor.isEnabled() && DateEntry.this.textFieldEditor.getCaret() != null) {
                DateEntry.this.textFieldEditor.getCaret().setVisible(true);
            }
        }
    };

    public DateEntry(int n2, String string) {
        this.dateFormatString = string;
        this.showNonePanel = new JPanel(new GridLayout(1, 0));
        this.showNoneCheckBox = new JCheckBox();
        this.showNoneCheckBox.addActionListener(actionEvent -> {
            this.intSetShowNoneChecked(this.showNoneCheckBox.isSelected());
            if (this.changeListener != null) {
                this.changeListener.stateChanged(new DateEntryEvent(this));
            }
        });
        this.showNoneCheckBox.setFocusable(false);
        this.showNonePanel.add(this.showNoneCheckBox);
        this.showNonePanel.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 0, Color.darkGray));
        this.setLayout(new BorderLayout());
        this.keyListenerProxy = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (DateEntry.this.keyListener != null) {
                    DateEntry.this.keyListener.keyTyped(keyEvent);
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (DateEntry.this.keyListener != null) {
                    DateEntry.this.keyListener.keyReleased(keyEvent);
                }
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (DateEntry.this.keyListener != null) {
                    DateEntry.this.keyListener.keyPressed(keyEvent);
                }
            }
        };
        this.setStyle(n2);
        if (this.name != null && this.textFieldEditor != null) {
            this.textFieldEditor.setName(this.name);
        }
        this.add((Component)((Object)this.dateEntry), "Center");
        this.dateEntry.getCalendarButton().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Date date = DateEntry.this.getJCalendar().getDate();
                if (!(DateEntry.this.oldDate == null || date != null && date.equals(DateEntry.this.oldDate))) {
                    DateEntry.this.getJCalendar().setDate(DateEntry.this.oldDate);
                }
                if (DateEntry.this.getOutAcceptListener() != null && DateEntry.this.getOutAcceptListener().bufferedOutAcceptEvent(new OutAcceptEvent(mouseEvent))) {
                    return;
                }
                DateEntry.this.handleCalendarButtonMousePressed();
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                DateEntry.this.handleCalendarButtonMouseReleased(mouseEvent);
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                DateEntry.this.handleCalendarButtonMouseClicked(mouseEvent);
            }
        });
        this.dateEntry.addPropertyChangeListener("date", propertyChangeEvent -> {
            if (this.changeListener != null) {
                if (!this.showNoneCheckBox.isSelected()) {
                    this.showNoneCheckBox.setSelected(true);
                    this.intSetShowNoneChecked(true);
                }
                this.changeListener.stateChanged(new DateEntryEvent(this, (Date)propertyChangeEvent.getNewValue()));
            }
        });
        this.intSetAllowEmpty(false);
        if (this.textFieldEditor != null) {
            this.textFieldEditor.addKeyListener(this.keyListenerProxy);
        }
        this.showNoneCheckBox.addKeyListener(this.keyListenerProxy);
        this.kepp = keyEvent -> {
            if (keyEvent.getSource() == this.textFieldEditor && ((JComponent)this.editor).isEnabled() && keyEvent.getID() == 400 && keyEvent.getKeyChar() != '\uffff') {
                this.fireStateChanged();
            }
            return false;
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(this.kepp);
    }

    public Color getDisabledBackground() {
        return this.disabledBackground;
    }

    public void setDisabledBackground(Color color) {
        this.disabledBackground = color;
        this.textFieldEditor.repaint();
    }

    public Color getDisabledForeground() {
        return this.disabledForeground;
    }

    public void setDisabledForeground(Color color) {
        this.disabledForeground = color;
        if (this.disabledForeground != null && this.style == 1) {
            this.textFieldEditor.setDisabledTextColor(color);
        }
    }

    private boolean checkDateFormat(String string) {
        try {
            new SimpleDateFormat(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setStyle(int n2) {
        this.style = n2;
        switch (this.style) {
            default: {
                if (!this.checkDateFormat(this.dateFormatString)) {
                    this.dateFormatString = SPINNER_DEFAULT_PATTERN;
                }
                this.editor = new MyJSpinnerDateEditor();
                JSpinner.DateEditor dateEditor = new JSpinner.DateEditor((JSpinner)this.editor, this.dateFormatString);
                ((MyJSpinnerDateEditor)this.editor).setEditor(dateEditor);
                this.textFieldEditor = dateEditor.getTextField();
                ((MyJSpinnerDateEditor)this.editor).de = this;
                this.dateEntry = new MyDateEntry(this.editor);
                break;
            }
            case 1: {
                if (!this.checkDateFormat(this.dateFormatString)) {
                    this.dateFormatString = TEXT_FIELD_DEFAULT_PATTERN;
                }
                this.dateFormatString = this.dateFormatString.replaceAll("\\bd\\b", "dd").replaceAll("\\bM\\b", "MM");
                this.dateEntry = new MyDateEntry(this, this.dateFormatString, IsguiUtility.createMaskFromDatePattern(this.dateFormatString, '#', true), ' ');
                this.editor = this.dateEntry.getDateEditor();
                this.textFieldEditor = (JTextFieldDateEditor)this.editor;
            }
        }
    }

    public void dispose() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(this.kepp);
        this.dateEntry.cleanup();
    }

    private void fireStateChanged() {
        if (!this.showNoneCheckBox.isSelected()) {
            this.showNoneCheckBox.setSelected(true);
            this.intSetShowNoneChecked(true);
        }
        if (this.changeListener != null) {
            this.changeListener.stateChanged(new DateEntryEvent(this));
        }
    }

    public void setDateEntryListener(DateEntryListener dateEntryListener) {
        this.deListener = dateEntryListener;
    }

    public void addOutAcceptListener(OutAcceptListener outAcceptListener) {
        this.oaListener = outAcceptListener;
    }

    public OutAcceptListener getOutAcceptListener() {
        return this.oaListener;
    }

    public void setChangeListener(DateEntryChangeListener dateEntryChangeListener) {
        this.changeListener = dateEntryChangeListener;
    }

    protected JDateChooser getDateChooser() {
        return this.dateEntry;
    }

    public JCalendar getJCalendar() {
        return this.dateEntry.getJCalendar();
    }

    public void hidePopup() {
        this.dateEntry.getPopup().setVisible(false);
    }

    public void setRightAlignment(boolean bl) {
        if (bl) {
            this.textFieldEditor.setHorizontalAlignment(4);
        } else {
            this.textFieldEditor.setHorizontalAlignment(2);
        }
    }

    @Override
    public void setFont(Font font) {
        if (this.textFieldEditor != null) {
            this.textFieldEditor.setFont(font);
            this.showNoneCheckBox.setFont(font);
        } else {
            super.setFont(font);
        }
    }

    @Override
    public Font getFont() {
        if (this.textFieldEditor != null) {
            return this.textFieldEditor.getFont();
        }
        return super.getFont();
    }

    public Font getCalendarFont() {
        JCalendar jCalendar = this.getJCalendar();
        if (jCalendar != null) {
            return jCalendar.getFont();
        }
        return null;
    }

    public void setCalendarFont(Font font) {
        JCalendar jCalendar = this.getJCalendar();
        if (jCalendar != null) {
            jCalendar.setFont(font);
            int n2 = this.textFieldEditor.getFontMetrics(font).getHeight() + 8;
            Dimension dimension = jCalendar.getMonthChooser().getParent().getPreferredSize();
            dimension.height = n2;
            jCalendar.getMonthChooser().getParent().setPreferredSize(dimension);
        }
    }

    public void setDate(Date date) {
        DateEntryChangeListener dateEntryChangeListener = this.changeListener;
        if (this.allowEmpty && this.textFieldEditor.getText().length() == 0) {
            this.changeListener = null;
        }
        this.oldDate = date;
        this.dateEntry.setDate(date);
        if (date != null) {
            this.dateEntry.getJCalendar().setDate(date);
            if (this.allowEmpty && this.textFieldEditor.getText().length() == 0) {
                this.textFieldEditor.setValue(date);
            }
        }
        String string = this.dateEntry.getDateFormatString();
        if (date != null && string != null && string.length() > 0 && string.indexOf(121) == -1 && string.indexOf(89) == -1) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
            this.dateEntry.getJCalendar().getYearChooser().setYear(gregorianCalendar.get(1));
        }
        this.changeListener = dateEntryChangeListener;
    }

    String getText() {
        return this.textFieldEditor.getText();
    }

    public Date getDate() {
        try {
            Object object;
            JFormattedTextField.AbstractFormatter abstractFormatter;
            String string = this.textFieldEditor.getText();
            if (this.allowEmpty && (string.length() == 0 || this.dateEntry.emptyMaskPattern != null && string.equals(this.dateEntry.emptyMaskPattern))) {
                DateEntryChangeListener dateEntryChangeListener = this.changeListener;
                this.changeListener = null;
                this.dateEntry.setDate(null);
                this.changeListener = dateEntryChangeListener;
                this.oldDate = null;
                return this.oldDate;
            }
            if (this.textFieldEditor.getFormatter() != null) {
                abstractFormatter = this.textFieldEditor.getFormatter();
            } else {
                object = new SimpleDateFormat(this.dateFormatString);
                ((DateFormat)object).setLenient(false);
                abstractFormatter = new DateFormatter((DateFormat)object);
            }
            if (abstractFormatter instanceof DateFormatter && ((InternationalFormatter)(object = (DateFormatter)abstractFormatter)).getFormat() instanceof SimpleDateFormat) {
                SimpleDateFormat simpleDateFormat = (SimpleDateFormat)((InternationalFormatter)object).getFormat();
                if (!this.dateFormatString.equals(simpleDateFormat.toPattern())) {
                    simpleDateFormat = new SimpleDateFormat(this.dateFormatString);
                    simpleDateFormat.setLenient(false);
                    ((DateFormatter)object).setFormat(simpleDateFormat);
                }
                if (this._2DigitsYearStartDate != null) {
                    simpleDateFormat.set2DigitYearStart(this._2DigitsYearStartDate.getTime());
                }
            }
            try {
                this.oldDate = (Date)abstractFormatter.stringToValue(string);
            }
            catch (ParseException parseException) {
                if (this.illegalDate != null) {
                    this.oldDate = this.illegalDate;
                }
                throw parseException;
            }
            object = this.dateEntry.getDateFormatString();
            if (this.oldDate != null && object != null && ((String)object).length() > 0) {
                boolean bl = false;
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(this.oldDate);
                if (((String)object).indexOf(121) == -1 && ((String)object).indexOf(89) == -1) {
                    gregorianCalendar.set(1, this.dateEntry.getJCalendar().getYearChooser().getYear());
                    bl = true;
                }
                if (((String)object).indexOf(77) == -1) {
                    gregorianCalendar.set(2, this.dateEntry.getJCalendar().getMonthChooser().getMonth());
                    bl = true;
                }
                if (((String)object).indexOf(100) == -1) {
                    gregorianCalendar.set(5, this.dateEntry.getJCalendar().getDayChooser().getDay());
                    bl = true;
                }
                if (bl) {
                    return gregorianCalendar.getTime();
                }
                return this.oldDate;
            }
            return this.oldDate;
        }
        catch (Exception exception) {
            if (this.oldDate != null) {
                return this.oldDate;
            }
            return this.dateEntry.getDate();
        }
    }

    public void setMaxSelectableDate(Date date) {
        this.dateEntry.setMaxSelectableDate(date);
    }

    public void setMinSelectableDate(Date date) {
        this.dateEntry.setMinSelectableDate(date);
    }

    public JButton getCalendarButton() {
        return this.dateEntry.getCalendarButton();
    }

    public JCheckBox getShowNoneButton() {
        return this.showNoneCheckBox;
    }

    public void setDateFormatString(String string) {
        this.dateFormatString = string;
        this.dateEntry.setDateFormatString(string);
    }

    protected void fireActionPerformedEvent() {
        this.dateEntry.intActionPerformed();
    }

    public void showPopup() {
        int n2 = this.dateEntry.getCalendarButton().getWidth() - (int)this.dateEntry.getPopup().getPreferredSize().getWidth();
        int n3 = this.dateEntry.getCalendarButton().getY() + this.dateEntry.getCalendarButton().getHeight();
        this.dateEntry.getPopup().show(this.dateEntry.getCalendarButton(), n2, n3);
        this.dateEntry.setDateSelected(false);
    }

    public void setIcon(ImageIcon imageIcon) {
        this.dateEntry.setIcon(imageIcon);
    }

    public void selectAll() {
        if (this.textFieldEditor != null && (!this.isShowNone() || this.showNoneCheckBox.isSelected())) {
            this.textFieldEditor.selectAll();
        }
    }

    @Override
    public void requestFocus() {
        if (this.isShowNone() && !this.showNoneCheckBox.isSelected()) {
            this.showNoneCheckBox.requestFocus();
        } else if (this.textFieldEditor != null) {
            this.textFieldEditor.requestFocus();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.isShowNone() && !this.showNoneCheckBox.isSelected()) {
            return this.showNoneCheckBox.requestFocusInWindow();
        }
        if (this.textFieldEditor != null) {
            return this.textFieldEditor.requestFocusInWindow();
        }
        return false;
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        if (this.textFieldEditor != null) {
            this.textFieldEditor.addMouseListener(mouseListener);
        }
        if (this.editor != null) {
            Component[] componentArray = ((Container)this.editor).getComponents();
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                componentArray[i2].addMouseListener(mouseListener);
            }
        }
        if (this.showNoneCheckBox != null) {
            this.showNoneCheckBox.addMouseListener(mouseListener);
        }
        this.getCalendarButton().addMouseListener(mouseListener);
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        if (this.textFieldEditor != null) {
            this.textFieldEditor.removeMouseListener(mouseListener);
        }
        if (this.editor != null) {
            Component[] componentArray = ((Container)this.editor).getComponents();
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                componentArray[i2].removeMouseListener(mouseListener);
            }
        }
        if (this.showNoneCheckBox != null) {
            this.showNoneCheckBox.removeMouseListener(mouseListener);
        }
        this.getCalendarButton().removeMouseListener(mouseListener);
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        this.keyListener = AWTEventMulticaster.add(this.keyListener, keyListener);
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        this.keyListener = AWTEventMulticaster.remove(this.keyListener, keyListener);
    }

    @Override
    public void setBackground(Color color) {
        if (this.textFieldEditor != null) {
            this.textFieldEditor.setBackground(color);
            this.showNoneCheckBox.setBackground(color);
        } else {
            super.setBackground(color);
        }
    }

    @Override
    public void setForeground(Color color) {
        if (this.textFieldEditor != null) {
            this.textFieldEditor.setForeground(color);
            this.showNoneCheckBox.setForeground(color);
        } else {
            super.setForeground(color);
        }
    }

    @Override
    public void setToolTipText(String string) {
        if (this.editor != null) {
            ((JComponent)this.editor).setToolTipText(string);
        }
    }

    public void setShowNone(boolean bl) {
        if (this.showNone != bl) {
            this.showNone = bl;
            if (this.showNone) {
                this.add((Component)this.showNonePanel, "West");
            } else {
                this.remove(this.showNonePanel);
            }
        }
    }

    public boolean isShowNone() {
        return this.showNone;
    }

    public boolean isShowNoneChecked() {
        return !this.isShowNone() || this.showNoneCheckBox.isSelected();
    }

    public void setShowNoneChecked(boolean bl) {
        if (this.isShowNone()) {
            this.showNoneCheckBox.setSelected(bl);
            this.intSetShowNoneChecked(bl);
        }
    }

    private void intSetShowNoneChecked(boolean bl) {
        this.showNoneCheckBox.setFocusable(!bl);
        ((JComponent)this.editor).setEnabled(bl && this.dateEntry.isEnabled());
        boolean bl2 = false;
        for (KeyListener keyListener : this.showNoneCheckBox.getKeyListeners()) {
            if (keyListener != this.keyListenerProxy) continue;
            bl2 = true;
            break;
        }
        if (bl) {
            if (bl2) {
                this.showNoneCheckBox.removeKeyListener(this.keyListenerProxy);
            }
        } else if (!bl2) {
            this.showNoneCheckBox.addKeyListener(this.keyListenerProxy);
        }
        if (!bl && this.textFieldEditor.isFocusOwner()) {
            this.showNoneCheckBox.requestFocus();
        } else if (bl && this.showNoneCheckBox.isFocusOwner()) {
            this.textFieldEditor.requestFocus();
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.dateEntry != null) {
            this.dateEntry.setEnabled(bl);
        }
        if (this.showNoneCheckBox != null) {
            this.showNoneCheckBox.setEnabled(bl);
        }
        if (this.textFieldEditor != null) {
            this.textFieldEditor.setEnabled(bl);
            this.textFieldEditor.setFocusable(bl);
        }
        ((JComponent)this.editor).setEnabled(bl && (!this.isShowNone() || this.showNoneCheckBox.isSelected()));
    }

    protected void handleCalendarButtonMouseReleased(MouseEvent mouseEvent) {
    }

    protected void handleCalendarButtonMouseClicked(MouseEvent mouseEvent) {
    }

    protected void handleCalendarButtonMousePressed() {
        if (this.dateEntry.isEnabled()) {
            if (this.deListener != null) {
                try {
                    this.deListener.popupWillBecameVisible(new DateEntryEvent(this));
                    this.dateEntry.intActionPerformed();
                }
                catch (DateEntryVetoException dateEntryVetoException) {}
            } else {
                this.showPopup();
            }
        }
    }

    protected boolean handleSetValue(Date date) {
        Date date2 = date;
        if (this.oldDate == null || !this.oldDate.equals(date2)) {
            if (this.deListener != null) {
                try {
                    this.deListener.stateWillChange(new DateEntryEvent(this, date2));
                    return false;
                }
                catch (DateEntryVetoException dateEntryVetoException) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean isAllowEmpty() {
        return this.allowEmpty;
    }

    public void setAllowEmpty(boolean bl) {
        if (bl != this.allowEmpty) {
            this.intSetAllowEmpty(bl);
        }
    }

    private void intSetAllowEmpty(boolean bl) {
        block4: {
            block3: {
                this.allowEmpty = bl;
                if (this.allowEmpty) break block3;
                if (this.dayListener == null) {
                    this.dayListener = actionEvent -> this.textFieldEditor.setValue(this.dateEntry.getDate());
                }
                for (Component component : this.dateEntry.getJCalendar().getDayChooser().getDayPanel().getComponents()) {
                    if (!(component instanceof JButton)) continue;
                    ((JButton)component).addActionListener(this.dayListener);
                }
                break block4;
            }
            if (this.dayListener == null) break block4;
            for (Component component : this.dateEntry.getJCalendar().getDayChooser().getDayPanel().getComponents()) {
                if (!(component instanceof JButton)) continue;
                ((JButton)component).removeActionListener(this.dayListener);
            }
        }
    }

    protected String getEmptyMaskPattern() {
        return this.dateEntry.emptyMaskPattern;
    }

    public int get2DigitsYearStart() {
        return this._2DigitsYearStartDate != null ? this._2DigitsYearStartDate.get(1) : -1;
    }

    public void set2DigitsYearStart(int n2) {
        if (n2 >= 0) {
            if (n2 >= 100) {
                n2 %= 100;
            }
            this._2DigitsYearStartDate = Calendar.getInstance();
            this._2DigitsYearStartDate.clear();
            this._2DigitsYearStartDate.set(5, 31);
            this._2DigitsYearStartDate.set(2, 11);
            this._2DigitsYearStartDate.set(11, 23);
            this._2DigitsYearStartDate.set(12, 59);
            this._2DigitsYearStartDate.set(13, 59);
            this._2DigitsYearStartDate.set(1, 1900 + n2);
        } else {
            this._2DigitsYearStartDate = null;
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) {
        if (this.textFieldEditor != null && this.readOnly != bl) {
            this.readOnly = bl;
            this.textFieldEditor.setEditable(!bl);
            if (this.readOnly) {
                this.textFieldEditor.addFocusListener(this.focusListener);
            } else {
                this.textFieldEditor.removeFocusListener(this.focusListener);
            }
        }
    }

    @Override
    public void setName(String string) {
        this.name = string;
        if (this.textFieldEditor != null) {
            this.textFieldEditor.setName(this.name);
        }
    }

    public boolean isDefaultShortcutsEnabled() {
        return this.defaultShortcutsEnabled;
    }

    public void setDefaultShortcutsEnabled(boolean bl) {
        if (this.defaultShortcutsEnabled != bl) {
            this.defaultShortcutsEnabled = bl;
            if (!this.defaultShortcutsEnabled) {
                RemoteBaseGUIControl.disableDefaultShortcuts(this.textFieldEditor.getKeymap());
            }
        }
    }

    public void setBorderW(Border border) {
        if (this.textFieldEditor != null) {
            this.textFieldEditor.setBorder(null);
        }
        if (this.style == 0 && this.editor != null) {
            ((JSpinnerDateEditor)this.editor).setBorder(null);
        }
        if (this.showNonePanel != null) {
            this.showNonePanel.setBorder(null);
        }
        if (this.dateEntry != null) {
            this.dateEntry.setBorder(null);
        }
        if (this.textFieldEditor != null) {
            this.textFieldEditor.setBorder(border);
        }
        super.setBorder(null);
    }

    public Date getIllegalDate() {
        return this.illegalDate;
    }

    public void setIllegalDate(Date date) {
        this.illegalDate = date;
    }

    public JComponent getDragDropComponent() {
        return this.textFieldEditor;
    }

    public void setDragComponent(OutDragListener outDragListener) {
        if (this.textFieldEditor != null) {
            if (outDragListener != null) {
                this.textFieldEditor.setDropMode(DropMode.INSERT);
                this.textFieldEditor.setDragEnabled(true);
                this.ftth = new FromToTransferHandler(outDragListener, 1);
                this.textFieldEditor.setTransferHandler(this.ftth);
            } else {
                this.textFieldEditor.setDragEnabled(false);
                if (this.ftth != null) {
                    this.textFieldEditor.setTransferHandler(null);
                }
            }
        }
    }

    private static class MyJSpinnerDateEditor
    extends JSpinnerDateEditor {
        private static final long serialVersionUID = 1L;
        DateEntry de;

        private MyJSpinnerDateEditor() {
        }

        public void setValue(Object object) {
            if (this.de != null) {
                if (!this.de.handleSetValue((Date)object)) {
                    super.setValue(object);
                }
            } else {
                super.setValue(object);
            }
        }
    }

    private static class MyDateEntry
    extends JDateChooser {
        private static final long serialVersionUID = 1L;
        private String emptyMaskPattern;

        public MyDateEntry(IDateEditor iDateEditor) {
            super(iDateEditor);
            this.setDate(null);
        }

        public MyDateEntry(DateEntry dateEntry, String string, String string2, char c2) {
            super(null, null, string, (IDateEditor)new MyTextFieldDateEditor(dateEntry, string, string2, c2));
            this.emptyMaskPattern = IsguiUtility.createMaskFromDatePattern(string, c2, false);
            this.setDate(null);
        }

        JPopupMenu getPopup() {
            return this.popup;
        }

        void setDateSelected(boolean bl) {
            this.dateSelected = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        void intActionPerformed() {
            super.actionPerformed(null);
        }

        public JCalendar getJCalendar() {
            return this.jcalendar;
        }
    }

    private static class MyTextFieldDateEditor
    extends JTextFieldDateEditor {
        private static final long serialVersionUID = 1L;
        private DateEntry thisDateEntry;

        MyTextFieldDateEditor(DateEntry dateEntry, String string, String string2, char c2) {
            super(string, string2, c2);
            this.thisDateEntry = dateEntry;
        }

        public Color getBackground() {
            if (!this.isEnabled() && this.thisDateEntry != null && this.thisDateEntry.disabledBackground != null) {
                return this.thisDateEntry.disabledBackground;
            }
            return super.getBackground();
        }
    }
}

