/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.Constants;
import com.iscobol.gui.client.swing.CobolEvent;
import com.iscobol.gui.client.swing.CobolEventListener;
import com.iscobol.gui.client.swing.SearchKeyEventListener;
import java.net.URL;
import java.util.Vector;
import org.jdesktop.jdic.browser.WebBrowser;
import org.jdesktop.jdic.browser.WebBrowserEvent;
import org.jdesktop.jdic.browser.WebBrowserListener;

public class DesktopWebBrowser
extends WebBrowser
implements Constants,
WebBrowserListener {
    private Vector listeners = new Vector();
    private boolean busy;
    private URL nextURL;
    private String statusText = "";
    private boolean nomsgbeforenavigate = false;
    private String progress = "";

    public DesktopWebBrowser() {
        super(false);
        this.addWebBrowserListener(this);
    }

    protected DesktopWebBrowser(URL uRL) {
        super(uRL, false);
        this.addWebBrowserListener(this);
    }

    public void addCobolEventListener(CobolEventListener cobolEventListener) {
        this.listeners.addElement(cobolEventListener);
    }

    public void removeCobolEventListener(CobolEventListener cobolEventListener) {
        this.listeners.removeElement(cobolEventListener);
    }

    public void addSearchKeyEventListener(SearchKeyEventListener searchKeyEventListener) {
    }

    public void removeSearchKeyEventListener(SearchKeyEventListener searchKeyEventListener) {
    }

    private void pushEvent(int n2) {
        CobolEvent cobolEvent = new CobolEvent(this, 7, n2);
        for (int i2 = this.listeners.size() - 1; i2 >= 0; --i2) {
            try {
                ((CobolEventListener)this.listeners.elementAt(i2)).cobolEvent(cobolEvent);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected boolean willOpenURL(URL uRL) {
        if (!this.nomsgbeforenavigate && this.nextURL == null) {
            this.nextURL = uRL;
            this.busy = true;
            this.pushEvent(16429);
            return false;
        }
        return super.willOpenURL(uRL);
    }

    public void doOpenURL() {
        if (this.nextURL != null) {
            this.setURL(this.nextURL);
        }
    }

    public void abortOpenURL() {
        this.nextURL = null;
        this.busy = false;
    }

    public URL getURL() {
        return this.nextURL == null ? super.getURL() : this.nextURL;
    }

    public void initializationCompleted(WebBrowserEvent webBrowserEvent) {
    }

    public void documentCompleted(WebBrowserEvent webBrowserEvent) {
        this.busy = false;
        this.nextURL = null;
        this.pushEvent(16430);
    }

    public void downloadCompleted(WebBrowserEvent webBrowserEvent) {
        this.pushEvent(16432);
    }

    public void downloadError(WebBrowserEvent webBrowserEvent) {
        this.pushEvent(16432);
    }

    public void downloadProgress(WebBrowserEvent webBrowserEvent) {
        this.progress = webBrowserEvent.getData();
        this.pushEvent(16433);
    }

    public void downloadStarted(WebBrowserEvent webBrowserEvent) {
        this.pushEvent(16431);
    }

    public void statusTextChange(WebBrowserEvent webBrowserEvent) {
        this.statusText = webBrowserEvent.getData();
        this.pushEvent(16434);
    }

    public void windowClose(WebBrowserEvent webBrowserEvent) {
    }

    public void titleChange(WebBrowserEvent webBrowserEvent) {
        this.pushEvent(16435);
    }

    public boolean isBusy() {
        return this.busy;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public String getProgress() {
        return this.progress;
    }

    public void setNoMsgBeforeNavigate(boolean bl) {
        this.nomsgbeforenavigate = bl;
    }
}

