/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.docking.eleritec.CursorProvider;
import com.iscobol.docking.eleritec.Dockable;
import com.iscobol.docking.eleritec.DockingManager;
import com.iscobol.docking.eleritec.DockingPort;
import com.iscobol.gui.client.KeyboardBuffer;
import com.iscobol.gui.client.swing.DockingPanel;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.UndockedDialog;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.WindowConstants;
import javax.swing.border.LineBorder;

public class DockablePanel
extends JPanel
implements Dockable,
WindowConstants {
    private final String NO_TITLE = "#";
    private Window parentWin;
    private TitleBar titleBar;
    private WindowListener winListener;
    private WindowFocusListener winFocusListener;
    private WindowStateListener winStateListener;
    private boolean undecorated;
    private JRootPane rootPane;
    private DockingPanel dockPanel;
    private DockingPort port;
    private int defaultCloseOperation = 1;
    private UndockedDialog undockedDialog;

    public DockablePanel(GuiFactoryImpl guiFactoryImpl, DockingPanel dockingPanel) {
        Container container;
        this.dockPanel = dockingPanel;
        this.titleBar = new TitleBar("#");
        this.rootPane = new JRootPane();
        this.add(this.rootPane);
        Container container2 = dockingPanel;
        while (!(container2 instanceof Window) && (container = container2.getParent()) != null) {
            container2 = container;
        }
        this.parentWin = (Window)container2;
        this.setVisible(false);
    }

    public void init() {
        String string = this.titleBar.getTitle();
        if (string != "#") {
            this.add((Component)this.titleBar, 0);
        }
        this.dock();
        if (string != "#") {
            this.titleBar.getCloseButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (DockablePanel.this.winListener == null) {
                        DockablePanel.this.doDefaultCloseAction();
                    } else {
                        DockablePanel.this.winListener.windowClosing(new WindowEvent(DockablePanel.this.parentWin, 201, DockablePanel.this.parentWin));
                    }
                }
            });
        }
        KeyboardBuffer.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (DockablePanel.this.undockedDialog != null) {
                    return;
                }
                for (Container container = DockablePanel.this.getParent(); container != null; container = container.getParent()) {
                    if (!(container instanceof JTabbedPane)) continue;
                    return;
                }
                MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent((Component)mouseEvent.getSource(), mouseEvent, DockablePanel.this);
                if (DockablePanel.this.contains(mouseEvent2.getX(), mouseEvent2.getY()) && !DockablePanel.this.isFocused()) {
                    DockablePanel.this.setFocused(true);
                }
            }
        });
    }

    public void dock() {
        this.undockedDialog = null;
        DockingManager.registerDockable(this);
        this.port.dock(this, this.titleBar.getTitle(), "CENTER", false);
        this.dockPanel.addDockable(this);
        this.revalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFocused() {
        DockingPanel dockingPanel = this.dockPanel;
        synchronized (dockingPanel) {
            return this.dockPanel.focused == this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFocused(boolean bl) {
        DockingPanel dockingPanel = this.dockPanel;
        synchronized (dockingPanel) {
            DockablePanel dockablePanel = this.dockPanel.focused;
            if (bl) {
                if (dockablePanel != this) {
                    if (dockablePanel != null) {
                        dockablePanel.setFocused(false);
                    }
                    this.dockPanel.focused = this;
                    WindowEvent windowEvent = new WindowEvent(this.parentWin, 207, this.parentWin);
                    if (this.winFocusListener != null) {
                        this.winFocusListener.windowGainedFocus(windowEvent);
                    }
                }
            } else if (dockablePanel == this) {
                WindowEvent windowEvent = new WindowEvent(this.parentWin, 208, this.parentWin);
                if (this.winFocusListener != null) {
                    this.winFocusListener.windowLostFocus(windowEvent);
                }
                this.dockPanel.focused = null;
            }
            if (this.undockedDialog == null) {
                this.titleBar.setFocusLayout(bl);
            }
        }
    }

    private void _dispose() {
        if (this.undockedDialog != null) {
            this.undockedDialog.dispose();
        }
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof DockingPort)) continue;
            this.setVisible(false);
            ((DockingPort)((Object)container)).undock(this);
            break;
        }
        if (this.winListener != null) {
            this.winListener.windowClosed(new WindowEvent(this.parentWin, 202, this.parentWin));
        }
    }

    public void dispose() {
        if (SwingUtilities.isEventDispatchThread()) {
            this._dispose();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DockablePanel.this._dispose();
                }
            });
        }
    }

    @Override
    public void undock(Point point) {
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof DockingPort)) continue;
            this.setVisible(false);
            ((DockingPort)((Object)container)).undock(this);
            break;
        }
        this.undockedDialog = new UndockedDialog(this, point);
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.undockedDialog != null) {
            this.undockedDialog.setVisible(bl);
        } else {
            super.setVisible(bl);
        }
    }

    @Override
    public void doLayout() {
        Dimension dimension;
        Insets insets = this.getInsets();
        if (this.undecorated || this.titleBar.getTitle() == "#") {
            dimension = new Dimension(0, 0);
        } else {
            dimension = this.titleBar.getMinimumSize();
            this.titleBar.setBounds(insets.left, insets.top, this.getWidth() - insets.left - insets.right, dimension.height);
        }
        this.rootPane.setBounds(insets.left, insets.top + dimension.height, this.getWidth() - insets.left - insets.right, this.getHeight() - dimension.height);
    }

    @Override
    public CursorProvider getCursorProvider() {
        return null;
    }

    @Override
    public void dockingCanceled() {
    }

    @Override
    public void dockingCompleted(DockingPort dockingPort) {
        this.port = dockingPort;
    }

    @Override
    public Component getDockable() {
        return this;
    }

    @Override
    public String getDockableDesc() {
        return this.titleBar.getText().trim();
    }

    @Override
    public Component getInitiator() {
        return this.titleBar;
    }

    @Override
    public boolean isDockedLayoutResizable() {
        return true;
    }

    @Override
    public boolean isDockingEnabled() {
        return true;
    }

    @Override
    public boolean mouseMotionListenersBlockedWhileDragging() {
        return false;
    }

    @Override
    public void setDockedLayoutResizable(boolean bl) {
    }

    @Override
    public void setDockingEnabled(boolean bl) {
    }

    @Override
    public void setDockableDesc(String string) {
    }

    public void setUndecorated(boolean bl) {
        if (bl != this.undecorated) {
            this.undecorated = bl;
        }
    }

    @Override
    public void setSelected() {
        this.setFocused(true);
    }

    @Override
    public String toString() {
        return "DockablePanel: " + this.getDockableDesc();
    }

    public void setJMenuBar(JMenuBar jMenuBar) {
    }

    public boolean isResizable() {
        return false;
    }

    public void setResizable(boolean bl) {
    }

    public String getTitle() {
        if (this.titleBar == null) {
            return "";
        }
        return this.titleBar.getTitle();
    }

    @Override
    public String getName() {
        return this.getTitle();
    }

    public void setTitle(String string) {
        this.titleBar.setTitle(" " + string);
    }

    public void setDefaultCloseOperation(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: {
                this.defaultCloseOperation = n2;
            }
        }
    }

    public void doDefaultCloseAction() {
        switch (this.defaultCloseOperation) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                this.dispose();
            }
        }
    }

    @Override
    public JRootPane getRootPane() {
        return this.rootPane;
    }

    public Container getContentPane() {
        return this.rootPane.getContentPane();
    }

    public void setPort(String string) {
        if (this.port == null) {
            this.port = this.dockPanel.getPort(string);
            this.init();
        }
    }

    public void pack() {
    }

    public Frame getRootWindow() {
        Window window;
        Window window2 = this.parentWin;
        while ((window = window2.getOwner()) != null) {
            window2 = window;
        }
        return (Frame)window2;
    }

    public Component getFocusOwner() {
        return this.parentWin.getFocusOwner();
    }

    public void addWindowListener(WindowListener windowListener) {
        this.winListener = AWTEventMulticaster.add(this.winListener, windowListener);
    }

    public void removeWindowListener(WindowListener windowListener) {
        this.winListener = AWTEventMulticaster.remove(this.winListener, windowListener);
    }

    public WindowListener getWindowListener() {
        return this.winListener;
    }

    public void addWindowFocusListener(WindowFocusListener windowFocusListener) {
        this.winFocusListener = AWTEventMulticaster.add(this.winFocusListener, windowFocusListener);
    }

    public void removeWindowFocusListener(WindowFocusListener windowFocusListener) {
        this.winFocusListener = AWTEventMulticaster.remove(this.winFocusListener, windowFocusListener);
    }

    public WindowFocusListener getWindowFocusListener() {
        return this.winFocusListener;
    }

    public void addWindowStateListener(WindowStateListener windowStateListener) {
        this.winStateListener = AWTEventMulticaster.add(this.winStateListener, windowStateListener);
    }

    public void removeWindowStateListener(WindowStateListener windowStateListener) {
        this.winStateListener = AWTEventMulticaster.remove(this.winStateListener, windowStateListener);
    }

    public WindowStateListener getWindowStateListener() {
        return this.winStateListener;
    }

    public void toFront() {
        if (this.undockedDialog != null) {
            this.undockedDialog.toFront();
        } else {
            this.setFocused(true);
        }
    }

    public void setActive(boolean bl) {
    }

    public String getPortName() {
        if (this.port != null) {
            return this.port.getName();
        }
        return null;
    }

    class TitleBar
    extends JPanel {
        private String title;
        private JLabel titleLabel;
        private JComponent drag;
        private JButton close;
        private boolean focusLayout;
        private final Dimension minSize;

        public TitleBar(String string) {
            this.setLayout(new BorderLayout());
            this.title = string;
            this.titleLabel = new JLabel("", 2);
            this.titleLabel.setOpaque(true);
            this.setFocusLayout(true);
            this.drag = new JComponent(){

                @Override
                public void paintComponent(Graphics graphics) {
                    super.paintComponent(graphics);
                    int n2 = this.getSize().width;
                    int n3 = this.getSize().height;
                    if (TitleBar.this.focusLayout) {
                        graphics.drawLine(2, n3 / 3, n2 - 4, n3 / 3);
                        graphics.drawLine(2, 2 * n3 / 3, n2 - 4, 2 * n3 / 3);
                    }
                }
            };
            ImageIcon imageIcon = new ImageIcon(this.getToolkit().getImage(this.getClass().getResource("close1.png")));
            ImageIcon imageIcon2 = new ImageIcon(this.getToolkit().getImage(this.getClass().getResource("close2.png")));
            this.setFocusable(false);
            this.close = new JButton(imageIcon);
            this.close.setFocusable(false);
            this.close.setFocusPainted(false);
            this.close.setRolloverIcon(imageIcon2);
            this.close.setRolloverEnabled(true);
            Dimension dimension = this.titleLabel.getMinimumSize();
            dimension.width = dimension.height;
            if (dimension.width < imageIcon.getIconHeight()) {
                dimension.width = dimension.height = imageIcon.getIconHeight();
            }
            this.close.setPreferredSize(dimension);
            this.minSize = new Dimension(dimension.width + 4, dimension.height + 4);
            this.add((Component)this.titleLabel, "West");
            this.add((Component)this.drag, "Center");
            this.add((Component)this.close, "East");
            LineBorder lineBorder = new LineBorder(Color.black, 1, true);
            this.setBorder(lineBorder);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        DockablePanel.this.undock(null);
                    } else {
                        DockablePanel.this.setFocused(true);
                    }
                }
            });
        }

        private void setFocusLayout(boolean bl) {
            if (this.focusLayout != bl) {
                this.focusLayout = bl;
                this.setEnabled(this.focusLayout);
                this.revalidate();
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return this.minSize;
        }

        public String getText() {
            return this.title;
        }

        public JButton getCloseButton() {
            return this.close;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String string) {
            this.title = string;
            this.titleLabel.setText(this.title);
        }
    }
}

