/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.docking.eleritec.DefaultDockingPort;
import com.iscobol.docking.eleritec.DockingPort;
import com.iscobol.docking.swingx.MultiSplitLayout;
import com.iscobol.docking.swingx.MultiSplitPane;
import com.iscobol.gui.client.swing.DockablePanel;
import com.iscobol.gui.client.swing.MainPanel;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;

public class DockingPanel
extends MainPanel {
    private MultiSplitPane multiSplitPane;
    private MultiSplitLayout mspLayout;
    private Hashtable ports = new Hashtable();
    private DefaultDockingPort firstPort;
    private String dockLayout;
    private HashSet winList = new HashSet();
    DockablePanel focused;

    public DockingPanel(String string) {
        super(false);
        this.setDockLayout(string);
    }

    public DockingPanel(RemoteDisplayWindow remoteDisplayWindow, boolean bl) {
        super(remoteDisplayWindow, bl);
    }

    public DockingPanel(boolean bl) {
        super(bl);
    }

    void addDockable(DockablePanel dockablePanel) {
        this.winList.add(dockablePanel);
        dockablePanel.setFocused(true);
    }

    public void setDockLayout(String string) {
        this.dockLayout = string;
        this.init();
    }

    public String getDockLayout() {
        return MultiSplitLayout.getModel(this.mspLayout.getModel());
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.firstPort == null && bl) {
            this.init();
        }
        super.setVisible(bl);
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.multiSplitPane = new MultiSplitPane();
        this.mspLayout = this.multiSplitPane.getMultiSplitLayout();
        if (this.dockLayout != null) {
            this.mspLayout.setModel(MultiSplitLayout.parseModel(this.dockLayout));
        }
        ArrayList arrayList = new ArrayList();
        MultiSplitLayout.Node node = this.mspLayout.getModel();
        if (node != null) {
            DockingPanel.getLeaves(arrayList, node);
            for (MultiSplitLayout.Leaf leaf : arrayList) {
                String string = leaf.getName();
                DefaultDockingPort defaultDockingPort = new DefaultDockingPort(string);
                this.ports.put(string, defaultDockingPort);
                this.multiSplitPane.add((Component)defaultDockingPort, string);
                if (this.firstPort != null) continue;
                this.firstPort = defaultDockingPort;
            }
        }
        if (this.firstPort == null) {
            this.firstPort = new DefaultDockingPort("");
            this.ports.put("", this.firstPort);
            this.multiSplitPane.add((Component)this.firstPort, "");
        }
        this.add((Component)this.multiSplitPane, "Center");
    }

    public DockingPort getPort(String string) {
        DockingPort dockingPort = (DockingPort)this.ports.get(string);
        if (dockingPort == null) {
            dockingPort = this.firstPort;
        }
        return dockingPort;
    }

    private static void getLeaves(List list, MultiSplitLayout.Node node) {
        if (node instanceof MultiSplitLayout.Split) {
            MultiSplitLayout.Split split = (MultiSplitLayout.Split)node;
            for (MultiSplitLayout.Node node2 : split.getChildren()) {
                DockingPanel.getLeaves(list, node2);
            }
        } else if (node instanceof MultiSplitLayout.Leaf) {
            list.add(node);
        }
    }

    private List getLeaves() {
        ArrayList arrayList = new ArrayList();
        MultiSplitLayout.Node node = this.mspLayout.getModel();
        if (node != null) {
            DockingPanel.getLeaves(arrayList, node);
        }
        return arrayList;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void setLayoutManager(String string, String string2) {
    }

    public void unsetLayoutManager() {
    }

    @Override
    public LayoutManager getLayout() {
        return null;
    }
}

