/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.SwingConstants;

public class DoubleIcon
implements Icon,
SwingConstants {
    private Icon icon1;
    private Icon icon2;
    private int position;
    private int hOrientation;
    private int vOrientation;

    public DoubleIcon(Icon icon, Icon icon2) {
        this(icon, icon2, 1);
    }

    public DoubleIcon(Icon icon, Icon icon2, int n2) {
        this(icon, icon2, n2, 0, 0);
    }

    public DoubleIcon(Icon icon, Icon icon2, int n2, int n3, int n4) {
        this.icon1 = icon;
        this.icon2 = icon2;
        this.position = n2;
        this.hOrientation = n3;
        this.vOrientation = n4;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
        int n4 = this.getIconWidth();
        int n5 = this.getIconHeight();
        if (this.position == 2 || this.position == 4) {
            Icon icon;
            Icon icon2;
            if (this.position == 2) {
                icon2 = this.icon1;
                icon = this.icon2;
            } else {
                icon2 = this.icon2;
                icon = this.icon1;
            }
            this.paintIcon(component, graphics, icon2, n2, n3, n4, n5, 2, this.vOrientation);
            this.paintIcon(component, graphics, icon, n2 + icon2.getIconWidth(), n3, n4, n5, 2, this.vOrientation);
        } else if (this.position == 1 || this.position == 3) {
            Icon icon;
            Icon icon3;
            if (this.position == 1) {
                icon3 = this.icon1;
                icon = this.icon2;
            } else {
                icon3 = this.icon2;
                icon = this.icon1;
            }
            this.paintIcon(component, graphics, icon3, n2, n3, n4, n5, this.hOrientation, 1);
            this.paintIcon(component, graphics, icon, n2, n3 + icon3.getIconHeight(), n4, n5, this.hOrientation, 1);
        } else {
            this.paintIcon(component, graphics, this.icon1, n2, n3, n4, n5, this.hOrientation, this.vOrientation);
            this.paintIcon(component, graphics, this.icon2, n2, n3, n4, n5, this.hOrientation, this.vOrientation);
        }
    }

    void paintIcon(Component component, Graphics graphics, Icon icon, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int n9;
        switch (n6) {
            case 2: {
                n9 = n2;
                break;
            }
            case 4: {
                n9 = n2 + n4 - icon.getIconWidth();
                break;
            }
            default: {
                n9 = n2 + (n4 - icon.getIconWidth()) / 2;
            }
        }
        switch (n7) {
            case 1: {
                n8 = n3;
                break;
            }
            case 3: {
                n8 = n3 + n5 - icon.getIconHeight();
                break;
            }
            default: {
                n8 = n3 + (n5 - icon.getIconHeight()) / 2;
            }
        }
        icon.paintIcon(component, graphics, n9, n8);
    }

    @Override
    public int getIconWidth() {
        if (this.position == 2 || this.position == 4) {
            return this.icon1.getIconWidth() + this.icon2.getIconWidth();
        }
        return Math.max(this.icon1.getIconWidth(), this.icon2.getIconWidth());
    }

    @Override
    public int getIconHeight() {
        if (this.position == 1 || this.position == 3) {
            return this.icon1.getIconHeight() + this.icon2.getIconHeight();
        }
        return Math.max(this.icon1.getIconHeight(), this.icon2.getIconHeight());
    }

    public Icon getIcon1() {
        return this.icon1;
    }

    public Icon getIcon2() {
        return this.icon2;
    }
}

