/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.IsguiWorker;
import com.iscobol.gui.PicobolTextEvent;
import com.iscobol.gui.PicobolTextListener;
import com.iscobol.gui.client.PicobolWidget;
import com.iscobol.gui.client.spellchecker.Span;
import com.iscobol.gui.client.spellchecker.SpellChecker;
import com.iscobol.gui.client.swing.EditableTextField;
import com.iscobol.gui.client.swing.FromToTransferHandler;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.MsgBoxEvent;
import com.iscobol.gui.client.swing.MsgBoxListener;
import com.iscobol.gui.client.swing.OutDragListener;
import com.iscobol.gui.client.swing.PicobolMenuElement;
import com.iscobol.gui.client.swing.PicobolPopupMenu;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.rts.Factory;
import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.im.InputMethodRequests;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.MaskFormatter;
import javax.swing.text.NumberFormatter;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class EntryField
extends JComponent
implements EditableTextField {
    private static final long serialVersionUID = 1L;
    public static final int MASK_FORMAT_TYPE = 0;
    public static final int NUMBER_FORMAT_TYPE = 1;
    public static final int DATE_FORMAT_TYPE = 2;
    private static final int ICON_GAP = 1;
    private static final int ICON_TEXT_GAP = 1;
    private final UndoManager undoManager = new UndoManager();
    private static String eol = System.getProperty("line.separator", "\n");
    private final UndoableEditListener undoEditListener = undoableEditEvent -> this.undoManager.addEdit(undoableEditEvent.getEdit());
    private final KeyListener undoKeyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 90 && keyEvent.isControlDown()) {
                EntryField.this.undo();
            }
            if (keyEvent.getKeyCode() == 89 && keyEvent.isControlDown()) {
                EntryField.this.redo();
            }
        }
    };
    private int upperLowerMethod;
    private int formatType = 0;
    private boolean fireEvents = true;
    private boolean upper;
    private boolean lower;
    private boolean numeric;
    private boolean msgBoxOnError;
    private boolean useTab;
    private boolean useReturn;
    private boolean auto;
    private boolean autoSpin;
    private boolean noWrap;
    private int maxText;
    private String encoding;
    private int maxLines;
    private Color background;
    protected JTextComponent textComponent;
    private JScrollPane textScrollPane;
    private JSpinner spinner;
    private int lastKeyCode;
    private final boolean multiline;
    private boolean secure;
    private final Border defaultBorder;
    private double value;
    private double minVal;
    private double maxVal;
    private boolean increment;
    private SpinnerNumberModel spinnerModel;
    private int[][] lineOffsets;
    private boolean undoListenerInstalled;
    private MyDocument textDocument;
    private DefaultFormatter formatter;
    private GuiFactoryImpl gf;
    private Color readOnlyBackground;
    private Color readOnlyForeground;
    private Color disabledBackground;
    private Color disabledForeground;
    private Vector<PicobolTextListener> textListeners = new Vector();
    private Vector<FocusListener> focusListeners = new Vector();
    private Vector<MouseListener> mouseListeners = new Vector();
    private Vector<KeyListener> keyListeners = new Vector();
    private Icon icon;
    private Icon iconDisabled;
    private Icon iconTrailing;
    private Icon iconTrailingDisabled;
    private Icon iconRollover;
    private Icon iconTrailingRollover;
    private MouseAdapter iconMouseListener;
    private String[] iconHint = new String[2];
    private boolean[] iconMouseOver = new boolean[2];
    private Border[] border;
    private Insets borderInsets;
    private Insets margins = new Insets(0, 1, 0, 0);
    private Rectangle[] iconBounds = new Rectangle[2];
    private String placeholder;
    private Color placeholderColor;
    private String spellChecking;
    private Span[] spellCheckingSpans;
    private MyTimer spellCheckingTimer = new MyTimer(500);
    private String toolTipText;
    private Cursor textCmpCursor;
    private Cursor defCursor = Cursor.getDefaultCursor();
    private boolean defaultShortcutsEnabled = true;
    private char[] acceptedControlChars;
    private boolean maxTextBytes = true;
    private FromToTransferHandler ftth = null;
    private String inputFilter;
    private MsgBoxListener msgboxlistener = null;

    private static boolean isDigit(char c2) {
        return Character.isDigit(c2) || c2 == '-' || c2 == '+' || c2 == '.' || c2 == ',' || c2 == ' ' || c2 == '/';
    }

    public EntryField(GuiFactoryImpl guiFactoryImpl, String string, int n2, int n3) {
        this(guiFactoryImpl, true, false, false, string, n2, n3, 0, null, '\u0000', '\u0000');
    }

    public EntryField(GuiFactoryImpl guiFactoryImpl, boolean bl) {
        this(guiFactoryImpl, false, true, bl, null, 0, 0, 0, null, '\u0000', '\u0000');
    }

    public EntryField(GuiFactoryImpl guiFactoryImpl) {
        this(guiFactoryImpl, false, false, false, null, 0, 0, 0, null, '\u0000', '\u0000');
    }

    public EntryField(GuiFactoryImpl guiFactoryImpl, int n2, String string, char c2) {
        this(guiFactoryImpl, false, false, false, null, 0, 0, n2, string, c2, '\u0000');
    }

    public EntryField(GuiFactoryImpl guiFactoryImpl, char c2) {
        this(guiFactoryImpl, false, false, false, null, 0, 0, 0, null, '\u0000', c2);
    }

    private EntryField(GuiFactoryImpl guiFactoryImpl, boolean bl, boolean bl2, final boolean bl3, String string, int n2, int n3, int n4, String string2, char c2, char c3) {
        this.gf = guiFactoryImpl;
        this.multiline = bl;
        this.setLayout(new GridLayout(0, 1));
        if (this.multiline) {
            this.textComponent = new MultiLineEntryFieldComponent(this, string, n2, n3);
            this.textScrollPane = new JScrollPane(this.textComponent, 21, 31);
            this.textScrollPane.setFocusable(false);
            this.textScrollPane.getVerticalScrollBar().setFocusable(false);
            this.textScrollPane.getHorizontalScrollBar().setFocusable(false);
            this.add(this.textScrollPane);
        } else if (string2 != null) {
            this.textComponent = new FormattedEntryFieldComponent(this);
            ((FormattedEntryFieldComponent)this.textComponent).setFocusLostBehavior(0);
            this.add(this.textComponent);
            this.setFormatType(n4);
            this.setFormatString(string2);
            this.setFillChar(c2);
        } else if (c3 > '\u0000') {
            this.textComponent = new PasswordFieldComponent(this, n3);
            ((PasswordFieldComponent)this.textComponent).setEchoChar(c3);
            this.add(this.textComponent);
            this.secure = true;
        } else {
            this.textComponent = new SingleLineEntryFieldComponent(this, n3);
            if (bl2) {
                this.createSpinner();
                this.add(this.spinner);
                this.setAutoSpin(bl3);
            } else {
                this.add(this.textComponent);
            }
        }
        this.textComponent.setToolTipText("");
        this.msgBoxOnError = this.gf.getCsProperty().get("iscobol.gui.ef.ext_message", false);
        this.textDocument = new MyDocument(this);
        this.textComponent.setDocument(this.textDocument);
        this.textDocument.addDocumentListener(new DocumentListener(){

            private void handleEvent(DocumentEvent documentEvent, int n2, boolean bl) {
                Serializable serializable;
                String string = EntryField.this.getText();
                if (EntryField.this.fireEvents && ((PicobolWidget)((Object)EntryField.this.textComponent)).getActiveAccept() && !EntryField.this.textListeners.isEmpty()) {
                    if (EntryField.this.formatter == null || !(EntryField.this.formatter instanceof MaskFormatter) || bl) {
                        serializable = new PicobolTextEvent(EntryField.this.textComponent, 2199, n2);
                        for (PicobolTextListener picobolTextListener : EntryField.this.textListeners) {
                            picobolTextListener.textChanged((PicobolTextEvent)serializable);
                        }
                    }
                    if ((EntryField.this.formatter == null || EntryField.this.formatter instanceof NumberFormatter) && EntryField.this.maxText > 0 && EntryField.this.textDocument.length(string) >= EntryField.this.maxText && EntryField.this.auto) {
                        serializable = new PicobolTextEvent(EntryField.this.textComponent, 2202);
                        for (PicobolTextListener picobolTextListener : EntryField.this.textListeners) {
                            picobolTextListener.inputTerminated((PicobolTextEvent)serializable);
                        }
                    }
                }
                if (EntryField.this.spinner != null) {
                    try {
                        serializable = new Double(string.replace(',', '.'));
                        if (bl3) {
                            serializable = new Double(Math.round(serializable));
                        }
                        EntryField.this.value = serializable;
                        EntryField.this.spinner.setValue(serializable);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (EntryField.this.spellChecking != null && EntryField.this.spellChecking.length() > 0 && SpellChecker.isSupported() && (EntryField.this.textComponent instanceof SingleLineEntryFieldComponent || EntryField.this.textComponent instanceof MultiLineEntryFieldComponent)) {
                    EntryField.this.spellCheckingTimer.restart(new Runnable(){

                        @Override
                        public void run() {
                            EntryField.this.spellCheck();
                        }
                    });
                }
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.handleEvent(documentEvent, documentEvent.getOffset() + documentEvent.getLength(), true);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                if (EntryField.this.lastKeyCode == 8 || EntryField.this.lastKeyCode == 127 || !EntryField.this.hasSelection()) {
                    this.handleEvent(documentEvent, Math.max(0, documentEvent.getOffset() - documentEvent.getLength() + 1), false);
                }
            }
        });
        this.textCmpCursor = this.textComponent.getCursor();
        super.setBorder(null);
        this.defaultBorder = this.spinner != null ? this.spinner.getBorder() : (this.textScrollPane != null ? this.textScrollPane.getBorder() : this.textComponent.getBorder());
        this.iconMouseListener = new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (!EntryField.this.iconsAllowed()) {
                    return;
                }
                boolean bl = EntryField.this.iconMouseOver[0] || EntryField.this.iconMouseOver[1];
                ((EntryField)EntryField.this).iconMouseOver[0] = false;
                ((EntryField)EntryField.this).iconMouseOver[1] = false;
                EntryField.this.textComponent.setCursor(EntryField.this.textCmpCursor);
                if (bl) {
                    EntryField.this.textComponent.repaint();
                }
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (!EntryField.this.iconsAllowed()) {
                    return;
                }
                boolean bl = false;
                if (EntryField.this.textComponent.isEnabled()) {
                    for (int i2 = 0; i2 < EntryField.this.iconBounds.length; ++i2) {
                        boolean bl2 = EntryField.this.iconMouseOver[i2];
                        ((EntryField)EntryField.this).iconMouseOver[i2] = EntryField.this.iconBounds[i2] != null && EntryField.this.iconBounds[i2].contains(mouseEvent.getPoint());
                        bl |= bl2 != EntryField.this.iconMouseOver[i2];
                    }
                }
                if (EntryField.this.iconMouseOver[0] || EntryField.this.iconMouseOver[1]) {
                    EntryField.this.textComponent.setCursor(EntryField.this.defCursor);
                } else {
                    EntryField.this.textComponent.setCursor(EntryField.this.textCmpCursor);
                }
                if (bl) {
                    EntryField.this.textComponent.repaint();
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!EntryField.this.iconsAllowed()) {
                    return;
                }
                if (EntryField.this.textComponent.isEnabled()) {
                    for (int i2 = 0; i2 < EntryField.this.iconBounds.length; ++i2) {
                        PicobolTextEvent picobolTextEvent;
                        if (EntryField.this.iconBounds[i2] == null || !EntryField.this.iconBounds[i2].contains(mouseEvent.getPoint())) continue;
                        if (mouseEvent.getClickCount() <= 1) {
                            picobolTextEvent = new PicobolTextEvent(EntryField.this.textComponent, 2203, i2);
                            for (PicobolTextListener picobolTextListener : EntryField.this.textListeners) {
                                picobolTextListener.iconClicked(picobolTextEvent);
                            }
                            continue;
                        }
                        picobolTextEvent = new PicobolTextEvent(EntryField.this.textComponent, 2204, i2);
                        for (PicobolTextListener picobolTextListener : EntryField.this.textListeners) {
                            picobolTextListener.iconDoubleClicked(picobolTextEvent);
                        }
                    }
                }
            }
        };
        this.textComponent.addMouseListener(this.iconMouseListener);
        this.textComponent.addMouseMotionListener(this.iconMouseListener);
    }

    private void createSpinner() {
        this.spinnerModel = new SpinnerNumberModel(new Double("0"), null, null, new Double("1"));
        this.spinner = new JSpinner(this.spinnerModel){
            private static final long serialVersionUID = 1L;
            private Double lastVal;
            {
                this.lastVal = new Double("0");
            }

            @Override
            protected void fireStateChanged() {
                int n2;
                Double d2 = (Double)EntryField.this.spinner.getValue();
                if (EntryField.this.autoSpin) {
                    d2 = new Double(Math.round(d2));
                }
                if (d2 != EntryField.this.value && (n2 = d2.compareTo(this.lastVal)) != 0) {
                    if (n2 > 0) {
                        if (!EntryField.this.areMaxMinValueSet() || EntryField.this.value < EntryField.this.maxVal) {
                            if (!EntryField.this.textListeners.isEmpty()) {
                                PicobolTextEvent picobolTextEvent = new PicobolTextEvent(EntryField.this.textComponent, 2200);
                                for (PicobolTextListener picobolTextListener : EntryField.this.textListeners) {
                                    picobolTextListener.valueIncrementing(picobolTextEvent);
                                }
                            }
                            EntryField.this.increment = true;
                        }
                    } else if (!EntryField.this.areMaxMinValueSet() || EntryField.this.value > EntryField.this.minVal) {
                        if (!EntryField.this.textListeners.isEmpty()) {
                            PicobolTextEvent picobolTextEvent = new PicobolTextEvent(EntryField.this.textComponent, 2201);
                            for (PicobolTextListener picobolTextListener : EntryField.this.textListeners) {
                                picobolTextListener.valueDecrementing(picobolTextEvent);
                            }
                        }
                        EntryField.this.increment = false;
                    }
                }
                this.lastVal = d2;
            }
        };
        this.spinner.setFocusable(false);
        this.spinner.setEditor(this.textComponent);
        SwingUtilities.replaceUIActionMap(this.spinner, null);
    }

    public Border getDefaultBorder() {
        return this.defaultBorder;
    }

    public void addTextListener(PicobolTextListener picobolTextListener) {
        if (!this.textListeners.contains(picobolTextListener)) {
            this.textListeners.addElement(picobolTextListener);
        }
    }

    public void removeTextListener(PicobolTextListener picobolTextListener) {
        this.textListeners.removeElement(picobolTextListener);
    }

    private boolean areMaxMinValueSet() {
        return this.maxVal != 0.0 || this.minVal != 0.0;
    }

    public void setUpper(boolean bl) {
        this.upper = bl;
        if (bl) {
            this.lower = !bl;
        }
    }

    public void setLower(boolean bl) {
        this.lower = bl;
        if (bl) {
            this.upper = !bl;
        }
    }

    public void setNumeric(boolean bl) {
        this.numeric = bl;
    }

    public void setUseTab(boolean bl) {
        this.useTab = bl;
    }

    public void setReadOnly(boolean bl, final boolean bl2) {
        if (this.textComponent.isEditable() == !bl && !bl2) {
            return;
        }
        final boolean bl3 = !bl;
        new IsguiWorker(true){

            @Override
            public void launch() {
                EntryField.this.textComponent.setEditable(bl3);
                if (bl2) {
                    EntryField.this.textCmpCursor = EntryField.this.textComponent.getCursor();
                }
            }
        }.start();
    }

    public void setMaxText(int n2) {
        this.maxText = n2;
        if (this.formatter != null && this.formatter instanceof MaskFormatter) {
            ((FormattedEntryFieldComponent)this.textComponent).setMaxText();
        }
    }

    public int getMaxText() {
        return this.maxText;
    }

    void setEncoding(String string) {
        this.encoding = string;
    }

    void setMaxTextBytes(boolean bl) {
        this.maxTextBytes = bl;
    }

    public void setMaxLines(int n2) {
        this.maxLines = n2;
    }

    public void setAuto(boolean bl) {
        this.auto = bl;
    }

    public void setAutoSpin(boolean bl) {
        this.autoSpin = bl;
    }

    public boolean isUpper() {
        return this.upper;
    }

    public boolean isLower() {
        return this.lower;
    }

    public void setUseReturn(boolean bl) {
        this.useReturn = bl;
    }

    public boolean getUseReturn() {
        return this.useReturn;
    }

    public boolean useReturn() {
        return this.useReturn;
    }

    public boolean useTab() {
        return this.useTab;
    }

    @Override
    public boolean hasSelection() {
        return this.textComponent.getSelectionStart() != this.textComponent.getSelectionEnd();
    }

    @Override
    public void setToolTipText(String string) {
        this.toolTipText = string;
        this.textComponent.setToolTipText(this.toolTipText != null ? this.toolTipText : "");
    }

    @Override
    public void setSize(int n2, int n3) {
        super.setSize(n2, n3);
        this.revalidate();
    }

    public void setSecure(boolean bl, char c2) {
        JTextField jTextField;
        if (this.multiline || this.formatter != null || this.secure == bl) {
            return;
        }
        this.secure = bl;
        if (this.secure) {
            jTextField = (SingleLineEntryFieldComponent)this.textComponent;
            this.textComponent = new PasswordFieldComponent(this, jTextField.getColumns());
        } else {
            jTextField = (PasswordFieldComponent)this.textComponent;
            this.textComponent = new SingleLineEntryFieldComponent(this, jTextField.getColumns());
        }
        this.setTextComponentAttributes(jTextField);
        if (this.secure) {
            ((PasswordFieldComponent)this.textComponent).setEchoChar(c2);
        }
        this.remove(jTextField);
        this.add(this.textComponent);
        this.doLayout();
    }

    private void setTextComponentAttributes(JTextField jTextField) {
        this.textComponent.setDocument(this.textDocument);
        this.textComponent.setBackground(jTextField.getBackground());
        this.textComponent.setForeground(jTextField.getForeground());
        this.textComponent.setBorder(jTextField.getBorder());
        this.textComponent.setCaretPosition(jTextField.getCaretPosition());
        this.textComponent.setEnabled(jTextField.isEnabled());
        this.textComponent.setFocusable(jTextField.isFocusable());
        this.textComponent.setFont(jTextField.getFont());
        ((JTextField)this.textComponent).setHorizontalAlignment(jTextField.getHorizontalAlignment());
        this.textComponent.setSelectedTextColor(jTextField.getSelectedTextColor());
        this.textComponent.setSelectionColor(jTextField.getSelectionColor());
        this.textComponent.setDragEnabled(jTextField.getDragEnabled());
        this.textComponent.setEditable(jTextField.isEditable());
        this.textComponent.setText(jTextField.getText());
        this.textComponent.setToolTipText(jTextField.getToolTipText());
        if (!this.defaultShortcutsEnabled) {
            RemoteBaseGUIControl.disableDefaultShortcuts(this.textComponent.getKeymap());
        }
        if (this.undoListenerInstalled) {
            jTextField.getDocument().removeUndoableEditListener(this.undoEditListener);
            jTextField.removeKeyListener(this.undoKeyListener);
            this.textComponent.getDocument().addUndoableEditListener(this.undoEditListener);
            this.textComponent.addKeyListener(this.undoKeyListener);
        }
        for (FocusListener eventListener : this.focusListeners) {
            this.textComponent.addFocusListener(eventListener);
        }
        for (KeyListener keyListener : this.keyListeners) {
            this.textComponent.addKeyListener(keyListener);
        }
        for (MouseListener mouseListener : this.mouseListeners) {
            this.textComponent.addMouseListener(mouseListener);
        }
        if (this.iconMouseListener != null) {
            jTextField.removeMouseListener(this.iconMouseListener);
            jTextField.removeMouseMotionListener(this.iconMouseListener);
            this.textComponent.addMouseListener(this.iconMouseListener);
            this.textComponent.addMouseMotionListener(this.iconMouseListener);
        }
    }

    private void intPaste() {
        if (!this.textComponent.isEditable()) {
            return;
        }
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        try {
            String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            if (this.hasSelection()) {
                this.textComponent.replaceSelection(string);
            } else {
                this.textComponent.getDocument().insertString(this.textComponent.getCaretPosition(), string, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getText() {
        if (this.multiline) {
            return ((MultiLineEntryFieldComponent)this.textComponent).getText();
        }
        if (this.formatter != null) {
            try {
                ((FormattedEntryFieldComponent)this.textComponent).commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            Object object = ((FormattedEntryFieldComponent)this.textComponent).getValue();
            if (object != null) {
                return object.toString();
            }
            return "";
        }
        if (this.textComponent instanceof PasswordFieldComponent) {
            return ((PasswordFieldComponent)this.textComponent).GetText();
        }
        return ((SingleLineEntryFieldComponent)this.textComponent).GetText();
    }

    public boolean isEditValid() {
        if (this.formatter == null) {
            return true;
        }
        try {
            ((FormattedEntryFieldComponent)this.textComponent).commitEdit();
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public int getCaretPosition() {
        return this.textComponent.getCaretPosition();
    }

    public String getSelectedText() {
        String string = this.textComponent.getSelectedText();
        if (string != null) {
            return string;
        }
        return "";
    }

    public int getSelectionStart() {
        return this.textComponent.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.textComponent.getSelectionEnd();
    }

    @Override
    public void selectAll() {
        this.textComponent.selectAll();
    }

    public void setText(String string) {
        if (this.formatter == null) {
            this.textComponent.setText(string);
        } else {
            ((FormattedEntryFieldComponent)this.textComponent).setValue(string);
        }
    }

    public void setAllText(String string) {
        if (this.formatter == null) {
            this.textDocument.setAllText(string, true);
        } else {
            boolean bl = false;
            while (!bl) {
                try {
                    switch (this.formatType) {
                        default: {
                            this.formatter.valueToString(string);
                            break;
                        }
                        case 1: 
                        case 2: {
                            this.formatter.stringToValue(string);
                        }
                    }
                    bl = true;
                }
                catch (ParseException parseException) {
                    int n2 = parseException.getErrorOffset();
                    if (n2 < string.length()) {
                        string = string.substring(0, n2) + string.substring(n2 + 1);
                        continue;
                    }
                    bl = true;
                }
            }
            ((FormattedEntryFieldComponent)this.textComponent).setValue(string);
        }
    }

    @Override
    public void copy() {
        this.textComponent.copy();
    }

    @Override
    public void cut() {
        if (this.textComponent.isEditable()) {
            this.textComponent.cut();
        }
    }

    @Override
    public void paste() {
        this.intPaste();
    }

    public void select(int n2, int n3) {
        this.textComponent.select(n2, n3);
    }

    void setMargins(Insets insets, boolean bl) {
        Insets insets2 = this.margins = insets != null ? insets : new Insets(0, 0, 0, 0);
        if (!this.multiline) {
            this.margins.bottom = 0;
            this.margins.top = 0;
        }
        if (bl) {
            Border border = this.border != null ? this.border[0] : null;
            this.intSetBorder(this.textComponent, border);
        }
    }

    @Override
    public void replaceSelection(String string) {
        this.textComponent.replaceSelection(string);
    }

    public void setCaretPosition(int n2) {
        this.textComponent.setCaretPosition(n2);
    }

    @Override
    public void setBackground(Color color) {
        this.background = color;
        if (this.textComponent == null) {
            super.setBackground(color);
        } else {
            if (this.textScrollPane != null) {
                this.textScrollPane.setBackground(color);
                this.textScrollPane.setViewportBorder(BorderFactory.createMatteBorder(this.margins.top, this.margins.left, this.margins.bottom, this.margins.right, color));
            }
            this.textComponent.setBackground(color);
        }
    }

    @Override
    public Color getBackground() {
        if (this.textComponent == null || !this.textComponent.isBackgroundSet()) {
            return super.getBackground();
        }
        return this.textComponent.getBackground();
    }

    @Override
    public void setForeground(Color color) {
        if (this.textComponent == null) {
            super.setForeground(color);
        } else {
            this.textComponent.setForeground(color);
        }
    }

    @Override
    public Color getForeground() {
        if (this.textComponent == null || !this.textComponent.isForegroundSet()) {
            return super.getForeground();
        }
        return this.textComponent.getForeground();
    }

    @Override
    public void setEnabled(boolean bl) {
        this.textComponent.setEnabled(bl);
        if (this.textScrollPane != null) {
            this.textScrollPane.setEnabled(bl);
        }
        if (this.spinner != null) {
            this.spinner.setEnabled(bl);
        }
        this.redrawIcon();
    }

    @Override
    public boolean isEditable() {
        return this.textComponent.isEditable();
    }

    @Override
    public boolean isEnabled() {
        return this.textComponent.isEnabled();
    }

    @Override
    public void setFont(Font font) {
        if (this.textComponent == null) {
            super.setFont(font);
        } else {
            this.textComponent.setFont(font);
        }
    }

    @Override
    public Font getFont() {
        if (this.textComponent == null || !this.textComponent.isFontSet()) {
            return super.getFont();
        }
        return this.textComponent.getFont();
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        if (this.textComponent == null) {
            super.addKeyListener(keyListener);
        } else {
            this.textComponent.addKeyListener(keyListener);
            this.keyListeners.addElement(keyListener);
        }
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        this.textComponent.removeKeyListener(keyListener);
        this.keyListeners.removeElement(keyListener);
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
        if (this.textComponent == null) {
            super.addFocusListener(focusListener);
        } else {
            this.textComponent.addFocusListener(focusListener);
            this.focusListeners.addElement(focusListener);
        }
    }

    @Override
    public void removeFocusListener(FocusListener focusListener) {
        this.textComponent.removeFocusListener(focusListener);
        this.focusListeners.removeElement(focusListener);
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        if (this.textComponent == null) {
            super.addMouseListener(mouseListener);
        } else {
            this.textComponent.addMouseListener(mouseListener);
            this.mouseListeners.addElement(mouseListener);
        }
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        this.textComponent.removeMouseListener(mouseListener);
        this.mouseListeners.removeElement(mouseListener);
    }

    @Override
    public void setFocusable(boolean bl) {
        this.textComponent.setFocusable(bl);
    }

    @Override
    public void requestFocus() {
        this.textComponent.requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.textComponent.requestFocusInWindow();
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            if (this.textComponent.isEditable() && !this.undoListenerInstalled) {
                this.textComponent.getDocument().addUndoableEditListener(this.undoEditListener);
                this.textComponent.addKeyListener(this.undoKeyListener);
                this.undoListenerInstalled = true;
            }
            if (this.multiline && !this.textComponent.isEditable()) {
                this.textComponent.setFocusTraversalKeys(1, Collections.EMPTY_SET);
                this.textComponent.setFocusTraversalKeys(0, Collections.EMPTY_SET);
            }
            this.doLayout();
        }
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (this.textScrollPane != null) {
            this.textScrollPane.doLayout();
        }
        if (this.spinner != null) {
            this.spinner.doLayout();
        }
    }

    public void updateValue() {
        if (this.spinner != null) {
            this.value = this.increment ? (this.value += 1.0) : (this.value -= 1.0);
            String string = "";
            string = Math.ceil(this.value) == this.value ? string + (long)this.value : string + this.value;
            this.setText(string);
        }
    }

    public void setMaxValue(int n2) {
        this.maxVal = n2;
    }

    public void setMinValue(int n2) {
        this.minVal = n2;
    }

    public void setHorizontalAlignment(int n2) {
        if (!this.multiline) {
            ((JTextField)this.textComponent).setHorizontalAlignment(n2);
        }
    }

    public void addVerticalScrollBar() {
        int n2;
        if (this.textScrollPane != null && (n2 = this.textScrollPane.getVerticalScrollBarPolicy()) != 22) {
            this.textScrollPane.setVerticalScrollBarPolicy(22);
        }
    }

    public int getLineCount() {
        if (this.multiline) {
            return ((MultiLineEntryFieldComponent)this.textComponent).getLineCount();
        }
        return 1;
    }

    private int getLineCount(boolean bl) {
        if (this.multiline) {
            return ((MultiLineEntryFieldComponent)this.textComponent).getLineCount(bl);
        }
        return 1;
    }

    public int getLineStartOffset(int n2) {
        if (this.multiline) {
            try {
                return ((MultiLineEntryFieldComponent)this.textComponent).getLineStartOffset(n2);
            }
            catch (BadLocationException badLocationException) {
                return 0;
            }
        }
        return 0;
    }

    public int getLineEndOffset(int n2) {
        if (this.multiline) {
            try {
                return ((MultiLineEntryFieldComponent)this.textComponent).getLineEndOffset(n2);
            }
            catch (BadLocationException badLocationException) {
                return this.getText().length();
            }
        }
        return this.getText().length();
    }

    public int[][] getLineOffsets() {
        if (this.multiline) {
            return ((MultiLineEntryFieldComponent)this.textComponent).getLineOffsets();
        }
        return new int[][]{{0, this.getText().length()}};
    }

    public void setFormatType(int n2) {
        if (this.textComponent instanceof FormattedEntryFieldComponent) {
            this.formatType = n2;
            switch (this.formatType) {
                case 1: {
                    this.formatter = new NumberFormatter();
                    break;
                }
                case 2: {
                    this.formatter = new DateFormatter();
                    break;
                }
                default: {
                    this.formatter = new MaskFormatter();
                    ((MaskFormatter)this.formatter).setValueContainsLiteralCharacters(false);
                }
            }
            ((FormattedEntryFieldComponent)this.textComponent).setFormatterFactory(new DefaultFormatterFactory(this.formatter));
        }
    }

    public void setPlaceholder(String string) {
        this.placeholder = string;
        this.textComponent.repaint();
    }

    public void setPlaceholderColor(Color color) {
        this.placeholderColor = color;
        this.textComponent.repaint();
    }

    public int getFormatType() {
        return this.formatType;
    }

    public void setFormatString(String string) {
        if (this.formatter == null) {
            return;
        }
        FormattedEntryFieldComponent formattedEntryFieldComponent = (FormattedEntryFieldComponent)this.textComponent;
        switch (this.formatType) {
            case 1: {
                ((NumberFormatter)this.formatter).setFormat(new DecimalFormat(string));
                break;
            }
            case 2: {
                ((DateFormatter)this.formatter).setFormat(new SimpleDateFormat(string));
                break;
            }
            default: {
                formattedEntryFieldComponent.setMask(string);
            }
        }
        formattedEntryFieldComponent.setValue(formattedEntryFieldComponent.getValue());
    }

    public String getFormatString() {
        if (this.formatter == null) {
            return null;
        }
        switch (this.formatType) {
            case 1: {
                return ((DecimalFormat)((NumberFormatter)this.formatter).getFormat()).toPattern();
            }
            case 2: {
                return ((SimpleDateFormat)((DateFormatter)this.formatter).getFormat()).toPattern();
            }
        }
        return ((MaskFormatter)this.formatter).getMask();
    }

    public void setFillChar(char c2) {
        if (this.formatter != null && this.formatter instanceof MaskFormatter) {
            ((MaskFormatter)this.formatter).setPlaceholderCharacter(c2);
        }
    }

    public char getFillChar() {
        if (this.formatter != null && this.formatter instanceof MaskFormatter) {
            return ((MaskFormatter)this.formatter).getPlaceholderCharacter();
        }
        return '\u0000';
    }

    @Override
    public void setBorder(Border border) {
        this.border = new Border[]{border};
        if (this.textComponent == null) {
            super.setBorder(border);
        } else if (this.spinner != null) {
            if (border != null) {
                if (border instanceof MatteBorder) {
                    super.setBorder(null);
                    if (this.textScrollPane != null) {
                        this.textScrollPane.setBorder(null);
                    }
                    if (this.textComponent != null) {
                        this.textComponent.setBorder(border);
                    }
                    this.spinner.setBorder(null);
                } else {
                    this.spinner.setBorder(border);
                }
            } else {
                this.intSetBorder(this.spinner, border);
            }
        } else if (this.textScrollPane != null) {
            this.intSetBorder(this.textScrollPane, border);
        } else {
            this.intSetBorder(this.textComponent, border);
            this.redrawIcon();
        }
    }

    private void intSetBorder(JComponent jComponent, Border border) {
        Border border2;
        if (this.multiline) {
            Color color = this.background != null ? this.background : this.gf.getRemotePalette().getColor(15);
            border2 = BorderFactory.createMatteBorder(this.margins.top, this.margins.left, this.margins.bottom, this.margins.right, color);
        } else {
            border2 = BorderFactory.createEmptyBorder(this.margins.top, this.margins.left, this.margins.bottom, this.margins.right);
        }
        if (border == null) {
            jComponent.setBorder(border2);
        } else if (this.multiline) {
            jComponent.setBorder(border);
            if (this.textScrollPane != null) {
                this.textScrollPane.setViewportBorder(border2);
            }
        } else {
            jComponent.setBorder(BorderFactory.createCompoundBorder(border, border2));
        }
    }

    @Override
    public Border getBorder() {
        if (this.textComponent == null) {
            return super.getBorder();
        }
        if (this.border != null) {
            return this.border[0];
        }
        if (this.spinner != null) {
            return this.spinner.getBorder();
        }
        if (this.textScrollPane != null) {
            return this.textScrollPane.getBorder();
        }
        return this.textComponent.getBorder();
    }

    private boolean intProcessEvent(AWTEvent aWTEvent, boolean bl) {
        MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
        if (aWTEvent instanceof KeyEvent && menuElementArray != null && menuElementArray.length > 0 && menuElementArray[0] instanceof PicobolPopupMenu) {
            aWTEvent.setSource(menuElementArray[menuElementArray.length - 1]);
            ((PicobolMenuElement)((Object)menuElementArray[menuElementArray.length - 1])).processEvent((KeyEvent)aWTEvent);
            return false;
        }
        switch (aWTEvent.getID()) {
            case 1004: {
                if (this.textComponent.getCaret() != null && !this.textComponent.isEditable()) {
                    this.textComponent.getCaret().setVisible(true);
                    this.textComponent.getCaret().setSelectionVisible(true);
                }
                return true;
            }
            case 1005: {
                if (this.textComponent.getCaret() != null && !this.textComponent.isEditable()) {
                    this.textComponent.getCaret().setVisible(false);
                    this.textComponent.getCaret().setSelectionVisible(false);
                }
                return true;
            }
            case 500: 
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: {
                return true;
            }
            case 400: {
                KeyEvent keyEvent = (KeyEvent)aWTEvent;
                RemoteBaseGUIControl.checkControlCharacter(keyEvent, this.acceptedControlChars, this.textComponent);
                this.gf.getRemoteVirtualKeyboard().mapKey(keyEvent, this.lastKeyCode);
                return true;
            }
            case 401: {
                this.lastKeyCode = ((KeyEvent)aWTEvent).getKeyCode();
                return true;
            }
        }
        return bl;
    }

    @Override
    public void undo() {
        if (this.undoManager.canUndo()) {
            try {
                this.undoManager.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                System.err.println(cannotUndoException);
            }
        }
    }

    @Override
    public void redo() {
        if (this.undoManager.canRedo()) {
            try {
                this.undoManager.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                System.err.println(cannotRedoException);
            }
        }
    }

    @Override
    public boolean canUndo() {
        return this.undoManager.canUndo();
    }

    @Override
    public boolean canRedo() {
        return this.undoManager.canRedo();
    }

    public JTextComponent getTextComponent() {
        return this.textComponent;
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        return this.textComponent.getInputMethodRequests();
    }

    public Color getDisabledBackground() {
        return this.disabledBackground;
    }

    public void setDisabledBackground(Color color) {
        this.disabledBackground = color;
        this.textComponent.repaint();
    }

    public Color getDisabledForeground() {
        return this.disabledForeground;
    }

    public void setDisabledForeground(Color color) {
        this.disabledForeground = color;
        this.textComponent.repaint();
    }

    public Color getReadOnlyBackground() {
        return this.readOnlyBackground;
    }

    public void setReadOnlyBackground(Color color) {
        this.readOnlyBackground = color;
        this.textComponent.repaint();
    }

    public Color getReadOnlyForeground() {
        return this.readOnlyForeground;
    }

    public void setReadOnlyForeground(Color color) {
        this.readOnlyForeground = color;
        this.textComponent.repaint();
    }

    @Override
    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        if (this.textComponent != null) {
            this.textComponent.setComponentOrientation(componentOrientation);
        }
    }

    @Override
    public void setName(String string) {
        if (this.textComponent != null) {
            this.textComponent.setName(string);
        }
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        if (this.icon != icon) {
            this.icon = icon;
            this.redrawIcon();
        }
    }

    public Icon getIconDisabled() {
        return this.iconDisabled;
    }

    public void setIconDisabled(Icon icon) {
        if (this.iconDisabled != icon) {
            this.iconDisabled = icon;
            this.redrawIcon();
        }
    }

    public Icon getIconTrailing() {
        return this.iconTrailing;
    }

    public void setIconTrailing(Icon icon) {
        if (this.iconTrailing != icon) {
            this.iconTrailing = icon;
            this.redrawIcon();
        }
    }

    public Icon getIconTrailingDisabled() {
        return this.iconTrailingDisabled;
    }

    public void setIconTrailingDisabled(Icon icon) {
        if (this.iconTrailingDisabled != icon) {
            this.iconTrailingDisabled = icon;
            this.redrawIcon();
        }
    }

    public Icon getIconRollover() {
        return this.iconRollover;
    }

    public void setIconRollover(Icon icon) {
        this.iconRollover = icon;
    }

    public Icon getIconTrailingRollover() {
        return this.iconTrailingRollover;
    }

    public void setIconTrailingRollover(Icon icon) {
        this.iconTrailingRollover = icon;
    }

    public String getIconHint() {
        return this.iconHint[0];
    }

    public void setIconHint(String string) {
        this.iconHint[0] = string;
    }

    public String getIconTrailingHint() {
        return this.iconHint[1];
    }

    public void setIconTrailingHint(String string) {
        this.iconHint[1] = string;
    }

    private Icon[] getIcons() {
        Icon icon;
        Icon icon2;
        if (this.textComponent.isEnabled()) {
            icon2 = this.iconMouseOver[0] ? (this.iconRollover != null ? this.iconRollover : this.icon) : this.icon;
            icon = this.iconMouseOver[1] ? (this.iconTrailingRollover != null ? this.iconTrailingRollover : this.iconTrailing) : this.iconTrailing;
        } else {
            icon2 = this.iconDisabled != null ? this.iconDisabled : this.icon;
            icon = this.iconTrailingDisabled != null ? this.iconTrailingDisabled : this.iconTrailing;
        }
        return new Icon[]{icon2, icon};
    }

    private boolean iconsAllowed() {
        return this.spinner == null && !(this.textComponent instanceof MultiLineEntryFieldComponent);
    }

    private void redrawIcon() {
        if (!this.iconsAllowed()) {
            return;
        }
        Icon[] iconArray = this.getIcons();
        Insets insets = new Insets(this.margins.top, this.margins.left, this.margins.bottom, this.margins.right);
        this.borderInsets = this.getBorderInsets();
        if (this.getBorder() != null) {
            this.borderInsets = this.getBorder().getBorderInsets(this);
        }
        if (iconArray[0] != null) {
            insets.left = this.borderInsets.left + iconArray[0].getIconWidth() + 1;
        }
        if (iconArray[1] != null) {
            insets.right = this.borderInsets.right + iconArray[1].getIconWidth() + 1;
        }
        if (this.border == null) {
            this.textComponent.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
        } else {
            this.textComponent.setBorder(BorderFactory.createCompoundBorder(this.border[0], BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right)));
        }
        this.textComponent.repaint();
    }

    private Insets getBorderInsets() {
        if (this.border != null && this.border[0] != null) {
            JTextField jTextField = new JTextField();
            jTextField.setBorder(this.border[0]);
            return this.border[0].getBorderInsets(jTextField);
        }
        return new Insets(0, 0, 0, 0);
    }

    private void intPaintComponent(JTextComponent jTextComponent, Graphics graphics) {
        int n2;
        int n3;
        Object object;
        if (this.iconsAllowed()) {
            int n4;
            int n5;
            if (this.borderInsets == null) {
                this.borderInsets = this.getBorderInsets();
            }
            if ((object = this.getIcons())[0] != null) {
                n3 = object[0].getIconWidth();
                n5 = object[0].getIconHeight();
                n2 = (jTextComponent.getHeight() - n5) / 2;
                n4 = this.borderInsets.left + 1;
                object[0].paintIcon(jTextComponent, graphics, n4, n2);
                this.iconBounds[0] = new Rectangle(n4, n2, n3, n5);
            } else {
                this.iconBounds[0] = null;
            }
            if (object[1] != null) {
                n3 = object[1].getIconWidth();
                n5 = object[1].getIconHeight();
                n2 = (jTextComponent.getHeight() - n5) / 2;
                n4 = jTextComponent.getWidth() - this.borderInsets.right - 1 - n3;
                object[1].paintIcon(jTextComponent, graphics, n4, n2);
                this.iconBounds[1] = new Rectangle(n4, n2, n3, n5);
            } else {
                this.iconBounds[1] = null;
            }
        }
        if (this.placeholder != null && this.placeholder.length() > 0 && jTextComponent.getText().length() == 0) {
            object = (Graphics2D)graphics;
            ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics)object).setColor(this.placeholderColor != null ? this.placeholderColor : jTextComponent.getDisabledTextColor());
            n3 = jTextComponent.getInsets().left;
            if (this.textComponent instanceof JTextField) {
                FontMetrics fontMetrics = graphics.getFontMetrics();
                n2 = fontMetrics.stringWidth(this.placeholder);
                if (((JTextField)this.textComponent).getHorizontalAlignment() == 2) {
                    n3 = jTextComponent.getInsets().left;
                } else if (((JTextField)this.textComponent).getHorizontalAlignment() == 0) {
                    n3 = jTextComponent.getWidth() / 2 - n2 / 2;
                } else if (((JTextField)this.textComponent).getHorizontalAlignment() == 4) {
                    n3 = jTextComponent.getWidth() - jTextComponent.getInsets().right - n2;
                }
            }
            ((Graphics2D)object).drawString(this.placeholder, n3, graphics.getFontMetrics().getMaxAscent() + jTextComponent.getInsets().top);
        }
    }

    public String getSpellChecking() {
        return this.spellChecking;
    }

    private String intGetToolTipText(MouseEvent mouseEvent, boolean bl) {
        int n2;
        if (bl && this.spellChecking != null && this.spellChecking.length() > 0 && this.spellCheckingSpans != null && this.spellCheckingSpans.length > 0 && SpellChecker.isSupported()) {
            n2 = this.textComponent.viewToModel(mouseEvent.getPoint());
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < this.spellCheckingSpans.length; ++i2) {
                Span span = this.spellCheckingSpans[i2];
                if (n2 < span.getStart() || n2 >= span.getEnd()) continue;
                stringBuilder = new StringBuilder();
                stringBuilder.append("<html><b>");
                stringBuilder.append(span.getMessage());
                stringBuilder.append("</b>:<br>");
                stringBuilder.append(span.getDescription());
                List list = span.getReplacements();
                if (!list.isEmpty()) {
                    stringBuilder.append("<br><br><b>");
                    stringBuilder.append(Factory.getSysMsg("ef_spell_checking_correction"));
                    stringBuilder.append("</b>:<br>");
                    int n3 = 0;
                    ListIterator listIterator = list.listIterator();
                    while (listIterator.hasNext()) {
                        if (n3 > 0) {
                            stringBuilder.append(",");
                        }
                        stringBuilder.append(listIterator.next());
                        ++n3;
                    }
                }
                stringBuilder.append("</html>");
                break;
            }
            if (stringBuilder.length() > 0) {
                return stringBuilder.toString();
            }
        }
        for (n2 = 0; n2 < this.iconBounds.length; ++n2) {
            if (this.iconBounds[n2] == null || !this.iconBounds[n2].contains(mouseEvent.getPoint()) || this.iconHint[n2] == null || this.iconHint[n2].length() <= 0) continue;
            return this.iconHint[n2];
        }
        if (this.toolTipText != null && this.toolTipText.length() > 0) {
            return this.toolTipText;
        }
        return null;
    }

    public void setSpellChecking(String string) {
        String string2;
        String string3 = this.spellChecking;
        if (string3 == null) {
            string3 = "";
        }
        if ((string2 = string) == null) {
            string2 = "";
        }
        if (!string3.equals(string2)) {
            this.spellChecking = string;
            if (this.spellChecking.length() > 0 && SpellChecker.isSupported() && (this.textComponent instanceof SingleLineEntryFieldComponent || this.textComponent instanceof MultiLineEntryFieldComponent)) {
                this.spellCheckingTimer.restart(() -> this.spellCheck());
            } else {
                this.removeHighlights();
            }
        }
    }

    private void removeHighlights() {
        for (Highlighter.Highlight highlight : this.textComponent.getHighlighter().getHighlights()) {
            if (!(highlight.getPainter() instanceof SpellcheckerHighlightPainter)) continue;
            this.textComponent.getHighlighter().removeHighlight(highlight);
        }
    }

    private void updateHighlights() {
        this.removeHighlights();
        Highlighter highlighter = this.textComponent.getHighlighter();
        for (int i2 = 0; i2 < this.spellCheckingSpans.length; ++i2) {
            Span span = this.spellCheckingSpans[i2];
            if (span.getStart() == span.getEnd()) continue;
            try {
                if (span.getStart() >= span.getEnd()) continue;
                Color color = SpellChecker.MISSPELLING == span.getLocQualityIssueType() ? Color.red : Color.blue;
                SpellcheckerHighlightPainter spellcheckerHighlightPainter = new SpellcheckerHighlightPainter(null, color);
                highlighter.addHighlight(span.getStart(), span.getEnd(), spellcheckerHighlightPainter);
                continue;
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    private void spellCheck() {
        try {
            this.spellCheckingSpans = SpellChecker.check(this.textComponent.getText(), this.spellChecking);
            SwingUtilities.invokeLater(() -> this.updateHighlights());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setSpellCheckingDelay(int n2) {
        this.spellCheckingTimer.setDelay(n2);
    }

    public int getSpellCheckingDelay() {
        return this.spellCheckingTimer.getDelay();
    }

    public boolean isNoWrap() {
        return this.noWrap;
    }

    public void setNoWrap(boolean bl) {
        this.noWrap = bl;
        if (this.multiline) {
            ((MultiLineEntryFieldComponent)this.textComponent).setLineWrap(!this.noWrap);
            this.textScrollPane.setHorizontalScrollBarPolicy(this.noWrap ? 30 : 31);
        }
    }

    public int getUpperLowerMethod() {
        return this.upperLowerMethod;
    }

    public void setUpperLowerMethod(int n2) {
        this.upperLowerMethod = n2;
    }

    public boolean isDefaultShortcutsEnabled() {
        return this.defaultShortcutsEnabled;
    }

    public void setDefaultShortcutsEnabled(boolean bl) {
        if (this.defaultShortcutsEnabled != bl) {
            this.defaultShortcutsEnabled = bl;
            if (!this.defaultShortcutsEnabled) {
                RemoteBaseGUIControl.disableDefaultShortcuts(this.textComponent.getKeymap());
            }
        }
    }

    protected void setAcceptedControlCharacters(String string) {
        this.acceptedControlChars = string != null ? string.toCharArray() : null;
    }

    private boolean checkReplaceSelection(String string) {
        return !("\t".equals(string) && !this.useTab || "\n".equals(string) && !this.useReturn) && this.checkNumeric(string);
    }

    private boolean checkNumeric(String string) {
        if (this.numeric && string.length() > 0 && !EntryField.isDigit(string.charAt(0))) {
            if (this.msgBoxOnError && this.msgboxlistener != null) {
                this.msgboxlistener.sendMsgBox(new MsgBoxEvent(this, Factory.getSysMsg("ef_error_number"), ""));
            }
            return false;
        }
        return true;
    }

    public JComponent getDragDropComponent() {
        return this.textComponent;
    }

    public void setDragComponent(OutDragListener outDragListener) {
        if (this.textComponent != null) {
            if (outDragListener != null) {
                this.textComponent.setDropMode(DropMode.INSERT);
                this.textComponent.setDragEnabled(true);
                this.ftth = new FromToTransferHandler(outDragListener, 1);
                this.textComponent.setTransferHandler(this.ftth);
            } else {
                this.textComponent.setDragEnabled(false);
                if (this.ftth != null) {
                    this.textComponent.setTransferHandler(null);
                }
            }
        }
    }

    private static boolean hasInputFilter(EntryField entryField) {
        return entryField.inputFilter != null && entryField.inputFilter.length() > 0;
    }

    public void setInputFilter(String string) {
        if (this.inputFilter == null || !this.inputFilter.equals(string)) {
            this.inputFilter = string;
        }
    }

    private static boolean charInInputFilter(EntryField entryField, char c2) {
        boolean bl = false;
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(entryField.inputFilter);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return bl;
        }
        Matcher matcher = pattern.matcher("");
        matcher.reset(String.valueOf(c2));
        bl = matcher.find();
        return bl;
    }

    private static String checkInInputFilter(EntryField entryField, String string) {
        String string2 = "";
        if (string != null && string.length() > 0 && EntryField.hasInputFilter(entryField)) {
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                if (!EntryField.charInInputFilter(entryField, c2)) continue;
                string2 = string2 + c2;
            }
        } else {
            string2 = string;
        }
        return string2;
    }

    public void setMsgBoxListener(MsgBoxListener msgBoxListener) {
        this.msgboxlistener = msgBoxListener;
    }

    static /* synthetic */ int[][] access$102(EntryField entryField, int[][] nArray) {
        entryField.lineOffsets = nArray;
        return nArray;
    }

    private static class MyDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;
        private int byteLength;
        EntryField parent;

        MyDocument(EntryField entryField) {
            this.parent = entryField;
        }

        int length() {
            return this.parent != null && this.parent.encoding != null && this.parent.maxTextBytes ? this.byteLength : this.getLength();
        }

        int length(String string) {
            try {
                return this.parent != null && this.parent.encoding != null && this.parent.maxTextBytes ? string.getBytes(this.parent.encoding).length : string.length();
            }
            catch (Exception exception) {
                return string.length();
            }
        }

        String cut(String string, int n2) {
            if (this.parent != null && this.parent.encoding != null && this.parent.maxTextBytes) {
                int n3;
                int n4 = 0;
                for (n3 = 0; n3 < string.length(); ++n3) {
                    try {
                        n4 += Character.toString(string.charAt(n3)).getBytes(this.parent.encoding).length;
                    }
                    catch (Exception exception) {
                        ++n4;
                    }
                    if (n4 > n2) break;
                }
                return string.substring(0, n3);
            }
            return string.substring(0, n2);
        }

        @Override
        public void remove(int n2, int n3) throws BadLocationException {
            if (this.parent != null) {
                this.parent.fireEvents = true;
                if (this.parent.encoding != null && this.parent.maxTextBytes) {
                    try {
                        this.byteLength -= this.getText(n2, n3).getBytes(this.parent.encoding).length;
                    }
                    catch (Exception exception) {
                        this.byteLength -= n3;
                    }
                }
            }
            super.remove(n2, n3);
        }

        public void setAllText(String string, boolean bl) {
            this.parent.fireEvents = false;
            if (this.parent.undoListenerInstalled) {
                this.removeUndoableEditListener(this.parent.undoEditListener);
            }
            try {
                int n2;
                string = EntryField.checkInInputFilter(this.parent, string);
                if (this.parent.upper) {
                    string = Factory.toUpperCase(string, this.parent.upperLowerMethod);
                } else if (this.parent.lower) {
                    string = Factory.toLowerCase(string, this.parent.upperLowerMethod);
                }
                super.remove(0, this.getLength());
                super.insertString(0, string, null);
                if (bl && this.parent.maxLines > 0 && this.parent.getLineCount(true) > this.parent.maxLines && (n2 = this.parent.lineOffsets[this.parent.maxLines - 1][1]) < string.length()) {
                    string = string.substring(0, n2);
                    super.remove(0, this.getLength());
                    super.insertString(0, string, null);
                }
                if (this.parent.encoding != null && this.parent.maxTextBytes) {
                    try {
                        this.byteLength = string.getBytes(this.parent.encoding).length;
                    }
                    catch (Exception exception) {
                        this.byteLength = string.length();
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (this.parent.undoListenerInstalled) {
                this.addUndoableEditListener(this.parent.undoEditListener);
            }
        }

        @Override
        public void insertString(int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            if (this.parent != null) {
                if (this.parent.formatter == null) {
                    this.myinsertString(n2, string, attributeSet);
                } else {
                    if (this.parent.encoding != null && this.parent.maxTextBytes) {
                        try {
                            this.byteLength += string.getBytes(this.parent.encoding).length;
                        }
                        catch (Exception exception) {
                            this.byteLength += string.length();
                        }
                    }
                    super.insertString(n2, string, attributeSet);
                }
            } else {
                super.insertString(n2, string, attributeSet);
            }
        }

        private void myinsertString(int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            if (!this.parent.checkNumeric(string)) {
                return;
            }
            string = ((EntryFieldComponent)((Object)this.parent.textComponent)).check(string);
            if (this.parent.multiline && !eol.equals("\n")) {
                String string2 = this.parent.textComponent.getText();
                if (n2 - 1 >= 0 && string2.lastIndexOf(eol) == n2 - 1) {
                    --n2;
                }
            }
            if (string == null) {
                Toolkit.getDefaultToolkit().beep();
                throw new BadLocationException(string, n2);
            }
            string = EntryField.checkInInputFilter(this.parent, string);
            if (this.parent.upper) {
                string = Factory.toUpperCase(string, this.parent.upperLowerMethod);
            } else if (this.parent.lower) {
                string = Factory.toLowerCase(string, this.parent.upperLowerMethod);
            }
            if (this.parent.multiline && this.parent.maxLines > 0) {
                this.parent.fireEvents = false;
                if (this.parent.undoListenerInstalled) {
                    this.removeUndoableEditListener(this.parent.undoEditListener);
                }
                super.insertString(n2, string, attributeSet);
                int n3 = this.parent.getLineCount();
                super.remove(n2, string.length());
                this.parent.fireEvents = true;
                if (this.parent.undoListenerInstalled) {
                    this.addUndoableEditListener(this.parent.undoEditListener);
                }
                if (n3 > this.parent.maxLines) {
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    super.insertString(n2, string, attributeSet);
                    if (this.parent.encoding != null && this.parent.maxTextBytes) {
                        try {
                            this.byteLength += string.getBytes(this.parent.encoding).length;
                        }
                        catch (Exception exception) {
                            this.byteLength += string.length();
                        }
                    }
                }
            } else {
                this.parent.fireEvents = true;
                if (this.parent.encoding != null && this.parent.maxTextBytes) {
                    try {
                        this.byteLength += string.getBytes(this.parent.encoding).length;
                    }
                    catch (Exception exception) {
                        this.byteLength += string.length();
                    }
                }
                super.insertString(n2, string, attributeSet);
            }
        }
    }

    private static class FormattedEntryFieldComponent
    extends JFormattedTextField
    implements PicobolWidget,
    EntryFieldComponent {
        private static final long serialVersionUID = 1L;
        private static final char DIGIT_KEY = '#';
        private static final char LITERAL_KEY = '\'';
        private static final char UPPERCASE_KEY = 'U';
        private static final char LOWERCASE_KEY = 'L';
        private static final char ALPHA_NUMERIC_KEY = 'A';
        private static final char CHARACTER_KEY = '?';
        private static final char ANYTHING_KEY = '*';
        private static final char HEX_KEY = 'H';
        private boolean activate;
        private int idxlasteditchar = -1;
        EntryField parent;

        FormattedEntryFieldComponent(EntryField entryField) {
            this.parent = entryField;
        }

        @Override
        public void setFormatter(JFormattedTextField.AbstractFormatter abstractFormatter) {
            if (this.parent != null && this.parent.undoListenerInstalled) {
                this.getDocument().removeUndoableEditListener(this.parent.undoEditListener);
            }
            try {
                super.setFormatter(abstractFormatter);
            }
            catch (Exception exception) {
            }
            finally {
                if (this.parent != null && this.parent.undoListenerInstalled) {
                    this.getDocument().addUndoableEditListener(this.parent.undoEditListener);
                }
            }
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            return this.parent.intGetToolTipText(mouseEvent, false);
        }

        @Override
        public void cut() {
            if (this.isEditable()) {
                super.cut();
            }
        }

        @Override
        public void paste() {
            if (this.parent != null) {
                this.parent.intPaste();
            } else {
                super.paste();
            }
        }

        @Override
        public String check(String string) {
            return string;
        }

        @Override
        protected void processEvent(AWTEvent aWTEvent) {
            if (this.parent == null || this.parent.intProcessEvent(aWTEvent, this.activate)) {
                super.processEvent(aWTEvent);
            }
        }

        @Override
        public boolean getActiveAccept() {
            return this.activate;
        }

        @Override
        public boolean getSelfAct() {
            return false;
        }

        @Override
        public Color getBackground() {
            if (this.parent != null) {
                return this.mygetBackground();
            }
            return super.getBackground();
        }

        private Color mygetBackground() {
            if (this.isEnabled()) {
                if (this.isEditable()) {
                    return super.getBackground();
                }
                if (this.parent.getReadOnlyBackground() != null) {
                    return this.parent.getReadOnlyBackground();
                }
                return super.getBackground();
            }
            if (this.parent.getDisabledBackground() != null) {
                return this.parent.getDisabledBackground();
            }
            return super.getBackground();
        }

        @Override
        public Color getForeground() {
            if (this.parent != null) {
                return this.mygetForeground();
            }
            return super.getForeground();
        }

        private Color mygetForeground() {
            if (this.isEnabled()) {
                if (this.isEditable()) {
                    return super.getForeground();
                }
                if (this.parent.getReadOnlyForeground() != null) {
                    return this.parent.getReadOnlyForeground();
                }
                return super.getForeground();
            }
            if (this.parent.getDisabledForeground() != null) {
                return this.parent.getDisabledForeground();
            }
            return super.getForeground();
        }

        @Override
        public Color getDisabledTextColor() {
            if (this.parent != null) {
                return this.mygetDisabledTextColor();
            }
            return super.getDisabledTextColor();
        }

        private Color mygetDisabledTextColor() {
            if (this.parent.getDisabledForeground() != null) {
                return this.parent.getDisabledForeground();
            }
            return super.getDisabledTextColor();
        }

        @Override
        public void setActiveAccept(boolean bl) {
            this.activate = bl;
        }

        @Override
        public void asyncProcessEvent(AWTEvent aWTEvent) {
        }

        @Override
        public void setSelfAct(boolean bl) {
        }

        @Override
        public void replaceSelection(String string) {
            if (this.parent != null) {
                if (this.parent.checkReplaceSelection(string)) {
                    super.replaceSelection(string);
                    if (this.parent.auto && this.parent.formatter instanceof MaskFormatter && this.getCaretPosition() > this.idxlasteditchar && this.getSelectedText() == null) {
                        PicobolTextEvent picobolTextEvent = new PicobolTextEvent(this.parent.textComponent, 2202);
                        for (PicobolTextListener picobolTextListener : this.parent.textListeners) {
                            picobolTextListener.inputTerminated(picobolTextEvent);
                        }
                    }
                }
            } else {
                super.replaceSelection(string);
            }
        }

        public void setMaxText() {
            String string = ((MaskFormatter)this.parent.formatter).getMask();
            if (string != null) {
                int n2 = string.length();
                this.idxlasteditchar = -1;
                for (int i2 = 0; i2 < this.parent.maxText && i2 < n2; ++i2) {
                    if (string.charAt(i2) != '#' && string.charAt(i2) != '\'' && string.charAt(i2) != 'U' && string.charAt(i2) != 'L' && string.charAt(i2) != 'A' && string.charAt(i2) != '?' && string.charAt(i2) != '*' && string.charAt(i2) != 'H') continue;
                    this.idxlasteditchar = i2;
                }
            }
        }

        public void setMask(String string) {
            try {
                ((MaskFormatter)this.parent.formatter).setMask(string);
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
            if (string != null) {
                int n2 = string.length();
                this.idxlasteditchar = -1;
                for (int i2 = n2 - 1; this.idxlasteditchar == -1 && i2 >= 0; --i2) {
                    if (string.charAt(i2) != '#' && string.charAt(i2) != '\'' && string.charAt(i2) != 'U' && string.charAt(i2) != 'L' && string.charAt(i2) != 'A' && string.charAt(i2) != '?' && string.charAt(i2) != '*' && string.charAt(i2) != 'H') continue;
                    this.idxlasteditchar = i2;
                }
            }
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            this.parent.intPaintComponent(this, graphics);
        }
    }

    private static class PasswordFieldComponent
    extends JPasswordField
    implements PicobolWidget,
    EntryFieldComponent {
        private static final long serialVersionUID = 1L;
        private boolean activate;
        EntryField parent;

        public PasswordFieldComponent(EntryField entryField, int n2) {
            super(n2);
            this.enableInputMethods(true);
            this.parent = entryField;
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            return this.parent.intGetToolTipText(mouseEvent, false);
        }

        @Override
        public Color getDisabledTextColor() {
            if (this.parent != null) {
                return this.mygetDisabledTextColor();
            }
            return super.getDisabledTextColor();
        }

        private Color mygetDisabledTextColor() {
            if (this.parent.getDisabledForeground() != null) {
                return this.parent.getDisabledForeground();
            }
            return super.getDisabledTextColor();
        }

        @Override
        public Color getBackground() {
            if (this.parent != null) {
                return this.mygetBackground();
            }
            return super.getBackground();
        }

        private Color mygetBackground() {
            if (this.isEnabled()) {
                if (this.isEditable()) {
                    return super.getBackground();
                }
                if (this.parent.getReadOnlyBackground() != null) {
                    return this.parent.getReadOnlyBackground();
                }
                return super.getBackground();
            }
            if (this.parent.getDisabledBackground() != null) {
                return this.parent.getDisabledBackground();
            }
            return super.getBackground();
        }

        @Override
        public Color getForeground() {
            if (this.parent != null) {
                return this.mygetForeground();
            }
            return super.getForeground();
        }

        private Color mygetForeground() {
            if (this.isEnabled()) {
                if (this.isEditable()) {
                    return super.getForeground();
                }
                if (this.parent.getReadOnlyForeground() != null) {
                    return this.parent.getReadOnlyForeground();
                }
                return super.getForeground();
            }
            if (this.parent.getDisabledForeground() != null) {
                return this.parent.getDisabledForeground();
            }
            return super.getForeground();
        }

        @Override
        public String check(String string) {
            int n2;
            MyDocument myDocument = (MyDocument)this.getDocument();
            int n3 = myDocument.length();
            int n4 = myDocument.length(string);
            if (n4 == 0) {
                return string;
            }
            char c2 = string.charAt(0);
            if (c2 == '\t' && !this.parent.useTab || c2 == '\n' && !this.parent.useReturn) {
                return null;
            }
            if (this.parent.numeric && !EntryField.isDigit(c2)) {
                return null;
            }
            if (this.parent.hasSelection()) {
                return string;
            }
            if (this.parent.maxText > 0 && (n2 = n3 + n4 - this.parent.maxText) > 0 && (n2 >= n4 || (string = myDocument.cut(string, n4 - n2)).length() == 0)) {
                return null;
            }
            return string;
        }

        @Override
        protected void processEvent(AWTEvent aWTEvent) {
            if (this.parent == null || this.parent.intProcessEvent(aWTEvent, this.activate)) {
                super.processEvent(aWTEvent);
            }
        }

        private String GetText() {
            return ((JTextComponent)this).getText();
        }

        @Override
        public void replaceSelection(String string) {
            if (this.parent == null || this.parent.checkReplaceSelection(string)) {
                super.replaceSelection(string);
            }
        }

        @Override
        public void paste() {
            if (this.parent != null) {
                this.parent.intPaste();
            } else {
                super.paste();
            }
        }

        @Override
        public boolean getActiveAccept() {
            return this.activate;
        }

        @Override
        public boolean getSelfAct() {
            return false;
        }

        @Override
        public void setActiveAccept(boolean bl) {
            this.activate = bl;
        }

        @Override
        public void asyncProcessEvent(AWTEvent aWTEvent) {
        }

        @Override
        public void setSelfAct(boolean bl) {
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            this.parent.intPaintComponent(this, graphics);
        }
    }

    private static class SingleLineEntryFieldComponent
    extends JTextField
    implements PicobolWidget,
    EntryFieldComponent {
        private static final long serialVersionUID = 1L;
        private boolean activate;
        EntryField parent;

        public SingleLineEntryFieldComponent(EntryField entryField, int n2) {
            super(n2);
            this.enableInputMethods(true);
            this.parent = entryField;
        }

        @Override
        public void setBorder(Border border) {
            super.setBorder(border);
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            return this.parent.intGetToolTipText(mouseEvent, this.parent.spinner == null);
        }

        @Override
        public Color getDisabledTextColor() {
            if (this.parent != null) {
                return this.mygetDisabledTextColor();
            }
            return super.getDisabledTextColor();
        }

        private Color mygetDisabledTextColor() {
            if (this.parent.getDisabledForeground() != null) {
                return this.parent.getDisabledForeground();
            }
            return super.getDisabledTextColor();
        }

        @Override
        public Color getBackground() {
            if (this.parent != null) {
                return this.mygetBackground();
            }
            return super.getBackground();
        }

        private Color mygetBackground() {
            if (this.isEnabled()) {
                if (this.isEditable()) {
                    return super.getBackground();
                }
                if (this.parent.getReadOnlyBackground() != null) {
                    return this.parent.getReadOnlyBackground();
                }
                return super.getBackground();
            }
            if (this.parent.getDisabledBackground() != null) {
                return this.parent.getDisabledBackground();
            }
            return super.getBackground();
        }

        @Override
        public Color getForeground() {
            if (this.parent != null) {
                return this.mygetForeground();
            }
            return super.getForeground();
        }

        private Color mygetForeground() {
            if (this.isEnabled()) {
                if (this.isEditable()) {
                    return super.getForeground();
                }
                if (this.parent.getReadOnlyForeground() != null) {
                    return this.parent.getReadOnlyForeground();
                }
                return super.getForeground();
            }
            if (this.parent.getDisabledForeground() != null) {
                return this.parent.getDisabledForeground();
            }
            return super.getForeground();
        }

        @Override
        public String check(String string) {
            int n2;
            MyDocument myDocument = (MyDocument)this.getDocument();
            int n3 = myDocument.length();
            int n4 = myDocument.length(string);
            if (n4 == 0) {
                return string;
            }
            char c2 = string.charAt(0);
            if (c2 == '\t' && !this.parent.useTab || c2 == '\n' && !this.parent.useReturn) {
                return null;
            }
            int n5 = -1;
            n5 = string.indexOf(13);
            if (n5 >= 0 || (n5 = string.indexOf(10)) >= 0) {
                string = string.substring(0, n5);
                n4 = myDocument.length(string);
            }
            if (this.parent.numeric && !EntryField.isDigit(c2)) {
                return null;
            }
            if (this.parent.hasSelection()) {
                return string;
            }
            if (this.parent.maxText > 0 && (n2 = n3 + n4 - this.parent.maxText) > 0 && (n2 >= n4 || (string = myDocument.cut(string, n4 - n2)).length() == 0)) {
                return null;
            }
            return string;
        }

        @Override
        protected void processEvent(AWTEvent aWTEvent) {
            if (this.parent == null || this.parent.intProcessEvent(aWTEvent, this.activate)) {
                super.processEvent(aWTEvent);
            }
        }

        private String GetText() {
            return this.getText();
        }

        @Override
        public void replaceSelection(String string) {
            if (this.parent == null || this.parent.checkReplaceSelection(string)) {
                super.replaceSelection(string);
            }
        }

        @Override
        public void paste() {
            if (this.parent != null) {
                this.parent.intPaste();
            } else {
                super.paste();
            }
        }

        @Override
        public void cut() {
            if (this.isEditable()) {
                super.cut();
            }
        }

        @Override
        public boolean getActiveAccept() {
            return this.activate;
        }

        @Override
        public boolean getSelfAct() {
            return false;
        }

        @Override
        public void setActiveAccept(boolean bl) {
            this.activate = bl;
        }

        @Override
        public void asyncProcessEvent(AWTEvent aWTEvent) {
        }

        @Override
        public void setSelfAct(boolean bl) {
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            try {
                super.paintComponent(graphics);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.parent.intPaintComponent(this, graphics);
        }
    }

    private static class MultiLineEntryFieldComponent
    extends JTextArea
    implements PicobolWidget,
    EntryFieldComponent {
        private static final long serialVersionUID = 1L;
        private boolean activate;
        EntryField parent;
        private boolean usereturntmp = false;

        public MultiLineEntryFieldComponent(EntryField entryField, String string, int n2, int n3) {
            super(string, n2, n3);
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.parent = entryField;
        }

        @Override
        public void setBounds(int n2, int n3, int n4, int n5) {
            super.setBounds(n2, n3, n4, n5);
            if (this.parent != null && this.parent.maxLines > 0 && this.getLineCount(true) > this.parent.maxLines) {
                String string = this.getText();
                int n6 = this.parent.lineOffsets[this.parent.maxLines - 1][1];
                if (n6 < string.length()) {
                    string = string.substring(0, n6);
                    this.parent.textDocument.setAllText(string, false);
                }
            }
        }

        @Override
        public void replaceSelection(String string) {
            if (this.parent == null || this.parent.checkReplaceSelection(string)) {
                super.replaceSelection(string);
            }
        }

        @Override
        public String check(String string) {
            int n2;
            MyDocument myDocument = (MyDocument)this.getDocument();
            int n3 = myDocument.length(string);
            if (n3 == 0) {
                return string;
            }
            char c2 = string.charAt(0);
            if (c2 == '\t' && !this.parent.useTab || c2 == '\n' && !this.parent.useReturn) {
                return null;
            }
            if (this.parent.numeric && !Character.isDigit(c2) && c2 != '\n') {
                return null;
            }
            if (this.parent.hasSelection()) {
                return string;
            }
            int n4 = myDocument.getLength();
            if (this.parent.maxText > 0 && (n2 = n4 + n3 - this.parent.maxText) > 0 && (n2 >= n3 || (string = myDocument.cut(string, n3 - n2)).length() == 0)) {
                return null;
            }
            return string;
        }

        @Override
        protected void processEvent(AWTEvent aWTEvent) {
            boolean bl = false;
            if (this.parent == null || this.parent.intProcessEvent(aWTEvent, this.activate)) {
                KeyEvent keyEvent;
                if (aWTEvent instanceof KeyEvent && (keyEvent = (KeyEvent)aWTEvent).getID() == 401 && keyEvent.getKeyCode() == 10 && keyEvent.isControlDown() && !this.parent.useReturn) {
                    this.usereturntmp = true;
                    this.parent.useReturn = true;
                    char c2 = '\n';
                    long l2 = System.currentTimeMillis();
                    super.processEvent(new KeyEvent((Component)aWTEvent.getSource(), 401, System.currentTimeMillis(), 0, keyEvent.getKeyCode(), c2));
                    this.usereturntmp = false;
                    this.parent.useReturn = false;
                    return;
                }
                super.processEvent(aWTEvent);
            }
        }

        @Override
        public void cut() {
            if (this.isEditable()) {
                super.cut();
            }
        }

        @Override
        public void paste() {
            if (this.parent != null) {
                this.parent.intPaste();
            } else {
                super.paste();
            }
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            return this.parent.intGetToolTipText(mouseEvent, true);
        }

        @Override
        public boolean getActiveAccept() {
            return this.activate;
        }

        @Override
        public boolean getSelfAct() {
            return false;
        }

        @Override
        public void setActiveAccept(boolean bl) {
            this.activate = bl;
        }

        @Override
        public void asyncProcessEvent(AWTEvent aWTEvent) {
        }

        @Override
        public void setSelfAct(boolean bl) {
        }

        @Override
        public int getLineCount() {
            return this.getLineCount(false);
        }

        @Override
        public Color getBackground() {
            if (this.parent != null) {
                return this.mygetBackground();
            }
            return super.getBackground();
        }

        private Color mygetBackground() {
            if (this.isEnabled()) {
                if (this.isEditable()) {
                    return super.getBackground();
                }
                if (this.parent.getReadOnlyBackground() != null) {
                    return this.parent.getReadOnlyBackground();
                }
                if (this.parent.background != null) {
                    return this.parent.background;
                }
                Color color = UIManager.getColor("TextField.inactiveBackground");
                if (color == null) {
                    color = super.getBackground();
                }
                return color;
            }
            if (this.parent.getDisabledBackground() != null) {
                return this.parent.getDisabledBackground();
            }
            if (this.isEditable()) {
                return super.getBackground();
            }
            if (this.parent.background != null) {
                return this.parent.background;
            }
            Color color = UIManager.getColor("TextField.inactiveBackground");
            if (color == null) {
                color = super.getBackground();
            }
            return color;
        }

        @Override
        public Color getDisabledTextColor() {
            if (this.parent != null) {
                return this.mygetDisabledTextColor();
            }
            return super.getDisabledTextColor();
        }

        private Color mygetDisabledTextColor() {
            if (this.parent.getDisabledForeground() != null) {
                return this.parent.getDisabledForeground();
            }
            return super.getDisabledTextColor();
        }

        @Override
        public Color getForeground() {
            if (this.parent != null) {
                return this.mygetForeground();
            }
            return super.getForeground();
        }

        private Color mygetForeground() {
            if (this.isEnabled()) {
                if (this.isEditable()) {
                    return super.getForeground();
                }
                if (this.parent.getReadOnlyForeground() != null) {
                    return this.parent.getReadOnlyForeground();
                }
                return super.getForeground();
            }
            if (this.parent.getDisabledForeground() != null) {
                return this.parent.getDisabledForeground();
            }
            return super.getForeground();
        }

        private int getLineCount(boolean bl) {
            Vector<int[]> vector = null;
            if (bl) {
                vector = new Vector<int[]>();
            }
            int n2 = 0;
            int n3 = 0;
            int n4 = this.getDocument().getLength();
            int n5 = 0;
            try {
                while (n3 <= n4 && (n5 = Utilities.getRowEnd(this, n3)) >= 0) {
                    ++n2;
                    if (bl) {
                        vector.addElement(new int[]{n3, n5});
                    }
                    n3 = n5 + 1;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (bl) {
                EntryField.access$102(this.parent, new int[n2][2]);
                vector.toArray((T[])this.parent.lineOffsets);
                if (n2 > 0) {
                    int[] nArray = this.parent.lineOffsets[n2 - 1];
                    nArray[1] = nArray[1] + 1;
                }
            }
            return n2;
        }

        @Override
        public int getLineStartOffset(int n2) throws BadLocationException {
            if (this.parent != null) {
                int n3 = this.getLineCount(true);
                if (n2 < n3) {
                    return this.parent.lineOffsets[n2][0];
                }
                return -1;
            }
            return super.getLineStartOffset(n2);
        }

        @Override
        public int getLineEndOffset(int n2) throws BadLocationException {
            if (this.parent != null) {
                int n3 = this.getLineCount(true);
                if (n2 < n3) {
                    return this.parent.lineOffsets[n2][1];
                }
                return -1;
            }
            return super.getLineEndOffset(n2);
        }

        public int[][] getLineOffsets() {
            this.getLineCount(true);
            return this.parent.lineOffsets;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            this.parent.intPaintComponent(this, graphics);
        }
    }

    private static class MyTimer
    extends Timer {
        private static final long serialVersionUID = 1L;
        Runnable run;

        MyTimer(int n2) {
            super(n2, null);
            this.setRepeats(false);
            this.addActionListener(actionEvent -> {
                if (this.run != null) {
                    this.run.run();
                }
            });
        }

        void restart(Runnable runnable) {
            this.run = runnable;
            super.restart();
        }
    }

    private static class SpellcheckerHighlightPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        private static final BasicStroke OO_STROKE1 = new BasicStroke(1.0f, 1, 1, 10.0f, new float[]{3.0f, 5.0f}, 2.0f);
        private static final BasicStroke OO_STROKE2 = new BasicStroke(1.0f, 1, 1, 10.0f, new float[]{1.0f, 3.0f}, 3.0f);
        private static final BasicStroke OO_STROKE3 = new BasicStroke(1.0f, 1, 1, 10.0f, new float[]{3.0f, 5.0f}, 6.0f);
        private static final BasicStroke ZIGZAG_STROKE1 = new BasicStroke(1.0f, 1, 1, 10.0f, new float[]{1.0f, 1.0f}, 0.0f);
        private final Color underlineColor;
        private final Color backgroundColor;

        SpellcheckerHighlightPainter(Color color, Color color2) {
            super(color);
            this.backgroundColor = color;
            this.underlineColor = color2;
        }

        @Override
        public Shape paintLayer(Graphics graphics, int n2, int n3, Shape shape, JTextComponent jTextComponent, View view) {
            Object object;
            Rectangle rectangle;
            if (this.backgroundColor != null) {
                super.paintLayer(graphics, n2, n3, shape, jTextComponent, view);
            }
            if (n2 == view.getStartOffset() && n3 == view.getEndOffset()) {
                rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            } else {
                try {
                    object = view.modelToView(n2, Position.Bias.Forward, n3, Position.Bias.Backward, shape);
                    rectangle = object instanceof Rectangle ? (Rectangle)object : object.getBounds();
                }
                catch (BadLocationException badLocationException) {
                    rectangle = null;
                }
            }
            if (rectangle != null) {
                object = this.underlineColor;
                if (object == null) {
                    graphics.setColor(jTextComponent.getSelectionColor());
                } else {
                    graphics.setColor((Color)object);
                }
                rectangle.width = Math.max(rectangle.width, 1);
                int n4 = jTextComponent.getFontMetrics(jTextComponent.getFont()).getDescent();
                if (n4 > 3) {
                    this.drawCurvedLine(graphics, rectangle);
                } else if (n4 > 2) {
                    this.drawCurvedLine(graphics, rectangle);
                } else {
                    this.drawLine(graphics, rectangle);
                }
            }
            return rectangle;
        }

        private void drawCurvedLine(Graphics graphics, Rectangle rectangle) {
            int n2 = rectangle.x;
            int n3 = rectangle.x + rectangle.width;
            int n4 = rectangle.y + rectangle.height;
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setStroke(OO_STROKE1);
            graphics2D.drawLine(n2, n4 - 1, n3, n4 - 1);
            graphics2D.setStroke(OO_STROKE2);
            graphics2D.drawLine(n2, n4 - 2, n3, n4 - 2);
            graphics2D.setStroke(OO_STROKE3);
            graphics2D.drawLine(n2, n4 - 3, n3, n4 - 3);
        }

        private void drawLine(Graphics graphics, Rectangle rectangle) {
            int n2 = rectangle.x;
            int n3 = rectangle.x + rectangle.width;
            int n4 = rectangle.y + rectangle.height;
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setStroke(ZIGZAG_STROKE1);
            graphics2D.drawLine(n2, n4 - 1, n3, n4 - 1);
        }
    }

    private static interface EntryFieldComponent {
        public String check(String var1);
    }
}

