/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.client.swing.ChipsBoxElement;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

class Etichetta
extends JLabel
implements MouseListener {
    ImageIcon x1;
    ImageIcon x2;
    JPanel p;
    Image transparentImg;
    ChipsBoxElement parent;
    Image mouseentered;
    Image mouseexited;

    Etichetta(ChipsBoxElement chipsBoxElement, JPanel jPanel, Image image, Image image2) {
        this.p = jPanel;
        this.parent = chipsBoxElement;
        this.mouseentered = image;
        this.mouseexited = image2;
        this.x1 = image != null ? new ImageIcon(image) : new ImageIcon(this.getClass().getResource("x1up.png"), "x");
        this.x2 = image2 != null ? new ImageIcon(image2) : new ImageIcon(this.getClass().getResource("x1down.png"), "x");
        int n2 = this.x2.getIconWidth();
        int n3 = this.x2.getIconHeight();
        if (this.x1.getIconWidth() > n2) {
            n2 = this.x1.getIconWidth();
        }
        if (this.x1.getIconHeight() > n3) {
            n3 = this.x1.getIconHeight();
        }
        Dimension dimension = new Dimension(n2, n3);
        RGBImageFilter rGBImageFilter = new RGBImageFilter(){
            int transparentColor = Color.white.getRGB() | 0xFF000000;

            @Override
            public final int filterRGB(int n2, int n3, int n4) {
                if ((n4 | 0xFF000000) == this.transparentColor) {
                    return 0xFFFFFF & n4;
                }
                return n4;
            }
        };
        FilteredImageSource filteredImageSource = new FilteredImageSource(this.x2.getImage().getSource(), rGBImageFilter);
        this.transparentImg = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
        this.setIcon(new ImageIcon(this.transparentImg));
        this.setPreferredSize(dimension);
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.setSize(dimension);
        this.setLayout(null);
        this.addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.parent.sendClose();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.parent.sendmousePressed(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.parent.setMouseentered(true);
        this.setIcon(this.x1);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.parent.setMouseentered(false);
        this.setIcon(new ImageIcon(this.transparentImg));
    }

    public ImageIcon createImageIcon(String string) {
        URL uRL = this.getClass().getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        return null;
    }
}

