/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.swing.GridCell;
import com.iscobol.gui.client.swing.GridConstant;
import com.iscobol.gui.client.swing.GridViewS;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.rts.Factory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class FilterJPanel
extends JPanel
implements GridConstant {
    private static final long serialVersionUID = 124L;
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private int numcolmodel;
    private JPanel panelbutton;
    private JList list;
    private JButton filterok;
    private JButton close;
    private FilterListener listener;
    private CheckBoxListEntry cbMenuItem = null;
    private CheckBoxListEntry filterall = null;
    private CheckBoxListEntry[] filtercb = null;
    private boolean[] filtercbsaved = null;
    private Object[] distinctValues = null;
    private GridCell agc = null;
    private Vector objectshidden = null;
    private int filtertype = 0;
    private GuiFactoryImpl gf;
    private JScrollPane listScroller = null;

    public FilterJPanel(GuiFactoryImpl guiFactoryImpl, int n2, GridCell gridCell, int n3) {
        this.numcolmodel = n2;
        this.agc = gridCell;
        this.filtertype = n3;
        this.gf = guiFactoryImpl;
    }

    public void init() {
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    if (FilterJPanel.this.filtertype == 2) {
                        FilterJPanel.this.restoreCbSaved();
                        FilterJPanel.this.listener.exitFilterJPanel(FilterJPanel.this.numcolmodel, false);
                    } else {
                        FilterJPanel.this.responseOnAction(true);
                    }
                }
            }
        };
        this.setLayout(new BorderLayout());
        this.panelbutton = new JPanel();
        SpringLayout springLayout = new SpringLayout();
        this.panelbutton.setLayout(springLayout);
        this.panelbutton.setPreferredSize(new Dimension(200, 50));
        this.list = new JList();
        this.list.setModel(new DefaultListModel());
        this.list.setCellRenderer(new CheckboxCellRenderer());
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Object e2;
                int n2 = FilterJPanel.this.list.locationToIndex(mouseEvent.getPoint());
                if (n2 != -1 && (e2 = FilterJPanel.this.list.getModel().getElementAt(n2)) instanceof JCheckBox) {
                    JCheckBox jCheckBox;
                    jCheckBox.setSelected(!(jCheckBox = (JCheckBox)e2).isSelected());
                    if (jCheckBox == FilterJPanel.this.filterall) {
                        FilterJPanel.this.selectall(jCheckBox.isSelected());
                    } else if (jCheckBox.isSelected() && FilterJPanel.this.isAllSelected()) {
                        FilterJPanel.this.filterall.setSelected(true);
                    } else {
                        FilterJPanel.this.filterall.setSelected(false);
                    }
                    if (!jCheckBox.isSelected() && FilterJPanel.this.isAllDeselected()) {
                        FilterJPanel.this.filterok.setEnabled(false);
                    } else {
                        FilterJPanel.this.filterok.setEnabled(true);
                    }
                    FilterJPanel.this.repaint();
                }
            }
        });
        this.list.setSelectionMode(0);
        this.loadlist();
        this.listScroller = new JScrollPane(this.list);
        this.listScroller.setAlignmentX(0.0f);
        String string = this.gf.getMessages().getMessage("ok");
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = ScreenUtility.getMnemonicChar(stringBuffer);
        string = stringBuffer.toString();
        this.filterok = new JButton(string);
        this.filterok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FilterJPanel.this.responseOnAction();
                if (FilterJPanel.this.listener != null) {
                    FilterJPanel.this.listener.sendfinishfiltermsg();
                }
            }
        });
        string = this.gf.getMessages().getMessage("cancel");
        stringBuffer = new StringBuffer(string);
        n2 = ScreenUtility.getMnemonicChar(stringBuffer);
        string = stringBuffer.toString();
        this.close = new JButton(string);
        this.close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (FilterJPanel.this.filtertype == 2) {
                    FilterJPanel.this.restoreCbSaved();
                    if (FilterJPanel.this.listener != null) {
                        FilterJPanel.this.listener.exitFilterJPanel(FilterJPanel.this.numcolmodel, false);
                    }
                } else {
                    FilterJPanel.this.responseOnAction(true);
                }
            }
        });
        this.filterok.setMnemonic('f');
        this.close.setMnemonic('c');
        this.panelbutton.add(this.filterok);
        this.panelbutton.add(this.close);
        this.add((Component)this.listScroller, "Center");
        this.add((Component)this.panelbutton, "South");
        this.filterok.addKeyListener(keyAdapter);
        this.close.addKeyListener(keyAdapter);
        springLayout.putConstraint("East", (Component)this.close, -2, "East", (Component)this.panelbutton);
        springLayout.putConstraint("South", (Component)this.close, -2, "South", (Component)this.panelbutton);
        springLayout.putConstraint("North", (Component)this.filterok, 0, "North", (Component)this.close);
        springLayout.putConstraint("East", (Component)this.filterok, -2, "West", (Component)this.close);
    }

    public void loadlist() {
        if (this.distinctValues != null) {
            ((DefaultListModel)this.list.getModel()).clear();
        }
        if ((this.distinctValues = this.listener.getDistinctValues(this.numcolmodel)) == null) {
            return;
        }
        this.filtercb = new CheckBoxListEntry[this.distinctValues.length];
        this.filtercbsaved = new boolean[this.distinctValues.length];
        if (this.distinctValues.length > 0) {
            GridViewS.FilterElement filterElement = null;
            this.filterall = this.cbMenuItem = new CheckBoxListEntry(Factory.getSysMsg("All"), null);
            ((DefaultListModel)this.list.getModel()).addElement(this.cbMenuItem);
            this.filterall.setSelected(true);
            String string = "";
            int n2 = 0;
            for (int i2 = 0; i2 < this.distinctValues.length; ++i2) {
                filterElement = (GridViewS.FilterElement)this.distinctValues[i2];
                string = filterElement.text;
                this.filtercb[i2] = this.cbMenuItem = new CheckBoxListEntry(string, filterElement.correspondingtext);
                this.filtercbsaved[i2] = filterElement.state;
                this.cbMenuItem.setSelected(filterElement.state);
                if (!filterElement.visible) {
                    this.cbMenuItem.setForeground(Color.red);
                } else {
                    if (filterElement.state) {
                        ++n2;
                    }
                    ((DefaultListModel)this.list.getModel()).addElement(this.cbMenuItem);
                }
                this.cbMenuItem.setVisible(filterElement.visible);
            }
            this.filterall.setSelected(n2 == this.distinctValues.length);
        }
    }

    private void selectall(boolean bl) {
        CheckBoxListEntry checkBoxListEntry = null;
        for (int i2 = 0; i2 < this.filtercb.length; ++i2) {
            checkBoxListEntry = this.filtercb[i2];
            if (checkBoxListEntry == null) continue;
            checkBoxListEntry.setSelected(bl);
        }
    }

    private void visibleall(boolean bl) {
        CheckBoxListEntry checkBoxListEntry = null;
        for (int i2 = 0; i2 < this.filtercb.length; ++i2) {
            checkBoxListEntry = this.filtercb[i2];
            if (checkBoxListEntry == null) continue;
            checkBoxListEntry.setVisible(bl);
        }
    }

    public boolean isAllSelected() {
        boolean bl = true;
        CheckBoxListEntry checkBoxListEntry = null;
        for (int i2 = 0; bl && i2 < this.filtercb.length; ++i2) {
            checkBoxListEntry = this.filtercb[i2];
            if (checkBoxListEntry == null || checkBoxListEntry == this.filterall) continue;
            bl = checkBoxListEntry.isSelected();
        }
        return bl;
    }

    private boolean isAllDeselected() {
        boolean bl = false;
        CheckBoxListEntry checkBoxListEntry = null;
        for (int i2 = 0; !bl && i2 < this.filtercb.length; ++i2) {
            checkBoxListEntry = this.filtercb[i2];
            if (checkBoxListEntry == null) continue;
            bl = checkBoxListEntry.isSelected();
        }
        return !bl;
    }

    private boolean changed() {
        boolean bl = false;
        if (this.filtercb == null && this.filtercbsaved == null) {
            return bl;
        }
        if (this.filtercb.length != this.filtercbsaved.length) {
            bl = true;
        } else {
            CheckBoxListEntry checkBoxListEntry = null;
            boolean bl2 = false;
            for (int i2 = 0; !bl && i2 < this.filtercb.length; ++i2) {
                checkBoxListEntry = this.filtercb[i2];
                bl2 = this.filtercbsaved[i2];
                if (checkBoxListEntry == null || !checkBoxListEntry.isVisible() || checkBoxListEntry.isSelected() == bl2) continue;
                bl = true;
            }
        }
        return bl;
    }

    public void restoreCbSaved() {
        CheckBoxListEntry checkBoxListEntry = null;
        boolean bl = false;
        boolean bl2 = true;
        for (int i2 = 0; i2 < this.filtercb.length; ++i2) {
            checkBoxListEntry = this.filtercb[i2];
            bl = this.filtercbsaved[i2];
            checkBoxListEntry.setSelected(bl);
            if (!bl2 || bl) continue;
            bl2 = false;
        }
        this.filterall.setSelected(bl2);
    }

    public void reloadCbSaved() {
        CheckBoxListEntry checkBoxListEntry = null;
        boolean bl = false;
        for (int i2 = 0; i2 < this.filtercb.length; ++i2) {
            checkBoxListEntry = this.filtercb[i2];
            bl = this.filtercbsaved[i2];
            this.filtercbsaved[i2] = checkBoxListEntry.isSelected();
        }
    }

    public boolean haveobjectshidden() {
        return this.objectshidden != null && this.objectshidden.size() > 0;
    }

    private void responseOnAction() {
        this.responseOnAction(false);
        if (this.listener != null) {
            this.listener.exitFilterJPanel(this.numcolmodel, !this.haveobjectshidden());
        }
    }

    public void responseOnAction(boolean bl) {
        boolean bl2 = this.changed();
        if (this.listener != null) {
            this.listener.repaintHeader();
            if (bl) {
                this.listener.exitFilterJPanel(this.numcolmodel, !this.haveobjectshidden());
            } else if (this.filterall != null && this.filterall.isSelected()) {
                this.listener.filterTextClear(this.numcolmodel, true, this.objectshidden);
            } else if (bl2) {
                if (this.objectshidden != null) {
                    this.listener.filterTextClear(this.numcolmodel, this.objectshidden);
                } else {
                    if (this.filtertype != 2) {
                        this.reloadCbSaved();
                    }
                    this.objectshidden = this.listener.filter(this.numcolmodel, this.filtercb);
                    this.agc.setFilterableDialogOpen(!this.haveobjectshidden());
                }
            }
        }
    }

    public void setFilterListener(FilterListener filterListener) {
        this.listener = filterListener;
    }

    public FilterListener getFilterListener() {
        return this.listener;
    }

    public void clearFilter() {
        if (this.listener != null) {
            this.listener.clearFilterTextClear(this.numcolmodel, this.filtercb, this.objectshidden);
        }
    }

    public void reloadFilter2(int n2) {
        if (this.listener != null) {
            if (this.filterall.isSelected() && n2 >= 0 && this.numcolmodel == n2) {
                this.selectall(true);
                this.visibleall(true);
                this.filterall.setSelected(true);
            }
            this.objectshidden = this.listener.filter(n2, this.filtercb);
        }
    }

    public void reloadFilter() {
        if (this.listener != null && this.filtercb != null && (!this.isAllDeselected() || this.filterall.isSelected())) {
            this.objectshidden = this.listener.filter(this.numcolmodel, this.filtercb);
        }
    }

    public CheckBoxListEntry[] getFiltercb() {
        return this.filtercb;
    }

    public void addObjectHidden(Object object) {
        if (this.objectshidden == null) {
            this.objectshidden = new Vector();
        }
        this.objectshidden.add(object);
    }

    public void destroy() {
        this.removeAll();
        this.panelbutton.removeAll();
        this.panelbutton = null;
        this.list.removeAll();
        this.list = null;
        this.filterok = null;
        this.close = null;
        this.listener = null;
        this.cbMenuItem = null;
        this.filterall = null;
        this.filtercb = null;
        this.filtercbsaved = null;
        this.distinctValues = null;
        if (this.objectshidden != null && this.objectshidden.size() > 0) {
            this.objectshidden.removeAllElements();
        }
        this.objectshidden = null;
    }

    public int getFilterType() {
        return this.filtertype;
    }

    public int getNumColModel() {
        return this.numcolmodel;
    }

    public void setFontFilterComponents(Font font) {
        this.setFont(font);
        this.filterall.setFont(font);
        this.filterok.setFont(font);
        this.panelbutton.setFont(font);
        this.list.setFont(font);
        this.listScroller.setFont(font);
        this.close.setFont(font);
        CheckBoxListEntry checkBoxListEntry = null;
        for (int i2 = 0; i2 < this.filtercb.length; ++i2) {
            checkBoxListEntry = this.filtercb[i2];
            if (checkBoxListEntry == null) continue;
            checkBoxListEntry.setFont(font);
        }
    }

    class CheckboxCellRenderer
    extends DefaultListCellRenderer {
        CheckboxCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
            if (object instanceof CheckBoxListEntry) {
                CheckBoxListEntry checkBoxListEntry = (CheckBoxListEntry)object;
                checkBoxListEntry.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
                return checkBoxListEntry;
            }
            return super.getListCellRendererComponent((JList<?>)jList, object.getClass().getName(), n2, bl, bl2);
        }
    }

    public class CheckBoxListEntry
    extends JCheckBox {
        private Object value;
        private String correspondingValue;

        public CheckBoxListEntry(Object object, String string) {
            super(string != null ? string : (object == null ? "" : "" + object));
            this.value = null;
            this.correspondingValue = null;
            this.setValue(object);
        }

        @Override
        public boolean isSelected() {
            return super.isSelected();
        }

        @Override
        public void setSelected(boolean bl) {
            super.setSelected(bl);
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object object) {
            this.value = object;
        }

        public void setCorrespondigValue(String string) {
            this.correspondingValue = string;
        }

        public String getOriginalText() {
            return this.value == null ? "" : "" + this.value;
        }
    }

    public static interface FilterListener {
        public Vector filter(int var1, CheckBoxListEntry[] var2);

        public Object[] getDistinctValues(int var1);

        public void filterTextClear(int var1, Vector var2);

        public void filterTextClear(int var1, boolean var2, Vector var3);

        public void exitFilterJPanel(int var1, boolean var2);

        public void clearFilterTextClear(int var1, CheckBoxListEntry[] var2, Vector var3);

        public void repaintHeader();

        public void sendfinishfiltermsg();
    }
}

