/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.client.swing.Filterable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public abstract class FilterableTreeViewNode
implements TreeNode {
    private FilterableTreeViewNode parent;
    protected FilterableTreeViewNode root;
    private Vector<FilterableTreeViewNode> children = new Vector();
    private Vector<FilterableTreeViewNode> filteredChildren;
    private String lastFilterString;
    private boolean lastFilterCS;
    protected boolean expanded;

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    private Vector<FilterableTreeViewNode> getChildrenVector(boolean bl) {
        String string;
        Filterable filterable = (Filterable)((Object)this.root);
        if (bl && filterable != null && filterable.isFilterItems() && (string = filterable.getFilterString()) != null && string.length() > 0) {
            if (this.filteredChildren == null || !string.equals(this.lastFilterString) || this.lastFilterCS != filterable.isFilterCaseSensitive()) {
                this.filteredChildren = new Vector();
                if (!filterable.isFilterCaseSensitive()) {
                    string = string.toLowerCase();
                }
                for (FilterableTreeViewNode filterableTreeViewNode : this.children) {
                    Vector<FilterableTreeViewNode> vector = filterableTreeViewNode.getChildrenVector(true);
                    if (!vector.isEmpty() || this.accept(filterableTreeViewNode, string, filterable.isFilterCaseSensitive())) {
                        this.filteredChildren.addElement(filterableTreeViewNode);
                        continue;
                    }
                    filterableTreeViewNode.setExpanded(false);
                }
                if (this.filteredChildren.isEmpty()) {
                    this.setExpanded(false);
                }
            }
            this.lastFilterString = string;
            this.lastFilterCS = filterable.isFilterCaseSensitive();
            return this.filteredChildren;
        }
        this.resetFilteredChildren();
        return this.children;
    }

    protected abstract boolean accept(FilterableTreeViewNode var1, String var2, boolean var3);

    public void setExpanded(boolean bl) {
        this.expanded = bl;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public TreeNode getChildAt(int n2) {
        return this.getChildAt(n2, true);
    }

    public TreeNode getChildAt(int n2, boolean bl) {
        Vector<FilterableTreeViewNode> vector = this.getChildrenVector(bl);
        int n3 = vector.size();
        return n2 < n3 ? (TreeNode)vector.elementAt(n2) : null;
    }

    @Override
    public int getChildCount() {
        return this.getChildCount(true);
    }

    public int getChildCount(boolean bl) {
        return this.getChildrenVector(bl).size();
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    public FilterableTreeViewNode getRoot() {
        return this.root;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        return this.getIndex(treeNode, true);
    }

    public int getIndex(TreeNode treeNode, boolean bl) {
        return this.getChildrenVector(bl).indexOf(treeNode);
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    public Enumeration<FilterableTreeViewNode> children() {
        return this.getChildrenVector(true).elements();
    }

    public Enumeration<FilterableTreeViewNode> children(boolean bl) {
        return this.getChildrenVector(bl).elements();
    }

    public FilterableTreeViewNode[] getPath() {
        Vector<FilterableTreeViewNode> vector = new Vector<FilterableTreeViewNode>();
        FilterableTreeViewNode filterableTreeViewNode = this;
        while (filterableTreeViewNode != null) {
            vector.add(0, filterableTreeViewNode);
            filterableTreeViewNode = filterableTreeViewNode.parent;
        }
        return vector.toArray(new FilterableTreeViewNode[vector.size()]);
    }

    public void removeAllChildren() {
        while (!this.children.isEmpty()) {
            FilterableTreeViewNode filterableTreeViewNode = this.children.elementAt(0);
            filterableTreeViewNode.parent = null;
            filterableTreeViewNode.root = null;
            this.children.removeElementAt(0);
        }
        this.resetFilteredChildren();
    }

    private void resetFilteredChildren() {
        this.lastFilterString = null;
        this.lastFilterCS = false;
        if (this.filteredChildren != null) {
            this.filteredChildren.clear();
            this.filteredChildren = null;
        }
    }

    public FilterableTreeViewNode getFirstChild() {
        return (FilterableTreeViewNode)this.getChildAt(0);
    }

    public FilterableTreeViewNode getLastChild() {
        return this.getLastChild(true);
    }

    public FilterableTreeViewNode getLastChild(boolean bl) {
        Vector<FilterableTreeViewNode> vector = this.getChildrenVector(bl);
        int n2 = vector.size();
        return n2 > 0 ? vector.elementAt(n2 - 1) : null;
    }

    public FilterableTreeViewNode getNextSibling() {
        return this.getNextSibling(true);
    }

    public FilterableTreeViewNode getNextSibling(boolean bl) {
        Vector<FilterableTreeViewNode> vector;
        int n2;
        if (this.parent != null && (n2 = (vector = this.parent.getChildrenVector(bl)).indexOf(this)) >= 0 && n2 < vector.size() - 1) {
            return vector.elementAt(n2 + 1);
        }
        return null;
    }

    public FilterableTreeViewNode getPreviousSibling() {
        return this.getPreviousSibling(true);
    }

    public FilterableTreeViewNode getPreviousSibling(boolean bl) {
        Vector<FilterableTreeViewNode> vector;
        int n2;
        if (this.parent != null && (n2 = (vector = this.parent.getChildrenVector(bl)).indexOf(this)) > 0) {
            return vector.elementAt(n2 - 1);
        }
        return null;
    }

    public void add(FilterableTreeViewNode filterableTreeViewNode) {
        if (filterableTreeViewNode.parent != null) {
            filterableTreeViewNode.parent.remove(filterableTreeViewNode);
        }
        filterableTreeViewNode.parent = this;
        filterableTreeViewNode.root = this.root;
        this.children.addElement(filterableTreeViewNode);
        this.resetFilteredChildren();
    }

    public void insert(FilterableTreeViewNode filterableTreeViewNode, int n2) {
        if (filterableTreeViewNode.parent != null) {
            filterableTreeViewNode.parent.remove(filterableTreeViewNode);
        }
        filterableTreeViewNode.parent = this;
        filterableTreeViewNode.root = this.root;
        if (n2 < this.children.size()) {
            this.children.add(n2, filterableTreeViewNode);
        } else {
            this.children.addElement(filterableTreeViewNode);
        }
        this.resetFilteredChildren();
    }

    public void remove(FilterableTreeViewNode filterableTreeViewNode) {
        filterableTreeViewNode.parent = null;
        filterableTreeViewNode.root = null;
        this.children.removeElement(filterableTreeViewNode);
        this.resetFilteredChildren();
    }
}

