/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import com.iscobol.gui.client.LocalFontCmp;
import com.iscobol.gui.client.swing.GridCell;
import com.iscobol.gui.client.swing.GridConstant;
import com.iscobol.gui.client.swing.IsTextIcon;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Map;
import java.util.regex.Matcher;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

class GUIGridCell
extends JLabel
implements GridConstant {
    private int colWidth = -1;
    private int colDivWidth = -1;
    private int rowHeight = -1;
    private int rowDivHeight = -1;
    private float separation;
    private boolean textInHtml;
    private int extraMargin = 2;
    private int extraMarginLRtext = 2;
    private int extraMarginLRboth = 2;
    private int extraMarginTBboth = 2;
    private Insets skip;
    private boolean dotted;
    private boolean tiled;
    GridCell agc = null;
    private ImageIcon vertIcon = null;
    private int columnheadingslayout = 4;
    private int horTextPos = 2;
    private int vertTextPos = 3;
    private int horAlign = -1;
    private int vertAlign = -1;
    private int vertRotation = 2;
    private boolean vertical;
    private ImageIcon filterableIcon = null;
    private ImageIcon sortIcon;
    private Color defaultMatchingTextColorBackground;
    private Color matchingTextColorBackground = this.defaultMatchingTextColorBackground = new Color(255, 215, 50);
    private Color matchingTextColorForeground = null;
    private int matcherstart = -1;
    private int matcherend = -1;
    private String tmatcher;
    private Matcher matcher;

    public void setSkip(Insets insets, boolean bl, boolean bl2) {
        this.skip = insets;
        this.dotted = bl;
        this.tiled = bl2;
    }

    public void initialize() {
        this.horTextPos = 2;
        this.vertTextPos = 0;
        this.horAlign = -1;
        this.vertAlign = -1;
        this.colWidth = -1;
        this.colDivWidth = -1;
        this.rowHeight = -1;
        this.rowDivHeight = -1;
        this.agc = null;
        this.separation = 0.0f;
        this.textInHtml = false;
        this.skip = null;
        this.dotted = false;
        this.tiled = false;
        this.matcherstart = -1;
        this.matcherend = -1;
        this.tmatcher = "";
        this.matcher = null;
        this.filterableIcon = null;
    }

    public void setRowDim(int n2, int n3) {
        this.rowHeight = n2;
        this.rowDivHeight = n3;
    }

    public void setCell(GridCell gridCell) {
        this.agc = gridCell;
    }

    public void setCol(int n2, int n3) {
        this.colWidth = n2;
        this.colDivWidth = n3;
    }

    public void setColumnHeadingsLayout(int n2, String string, int n3, boolean bl) {
        this.columnheadingslayout = n2;
        this.setHorizontalTextPosition(n3);
        this.horAlign = 10;
        this.setVerticalTextPosition(n3);
        this.setVerticalAlignment(0);
        if (this.columnheadingslayout > 0) {
            if ((this.columnheadingslayout & 8) == 8) {
                this.horAlign = 2;
            } else if ((this.columnheadingslayout & 0x10) == 16) {
                this.horAlign = 4;
            } else {
                this.setHorizontalAlignment(this.horAlign);
            }
            this.setVerticalAttribute();
        } else {
            if (bl) {
                this.setHorizontalAlignment(0);
            }
            if (string != null) {
                if (!bl) {
                    if (string.startsWith("R") || string.startsWith("r")) {
                        this.setHorizontalAlignment(4);
                    } else if (string.startsWith("L") || string.startsWith("l")) {
                        this.setHorizontalAlignment(2);
                    } else if (string.startsWith("C") || string.startsWith("c")) {
                        this.setHorizontalAlignment(0);
                    }
                }
                if (string.startsWith("H") || string.startsWith("h")) {
                    if (bl) {
                        this.setHorizontalAlignment(0);
                    }
                    this.setTextInHtml(true);
                }
            }
        }
    }

    @Override
    public void setHorizontalTextPosition(int n2) {
        if ((this.columnheadingslayout & 0) == 0) {
            if (n2 == 0) {
                n2 = 4;
            } else if (n2 == 1) {
                n2 = 2;
            }
            super.setHorizontalTextPosition(n2);
            if (n2 == 2 || n2 == 4) {
                this.horTextPos = n2;
            }
        }
    }

    @Override
    public void setVerticalTextPosition(int n2) {
        if ((this.columnheadingslayout & 3) > 0) {
            if (n2 == 0) {
                n2 = 3;
            } else if (n2 == 1) {
                n2 = 1;
            }
            super.setVerticalTextPosition(n2);
            if (n2 == 1 || n2 == 3) {
                this.vertTextPos = n2;
            }
        }
    }

    public void setVerticalAttribute() {
        if ((this.columnheadingslayout & 3) > 0) {
            this.horTextPos = 0;
            this.vertical = true;
            if ((this.columnheadingslayout & 2) == 2) {
                this.vertRotation = 4;
            }
        }
        if ((this.columnheadingslayout & 0x40) == 64) {
            this.setVerticalAlignment(3);
        }
        if ((this.columnheadingslayout & 0x20) == 32) {
            this.setVerticalAlignment(1);
        }
    }

    @Override
    public void setHorizontalAlignment(int n2) {
        super.setHorizontalAlignment(n2);
        if (n2 == 2 || n2 == 4 || n2 == 0) {
            this.horAlign = n2;
        }
    }

    @Override
    public void setVerticalAlignment(int n2) {
        super.setVerticalAlignment(n2);
        if (n2 == 1 || n2 == 3 || n2 == 0) {
            this.vertAlign = n2;
        }
    }

    public void setSeparation(float f2) {
        this.separation = f2;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int n2;
        Object object;
        Object object2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = -1;
        IsTextIcon isTextIcon = null;
        int n15 = 5;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        if (this.textInHtml) {
            Graphics graphics2 = graphics;
            Rectangle rectangle = this.getBounds();
            this.colWidth = (int)rectangle.getWidth();
            n5 = (int)rectangle.getHeight();
            int n19 = 0;
            int n20 = 0;
            if (this.sortIcon != null) {
                graphics.drawImage(this.sortIcon.getImage(), this.colWidth - this.sortIcon.getIconWidth() - 4, n5 / 2 - this.sortIcon.getIconHeight() / 2, this);
                n20 = this.sortIcon.getIconWidth() + 4;
            }
            if (this.filterableIcon != null) {
                n16 = this.filterableIcon.getIconWidth();
                n17 = this.filterableIcon.getIconHeight();
                n18 = n5 / 2;
                graphics.drawImage(this.filterableIcon.getImage(), 2, n18 -= n17 / 2, this);
                if (this.agc != null) {
                    this.agc.setFilterableImageCoord(0, 0, n16 * 2, n5);
                }
                n13 += n16;
                n19 += n16 + 2;
                n20 += n16 + 2;
            }
            if (n19 > 0 || n20 > 0) {
                Rectangle rectangle2 = graphics.getClipBounds();
                graphics2 = graphics.create(rectangle2.x + n19, rectangle2.y, rectangle2.width - n20, rectangle2.height);
            }
            super.paintComponent(graphics2);
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (AbstractGuiFactoryImpl.getFontHandlingProp() != 3 && (object2 = (Map)((Toolkit)(object = Toolkit.getDefaultToolkit())).getDesktopProperty("awt.font.desktophints")) != null) {
            graphics2D.addRenderingHints((Map<?, ?>)object2);
        }
        object = this.getBounds();
        this.colWidth = (int)((Rectangle)object).getWidth();
        n5 = (int)((Rectangle)object).getHeight();
        if (this.agc != null && this.agc.getFont() != null) {
            n4 = this.agc.getFont().getHeight();
            if (this.getText() != null) {
                n3 = this.agc.getFont().computeScreenWidth(this.getText());
            }
        } else if (this.getText() != null) {
            object2 = this.getFontMetrics(this.getFont());
            n4 = ((FontMetrics)object2).getAscent() + ((FontMetrics)object2).getDescent();
            n3 = SwingUtilities.computeStringWidth((FontMetrics)object2, this.getText());
        }
        if (this.vertical && this.getText() != null) {
            isTextIcon = new IsTextIcon(this, this.getText(), this.vertRotation);
            n3 = isTextIcon.getIconWidth();
            n4 = isTextIcon.getIconHeight();
        }
        if (this.getIcon() != null) {
            n10 = this.getIcon().getIconWidth();
            n11 = this.getIcon().getIconHeight();
            n12 = (this.rowHeight - n11) / 2;
            if (n12 < 0) {
                n12 = 0;
            }
            if ((n13 = (this.colWidth - n10) / 2) < 0) {
                n13 = 0;
            }
            if (this.vertical) {
                switch (this.horAlign) {
                    case 2: {
                        if (this.getText() != null && n3 > n10) {
                            n13 = (n3 - n10) / 2;
                            n13 += this.extraMargin;
                            break;
                        }
                        n13 = this.extraMargin;
                        break;
                    }
                    case 4: {
                        n13 = this.colWidth - n10;
                        if (this.getText() != null && n3 > n10) {
                            n13 -= (n3 - n10) / 2;
                        }
                        n13 -= this.extraMargin;
                        break;
                    }
                    default: {
                        n13 = this.colWidth / 2;
                        n13 -= n10 / 2;
                        break;
                    }
                }
            } else {
                switch (this.vertAlign) {
                    case 1: {
                        if (this.getText() != null && n4 > n11) {
                            n12 = (n4 - n11) / 2;
                            break;
                        }
                        n12 = this.extraMargin;
                        break;
                    }
                    case 3: {
                        n12 = n5 - n11;
                        if (this.getText() != null && n4 > n11) {
                            n12 -= (n4 - n11) / 2;
                            n12 += this.extraMargin;
                            break;
                        }
                        n12 -= this.extraMargin;
                        break;
                    }
                    default: {
                        n12 = n5 / 2;
                        n12 -= n11 / 2;
                    }
                }
            }
        }
        if (this.sortIcon != null) {
            graphics.drawImage(this.sortIcon.getImage(), this.colWidth - this.sortIcon.getIconWidth() - 2, n5 / 2 - this.sortIcon.getIconHeight() / 2, this);
        }
        if (this.filterableIcon != null) {
            n16 = this.filterableIcon.getIconWidth();
            n17 = this.filterableIcon.getIconHeight();
            n18 = n5 / 2;
            graphics.drawImage(this.filterableIcon.getImage(), 2, n18 -= n17 / 2, this);
            if (this.agc != null) {
                this.agc.setFilterableImageCoord(0, 0, n16 * 2, n5);
            }
            n13 += n16;
        }
        if (this.getText() != null) {
            int n21 = 0;
            n2 = 0;
            if (this.vertical) {
                switch (this.horAlign) {
                    case 2: {
                        n8 = this.getIcon() != null && n10 > n3 ? (n8 += (n10 - n3) / 2) : (n8 += -this.extraMargin);
                        n8 += this.extraMarginLRboth;
                        break;
                    }
                    case 4: {
                        n8 = this.getIcon() != null && n10 > n3 ? this.colWidth - n3 - (n10 - n3) / 2 : this.colWidth - n3 + this.extraMargin;
                        n8 -= this.extraMarginLRboth;
                        break;
                    }
                    default: {
                        n8 = this.colWidth / 2;
                        n8 -= n3 / 2;
                        break;
                    }
                }
            } else {
                if (this.agc != null && this.agc.getFont() != null) {
                    n3 = this.agc.getFont().computeScreenWidth(this.getText());
                    n21 = this.agc.getFont().getDescent() - this.agc.getFont().getAscent();
                } else {
                    n3 = SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), this.getText());
                    n21 = this.getFontMetrics(this.getFont()).getDescent() - this.getFontMetrics(this.getFont()).getAscent();
                }
                if (n21 < 0) {
                    n21 *= -1;
                }
                switch (this.vertAlign) {
                    case 1: {
                        if (this.getIcon() != null && n11 > n4) {
                            n9 = n11 / 2 + n21 / 2;
                            break;
                        }
                        n9 = this.extraMargin + n21;
                        break;
                    }
                    case 3: {
                        if (this.getIcon() != null && n11 > n4) {
                            n9 = this.rowHeight - n11 / 2 + n21 / 2 - this.extraMargin;
                            break;
                        }
                        n9 = this.rowHeight - n21 / 2 + 2 * this.extraMargin;
                        break;
                    }
                    default: {
                        n9 = this.rowHeight / 2;
                        n9 += n21 / 2;
                    }
                }
            }
        }
        if (this.getText() != null && this.getText().length() > 0 && this.getIcon() != null) {
            if (this.vertical) {
                n15 = 0;
                n7 = (n5 - n11 - n4 - n15) / 2;
                if (this.vertTextPos == 3) {
                    if (this.vertAlign == 1) {
                        n9 = this.extraMargin;
                        n12 = 2 * n15 + n4;
                    } else if (this.vertAlign == 3) {
                        n9 = n5 - n11 - n4 - 2 * n15;
                        n12 = n5 - n11;
                    } else if (this.vertAlign == 0) {
                        n9 = n7;
                        n12 = n7 + n15 + n4;
                    } else {
                        n9 = this.extraMargin;
                        n12 = this.extraMargin + n15 + n4;
                    }
                    n9 -= this.extraMarginTBboth;
                } else if (this.vertTextPos == 1) {
                    if (this.vertAlign == 1) {
                        n12 = this.extraMargin;
                        n9 = n15 + n11;
                    } else if (this.vertAlign == 3) {
                        n12 = n5 - n11 - n4 - n15 - this.extraMargin;
                        n9 = n5 - n4 - n15;
                    } else if (this.vertAlign == 0) {
                        n12 = n7;
                        n9 = n7 + this.extraMargin + n11;
                    } else {
                        n12 = this.extraMargin;
                        n9 = this.extraMargin + n15 + n11;
                    }
                    n9 += this.extraMarginTBboth;
                    n12 += this.extraMarginTBboth;
                } else if (this.vertTextPos == 0) {
                    // empty if block
                }
            } else {
                n6 = (this.colWidth - n10 - n3 - n15) / 2;
                if (this.horTextPos == 2) {
                    if (this.horAlign == 2) {
                        n8 = this.extraMargin;
                        n13 = this.extraMargin + n15 + n3;
                    } else if (this.horAlign == 4) {
                        n8 = this.colWidth - n15 - n3 - n10 - this.extraMargin;
                        n13 = this.colWidth - n10 - this.extraMargin;
                    } else if (this.horAlign == 0) {
                        n8 = n6;
                        n13 = n6 + n15 + n3;
                    } else {
                        n8 = this.extraMargin;
                        n13 = this.extraMargin + n15 + n3;
                    }
                    if (this.filterableIcon != null) {
                        n8 += n16;
                    }
                } else if (this.horTextPos == 4) {
                    if (this.horAlign == 2) {
                        n13 = this.extraMargin;
                        n8 = this.extraMargin + n10 + n15;
                    } else if (this.horAlign == 4) {
                        n13 = this.colWidth - n15 - n10 - (n3 -= this.colDivWidth) - this.extraMargin;
                        n8 = this.colWidth - n3 - this.extraMargin;
                    } else if (this.horAlign == 0) {
                        n13 = n6;
                        n8 = n6 + n15 + n10;
                        if (this.separation > 0.0f) {
                            n13 = (int)((float)n13 - this.separation);
                        }
                    } else {
                        n13 = this.extraMargin;
                        n8 = this.extraMargin + n10 + n15;
                    }
                }
            }
            if (this.agc != null) {
                this.agc.setImageCoord(n13, n12, n10, n11);
            }
            graphics.drawImage(((ImageIcon)this.getIcon()).getImage(), n13, n12, this);
            if (this.vertical) {
                isTextIcon.paintIcon(this, graphics, n8, n9);
            } else {
                String string = this.getText();
                if (this.horAlign == 0 && string != null && this.separation > 0.0f) {
                    n8 = (int)((float)n8 - this.separation);
                }
                if (n8 <= 0) {
                    n8 = 2;
                }
                this.printMatcher(graphics, string, n8, n9, (Rectangle)object);
            }
        } else if (this.getIcon() != null) {
            if (this.vertical) {
                if (this.vertAlign == 1) {
                    n12 = this.extraMargin;
                } else if (this.vertAlign == 3) {
                    n12 = n5 - n11;
                    n12 -= this.extraMargin;
                } else if (this.vertAlign == 0) {
                    n12 = (n5 - n11) / 2;
                }
            } else if (this.horAlign == 2 || this.horAlign == -1) {
                n13 = this.extraMargin;
            } else if (this.horAlign == 4) {
                n13 = this.colWidth - n10 - this.extraMargin;
            } else if (this.horAlign == 0) {
                n13 = (this.colWidth - n10) / 2;
            }
            graphics.drawImage(((ImageIcon)this.getIcon()).getImage(), n13, n12, this);
            if (this.agc != null) {
                this.agc.setImageCoord(n13, n12, n10, n11);
            }
        } else if (this.getText() != null) {
            if (this.vertical) {
                if (this.vertAlign == 1) {
                    n9 = 0;
                } else if (this.vertAlign == 3) {
                    n9 = n5 - n4;
                } else if (this.vertAlign == 0) {
                    n9 = (n5 - n4) / 2;
                }
                isTextIcon.paintIcon(this, graphics, n8, n9);
            } else {
                if (this.separation > 0.0f) {
                    this.colWidth = (int)((float)this.colWidth - this.separation);
                }
                if (this.horAlign == 2) {
                    n8 = this.extraMargin;
                    if (this.filterableIcon != null) {
                        n8 += n16;
                    }
                } else if (this.horAlign == 4) {
                    n8 = this.colWidth - (n3 -= this.colDivWidth) - this.extraMargin;
                } else if (this.horAlign == 0) {
                    n8 = (this.colWidth - n3) / 2;
                }
                String string = this.getText();
                if (n8 <= 0) {
                    n8 = 2;
                    if (this.filterableIcon != null) {
                        n8 += n16;
                    }
                }
                this.printMatcher(graphics, string, n8, n9, (Rectangle)object);
                if (this.agc != null) {
                    this.agc.setImageCoord(0, 0, 0, 0);
                }
                if (string != null && string.length() > 0 && this.separation > 0.0f && (this.horAlign == -1 || this.horAlign == 2)) {
                    n14 = (int)(((Rectangle)object).getWidth() - (double)this.separation + (double)n8);
                    n2 = 0;
                    int n22 = (int)this.separation;
                    if (this.skip != null) {
                        if (this.dotted) {
                            n22 -= this.skip.left + this.skip.right + 2;
                            ((Rectangle)object).height -= this.skip.top + this.skip.bottom + 2;
                            n2 = this.skip.top + 1;
                        } else if (this.tiled) {
                            n14 -= this.skip.right - 1;
                            n22 -= this.skip.right - 1;
                            ((Rectangle)object).height -= this.skip.top - 1 + this.skip.bottom - 2;
                            n2 = this.skip.top - 1;
                        } else {
                            n22 -= this.skip.right + n8;
                            ((Rectangle)object).height -= this.skip.top + this.skip.bottom;
                            n2 = this.skip.top;
                        }
                    }
                    graphics.setColor(this.getParent().getBackground());
                    graphics.fillRect(n14, n2, n22, ((Rectangle)object).height);
                }
            }
        }
    }

    public void oosetText(String string) {
        this.setTextGUI(string);
    }

    public String setTextGUI(String string) {
        String string2 = string;
        if (string != null) {
            if (this.horAlign == 2) {
                string2 = string.trim();
            } else if (this.horAlign == 4) {
                string2 = ScreenUtility.rightTrim(string);
                string2 = string2.trim();
            } else if (this.horAlign == 0) {
                string2 = ScreenUtility.rightTrim(string);
                string2 = string2.trim();
            }
        }
        super.setText(string2);
        return string2;
    }

    public static String getTextGUI(String string, int n2) {
        String string2 = string;
        if (string != null) {
            if (n2 == 2) {
                string2 = string.trim();
            } else if (n2 == 4) {
                string2 = ScreenUtility.rightTrim(string);
                string2 = string2.trim();
            } else if (n2 == 0) {
                string2 = ScreenUtility.rightTrim(string);
                string2 = string2.trim();
            }
        }
        return string2;
    }

    public void setTextInHtml(boolean bl) {
        this.textInHtml = bl;
    }

    public boolean getTextInHtml() {
        return this.textInHtml;
    }

    public boolean isMultiLine(String string, LocalFontCmp localFontCmp) {
        Object var3_3 = null;
        boolean bl = false;
        if (string.indexOf(10) > -1) {
            bl = true;
        } else if (localFontCmp != null) {
            bl = localFontCmp.computeScreenWidth(string) > this.colWidth && string.indexOf(32) > -1;
        }
        return bl;
    }

    public void setExtraMargin(boolean bl) {
        if (bl) {
            this.extraMargin = 2;
        }
    }

    public void setFilterableIcon(ImageIcon imageIcon) {
        this.filterableIcon = imageIcon;
    }

    @Override
    public void setIcon(Icon icon) {
        super.setIcon(icon);
    }

    public void setmatcheridx(Matcher matcher, int n2, int n3, String string) {
        this.matcher = matcher;
        if (matcher == null) {
            this.matcherstart = n2;
            this.matcherend = n3;
            this.tmatcher = string;
        }
    }

    public int getmatcherstart() {
        return this.matcherstart;
    }

    public int getmatcherend() {
        return this.matcherend;
    }

    public String getmatchert() {
        return this.tmatcher;
    }

    private void printMatcher(Graphics graphics, String string, int n2, int n3, Rectangle rectangle) {
        int n4 = -1;
        int n5 = -1;
        if (string != null && string.length() > 0) {
            if (this.matcher != null) {
                this.matcher.reset(string);
                if (this.matcher.find()) {
                    this.matcherstart = this.matcher.start();
                    this.matcherend = this.matcher.end();
                    this.tmatcher = this.matcher.group();
                }
            }
            if (this.matcherstart >= 0 && this.matcherend > 0 && this.matcherend > this.matcherstart && this.matcherend <= string.length() && this.matcherend - this.matcherstart > 0) {
                Color color = graphics.getColor();
                String string2 = "";
                String string3 = "";
                String string4 = "";
                try {
                    string2 = string.substring(0, this.matcherstart);
                    string3 = string.substring(this.matcherstart, this.matcherend);
                    string4 = string.substring(this.matcherend, string.length());
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                n4 = SwingUtilities.computeStringWidth(fontMetrics, string2);
                n5 = SwingUtilities.computeStringWidth(fontMetrics, this.tmatcher);
                graphics.drawString(string2, n2, n3);
                graphics.setColor(this.matchingTextColorBackground);
                graphics.fillRect(n2 + n4, 0, n5, rectangle.height);
                if (this.matchingTextColorForeground != null) {
                    graphics.setColor(this.matchingTextColorForeground);
                } else {
                    graphics.setColor(color);
                }
                graphics.drawString(string3, n2 + n4, n3);
                graphics.setColor(color);
                graphics.drawString(string4, n2 + n4 + n5, n3);
            } else {
                graphics.drawString(string, n2, n3);
            }
        } else {
            graphics.drawString(string, n2, n3);
        }
    }

    public void setSortIcon(ImageIcon imageIcon) {
        this.sortIcon = imageIcon;
    }

    public void setMatchingTextColorBackground(Color color) {
        this.matchingTextColorBackground = color;
        if (color == null) {
            color = this.defaultMatchingTextColorBackground;
        }
    }

    public void setMatchingTextColorForeground(Color color) {
        this.matchingTextColorForeground = color;
    }
}

