/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.ColorCmp;
import com.iscobol.gui.IsguiUtility;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class GradientManager {
    public static final String ORIENTATION = "orientation";
    public static final String COLOR1 = "color1";
    public static final String COLOR2 = "color2";
    public static final String IMAGE = "image";
    public static final String IMAGE_SCALE = "imageScale";
    public static final int GRADIENT_NORTH_TO_SOUTH = 0;
    public static final int GRADIENT_NORTHEAST_TO_SOUTHWEST = 1;
    public static final int GRADIENT_EAST_TO_WEST = 2;
    public static final int GRADIENT_SOUTHEAST_TO_NORTHWEST = 3;
    public static final int GRADIENT_SOUTH_TO_NORTH = 4;
    public static final int GRADIENT_SOUTHWEST_TO_NORTHEAST = 5;
    public static final int GRADIENT_WEST_TO_EAST = 6;
    public static final int GRADIENT_NORTHWEST_TO_SOUTHEAST = 7;
    public static final int GRADIENT_MIN_VALUE = 0;
    public static final int GRADIENT_MAX_VALUE = 7;
    private int orientation = -1;
    private Color color1;
    private ColorCmp color1Cmp;
    private int color1Index = -1;
    private Color color2;
    private ColorCmp color2Cmp;
    private int color2Index = -1;
    private Image image;
    private int imageScale = 1;
    private Dimension scaledImageSize;
    private Image scaledImage;
    private PropertyChangeSupport pcSupport = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n2) {
        int n3 = this.orientation;
        this.orientation = n2;
        this.pcSupport.firePropertyChange(ORIENTATION, n3, this.orientation);
    }

    public Color getColor1() {
        return this.color1;
    }

    public void setColor1(Color color) {
        Color color2 = this.color1;
        this.color1 = color;
        this.pcSupport.firePropertyChange(COLOR1, color2, this.color1);
    }

    public ColorCmp getColor1Cmp() {
        return this.color1Cmp;
    }

    public void setColor1Cmp(ColorCmp colorCmp) {
        this.color1Cmp = colorCmp;
    }

    public int getColor1Index() {
        return this.color1Index;
    }

    public String getColor1AsString() {
        if (this.color1 != null) {
            if (this.color1Index >= 0) {
                return Integer.toString(this.color1Index);
            }
            return Integer.toString(this.color1Cmp.getForeground());
        }
        return null;
    }

    public String getColor2AsString() {
        if (this.color2 != null) {
            if (this.color2Index >= 0) {
                return Integer.toString(this.color2Index);
            }
            return Integer.toString(this.color2Cmp.getForeground());
        }
        return null;
    }

    public void setColor1Index(int n2) {
        this.color1Index = n2;
    }

    public Color getColor2() {
        return this.color2;
    }

    public void setColor2(Color color) {
        Color color2 = this.color2;
        this.color2 = color;
        this.pcSupport.firePropertyChange(COLOR2, color2, this.color2);
    }

    public ColorCmp getColor2Cmp() {
        return this.color2Cmp;
    }

    public void setColor2Cmp(ColorCmp colorCmp) {
        this.color2Cmp = colorCmp;
    }

    public int getColor2Index() {
        return this.color2Index;
    }

    public void setColor2Index(int n2) {
        this.color2Index = n2;
    }

    public void setColor1(int n2, boolean bl, GuiFactoryImpl guiFactoryImpl) {
        this.setColor(1, n2, bl, guiFactoryImpl);
    }

    public void setColor2(int n2, boolean bl, GuiFactoryImpl guiFactoryImpl) {
        this.setColor(2, n2, bl, guiFactoryImpl);
    }

    private void setColor(int n2, int n3, boolean bl, GuiFactoryImpl guiFactoryImpl) {
        Color color;
        int n4;
        ColorCmp colorCmp;
        if (n3 < 0 || bl) {
            colorCmp = new ColorCmp(true);
            n4 = -1;
            colorCmp.setForeRGB(n3);
            color = guiFactoryImpl.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(colorCmp.getForeground(), false));
        } else {
            colorCmp = new ColorCmp(n3);
            n4 = n3;
            color = guiFactoryImpl.getRemotePalette().getDefaultColor(colorCmp.getForeground());
        }
        if (n2 == 1) {
            this.setColor1Cmp(colorCmp);
            this.setColor1Index(n4);
            this.setColor1(color);
        } else {
            this.setColor2Cmp(colorCmp);
            this.setColor2Index(n4);
            this.setColor2(color);
        }
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        Image image2 = this.image;
        this.image = image;
        this.scaledImage = null;
        this.scaledImageSize = null;
        this.pcSupport.firePropertyChange(IMAGE, image2, this.image);
    }

    public int getImageScale() {
        return this.imageScale;
    }

    public void setImageScale(int n2) {
        int n3 = this.imageScale;
        this.imageScale = n2;
        this.scaledImage = null;
        this.scaledImageSize = null;
        this.pcSupport.firePropertyChange(IMAGE_SCALE, n3, this.imageScale);
    }

    public boolean isPaintGradient() {
        return this.getImage() != null || this.getColor1() != null || this.getColor2() != null;
    }

    public void paint(Graphics2D graphics2D, Rectangle rectangle) {
        if (this.getImage() != null) {
            this.paintImage(graphics2D, rectangle);
        } else {
            this.paintGradient(graphics2D, rectangle);
        }
    }

    private void paintImage(Graphics2D graphics2D, Rectangle rectangle) {
        if (this.scaledImage == null || !rectangle.getSize().equals(this.scaledImageSize)) {
            int n2;
            int n3;
            switch (this.imageScale) {
                case 1: {
                    n3 = 0;
                    n2 = 5;
                    break;
                }
                case 2: {
                    n3 = 1;
                    n2 = 7;
                    break;
                }
                default: {
                    n3 = -1;
                    n2 = -1;
                }
            }
            this.scaledImage = n3 >= 0 ? IsguiUtility.scale(this.image, rectangle.width, rectangle.height, n3, n2, false) : this.image;
            this.scaledImageSize = rectangle.getSize();
        }
        graphics2D.drawImage(this.scaledImage, rectangle.x, rectangle.y, null);
    }

    private void paintGradient(Graphics2D graphics2D, Rectangle rectangle) {
        int n2 = this.orientation;
        Color color = this.color1;
        Color color2 = this.color2;
        boolean bl = false;
        if (color != null || color2 != null) {
            bl = true;
            if (n2 < 0) {
                n2 = 0;
            }
            if (color == null) {
                color = Color.black;
            }
            if (color2 == null) {
                color2 = Color.black;
            }
        }
        if (bl) {
            GradientPaint gradientPaint;
            switch (n2) {
                case 1: {
                    gradientPaint = new GradientPaint(rectangle.width - 1, 0.0f, color, 0.0f, rectangle.height - 1, color2);
                    break;
                }
                case 2: {
                    gradientPaint = new GradientPaint(rectangle.width - 1, 0.0f, color, 0.0f, 0.0f, color2);
                    break;
                }
                case 3: {
                    gradientPaint = new GradientPaint(rectangle.width - 1, rectangle.height - 1, color, 0.0f, 0.0f, color2);
                    break;
                }
                case 4: {
                    gradientPaint = new GradientPaint(0.0f, rectangle.height - 1, color, 0.0f, 0.0f, color2);
                    break;
                }
                case 5: {
                    gradientPaint = new GradientPaint(0.0f, rectangle.height - 1, color, rectangle.width - 1, 0.0f, color2);
                    break;
                }
                case 6: {
                    gradientPaint = new GradientPaint(0.0f, 0.0f, color, rectangle.width - 1, 0.0f, color2);
                    break;
                }
                case 7: {
                    gradientPaint = new GradientPaint(0.0f, 0.0f, color, rectangle.width - 1, rectangle.height - 1, color2);
                    break;
                }
                default: {
                    gradientPaint = new GradientPaint(0.0f, 0.0f, color, 0.0f, rectangle.height - 1, color2);
                }
            }
            Paint paint = graphics2D.getPaint();
            graphics2D.setPaint(gradientPaint);
            graphics2D.fill(rectangle);
            graphics2D.setPaint(paint);
        }
    }
}

