/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.Constants;
import com.iscobol.gui.client.swing.GridCell;
import com.iscobol.gui.client.swing.GridConstant;
import com.iscobol.gui.client.swing.GridModel;
import com.iscobol.gui.client.swing.GridViewS;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class GridModelSorter
extends AbstractTableModel
implements Constants,
GridConstant,
GridModel,
TableModelListener {
    protected GridModel tableModel;
    public static final int SORT_DESCENDING = -1;
    public static final int NOT_SORTED = 0;
    public static final int SORT_ASCENDING = 1;
    private Row[] viewerToModel;
    private int[] modelToViewer;
    private JTableHeader tableHeader;
    private MouseListener mouseListener;
    private List sortingColumns = new ArrayList();
    private GridViewS parent;
    private String sortdata;
    private String internalsortdata;
    private boolean onlyrepaint = false;
    private int sendbegincolumnsorttypes = -1;
    public static final int SORT_ELEM_LEN_NUM_COL = 4;
    public static final int SORT_ELEM_DATA = 6;

    public GridModelSorter(GridViewS gridViewS, GridModel gridModel) {
        this.parent = gridViewS;
        this.mouseListener = new MouseHandler();
        if (this.tableModel != null) {
            this.tableModel.removeTableModelListener(this);
        }
        this.tableModel = gridModel;
        if (this.tableModel != null) {
            this.tableModel.addTableModelListener(this);
        }
        this.clearSortingState();
        this.fireTableStructureChanged();
    }

    private synchronized void clearSortingState() {
        this.viewerToModel = null;
        this.modelToViewer = null;
    }

    public GridModel getTableModel() {
        return this.tableModel;
    }

    public JTableHeader getTableHeader() {
        return this.tableHeader;
    }

    public void removemouseListener() {
        if (this.tableHeader != null) {
            this.tableHeader.removeMouseListener(this.mouseListener);
        }
    }

    public void addmouseListener() {
        if (this.tableHeader != null) {
            this.tableHeader.addMouseListener(this.mouseListener);
        }
    }

    public void setTableHeader(JTableHeader jTableHeader) {
        this.tableHeader = jTableHeader;
    }

    private OrderingType getOrderingType(int n2) {
        OrderingType orderingType = null;
        OrderingType orderingType2 = null;
        for (int i2 = 0; i2 < this.sortingColumns.size(); ++i2) {
            orderingType2 = (OrderingType)this.sortingColumns.get(i2);
            if (orderingType2.column != n2) continue;
            orderingType = orderingType2;
        }
        return orderingType;
    }

    public int getSortingStatus(int n2) {
        int n3 = 0;
        OrderingType orderingType = this.getOrderingType(n2);
        if (orderingType != null) {
            n3 = orderingType.mode;
        }
        return n3;
    }

    public boolean sortingStatusChanged() {
        return this.sortingStatusChanged(false);
    }

    public boolean sortingStatusChanged(boolean bl) {
        boolean bl2 = false;
        if (bl || this.sortingColumns != null && this.sortingColumns.size() > 0) {
            bl2 = true;
            this.clearSortingState();
            this.fireTableDataChanged();
            if (this.tableHeader != null) {
                this.tableHeader.repaint();
            }
        }
        return bl2;
    }

    public void setSortingStatus(int n2, int n3) {
        OrderingType orderingType = this.getOrderingType(n2);
        if (orderingType != null) {
            this.sortingColumns.remove(orderingType);
        }
        if (n3 != 0) {
            this.sortingColumns.add(new OrderingType(n2, n3));
        }
        this.sortingStatusChanged(true);
        if (this.sortingColumns != null && this.sortingColumns.size() == 0 && this.tableHeader != null) {
            this.tableHeader.repaint();
        }
    }

    protected Icon getHeaderRendererIcon(int n2, int n3) {
        OrderingType orderingType = this.getOrderingType(n2);
        if (orderingType == null) {
            return null;
        }
        return new SortStateIcon(orderingType.mode == -1, n3);
    }

    private void cancelSorting() {
        this.sortingColumns.clear();
        this.sortingStatusChanged();
    }

    private Row[] getViewerToModel() {
        int n2 = this.tableModel.getRowCount();
        if (this.viewerToModel == null || this.viewerToModel.length != n2) {
            this.viewerToModel = new Row[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.viewerToModel[i2] = new Row(this.tableModel.convertRowIndexToModel(i2));
            }
            if (this.sortingColumns.size() > 0) {
                Arrays.sort(this.viewerToModel);
            }
        }
        return this.viewerToModel;
    }

    private synchronized int modelIndex(int n2) {
        Row row;
        int n3 = n2;
        Row[] rowArray = this.getViewerToModel();
        if (rowArray != null && rowArray.length > n2 && (row = rowArray[n2]) != null) {
            n3 = row.modelIndex;
        }
        return n3;
    }

    private synchronized int[] getModelToViewer() {
        if (this.modelToViewer == null) {
            int n2 = this.getViewerToModel().length;
            this.modelToViewer = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.modelToViewer[this.modelIndex((int)i2)] = i2;
            }
        }
        return this.modelToViewer;
    }

    @Override
    public int getRowCount() {
        return this.tableModel == null ? 0 : this.tableModel.getRowCount();
    }

    @Override
    public int getColumnCount() {
        int n2 = this.tableModel == null ? 0 : this.tableModel.getColumnCount();
        return n2;
    }

    @Override
    public String getColumnName(int n2) {
        return this.tableModel.getColumnName(n2);
    }

    public Class getColumnClass(int n2) {
        return this.tableModel.getColumnClass(n2);
    }

    @Override
    public boolean isCellEditable(int n2, int n3) {
        return this.tableModel.isCellEditable(n2, n3);
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        return this.tableModel.getValueAt(n2, n3);
    }

    @Override
    public void setValueAt(Object object, int n2, int n3) {
        this.tableModel.setValueAt(object, n2, n3);
        this.sortingStatusChanged();
    }

    public Icon getColumnSortIcon(int n2, int n3) {
        return this.getHeaderRendererIcon(n2, n3);
    }

    public ImageIcon getColumnSortImage(int n2) {
        OrderingType orderingType = this.getOrderingType(n2);
        if (orderingType == null) {
            return this.parent.getSortNoneIcon();
        }
        if (orderingType.mode == -1) {
            return this.parent.getSortDownIcon();
        }
        if (orderingType.mode == 1) {
            return this.parent.getSortUpIcon();
        }
        return null;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.sortingColumns.size() == 0) {
            if (!this.onlyrepaint) {
                this.clearSortingState();
            }
            this.fireTableChanged(tableModelEvent);
        } else if (tableModelEvent.getFirstRow() == -1) {
            if (!this.onlyrepaint) {
                this.cancelSorting();
            }
            this.fireTableChanged(tableModelEvent);
        } else if (tableModelEvent.getFirstRow() == tableModelEvent.getLastRow() && tableModelEvent.getColumn() != -1 && this.getSortingStatus(tableModelEvent.getColumn()) == 0 && this.modelToViewer != null) {
            this.fireTableChanged(new TableModelEvent(this, this.getModelToViewer()[tableModelEvent.getFirstRow()], this.getModelToViewer()[tableModelEvent.getFirstRow()], tableModelEvent.getColumn(), tableModelEvent.getType()));
        } else {
            if (!this.onlyrepaint) {
                this.clearSortingState();
            }
            this.fireTableChanged(tableModelEvent);
        }
    }

    public void sendBeginSort(int n2, boolean bl, boolean bl2) {
        this.sendBeginSort(n2, bl, bl2, null);
    }

    private void sendBeginSort(int n2, boolean bl, boolean bl2, GridViewS.DataType dataType) {
        int n3 = this.getSortingStatus(n2);
        if (dataType != null && dataType.isSortType() && dataType.getStartOrdering() == -1) {
            n3 = n3 == 0 ? -1 : (n3 == -1 ? 1 : 0);
        } else {
            n3 += bl2 ? -1 : 1;
            n3 = (n3 + 4) % 3 - 1;
        }
        this.sendBeginSort(n2, n3, bl, dataType);
    }

    public void sendBeginSort(int n2, int n3, boolean bl, GridViewS.DataType dataType) {
        this.parent.getJTable().backupselection();
        if (!bl) {
            this.cancelSorting();
        }
        this.buildSortData(n2, n3);
        if (dataType != null && dataType.isSortType()) {
            this.sendbegincolumnsorttypes = n2;
            this.parent.sendRet(16437, n2, this.sendOrderMode(n3), new Integer(n2));
        } else {
            this.parent.sendRet(16437, 0, this.sendOrderMode(n3), new Integer(n2));
        }
    }

    @Override
    public void fireTableRowsInserted(int n2, int n3) {
        if (this.parent.prop_MASS_UPDATE == 0 && n2 >= 0 && n3 >= 0) {
            this.getTableModel().fireTableRowsInserted(n2, n3);
            if (!this.sortingStatusChanged()) {
                super.fireTableRowsInserted(n2, n3);
            }
        }
    }

    @Override
    public void fireTableRowsDeleted(int n2, int n3) {
        if (this.parent.prop_MASS_UPDATE == 0 && n2 >= 0 && n3 >= 0 && this.getRowCount() >= 0 && n2 <= this.getRowCount() && n3 <= this.getRowCount()) {
            super.fireTableRowsDeleted(n2, n3);
        }
    }

    @Override
    public void fireTableRowsUpdated(int n2, int n3, boolean bl) {
        boolean bl2 = this.onlyrepaint;
        if (!bl) {
            this.onlyrepaint = true;
        }
        if (this.parent.prop_MASS_UPDATE == 0 && n2 >= 0 && n3 >= 0) {
            this.tableModel.fireTableRowsUpdated(n2, n3);
        }
        if (bl) {
            this.sortingStatusChanged();
        }
        this.onlyrepaint = bl2;
    }

    @Override
    public void fireTableRowsUpdated(int n2, int n3) {
        if (this.parent.prop_MASS_UPDATE == 0 && n2 >= 0 && n3 >= 0) {
            this.tableModel.fireTableRowsUpdated(n2, n3);
        }
        this.sortingStatusChanged();
    }

    @Override
    public void fireTableCellRepaint(int n2, int n3) {
        if (this.parent.prop_MASS_UPDATE == 0) {
            this.onlyrepaint = true;
            this.tableModel.fireTableCellUpdated(n2, n3);
            this.onlyrepaint = false;
        }
    }

    @Override
    public void fireTableCellUpdated(int n2, int n3) {
        if (this.parent.prop_MASS_UPDATE == 0) {
            this.tableModel.fireTableCellUpdated(n2, n3);
        }
    }

    @Override
    public void fireTableStructureChanged() {
        if (this.parent.prop_MASS_UPDATE == 0) {
            this.parent.getDataModel().fireTableStructureChanged();
            if (this.parent.getDataModel() != this.tableModel && this.tableModel != null) {
                this.tableModel.fireTableStructureChanged();
            }
            if (this.parent.rowHeader != null) {
                ((GridModel)this.parent.rowHeader.getModel()).fireTableStructureChanged();
            }
        }
        this.sortingStatusChanged();
    }

    @Override
    public void fireTableDataChanged() {
        if (this.parent.prop_MASS_UPDATE == 0) {
            super.fireTableDataChanged();
            if (this.parent.rowHeader != null) {
                ((GridModel)this.parent.rowHeader.getModel()).fireTableDataChanged();
                this.parent.reloadRowHeight(this.parent.rowHeader);
                this.parent.rowHeader.repaint();
                Rectangle rectangle = this.parent.getJTable().getVisibleRect();
                this.parent.rowHeader.scrollRectToVisible(rectangle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int convertRowIndexToModel(int n2) {
        int n3 = n2;
        if (!this.parent.useModelStandard()) {
            Vector vector = this.parent.gridarray;
            synchronized (vector) {
                if (this.sortingColumns.size() > 0 && this.tableModel.getRowCount() > 0) {
                    n3 = this.modelIndex(n2);
                } else if (this.sortingColumns.size() == 0) {
                    n3 = this.tableModel.convertRowIndexToModel(n3);
                }
            }
        }
        if (this.sendbegincolumnsorttypes >= 0) {
            this.parent.sendRet(17034, this.sendbegincolumnsorttypes, this.parent.getLastRow() - 1, new Integer(this.sendbegincolumnsorttypes));
        }
        this.sendbegincolumnsorttypes = -1;
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int convertRowIndexToView(int n2) {
        if (this.parent.useModelStandard()) {
            return n2;
        }
        int n3 = n2;
        Vector vector = this.parent.gridarray;
        synchronized (vector) {
            if (this.sortingColumns.size() == 0) {
                n3 = this.tableModel.convertRowIndexToView(n3);
            } else if (this.sortingColumns.size() > 0 && this.tableModel.getRowCount() > 0) {
                int n4 = 0;
                if (this.getViewerToModel() != null) {
                    int n5 = this.getViewerToModel().length;
                    for (n4 = 0; n4 < n5 && this.viewerToModel[n4].modelIndex != n3; ++n4) {
                    }
                    if (n4 < n5) {
                        n3 = n4;
                    }
                }
            }
        }
        return n3;
    }

    @Override
    public int convertColumnIndexToModel(int n2) {
        return this.tableModel.convertColumnIndexToModel(n2);
    }

    @Override
    public int convertColumnIndexToView(int n2) {
        return this.tableModel.convertColumnIndexToView(n2);
    }

    @Override
    public boolean isColumnHide(int n2) {
        boolean bl = this.tableModel.isColumnHide(n2);
        return bl;
    }

    @Override
    public boolean isRowHide(int n2) {
        int n3 = this.convertRowIndexToModel(n2);
        boolean bl = this.tableModel.isRowHide(n3);
        return bl;
    }

    private int sendOrderMode(int n2) {
        if (n2 == -1) {
            return 2;
        }
        if (n2 == 1) {
            return 1;
        }
        return 0;
    }

    private int receiveOrderMode(int n2) {
        if (n2 == 2) {
            return -1;
        }
        if (n2 == 1) {
            return 1;
        }
        return 0;
    }

    private char getOrderMode(int n2) {
        if (n2 == -1) {
            return '2';
        }
        if (n2 == 1) {
            return '1';
        }
        return '0';
    }

    private int getOrderMode(char c2) {
        if (c2 == '2') {
            return -1;
        }
        if (c2 == '1') {
            return 1;
        }
        return 0;
    }

    private char getDataType(int n2) {
        return '1';
    }

    private void writeelemsd(char[] cArray, int n2, int n3, int n4) {
        String string = new Integer(n2).toString();
        while (string.length() < 4) {
            string = "0".concat(string);
        }
        for (int i2 = 0; i2 < 4; ++i2) {
            cArray[n3 * 6 + i2] = string.charAt(i2);
            cArray[n3 * 6 + 4] = this.getOrderMode(n4);
            cArray[n3 * 6 + 4 + 1] = this.getDataType(n3);
        }
    }

    private void buildSortData(int n2, int n3) {
        OrderingType orderingType2 = null;
        char[] cArray = null;
        cArray = this.initializeSortData(this.parent.getDataColumnSize());
        String string = "";
        boolean bl = false;
        int n4 = 1;
        boolean bl2 = false;
        for (OrderingType orderingType2 : this.sortingColumns) {
            if (orderingType2.column != n2) {
                this.writeelemsd(cArray, n4++, orderingType2.column, orderingType2.mode);
                continue;
            }
            bl2 = true;
            this.writeelemsd(cArray, n4++, n2, n3);
        }
        if (!bl2) {
            this.writeelemsd(cArray, n4, n2, n3);
        }
        this.internalsortdata = new String(cArray);
    }

    public void setSortData(String string) {
        Object var2_2 = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.parent.getDataColumnSize();
        int n5 = 0;
        String string2 = "";
        boolean bl = false;
        int n6 = -1;
        boolean bl2 = false;
        OrderingType[] orderingTypeArray = new OrderingType[n4];
        this.sortingColumns.clear();
        if (string == null || string.length() == 0) {
            this.sortdata = string;
            return;
        }
        n5 = string.length() / 6;
        for (n2 = 0; n2 < n4 && n2 < n5; ++n2) {
            string2 = string.substring(n2 * 6, n2 * 6 + 4);
            n6 = -1;
            bl = false;
            try {
                if (string2 != null) {
                    n6 = (int)Float.parseFloat(string2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
            }
            if (n6 < 1 || n6 > n4 || (n3 = this.getOrderMode(string.charAt(n2 * 6 + 4))) == 0) continue;
            orderingTypeArray[n6 - 1] = new OrderingType(n2, n3);
        }
        for (n2 = 0; n2 < n4; ++n2) {
            if (orderingTypeArray[n2] != null) {
                this.sortingColumns.add(orderingTypeArray[n2]);
            }
            orderingTypeArray[n2] = null;
        }
        this.sortdata = string;
    }

    private String verifyFill(String string, int n2) {
        if (string != null) {
            while (string.length() < n2 * 6) {
                string = string + "0";
            }
        }
        return string;
    }

    private char[] initializeSortData(int n2) {
        int n3 = 0;
        int n4 = 0;
        char[] cArray = null;
        if (n2 > 0) {
            cArray = new char[n2 * 6];
            for (n3 = 0; n3 < n2; ++n3) {
                for (n4 = n3 * 6; n4 < 6 * (n3 + 1); ++n4) {
                    cArray[n4++] = 48;
                }
            }
        }
        return cArray;
    }

    public String getSortData() {
        if (this.internalsortdata == null) {
            this.internalsortdata = this.sortdata != null ? new String(this.sortdata) : new String(this.initializeSortData(this.parent.getDataColumnSize()));
        }
        this.internalsortdata = this.verifyFill(this.internalsortdata, this.parent.getDataColumnSize());
        return this.internalsortdata;
    }

    public void goSortData() {
        if (this.sortdata != null && this.sortdata.trim().length() > 0 && !this.sortdata.equals(this.internalsortdata)) {
            this.internalsortdata = new String(this.sortdata);
            this.sortingStatusChanged();
        }
    }

    public void goBeginSort(Integer n2, int n3) {
        if (n2 == null) {
            this.goSortData();
        } else {
            int n4 = n2;
            this.setSortingStatus(n4, this.receiveOrderMode(n3));
        }
    }

    private void debug(int n2) {
        System.out.println(" status [" + n2 + "]");
        for (OrderingType orderingType : this.sortingColumns) {
            System.out.println(" col [" + orderingType.column + "] type [" + orderingType.mode + "]");
        }
    }

    public MouseListener getMouseListener() {
        return this.mouseListener;
    }

    public boolean hasSortingColumns() {
        return this.sortingColumns.size() > 0;
    }

    private static class OrderingType {
        private int column;
        private int mode;

        public OrderingType(int n2, int n3) {
            this.column = n2;
            this.mode = n3;
        }
    }

    private static class SortStateIcon
    implements Icon {
        private boolean descending;
        private int size;

        public SortStateIcon(boolean bl, int n2) {
            this.descending = bl;
            this.size = n2;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            Color color = component == null ? Color.GRAY : component.getBackground();
            int n4 = this.size / 2;
            int n5 = this.descending ? n4 : -n4;
            n3 = n3 + 5 * this.size / 6 + (this.descending ? -n5 : 0);
            int n6 = this.descending ? 1 : -1;
            graphics.translate(n2, n3);
            graphics.setColor(color.darker());
            graphics.drawLine(n4 / 2, n5, 0, 0);
            graphics.drawLine(n4 / 2, n5 + n6, 0, n6);
            graphics.setColor(color.brighter());
            graphics.drawLine(n4 / 2, n5, n4, 0);
            graphics.drawLine(n4 / 2, n5 + n6, n4, n6);
            if (this.descending) {
                graphics.setColor(color.darker().darker());
            } else {
                graphics.setColor(color.brighter().brighter());
            }
            graphics.drawLine(n4, 0, 0, 0);
            graphics.setColor(color);
            graphics.translate(-n2, -n3);
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 || !((GridModelSorter)GridModelSorter.this).parent.finishentryok) {
                mouseEvent.consume();
                return;
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 || !((GridModelSorter)GridModelSorter.this).parent.finishentryok) {
                mouseEvent.consume();
                return;
            }
            if (SwingUtilities.isRightMouseButton(mouseEvent) && GridModelSorter.this.parent.getHeadingMenuPopup() == 1) {
                return;
            }
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
            int n2 = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            int n3 = GridModelSorter.this.convertColumnIndexToModel(n2);
            if (n3 != -1) {
                int n4 = GridModelSorter.this.parent.getNumRowFromPixel(mouseEvent.getY(), true);
                if (n4 == GridModelSorter.this.parent.getNumColHeadings() && GridModelSorter.this.parent.getShowFilterType3() >= 0) {
                    return;
                }
                int n5 = -1;
                n5 = GridModelSorter.this.parent.mousePressedOverBitmapOrFilterIcon(mouseEvent, n4, n3, GridModelSorter.this.parent.getJTable(), n4, true);
                if (n5 == 2) {
                    return;
                }
                GridViewS.DataType dataType = GridModelSorter.this.parent.getSortType(n3);
                if (!(dataType == null || dataType.isSortType() && dataType.getTypeEditFieldValue() == 12)) {
                    if (dataType != null && dataType.isSortType()) {
                        GridModelSorter.this.sendBeginSort(n3, mouseEvent.isControlDown(), mouseEvent.isShiftDown(), dataType);
                    } else {
                        GridModelSorter.this.sendBeginSort(n3, mouseEvent.isControlDown(), mouseEvent.isShiftDown());
                    }
                }
            }
        }
    }

    private class Row
    implements Comparable {
        private int modelIndex;

        public Row(int n2) {
            this.modelIndex = n2;
        }

        public int getIndex() {
            return this.modelIndex;
        }

        public int compareTo(Object object) {
            int n2 = this.modelIndex;
            int n3 = ((Row)object).modelIndex;
            int n4 = 0;
            OrderingType orderingType2 = null;
            GridCell gridCell = null;
            GridCell gridCell2 = null;
            for (OrderingType orderingType2 : GridModelSorter.this.sortingColumns) {
                gridCell = (GridCell)GridModelSorter.this.tableModel.getValueAt(n2, orderingType2.column);
                n4 = gridCell.compare(gridCell2 = (GridCell)GridModelSorter.this.tableModel.getValueAt(n3, orderingType2.column), orderingType2.column);
                if (n4 == 0) continue;
                int n5 = n4 = orderingType2.mode == -1 ? -n4 : n4;
                break;
            }
            if (gridCell != null && (gridCell.getText() == null || gridCell.getText() != null && gridCell.getText().length() == 0) && GridModelSorter.this.parent.getNumRows() == -1 && n2 == GridModelSorter.this.parent.getLastRow() - GridModelSorter.this.parent.getNumColHeadings()) {
                n4 = orderingType2.mode == 1 ? -n4 : n4;
            } else if (gridCell2 != null && (gridCell2.getText() == null || gridCell2.getText() != null && gridCell2.getText().length() == 0) && GridModelSorter.this.parent.getNumRows() == -1 && n3 == GridModelSorter.this.parent.getLastRow() - GridModelSorter.this.parent.getNumColHeadings()) {
                n4 = orderingType2.mode == 1 ? -n4 : n4;
            }
            return n4;
        }
    }
}

