/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.Constants;
import com.iscobol.gui.client.swing.GridConstant;
import com.iscobol.gui.client.swing.GridJTable;
import com.iscobol.gui.client.swing.GridViewS;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

class GridMouseMotionListenerAdapter
implements Constants,
GridConstant,
MouseMotionListener {
    GridViewS parent;
    String type;
    boolean isHeader;
    private GridJTable tab;
    private int numcol = -1;
    private int numrow = -1;

    GridMouseMotionListenerAdapter(GridViewS gridViewS, String string, boolean bl, GridJTable gridJTable) {
        this.parent = gridViewS;
        this.type = string;
        this.isHeader = bl;
        this.tab = gridJTable;
    }

    public int getcolumnnum(MouseEvent mouseEvent) {
        TableColumnModel tableColumnModel = this.tab.getColumnModel();
        this.numcol = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
        return this.numcol;
    }

    public int getrownum(MouseEvent mouseEvent) {
        int n2 = this.parent.getNumRowFromPixel(mouseEvent.getY(), this.isHeader);
        if (!this.isHeader) {
            n2 += this.parent.getNumColHeadings();
        }
        if (n2 >= this.parent.getRowCount() + this.parent.getNumColHeadings()) {
            n2 = this.parent.getRowCount() + this.parent.getNumColHeadings() - 1;
        }
        this.numrow = n2;
        return n2;
    }

    public String inizio(MouseEvent mouseEvent) {
        String string = new String();
        string = " CLICK [" + mouseEvent.getClickCount() + "] COLONNA [" + this.getcolumnnum(mouseEvent) + "] ROW [" + this.getrownum(mouseEvent) + "]";
        return string;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.parent.finishentryok) {
            mouseEvent.consume();
            return;
        }
        this.getcolumnnum(mouseEvent);
        this.getrownum(mouseEvent);
        int n2 = this.numcol;
        if (this.isHeader) {
            n2 = this.parent.getModel().convertColumnIndexToModel(this.numcol);
            this.parent.repaintHeadingElement(true, this.numrow, n2);
        }
        int n3 = this.parent.getAbsoluteRowNoHeaderModel(this.numrow);
        if (!this.parent.isingridrect(mouseEvent.getLocationOnScreen())) {
            return;
        }
        this.parent.sendMsgNotifyMouseData1Data2(n3, n2);
        if (this.numrow == -1 || this.numcol == -1 || this.parent.jumpCell(this.numrow, this.numcol) == 2) {
            mouseEvent.consume();
            return;
        }
        if (this.parent.style_REORDERING_COLUMNS) {
            boolean bl = false;
            JTableHeader jTableHeader = this.parent.getJTable().getTableHeader();
            int n4 = this.tab.convertColumnIndexToModel(this.numcol);
            if (!this.parent.isInHeaderV(n4)) {
                bl = true;
            }
            if (jTableHeader != null) {
                jTableHeader.setReorderingAllowed(bl);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.parent.finishentryok) {
            mouseEvent.consume();
            return;
        }
        this.getcolumnnum(mouseEvent);
        this.getrownum(mouseEvent);
        if (this.numrow == -1 || this.numcol == -1 || this.parent.jumpCell(this.numrow, this.numcol) == 2) {
            mouseEvent.consume();
            return;
        }
        int n2 = this.parent.getAbsoluteRowNoHeaderModel(this.numrow);
        int n3 = this.parent.getModel().convertColumnIndexToModel(this.numcol);
        if (this.parent.isDraggedOver(mouseEvent.getX(), mouseEvent.getY(), this.numcol, this.numrow, this.isHeader, mouseEvent)) {
            return;
        }
        boolean bl = this.isHeader;
        int n4 = 0;
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            return;
        }
        TableColumn tableColumn = this.parent.getColumnResized();
        if (tableColumn != null) {
            int n5 = 0;
            for (n5 = 0; n5 < this.parent.getJTable().getColumnModel().getColumnCount() && tableColumn != this.parent.getJTable().getColumnModel().getColumn(n5); ++n5) {
            }
            if (n5 < this.parent.getJTable().getColumnModel().getColumnCount()) {
                this.numcol = n5;
            }
            this.parent.setLastRowColDragged(this.numrow, this.tab.getMyModel().convertColumnIndexToModel(this.numcol));
            this.parent.setBeginDrag(40);
            return;
        }
        int n6 = this.tab.getMyModel().convertColumnIndexToModel(this.numcol);
        if (this.parent.isInHeader(this.numrow, this.numcol)) {
            bl = true;
        }
        if ((n4 = this.parent.getBeginDrag()) == 0) {
            this.parent.setBeginDrag(bl, this.numrow, this.numcol, n6);
            n4 = this.parent.getBeginDrag();
            if (n4 != 0) {
                return;
            }
        }
        boolean bl2 = this.parent.changeRowColDragged(this.numrow, n6);
        if (n4 != 0 && bl2) {
            if (this.parent.getBeginDrag() == 10) {
                this.parent.sendRetDragEvent(16405, this.numcol, 0, n6, 0);
            } else if (this.parent.getBeginDrag() == 20) {
                this.parent.sendRetDragEvent(16405, this.numcol, this.numrow, this.numcol, this.numrow);
            } else if (!bl && !this.parent.getJTable().isEditing()) {
                this.parent.setLastColCursor(n6);
                this.parent.setLastRowCursor(this.numrow);
                this.parent.sendRetDragEvent(16404, this.numcol, this.numrow, n6, this.parent.getAbsoluteRowNoHeaderModel(this.numrow));
            }
        }
    }
}

