/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.Constants;
import com.iscobol.gui.client.swing.GridViewS;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.event.MouseInputAdapter;

public class GridTableAdjustableRows
extends MouseInputAdapter
implements Constants {
    public Cursor resizeCursor;
    private Cursor otherCursor;
    private Cursor initialCursor;
    private GridViewS parent;
    private JTable table;
    private int mousepressedY;
    private int adjustRow = -1;
    private int adjustRowCandidate = -1;
    private int newHeight = -1;
    private int minvalue;
    private int maxvalue;

    public GridTableAdjustableRows(GridViewS gridViewS, JTable jTable) {
        this.parent = gridViewS;
        this.otherCursor = this.resizeCursor = Cursor.getPredefinedCursor(8);
        this.table = jTable;
        this.initialCursor = this.table.getCursor();
        this.table.addMouseListener(this);
        this.table.addMouseMotionListener(this);
    }

    public void removeListenerAdjustableRows() {
        this.table.removeMouseListener(this);
        this.table.removeMouseMotionListener(this);
        this.table.setCursor(this.initialCursor);
    }

    private int getAdjustableRow(Point point) {
        return this.getAdjustableRow(point, this.table.rowAtPoint(point));
    }

    private int getAdjustableRow(Point point, int n2) {
        if (n2 == -1) {
            return -1;
        }
        int n3 = this.table.columnAtPoint(point);
        if (n3 == -1) {
            return -1;
        }
        Rectangle rectangle = this.table.getCellRect(n2, n3, true);
        rectangle.grow(0, -3);
        if (rectangle.contains(point)) {
            return -1;
        }
        int n4 = rectangle.y + rectangle.height / 2;
        int n5 = point.y < n4 ? n2 - 1 : n2;
        return n5;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        this.adjustRowCandidate = this.adjustRow = this.getAdjustableRow(point);
        this.mousepressedY = point.y - this.table.getRowHeight(this.adjustRow);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.newHeight >= 0 && this.adjustRow >= 0) {
            this.parent.sendRet(16438, this.adjustRow + this.parent.getNumColHeadings(), this.newHeight / this.parent.font.getHeight(), false);
            this.adjustRow = -1;
            this.adjustRowCandidate = -1;
            this.newHeight = -1;
            this.parent.setBeginDrag(0);
            this.parent.setLastRowColDragged(-99, -99);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.adjustRowCandidate = this.getAdjustableRow(mouseEvent.getPoint());
        if (this.adjustRowCandidate >= 0 != (this.table.getCursor() == this.resizeCursor)) {
            Cursor cursor = this.table.getCursor();
            this.table.setCursor(this.otherCursor);
            if (this.otherCursor != this.resizeCursor) {
                this.adjustRowCandidate = -1;
            }
            this.otherCursor = cursor;
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.adjustRow >= 0) {
            this.parent.setBeginDrag(50);
            this.newHeight = mouseEvent.getY() - this.mousepressedY;
            if (this.newHeight >= this.minvalue && this.newHeight <= this.maxvalue) {
                this.parent.intsetRowHeight(this.adjustRow + this.parent.getNumColHeadings(), this.newHeight);
                this.parent.getJTable().setRowHeight(this.adjustRow, this.newHeight);
            }
        }
    }

    public void setMinMaxHeight(int n2, int n3, float f2) {
        this.minvalue = n2;
        this.maxvalue = (int)(f2 * (float)n3);
    }

    public int getAdjustRowCandidate() {
        return this.adjustRowCandidate;
    }
}

