/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import java.awt.Dimension;
import java.awt.Insets;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class InputList
extends JPanel
implements DocumentListener,
ListSelectionListener {
    protected JLabel label = new JLabel();
    protected JTextField textfield;
    protected JList list;
    protected JScrollPane scroll;

    public InputList(Object[] objectArray, String string) {
        this.setLayout(null);
        this.add(this.label);
        this.textfield = new OpelListText();
        this.label.setLabelFor(this.textfield);
        this.add(this.textfield);
        this.list = new OpelListList(objectArray);
        this.list.setVisibleRowCount(4);
        this.textfield.getDocument().addDocumentListener(this);
        this.list.addListSelectionListener(this);
        this.scroll = new JScrollPane(this.list);
        this.add(this.scroll);
    }

    @Override
    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.label.setToolTipText(string);
        this.textfield.setToolTipText(string);
        this.list.setToolTipText(string);
    }

    public void setDisplayedMnemonic(char c2) {
        this.label.setDisplayedMnemonic(c2);
    }

    public void setSelected(Object object) {
        this.list.removeListSelectionListener(this);
        this.textfield.getDocument().removeDocumentListener(this);
        this.list.setSelectedValue(object, true);
        this.textfield.setText(object.toString());
        this.list.addListSelectionListener(this);
        this.textfield.getDocument().addDocumentListener(this);
    }

    public String getSelected() {
        Object e2 = this.list.getSelectedValue();
        return e2 != null ? e2.toString() : null;
    }

    public void setSelectedInt(int n2) {
        this.setSelected(new Integer(n2));
    }

    public int getSelectedInt() {
        try {
            return Integer.parseInt(this.getSelected());
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object e2 = this.list.getSelectedValue();
        if (e2 != null) {
            this.textfield.getDocument().removeDocumentListener(this);
            this.textfield.setText(e2.toString());
            this.textfield.getDocument().addDocumentListener(this);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.textValueChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.textValueChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    private void textValueChanged() {
        ListModel listModel = this.list.getModel();
        if (listModel == null) {
            return;
        }
        this.list.removeListSelectionListener(this);
        String string = this.textfield.getText().toLowerCase();
        int n2 = -1;
        if (listModel.getElementAt(0) instanceof String) {
            boolean bl = false;
            for (n2 = 0; !bl && n2 < listModel.getSize(); ++n2) {
                String string2 = (String)listModel.getElementAt(n2);
                if (!string2.toLowerCase().startsWith(string)) continue;
                this.list.setSelectedValue(string2, true);
                bl = true;
            }
            if (!bl) {
                this.list.clearSelection();
            }
        } else if (listModel.getElementAt(0) instanceof Integer) {
            try {
                Integer n3 = new Integer(string);
                boolean bl = false;
                for (n2 = 0; !bl && n2 < listModel.getSize(); ++n2) {
                    Integer n4 = (Integer)listModel.getElementAt(n2);
                    if (n4.compareTo(n3) != 0) continue;
                    this.list.setSelectedValue(n4, true);
                    bl = true;
                }
                if (!bl) {
                    this.list.clearSelection();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.list.addListSelectionListener(this);
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.list.addListSelectionListener(listSelectionListener);
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        Dimension dimension = this.label.getPreferredSize();
        Dimension dimension2 = this.textfield.getPreferredSize();
        Dimension dimension3 = this.scroll.getPreferredSize();
        int n2 = Math.max(Math.max(dimension.width, dimension2.width), dimension3.width);
        int n3 = dimension.height + dimension2.height + dimension3.height;
        return new Dimension(n2 + insets.left + insets.right, n3 + insets.top + insets.bottom);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void doLayout() {
        Insets insets = this.getInsets();
        Dimension dimension = this.getSize();
        int n2 = insets.left;
        int n3 = insets.top;
        int n4 = dimension.width - insets.left - insets.right;
        int n5 = dimension.height - insets.top - insets.bottom;
        Dimension dimension2 = this.label.getPreferredSize();
        this.label.setBounds(n2, n3, n4, dimension2.height);
        Dimension dimension3 = this.textfield.getPreferredSize();
        this.textfield.setBounds(n2, n3 += dimension2.height, n4, dimension3.height);
        this.scroll.setBounds(n2, n3 += dimension3.height, n4, n5 - n3);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleOpenList();
        }
        return this.accessibleContext;
    }

    protected class AccessibleOpenList
    extends JComponent.AccessibleJComponent {
        protected AccessibleOpenList() {
            super(InputList.this);
        }

        @Override
        public String getAccessibleName() {
            System.out.println("getAccessibleName: " + this.accessibleName);
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            return InputList.this.label.getText();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST;
        }
    }

    class OpelListList
    extends JList {
        public OpelListList() {
        }

        public OpelListList(Object[] objectArray) {
            super(objectArray);
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            return InputList.this.getAccessibleContext();
        }

        @Override
        public void setSelectedIndex(int n2) {
            this.ensureIndexIsVisible(n2);
            super.setSelectedIndex(n2);
        }
    }

    class OpelListText
    extends JTextField {
        public OpelListText() {
        }

        public OpelListText(int n2) {
            super(n2);
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            return InputList.this.getAccessibleContext();
        }
    }

    class OpelListLabel
    extends JLabel {
        public OpelListLabel(String string, int n2) {
            super(string, n2);
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            return InputList.this.getAccessibleContext();
        }
    }
}

