/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.swing.IsTextIcon;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import java.awt.Color;
import java.awt.font.TextAttribute;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;

public class Label
extends JLabel {
    public static final int DEFAULT_H_ALIGNMENT = 2;
    public static final int DEFAULT_V_ALIGNMENT = 1;
    private int hAlignment = 2;
    private int vAlignment = 1;
    private boolean multiline;
    private boolean vertical;
    private boolean noKeyLetter;
    private boolean transparent;
    private String title = "";
    private int mnemonicIndex = -1;
    private Color savefg;

    void updateAlignment() {
        this.setAlignment(this.hAlignment, this.vAlignment);
    }

    private void reloadTitle(String string) {
        if (this.hAlignment == 0) {
            this.setText(RemoteBaseGUIControl.buildTitle(string, !this.noKeyLetter ? this.mnemonicIndex : -1, true, false, this.isUnderlined()));
        } else if (this.hAlignment == 4) {
            this.setText(RemoteBaseGUIControl.buildTitle(string, !this.noKeyLetter ? this.mnemonicIndex : -1, false, true, this.isUnderlined()));
        } else {
            this.setText(RemoteBaseGUIControl.buildTitle(string, !this.noKeyLetter ? this.mnemonicIndex : -1, false, false, this.isUnderlined()));
        }
    }

    boolean isUnderlined() {
        return this.getFont().getAttributes().get(TextAttribute.UNDERLINE) == TextAttribute.UNDERLINE_ON;
    }

    public void setTitle(String string) {
        this.title = string;
        if (this.title == null || this.title.length() == 0) {
            this.setText("");
            return;
        }
        string = this.checkTitle(string);
        if (this.vertical) {
            this.setAlignment(this.hAlignment, this.vAlignment);
        } else {
            if (this.multiline) {
                this.reloadTitle(string);
            } else {
                this.setText(string);
            }
            if (this.vAlignment != this.getVerticalAlignment()) {
                this.setVerticalAlignment(this.vAlignment);
            }
        }
    }

    private String checkTitle(String string) {
        if (!this.noKeyLetter) {
            StringBuffer stringBuffer = new StringBuffer(string);
            this.mnemonicIndex = ScreenUtility.getMnemonicIdx(stringBuffer);
            string = stringBuffer.toString();
        }
        return string;
    }

    public void setAlignment(int n2, int n3) {
        this.hAlignment = n2;
        this.vAlignment = n3;
        if (this.vertical) {
            this.setText(null);
            int n4 = this.hAlignment == 4 ? 4 : 2;
            this.setIcon(new IsTextIcon(this, this.checkTitle(this.title), n4));
            if (this.vAlignment != this.getVerticalAlignment()) {
                this.setVerticalAlignment(this.vAlignment);
            }
            this.setHorizontalAlignment(0);
        } else {
            this.setIcon(null);
            this.setTitle(this.title);
            if (this.hAlignment != this.getHorizontalAlignment()) {
                this.setHorizontalAlignment(this.hAlignment);
            }
        }
        this.repaint();
    }

    public void setNoKeyLetter(boolean bl) {
        this.noKeyLetter = bl;
        this.setTitle(this.title);
    }

    public void setTransparent(boolean bl) {
        this.transparent = bl;
        this.setOpaque(!this.transparent);
        this.repaint();
    }

    public void setCentered(boolean bl) {
        if (bl) {
            if (this.vertical) {
                this.setAlignment(this.hAlignment, 0);
            } else {
                this.setAlignment(0, this.vAlignment);
            }
        } else if (this.vertical) {
            this.setAlignment(this.hAlignment, 1);
        } else {
            this.setAlignment(2, this.vAlignment);
        }
    }

    public void setLeft(boolean bl) {
        if (bl) {
            this.setAlignment(2, this.vAlignment);
        } else {
            this.setAlignment(2, this.vAlignment);
        }
    }

    public void setRight(boolean bl) {
        if (bl) {
            this.setAlignment(4, this.vAlignment);
        } else {
            this.setAlignment(2, this.vAlignment);
        }
    }

    public void setTop(boolean bl) {
        this.setVertical(bl);
        if (bl) {
            this.setAlignment(this.hAlignment, 1);
        } else {
            this.setAlignment(this.hAlignment, 1);
        }
    }

    public void setBottom(boolean bl) {
        this.setVertical(bl);
        if (bl) {
            this.setAlignment(this.hAlignment, 3);
        } else {
            this.setAlignment(this.hAlignment, 1);
        }
    }

    public void setVertical(boolean bl) {
        this.vertical = bl;
    }

    public void setMultiline(boolean bl) {
        this.multiline = bl;
    }

    private void buildForeground(boolean bl) {
        if (this.getText() != null) {
            if (!bl) {
                Color color;
                if (this.savefg == null) {
                    this.savefg = this.getForeground();
                }
                if ((color = UIManager.getColor("Label.disabledForeground")) == null) {
                    color = new ColorUIResource(153, 153, 153);
                }
                super.setForeground(color);
            } else if (this.savefg != null) {
                this.setForeground(this.savefg);
                this.savefg = null;
            }
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.buildForeground(bl);
    }

    @Override
    public void setForeground(Color color) {
        if (!this.isEnabled()) {
            this.savefg = color;
        } else {
            super.setForeground(color);
        }
    }
}

