/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.Constants;
import com.iscobol.gui.IsguiWorker;
import com.iscobol.gui.PagedListBoxEvent;
import com.iscobol.gui.PagedListBoxListener;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.VirtualKeyboard;
import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import com.iscobol.gui.client.IscobolLayout;
import com.iscobol.gui.client.LocalFontCmp;
import com.iscobol.gui.client.PicobolWidget;
import com.iscobol.gui.client.ZoomLayout;
import com.iscobol.gui.client.swing.FindJPanel;
import com.iscobol.gui.client.swing.GradientManager;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.NotifyMouseEvent;
import com.iscobol.gui.client.swing.NotifyMouseListener;
import com.iscobol.gui.client.swing.SwingFontCmp;
import com.iscobol.gui.client.swing.SwingWorker;
import com.iscobol.rts.Factory;
import com.iscobol.types.CobolVar;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class ListBox
extends JPanel
implements Constants,
FindJPanel.FindListener,
ItemSelectable {
    private static final long serialVersionUID = 1L;
    private NotifyMouseListener nmListener = null;
    private Color defaultMatchingTextColorBackground;
    private Color matchingTextColorBackground = this.defaultMatchingTextColorBackground = new Color(255, 215, 50);
    private Color matchingTextColorForeground = null;
    private static Comparator<ListItem> ignoreCaseComparator = (listItem, listItem2) -> listItem.text.compareToIgnoreCase(listItem2.text);
    protected static final int BUTTON_PANEL_WIDTH = new JScrollBar((int)1).getPreferredSize().width;
    public static final int UNALIGNED = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int LEFT = 3;
    private SearchDocumentListener searchDocumentListener = new SearchDocumentListener();
    private FocusListener searchFocusListener = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent focusEvent) {
            Component component = focusEvent.getOppositeComponent();
            if (!ListBox.this.checkMenuSelected(component)) {
                ListBox.this.hideSearchBox(component == null || !(component instanceof PicobolWidget) || component instanceof JComponent && (JComponent)component == ListBox.this.list);
            }
        }
    };
    private boolean fireNtfChange = true;
    private JPanel checkPanel;
    private ItemListener checkListItemListener = itemEvent -> {
        if (this.fireNtfChange && (itemEvent.getStateChange() == 1 || this.getSelectionMode() != 0)) {
            for (int i2 = 0; i2 < this.checkPanel.getComponentCount(); ++i2) {
                if (this.checkPanel.getComponent(i2) != itemEvent.getSource()) continue;
                this.lastMouseSelectedIndex = i2;
                this.dispatchListSelectionEvent(this.lastMouseSelectedIndex);
                break;
            }
        }
    };
    private FocusListener checkListFocusListener = new FocusListener(){

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (ListBox.this.focusListener != null) {
                ListBox.this.focusListener.focusLost(focusEvent);
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            ListBox.this.focusedButton = (JToggleButton)focusEvent.getComponent();
            ListBox.this.checkPanel.scrollRectToVisible(focusEvent.getComponent().getBounds());
            if (ListBox.this.focusListener != null) {
                ListBox.this.focusListener.focusGained(focusEvent);
            }
        }
    };
    private MouseListener checkListMouseListener = new MouseListener(){

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (ListBox.this.mouseListener != null) {
                ListBox.this.mouseListener.mouseReleased(mouseEvent);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (ListBox.this.mouseListener != null) {
                ListBox.this.mouseListener.mousePressed(mouseEvent);
            }
            if (mouseEvent.getComponent() instanceof JToggleButton) {
                ListBox.this.focusedButton = (JToggleButton)mouseEvent.getComponent();
            }
            ListBox.this.requestFocus();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            ListBox.this.check(mouseEvent);
            if (ListBox.this.mouseListener != null) {
                ListBox.this.mouseListener.mouseExited(mouseEvent);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            Component[] componentArray = ListBox.this.checkPanel.getComponents();
            int n2 = -1;
            for (int i2 = 0; n2 == -1 && i2 < componentArray.length; ++i2) {
                if (componentArray[i2] != mouseEvent.getSource()) continue;
                n2 = i2;
            }
            if (ListBox.this.nmListener != null && n2 >= 0) {
                ListBox.this.nmListener.sendNotifyMouseData(new NotifyMouseEvent(mouseEvent.getSource(), 17023, n2 + 1, 1));
            } else if (ListBox.this.nmListener != null && n2 == -1) {
                ListBox.this.nmListener.sendNotifyMouseData(new NotifyMouseEvent(mouseEvent.getSource(), 17024, 0, 0));
            }
            if (ListBox.this.mouseListener != null) {
                ListBox.this.mouseListener.mouseEntered(mouseEvent);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (ListBox.this.mouseListener != null) {
                ListBox.this.mouseListener.mouseClicked(mouseEvent);
            }
        }
    };
    private KeyListener checkListKeyListener = new KeyListener(){

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (ListBox.this.keyListener != null) {
                ListBox.this.keyListener.keyTyped(keyEvent);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (ListBox.this.keyListener != null) {
                ListBox.this.keyListener.keyReleased(keyEvent);
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (ListBox.this.keyListener != null) {
                ListBox.this.keyListener.keyPressed(keyEvent);
                if (ListBox.this.showFindPanel(keyEvent)) {
                    return;
                }
            }
        }
    };
    private boolean checkList;
    private HashSet<JToggleButton> opaqueButtons = new HashSet();
    private MyScrollPane checkScrollPane;
    private JToggleButton focusedButton;
    private JPanel listPanel;
    private JTextField searchBox;
    private JPanel buttonPanel;
    private JListWithDividers list;
    private PagedEventDispatcher ped;
    private KeyEventDispatcher ked;
    private PagedListButton[] buttons;
    private CardLayout firstCardLayout;
    private CardLayout lastCardLayout;
    private JPanel firstCardPanel;
    private JPanel lastCardPanel;
    private MyScrollPane listScrollPane;
    private LocalFontCmp fontCmp;
    private GuiFactoryImpl gf;
    private boolean lmOnColumns;
    private int selectionMode;
    private ItemListener itemListener;
    private MouseListener mouseListener;
    private FocusListener focusListener;
    private KeyListener keyListener;
    private FilteredListModel model = new FilteredListModel();
    private FastCellRenderer renderer;
    private Vector dataColumns;
    private Vector displayColumns;
    private Vector dividers;
    private Vector separators;
    private Vector alignments;
    private boolean upper;
    private boolean lower;
    private boolean unsorted;
    private int sortOrder;
    private float cellWidth;
    private int fontHeight;
    private Column[] column;
    private boolean paged;
    private boolean isNoSearch;
    private int thumbPosition;
    private Vector pListeners = new Vector();
    private int rows = 5;
    private int origWidth;
    private int origHeight;
    private int XPos;
    private int YPos;
    private int mousewheellinestoscroll = 1;
    private Vector rowColorPatterns;
    private Font font;
    private Color background;
    private Color foreground;
    private MyButtonGroup radioGroup;
    private SearchKeyListener searchKeyListener = new SearchKeyListener();
    private int upperLowerMethod;
    private boolean f4ShowsSearchBox = true;
    private int lastMouseSelectedIndex = -2;
    private GradientManager gradientMgr;
    private FindTimer findTimer;
    private int findtimerdelay;
    private FindJPanel panelfind = null;
    private ImageIcon closeIcon;
    private ImageIcon findIcon;
    private ImageIcon clearIcon;
    private ImageIcon casesensitiveIcon;
    private ImageIcon casenotsensitiveIcon;
    private boolean casesensitiveState;
    private Border syntaxborderok;
    private Border syntaxbordererr;
    private Window parentwindow;
    private Cursor lastCursor;
    private static final Cursor BUSY_CURSOR = new Cursor(3);
    private int prop_SEARCH_PANEL;
    private JList dragcomponent;

    public ListBox(GuiFactoryImpl guiFactoryImpl, boolean bl, boolean bl2, boolean bl3, boolean bl4, GradientManager gradientManager) {
        if (bl4) {
            super.setName("IscobolListBoxPanel");
        }
        this.gf = guiFactoryImpl;
        this.setLayout(new BorderLayout(0, 0));
        this.paged = bl;
        this.isNoSearch = bl2;
        this.intSetCheckList(bl3);
        this.gradientMgr = gradientManager;
        this.gradientMgr.addPropertyChangeListener(propertyChangeEvent -> {
            this.setOpaque();
            if (this.checkList) {
                this.checkScrollPane.getViewport().repaint();
            } else if (this.paged) {
                this.list.repaint();
            } else {
                this.listScrollPane.getViewport().repaint();
            }
        });
        this.setOpaque();
        this.closeIcon = new ImageIcon(this.getClass().getResource("cancelfind.png"), "close");
        this.findIcon = new ImageIcon(this.getClass().getResource("searchfind.png"), "find");
        this.clearIcon = new ImageIcon(this.getClass().getResource("cleanfind.png"), "clear");
        this.casesensitiveIcon = new ImageIcon(this.getClass().getResource("vV.png"), "casesensitive");
        this.casenotsensitiveIcon = new ImageIcon(this.getClass().getResource("vV2.png"), "casenotsensitive");
        this.findtimerdelay = guiFactoryImpl.getCsProperty().get("iscobol.gui.grid.find_delay", 500);
        if (this.findtimerdelay > 0) {
            this.findTimer = new FindTimer(this.findtimerdelay);
        }
    }

    public void setPaged(boolean bl) {
        if (this.paged != bl) {
            this.intSetPaged(bl);
        }
    }

    private void intSetPaged(boolean bl) {
        this.paged = bl;
        if (this.paged) {
            if (this.listScrollPane != null) {
                this.listPanel.remove(this.listScrollPane);
                this.listPanel.remove(this.searchBox);
                this.listScrollPane = null;
            }
            this.add((Component)this.createButtonPanel(), "East");
            this.listPanel.add(this.createSearchBox());
            this.listPanel.add(this.list);
        } else {
            if (this.buttonPanel != null) {
                this.remove(this.buttonPanel);
                this.listPanel.remove(this.list);
                this.listPanel.remove(this.searchBox);
            }
            this.listPanel.add(this.createSearchBox());
            this.listPanel.add(this.createListScrollPane());
        }
        this.doLayout();
    }

    public void setNoSearch(boolean bl) {
        if (this.isNoSearch != bl) {
            this.intSetNoSearch(bl);
        }
    }

    private void intSetNoSearch(boolean bl) {
        this.isNoSearch = bl;
        if (this.isNoSearch) {
            this.list.removeKeyListener(this.searchKeyListener);
        } else {
            this.createSearchBox();
            this.list.addKeyListener(this.searchKeyListener);
        }
    }

    private void dispatchListSelectionEvent(int n2) {
        if (this.itemListener == null) {
            return;
        }
        try {
            if (n2 >= 0 && n2 < this.getItemCount()) {
                ItemEvent itemEvent = new ItemEvent(this, 701, this.model.getElementAt(n2), 1);
                this.itemListener.itemStateChanged(itemEvent);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
        }
    }

    private JScrollPane createListScrollPane() {
        if (this.listScrollPane != null) {
            return this.listScrollPane;
        }
        this.listScrollPane = new MyScrollPane(this.list, 20, 31);
        this.listScrollPane.setBorder(null);
        JScrollBar jScrollBar = this.listScrollPane.getVerticalScrollBar();
        jScrollBar.setFocusable(false);
        jScrollBar.setPreferredSize(new Dimension(BUTTON_PANEL_WIDTH, jScrollBar.getPreferredSize().height));
        this.listScrollPane.getHorizontalScrollBar().setFocusable(false);
        this.listScrollPane.getHorizontalScrollBar().addAdjustmentListener(adjustmentEvent -> {
            this.XPos = adjustmentEvent.getValue();
        });
        this.listScrollPane.getVerticalScrollBar().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                ListBox.this.repaint();
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                ListBox.this.repaint();
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                ListBox.this.repaint();
            }
        });
        this.listScrollPane.getVerticalScrollBar().addAdjustmentListener(adjustmentEvent -> {
            this.YPos = adjustmentEvent.getValue();
        });
        return this.listScrollPane;
    }

    private JPanel createButtonPanel() {
        if (this.buttonPanel != null) {
            return this.buttonPanel;
        }
        this.buttonPanel = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(BUTTON_PANEL_WIDTH, super.getPreferredSize().height);
            }
        };
        this.buttonPanel.setLayout(new GridLayout(4, 1));
        this.buttons = new PagedListButton[6];
        this.buttons[0] = this.createButton("first.gif", 2099);
        this.buttons[1] = this.createButton("prev.gif", 2100);
        this.firstCardLayout = new CardLayout();
        this.firstCardPanel = new JPanel(this.firstCardLayout);
        this.firstCardPanel.add((Component)this.buttons[1], "prev.gif");
        this.firstCardPanel.add((Component)this.buttons[0], "first.gif");
        this.buttonPanel.add(this.firstCardPanel);
        this.buttons[2] = this.createButton("pageprev.gif", 2101);
        this.buttonPanel.add(this.buttons[2]);
        this.buttons[3] = this.createButton("pagesucc.gif", 2102);
        this.buttonPanel.add(this.buttons[3]);
        this.buttons[4] = this.createButton("succ.gif", 2103);
        this.buttons[5] = this.createButton("last.gif", 2104);
        this.lastCardLayout = new CardLayout();
        this.lastCardPanel = new JPanel(this.lastCardLayout);
        this.lastCardPanel.add((Component)this.buttons[4], "succ.gif");
        this.lastCardPanel.add((Component)this.buttons[5], "last.gif");
        this.buttonPanel.add(this.lastCardPanel);
        return this.buttonPanel;
    }

    private PagedListButton createButton(String string, final int n2) {
        MediaTracker mediaTracker = new MediaTracker(this);
        Image image = this.getToolkit().createImage(this.getClass().getResource(string));
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        ImageIcon imageIcon = new ImageIcon(image);
        PagedListButton pagedListButton = new PagedListButton(imageIcon);
        pagedListButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (ListBox.this.ped != null) {
                    ListBox.this.ped.stop();
                    ListBox.this.ped = null;
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (ListBox.this.ped != null) {
                    ListBox.this.ped.stop();
                    ListBox.this.ped = null;
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (!ListBox.this.isEnabled()) {
                    return;
                }
                if (ListBox.this.mouseListener != null) {
                    ListBox.this.mouseListener.mousePressed(mouseEvent);
                }
                PagedListBoxEvent pagedListBoxEvent = new PagedListBoxEvent((Object)ListBox.this.list, n2, 2);
                switch (n2) {
                    case 2100: 
                    case 2101: 
                    case 2102: 
                    case 2103: {
                        (ListBox.this.ped = new PagedEventDispatcher(ListBox.this.pListeners, pagedListBoxEvent)).start();
                        break;
                    }
                    case 2099: 
                    case 2104: {
                        new PagedEventDispatcher(ListBox.this.pListeners, pagedListBoxEvent);
                    }
                }
            }
        });
        pagedListButton.setFocusable(false);
        return pagedListButton;
    }

    protected boolean isSearchBoxVisible() {
        return this.searchBox != null && this.searchBox.isVisible();
    }

    public void showSearchBox() {
        if (this.searchBox != null && !this.searchBox.isVisible()) {
            this.intShowSearchBox();
        }
    }

    private void intShowSearchBox() {
        this.searchBox.setVisible(true);
        this.searchBox.requestFocusInWindow();
        this.listPanel.doLayout();
        this.buttonPanel.doLayout();
        this.firstCardLayout.first(this.firstCardPanel);
        this.lastCardLayout.first(this.lastCardPanel);
        this.addSearchBoxListeners();
    }

    private void addSearchBoxListeners() {
        this.searchBox.addKeyListener(this.searchKeyListener);
        this.searchBox.getDocument().addDocumentListener(this.searchDocumentListener);
        this.searchBox.addFocusListener(this.searchFocusListener);
    }

    public void hideSearchBox() {
        this.hideSearchBox(false);
    }

    private void hideSearchBox(boolean bl) {
        if (this.searchBox != null && this.searchBox.isVisible()) {
            this.intHideSearchBox(bl);
        }
    }

    private void intHideSearchBox(boolean bl) {
        this.removeSearchBoxListeners();
        this.searchBox.setVisible(false);
        if (bl) {
            this.list.requestFocusInWindow();
        }
        this.listPanel.doLayout();
        this.buttonPanel.doLayout();
    }

    private void removeSearchBoxListeners() {
        this.searchBox.removeKeyListener(this.searchKeyListener);
        this.searchBox.getDocument().removeDocumentListener(this.searchDocumentListener);
        this.searchBox.removeFocusListener(this.searchFocusListener);
    }

    private JTextField createSearchBox() {
        if (this.searchBox != null) {
            return this.searchBox;
        }
        this.searchBox = new JTextField(){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(Math.max(50, ((ListBox)ListBox.this).listPanel.getSize().width - 20), ((ListBox)ListBox.this).searchBox.getPreferredSize().height);
            }
        };
        this.searchBox.setVisible(false);
        this.searchBox.setAlignmentX(1.0f);
        this.searchBox.setDocument(new PlainDocument(){
            private static final long serialVersionUID = 1L;

            @Override
            public void insertString(int n2, String string, AttributeSet attributeSet) throws BadLocationException {
                char c2;
                if (string.length() > 0 && (c2 = string.charAt(0)) != '\t' && c2 != '\n') {
                    if (ListBox.this.upper) {
                        string = Factory.toUpperCase(string, ListBox.this.upperLowerMethod);
                    } else if (ListBox.this.lower) {
                        string = Factory.toLowerCase(string, ListBox.this.upperLowerMethod);
                    }
                    super.insertString(n2, string, attributeSet);
                }
            }

            @Override
            public void replace(int n2, int n3, String string, AttributeSet attributeSet) throws BadLocationException {
                ListBox.this.searchDocumentListener.notifyRemove = false;
                super.replace(n2, n3, string, attributeSet);
                ListBox.this.searchDocumentListener.notifyRemove = true;
            }
        });
        return this.searchBox;
    }

    protected boolean findAndSelectSearchedText(boolean bl) {
        return this.findAndSelect(this.searchBox.getText(), bl);
    }

    protected boolean findAndSelect(String string, boolean bl) {
        boolean bl2 = false;
        if (string.length() > 0 && this.sortOrder != 1) {
            int n2;
            int n3 = this.model.getSize();
            for (n2 = 0; !bl2 && n2 < n3; ++n2) {
                String string2 = this.getItemAt(n2).trim();
                if (this.upper || this.lower || this.sortOrder != 2) {
                    if (!string2.toLowerCase().startsWith(string.toLowerCase())) continue;
                    bl2 = true;
                    break;
                }
                if (!string2.startsWith(string)) continue;
                bl2 = true;
                break;
            }
            if (bl2) {
                int n4 = n2;
                SwingUtilities.invokeLater(() -> {
                    boolean bl2 = this.fireNtfChange;
                    if (!bl) {
                        this.fireNtfChange = false;
                    }
                    this.list.setSelectedIndex(n4);
                    this.fireNtfChange = bl2;
                });
            }
        }
        return bl2;
    }

    private void dispatchSearchEvent(boolean bl) {
        boolean bl2;
        String string = this.searchBox.getText();
        boolean bl3 = this.findAndSelect(string, true);
        boolean bl4 = bl2 = bl || !bl3 || this.sortOrder == 1;
        if (bl2) {
            Enumeration enumeration = this.pListeners.elements();
            while (enumeration.hasMoreElements()) {
                PagedListBoxListener pagedListBoxListener = (PagedListBoxListener)enumeration.nextElement();
                PagedListBoxEvent pagedListBoxEvent = new PagedListBoxEvent((Object)this.searchBox, 2105, string);
                pagedListBoxListener.search(pagedListBoxEvent);
            }
        }
    }

    public void addItem(ListItem listItem, int n2) {
        this.fireNtfChange = false;
        if (n2 < 0 || n2 >= this.model.getSize()) {
            if (!this.isPaged() && !this.unsorted && (n2 = ScreenUtility.getInsertionIndex(this.model.delegate, listItem, ignoreCaseComparator)) < this.model.getSize()) {
                this.model.add(n2, listItem);
                if (this.checkList) {
                    this.addCheckItem(listItem, n2);
                }
                this.fireNtfChange = true;
                return;
            }
            if (this.isPaged() && this.model.getSize() == this.rows) {
                this.model.removeElementAt(0);
            }
            this.model.addElement(listItem);
            if (this.checkList) {
                this.addCheckItem(listItem, -1);
            }
        } else {
            if (this.isPaged() && this.model.getSize() == this.rows) {
                if (n2 > 0) {
                    this.model.removeElementAt(0);
                } else {
                    this.model.removeElementAt(this.model.getSize() - 1);
                }
            }
            this.model.add(n2, listItem);
            if (this.checkList) {
                this.addCheckItem(listItem, n2);
            }
        }
        this.fireNtfChange = true;
    }

    private void addCheckItem(ListItem listItem, int n2) {
        JToggleButton jToggleButton = this.addCheckItem(listItem.text, listItem.getBackground(), listItem.getForeground(), n2);
        if (jToggleButton instanceof MyJCheckBox) {
            ((MyJCheckBox)jToggleButton).item = listItem;
        } else {
            ((MyJRadioButton)jToggleButton).item = listItem;
        }
        if (listItem.getBackground() != null) {
            this.opaqueButtons.add(jToggleButton);
            jToggleButton.setOpaque(true);
        } else {
            jToggleButton.setOpaque(!this.gradientMgr.isPaintGradient());
        }
        if (this.checkPanel.getComponentCount() == 1) {
            this.checkScrollPane.getVerticalScrollBar().setUnitIncrement(jToggleButton.getPreferredSize().height + jToggleButton.getMargin().top + jToggleButton.getMargin().bottom);
        }
        this.checkScrollPane.doLayout();
    }

    private JToggleButton addCheckItem(String string, Color color, Color color2, int n2) {
        JToggleButton jToggleButton;
        MyJRadioButton myJRadioButton = null;
        if (this.getSelectionMode() == 0) {
            myJRadioButton = new MyJRadioButton(string);
            jToggleButton = myJRadioButton;
            this.radioGroup.add(myJRadioButton);
        } else {
            jToggleButton = new MyJCheckBox(string);
        }
        jToggleButton.setForeground(color2 != null ? color2 : this.getForeground());
        jToggleButton.setBackground(color != null ? color : this.getBackground());
        jToggleButton.setFont(this.getFont());
        jToggleButton.setToolTipText(this.checkPanel.getToolTipText());
        jToggleButton.addItemListener(this.checkListItemListener);
        jToggleButton.addFocusListener(this.checkListFocusListener);
        jToggleButton.addMouseListener(this.checkListMouseListener);
        jToggleButton.addKeyListener(this.checkListKeyListener);
        if (n2 >= 0 && n2 < this.checkPanel.getComponentCount()) {
            this.checkPanel.add((Component)jToggleButton, n2);
            if (myJRadioButton != null) {
                Vector<AbstractButton> vector = this.radioGroup.getButtons();
                vector.remove(vector.size() - 1);
                vector.add(n2, myJRadioButton);
            }
        } else {
            this.checkPanel.add(jToggleButton);
        }
        this.checkPanel.doLayout();
        return jToggleButton;
    }

    public void removeItem(int n2) {
        this.fireNtfChange = false;
        this.model.removeElementAt(n2);
        if (this.checkList) {
            this.removeCheckItem(n2);
        }
        this.fireNtfChange = true;
    }

    private void removeCheckItem(int n2) {
        if (n2 < this.checkPanel.getComponentCount()) {
            this.removeCheckItem0(n2);
            this.checkScrollPane.doLayout();
        }
    }

    private JToggleButton removeCheckItem0(int n2) {
        JToggleButton jToggleButton = (JToggleButton)this.checkPanel.getComponent(n2);
        this.opaqueButtons.remove(jToggleButton);
        jToggleButton.removeItemListener(this.checkListItemListener);
        jToggleButton.removeFocusListener(this.checkListFocusListener);
        jToggleButton.removeKeyListener(this.checkListKeyListener);
        jToggleButton.removeMouseListener(this.checkListMouseListener);
        if (this.getSelectionMode() == 0) {
            this.radioGroup.remove(jToggleButton);
        }
        this.checkPanel.remove(n2);
        this.checkPanel.doLayout();
        return jToggleButton;
    }

    public void removeAllItems() {
        this.fireNtfChange = false;
        this.model.removeAllElements();
        if (this.checkList) {
            this.removeAllCheckItems();
        }
        this.fireNtfChange = true;
    }

    private void removeAllCheckItems() {
        this.checkPanel.removeAll();
        if (this.getSelectionMode() == 0) {
            Vector<AbstractButton> vector = new Vector<AbstractButton>(this.radioGroup.getButtons());
            for (AbstractButton abstractButton : vector) {
                this.radioGroup.remove(abstractButton);
            }
        }
        this.opaqueButtons.clear();
        this.checkPanel.doLayout();
        this.checkPanel.repaint();
        this.checkScrollPane.doLayout();
    }

    public void dispose() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.ked);
    }

    public void addAlignment(String string) {
        if (this.alignments == null) {
            this.alignments = new Vector();
        }
        this.alignments.addElement(string);
    }

    public void resetAlignments() {
        this.alignments = null;
    }

    public void addDivider(int n2) {
        if (this.dividers == null) {
            this.dividers = new Vector();
        }
        this.dividers.addElement(n2);
        this.repaint();
    }

    public void resetDividers() {
        this.dividers = null;
        this.repaint();
    }

    public void addSeparator(int n2) {
        if (this.separators == null) {
            this.separators = new Vector();
        }
        this.separators.addElement(n2);
    }

    public void resetSeparators() {
        this.separators = null;
    }

    public void addDataColumn(int n2) {
        if (n2 > 1) {
            if (this.dataColumns == null) {
                this.dataColumns = new Vector();
            }
            Integer n3 = n2;
            Enumeration enumeration = this.dataColumns.elements();
            int n4 = 0;
            while (enumeration.hasMoreElements()) {
                Integer n5 = (Integer)enumeration.nextElement();
                if (n3.compareTo(n5) == 0) {
                    return;
                }
                if (n3.compareTo(n5) < 0) {
                    this.dataColumns.add(n4, n3);
                    return;
                }
                ++n4;
            }
            this.dataColumns.addElement(n3);
        }
    }

    public void resetDataColumns() {
        this.dataColumns = null;
    }

    public void addDisplayColumn(int n2) {
        if (n2 > 1) {
            if (this.displayColumns == null) {
                this.displayColumns = new Vector();
            }
            Integer n3 = n2;
            Enumeration enumeration = this.displayColumns.elements();
            int n4 = 0;
            while (enumeration.hasMoreElements()) {
                Integer n5 = (Integer)enumeration.nextElement();
                if (n3.compareTo(n5) == 0) {
                    return;
                }
                if (n3.compareTo(n5) < 0) {
                    this.displayColumns.add(n4, n3);
                    return;
                }
                ++n4;
            }
            this.displayColumns.addElement(n3);
        }
    }

    public void resetDisplayColumns() {
        this.displayColumns = null;
    }

    @Override
    public void setToolTipText(String string) {
        if (this.list != null || this.checkPanel != null) {
            if (this.checkList) {
                this.checkPanel.setToolTipText(string);
                for (int i2 = 0; i2 < this.checkPanel.getComponentCount(); ++i2) {
                    ((JToggleButton)this.checkPanel.getComponent(i2)).setToolTipText(string);
                }
            } else {
                this.list.setToolTipText(string);
            }
        } else {
            super.setToolTipText(string);
        }
    }

    public void setUpper(boolean bl) {
        this.upper = bl;
    }

    public void setLower(boolean bl) {
        this.lower = bl;
    }

    private void setOpaque() {
        boolean bl;
        boolean bl2 = bl = !this.gradientMgr.isPaintGradient();
        if (this.checkList) {
            this.checkPanel.setOpaque(bl);
            this.checkScrollPane.getViewport().setOpaque(bl);
            for (int i2 = 0; i2 < this.checkPanel.getComponentCount(); ++i2) {
                JToggleButton jToggleButton = (JToggleButton)this.checkPanel.getComponent(i2);
                if (this.opaqueButtons.contains(jToggleButton)) {
                    jToggleButton.setOpaque(true);
                    continue;
                }
                jToggleButton.setOpaque(bl);
            }
        } else {
            this.list.setOpaque(bl);
            if (this.listScrollPane != null) {
                this.listScrollPane.getViewport().setOpaque(bl);
            }
        }
    }

    public void setThumbPosition(int n2) {
        this.thumbPosition = n2;
        if (this.checkList) {
            if (this.checkPanel.getComponentCount() > 0) {
                int n3 = this.checkScrollPane.getViewport().getViewRect().height;
                JToggleButton jToggleButton = (JToggleButton)this.checkPanel.getComponent(0);
                int n4 = jToggleButton.getSize().height + jToggleButton.getMargin().top + jToggleButton.getMargin().bottom;
                int n5 = n3 / n4;
                int n6 = 0;
                if (n2 > 0) {
                    n6 = n2 <= this.getFirstVisibleIndex() ? n2 : (n2 <= this.getItemCount() - n5 ? n2 + n5 : this.getItemCount());
                }
                if (n6 > 0) {
                    this.checkPanel.scrollRectToVisible(this.checkPanel.getComponent(n6 - 1).getBounds());
                }
            }
        } else {
            int n7 = this.getRows() - 1;
            int n8 = 0;
            if (n2 > 0) {
                n8 = n2 <= this.getFirstVisibleIndex() ? n2 : (n2 <= this.getItemCount() - n7 ? n2 + n7 : this.getItemCount());
            }
            if (n8 > 0) {
                this.list.ensureIndexIsVisible(n8 - 1);
                this.list.repaint();
            }
        }
    }

    public int getThumbPosition() {
        return this.getFirstVisibleIndex() + 1;
    }

    public void setUnsorted(boolean bl) {
        this.unsorted = bl;
    }

    private boolean isPaged() {
        return this.paged && !this.checkList;
    }

    public boolean isLower() {
        return this.lower;
    }

    public boolean isUpper() {
        return this.upper;
    }

    @Override
    public void setFont(Font font) {
        if (this.list == null && this.checkPanel == null) {
            super.setFont(font);
        } else if (this.font == null || !this.font.equals(font)) {
            this.font = font;
            if (this.checkList) {
                for (int i2 = 0; i2 < this.checkPanel.getComponentCount(); ++i2) {
                    this.checkPanel.getComponent(i2).setFont(font);
                }
            } else {
                this.list.setFont(font);
                this.fontCmp = this.getFontCmp();
                if (this.fontCmp != null) {
                    IscobolLayout iscobolLayout = this.getIscobolLayout();
                    if (!(iscobolLayout instanceof ZoomLayout) || !iscobolLayout.isLayingOut()) {
                        this.cellWidth = this.fontCmp.computeScreenWidth("0");
                    }
                    this.fontHeight = this.fontCmp.getHeight();
                    this.renderer.updateRenderer();
                }
                this.rows = this.origHeight / this.fontHeight;
                this.buildColumns(this.getCellWidth());
            }
        }
    }

    private IscobolLayout getIscobolLayout() {
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container.getLayout() instanceof IscobolLayout)) continue;
            return (IscobolLayout)container.getLayout();
        }
        return null;
    }

    private IscobolLayout.LayoutData getIscobolLayoutData() {
        Container container = this;
        for (Container container2 = container.getParent(); container2 != null; container2 = container2.getParent()) {
            if (container2.getLayout() instanceof IscobolLayout) {
                return ((IscobolLayout)container2.getLayout()).getLayoutData(container);
            }
            container = container2;
        }
        return null;
    }

    @Override
    public Font getFont() {
        return this.font != null ? this.font : super.getFont();
    }

    @Override
    public void setForeground(Color color) {
        this.intSetForeground(color);
    }

    private void intSetForeground(Color color) {
        if (this.list != null || this.checkPanel != null) {
            this.foreground = color;
            if (this.checkList) {
                for (int i2 = 0; i2 < this.checkPanel.getComponentCount(); ++i2) {
                    this.checkPanel.getComponent(i2).setForeground(color);
                }
            } else {
                this.list.setForeground(color);
            }
        } else {
            super.setForeground(color);
        }
    }

    @Override
    public Color getForeground() {
        if (this.foreground != null) {
            return this.foreground;
        }
        if (!this.checkList && this.list != null) {
            return this.list.getForeground();
        }
        return super.getForeground();
    }

    @Override
    public void setBackground(Color color) {
        this.intSetBackground(color);
    }

    private void intSetBackground(Color color) {
        if (this.list != null || this.checkPanel != null) {
            this.background = color;
            if (this.checkList) {
                this.checkPanel.setBackground(color);
                for (int i2 = 0; i2 < this.checkPanel.getComponentCount(); ++i2) {
                    this.checkPanel.getComponent(i2).setBackground(color);
                }
            } else {
                this.list.setBackground(color);
            }
        }
    }

    @Override
    public Color getBackground() {
        if (this.background != null) {
            return this.background;
        }
        if (!this.checkList && this.list != null) {
            return this.list.getBackground();
        }
        return super.getBackground();
    }

    public void clearSelection() {
        if (this.checkList) {
            boolean bl = this.fireNtfChange;
            this.fireNtfChange = false;
            for (int i2 = 0; i2 < this.checkPanel.getComponentCount(); ++i2) {
                ((JToggleButton)this.checkPanel.getComponent(i2)).setSelected(false);
            }
            this.fireNtfChange = bl;
        } else {
            this.list.clearSelection();
            this.list.getSelectionModel().setAnchorSelectionIndex(-1);
            this.list.getSelectionModel().setLeadSelectionIndex(-1);
        }
    }

    void select(int n2) {
        this.select(new int[]{n2});
    }

    void select(int[] nArray) {
        this.fireNtfChange = false;
        if (this.checkList) {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                ((JToggleButton)this.checkPanel.getComponent(nArray[i2])).setSelected(true);
            }
        } else if (nArray.length > 1) {
            this.list.setSelectedIndices(nArray);
            this.list.ensureIndexIsVisible(nArray[nArray.length - 1]);
        } else {
            this.list.setSelectedIndex(nArray[0]);
            this.list.ensureIndexIsVisible(nArray[0]);
        }
        this.fireNtfChange = true;
    }

    public int getSelectedIndex() {
        if (this.checkList) {
            for (int i2 = 0; i2 < this.checkPanel.getComponentCount(); ++i2) {
                if (!((JToggleButton)this.checkPanel.getComponent(i2)).isSelected()) continue;
                return i2;
            }
            return -1;
        }
        return this.list.getSelectedIndex();
    }

    public int[] getSelectedIndices() {
        if (this.checkList) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i2 = 0; i2 < this.checkPanel.getComponentCount(); ++i2) {
                if (!((JToggleButton)this.checkPanel.getComponent(i2)).isSelected()) continue;
                arrayList.add(i2);
            }
            int[] nArray = new int[arrayList.size()];
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                nArray[i3] = (Integer)arrayList.get(i3);
            }
            return nArray;
        }
        return this.list.getSelectedIndices();
    }

    public void setRowColorPattern(Vector vector) {
        this.rowColorPatterns = vector;
        if (!this.checkList) {
            this.list.repaint();
        }
    }

    public int setSelectedValue(String string) {
        int n2 = this.indexOf(string);
        if (n2 >= 0) {
            new SwingWorker(true, () -> this.select(n2)).start();
        }
        return n2;
    }

    public String getSelectedValue() {
        int n2 = this.getSelectedIndex();
        if (n2 >= 0) {
            return this.getItemAt(n2);
        }
        return null;
    }

    private int indexOf(String string) {
        int n2;
        int n3 = this.model.getSize();
        for (n2 = 0; n2 < n3; ++n2) {
            if (!this.model.getElementAt(n2).toString().equals(string)) continue;
            return n2;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (!this.model.getElementAt(n2).toString().equalsIgnoreCase(string)) continue;
            return n2;
        }
        string = string.toLowerCase();
        for (n2 = 0; n2 < n3; ++n2) {
            if (!this.model.getElementAt(n2).toString().toLowerCase().startsWith(string)) continue;
            return n2;
        }
        return -1;
    }

    public String getItemAt(int n2) {
        ListItem listItem = (ListItem)this.model.getElementAt(n2);
        return listItem != null ? listItem.toString() : "";
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        if (!this.checkList) {
            this.list.addKeyListener(keyListener);
            if (this.searchBox != null) {
                this.searchBox.addKeyListener(keyListener);
            }
        }
        this.keyListener = AWTEventMulticaster.add(this.keyListener, keyListener);
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        if (!this.checkList) {
            this.list.removeKeyListener(keyListener);
            if (this.searchBox != null) {
                this.searchBox.removeKeyListener(keyListener);
            }
        }
        this.keyListener = AWTEventMulticaster.remove(this.keyListener, keyListener);
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
        if (this.list == null && this.checkPanel == null) {
            super.addFocusListener(focusListener);
        } else if (!this.checkList) {
            this.list.addFocusListener(focusListener);
        }
        this.focusListener = AWTEventMulticaster.add(this.focusListener, focusListener);
    }

    @Override
    public void removeFocusListener(FocusListener focusListener) {
        if (!this.checkList) {
            this.list.removeFocusListener(focusListener);
        }
        this.focusListener = AWTEventMulticaster.remove(focusListener, this.focusListener);
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        if (!this.checkList) {
            this.list.addMouseListener(mouseListener);
        }
        this.mouseListener = AWTEventMulticaster.add(this.mouseListener, mouseListener);
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        if (!this.checkList) {
            this.list.removeMouseListener(mouseListener);
        }
        this.mouseListener = AWTEventMulticaster.remove(this.mouseListener, mouseListener);
    }

    public void addPagedListBoxListener(PagedListBoxListener pagedListBoxListener) {
        this.pListeners.addElement(pagedListBoxListener);
    }

    public void removePagedListBoxListener(PagedListBoxListener pagedListBoxListener) {
        this.pListeners.removeElement(pagedListBoxListener);
    }

    public void setSortOrder(int n2) {
        this.sortOrder = n2;
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public void buildColumns() {
        this.buildColumns(this.getCellWidth());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildColumns(float f2) {
        if (this.isCheckList()) {
            return;
        }
        ListBox listBox = this;
        synchronized (listBox) {
            Object[] objectArray;
            int n2 = this.origWidth;
            int n3 = Math.round((float)n2 / f2);
            int n4 = 0;
            if (this.displayColumns != null) {
                objectArray = new Integer[this.displayColumns.size()];
                Integer[] integerArray = null;
                if (this.separators != null) {
                    integerArray = new Integer[this.separators.size()];
                    this.separators.toArray(integerArray);
                }
                String[] stringArray = null;
                if (this.alignments != null) {
                    stringArray = new String[this.alignments.size()];
                    this.alignments.toArray(stringArray);
                }
                Integer[] integerArray2 = null;
                if (this.dividers != null) {
                    integerArray2 = new Integer[this.dividers.size()];
                    this.dividers.toArray(integerArray2);
                }
                this.displayColumns.toArray(objectArray);
                this.column = new Column[objectArray.length + 1];
                int n5 = 1;
                int n6 = 0;
                while (n6 < objectArray.length) {
                    this.column[n6] = new Column();
                    int n7 = (Integer)objectArray[n6];
                    if (n7 > n3) break;
                    this.column[n6].width = Math.round((float)(n7 - n5) * f2);
                    if (integerArray != null) {
                        if (n6 < integerArray.length) {
                            this.column[n6].separator = this.getSepWidth(integerArray[n6]);
                        }
                    } else {
                        this.column[n6].separator = this.getSepWidth(this.gf.getColumnSeparation());
                    }
                    this.column[n6].alignment = stringArray != null && n6 < stringArray.length ? this.getAlignValue(stringArray[n6]) : 0;
                    if (integerArray2 != null && n6 < integerArray2.length) {
                        this.column[n6].divider = integerArray2[n6];
                    }
                    n5 = n7;
                    n2 -= this.column[n6].width;
                    ++n6;
                    ++n4;
                }
                if (n5 <= n3) {
                    ++n4;
                    this.column[n6] = new Column();
                    this.column[n6].width = n2;
                    if (integerArray != null) {
                        if (n6 < integerArray.length) {
                            this.column[n6].separator = this.getSepWidth(integerArray[n6]);
                        }
                    } else {
                        this.column[n6].separator = this.getSepWidth(this.gf.getColumnSeparation());
                    }
                    if (this.alignments != null && n6 < stringArray.length) {
                        this.column[n6].alignment = this.getAlignValue(stringArray[n6]);
                    }
                }
            } else {
                this.column = new Column[]{new Column()};
                this.column[0].width = n2;
                n4 = 1;
            }
            if (n4 < this.column.length) {
                objectArray = this.column;
                this.column = new Column[n4];
                System.arraycopy(objectArray, 0, this.column, 0, n4);
            }
        }
        this.renderer.updateRenderer();
        this.doLayout();
    }

    private int getSepWidth(int n2) {
        return (int)(this.cellWidth / 10.0f * (float)n2);
    }

    private int getAlignValue(String string) {
        if ((string = string.toUpperCase()).startsWith("C")) {
            return 1;
        }
        if (string.startsWith("R")) {
            return 2;
        }
        if (string.startsWith("L")) {
            return 3;
        }
        return 0;
    }

    protected LocalFontCmp getFontCmp() {
        if (this.font != null) {
            return new SwingFontCmp(this.gf, this.font);
        }
        return null;
    }

    public int getRows() {
        return this.rows;
    }

    private int getFirstVisibleIndex() {
        if (this.checkList) {
            Rectangle rectangle = this.checkScrollPane.getViewport().getViewRect();
            for (int i2 = 0; i2 < this.checkPanel.getComponentCount(); ++i2) {
                if (!rectangle.contains(this.checkPanel.getComponent(i2).getBounds())) continue;
                return i2;
            }
            return -1;
        }
        return this.list.getFirstVisibleIndex();
    }

    private void setPrototypeCellValue(Object object) {
        if (!this.checkList) {
            this.list.setPrototypeCellValue(object);
        }
    }

    private void setFixedCellWidth(int n2) {
        if (!this.checkList) {
            this.list.setFixedCellWidth(n2);
        }
    }

    private void setFixedCellHeight(int n2) {
        if (!this.checkList) {
            this.list.setFixedCellHeight(n2);
        }
    }

    public int getFixedCellHeight() {
        return this.list.getFixedCellHeight();
    }

    String[] buildTokens(ListItem listItem) {
        String[] stringArray;
        if (!this.isCheckList() && this.dataColumns != null) {
            int n2;
            int n3;
            Integer[] integerArray = new Integer[this.dataColumns.size()];
            char[] cArray = null;
            byte[] byArray = null;
            if (listItem.bytes != null) {
                byArray = listItem.bytes;
                n3 = byArray.length;
            } else {
                cArray = listItem.text.toCharArray();
                n3 = cArray.length;
            }
            this.dataColumns.toArray(integerArray);
            stringArray = new String[integerArray.length + 1];
            int n4 = 0;
            for (int i2 = 0; i2 < integerArray.length && (n2 = integerArray[i2] - 1) <= n3; ++i2) {
                if (byArray != null) {
                    try {
                        stringArray[i2] = new String(byArray, n4, n2 - n4, ListItem.encoding);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        stringArray[i2] = "";
                    }
                } else {
                    stringArray[i2] = new String(cArray, n4, n2 - n4);
                }
                n4 = n2;
            }
            if (n4 < n3) {
                if (byArray != null) {
                    try {
                        stringArray[i2] = new String(byArray, n4, byArray.length - n4, ListItem.encoding);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        stringArray[i2] = "";
                    }
                } else {
                    stringArray[i2] = new String(cArray, n4, cArray.length - n4);
                }
            }
        } else {
            stringArray = new String[]{listItem.text};
        }
        return stringArray;
    }

    @Override
    public void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    @Override
    public void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    @Override
    public Object[] getSelectedObjects() {
        return null;
    }

    public int getItemCount() {
        return this.model.getSize();
    }

    int getModelItemCount() {
        return this.model.model.getSize();
    }

    JList getList() {
        return this.list;
    }

    protected PicobolWidget[] getButtons() {
        return this.buttons;
    }

    @Override
    public void setVisible(boolean bl) {
        boolean bl2 = this.isVisible();
        super.setVisible(bl);
        if (!this.checkList && bl != bl2) {
            if (bl) {
                this.doLayout();
                if (this.searchBox != null && this.searchBox.isVisible()) {
                    this.addSearchBoxListeners();
                }
                if (this.paged) {
                    this.firstCardLayout.first(this.firstCardPanel);
                    this.lastCardLayout.first(this.lastCardPanel);
                }
            } else if (this.getParent() != null) {
                Rectangle rectangle = super.getBounds();
                this.getParent().repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                if (this.searchBox != null) {
                    this.removeSearchBoxListeners();
                }
            }
        }
    }

    @Override
    public void doLayout() {
        new IsguiWorker(false, () -> {
            ListBox.super.doLayout();
            if (this.checkList) {
                if (this.checkScrollPane != null) {
                    this.checkScrollPane.doLayout();
                }
            } else {
                if (this.listScrollPane != null) {
                    this.listScrollPane.doLayout();
                }
                if (this.paged) {
                    this.buttonPanel.doLayout();
                }
            }
        }).start();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.checkList) {
            this.checkScrollPane.setEnabled(bl);
            for (int i2 = 0; i2 < this.checkPanel.getComponentCount(); ++i2) {
                this.checkPanel.getComponent(i2).setEnabled(bl);
            }
        } else {
            this.list.setEnabled(bl);
            if (this.listScrollPane != null) {
                this.listScrollPane.setEnabled(bl);
                this.listScrollPane.getHorizontalScrollBar().setEnabled(bl);
                this.listScrollPane.getVerticalScrollBar().setEnabled(bl);
                this.listScrollPane.setWheelScrollingEnabled(bl);
            }
            if (this.buttons != null) {
                for (int i3 = 0; i3 < this.buttons.length; ++i3) {
                    this.buttons[i3].setEnabled(bl);
                }
            }
            if (this.buttonPanel != null) {
                this.buttonPanel.setEnabled(bl);
            }
        }
    }

    @Override
    public void requestFocus() {
        if (this.checkList) {
            if (this.focusedButton != null) {
                this.focusedButton.requestFocus();
            } else if (this.checkPanel.getComponentCount() > 0) {
                int n2;
                if (this.getSelectionMode() == 0) {
                    n2 = this.getSelectedIndex();
                    if (n2 < 0) {
                        n2 = 0;
                    }
                } else {
                    n2 = 0;
                }
                this.checkPanel.getComponent(n2).requestFocus();
            } else {
                this.checkPanel.requestFocus();
            }
        } else if (this.searchBox != null && this.searchBox.isVisible()) {
            this.searchBox.requestFocus();
            this.searchBox.repaint();
        } else {
            this.list.requestFocus();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        boolean bl;
        if (this.checkList) {
            if (this.focusedButton != null) {
                bl = this.focusedButton.requestFocusInWindow();
            } else if (this.checkPanel.getComponentCount() > 0) {
                int n2;
                if (this.getSelectionMode() == 0) {
                    n2 = this.getSelectedIndex();
                    if (n2 < 0) {
                        n2 = 0;
                    }
                } else {
                    n2 = 0;
                }
                bl = this.checkPanel.getComponent(n2).requestFocusInWindow();
            } else {
                bl = this.checkPanel.requestFocusInWindow();
            }
        } else if (this.searchBox != null && this.searchBox.isVisible()) {
            bl = this.searchBox.requestFocusInWindow();
            this.searchBox.repaint();
        } else {
            bl = this.list.requestFocusInWindow();
        }
        return bl;
    }

    @Override
    public void setFocusable(boolean bl) {
        if (this.checkList) {
            for (int i2 = 0; i2 < this.checkPanel.getComponentCount(); ++i2) {
                this.checkPanel.getComponent(i2).setFocusable(bl);
            }
        } else if (this.list != null) {
            this.list.setFocusable(bl);
        }
    }

    @Override
    public Rectangle getBounds() {
        if (this.origWidth > 0 && this.origHeight > 0 && this.fontHeight > 0) {
            return new Rectangle(this.getX(), this.getY(), this.origWidth, this.origHeight);
        }
        return super.getBounds();
    }

    @Override
    public void setLocation(int n2, int n3) {
        this.setBounds(n2, n3, this.origWidth, this.origHeight);
    }

    @Override
    public void setBounds(int n2, int n3, int n4, int n5) {
        if (!(this.checkList || n4 == this.origWidth && n5 == this.origHeight || this.fontHeight <= 0)) {
            this.origWidth = n4;
            this.origHeight = n5;
            super.setBounds(n2, n3, this.origWidth, this.origHeight);
            this.rows = this.origHeight / this.fontHeight;
            this.buildColumns(this.getCellWidth());
            this.revalidate();
        } else {
            super.setBounds(n2, n3, n4, n5);
        }
    }

    private float getCellWidth() {
        IscobolLayout.LayoutData layoutData;
        if (this.isLmOnColumns() && (layoutData = this.getIscobolLayoutData()) != null) {
            int n2 = this.getSize().width;
            if (this.cellWidth > 0.0f && n2 != layoutData.getOrigBounds().width) {
                return this.cellWidth * (float)n2 / (float)layoutData.getOrigBounds().width;
            }
        }
        return this.cellWidth;
    }

    @Override
    public void setSize(int n2, int n3) {
        this.setBounds(this.getX(), this.getY(), n2, n3);
    }

    public Point getReferencedPopupLocation(MouseEvent mouseEvent) {
        return new Point(mouseEvent.getX() - this.XPos, mouseEvent.getY() - this.YPos);
    }

    public void setMouseWheelLinesToScroll(int n2) {
        if (n2 > 0) {
            this.mousewheellinestoscroll = n2;
        }
    }

    public Object getHiddenDataItemAt(int n2) {
        ListItem listItem;
        this.fireNtfChange = false;
        Object object = null;
        if (n2 >= 0 && n2 < this.getItemCount() && (listItem = (ListItem)this.model.getElementAt(n2)) != null && listItem.getHiddenData() != null) {
            object = listItem.getHiddenData();
        }
        this.fireNtfChange = true;
        return object;
    }

    public ListItem getListItemAt(int n2) {
        if (n2 >= 0 && n2 < this.getItemCount()) {
            return (ListItem)this.model.getElementAt(n2);
        }
        return null;
    }

    ListItem getModelListItemAt(int n2) {
        if (n2 >= 0 && n2 < this.getModelItemCount()) {
            return (ListItem)this.model.model.getElementAt(n2);
        }
        return null;
    }

    Color getBackgroundColor(ListItem listItem, int n2) {
        if (listItem != null && listItem.getBackground() != null) {
            return listItem.getBackground();
        }
        if (this.rowColorPatterns != null) {
            if (this.rowColorPatterns.size() > 1) {
                int n3 = this.rowColorPatterns.size();
                return ((Color[])this.rowColorPatterns.elementAt(n2 % n3))[0];
            }
            if (this.rowColorPatterns.size() > 0) {
                return ((Color[])this.rowColorPatterns.elementAt(0))[0];
            }
        }
        return null;
    }

    Color getForegroundColor(ListItem listItem, int n2) {
        if (listItem != null && listItem.getForeground() != null) {
            return listItem.getForeground();
        }
        if (this.rowColorPatterns != null) {
            if (this.rowColorPatterns.size() > 1) {
                int n3 = this.rowColorPatterns.size();
                return ((Color[])this.rowColorPatterns.elementAt(n2 % n3))[1];
            }
            if (this.rowColorPatterns.size() > 0) {
                return ((Color[])this.rowColorPatterns.elementAt(0))[1];
            }
        }
        return null;
    }

    boolean hasButtonsOrScrollBar() {
        if (this.checkList) {
            return false;
        }
        boolean bl = this.paged || this.listScrollPane != null && this.listScrollPane.getVerticalScrollBar() != null && this.listScrollPane.getVerticalScrollBar().isVisible() && this.listScrollPane.getVerticalScrollBar().getSize().width > 0;
        return bl;
    }

    private boolean checkMenuSelected(Component component) {
        Component[] componentArray;
        boolean bl = false;
        if (component == null) {
            return bl;
        }
        if (component instanceof JMenu && ((JMenu)component).isSelected()) {
            return true;
        }
        if (component instanceof Container && (componentArray = ((Container)component).getComponents()) != null) {
            for (int i2 = 0; !bl && i2 < componentArray.length; ++i2) {
                if (componentArray[i2] instanceof JMenu && ((JMenu)componentArray[i2]).isSelected()) {
                    return true;
                }
                bl = this.checkMenuSelected(componentArray[i2]);
            }
        }
        return bl;
    }

    public void copyItems(ListBox listBox) {
        int n2 = listBox.getItemCount();
        ListItem listItem = null;
        String string = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            string = listBox.getItemAt(i2);
            listItem = new ListItem(string);
            this.addItem(listItem, i2);
        }
    }

    public boolean isLmOnColumns() {
        return this.lmOnColumns;
    }

    public void setLmOnColumns(boolean bl) {
        this.lmOnColumns = bl;
    }

    @Override
    public void setName(String string) {
        if (this.list != null) {
            this.list.setName(string);
        }
    }

    public void setSelectionMode(int n2) {
        int n3 = this.selectionMode;
        this.selectionMode = n2;
        if (this.checkList) {
            if (n3 != n2) {
                boolean bl;
                boolean bl2 = n3 == 0;
                boolean bl3 = bl = n2 == 0;
                if (bl2 != bl) {
                    this.fireNtfChange = false;
                    Vector<JToggleButton> vector = new Vector<JToggleButton>();
                    while (this.checkPanel.getComponentCount() > 0) {
                        vector.add(this.removeCheckItem0(0));
                    }
                    boolean bl4 = !this.gradientMgr.isPaintGradient();
                    for (int i2 = 0; i2 < vector.size(); ++i2) {
                        JToggleButton jToggleButton = (JToggleButton)vector.elementAt(i2);
                        JToggleButton jToggleButton2 = this.addCheckItem(jToggleButton.getText(), jToggleButton.getBackground(), jToggleButton.getForeground(), -1);
                        if (this.opaqueButtons.contains(jToggleButton)) {
                            this.opaqueButtons.remove(jToggleButton);
                            this.opaqueButtons.add(jToggleButton2);
                            jToggleButton2.setOpaque(true);
                        } else {
                            jToggleButton2.setOpaque(bl4);
                        }
                        if (jToggleButton == this.focusedButton) {
                            this.focusedButton = jToggleButton2;
                        }
                        if (jToggleButton.isSelected()) {
                            jToggleButton2.setSelected(true);
                        }
                        if (i2 != 0) continue;
                        this.checkScrollPane.getVerticalScrollBar().setUnitIncrement(jToggleButton2.getPreferredSize().height + jToggleButton2.getMargin().top + jToggleButton2.getMargin().bottom);
                    }
                    this.checkPanel.doLayout();
                    this.checkScrollPane.doLayout();
                    this.fireNtfChange = true;
                }
            }
        } else {
            int[] nArray;
            this.list.setSelectionMode(n2);
            if (n3 != n2 && n2 == 0 && (nArray = this.list.getSelectedIndices()).length > 0) {
                this.list.setSelectedIndex(nArray[nArray.length - 1]);
            }
        }
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public String getSearchText() {
        return this.searchBox != null ? this.searchBox.getText() : "";
    }

    Column[] getColumns() {
        return this.column;
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
        if (this.list != null) {
            this.list.setBorder(null);
        }
    }

    public void setCheckList(boolean bl) {
        if (this.checkList != bl) {
            this.intSetCheckList(bl);
        }
    }

    private void intSetCheckList(boolean bl) {
        this.checkList = bl;
        this.removeAll();
        if (this.checkList) {
            this.buildCheckList();
        } else {
            this.buildStandardList();
        }
    }

    private void buildCheckList() {
        this.radioGroup = new MyButtonGroup();
        this.checkPanel = new JPanel(){
            Insets insets = new Insets(0, 4, 0, 0);

            @Override
            public Insets getInsets() {
                return this.insets;
            }
        };
        this.checkPanel.setOpaque(false);
        this.checkPanel.setLayout(new BoxLayout(this.checkPanel, 1));
        HashSet<KeyStroke> hashSet = new HashSet<KeyStroke>();
        hashSet.add(KeyStroke.getKeyStroke(40, 0));
        this.checkPanel.setFocusTraversalKeys(0, hashSet);
        hashSet = new HashSet();
        hashSet.add(KeyStroke.getKeyStroke(38, 0));
        this.checkPanel.setFocusTraversalKeys(1, hashSet);
        this.checkPanel.setFocusCycleRoot(true);
        this.checkScrollPane = new MyScrollPane(this.checkPanel);
        this.checkScrollPane.setFocusable(false);
        this.checkScrollPane.getVerticalScrollBar().setFocusable(false);
        this.checkScrollPane.getHorizontalScrollBar().setFocusable(false);
        this.checkPanel.addMouseListener(this.checkListMouseListener);
        this.checkScrollPane.getVerticalScrollBar().addMouseListener(this.checkListMouseListener);
        this.checkScrollPane.getHorizontalScrollBar().addMouseListener(this.checkListMouseListener);
        this.add((Component)this.checkScrollPane, "Center");
        JList jList = new JList();
        this.setBackground(new Color(jList.getBackground().getRGB()));
        this.setForeground(new Color(jList.getForeground().getRGB()));
        this.setFont(jList.getFont());
        this.dragcomponent = jList;
    }

    private void buildStandardList() {
        this.listPanel = new JPanel();
        OverlayLayout overlayLayout = new OverlayLayout(this.listPanel);
        this.listPanel.setLayout(overlayLayout);
        this.add((Component)this.listPanel, "Center");
        this.list = new JListWithDividers(this.model.model);
        if (this.ked == null) {
            this.ked = new KeyEventDispatcher(){
                boolean skip;

                @Override
                public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                    if (keyEvent.getSource() == ListBox.this.list) {
                        if (keyEvent.getID() == 401) {
                            this.skip = ListBox.this.paged && ListBox.this.isNoSearch && keyEvent.getKeyChar() >= ' ' && keyEvent.getKeyChar() <= '~' && keyEvent.getModifiers() == 0;
                            return this.skip;
                        }
                        if (keyEvent.getID() == 400 && this.skip) {
                            this.skip = false;
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
            };
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.ked);
        this.renderer = new FastCellRenderer();
        this.list.setCellRenderer(this.renderer);
        this.list.setAlignmentX(1.0f);
        this.intSetPaged(this.paged);
        if (this.paged) {
            this.intSetNoSearch(this.isNoSearch);
        }
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (ListBox.this.nmListener != null) {
                    int n2 = ListBox.this.list.locationToIndex(mouseEvent.getPoint());
                    Rectangle rectangle = ListBox.this.list.getCellBounds(n2, n2);
                    if (rectangle != null) {
                        if (rectangle.y + rectangle.height >= mouseEvent.getY()) {
                            if (ListBox.this.list.locationToIndex(mouseEvent.getPoint()) >= 0) {
                                ListBox.this.nmListener.sendNotifyMouseData(new NotifyMouseEvent(mouseEvent.getSource(), 17023, ListBox.this.list.locationToIndex(mouseEvent.getPoint()) + 1, 1));
                            }
                        } else {
                            ListBox.this.nmListener.sendNotifyMouseData(new NotifyMouseEvent(mouseEvent.getSource(), 17024, 0, 0));
                        }
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (ListBox.this.searchBox.isVisible()) {
                    ListBox.this.intHideSearchBox(true);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (ListBox.this.ped != null) {
                    ListBox.this.ped.stop();
                    ListBox.this.ped = null;
                }
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                PagedListBoxEvent pagedListBoxEvent;
                if (ListBox.this.list.getSelectedIndex() == ListBox.this.list.getLastVisibleIndex() && ListBox.this.ped == null) {
                    pagedListBoxEvent = new PagedListBoxEvent((Object)ListBox.this.pListeners, 2103, 1);
                    (ListBox.this.ped = new PagedEventDispatcher(ListBox.this.pListeners, pagedListBoxEvent)).start();
                }
                if (ListBox.this.list.getSelectedIndex() == ListBox.this.list.getFirstVisibleIndex() && ListBox.this.ped == null) {
                    pagedListBoxEvent = new PagedListBoxEvent((Object)ListBox.this.pListeners, 2100, 1);
                    (ListBox.this.ped = new PagedEventDispatcher(ListBox.this.pListeners, pagedListBoxEvent)).start();
                }
            }
        };
        this.list.addMouseListener(mouseInputAdapter);
        this.list.addMouseMotionListener(mouseInputAdapter);
        WindowFocusListener windowFocusListener = new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent windowEvent) {
                if (ListBox.this.ped != null) {
                    ListBox.this.ped.stop();
                    ListBox.this.ped = null;
                }
            }

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
            }
        };
        Window[] windowArray = new Window[1];
        this.list.addHierarchyListener(hierarchyEvent -> {
            if ((hierarchyEvent.getChangeFlags() & 1L) == 1L) {
                if (this.list.getParent() != null) {
                    for (Container container = this.list.getParent(); container != null; container = container.getParent()) {
                        if (!(container instanceof Window)) continue;
                        windowArray[0] = (Window)container;
                        windowArray[0].addWindowFocusListener(windowFocusListener);
                        break;
                    }
                } else if (windowArray[0] != null) {
                    windowArray[0].removeWindowFocusListener(windowFocusListener);
                }
            }
        });
        this.dragcomponent = this.list;
    }

    public boolean isCheckList() {
        return this.checkList;
    }

    public Color getSelectionForeground() {
        if (this.checkList) {
            return this.getForeground();
        }
        return this.list.getSelectionForeground();
    }

    public Color getSelectionBackground() {
        if (this.checkList) {
            return this.getBackground();
        }
        return this.list.getSelectionBackground();
    }

    public void setSelectionForeground(Color color) {
        if (!this.checkList) {
            this.list.setSelectionForeground(color);
        }
    }

    public void setSelectionBackground(Color color) {
        if (!this.checkList) {
            this.list.setSelectionBackground(color);
        }
    }

    public boolean getActiveAccept() {
        if (this.checkList) {
            return true;
        }
        return this.list.getActiveAccept();
    }

    public void setActiveAccept(boolean bl) {
        if (!this.checkList) {
            this.list.setActiveAccept(bl);
        }
    }

    public int getUpperLowerMethod() {
        return this.upperLowerMethod;
    }

    public void setUpperLowerMethod(int n2) {
        this.upperLowerMethod = n2;
    }

    public boolean isF4ShowsSearchBox() {
        return this.f4ShowsSearchBox;
    }

    public void setF4ShowsSearchBox(boolean bl) {
        this.f4ShowsSearchBox = bl;
    }

    public void refreshItem(ListItem listItem) {
        if (this.checkList) {
            int n2 = this.model.delegate.indexOf(listItem);
            if (n2 >= 0 && n2 < this.checkPanel.getComponentCount()) {
                JToggleButton jToggleButton = (JToggleButton)this.checkPanel.getComponent(n2);
                if (listItem.getBackground() != null) {
                    jToggleButton.setBackground(listItem.getBackground());
                    jToggleButton.setOpaque(true);
                    this.opaqueButtons.add(jToggleButton);
                } else {
                    jToggleButton.setOpaque(!this.gradientMgr.isPaintGradient());
                    this.opaqueButtons.remove(jToggleButton);
                }
                if (listItem.getForeground() != null) {
                    jToggleButton.setForeground(listItem.getForeground());
                }
            }
        } else {
            this.list.repaint();
        }
    }

    public int getLastMouseSelectedIndex() {
        return this.lastMouseSelectedIndex;
    }

    public void setSearchPanel(int n2) {
        this.setSearchPanel(n2, false);
    }

    private void setSearchPanel(int n2, boolean bl) {
        boolean bl2 = this.prop_SEARCH_PANEL != n2;
        this.prop_SEARCH_PANEL = n2;
        if (this.panelfind != null && bl2) {
            this.panelfind.closeperformed();
            this.panelfind = null;
        }
        if ((bl || bl2) && n2 == 1) {
            this.Find();
        }
    }

    private boolean showFindPanel(KeyEvent keyEvent) {
        if (this.gf.getRemoteVirtualKeyboard().isSearchKey(keyEvent.getKeyCode(), keyEvent.isShiftDown(), keyEvent.isControlDown(), keyEvent.isAltDown(), "list-box")) {
            if (this.prop_SEARCH_PANEL == 0) {
                this.Find();
                return true;
            }
            if (this.prop_SEARCH_PANEL == 1 && this.panelfind != null) {
                this.panelfind.findfieldrequestFocus();
                return true;
            }
            return false;
        }
        return false;
    }

    private void Find() {
        if (this.panelfind == null) {
            this.panelfind = new FindJPanel(this.getFont(), this.closeIcon, this.findIcon, this.clearIcon, this.casesensitiveIcon, this.casenotsensitiveIcon, this.casesensitiveState, this.prop_SEARCH_PANEL, this.findtimerdelay){

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(this.getSize().width, 32);
                }

                @Override
                public Insets getInsets() {
                    return new Insets(3, 3, 3, 3);
                }
            };
            this.panelfind.setFindListener(this);
            this.add((Component)this.panelfind, "North");
            this.revalidate();
            this.doLayout();
        } else {
            this.panelfind.setVisible(true);
        }
        this.panelfind.findfieldrequestFocus();
    }

    @Override
    public void findText(String string, boolean bl, boolean bl2) {
        if (bl && this.findTimer != null) {
            this.findTimer.setFindText(string, bl2);
            this.findTimer.restart();
        } else {
            if (this.findTimer != null) {
                this.findTimer.stop();
            }
            EventQueue.invokeLater(() -> this.model.intfindText(string, bl2));
        }
        if (this.renderer != null) {
            this.renderer.updateRenderer();
        }
    }

    @Override
    public void findTextClear(boolean bl) {
        this.findTextClear();
    }

    public void findTextClear() {
        this.model.findTextClear();
    }

    @Override
    public boolean isFindKeyPressed(KeyEvent keyEvent) {
        int n2 = this.gf.getRemoteVirtualKeyboard().mapKey(keyEvent);
        return this.gf.getRemoteVirtualKeyboard().isSearchKey(n2, keyEvent.isShiftDown(), keyEvent.isControlDown(), keyEvent.isAltDown(), "lsitbox");
    }

    @Override
    public void refreshSelection() {
    }

    @Override
    public void sendfinishfiltermsg() {
        if (this.findTimer != null) {
            this.findTimer.stop();
        }
    }

    public void setPW(Window window) {
        this.parentwindow = window;
        this.lastCursor = window != null ? window.getCursor() : null;
    }

    public int[] getSelectedIndicesModel() {
        if (this.checkList || this.isClosePanelFind()) {
            return this.getSelectedIndices();
        }
        int[] nArray = this.getSelectedIndices();
        if (nArray != null && nArray.length > 0) {
            ListItem listItem = null;
            int[] nArray2 = new int[nArray.length];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                listItem = (ListItem)this.model.getElementAt(this.model.convertRowIndexToModel(nArray[i2]));
                if (listItem == null) continue;
                nArray2[i2] = this.model.delegate.indexOf(listItem);
            }
            return nArray2;
        }
        return new int[0];
    }

    public int convertRowIndexToModel(int n2) {
        if (this.checkList || this.isClosePanelFind()) {
            return n2;
        }
        return this.model.convertRowIndexToModel(n2);
    }

    public int getSelectedIndexModel() {
        if (this.checkList || this.isClosePanelFind()) {
            return this.getSelectedIndex();
        }
        int n2 = this.list.getSelectedIndex();
        return n2 >= 0 ? this.model.convertRowIndexToModel(n2) : n2;
    }

    public String getSelectedValueModel() {
        if (this.checkList || this.isClosePanelFind()) {
            return this.getSelectedValue();
        }
        int n2 = this.getSelectedIndex();
        ListItem listItem = null;
        if (n2 >= 0) {
            listItem = (ListItem)this.model.getElementAt(this.model.convertRowIndexToModel(n2));
        }
        return listItem != null ? listItem.toString() : null;
    }

    private boolean isClosePanelFind() {
        return this.panelfind == null || !this.panelfind.isVisible();
    }

    private String cutString(LocalFontCmp localFontCmp, String string, int n2) {
        int n3;
        FontMetrics fontMetrics = localFontCmp.getFontMetrics();
        int n4 = fontMetrics.stringWidth(string);
        if (n4 <= n2) {
            return string;
        }
        for (n3 = string.length() - 1; n3 >= 0 && n4 > n2; n4 -= fontMetrics.charWidth(string.charAt(n3)), --n3) {
        }
        if (n3 < 0) {
            return "";
        }
        return string.substring(0, n3 + 1);
    }

    private void printMatcher(Graphics graphics, String string, int n2, int n3, int n4, int n5, LocalFontCmp localFontCmp, ListItem listItem, AbstractButton abstractButton) {
        int n6 = -1;
        int n7 = -1;
        String string2 = this.cutString(localFontCmp, string, n2);
        if (string2 != null && string2.length() > 0) {
            boolean bl = false;
            int n8 = -1;
            int n9 = -1;
            String string3 = null;
            if (listItem.matcher != null) {
                listItem.matcher.reset(string2);
                if (listItem.matcher.find()) {
                    n8 = listItem.matcher.start();
                    n9 = listItem.matcher.end();
                    string3 = listItem.matcher.group();
                    bl = true;
                }
            } else if (listItem.matcherstart >= 0 && listItem.matcherend > 0 && listItem.matcherend > listItem.matcherstart && listItem.matcherend <= string2.length() && listItem.matcherend - listItem.matcherstart > 0) {
                n8 = listItem.matcherstart;
                n9 = listItem.matcherend;
                string3 = listItem.tmatcher;
                bl = true;
            }
            if (bl) {
                Color color = graphics.getColor();
                String string4 = "";
                String string5 = "";
                String string6 = "";
                try {
                    string4 = string2.substring(0, n8);
                    string5 = string2.substring(n8, n9);
                    string6 = string2.substring(n9, string2.length());
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
                FontMetrics fontMetrics = localFontCmp.getFontMetrics();
                n4 = fontMetrics.getMaxAscent() + (abstractButton.getHeight() - (fontMetrics.getAscent() + fontMetrics.getMaxDecent())) / 2;
                n6 = SwingUtilities.computeStringWidth(fontMetrics, string4);
                n7 = SwingUtilities.computeStringWidth(fontMetrics, string3);
                graphics.drawString(string4, n3 += abstractButton.getIconTextGap() + abstractButton.getMargin().right + abstractButton.getMargin().left + 2, n4);
                graphics.setColor(this.matchingTextColorBackground);
                graphics.fillRect(n3 + n6, 0, n7, n5);
                if (this.matchingTextColorForeground != null) {
                    graphics.setColor(this.matchingTextColorForeground);
                } else {
                    graphics.setColor(color);
                }
                graphics.drawString(string5, n3 + n6, n4);
                graphics.setColor(color);
                graphics.drawString(string6, n3 + n6 + n7, n4);
            } else {
                graphics.drawString(string2, n3, n4);
            }
        } else {
            graphics.drawString(string2, n3, n4);
        }
    }

    public JPanel getFindPanel() {
        return this.panelfind;
    }

    public void setFontFindComponents(Font font) {
        if (this.panelfind != null) {
            this.panelfind.setFontFindComponents(font);
        }
    }

    public Font getFontFindComponents() {
        if (this.panelfind != null) {
            this.panelfind.getFontFindComponents();
        }
        return this.getFont();
    }

    public JComponent getDragDropComponent() {
        return this.dragcomponent;
    }

    public int getDropRow(Point point) {
        return this.dragcomponent.locationToIndex(point);
    }

    public void addNotifyMouseListener(NotifyMouseListener notifyMouseListener) {
        this.nmListener = notifyMouseListener;
    }

    public void removeNotifyMouseListener() {
        this.nmListener = null;
    }

    public void check(MouseEvent mouseEvent) {
        Point point = mouseEvent.getLocationOnScreen();
        Point point2 = this.getLocationOnScreen();
        Rectangle rectangle = new Rectangle(point2.x, point2.y, this.getBounds().width, this.getBounds().height);
        Insets insets = this.getInsets();
        if (insets != null) {
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
            point2.x += insets.left;
            point2.y += insets.top;
        }
        if ((point.x < point2.x || point.x > point2.x + rectangle.width || point.y < point2.y || point.y > point2.y + rectangle.height) && this.nmListener != null) {
            this.nmListener.sendNotifyMouseData(new NotifyMouseEvent(mouseEvent.getSource(), 17024, 0, 0));
        }
    }

    public void setMatchingTextColorBackground(Color color) {
        this.matchingTextColorBackground = color;
        if (color == null) {
            color = this.defaultMatchingTextColorBackground;
        }
    }

    public void setMatchingTextColorForeground(Color color) {
        this.matchingTextColorForeground = color;
    }

    private class MyJRadioButton
    extends JRadioButton {
        public ListItem item;
        private LocalFontCmp fcmp;
        private int baseline;

        public MyJRadioButton(String string) {
            super(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintComponent(Graphics graphics) {
            ListBox listBox = ListBox.this;
            synchronized (listBox) {
                if (this.item != null && this.item.getmatcher() != null) {
                    this.fcmp = ListBox.this.getFontCmp();
                    super.paintComponent(graphics);
                    ListBox.this.printMatcher(graphics, this.getText(), this.getWidth(), this.getHorizontalTextPosition(), this.baseline, this.getHeight(), this.fcmp, this.item, this);
                } else {
                    super.paintComponent(graphics);
                }
            }
        }
    }

    private class MyJCheckBox
    extends JCheckBox {
        public ListItem item;
        private int height;
        private LocalFontCmp fcmp;
        private int baseline;

        public MyJCheckBox(String string) {
            super(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintComponent(Graphics graphics) {
            ListBox listBox = ListBox.this;
            synchronized (listBox) {
                if (this.item != null && this.item.getmatcher() != null) {
                    this.fcmp = ListBox.this.getFontCmp();
                    this.height = this.fcmp.getHeight();
                    super.paintComponent(graphics);
                    ListBox.this.printMatcher(graphics, this.getText(), this.getWidth(), this.getHorizontalTextPosition(), this.baseline, this.getHeight(), this.fcmp, this.item, this);
                } else {
                    super.paintComponent(graphics);
                }
            }
        }
    }

    private class FindTimer
    extends Timer
    implements ActionListener {
        String findtext;
        boolean casesensitive;

        public FindTimer(int n2) {
            super(n2, null);
            this.setRepeats(false);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ListBox.this.panelfind != null) {
                ListBox.this.findText(this.findtext, false, this.casesensitive);
                ListBox.this.sendfinishfiltermsg();
            }
        }

        synchronized void setFindText(String string, boolean bl) {
            this.findtext = string;
            this.casesensitive = bl;
        }

        public String getFindText() {
            return this.findtext;
        }
    }

    private static class PagedListButton
    extends JButton
    implements PicobolWidget {
        private static final long serialVersionUID = 1L;
        private boolean activeAccept;

        public PagedListButton(ImageIcon imageIcon) {
            super(imageIcon);
        }

        @Override
        public boolean getActiveAccept() {
            return this.activeAccept;
        }

        @Override
        public boolean getSelfAct() {
            return false;
        }

        @Override
        public void setActiveAccept(boolean bl) {
            this.activeAccept = bl;
        }

        @Override
        public void asyncProcessEvent(AWTEvent aWTEvent) {
        }

        @Override
        public void setSelfAct(boolean bl) {
        }
    }

    private class JListWithDividers
    extends JList
    implements PicobolWidget,
    KeyListener,
    MouseWheelListener,
    ListSelectionListener {
        private static final long serialVersionUID = 1L;
        private boolean activated;

        public JListWithDividers(ListModel listModel) {
            super(listModel);
            super.setSelectionMode(0);
            this.addListSelectionListener(this);
            this.addKeyListener(this);
            this.addMouseWheelListener(this);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            if (ListBox.this.paged && ListBox.this.gradientMgr.isPaintGradient()) {
                ListBox.this.gradientMgr.paint((Graphics2D)graphics, new Rectangle(new Point(0, 0), this.getSize()));
            }
            super.paintComponent(graphics);
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            char c2 = Character.toLowerCase(keyEvent.getKeyChar());
            if (!Character.isLetterOrDigit(c2)) {
                return;
            }
            for (int i2 = 0; i2 < ListBox.this.model.getSize(); ++i2) {
                ListItem listItem = (ListItem)ListBox.this.model.getElementAt(i2);
                if (listItem.text.length() <= 0 || listItem.text.charAt(0) != c2) continue;
                super.setSelectedIndex(i2);
                super.ensureIndexIsVisible(i2);
                break;
            }
        }

        @Override
        public Dimension getMaximumSize() {
            return ListBox.this.listPanel.getSize();
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (ListBox.this.fireNtfChange && this.activated && this.isEnabled() && !listSelectionEvent.getValueIsAdjusting()) {
                ListBox.this.dispatchListSelectionEvent(listSelectionEvent.getFirstIndex());
            }
        }

        void handleKeyPressed(int n2) {
            Enumeration enumeration = ListBox.this.pListeners.elements();
            switch (n2) {
                case 38: {
                    if (this.getSelectedIndex() != 0) break;
                    PagedListBoxEvent pagedListBoxEvent = new PagedListBoxEvent((Object)this, 2100, 0);
                    while (enumeration.hasMoreElements()) {
                        PagedListBoxListener pagedListBoxListener = (PagedListBoxListener)enumeration.nextElement();
                        pagedListBoxListener.prevItem(pagedListBoxEvent);
                    }
                    return;
                }
                case 40: {
                    if (this.getSelectedIndex() != ListBox.this.model.getSize() - 1) break;
                    PagedListBoxEvent pagedListBoxEvent = new PagedListBoxEvent((Object)this, 2103, 0);
                    while (enumeration.hasMoreElements()) {
                        PagedListBoxListener pagedListBoxListener = (PagedListBoxListener)enumeration.nextElement();
                        pagedListBoxListener.nextItem(pagedListBoxEvent);
                    }
                    return;
                }
                case 33: {
                    PagedListBoxEvent pagedListBoxEvent = new PagedListBoxEvent((Object)this, 2101, 0);
                    while (enumeration.hasMoreElements()) {
                        PagedListBoxListener pagedListBoxListener = (PagedListBoxListener)enumeration.nextElement();
                        pagedListBoxListener.prevPage(pagedListBoxEvent);
                    }
                    return;
                }
                case 34: {
                    PagedListBoxEvent pagedListBoxEvent = new PagedListBoxEvent((Object)this, 2102, 0);
                    while (enumeration.hasMoreElements()) {
                        PagedListBoxListener pagedListBoxListener = (PagedListBoxListener)enumeration.nextElement();
                        pagedListBoxListener.nextPage(pagedListBoxEvent);
                    }
                    return;
                }
                case 36: {
                    PagedListBoxEvent pagedListBoxEvent = new PagedListBoxEvent((Object)this, 2099, 0);
                    while (enumeration.hasMoreElements()) {
                        PagedListBoxListener pagedListBoxListener = (PagedListBoxListener)enumeration.nextElement();
                        pagedListBoxListener.firstItem(pagedListBoxEvent);
                    }
                    return;
                }
                case 35: {
                    PagedListBoxEvent pagedListBoxEvent = new PagedListBoxEvent((Object)this, 2104, 0);
                    while (enumeration.hasMoreElements()) {
                        PagedListBoxListener pagedListBoxListener = (PagedListBoxListener)enumeration.nextElement();
                        pagedListBoxListener.lastItem(pagedListBoxEvent);
                    }
                    return;
                }
                case 16: {
                    ListBox.this.firstCardLayout.last(ListBox.this.firstCardPanel);
                    ListBox.this.lastCardLayout.last(ListBox.this.lastCardPanel);
                }
            }
        }

        @Override
        public void processEvent(AWTEvent aWTEvent) {
            if (ListBox.this.paged) {
                switch (aWTEvent.getID()) {
                    case 501: {
                        ListBox.this.lastMouseSelectedIndex = this.locationToIndex(((MouseEvent)aWTEvent).getPoint());
                        break;
                    }
                    case 401: {
                        KeyEvent keyEvent = (KeyEvent)aWTEvent;
                        if (ListBox.this.showFindPanel(keyEvent)) {
                            return;
                        }
                        if (keyEvent.getKeyCode() != 16 && keyEvent.getKeyCode() != 17) {
                            ListBox.this.lastMouseSelectedIndex = -2;
                        }
                        this.handleKeyPressed(keyEvent.getKeyCode());
                        if (keyEvent.getKeyCode() != 34 && keyEvent.getKeyCode() != 33) break;
                        return;
                    }
                    case 402: {
                        KeyEvent keyEvent = (KeyEvent)aWTEvent;
                        if (keyEvent.getKeyCode() != 16) break;
                        ListBox.this.firstCardLayout.first(ListBox.this.firstCardPanel);
                        ListBox.this.lastCardLayout.first(ListBox.this.lastCardPanel);
                    }
                }
            } else {
                switch (aWTEvent.getID()) {
                    case 501: {
                        ListBox.this.lastMouseSelectedIndex = this.locationToIndex(((MouseEvent)aWTEvent).getPoint());
                        break;
                    }
                    case 401: {
                        KeyEvent keyEvent = (KeyEvent)aWTEvent;
                        if (ListBox.this.showFindPanel(keyEvent)) {
                            return;
                        }
                        if (keyEvent.getKeyCode() == 16 || keyEvent.getKeyCode() == 17) break;
                        ListBox.this.lastMouseSelectedIndex = -2;
                    }
                }
            }
            super.processEvent(aWTEvent);
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (ListBox.this.dividers != null) {
                this.drawDividers(graphics);
            }
        }

        private void drawDividers(Graphics graphics) {
            int n2 = 0;
            int n3 = Math.max(this.getBounds().height, graphics.getClipBounds() != null ? graphics.getClipBounds().height : this.getBounds().height);
            for (int i2 = 0; i2 < ListBox.this.column.length; ++i2) {
                graphics.setColor(Color.black);
                graphics.fillRect(n2 += ((ListBox)ListBox.this).column[i2].width - ((ListBox)ListBox.this).column[i2].divider, 0, ((ListBox)ListBox.this).column[i2].divider, n3);
                n2 += ((ListBox)ListBox.this).column[i2].divider;
            }
        }

        @Override
        public void setActiveAccept(boolean bl) {
            this.activated = bl;
        }

        @Override
        public void asyncProcessEvent(AWTEvent aWTEvent) {
        }

        @Override
        public boolean getActiveAccept() {
            return this.activated;
        }

        @Override
        public void setSelfAct(boolean bl) {
        }

        @Override
        public boolean getSelfAct() {
            return false;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (mouseWheelEvent.getScrollType() != 0) {
                return;
            }
            if (!ListBox.this.paged) {
                JScrollBar jScrollBar = ListBox.this.listScrollPane.getVerticalScrollBar();
                if (jScrollBar != null) {
                    Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(SwingUtilities.convertMouseEvent(this, mouseWheelEvent, jScrollBar));
                }
                return;
            }
            int n2 = mouseWheelEvent.getWheelRotation();
            int n3 = -1;
            if (n2 < 0) {
                n3 = ListBox.this.mousewheellinestoscroll > 1 ? -ListBox.this.mousewheellinestoscroll : this.getSelectedIndex() + n2;
                if (n3 < 0) {
                    PagedListBoxEvent pagedListBoxEvent = new PagedListBoxEvent((Object)this, 2100, 1);
                    for (int i2 = 0; i2 < -n3; ++i2) {
                        Enumeration enumeration = ListBox.this.pListeners.elements();
                        while (enumeration.hasMoreElements()) {
                            PagedListBoxListener pagedListBoxListener = (PagedListBoxListener)enumeration.nextElement();
                            pagedListBoxListener.prevItem(pagedListBoxEvent);
                        }
                    }
                } else {
                    this.setSelectedIndex(n3);
                }
            } else if (n2 > 0) {
                n3 = ListBox.this.mousewheellinestoscroll > 1 ? -ListBox.this.mousewheellinestoscroll : ListBox.this.model.getSize() - 1 - this.getSelectedIndex() - n2;
                if (n3 < 0) {
                    PagedListBoxEvent pagedListBoxEvent = new PagedListBoxEvent((Object)this, 2103, 1);
                    for (int i3 = 0; i3 < -n3; ++i3) {
                        Enumeration enumeration = ListBox.this.pListeners.elements();
                        while (enumeration.hasMoreElements()) {
                            PagedListBoxListener pagedListBoxListener = (PagedListBoxListener)enumeration.nextElement();
                            pagedListBoxListener.nextItem(pagedListBoxEvent);
                        }
                    }
                } else {
                    this.setSelectedIndex(ListBox.this.model.getSize() - 1 - n3);
                }
            }
        }
    }

    private class SearchDocumentListener
    implements DocumentListener {
        private boolean notifyRemove = true;

        private SearchDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            ListBox.this.dispatchSearchEvent(false);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            if (this.notifyRemove) {
                ListBox.this.dispatchSearchEvent(true);
            }
        }
    }

    private class SearchKeyListener
    extends KeyAdapter {
        private SearchKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (!keyEvent.isControlDown() && !keyEvent.isAltDown() && keyEvent.getKeyChar() >= ' ' && keyEvent.getKeyChar() <= '~') {
                if (!ListBox.this.searchBox.isVisible()) {
                    SwingUtilities.invokeLater(() -> {
                        ListBox.this.intShowSearchBox();
                        ListBox.this.searchBox.setText("" + keyEvent.getKeyChar());
                    });
                }
            } else {
                int n2 = VirtualKeyboard.editing(ListBox.this.gf.getRemoteVirtualKeyboard().mapKey(keyEvent));
                switch (n2) {
                    case 196608: 
                    case 262144: {
                        if (!ListBox.this.searchBox.isVisible()) break;
                        ListBox.this.intHideSearchBox(true);
                        keyEvent.setSource(ListBox.this.list);
                        ListBox.this.list.processEvent(keyEvent);
                    }
                }
                switch (keyEvent.getKeyCode()) {
                    case 115: {
                        if (!ListBox.this.f4ShowsSearchBox) break;
                        if (!ListBox.this.searchBox.isVisible()) {
                            ListBox.this.intShowSearchBox();
                            break;
                        }
                        ListBox.this.intHideSearchBox(true);
                        break;
                    }
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 38: 
                    case 40: {
                        if (!ListBox.this.searchBox.isVisible()) break;
                        ListBox.this.intHideSearchBox(true);
                        keyEvent.setSource(ListBox.this.list);
                        ListBox.this.list.processEvent(keyEvent);
                    }
                }
            }
        }
    }

    private static class MyButtonGroup
    extends ButtonGroup {
        private MyButtonGroup() {
        }

        public Vector<AbstractButton> getButtons() {
            return this.buttons;
        }
    }

    static class ListItem {
        static final String encoding = CobolVar.encoding;
        byte[] bytes;
        String text;
        Object hiddendata;
        private int color;
        private int backgroundColor;
        private int foregroundColor;
        private Color foreground;
        private Color background;
        int matcherstart = -1;
        int matcherend = -1;
        String tmatcher = null;
        Matcher matcher = null;

        ListItem(String string) {
            this.text = string;
        }

        ListItem(byte[] byArray) {
            this.bytes = byArray;
            try {
                this.text = new String(byArray, encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.text = "";
            }
        }

        public String toString() {
            return this.text;
        }

        public void setHiddenData(Object object) {
            this.hiddendata = object;
        }

        public Object getHiddenData() {
            return this.hiddendata;
        }

        public int getColor() {
            return this.color;
        }

        public int getBackgroundColor() {
            return this.backgroundColor;
        }

        public int getForegroundColor() {
            return this.foregroundColor;
        }

        public Color getForeground() {
            return this.foreground;
        }

        public Color getBackground() {
            return this.background;
        }

        public void setColor(int n2) {
            this.color = n2;
        }

        public void setBackgroundColor(int n2) {
            this.backgroundColor = n2;
        }

        public void setForegroundColor(int n2) {
            this.foregroundColor = n2;
        }

        public void setForeground(Color color) {
            this.foreground = color;
        }

        public void setBackground(Color color) {
            this.background = color;
        }

        public void setmatcheridx(Matcher matcher, int n2, int n3, String string) {
            this.matcher = matcher;
            if (matcher == null) {
                this.matcherstart = n2;
                this.matcherend = n3;
                this.tmatcher = string;
            }
        }

        public void setmatcheridx(int n2, int n3, String string) {
            this.setmatcheridx(null, n2, n3, string);
        }

        public void clearmatcher() {
            this.matcher = null;
            this.matcherstart = -1;
            this.matcherend = -1;
            this.tmatcher = null;
        }

        public int getmatcherstart() {
            return this.matcherstart;
        }

        public int getmatcherend() {
            return this.matcherend;
        }

        public String getmatchert() {
            return this.tmatcher;
        }

        public Matcher getmatcher() {
            return this.matcher;
        }
    }

    static class Column {
        int alignment;
        int divider;
        int separator;
        int width;

        Column() {
        }
    }

    private class FastCellRenderer
    extends JPanel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;
        private ListItem item;
        private int height;
        private LocalFontCmp fcmp;
        private int baseline;
        private boolean firstPaint = true;
        private boolean showBackground;

        private FastCellRenderer() {
        }

        public void updateRenderer() {
            this.fcmp = ListBox.this.getFontCmp();
            this.baseline = this.fcmp.getAscent();
            this.height = this.fcmp.getHeight();
            ListBox.this.setFixedCellWidth(0);
            ListBox.this.setFixedCellHeight(this.height);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(0, this.height);
        }

        private String cutString(String string, int n2) {
            int n3;
            FontMetrics fontMetrics = this.fcmp.getFontMetrics();
            int n4 = fontMetrics.stringWidth(string);
            if (n4 <= n2) {
                return string;
            }
            for (n3 = string.length() - 1; n3 >= 0 && n4 > n2; n4 -= fontMetrics.charWidth(string.charAt(n3)), --n3) {
            }
            if (n3 < 0) {
                return "";
            }
            return string.substring(0, n3 + 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics graphics) {
            ListBox listBox = ListBox.this;
            synchronized (listBox) {
                Toolkit toolkit;
                Map map;
                if (this.firstPaint) {
                    ListBox.this.setPrototypeCellValue(this.item);
                    this.firstPaint = false;
                }
                String[] stringArray = ListBox.this.buildTokens(this.item);
                int n2 = 1;
                Font font = graphics.getFont();
                Graphics2D graphics2D = (Graphics2D)graphics;
                if (AbstractGuiFactoryImpl.getFontHandlingProp() != 3 && (map = (Map)(toolkit = Toolkit.getDefaultToolkit()).getDesktopProperty("awt.font.desktophints")) != null) {
                    graphics2D.addRenderingHints(map);
                }
                graphics.setFont(ListBox.this.list.getFont());
                int n3 = ListBox.this.hasButtonsOrScrollBar() ? BUTTON_PANEL_WIDTH : 0;
                for (int i2 = 0; i2 < ListBox.this.column.length; ++i2) {
                    String string = "";
                    int n4 = 0;
                    Column column = ListBox.this.column[i2];
                    int n5 = column.width;
                    if (i2 == ListBox.this.column.length - 1) {
                        n5 -= n3;
                    }
                    if (i2 == 0) {
                        --n5;
                    }
                    if (ListBox.this.list.isOpaque() || this.showBackground) {
                        graphics.setColor(this.getBackground());
                        graphics.fillRect(n2, 0, n5, this.height);
                    }
                    if (i2 < stringArray.length && stringArray[i2] != null) {
                        string = column.alignment == 0 ? ScreenUtility.rightTrim(stringArray[i2]) : stringArray[i2].trim();
                        if (ListBox.this.isUpper()) {
                            string = Factory.toUpperCase(string, ListBox.this.upperLowerMethod);
                        } else if (ListBox.this.isLower()) {
                            string = Factory.toLowerCase(string, ListBox.this.upperLowerMethod);
                        }
                        n4 = this.fcmp.computeScreenWidth(string);
                        graphics.setColor(this.getForeground());
                        int n6 = n2;
                        int n7 = n5 - column.separator - n4;
                        if (n7 > 0) {
                            if (column.alignment == 1) {
                                n6 += n7 / 2;
                            } else if (column.alignment == 2) {
                                n6 += n7;
                            } else if (n6 > 1) {
                                ++n6;
                            }
                        } else if (n6 > 1) {
                            ++n6;
                        }
                        this.printMatcher(graphics, string, column.width, n6, this.baseline, this.height);
                        if ((ListBox.this.list.isOpaque() || this.showBackground) && column.separator > 0) {
                            graphics.setColor(this.getBackground());
                            graphics.fillRect(n2 + n5 - column.separator, 0, column.separator, this.height);
                        }
                    }
                    n2 += n5;
                }
                graphics.setFont(font);
            }
        }

        private void printMatcher(Graphics graphics, String string, int n2, int n3, int n4, int n5) {
            int n6 = -1;
            int n7 = -1;
            String string2 = this.cutString(string, n2);
            if (string2 != null && string2.length() > 0) {
                boolean bl = false;
                int n8 = -1;
                int n9 = -1;
                String string3 = null;
                if (this.item.matcher != null) {
                    this.item.matcher.reset(string2);
                    if (this.item.matcher.find()) {
                        n8 = this.item.matcher.start();
                        n9 = this.item.matcher.end();
                        string3 = this.item.matcher.group();
                        bl = true;
                    }
                } else if (this.item.matcherstart >= 0 && this.item.matcherend > 0 && this.item.matcherend > this.item.matcherstart && this.item.matcherend <= string2.length() && this.item.matcherend - this.item.matcherstart > 0) {
                    n8 = this.item.matcherstart;
                    n9 = this.item.matcherend;
                    string3 = this.item.tmatcher;
                    bl = true;
                }
                if (bl) {
                    Color color = graphics.getColor();
                    String string4 = "";
                    String string5 = "";
                    String string6 = "";
                    try {
                        string4 = string2.substring(0, n8);
                        string5 = string2.substring(n8, n9);
                        string6 = string2.substring(n9, string2.length());
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    FontMetrics fontMetrics = this.fcmp.getFontMetrics();
                    n6 = SwingUtilities.computeStringWidth(fontMetrics, string4);
                    n7 = SwingUtilities.computeStringWidth(fontMetrics, string3);
                    graphics.drawString(string4, n3, n4);
                    graphics.setColor(ListBox.this.matchingTextColorBackground);
                    graphics.fillRect(n3 + n6, 0, n7, n5);
                    if (ListBox.this.matchingTextColorForeground != null) {
                        graphics.setColor(ListBox.this.matchingTextColorForeground);
                    } else {
                        graphics.setColor(color);
                    }
                    graphics.drawString(string5, n3 + n6, n4);
                    graphics.setColor(color);
                    graphics.drawString(string6, n3 + n6 + n7, n4);
                } else {
                    graphics.drawString(string2, n3, n4);
                }
            } else {
                graphics.drawString(string2, n3, n4);
            }
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
            Color color;
            Color color2;
            if (bl) {
                color2 = jList.getSelectionBackground();
                color = jList.getSelectionForeground();
                this.showBackground = true;
            } else {
                color2 = ListBox.this.getBackgroundColor((ListItem)ListBox.this.model.getElementAt(n2), n2);
                if (color2 == null) {
                    color2 = jList.getBackground();
                    this.showBackground = false;
                } else {
                    this.showBackground = true;
                }
                color = ListBox.this.getForegroundColor((ListItem)ListBox.this.model.getElementAt(n2), n2);
                if (color == null) {
                    color = jList.getForeground();
                }
            }
            if (!jList.isEnabled()) {
                color2 = color2.darker();
                color = color.darker();
            }
            this.setBackground(color2);
            this.setForeground(color);
            this.item = object instanceof ListItem ? (ListItem)object : new ListItem("");
            return this;
        }
    }

    private class FilteredListModel {
        private Vector<ListItem> delegate = new Vector();
        private final MyListModel model = new MyListModel();

        private FilteredListModel() {
        }

        public Object getElementAt(int n2) {
            if (n2 >= 0 && n2 < this.delegate.size()) {
                return this.delegate.elementAt(n2);
            }
            return null;
        }

        public int getSize() {
            return this.delegate.size();
        }

        public void addElement(ListItem listItem) {
            this.delegate.addElement(listItem);
            this.model.addElement(listItem);
            if (ListBox.this.findTimer != null && ListBox.this.findTimer.getFindText() != null) {
                ListBox.this.findTimer.restart();
            }
        }

        public void add(int n2, ListItem listItem) {
            int n3 = this.delegate.size();
            if (n2 <= n3) {
                this.delegate.add(n2, listItem);
                this.model.add(n2, listItem);
            } else {
                this.delegate.addElement(listItem);
                this.model.addElement(listItem);
            }
            if (ListBox.this.findTimer != null && ListBox.this.findTimer.getFindText() != null) {
                ListBox.this.findTimer.restart();
            }
        }

        public void removeElementAt(int n2) {
            if (n2 >= 0 && n2 < this.delegate.size()) {
                this.delegate.removeElementAt(n2);
                this.model.removeElementAt(n2);
                if (ListBox.this.findTimer != null && ListBox.this.findTimer.getFindText() != null) {
                    ListBox.this.findTimer.restart();
                }
            }
        }

        public void removeAllElements() {
            int n2 = this.delegate.size();
            if (n2 > 0) {
                this.delegate = new Vector();
                this.model.removeAllElements();
            }
        }

        public void intfindText(String string, boolean bl) {
            ListBox.this.casesensitiveState = bl;
            if (this.delegate != null && this.delegate.size() > 0) {
                ListBox.this.clearSelection();
                ListBox.this.panelfind.findfieldsetBorder(ListBox.this.syntaxborderok);
                if (string != null && string.length() > 0) {
                    if (ListBox.this.syntaxbordererr == null) {
                        ListBox.this.syntaxbordererr = BorderFactory.createLineBorder(Color.red);
                    }
                    if (!bl) {
                        string = "(?i)" + string;
                    }
                    this.model.removeAllElements();
                    this.model.clear();
                    this.model.fireAdded = false;
                    boolean bl2 = true;
                    Pattern pattern = null;
                    try {
                        pattern = Pattern.compile(string);
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        ListBox.this.panelfind.findfieldsetBorder(ListBox.this.syntaxbordererr);
                        return;
                    }
                    ListBox.this.parentwindow.setCursor(BUSY_CURSOR);
                    ListBox.this.panelfind.findfieldsetBorder(ListBox.this.syntaxborderok);
                    Matcher matcher = pattern.matcher("");
                    String string2 = "";
                    for (ListItem listItem : this.delegate) {
                        string2 = listItem.toString();
                        if (string2 == null) {
                            listItem.setmatcheridx(null, -1, -1, "");
                            continue;
                        }
                        matcher.reset(string2);
                        if (matcher.find()) {
                            listItem.setmatcheridx(matcher, matcher.start(), matcher.end(), matcher.group());
                            this.model.addElement(listItem);
                            continue;
                        }
                        listItem.setmatcheridx(null, -1, -1, "");
                    }
                    this.model.fireAdded = true;
                    this.model.update();
                    if (ListBox.this.listScrollPane != null) {
                        ListBox.this.listScrollPane.doLayout();
                    }
                    if (ListBox.this.checkScrollPane != null) {
                        ListBox.this.fireNtfChange = false;
                        ListBox.this.removeAllCheckItems();
                        for (int i2 = 0; i2 < this.model.getSize(); ++i2) {
                            ListItem listItem;
                            listItem = (ListItem)this.model.getElementAt(i2);
                            ListBox.this.addCheckItem(listItem, i2);
                        }
                        ListBox.this.fireNtfChange = true;
                        ListBox.this.checkScrollPane.doLayout();
                        ListBox.this.checkScrollPane.getViewport().repaint();
                    }
                    ListBox.this.setThumbPosition(ListBox.this.thumbPosition);
                    ListBox.this.parentwindow.setCursor(ListBox.this.lastCursor);
                } else {
                    this.findTextClear();
                }
            } else {
                this.findTextClear();
            }
        }

        public void findTextClear() {
            int[] nArray = ListBox.this.getSelectedIndices();
            if (nArray.length > 0) {
                Object object = null;
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    object = (ListItem)this.model.getElementAt(this.convertRowIndexToModel(nArray[i2]));
                    if (object == null) continue;
                    nArray[i2] = this.delegate.indexOf(object);
                }
            }
            this.model.clear();
            this.model.fireAdded = false;
            for (ListItem listItem : this.delegate) {
                listItem.clearmatcher();
                this.model.addElement(listItem);
            }
            this.model.fireAdded = true;
            this.model.update();
            if (ListBox.this.listScrollPane != null) {
                ListBox.this.listScrollPane.doLayout();
            }
            if (ListBox.this.checkScrollPane != null) {
                ListBox.this.fireNtfChange = false;
                ListBox.this.removeAllCheckItems();
                for (int i3 = 0; i3 < this.model.getSize(); ++i3) {
                    ListItem listItem = (ListItem)this.model.getElementAt(i3);
                    ListBox.this.addCheckItem(listItem, i3);
                }
                ListBox.this.fireNtfChange = true;
                ListBox.this.checkScrollPane.doLayout();
                ListBox.this.checkScrollPane.getViewport().repaint();
            }
            ListBox.this.setThumbPosition(ListBox.this.thumbPosition);
            if (nArray.length > 0) {
                ListBox.this.select(nArray);
            }
        }

        public int convertRowIndexToModel(int n2) {
            if (ListBox.this.isClosePanelFind()) {
                return n2;
            }
            ListItem listItem = null;
            listItem = (ListItem)this.model.elementAt(n2);
            if (listItem != null) {
                return this.delegate.indexOf(listItem);
            }
            return -1;
        }
    }

    private static class MyListModel
    extends DefaultListModel {
        private boolean fireAdded = true;

        private MyListModel() {
        }

        @Override
        protected void fireIntervalAdded(Object object, int n2, int n3) {
            if (this.fireAdded) {
                super.fireIntervalAdded(object, n2, n3);
            }
        }

        void update() {
            int n2 = this.getSize();
            if (n2 > 0) {
                super.fireIntervalAdded(this, 0, n2 - 1);
            }
        }
    }

    private class MyScrollPane
    extends JScrollPane {
        MyScrollPane(Component component) {
            super(component);
        }

        MyScrollPane(Component component, int n2, int n3) {
            super(component, n2, n3);
        }

        @Override
        protected JViewport createViewport() {
            return new JViewport(){

                @Override
                public void paintComponent(Graphics graphics) {
                    if (ListBox.this.gradientMgr.isPaintGradient()) {
                        JScrollBar jScrollBar;
                        Dimension dimension = this.getSize();
                        JScrollBar jScrollBar2 = MyScrollPane.this.getVerticalScrollBar();
                        if (jScrollBar2.isVisible()) {
                            dimension.width += jScrollBar2.getSize().width;
                        }
                        if ((jScrollBar = MyScrollPane.this.getHorizontalScrollBar()).isVisible()) {
                            dimension.height += jScrollBar.getSize().height;
                        }
                        ListBox.this.gradientMgr.paint((Graphics2D)graphics, new Rectangle(new Point(0, 0), dimension));
                    }
                    super.paintComponent(graphics);
                }
            };
        }
    }

    private static class PagedEventDispatcher
    implements ActionListener {
        private Timer t;
        private Vector pblisteners;
        private PagedListBoxEvent pbe;

        PagedEventDispatcher(Vector vector, PagedListBoxEvent pagedListBoxEvent) {
            this.pblisteners = vector;
            this.pbe = pagedListBoxEvent;
            this.fireEvents();
            this.t = new Timer(75, this);
            this.t.setInitialDelay(300);
            this.t.setRepeats(true);
        }

        public void start() {
            this.t.start();
        }

        public void stop() {
            this.t.stop();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.fireEvents();
        }

        private void fireEvents() {
            Enumeration enumeration = this.pblisteners.elements();
            while (enumeration.hasMoreElements()) {
                PagedListBoxListener pagedListBoxListener = (PagedListBoxListener)enumeration.nextElement();
                switch (this.pbe.getID()) {
                    case 2100: {
                        pagedListBoxListener.prevItem(this.pbe);
                        break;
                    }
                    case 2103: {
                        pagedListBoxListener.nextItem(this.pbe);
                        break;
                    }
                    case 2101: {
                        pagedListBoxListener.prevPage(this.pbe);
                        break;
                    }
                    case 2102: {
                        pagedListBoxListener.nextPage(this.pbe);
                        break;
                    }
                    case 2099: {
                        pagedListBoxListener.firstItem(this.pbe);
                        break;
                    }
                    case 2104: {
                        pagedListBoxListener.lastItem(this.pbe);
                    }
                }
            }
        }
    }
}

