/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.client.swing.GradientManager;
import com.iscobol.gui.client.swing.MainPanel;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.DefaultDesktopManager;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

public class MDIPanel
extends MainPanel {
    private MDIDesktopPane desktopPane;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private GradientManager gradientMgr;

    public MDIPanel() {
        super(false);
        this.init();
    }

    public MDIPanel(RemoteDisplayWindow remoteDisplayWindow) {
        super(remoteDisplayWindow, false);
        this.gradientMgr = remoteDisplayWindow.gradientMgr;
        this.gradientMgr.addPropertyChangeListener(propertyChangeEvent -> this.repaint());
        this.init();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.addPropertyChangeListener(propertyChangeListener);
        } else {
            super.addPropertyChangeListener(propertyChangeListener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        } else {
            super.removePropertyChangeListener(propertyChangeListener);
        }
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.desktopPane = new MDIDesktopPane(this.changeSupport, this.gradientMgr);
        this.add((Component)this.desktopPane, "Center");
    }

    public JDesktopPane getDesktopPane() {
        return this.desktopPane;
    }

    @Override
    public boolean isExpandable() {
        return false;
    }

    @Override
    public void setExpandable(boolean bl) {
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.desktopPane != null) {
            this.desktopPane.setBackground(color);
        }
    }

    private static class MDIDesktopPane
    extends JDesktopPane {
        private final PropertyChangeSupport cs;
        private final GradientManager gradientMgr;

        public MDIDesktopPane(PropertyChangeSupport propertyChangeSupport, GradientManager gradientManager) {
            DefaultDesktopManager defaultDesktopManager = new DefaultDesktopManager();
            this.cs = propertyChangeSupport;
            this.gradientMgr = gradientManager;
            this.setDesktopManager(defaultDesktopManager);
        }

        @Override
        public void setSelectedFrame(JInternalFrame jInternalFrame) {
            JInternalFrame jInternalFrame2 = this.getSelectedFrame();
            if (jInternalFrame2 != jInternalFrame) {
                super.setSelectedFrame(jInternalFrame);
                this.cs.firePropertyChange("selectionChanged", jInternalFrame2, jInternalFrame);
            }
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.gradientMgr != null) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                this.gradientMgr.paint(graphics2D, new Rectangle(0, 0, this.getWidth(), this.getHeight()));
            }
        }
    }
}

