/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.client.Terminal;
import com.iscobol.gui.client.swing.BorderedPanel;
import com.iscobol.gui.client.swing.PicobolStatusBar;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;

public class MainPanel
extends BorderedPanel {
    private int width;
    private int height;
    private int origWidth;
    private int origHeight;
    private boolean expandable;
    private Component rightmostComponent;
    private int rightmostX = -1;
    private Component bottommostComponent;
    private int bottommostY = -1;
    private ComponentListener listener = new ComponentAdapter(){

        private void handleEvent(ComponentEvent componentEvent) {
            if (componentEvent.getComponent() == MainPanel.this.rightmostComponent || componentEvent.getComponent() == MainPanel.this.bottommostComponent) {
                MainPanel.this.setBottomRightmostComponent();
                if (MainPanel.this.rightmostX >= 0 || MainPanel.this.bottommostY >= 0) {
                    MainPanel.this.adjustSize();
                }
            } else {
                MainPanel.this.setBottomRightmostComponent(componentEvent.getComponent());
                if (MainPanel.this.rightmostComponent == componentEvent.getComponent() || MainPanel.this.bottommostComponent == componentEvent.getComponent()) {
                    MainPanel.this.adjustSize();
                }
            }
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            this.handleEvent(componentEvent);
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            this.handleEvent(componentEvent);
        }
    };

    public MainPanel(RemoteDisplayWindow remoteDisplayWindow, boolean bl) {
        super(remoteDisplayWindow, bl);
    }

    public MainPanel(boolean bl) {
        this((RemoteDisplayWindow)null, bl);
    }

    @Override
    public Component add(Component component) {
        return this.add(component, -1);
    }

    @Override
    public Component add(Component component, int n2) {
        if (this.getLayout() == null && this.expandable && this.isValidComponent(component)) {
            this.setBottomRightmostComponent(component);
            if (component == this.rightmostComponent || component == this.bottommostComponent) {
                this.adjustSize();
            }
            component.addComponentListener(this.listener);
        }
        Component component2 = n2 >= 0 ? super.add(component, n2) : super.add(component);
        return component2;
    }

    @Override
    public void remove(Component component) {
        super.remove(component);
        if (this.getLayout() == null && this.expandable && this.isValidComponent(component)) {
            component.removeComponentListener(this.listener);
            if (component == this.rightmostComponent || component == this.bottommostComponent) {
                this.setBottomRightmostComponent();
                if (this.rightmostX >= 0 || this.bottommostY >= 0) {
                    this.adjustSize();
                }
            }
        }
    }

    private boolean isValidComponent(Component component) {
        return !(component instanceof Terminal) && !(component instanceof PicobolStatusBar);
    }

    private void adjustSize() {
        this.mySetSize(Math.max(this.origWidth, this.rightmostX), Math.max(this.origHeight, this.bottommostY));
    }

    public Dimension getOrigSize() {
        return new Dimension(this.origWidth, this.origHeight);
    }

    private void setBottomRightmostComponent(Component component) {
        if (this.rightmostX >= 0 || this.bottommostY >= 0) {
            Rectangle rectangle = component.getBounds();
            if (rectangle.x + rectangle.width > this.rightmostX) {
                this.rightmostComponent = component;
                this.rightmostX = rectangle.x + rectangle.width;
            }
            if (rectangle.y + rectangle.height > this.bottommostY) {
                this.bottommostComponent = component;
                this.bottommostY = rectangle.y + rectangle.height;
            }
        } else if (this.rightmostX == -1 && this.bottommostY == -1) {
            this.rightmostComponent = component;
            this.bottommostComponent = component;
            Rectangle rectangle = component.getBounds();
            this.rightmostX = rectangle.x + rectangle.width;
            this.bottommostY = rectangle.y + rectangle.height;
        }
    }

    private void setBottomRightmostComponent() {
        Component[] componentArray = this.getComponents();
        Component component = null;
        Point point = new Point();
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            if (!this.isValidComponent(componentArray[i2])) continue;
            component = componentArray[i2];
            Rectangle rectangle = component.getBounds();
            int n2 = rectangle.x + rectangle.width;
            int n3 = rectangle.y + rectangle.height;
            if (n2 > point.x) {
                point.x = n2;
                this.rightmostComponent = component;
                this.rightmostX = n2;
            }
            if (n3 <= point.y) continue;
            point.y = n3;
            this.bottommostComponent = component;
            this.bottommostY = n3;
        }
    }

    public Dimension myGetSize() {
        return new Dimension(this.width, this.height);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.myGetSize();
    }

    public void mySetSize(int n2, int n3) {
        if (this.width != n2 || this.height != n3) {
            this.width = n2;
            this.height = n3;
            this.setSize(n2, n3);
        }
    }

    public void setInitD(int n2, int n3) {
        this.origWidth = n2;
        this.origHeight = n3;
        this.mySetSize(this.origWidth, this.origHeight);
    }

    public boolean isExpandable() {
        return this.expandable;
    }

    public void setExpandable(boolean bl) {
        this.expandable = bl;
    }
}

