/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.IsguiUtility;
import com.iscobol.gui.client.PicobolWidget;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class MassUpdatePanel
extends JPanel
implements PicobolWidget {
    private final JComponent component;
    private boolean massUpdate;
    private Layout layout;
    private boolean selfAct;
    private boolean activeAccept;
    private final Preview preview = new Preview();
    private Listener listener;

    public MassUpdatePanel(JComponent jComponent) {
        this.component = jComponent;
        this.preview.setFocusable(true);
        this.layout = new Layout(this, this.component, this.preview);
        this.setLayout(this.layout);
    }

    public boolean isMassUpdate() {
        return this.massUpdate;
    }

    public void setMassUpdate(boolean bl) {
        if (this.massUpdate != bl) {
            this.massUpdate = bl;
            if (this.massUpdate) {
                Dimension dimension = this.component.getSize();
                if (dimension.width > 0 && dimension.height > 0) {
                    Image image = this.component.isShowing() ? MassUpdatePanel.takeScreenshot(this.component) : IsguiUtility.takeScreenshot(this.component);
                    this.preview.setImage(image);
                }
                this.layout.show2();
            } else {
                this.layout.show1();
            }
            if (this.listener != null) {
                this.listener.massUpdateChanged(this.massUpdate);
            }
        }
    }

    Listener getListener() {
        return this.listener;
    }

    void setListener(Listener listener) {
        this.listener = listener;
    }

    private static Image takeScreenshot(JComponent jComponent) {
        BufferedImage bufferedImage = new BufferedImage(jComponent.getWidth(), jComponent.getHeight(), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        jComponent.paintAll(graphics2D);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public void setActiveAccept(boolean bl) {
        this.activeAccept = bl;
        if (this.component instanceof PicobolWidget) {
            ((PicobolWidget)((Object)this.component)).setActiveAccept(bl);
        }
    }

    @Override
    public boolean getActiveAccept() {
        return this.activeAccept;
    }

    @Override
    public void setSelfAct(boolean bl) {
        this.selfAct = bl;
        if (this.component instanceof PicobolWidget) {
            ((PicobolWidget)((Object)this.component)).setSelfAct(bl);
        }
    }

    @Override
    public boolean getSelfAct() {
        return this.selfAct;
    }

    @Override
    public void asyncProcessEvent(AWTEvent aWTEvent) {
        if (this.component instanceof PicobolWidget) {
            ((PicobolWidget)((Object)this.component)).asyncProcessEvent(aWTEvent);
        }
    }

    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public void setFont(Font font) {
        if (this.component != null) {
            this.component.setFont(font);
        } else {
            super.setFont(font);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.component != null) {
            this.component.setEnabled(bl);
        }
    }

    @Override
    public Font getFont() {
        if (this.component != null) {
            return this.component.getFont();
        }
        return super.getFont();
    }

    @Override
    public void setBackground(Color color) {
        if (this.component != null) {
            this.component.setBackground(color);
        } else {
            super.setBackground(color);
        }
    }

    @Override
    public Color getBackground() {
        if (this.component != null) {
            return this.component.getBackground();
        }
        return super.getBackground();
    }

    @Override
    public void setForeground(Color color) {
        if (this.component != null) {
            this.component.setForeground(color);
        } else {
            super.setForeground(color);
        }
    }

    @Override
    public Color getForeground() {
        if (this.component != null) {
            return this.component.getForeground();
        }
        return super.getForeground();
    }

    @Override
    public void setToolTipText(String string) {
        if (this.component != null) {
            this.component.setToolTipText(string);
            this.preview.setToolTipText(string);
        } else {
            super.setToolTipText(string);
        }
    }

    @Override
    public String getToolTipText() {
        if (this.component != null) {
            return this.component.getToolTipText();
        }
        return super.getToolTipText();
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        if (this.component != null) {
            this.component.addKeyListener(keyListener);
        } else {
            super.addKeyListener(keyListener);
        }
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        if (this.component != null) {
            this.component.removeKeyListener(keyListener);
        } else {
            super.removeKeyListener(keyListener);
        }
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
        if (this.component != null) {
            this.component.addFocusListener(focusListener);
        } else {
            super.addFocusListener(focusListener);
        }
    }

    @Override
    public void removeFocusListener(FocusListener focusListener) {
        if (this.component != null) {
            this.component.removeFocusListener(focusListener);
        } else {
            super.removeFocusListener(focusListener);
        }
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        if (this.component != null) {
            this.component.addMouseListener(mouseListener);
        } else {
            super.addMouseListener(mouseListener);
        }
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        if (this.component != null) {
            this.component.removeMouseListener(mouseListener);
        } else {
            super.removeMouseListener(mouseListener);
        }
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (this.component != null) {
            this.component.addMouseMotionListener(mouseMotionListener);
        } else {
            super.addMouseMotionListener(mouseMotionListener);
        }
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (this.component != null) {
            this.component.removeMouseMotionListener(mouseMotionListener);
        } else {
            super.removeMouseMotionListener(mouseMotionListener);
        }
    }

    @Override
    public void addMouseWheelListener(MouseWheelListener mouseWheelListener) {
        if (this.component != null) {
            this.component.addMouseWheelListener(mouseWheelListener);
        } else {
            super.addMouseWheelListener(mouseWheelListener);
        }
    }

    @Override
    public void removeMouseWheelListener(MouseWheelListener mouseWheelListener) {
        if (this.component != null) {
            this.component.removeMouseWheelListener(mouseWheelListener);
        } else {
            super.removeMouseWheelListener(mouseWheelListener);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.component != null) {
            this.component.addPropertyChangeListener(propertyChangeListener);
        } else {
            super.addPropertyChangeListener(propertyChangeListener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.component != null) {
            this.component.removePropertyChangeListener(propertyChangeListener);
        } else {
            super.removePropertyChangeListener(propertyChangeListener);
        }
    }

    @Override
    public void requestFocus() {
        if (this.component != null) {
            if (this.layout.showed == this.component) {
                this.component.requestFocus();
            } else {
                this.preview.requestFocus();
            }
        } else {
            super.requestFocus();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.component != null) {
            if (this.layout.showed == this.component) {
                return this.component.requestFocusInWindow();
            }
            return this.preview.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    private static class Layout
    implements LayoutManager {
        final Component comp1;
        final Component comp2;
        final Container parent;
        Component showed;

        Layout(Container container, Component component, Component component2) {
            this.parent = container;
            this.comp1 = component;
            this.comp2 = component2;
            this.parent.add(this.comp1);
            this.parent.add(this.comp2);
            this.show1();
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return this.comp1 != null ? this.comp1.getSize() : new Dimension(0, 0);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        @Override
        public void layoutContainer(Container container) {
            Insets insets = container.getInsets();
            Rectangle rectangle = new Rectangle(insets.left, insets.top, container.getSize().width - insets.left - insets.right, container.getSize().height - insets.top - insets.bottom);
            this.comp1.setBounds(rectangle);
            this.comp2.setBounds(rectangle);
        }

        void show1() {
            this.show(this.comp1);
        }

        void show2() {
            this.show(this.comp2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void show(Component component) {
            Object object = this.parent.getTreeLock();
            synchronized (object) {
                this.showed = component;
                if (this.showed == this.comp1) {
                    this.comp2.setVisible(false);
                    this.comp1.setVisible(true);
                } else {
                    this.comp1.setVisible(false);
                    this.comp2.setVisible(true);
                }
                this.parent.validate();
            }
        }
    }

    private static class Preview
    extends JComponent {
        Image image;

        private Preview() {
        }

        void setImage(Image image) {
            this.image = image;
        }

        @Override
        public void paint(Graphics graphics) {
            graphics.drawImage(this.image, 0, 0, null);
        }
    }

    public static interface Listener {
        public void massUpdateChanged(boolean var1);
    }
}

