/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuSelectionManager;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class MenuScroller {
    private JPopupMenu menu;
    private Component[] menuItems;
    private MenuScrollItem upItem;
    private MenuScrollItem downItem;
    private final MenuScrollListener menuListener = new MenuScrollListener();
    private int scrollCount;
    private int interval;
    private int topFixedCount;
    private int bottomFixedCount;
    private int firstIndex = 0;
    private int keepVisibleIndex = -1;

    public static MenuScroller setScrollerFor(JPopupMenu jPopupMenu) {
        return new MenuScroller(jPopupMenu);
    }

    public static MenuScroller setScrollerFor(JPopupMenu jPopupMenu, int n2) {
        return new MenuScroller(jPopupMenu, n2);
    }

    public static MenuScroller setScrollerFor(JPopupMenu jPopupMenu, int n2, int n3) {
        return new MenuScroller(jPopupMenu, n2, n3);
    }

    public static MenuScroller setScrollerFor(JPopupMenu jPopupMenu, int n2, int n3, int n4, int n5) {
        return new MenuScroller(jPopupMenu, n2, n3, n4, n5);
    }

    public MenuScroller(JPopupMenu jPopupMenu) {
        this(jPopupMenu, 15);
    }

    public MenuScroller(JPopupMenu jPopupMenu, int n2) {
        this(jPopupMenu, n2, 150);
    }

    public MenuScroller(JPopupMenu jPopupMenu, int n2, int n3) {
        this(jPopupMenu, n2, n3, 0, 0);
    }

    public MenuScroller(JPopupMenu jPopupMenu, int n2, int n3, int n4, int n5) {
        int n6 = this.scrollCountForScreen(n4, n5);
        if (n2 <= 0 || n2 > n6) {
            n2 = n6;
        }
        if (n3 <= 0) {
            n3 = 8;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        this.upItem = new MenuScrollItem(MenuIcon.UP, -1);
        this.downItem = new MenuScrollItem(MenuIcon.DOWN, 1);
        this.setScrollCount(n2);
        this.setInterval(n3);
        this.setTopFixedCount(n4);
        this.setBottomFixedCount(n5);
        this.menu = jPopupMenu;
        jPopupMenu.addPopupMenuListener(this.menuListener);
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int n2) {
        if (n2 <= 0) {
            n2 = 8;
        }
        this.upItem.setInterval(n2);
        this.downItem.setInterval(n2);
        this.interval = n2;
    }

    public int getscrollCount() {
        return this.scrollCount;
    }

    public void setScrollCount(int n2) {
        this.scrollCount = n2;
        MenuSelectionManager.defaultManager().clearSelectedPath();
    }

    public int getTopFixedCount() {
        return this.topFixedCount;
    }

    public void setTopFixedCount(int n2) {
        this.firstIndex = this.firstIndex <= n2 ? n2 : (this.firstIndex += n2 - this.topFixedCount);
        this.topFixedCount = n2;
    }

    public int getBottomFixedCount() {
        return this.bottomFixedCount;
    }

    public void setBottomFixedCount(int n2) {
        this.bottomFixedCount = n2;
    }

    public void keepVisible(JMenuItem jMenuItem) {
        int n2;
        this.keepVisibleIndex = jMenuItem == null ? -1 : (n2 = this.menu.getComponentIndex(jMenuItem));
    }

    public void keepVisible(int n2) {
        this.keepVisibleIndex = n2;
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.removePopupMenuListener(this.menuListener);
            this.menu = null;
        }
    }

    public void finalize() throws Throwable {
        this.dispose();
    }

    private void refreshMenu() {
        if (this.menuItems != null && this.menuItems.length > 0) {
            int n2;
            this.firstIndex = Math.max(this.topFixedCount, this.firstIndex);
            this.firstIndex = Math.min(this.menuItems.length - this.bottomFixedCount - this.scrollCount, this.firstIndex);
            this.upItem.setEnabled(this.firstIndex > this.topFixedCount);
            this.downItem.setEnabled(this.firstIndex + this.scrollCount < this.menuItems.length - this.bottomFixedCount);
            this.menu.removeAll();
            for (n2 = 0; n2 < this.topFixedCount; ++n2) {
                this.menu.add(this.menuItems[n2]);
            }
            if (this.topFixedCount > 0) {
                this.menu.addSeparator();
            }
            this.menu.add(this.upItem);
            n2 = 0;
            for (n2 = this.firstIndex; n2 < this.scrollCount + this.firstIndex; ++n2) {
                this.menu.add(this.menuItems[n2]);
            }
            this.menu.add(this.downItem);
            if (this.bottomFixedCount > 0) {
                this.menu.addSeparator();
            }
            for (n2 = this.menuItems.length - this.bottomFixedCount; n2 < this.menuItems.length; ++n2) {
                this.menu.add(this.menuItems[n2]);
            }
            JComponent jComponent = (JComponent)this.upItem.getParent();
            jComponent.revalidate();
            jComponent.repaint();
        }
    }

    public int scrollCountForScreen(int n2, int n3) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        JMenuItem jMenuItem = new JMenuItem("HH");
        int n4 = jMenuItem.getPreferredSize().height;
        int n5 = 40;
        int n6 = (dimension.height - 40) / n4 - n2 - n3 - 2;
        return n6;
    }

    static /* synthetic */ Component[] access$102(MenuScroller menuScroller, Component[] componentArray) {
        menuScroller.menuItems = componentArray;
        return componentArray;
    }

    private static enum MenuIcon implements Icon
    {
        UP(9, 1, 9),
        DOWN(1, 9, 1);

        final int[] xPoints = new int[]{1, 5, 9};
        final int[] yPoints;

        private MenuIcon(int ... nArray) {
            this.yPoints = nArray;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            Dimension dimension = component.getSize();
            Graphics graphics2 = graphics.create(dimension.width / 2 - 5, dimension.height / 2 - 5, 10, 10);
            graphics2.setColor(Color.GRAY);
            graphics2.drawPolygon(this.xPoints, this.yPoints, 3);
            if (component.isEnabled()) {
                graphics2.setColor(Color.BLACK);
                graphics2.fillPolygon(this.xPoints, this.yPoints, 3);
            }
            graphics2.dispose();
        }

        @Override
        public int getIconWidth() {
            return 0;
        }

        @Override
        public int getIconHeight() {
            return 10;
        }
    }

    private class MenuScrollItem
    extends JMenuItem
    implements ChangeListener {
        private MenuScrollTimer timer;

        public MenuScrollItem(MenuIcon menuIcon, int n2) {
            this.setIcon(menuIcon);
            this.setDisabledIcon(menuIcon);
            this.timer = new MenuScrollTimer(n2, MenuScroller.this.interval);
            this.addChangeListener(this);
        }

        public void setInterval(int n2) {
            this.timer.setDelay(n2);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (this.isArmed() && !this.timer.isRunning()) {
                this.timer.start();
            }
            if (!this.isArmed() && this.timer.isRunning()) {
                this.timer.stop();
            }
        }
    }

    private class MenuScrollTimer
    extends Timer {
        public MenuScrollTimer(final int n2, int n3) {
            super(n3, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MenuScroller.this.firstIndex = MenuScroller.this.firstIndex + n2;
                    MenuScroller.this.refreshMenu();
                }
            });
        }
    }

    private class MenuScrollListener
    implements PopupMenuListener {
        private MenuScrollListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            this.setMenuItems();
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            this.restoreMenuItems();
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            this.restoreMenuItems();
        }

        private void setMenuItems() {
            MenuScroller.access$102(MenuScroller.this, MenuScroller.this.menu.getComponents());
            if (MenuScroller.this.keepVisibleIndex >= MenuScroller.this.topFixedCount && MenuScroller.this.keepVisibleIndex <= MenuScroller.this.menuItems.length - MenuScroller.this.bottomFixedCount && (MenuScroller.this.keepVisibleIndex > MenuScroller.this.firstIndex + MenuScroller.this.scrollCount || MenuScroller.this.keepVisibleIndex < MenuScroller.this.firstIndex)) {
                MenuScroller.this.firstIndex = Math.min(MenuScroller.this.firstIndex, MenuScroller.this.keepVisibleIndex);
                MenuScroller.this.firstIndex = Math.max(MenuScroller.this.firstIndex, MenuScroller.this.keepVisibleIndex - MenuScroller.this.scrollCount + 1);
            }
            if (MenuScroller.this.menuItems.length > MenuScroller.this.topFixedCount + MenuScroller.this.scrollCount + MenuScroller.this.bottomFixedCount) {
                MenuScroller.this.refreshMenu();
            }
        }

        private void restoreMenuItems() {
            MenuScroller.this.menu.removeAll();
            for (Component component : MenuScroller.this.menuItems) {
                MenuScroller.this.menu.add(component);
            }
        }
    }
}

