/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleKeyBinding;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleText;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class MultilineLabel
extends JComponent
implements Accessible {
    private String text;
    private int mnemonicIndex = -1;
    private Font font;
    private Font underlineFont;
    private FontMetrics fontMetrics;
    private Dimension fontSize;
    private int align = 2;
    private boolean transparent;
    private ArrayList<Line> lines = new ArrayList();

    private static String[] split(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        while (string.length() > 0) {
            int n2 = string.indexOf("\r\n");
            int n3 = string.indexOf(10);
            if (n2 >= 0) {
                if (n3 >= 0) {
                    if (n2 < n3) {
                        arrayList.add(string.substring(0, n2));
                        arrayList.add("\r\n");
                        string = string.substring(n2 + 2);
                        continue;
                    }
                    arrayList.add(string.substring(0, n3));
                    arrayList.add("\n");
                    string = string.substring(n3 + 1);
                    continue;
                }
                arrayList.add(string.substring(0, n2));
                arrayList.add("\r\n");
                string = string.substring(n2 + 2);
                continue;
            }
            if (n3 >= 0) {
                arrayList.add(string.substring(0, n3));
                arrayList.add("\n");
                string = string.substring(n3 + 1);
                continue;
            }
            arrayList.add(string);
            break;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void buildLines() {
        ArrayList<Line> arrayList = new ArrayList<Line>();
        if (this.text != null && this.text.length() > 0) {
            int n2 = this.getSize().width;
            int n3 = this.mnemonicIndex;
            int n4 = 0;
            String string = "";
            block0: for (String string2 : MultilineLabel.split(this.text)) {
                if (string2.equals("\r\n") || string2.equals("\n")) {
                    n3 -= string2.length();
                    continue;
                }
                while (true) {
                    int n5;
                    int n6 = -1;
                    int n7 = string2.length();
                    string = string2;
                    while ((n5 = this.fontMetrics.stringWidth(string)) > n2 && (n6 = string2.lastIndexOf(32, n7 - 1)) >= 0) {
                        for (n7 = n6; n7 > 0 && string2.charAt(n7 - 1) == ' '; --n7) {
                        }
                        string = string2.substring(0, n7);
                    }
                    int n8 = -1;
                    if (n3 >= n4 && n3 < n4 + string.length()) {
                        n8 = n3 - n4;
                    }
                    arrayList.add(new Line(string, n5, n8));
                    n4 += string.length();
                    if (n7 >= string2.length() - 1) continue block0;
                    if (n3 > n4) {
                        n3 -= n7 + 1 - string.length();
                    }
                    string2 = string2.substring(n7 + 1);
                }
            }
        }
        this.setLines(arrayList);
    }

    public void setText(String string) {
        this.text = string;
        this.buildLines();
        this.repaint();
    }

    public void setMnemonicIndex(int n2) {
        this.mnemonicIndex = n2;
        this.buildLines();
        this.repaint();
    }

    public void setTextAlignment(int n2) {
        this.align = n2;
        this.repaint();
    }

    public void setTransparent(boolean bl) {
        this.transparent = bl;
        this.repaint();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.setFontAttrs(font);
        this.buildLines();
        this.repaint();
    }

    private void setFontAttrs(Font font) {
        this.font = font;
        HashMap<TextAttribute, Integer> hashMap = new HashMap<TextAttribute, Integer>();
        hashMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
        this.underlineFont = this.font.deriveFont(hashMap);
        this.fontMetrics = this.getFontMetrics(font);
        this.fontSize = new Dimension(Math.round((float)this.fontMetrics.stringWidth("0123456789") / 10.0f), this.fontMetrics.getHeight());
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.font == null) {
            this.setFontAttrs(this.getFont());
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Map map = (Map)toolkit.getDesktopProperty("awt.font.desktophints");
        if (map != null) {
            graphics2D.addRenderingHints(map);
        }
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        if (!this.transparent) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, n2, n3);
        }
        if (this.text != null && this.text.length() > 0) {
            Line[] lineArray;
            int n4 = this.fontMetrics.getAscent();
            graphics.setColor(this.getForeground());
            graphics.setFont(this.font);
            for (Line line : lineArray = this.getLines()) {
                int n5 = 0;
                int n6 = line.width;
                switch (this.align) {
                    default: {
                        break;
                    }
                    case 0: {
                        int n7 = n2 - n6;
                        if (n7 <= 0) break;
                        n5 += n7 / 2;
                        break;
                    }
                    case 4: {
                        int n7 = n2 - n6;
                        if (n7 <= 0) break;
                        n5 += n7;
                    }
                }
                String string = line.text;
                int n8 = line.uIndex;
                if (n8 >= 0) {
                    String string2;
                    if (n8 > 0) {
                        string2 = string.substring(0, n8);
                        graphics.drawString(string2, n5, n4);
                        n5 += this.fontMetrics.stringWidth(string2);
                    }
                    graphics.setFont(this.underlineFont);
                    string2 = "" + string.charAt(n8);
                    graphics.drawString(string2, n5, n4);
                    graphics.setFont(this.font);
                    n5 += this.fontMetrics.stringWidth(string2);
                    if (n8 < string.length() - 1) {
                        String string3 = string.substring(n8 + 1);
                        graphics.drawString(string3, n5, n4);
                        n5 += this.fontMetrics.stringWidth(string3);
                    }
                } else {
                    graphics.drawString(string, n5, n4);
                }
                n5 += n6;
                n4 += this.fontSize.height;
            }
        }
    }

    @Override
    public void setBounds(int n2, int n3, int n4, int n5) {
        Dimension dimension = this.getSize();
        super.setBounds(n2, n3, n4, n5);
        if (dimension.width != n4 || dimension.height != n5) {
            this.buildLines();
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Line[] getLines() {
        ArrayList<Line> arrayList = this.lines;
        synchronized (arrayList) {
            return this.lines.toArray(new Line[this.lines.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLines(ArrayList<Line> arrayList) {
        ArrayList<Line> arrayList2 = this.lines;
        synchronized (arrayList2) {
            this.lines.clear();
            this.lines.addAll(arrayList);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.fontMetrics != null && this.text != null) {
            return new Dimension(this.fontMetrics.stringWidth(this.text), this.fontMetrics.getHeight());
        }
        return super.getPreferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getDisplayedMnemonic() {
        ArrayList<Line> arrayList = this.lines;
        synchronized (arrayList) {
            for (Line line : this.lines) {
                if (line.uIndex < 0 || line.text == null || line.uIndex >= line.text.length()) continue;
                return line.text.charAt(line.uIndex);
            }
        }
        return -1;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleMultilineLabel();
        }
        return this.accessibleContext;
    }

    private static class Line {
        final String text;
        final int width;
        final int uIndex;

        Line(String string, int n2, int n3) {
            this.text = string;
            this.width = n2;
            this.uIndex = n3;
        }
    }

    private class AccessibleMultilineLabel
    extends JComponent.AccessibleJComponent {
        private AccessibleMultilineLabel() {
            super(MultilineLabel.this);
        }

        @Override
        public String getAccessibleName() {
            String string = this.accessibleName;
            if (string == null) {
                string = (String)MultilineLabel.this.getClientProperty("AccessibleName");
            }
            if (string == null) {
                string = MultilineLabel.this.text;
            }
            if (string == null) {
                string = super.getAccessibleName();
            }
            return string;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }

        @Override
        public AccessibleIcon[] getAccessibleIcon() {
            return null;
        }

        @Override
        public AccessibleText getAccessibleText() {
            return null;
        }

        @Override
        public String getToolTipText() {
            return MultilineLabel.this.getToolTipText();
        }

        @Override
        public String getTitledBorderText() {
            return null;
        }

        @Override
        public AccessibleKeyBinding getAccessibleKeyBinding() {
            int n2 = MultilineLabel.this.getDisplayedMnemonic();
            if (n2 == 0) {
                return null;
            }
            return new MultilineLabelKeyBinding(n2);
        }

        class MultilineLabelKeyBinding
        implements AccessibleKeyBinding {
            int mnemonic;

            MultilineLabelKeyBinding(int n2) {
                this.mnemonic = n2;
            }

            @Override
            public int getAccessibleKeyBindingCount() {
                return 1;
            }

            @Override
            public Object getAccessibleKeyBinding(int n2) {
                if (n2 != 0) {
                    throw new IllegalArgumentException();
                }
                return KeyStroke.getKeyStroke(this.mnemonic, 0);
            }
        }
    }
}

