/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.client.swing.DoubleIcon;
import com.iscobol.gui.client.swing.PicobolMenuElement;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;

public class PicobolMenuItem
extends JMenuItem
implements PicobolMenuElement {
    private static final long serialVersionUID = 1L;
    private static final Icon checkIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(PicobolMenuItem.class.getResource("checkmenuitem.gif")));
    private JLabel rightLabel;
    private boolean checked;
    private Icon disabledCheckIcon;
    private Icon icon;
    private Icon disabledIcon;

    public PicobolMenuItem() {
        this.setLayout(new BorderLayout());
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        if (this.rightLabel != null) {
            this.remove(this.rightLabel);
            this.rightLabel = null;
            this.doLayout();
        }
    }

    @Override
    public void fireActionPerformed(ActionEvent actionEvent) {
        super.fireActionPerformed(actionEvent);
    }

    public void setText(String string, String string2) {
        FontMetrics fontMetrics;
        if (this.rightLabel != null) {
            this.remove(this.rightLabel);
        }
        String string3 = string;
        int n2 = string2.length();
        for (int i2 = 0; i2 <= n2; ++i2) {
            string3 = string3 + " ";
        }
        super.setText(string3);
        string2 = "         " + string2 + "      ";
        this.rightLabel = new JLabel(string2, 4);
        this.add((Component)this.rightLabel, "East");
        if (this.getFont() != null && (fontMetrics = this.getFontMetrics(this.getFont())) != null) {
            int n3 = fontMetrics.stringWidth(string3) + fontMetrics.stringWidth(string2);
            if (this.getPreferredSize().width < n3 + 10) {
                this.setPreferredSize(new Dimension(n3 + 10, this.getPreferredSize().height));
            } else if (this.getPreferredSize().width < n3 + this.rightLabel.getPreferredSize().width) {
                this.setPreferredSize(new Dimension(n3 + this.rightLabel.getPreferredSize().width, this.getPreferredSize().height));
            }
        }
        this.doLayout();
    }

    private Icon getDisabledCheckIcon() {
        if (this.disabledCheckIcon == null) {
            this.disabledCheckIcon = this.getDisabledIcon(checkIcon);
        }
        return this.disabledCheckIcon;
    }

    private Icon getDisabledIcon(Icon icon) {
        LookAndFeel lookAndFeel;
        if (icon != null && (lookAndFeel = UIManager.getLookAndFeel()) != null) {
            return lookAndFeel.getDisabledIcon(this, icon);
        }
        return icon;
    }

    private void setDoubleIcon() {
        super.setIcon(new DoubleIcon(this.icon, checkIcon, 4));
        super.setDisabledIcon(new DoubleIcon(this.disabledIcon, this.getDisabledCheckIcon(), 4));
    }

    private void setCheckIcon() {
        super.setIcon(checkIcon);
        super.setDisabledIcon(this.getDisabledCheckIcon());
    }

    private void setNormalIcon() {
        super.setIcon(this.icon);
        super.setDisabledIcon(this.disabledIcon);
    }

    private void unsetIcon() {
        super.setIcon(null);
        super.setDisabledIcon(null);
    }

    private void updateIcon() {
        if (this.icon != null) {
            if (this.checked) {
                this.setDoubleIcon();
            } else {
                this.setNormalIcon();
            }
        } else if (this.checked) {
            this.setCheckIcon();
        } else {
            this.unsetIcon();
        }
    }

    public void setChecked(boolean bl) {
        this.checked = bl;
        this.updateIcon();
    }

    public boolean isChecked() {
        return this.checked;
    }

    @Override
    public void setIcon(Icon icon) {
        this.icon = icon;
        this.disabledIcon = this.icon != null ? this.getDisabledIcon(this.icon) : null;
        this.updateIcon();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.rightLabel != null) {
            this.rightLabel.setEnabled(bl);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.rightLabel != null) {
            this.rightLabel.setFont(font);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.rightLabel != null) {
            this.rightLabel.setForeground(color);
        }
    }

    @Override
    public void processEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (keyEvent.getKeyCode() == 10 && keyEvent.getID() == 401) {
            MenuSelectionManager.defaultManager().clearSelectedPath();
            this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
        }
    }
}

