/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.swing.BaseRemoteObject;
import com.iscobol.gui.client.swing.EditableTextField;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteMenu;
import com.iscobol.rts.Factory;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class PopupListener
extends MouseAdapter {
    private JPopupMenu defaultPopup;
    private JMenuItem undo;
    private JMenuItem redo;
    private JMenuItem cut;
    private JMenuItem copy;
    private JMenuItem paste;
    private JMenuItem delete;
    private JMenuItem selectAll;
    private RemoteMenu popup;
    private BaseRemoteObject invoker;
    private EditableTextField textField;

    public PopupListener(BaseRemoteObject baseRemoteObject, RemoteMenu remoteMenu) {
        this.popup = remoteMenu;
        this.invoker = baseRemoteObject;
    }

    public PopupListener(EditableTextField editableTextField) {
        this.textField = editableTextField;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    public void maybeShowPopup(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent, false);
    }

    public void maybeShowPopup(MouseEvent mouseEvent, boolean bl) {
        if (mouseEvent.isPopupTrigger() || bl) {
            boolean bl2 = true;
            Component component = (Component)mouseEvent.getSource();
            if (component != null) {
                bl2 = component.isEnabled();
            }
            if (!bl2) {
                return;
            }
            if (this.popup != null) {
                int n2 = mouseEvent.getX();
                int n3 = mouseEvent.getY();
                if (this.invoker instanceof RemoteBaseGUIControl) {
                    Point point = ((RemoteBaseGUIControl)this.invoker).getReferencedPopupLocation(mouseEvent);
                    n2 = (int)point.getX();
                    n3 = (int)point.getY();
                }
                this.popup.firePopupMenuEvents(this.invoker, n2, n3);
            } else {
                this.getDefaultPopup().show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private JPopupMenu getDefaultPopup() {
        if (this.defaultPopup == null) {
            this.defaultPopup = new JPopupMenu();
            this.undo = new JMenuItem(Factory.getSysMsg("undo"));
            this.undo.addActionListener(actionEvent -> this.textField.undo());
            this.defaultPopup.add(this.undo);
            this.redo = new JMenuItem(Factory.getSysMsg("redo"));
            this.redo.addActionListener(actionEvent -> this.textField.redo());
            this.defaultPopup.add(this.redo);
            this.defaultPopup.addSeparator();
            this.cut = new JMenuItem(Factory.getSysMsg("cut"));
            this.cut.addActionListener(actionEvent -> this.textField.cut());
            this.defaultPopup.add(this.cut);
            this.copy = new JMenuItem(Factory.getSysMsg("copy"));
            this.copy.addActionListener(actionEvent -> this.textField.copy());
            this.defaultPopup.add(this.copy);
            this.paste = new JMenuItem(Factory.getSysMsg("paste"));
            this.paste.addActionListener(actionEvent -> this.textField.paste());
            this.defaultPopup.add(this.paste);
            this.delete = new JMenuItem(Factory.getSysMsg("delete"));
            this.delete.addActionListener(actionEvent -> this.textField.replaceSelection(""));
            this.defaultPopup.add(this.delete);
            this.defaultPopup.addSeparator();
            this.selectAll = new JMenuItem(Factory.getSysMsg("selectall"));
            this.selectAll.addActionListener(actionEvent -> SwingUtilities.invokeLater(() -> this.textField.selectAll()));
            this.defaultPopup.add(this.selectAll);
        }
        int n2 = this.textField.getText().length();
        boolean bl = this.textField.hasSelection();
        boolean bl2 = this.textField.isEditable();
        this.undo.setEnabled(this.textField.canUndo() && bl2);
        this.redo.setEnabled(this.textField.canRedo() && bl2);
        this.cut.setEnabled(bl && bl2);
        this.copy.setEnabled(bl);
        this.paste.setEnabled(ScreenUtility.canPaste(this.textField.getClass()) && bl2);
        this.delete.setEnabled(bl && bl2);
        this.selectAll.setEnabled(n2 > 0);
        return this.defaultPopup;
    }

    public boolean isDefaultPopupVisible() {
        return this.defaultPopup != null && this.defaultPopup.isVisible();
    }

    public JPopupMenu getPopupMenu() {
        return this.popup != null ? this.popup.menuPopup : this.getDefaultPopup();
    }
}

