/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.ColorCmp;
import com.iscobol.gui.ParamElementSize;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.client.IscobolLayout;
import com.iscobol.gui.client.swing.Bar;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.PicobolBar;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;

public class RemoteBar
extends RemoteBaseGUIControl {
    public static final String WIDTH = "WIDTH";
    public static final String COLORS = "COLORS";
    public static final String COLORS_RGB = "COLORS-RGB";
    public static final String SHADING = "SHADING";
    public static final String POSITION_SHIFT = "POSITION-SHIFT";
    public static final String LEADING_SHIFT = "LEADING-SHIFT";
    public static final String TRAILING_SHIFT = "TRAILING-SHIFT";
    private int propWidth = 1;
    private int positionShift = 0;
    private Color[] colors = new Color[0];
    private int[] shading = new int[0];
    private int[] leadingShift = new int[0];
    private int[] trailingShift = new int[0];
    private int style = -1;

    public RemoteBar(GuiFactoryImpl guiFactoryImpl) {
        super(guiFactoryImpl);
    }

    @Override
    public float getDefaultWidth() {
        return 0.0f;
    }

    @Override
    public float getDefaultHeight() {
        return 0.0f;
    }

    @Override
    public void initialize() {
        if (this.getComponent() != null) {
            return;
        }
        this.setComponent(new PicobolBar());
        super.intInitialize();
        this.setPropWidth(this.propWidth);
        this.intSetStyle(this.style);
        this.intSetting(true);
    }

    @Override
    public int getGUIControlHeight(float f2) {
        int n2 = (int)((float)this.font.getHeight() * f2);
        return n2;
    }

    @Override
    public int getGUIControlWidth(float f2) {
        int n2 = (int)((float)this.font.getWidth() * f2);
        return n2;
    }

    @Override
    public String getValue() {
        return null;
    }

    public void getAllData() {
    }

    private void addLeadingShift(int n2) {
        if (this.leadingShift.length == 0) {
            this.leadingShift = new int[]{n2};
        } else {
            int n3 = this.leadingShift.length;
            int[] nArray = new int[n3 + 1];
            System.arraycopy(this.leadingShift, 0, nArray, 0, n3);
            this.leadingShift = nArray;
            this.leadingShift[n3] = n2;
        }
    }

    private void addTrailingShift(int n2) {
        if (this.trailingShift.length == 0) {
            this.trailingShift = new int[]{n2};
        } else {
            int n3 = this.trailingShift.length;
            int[] nArray = new int[n3 + 1];
            System.arraycopy(this.trailingShift, 0, nArray, 0, n3);
            this.trailingShift = nArray;
            this.trailingShift[n3] = n2;
        }
    }

    private void addColor(Color color) {
        if (this.colors.length == 0) {
            this.colors = new Color[]{color};
        } else {
            int n2 = this.colors.length;
            Color[] colorArray = new Color[n2 + 1];
            System.arraycopy(this.colors, 0, colorArray, 0, n2);
            this.colors = colorArray;
            this.colors[n2] = color;
        }
    }

    private void addShading(int n2) {
        if (this.shading.length == 0) {
            this.shading = new int[]{n2};
        } else {
            int n3 = this.shading.length;
            int[] nArray = new int[n3 + 1];
            System.arraycopy(this.shading, 0, nArray, 0, n3);
            this.shading = nArray;
            this.shading[n3] = n2;
        }
    }

    private void addPositionShift(int n2) {
        this.positionShift = n2;
    }

    private void setPropWidth(int n2) {
        this.propWidth = n2;
    }

    private void setColors(int n2) {
        if (n2 < 0) {
            ColorCmp colorCmp = new ColorCmp(true);
            colorCmp.setForeRGB(n2);
            this.addColor(this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(colorCmp.getForeground(), false)));
        } else {
            this.addColor(this.gf.getRemotePalette().getDefaultColor(new ColorCmp(n2).getForeground()));
        }
    }

    private void setColorsRgb(int n2) {
        ColorCmp colorCmp = new ColorCmp(true);
        colorCmp.setForeRGB(n2);
        this.addColor(this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(colorCmp.getForeground(), false)));
    }

    @Override
    public String setProp(Integer n2, byte[] byArray, int n3) {
        int[] nArray = new int[byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            nArray[i2] = byArray[i2];
        }
        return this.setProp((int)n2, nArray);
    }

    @Override
    public String setProp(int n2, int[] nArray) {
        int n3 = 0;
        switch (n2) {
            case 40: {
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    this.setColors(nArray[n3]);
                }
                break;
            }
            case 41: {
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    this.setColorsRgb(nArray[n3]);
                }
                break;
            }
            case 218: {
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    this.addShading(nArray[n3]);
                }
                break;
            }
            case 137: {
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    this.addLeadingShift(nArray[n3]);
                }
                break;
            }
            case 241: {
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    this.addTrailingShift(nArray[n3]);
                }
                break;
            }
        }
        return "";
    }

    @Override
    public String setProp(Integer n2, String[] stringArray) {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.setProp(n2, stringArray[i2], stringArray[i2].length());
        }
        return "";
    }

    @Override
    public String setProp(Integer n2, String string, int n3) {
        int n4 = -1;
        boolean bl = false;
        try {
            n4 = (int)Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            bl = true;
        }
        if (!bl) {
            switch (n2) {
                case 250: {
                    this.setPropWidth(n4);
                    break;
                }
                case 40: {
                    this.setColors(n4);
                    break;
                }
                case 41: {
                    this.setColorsRgb(n4);
                    break;
                }
                case 218: {
                    this.addShading(n4);
                    break;
                }
                case 174: {
                    this.addPositionShift(n4);
                    break;
                }
                case 137: {
                    this.addLeadingShift(n4);
                    break;
                }
                case 241: {
                    this.addTrailingShift(n4);
                    break;
                }
                default: {
                    return super.setProp(n2, string, n3);
                }
            }
            return "";
        }
        return super.setProp(n2, string, n3);
    }

    private void intSetStyle(int n2) {
        PicobolBar picobolBar;
        this.style = n2;
        if (n2 != -1 && (picobolBar = (PicobolBar)this.getComponent()) != null) {
            picobolBar.setStyle(n2);
        }
    }

    @Override
    public void setStyle(int n2, boolean bl) {
        if (bl) {
            switch (n2) {
                case 2: {
                    this.intSetStyle(1);
                    break;
                }
                case 1: {
                    this.intSetStyle(2);
                    break;
                }
                case 3: {
                    this.intSetStyle(3);
                }
            }
        } else {
            this.intSetStyle(-1);
        }
    }

    private void intSetting(boolean bl) {
        PicobolBar picobolBar = (PicobolBar)this.getComponent();
        if (picobolBar != null) {
            int n2;
            int[] nArray = new int[Math.max(this.leadingShift.length, this.propWidth)];
            int[] nArray2 = new int[Math.max(this.trailingShift.length, this.propWidth)];
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            for (n2 = 0; n2 < this.leadingShift.length; ++n2) {
                if (this.leadingShift[n2] < n3) {
                    n3 = this.leadingShift[n2];
                }
                if (this.leadingShift[n2] <= n4) continue;
                n4 = this.leadingShift[n2];
            }
            for (n2 = 0; n2 < this.leadingShift.length; ++n2) {
                nArray[n2] = this.leadingShift[n2] - n3;
            }
            while (n2 < this.propWidth) {
                nArray[n2] = -n3;
                ++n2;
            }
            picobolBar.setLeadingShift(nArray);
            for (n2 = 0; n2 < this.trailingShift.length; ++n2) {
                if (this.trailingShift[n2] < n5) {
                    n5 = this.trailingShift[n2];
                }
                if (this.trailingShift[n2] <= n6) continue;
                n6 = this.trailingShift[n2];
            }
            for (n2 = 0; n2 < this.trailingShift.length; ++n2) {
                nArray2[n2] = n6 - this.trailingShift[n2];
            }
            while (n2 < this.propWidth) {
                nArray2[n2] = n6;
                ++n2;
            }
            picobolBar.setTrailingShift(nArray2);
            picobolBar.setShading(this.shading);
            picobolBar.setColors(this.colors);
            if (bl || picobolBar.getParent() == null || !(picobolBar.getParent().getLayout() instanceof IscobolLayout)) {
                n7 = this.height;
                if (n7 > 0 && n7 > this.width) {
                    picobolBar.setVertical();
                    picobolBar.setSize(this.propWidth, n7 + n6 - n3);
                    if (this.positionShift != 0) {
                        Point point = picobolBar.getLocation();
                        picobolBar.setLocation(point.x + this.positionShift, point.y);
                    }
                } else {
                    picobolBar.setHorizontal();
                    n7 = this.width;
                    picobolBar.setSize(n7 + n6 - n3, this.propWidth);
                    if (this.positionShift != 0) {
                        Point point = picobolBar.getLocation();
                        picobolBar.setLocation(point.x, point.y + this.positionShift);
                    }
                }
            }
            this.colors = new Color[0];
            this.shading = new int[0];
            this.leadingShift = new int[0];
            this.trailingShift = new int[0];
        }
    }

    @Override
    public void displayProp() {
        if (this.getComponent() != null) {
            this.intSetting(false);
        }
    }

    @Override
    public boolean isInputField() {
        return false;
    }

    @Override
    public boolean isSelfAct() {
        return false;
    }

    @Override
    protected void intFocusGained(boolean bl) {
    }

    @Override
    public void setBorder(boolean bl) {
    }

    @Override
    public void setElementAt(int[] nArray) {
    }

    @Override
    public void setImage(int n2, int n3, int n4, int n5) {
    }

    @Override
    public void setRowsCols(float f2, float f3) {
    }

    @Override
    public String setValue(String string) {
        return string;
    }

    @Override
    public String getTitle() {
        return "";
    }

    @Override
    public void setTitle(String string) {
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    public void handleResponse(int n2, int n3) {
    }

    @Override
    public void handleResponse(int n2, RemoteRecordAccept remoteRecordAccept) {
    }

    @Override
    public void setCols(float f2) {
    }

    @Override
    public void setRows(float f2) {
    }

    @Override
    public Rectangle getRealBounds() {
        Rectangle rectangle = super.getRealBounds();
        if (this.height > 0) {
            rectangle.width = this.propWidth;
        } else {
            rectangle.height = this.propWidth;
        }
        return rectangle;
    }

    @Override
    protected float paramgetDefaultWidth(ParamElementSize paramElementSize, int n2) {
        if (paramElementSize.sizes > 0.0f) {
            return paramElementSize.sizes;
        }
        return super.paramgetDefaultWidth(paramElementSize, n2);
    }

    @Override
    public Rectangle getBounds() {
        Rectangle rectangle = super.getBounds();
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        rectangle.width = this.propWidth;
        return rectangle;
    }

    @Override
    public String getType() {
        if (this.guiComponent == null || ((Bar)((Object)this.guiComponent)).isHorizontal()) {
            return "hbar";
        }
        return "vbar";
    }

    @Override
    protected String getDefaultLayoutData(IscobolLayout iscobolLayout) {
        if (iscobolLayout.hasDefaultLayoutData(this.getType()) || !iscobolLayout.hasDefaultLayoutData("bar")) {
            return iscobolLayout.getDefaultLayoutDataString(this.getType());
        }
        return iscobolLayout.getDefaultLayoutDataString("bar");
    }

    @Override
    public void adjustBounds(Rectangle rectangle) {
        rectangle.width = this.propWidth;
    }
}

