/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.ColorCmp;
import com.iscobol.gui.ParamElementSize;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.client.swing.CobolEventCouple;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.PicobolCheckbox;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import com.iscobol.gui.client.swing.RemoteTab;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;

public class RemoteCheckBox
extends RemoteBaseGUIControl {
    private static final float DEFAULT_WIDTH_INSETS = 17.0f;
    private static final float MINIMUM_HEIGHT = 15.0f;
    private static final String DEFAULT_OFF_VALUE = "0";
    private static final String DEFAULT_ON_VALUE = "1";
    private String title;
    private boolean state;
    private boolean selfAct;
    private boolean transparent;
    private boolean leftText;
    private int leftTextAlign;
    private float rows;
    private int bitmapNumber;
    private int bitmapDisabled;
    private int bitmapDisabledSelected;
    private int bitmapPressed;
    private int bitmapSelected;
    private int bitmapRollover;
    private int bitmapRolloverSelected;
    private int bitmapWidth;
    private boolean flat;
    private boolean multiline;
    private boolean vtop;
    private int titlePosition;
    private ActionListener al;
    private int imageId = -1;
    private Image image;
    private Integer disabledColor;
    private Integer disabledBackgroundColor;
    private Integer disabledForegroundColor;
    private boolean disabledBackgroundRgb;
    private boolean disabledForegroundRgb;
    private Integer rolloverColor;
    private Integer rolloverBackgroundColor;
    private Integer rolloverForegroundColor;
    private boolean rolloverBackgroundRgb;
    private boolean rolloverForegroundRgb;
    private String checkOffValue;
    private String checkOffValueDefault = " ";
    private String checkOnValue;
    private String valuealpha;
    private int bitmapScale;
    private final boolean iconsScaling;
    private final boolean m25647;

    public RemoteCheckBox(GuiFactoryImpl guiFactoryImpl) {
        super(guiFactoryImpl);
        this.m25647 = guiFactoryImpl.getCsProperty().get("iscobol.m25647", false);
        this.iconsScaling = guiFactoryImpl.getCsProperty().get("iscobol.gui.icons_scaling", false);
    }

    @Override
    public void displayProp() {
    }

    @Override
    public float getDefaultWidth() {
        if (this.bitmapStyle) {
            return 16.0f;
        }
        if (this.title != null && this.title.length() > 0) {
            return (float)(this.font.computeScreenWidth(this.title) / this.font.computeScreenWidth(DEFAULT_OFF_VALUE)) + 1.2f;
        }
        return 0.0f;
    }

    @Override
    public float getDefaultHeight() {
        if (this.bitmapStyle) {
            return 15.0f;
        }
        return 1.0f;
    }

    @Override
    public int getGUIControlHeight(float f2) {
        int n2 = this.bitmapStyle ? (int)f2 : (int)((float)this.font.getHeight() * f2);
        if ((float)n2 < 15.0f) {
            n2 = 15;
        }
        return n2;
    }

    @Override
    public int getGUIControlWidth(float f2) {
        int n2 = 0;
        if (this.bitmapStyle) {
            n2 = (int)f2;
        } else if (f2 > 0.0f) {
            n2 = (int)((float)this.font.getWidth() * f2 + 17.0f);
        }
        return n2;
    }

    @Override
    public float getSizes() {
        float f2 = super.getSizes();
        if (f2 == 0.0f) {
            Dimension dimension = this.guiComponent.getPreferredSize();
            f2 = this.bitmapStyle ? (float)dimension.width : ((float)dimension.width - 17.0f) / (float)this.font.getWidth();
        }
        return f2;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getValue() {
        boolean bl = this.getState();
        if (this.checkOffValue != null || this.checkOnValue != null) {
            if (bl) {
                return this.checkOnValue;
            }
            return this.checkOffValue != null ? this.checkOffValue : this.checkOffValueDefault;
        }
        if (bl) {
            return DEFAULT_ON_VALUE;
        }
        return DEFAULT_OFF_VALUE;
    }

    @Override
    public void initialize() {
        Object object;
        if (this.guiComponent != null) {
            return;
        }
        this.guiComponent = new PicobolCheckbox();
        PicobolCheckbox picobolCheckbox = (PicobolCheckbox)this.guiComponent;
        picobolCheckbox.addOutAcceptListener(this);
        super.intInitialize();
        picobolCheckbox.setMultiline(this.multiline || this.m25647 && this.rows >= 2.0f);
        picobolCheckbox.setHasBitmap(this.bitmapStyle);
        if (this.image == null && this.imageId >= 0) {
            this.setImage(1, 1, this.imageId, 1);
        }
        if (!this.bitmapStyle && this.leftText) {
            picobolCheckbox.setLeftText(this.leftText);
        }
        if (this.titlePosition > 0) {
            picobolCheckbox.setTitlePosition(this.titlePosition);
        }
        picobolCheckbox.setLeftTextAlignment(this.leftTextAlign);
        picobolCheckbox.setVTop(this.vtop);
        this.setTitle(this.title);
        picobolCheckbox.setBitmapWidth(this.bitmapWidth);
        picobolCheckbox.setBitmapNumber(this.bitmapNumber);
        picobolCheckbox.setBitmapDisabled(this.bitmapDisabled);
        picobolCheckbox.setBitmapDisabledSelected(this.bitmapDisabledSelected);
        picobolCheckbox.setBitmapRollover(this.bitmapRollover);
        picobolCheckbox.setBitmapPressed(this.bitmapPressed);
        picobolCheckbox.setBitmapSelected(this.bitmapSelected);
        picobolCheckbox.setBitmapRolloverSelected(this.bitmapRolloverSelected);
        if (this.disabledColor != null) {
            object = this.getColors(this.disabledColor);
            picobolCheckbox.setDisabledBackground(object[0]);
            picobolCheckbox.setDisabledForeground(object[1]);
        } else {
            if (this.disabledBackgroundColor != null) {
                object = this.getBackgroundColor(this.disabledBackgroundColor, this.disabledBackgroundRgb);
                picobolCheckbox.setDisabledBackground((Color)object);
            }
            if (this.disabledForegroundColor != null) {
                object = this.getForegroundColor(this.disabledForegroundColor, this.disabledForegroundRgb);
                picobolCheckbox.setDisabledForeground((Color)object);
            }
        }
        if (this.rolloverColor != null) {
            object = this.getColors(this.rolloverColor);
            picobolCheckbox.setRolloverBackground(object[0]);
            picobolCheckbox.setRolloverForeground(object[1]);
        } else {
            if (this.rolloverBackgroundColor != null) {
                object = this.getBackgroundColor(this.rolloverBackgroundColor, this.rolloverBackgroundRgb);
                picobolCheckbox.setRolloverBackground((Color)object);
            }
            if (this.rolloverForegroundColor != null) {
                object = this.getForegroundColor(this.rolloverForegroundColor, this.rolloverForegroundRgb);
                picobolCheckbox.setRolloverForeground((Color)object);
            }
        }
        picobolCheckbox.setBitmapScale(this.bitmapScale);
        this.guiComponent.setSelfAct(this.selfAct);
        this.setState(this.state);
        picobolCheckbox.setFlat(this.flat);
        picobolCheckbox.setScaleDefaultIcon(this.iconsScaling);
        picobolCheckbox.setOpaque(!this.transparent);
        this.al = actionEvent -> {
            if (this.skipNextEvent) {
                this.setState(!picobolCheckbox.isSelected());
            } else {
                this.responseOnAction(actionEvent);
            }
            this.skipNextEvent = false;
        };
        picobolCheckbox.addActionListener(this.al);
        this.guiComponent.addKeyListener(this);
        this.usedtorender = true;
    }

    void responseOnAction(ActionEvent actionEvent) {
        if ((RemoteDisplayWindow)this.parentWindow != null) {
            ((RemoteDisplayWindow)this.parentWindow).stopTimer();
        }
        CobolEventCouple cobolEventCouple = new CobolEventCouple(this, new RemoteRecordAccept(16, 17, actionEvent.getID()));
        if (this.hasClickOverrideFocusChange() || (!this.getActiveAccept() || this.isProtectedField()) && !this.isSelfAct()) {
            if (this.hasClickOverrideFocusChange()) {
                cobolEventCouple.getRemoteRecordAccept().setResponse(true);
                cobolEventCouple.getRemoteRecordAccept().setWait(true);
            }
            if (this.hasClickOverrideFocusChange() && this.isSelfAct() && !this.getActiveAccept()) {
                this.setState(((PicobolCheckbox)this.guiComponent).isSelected());
            } else {
                this.setState(!((PicobolCheckbox)this.guiComponent).isSelected());
            }
        } else {
            this.state = ((PicobolCheckbox)this.guiComponent).isSelected();
        }
        this.pushEvent(cobolEventCouple, 4);
    }

    void setState(boolean bl) {
        this.state = bl;
        if (this.guiComponent != null && ((PicobolCheckbox)this.guiComponent).isSelected() != bl) {
            ((PicobolCheckbox)this.guiComponent).setSelected(bl);
        }
    }

    @Override
    public String getProp(int n2) {
        PicobolCheckbox picobolCheckbox = (PicobolCheckbox)this.guiComponent;
        switch (n2) {
            case 410: {
                if (!this.disabledBackgroundRgb && this.disabledBackgroundColor != null) {
                    return this.disabledBackgroundColor.toString();
                }
                if (picobolCheckbox == null || picobolCheckbox.getDisabledBackground() == null) break;
                ColorCmp colorCmp = new ColorCmp(true);
                colorCmp.setBackRGB(picobolCheckbox.getDisabledBackground().getRGB());
                Color color = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(colorCmp.getBackground(), false));
                return Integer.toString(color != null ? color.getRGB() : 0);
            }
            case 412: {
                if (!this.disabledForegroundRgb && this.disabledForegroundColor != null) {
                    return this.disabledForegroundColor.toString();
                }
                if (picobolCheckbox == null || picobolCheckbox.getDisabledForeground() == null) break;
                ColorCmp colorCmp = new ColorCmp(true);
                colorCmp.setForeRGB(picobolCheckbox.getDisabledForeground().getRGB());
                Color color = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(colorCmp.getForeground(), false));
                return Integer.toString(color != null ? color.getRGB() : 0);
            }
            case 409: {
                if (this.disabledColor != null) {
                    return this.disabledColor.toString();
                }
                return DEFAULT_OFF_VALUE;
            }
            case 415: {
                if (!this.rolloverBackgroundRgb && this.rolloverBackgroundColor != null) {
                    return this.rolloverBackgroundColor.toString();
                }
                if (picobolCheckbox == null || picobolCheckbox.getRolloverBackground() == null) break;
                ColorCmp colorCmp = new ColorCmp(true);
                colorCmp.setBackRGB(picobolCheckbox.getRolloverBackground().getRGB());
                Color color = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(colorCmp.getBackground(), false));
                return Integer.toString(color != null ? color.getRGB() : 0);
            }
            case 417: {
                if (!this.rolloverForegroundRgb && this.rolloverForegroundColor != null) {
                    return this.rolloverForegroundColor.toString();
                }
                if (picobolCheckbox == null || picobolCheckbox.getRolloverForeground() == null) break;
                ColorCmp colorCmp = new ColorCmp(true);
                colorCmp.setForeRGB(picobolCheckbox.getRolloverForeground().getRGB());
                Color color = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(colorCmp.getForeground(), false));
                return Integer.toString(color != null ? color.getRGB() : 0);
            }
            case 414: {
                if (this.rolloverColor != null) {
                    return this.rolloverColor.toString();
                }
                return DEFAULT_OFF_VALUE;
            }
        }
        return super.getProp(n2);
    }

    boolean getState() {
        return this.state;
    }

    @Override
    protected void intFocusGained(boolean bl) {
    }

    @Override
    public boolean isSelfAct() {
        if (this.guiComponent != null) {
            return this.guiComponent.getSelfAct();
        }
        return this.selfAct;
    }

    @Override
    public void setBorder(boolean bl) {
    }

    @Override
    public void setElementAt(int[] nArray) {
    }

    @Override
    public void setImage(int n2, int n3, int n4, int n5) {
        Rectangle rectangle = this.getBounds();
        n2 = rectangle.width;
        n3 = rectangle.height;
        this.imageId = n4;
        if (n2 == 0 || !this.bitmapStyle) {
            return;
        }
        this.image = this.getLocalImage(this.imageId);
        if (this.bitmapWidth == 0) {
            this.bitmapWidth = n2;
        }
        PicobolCheckbox picobolCheckbox = (PicobolCheckbox)this.guiComponent;
        if (this.guiComponent != null) {
            picobolCheckbox.setImage(this.image, this.bitmapWidth, n3);
            if (this.image != null && this.title != null) {
                picobolCheckbox.setHasBitmap(this.bitmapStyle);
                picobolCheckbox.setTitle(this.title);
            }
        }
    }

    private void setBitmapNumber(int n2, PicobolCheckbox picobolCheckbox) {
        this.bitmapNumber = n2;
        if (picobolCheckbox != null) {
            picobolCheckbox.setBitmapNumber(this.bitmapNumber);
        }
    }

    private void setBitmapDisabled(int n2, PicobolCheckbox picobolCheckbox) {
        this.bitmapDisabled = n2;
        if (picobolCheckbox != null) {
            picobolCheckbox.setBitmapDisabled(this.bitmapDisabled);
        }
    }

    private void setBitmapDisabledSelected(int n2, PicobolCheckbox picobolCheckbox) {
        this.bitmapDisabledSelected = n2;
        if (picobolCheckbox != null) {
            picobolCheckbox.setBitmapDisabledSelected(this.bitmapDisabledSelected);
        }
    }

    private void setBitmapPressed(int n2, PicobolCheckbox picobolCheckbox) {
        this.bitmapPressed = n2;
        if (picobolCheckbox != null) {
            picobolCheckbox.setBitmapPressed(this.bitmapPressed);
        }
    }

    private void setBitmapRollover(int n2, PicobolCheckbox picobolCheckbox) {
        this.bitmapRollover = n2;
        if (picobolCheckbox != null) {
            picobolCheckbox.setBitmapRollover(this.bitmapRollover);
        }
    }

    private void setBitmapSelected(int n2, PicobolCheckbox picobolCheckbox) {
        this.bitmapSelected = n2;
        if (picobolCheckbox != null) {
            picobolCheckbox.setBitmapSelected(this.bitmapSelected);
        }
    }

    private void setBitmapRolloverSelected(int n2, PicobolCheckbox picobolCheckbox) {
        this.bitmapRolloverSelected = n2;
        if (picobolCheckbox != null) {
            picobolCheckbox.setBitmapRolloverSelected(this.bitmapRolloverSelected);
        }
    }

    private void setTitlePosition(int n2, PicobolCheckbox picobolCheckbox) {
        this.titlePosition = n2;
        if (picobolCheckbox != null) {
            picobolCheckbox.setTitlePosition(this.titlePosition);
        }
    }

    private void setBitmapWidth(int n2, PicobolCheckbox picobolCheckbox) {
        this.bitmapWidth = n2;
        if (picobolCheckbox != null) {
            picobolCheckbox.setBitmapWidth(this.bitmapWidth);
        }
    }

    @Override
    public String setProp(Integer n2, String string, int n3) {
        String string2 = DEFAULT_OFF_VALUE;
        int n4 = 0;
        boolean bl = false;
        try {
            n4 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            bl = true;
        }
        PicobolCheckbox picobolCheckbox = (PicobolCheckbox)this.guiComponent;
        boolean bl2 = false;
        switch (n2) {
            case 295: {
                if (bl) break;
                this.bitmapScale = n4;
                if (picobolCheckbox == null) break;
                picobolCheckbox.setBitmapScale(this.bitmapScale);
                break;
            }
            case 409: {
                if (bl) break;
                this.disabledColor = n4;
                if (picobolCheckbox != null) {
                    Color[] colorArray = this.getColors(n4);
                    picobolCheckbox.setDisabledBackground(colorArray[0]);
                    picobolCheckbox.setDisabledForeground(colorArray[1]);
                }
                string2 = DEFAULT_ON_VALUE;
                break;
            }
            case 411: {
                bl2 = true;
            }
            case 410: {
                if (bl) break;
                this.disabledBackgroundColor = n4;
                this.disabledBackgroundRgb = bl2;
                if (picobolCheckbox != null) {
                    Color color = this.getBackgroundColor(n4, bl2);
                    picobolCheckbox.setDisabledBackground(color);
                }
                string2 = DEFAULT_ON_VALUE;
                break;
            }
            case 413: {
                bl2 = true;
            }
            case 412: {
                if (bl) break;
                this.disabledForegroundColor = n4;
                this.disabledForegroundRgb = bl2;
                if (picobolCheckbox != null) {
                    Color color = this.getForegroundColor(n4, bl2);
                    picobolCheckbox.setDisabledForeground(color);
                }
                string2 = DEFAULT_ON_VALUE;
                break;
            }
            case 414: {
                if (bl) break;
                this.rolloverColor = n4;
                if (picobolCheckbox != null) {
                    Color[] colorArray = this.getColors(n4);
                    picobolCheckbox.setRolloverBackground(colorArray[0]);
                    picobolCheckbox.setRolloverForeground(colorArray[1]);
                }
                string2 = DEFAULT_ON_VALUE;
                break;
            }
            case 416: {
                bl2 = true;
            }
            case 415: {
                if (bl) break;
                this.rolloverBackgroundColor = n4;
                this.rolloverBackgroundRgb = bl2;
                if (picobolCheckbox != null) {
                    Color color = this.getBackgroundColor(n4, bl2);
                    picobolCheckbox.setRolloverBackground(color);
                }
                string2 = DEFAULT_ON_VALUE;
                break;
            }
            case 418: {
                bl2 = true;
            }
            case 417: {
                if (bl) break;
                this.rolloverForegroundColor = n4;
                this.rolloverForegroundRgb = bl2;
                if (picobolCheckbox != null) {
                    Color color = this.getForegroundColor(n4, bl2);
                    picobolCheckbox.setRolloverForeground(color);
                }
                string2 = DEFAULT_ON_VALUE;
                break;
            }
            case 320: {
                if (bl) break;
                this.leftTextAlign = n4;
                if (picobolCheckbox != null) {
                    picobolCheckbox.setLeftTextAlignment(this.leftTextAlign);
                }
                string2 = DEFAULT_ON_VALUE;
                break;
            }
            case 7: 
            case 12: {
                if (bl) break;
                this.setBitmapNumber(n4, picobolCheckbox);
                string2 = DEFAULT_ON_VALUE;
                break;
            }
            case 8: {
                if (bl) break;
                this.setBitmapDisabled(n4, picobolCheckbox);
                string2 = DEFAULT_ON_VALUE;
                break;
            }
            case 13: {
                if (bl) break;
                this.setBitmapPressed(n4, picobolCheckbox);
                string2 = DEFAULT_ON_VALUE;
                break;
            }
            case 14: {
                if (bl) break;
                this.setBitmapRollover(n4, picobolCheckbox);
                string2 = DEFAULT_ON_VALUE;
                break;
            }
            case 16: {
                if (bl) break;
                this.setBitmapSelected(n4, picobolCheckbox);
                string2 = DEFAULT_ON_VALUE;
                break;
            }
            case 15: {
                if (bl) break;
                this.setBitmapRolloverSelected(n4, picobolCheckbox);
                string2 = DEFAULT_ON_VALUE;
                break;
            }
            case 240: {
                if (bl) break;
                this.setTitlePosition(n4, picobolCheckbox);
                string2 = DEFAULT_ON_VALUE;
                break;
            }
            case 20: {
                if (bl) break;
                this.setBitmapWidth(n4, picobolCheckbox);
                string2 = DEFAULT_ON_VALUE;
                break;
            }
            case 294: {
                if (bl) break;
                this.setBitmapDisabledSelected(n4, picobolCheckbox);
                string2 = DEFAULT_ON_VALUE;
                break;
            }
            case 424: {
                this.checkOffValue = string;
                break;
            }
            case 425: {
                this.checkOnValue = string;
                break;
            }
            default: {
                return super.setProp(n2, string, n3);
            }
        }
        return string2;
    }

    @Override
    public void setRowsCols(float f2, float f3) {
        this.rows = f2;
    }

    @Override
    public void setStyle(int n2, boolean bl) {
        PicobolCheckbox picobolCheckbox = (PicobolCheckbox)this.guiComponent;
        if ((n2 & 0x10000) == 65536) {
            this.transparent = bl;
            if (this.guiComponent != null) {
                ((PicobolCheckbox)this.guiComponent).setOpaque(!this.transparent);
            }
        }
        if ((n2 & 0x400000) == 0x400000) {
            this.selfAct = bl;
            if (this.getComponent() != null) {
                this.getComponent().setSelfAct(this.selfAct);
            }
        }
        if ((n2 & 2) == 2) {
            this.leftText = bl;
            if (picobolCheckbox != null) {
                picobolCheckbox.setLeftText(this.leftText);
            }
        }
        if ((n2 & 0x200) == 512) {
            this.vtop = bl;
            if (picobolCheckbox != null) {
                picobolCheckbox.setVTop(this.vtop);
            }
        }
        if ((n2 & 0x400) == 1024) {
            this.multiline = bl;
            if (picobolCheckbox != null) {
                picobolCheckbox.setMultiline(this.multiline);
            }
        }
        if ((n2 & 0x800) == 2048) {
            this.flat = bl;
            if (picobolCheckbox != null) {
                picobolCheckbox.setFlat(bl);
            }
        }
        if ((n2 & 0x8000) == 32768) {
            this.bitmapStyle = bl;
            if (picobolCheckbox != null) {
                picobolCheckbox.setHasBitmap(this.bitmapStyle);
            }
        }
        if ((n2 & 0x1000) == 4096) {
            // empty if block
        }
        if ((n2 & 0x2000) == 8192) {
            // empty if block
        }
        if ((n2 & 0x4000) == 16384) {
            // empty if block
        }
    }

    @Override
    public void setTitle(String string) {
        this.title = string;
        if (this.guiComponent != null) {
            PicobolCheckbox picobolCheckbox = (PicobolCheckbox)this.guiComponent;
            if (string != null) {
                picobolCheckbox.setTitle(string);
                if (picobolCheckbox.getMnemonicChar() > '\u0000' && this.parentWindow != null) {
                    this.parentWindow.removeMnemonic(this);
                    this.parentWindow.addMnemonic(picobolCheckbox.getMnemonicChar(), this);
                }
            } else if (!this.bitmapStyle) {
                picobolCheckbox.setBoundsMinimized(this.x, this.y, this.width, this.height);
            }
        }
    }

    @Override
    public String setValue(String string) {
        int n2;
        block4: {
            n2 = -1;
            try {
                n2 = Integer.parseInt(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                this.valuealpha = string.trim();
                if (this.valuealpha == null || this.checkOffValue == null && this.checkOnValue == null) break block4;
                if (this.checkOffValue != null && this.valuealpha.equalsIgnoreCase(this.checkOffValue) || this.valuealpha.length() == 0) {
                    n2 = 0;
                }
                if (!this.valuealpha.equalsIgnoreCase(this.checkOnValue)) break block4;
                n2 = 1;
            }
        }
        if (n2 != -1) {
            this.setState(n2 != 0);
        }
        return string;
    }

    @Override
    public void destroy() {
        PicobolCheckbox picobolCheckbox = (PicobolCheckbox)this.guiComponent;
        if (picobolCheckbox != null) {
            picobolCheckbox.removeOutAcceptListener();
            picobolCheckbox.removeActionListener(this.al);
            picobolCheckbox.removeKeyListener(this);
            this.al = null;
        }
        super.destroy();
    }

    public void handleResponse(int n2, int n3) {
    }

    @Override
    public void handleResponse(int n2, RemoteRecordAccept remoteRecordAccept) {
        boolean bl = false;
        super.handleResponse(n2, remoteRecordAccept);
        RemoteBaseGUIControl remoteBaseGUIControl = this.getUponCtrl();
        if (remoteBaseGUIControl != null && remoteBaseGUIControl instanceof RemoteTab && ((RemoteTab)remoteBaseGUIControl).isRibbon()) {
            bl = true;
        }
        if (this.hasClickOverrideFocusChange() && (this.getActiveAccept() || bl) && (n2 == 0 || n2 == 1 || n2 == 2) && remoteRecordAccept.getEventType() == 17) {
            this.setState(!((PicobolCheckbox)this.guiComponent).isSelected());
        }
    }

    @Override
    public void setCols(float f2) {
    }

    @Override
    public void setRows(float f2) {
    }

    @Override
    public Rectangle getRealBounds() {
        Rectangle rectangle = this.guiComponent != null ? this.guiComponent.getBounds() : new Rectangle(this.x, this.y, this.width, this.height);
        return rectangle;
    }

    @Override
    public Rectangle getBounds() {
        Rectangle rectangle = this.getRealBounds();
        if (this.bitmapStyle) {
            if (!this.sizesInPixel) {
                rectangle.width -= 8;
            }
            if (!this.linesInPixel) {
                rectangle.height -= 7;
            }
        }
        return rectangle;
    }

    @Override
    public Rectangle getBoundsWithoutDefaultWidth() {
        Rectangle rectangle = this.getBounds();
        if (!this.bitmapStyle && rectangle != null && rectangle.width > 0) {
            rectangle.width = (int)((float)rectangle.width - 17.0f);
        }
        return rectangle;
    }

    @Override
    public boolean isInputField() {
        return true;
    }

    @Override
    protected void processMnemonic(char c2) {
        super.processMnemonic(c2);
        PicobolCheckbox picobolCheckbox = (PicobolCheckbox)this.guiComponent;
        if (picobolCheckbox != null) {
            picobolCheckbox.doClick(100);
        }
    }

    @Override
    protected float paramgetDefaultWidth(ParamElementSize paramElementSize, int n2) {
        String string = null;
        if (paramElementSize.sizes > 0.0f) {
            return paramElementSize.sizes;
        }
        if (!this.bitmapStyle) {
            if (paramElementSize.sizesInPixel || this.bitmapStyle && !paramElementSize.sizesInCells || paramElementSize.sizesInCells) {
                if (this.title != null) {
                    string = this.title;
                }
                if (string != null) {
                    if (this.font != null) {
                        return (float)(this.font.computeScreenWidth(string) / this.font.computeScreenWidth(DEFAULT_OFF_VALUE)) + 1.2f;
                    }
                    return this.title.length();
                }
            } else {
                return 0.0f;
            }
        }
        return super.paramgetDefaultWidth(paramElementSize, n2);
    }

    @Override
    public void setSize(int n2, int n3, boolean bl) {
        this.width = n2;
        this.height = n3;
        if (this.guiComponent != null && bl) {
            this.updateLayoutManager();
            this.guiComponent.setSize(this.width, this.height);
        }
    }

    @Override
    public String getType() {
        return "checkbox";
    }

    @Override
    public void startCellEditing() {
        ((PicobolCheckbox)this.guiComponent).setSelected(!((PicobolCheckbox)this.guiComponent).isSelected());
        this.setState(((PicobolCheckbox)this.guiComponent).isSelected());
        CobolEventCouple cobolEventCouple = new CobolEventCouple(this, new RemoteRecordAccept(16, 17, 1001));
        this.pushEvent(cobolEventCouple, 4);
    }

    @Override
    public RemoteBaseGUIControl renderClone() {
        return this.renderClone(false, null);
    }

    @Override
    public RemoteBaseGUIControl renderClone(boolean bl, Dimension dimension) {
        PicobolCheckbox picobolCheckbox = (PicobolCheckbox)this.guiComponent;
        picobolCheckbox.removeOutAcceptListener();
        picobolCheckbox.removeActionListener(this.al);
        picobolCheckbox.removeKeyListener(this);
        this.image = null;
        RemoteCheckBox remoteCheckBox = null;
        try {
            remoteCheckBox = (RemoteCheckBox)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        remoteCheckBox.setComponent(null);
        remoteCheckBox.initialize();
        return remoteCheckBox;
    }

    @Override
    public Dimension getRendererSize() {
        Dimension dimension = null;
        dimension = this.guiComponent != null ? this.guiComponent.getSize() : new Dimension(this.width, this.height);
        if (dimension.width == 0) {
            if (this.title != null && this.title.length() > 0) {
                dimension.width = this.getGUIControlWidth(this.title.length());
            }
            if (dimension.width == 0) {
                dimension.width = (int)this.getDefaultWidth();
            }
        }
        if (dimension.height == 0) {
            dimension.height = (int)this.getDefaultHeight();
        }
        if (!this.bitmapStyle) {
            if ((float)dimension.width < 17.0f) {
                dimension.width = 17;
            }
            if ((float)dimension.height < 15.0f) {
                dimension.height = 15;
            }
        }
        return dimension;
    }

    @Override
    protected boolean mustreceivepressed() {
        return true;
    }

    @Override
    public void adjustBounds(Rectangle rectangle) {
        if (this.bitmapStyle) {
            if (!this.sizesInPixel) {
                rectangle.width -= 8;
            }
            if (!this.linesInPixel) {
                rectangle.height -= 7;
            }
        }
    }

    @Override
    public String getCorrespondingValue(String string) {
        String string2 = string;
        if (string != null && string.length() > 0) {
            if (this.checkOffValue != null && string.equalsIgnoreCase(DEFAULT_OFF_VALUE) || string.trim().length() == 0) {
                string2 = this.checkOffValue;
            } else if (this.checkOnValue != null && string.equalsIgnoreCase(DEFAULT_ON_VALUE)) {
                string2 = this.checkOnValue;
            }
        }
        return string2;
    }

    @Override
    public JComponent getDragDropComponent() {
        return (PicobolCheckbox)this.guiComponent;
    }
}

