/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.CobolFocusEvent;
import com.iscobol.gui.ColorCmp;
import com.iscobol.gui.ParamElementSize;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.swing.CobolEventCouple;
import com.iscobol.gui.client.swing.ComboBox;
import com.iscobol.gui.client.swing.EntryField;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.PicobolChoice;
import com.iscobol.gui.client.swing.PopupListener;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import com.iscobol.gui.client.swing.SwingWorker;
import com.iscobol.rts.Factory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class RemoteComboBox
extends RemoteBaseGUIControl {
    private static final float DEFAULT_INSETS = 0.4f;
    private static final float DEFAULT_WIDTH_INSETS = 8.0f;
    private static final float DEFAULT_WIDTH = 12.0f;
    private static final JTextField target = new JTextField();
    private int cursorPos;
    private boolean notifySelChange;
    private boolean notifyDblClik;
    private boolean textToUpper;
    private boolean textToLower;
    private boolean unsorted;
    private boolean dropList;
    private boolean noAutosel;
    private int insertionIndex;
    private int lastselected = -1;
    private int resetCombo;
    private Vector<String> items = new Vector();
    private String valueStr = "";
    private float rows;
    private int maxText;
    private int queryIndex;
    private Image image;
    private int bitmapWidth = 16;
    private ActionListener listener;
    private boolean additemwithpopup;
    private String disabledFieldColor;
    private PropertyChangeListener pcListener;
    private boolean f4DropsCombo = true;
    private int configBcolor = -1;
    private int configFcolor = -1;
    private Color defaultBackground;
    private Color defaultForeground;
    private boolean backgroundSet;
    private boolean foregroundSet;
    private boolean isNative;
    private String placeholder;
    private Color placeholderColor;
    private int upperLowerMethod;
    private boolean defaultShortcutsEnabled;
    private String acceptedControlCharacters;
    private Integer selectionColor;
    private Integer selectionBackgroundColor;
    private Integer selectionForegroundColor;
    private boolean selectionBackgroundRgb;
    private boolean selectionForegroundRgb;
    private float itemheight = -1.0f;
    private boolean setoncompsave;
    private float hsave = -1.0f;
    private int massUpdate;
    private String inputFilter;

    public RemoteComboBox(final GuiFactoryImpl guiFactoryImpl) {
        super(guiFactoryImpl);
        this.isNative = guiFactoryImpl.getCsProperty().get("iscobol.gui.native_style", false);
        this.disabledFieldColor = guiFactoryImpl.getCsProperty().get("iscobol.gui.disabled_field_color", null);
        this.f4DropsCombo = guiFactoryImpl.getCsProperty().get("iscobol.key.f4.system", guiFactoryImpl.getCsProperty().get("iscobol.gui.f4_drops_combobox", true));
        this.configBcolor = guiFactoryImpl.getCsProperty().get("iscobol.gui.curr_bcolor", -1);
        this.configFcolor = guiFactoryImpl.getCsProperty().get("iscobol.gui.curr_fcolor", -1);
        this.upperLowerMethod = guiFactoryImpl.getUpperLowerMethod();
        this.defaultShortcutsEnabled = guiFactoryImpl.getCsProperty().get("iscobol.key.default_shortcuts_enabled", true);
        this.acceptedControlCharacters = guiFactoryImpl.getCsProperty().get("iscobol.key.accepted_control_characters", null);
        this.setPlaceholderColor();
        this.pcListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (guiFactoryImpl != null) {
                    if (string.equals("iscobol.gui.disabled_field_color")) {
                        RemoteComboBox.this.setDisabledFieldColor(guiFactoryImpl.getCsProperty().get(string, null));
                    } else if (string.equals("iscobol.gui.f4_drops_combobox")) {
                        RemoteComboBox.this.setF4DropsCombo(guiFactoryImpl.getCsProperty().get(string, true));
                    } else if (string.equals("iscobol.key.f4.system")) {
                        RemoteComboBox.this.setF4DropsCombo(guiFactoryImpl.getCsProperty().get(string, true));
                    } else if (string.equals("iscobol.gui.curr_bcolor")) {
                        RemoteComboBox.this.configBcolor = guiFactoryImpl.getCsProperty().get(string, -1);
                    } else if (string.equals("iscobol.gui.curr_fcolor")) {
                        RemoteComboBox.this.configFcolor = guiFactoryImpl.getCsProperty().get(string, -1);
                    } else if (string.equals("iscobol.gui.placeholder_color")) {
                        RemoteComboBox.this.setPlaceholderColor();
                    } else if (string.equals("iscobol.key.accepted_control_characters")) {
                        RemoteComboBox.this.acceptedControlCharacters = guiFactoryImpl.getCsProperty().get("iscobol.key.accepted_control_characters", null);
                        if (RemoteComboBox.this.guiComponent != null) {
                            ((PicobolChoice)RemoteComboBox.this.guiComponent).setAcceptedControlCharacters(RemoteComboBox.this.acceptedControlCharacters);
                        }
                    }
                }
            }
        };
        guiFactoryImpl.getCsProperty().addPropertyChangeListener(this.pcListener);
    }

    private void setPlaceholderColor() {
        try {
            int n2 = Integer.parseInt(this.gf.getCsProperty().get("iscobol.gui.placeholder_color", null));
            this.placeholderColor = this.getForegroundColor(n2, false);
        }
        catch (Exception exception) {
            this.placeholderColor = null;
        }
        if (this.guiComponent != null) {
            ((PicobolChoice)this.guiComponent).setPlaceholderColor(this.placeholderColor);
        }
    }

    private void setF4DropsCombo(boolean bl) {
        this.f4DropsCombo = bl;
        if (this.guiComponent != null) {
            ((PicobolChoice)this.guiComponent).setF4DropsCombo(this.f4DropsCombo);
        }
    }

    @Override
    public void displayProp() {
    }

    @Override
    public float getDefaultHeight() {
        return 1.4f;
    }

    @Override
    public float getDefaultWidth() {
        float f2;
        float f3 = 0.0f;
        f3 = this.valueStr.length();
        if (f2 > 0.0f) {
            return f3;
        }
        return 12.0f;
    }

    @Override
    public int getGUIControlHeight(float f2) {
        if (this.itemheight == -1.0f) {
            this.hsave = f2;
            return (int)(this.getDefaultHeight() * (float)this.font.getHeight());
        }
        int n2 = -1;
        n2 = this.linesInPixel ? (int)this.itemheight : (this.linesInCells && this.getParentBGW() != null ? RemoteComboBox.roundToPix(this.itemheight * (float)this.getParentBGW().getCellHeight()) : (int)(this.itemheight * (float)this.font.getHeight()));
        return n2;
    }

    @Override
    public int getGUIControlWidth(float f2) {
        int n2 = (int)((float)this.font.getWidth() * f2);
        n2 = (int)((float)n2 + 8.0f);
        return n2 += 2 * this.font.getWidth();
    }

    private void updateCursorProps() {
        PicobolChoice picobolChoice = (PicobolChoice)this.guiComponent;
        if (picobolChoice != null && picobolChoice.isEditable()) {
            this.cursorPos = picobolChoice.getCaretPosition() + 1;
        }
    }

    @Override
    public String getProp(int n2) {
        PicobolChoice picobolChoice = (PicobolChoice)this.guiComponent;
        switch (n2) {
            case 142: {
                return "" + this.massUpdate;
            }
            case 147: {
                return "" + this.maxText;
            }
            case 128: 
            case 132: {
                if (picobolChoice != null && this.queryIndex > 0 && this.queryIndex <= picobolChoice.getItemCount()) {
                    String string = picobolChoice.getItemAt(this.queryIndex - 1).toString();
                    if (this.textToUpper || this.gf.getGuiKdbUpper()) {
                        return Factory.toUpperCase(string, this.upperLowerMethod);
                    }
                    if (this.textToLower || this.gf.getGuiKdbLower()) {
                        return Factory.toLowerCase(string, this.upperLowerMethod);
                    }
                    return string;
                }
                return null;
            }
            case 177: {
                return Integer.toString(this.queryIndex);
            }
            case 127: {
                return Integer.toString(picobolChoice.getSelectedIndex() + 1);
            }
            case 59: {
                this.updateCursorProps();
                return "" + this.cursorPos;
            }
            case 324: {
                return this.placeholder;
            }
            case 287: {
                if (!this.selectionBackgroundRgb && this.selectionBackgroundColor != null) {
                    return this.selectionBackgroundColor.toString();
                }
                if (picobolChoice.getSelectionBackground() != null) {
                    ColorCmp colorCmp = new ColorCmp(true);
                    colorCmp.setBackRGB(picobolChoice.getSelectionBackground().getRGB());
                    Color color = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(colorCmp.getBackground(), false));
                    return Integer.toString(color != null ? color.getRGB() : 0);
                }
                return "0";
            }
            case 288: {
                if (!this.selectionForegroundRgb && this.selectionForegroundColor != null) {
                    return this.selectionForegroundColor.toString();
                }
                if (picobolChoice.getSelectionForeground() != null) {
                    ColorCmp colorCmp = new ColorCmp(true);
                    colorCmp.setForeRGB(picobolChoice.getSelectionForeground().getRGB());
                    Color color = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(colorCmp.getForeground(), false));
                    return Integer.toString(color != null ? color.getRGB() : 0);
                }
                return "0";
            }
            case 383: {
                if (this.selectionColor != null) {
                    return this.selectionColor.toString();
                }
                return "0";
            }
        }
        return super.getProp(n2);
    }

    @Override
    public Object getPropObject(int n2) {
        Object object = null;
        PicobolChoice picobolChoice = (PicobolChoice)this.guiComponent;
        switch (n2) {
            case 115: {
                object = picobolChoice.getHiddenDataAt(this.queryIndex - 1);
            }
        }
        return object;
    }

    @Override
    public String getTitle() {
        return "";
    }

    @Override
    public String getValue() {
        if (this.guiComponent == null) {
            return "";
        }
        PicobolChoice picobolChoice = (PicobolChoice)this.guiComponent;
        return picobolChoice.getText();
    }

    @Override
    public void setControlEditor(boolean bl) {
        super.setControlEditor(bl);
        PicobolChoice picobolChoice = (PicobolChoice)this.guiComponent;
        if (picobolChoice != null) {
            picobolChoice.setDrawBorder(!bl);
            picobolChoice.setControlEditor(bl);
        }
    }

    @Override
    public void initialize() {
        Object object;
        if (this.guiComponent != null) {
            return;
        }
        final PicobolChoice picobolChoice = new PicobolChoice(this.isNative, !this.unsorted);
        if (this.name != null) {
            picobolChoice.setName(this.name);
        }
        this.guiComponent = picobolChoice;
        picobolChoice.setDefaultShortcutsEnabled(this.defaultShortcutsEnabled);
        picobolChoice.setEditable(!this.dropList);
        picobolChoice.setUpperLowerMethod(this.upperLowerMethod);
        if (this.popupListener == null && !this.dropList) {
            this.popupListener = new PopupListener(picobolChoice);
        }
        this.guiComponent.addKeyListener(this);
        picobolChoice.addOutAcceptListener(this);
        super.intInitialize();
        if (this.itemheight > 0.0f && this.hsave > 0.0f) {
            this.height = this.getGUIControlHeight(this.hsave);
            super.setSize(this.width, this.height, this.setoncompsave);
        }
        if (super.getBackground() == null) {
            this.guiComponent.setBackground(target.getBackground());
        }
        picobolChoice.setMaximumRowCount((int)this.rows);
        picobolChoice.setAcceptedControlCharacters(this.acceptedControlCharacters);
        this.guiComponent.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!(RemoteComboBox.this.guiComponent == null || focusEvent.getOppositeComponent() == null || focusEvent.getOppositeComponent() == RemoteComboBox.this.guiComponent || RemoteComboBox.this.popupListener != null && RemoteComboBox.this.popupListener.isDefaultPopupVisible())) {
                    picobolChoice.setPopupVisible(false);
                    picobolChoice.clearSelection();
                }
            }
        });
        picobolChoice.addHierarchyListener(hierarchyEvent -> {
            if ((hierarchyEvent.getChangeFlags() | 4L) == 4L && !picobolChoice.isShowing()) {
                picobolChoice.clearSelection();
            }
        });
        picobolChoice.setMaxText(this.maxText);
        if (this.textToUpper) {
            picobolChoice.setUpper(this.textToUpper);
        } else if (this.textToLower) {
            picobolChoice.setLower(this.textToLower);
        } else {
            picobolChoice.setLower(this.gf.getGuiKdbLower());
            picobolChoice.setUpper(this.gf.getGuiKdbUpper());
        }
        picobolChoice.setPlaceholder(this.placeholder);
        picobolChoice.setPlaceholderColor(this.placeholderColor);
        if (this.inputFilter != null) {
            picobolChoice.setInputFilter(this.inputFilter);
        }
        if (this.items.size() > 0) {
            for (String string : this.items) {
                this.additem0(string);
            }
            this.items.clear();
        }
        this.setValue(this.valueStr);
        this.setDisabledFieldColor(this.disabledFieldColor);
        this.setF4DropsCombo(this.f4DropsCombo);
        if (this.selectionColor != null) {
            object = this.getColors(this.selectionColor);
            picobolChoice.setSelectionBackground(object[0]);
            picobolChoice.setSelectionForeground(object[1]);
        } else {
            if (this.selectionBackgroundColor != null) {
                object = this.getBackgroundColor(this.selectionBackgroundColor, this.selectionBackgroundRgb);
                picobolChoice.setSelectionBackground((Color)object);
            }
            if (this.selectionForegroundColor != null) {
                object = this.getForegroundColor(this.selectionForegroundColor, this.selectionForegroundRgb);
                picobolChoice.setSelectionForeground((Color)object);
            }
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.items.size() > 0) {
            for (String string : this.items) {
                this.additem0(string);
            }
            this.items.clear();
            this.setValue(this.valueStr);
        }
        if (this.listener == null && this.guiComponent != null) {
            this.listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (RemoteComboBox.this.guiComponent != null) {
                        RemoteComboBox.this.responseOnAction();
                    }
                }
            };
            ((PicobolChoice)this.guiComponent).addActionListener(this.listener);
        }
        if (bl) {
            this.loadcursor();
        }
    }

    private void setDisabledFieldColor(String string) {
        this.disabledFieldColor = string;
        if (this.guiComponent != null) {
            boolean[] blArray = new boolean[1];
            Color[] colorArray = this.getFieldColors(this.disabledFieldColor, blArray);
            ComboBox comboBox = (ComboBox)((Object)this.guiComponent);
            if (blArray[0] || !this.backgroundSet) {
                comboBox.setDisabledBackground(colorArray[0]);
            } else {
                comboBox.setDisabledBackground(null);
            }
            if (blArray[0] || !this.foregroundSet) {
                comboBox.setDisabledForeground(colorArray[1]);
            } else {
                comboBox.setDisabledForeground(null);
            }
        }
    }

    private void responseOnAction() {
        if ((RemoteDisplayWindow)this.parentWindow != null) {
            ((RemoteDisplayWindow)this.parentWindow).stopTimer();
        }
        int n2 = ((PicobolChoice)this.guiComponent).getSelectedIndex();
        if (this.notifySelChange) {
            CobolEventCouple cobolEventCouple = new CobolEventCouple(this, new RemoteRecordAccept(6, 96, 4099, (short)(n2 + 1), 0, true, true, true));
            this.pushEvent(cobolEventCouple);
        }
        if (!this.noAutosel) {
            ((PicobolChoice)this.guiComponent).selectAll();
        }
        this.lastselected = n2;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.notifyDblClik && this.guiComponent.isEnabled() && mouseEvent.getClickCount() == 2) {
            int n2 = ((PicobolChoice)this.guiComponent).getSelectedIndex();
            CobolEventCouple cobolEventCouple = new CobolEventCouple(this, new RemoteRecordAccept(16, 18, (short)(n2 + 1)));
            this.pushEvent(cobolEventCouple);
        }
    }

    @Override
    protected boolean isMenuKeyPressed(KeyEvent keyEvent) {
        if (((PicobolChoice)this.guiComponent).isPopupVisible()) {
            return false;
        }
        return super.isMenuKeyPressed(keyEvent);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n2 = keyEvent.getKeyCode();
        switch (n2) {
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                return;
            }
            case 115: {
                if (!this.f4DropsCombo) break;
                return;
            }
            case 27: {
                if (((PicobolChoice)this.guiComponent).isPopupVisible()) {
                    return;
                }
            }
            case 67: 
            case 86: 
            case 88: 
            case 89: 
            case 90: {
                if (!keyEvent.isControlDown() || this.dropList || !this.defaultShortcutsEnabled) break;
                return;
            }
        }
        super.keyPressed(keyEvent);
    }

    @Override
    protected void intFocusGained(boolean bl) {
        if (!this.noAutosel) {
            ((PicobolChoice)this.guiComponent).selectAll();
        }
        if (!bl) {
            this.setconfigBF();
        }
    }

    @Override
    public boolean isSelfAct() {
        return false;
    }

    @Override
    protected void setAction(int n2) {
        int n3 = n2;
        PicobolChoice picobolChoice = (PicobolChoice)this.guiComponent;
        if (picobolChoice != null && picobolChoice.isVisible() && picobolChoice.isEnabled()) {
            switch (n3) {
                case 2: {
                    picobolChoice.copy();
                    break;
                }
                case 3: {
                    if (!ScreenUtility.canPaste(EntryField.class)) break;
                    picobolChoice.paste();
                    break;
                }
                case 1: {
                    picobolChoice.cut();
                    break;
                }
                case 4: {
                    picobolChoice.replaceSelection("");
                    break;
                }
                case 5: {
                    picobolChoice.undo();
                    break;
                }
                case 6: {
                    picobolChoice.redo();
                    break;
                }
                case 7: {
                    picobolChoice.selectAll();
                    break;
                }
                default: {
                    super.setAction(n2);
                }
            }
        }
    }

    @Override
    public void setBorder(boolean bl) {
    }

    @Override
    public void setElementAt(int n2) {
        this.queryIndex = n2;
    }

    @Override
    public void setElementAt(int[] nArray) {
        this.queryIndex = nArray[0];
    }

    @Override
    public void setImage(int n2, int n3, int n4, int n5) {
        this.image = this.getLocalImage(n4);
    }

    @Override
    public String setProp(Integer n2, byte[] byArray, int n3) {
        String string = "0";
        PicobolChoice picobolChoice = (PicobolChoice)this.guiComponent;
        switch (n2) {
            case 115: {
                if (picobolChoice != null && this.queryIndex > 0 && this.queryIndex <= picobolChoice.getItemCount()) {
                    picobolChoice.setHiddenDataAt(this.queryIndex - 1, byArray);
                }
                string = "1";
            }
        }
        return string;
    }

    @Override
    public String setProp(Integer n2, String[] stringArray) {
        String string = "0";
        if (stringArray == null) {
            return "0";
        }
        if (n2 == 129) {
            boolean bl = this.notifySelChange;
            this.notifySelChange = false;
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string2 = ScreenUtility.rightTrim(stringArray[i2]);
                if (string2.length() <= 0) continue;
                this.additem(string2);
            }
            this.notifySelChange = bl;
            string = "" + this.queryIndex;
        }
        return string;
    }

    private void loadcursor() {
        PicobolChoice picobolChoice = (PicobolChoice)this.guiComponent;
        if (picobolChoice != null && picobolChoice.isEditable()) {
            if (this.cursorPos > 0) {
                this.setCursorPos();
            } else if (this.parentWindow != null && ((RemoteDisplayWindow)this.parentWindow).getPreviousFocusOwner() != this) {
                picobolChoice.setCaretPosition(0);
            }
        }
    }

    private void setCursorPos() {
        PicobolChoice picobolChoice;
        if (this.cursorPos == 0) {
            this.cursorPos = 1;
        }
        if ((picobolChoice = (PicobolChoice)this.guiComponent) != null && picobolChoice.isEditable()) {
            try {
                picobolChoice.setCaretPosition(this.cursorPos - 1);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                picobolChoice.setCaretPosition(picobolChoice.getText().length());
            }
        }
    }

    @Override
    public String setProp(Integer n2, String string, int n3) {
        PicobolChoice picobolChoice = (PicobolChoice)this.guiComponent;
        String string2 = "0";
        int n4 = -1;
        boolean bl = false;
        boolean bl2 = false;
        try {
            n4 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            bl = true;
        }
        switch (n2) {
            case 142: {
                if (bl) break;
                this.massUpdate = n4;
                string2 = "1";
                break;
            }
            case 59: {
                if (bl) break;
                this.cursorPos = n4;
                if (this.cursorPos == -1 && picobolChoice != null) {
                    picobolChoice.selectAll();
                } else {
                    this.setCursorPos();
                }
                string2 = "1";
                break;
            }
            case 124: {
                if (bl) break;
                this.insertionIndex = n4;
                if (this.insertionIndex < 1) {
                    this.insertionIndex = 1;
                }
                if (this.insertionIndex > this.getItemCount()) {
                    this.insertionIndex = this.getItemCount();
                }
                string2 = "1";
                break;
            }
            case 127: 
            case 177: {
                if (bl) break;
                this.queryIndex = n4;
                string2 = "1";
                break;
            }
            case 128: 
            case 132: {
                if (picobolChoice != null && this.queryIndex > 0 && this.queryIndex <= picobolChoice.getItemCount()) {
                    String string3 = ScreenUtility.rightTrim(string);
                    picobolChoice.modifyItemAt(this.queryIndex - 1, string3);
                }
                string2 = "1";
                break;
            }
            case 20: {
                if (bl) break;
                this.bitmapWidth = n4;
                string2 = "1";
                break;
            }
            case 12: {
                Image image;
                if (bl) break;
                if (picobolChoice != null && this.image != null && this.queryIndex > 0 && this.queryIndex <= picobolChoice.getItemCount() && (image = ScreenUtility.getImage(this.bitmapWidth, -1, this.image, n4)) != null) {
                    picobolChoice.modifyItemAt(this.queryIndex - 1, new ImageIcon(image));
                }
                string2 = "1";
                break;
            }
            case 115: {
                if (picobolChoice != null && this.queryIndex > 0 && this.queryIndex <= picobolChoice.getItemCount()) {
                    picobolChoice.setHiddenDataAt(this.queryIndex - 1, string);
                }
                string2 = "1";
                break;
            }
            case 369: {
                if (bl) break;
                if (picobolChoice != null && this.queryIndex > 0 && this.queryIndex <= picobolChoice.getItemCount()) {
                    Color[] colorArray = this.getColors(n4);
                    picobolChoice.setColorAt(this.queryIndex - 1, n4, colorArray[0], colorArray[1]);
                }
                string2 = "1";
                break;
            }
            case 371: {
                bl2 = true;
            }
            case 370: {
                if (bl) break;
                if (picobolChoice != null && this.queryIndex > 0 && this.queryIndex <= picobolChoice.getItemCount()) {
                    Color color = this.getBackgroundColor(n4, bl2);
                    picobolChoice.setBackgroundColorAt(this.queryIndex - 1, n4, color);
                }
                string2 = "1";
                break;
            }
            case 373: {
                bl2 = true;
            }
            case 372: {
                if (bl) break;
                if (picobolChoice != null && this.queryIndex > 0 && this.queryIndex <= picobolChoice.getItemCount()) {
                    Color color = this.getForegroundColor(n4, bl2);
                    picobolChoice.setForegroundColorAt(this.queryIndex - 1, n4, color);
                }
                string2 = "1";
                break;
            }
            case 383: {
                if (bl) break;
                this.selectionColor = n4;
                if (picobolChoice != null) {
                    Color[] colorArray = this.getColors(n4);
                    picobolChoice.setSelectionBackground(colorArray[0]);
                    picobolChoice.setSelectionForeground(colorArray[1]);
                }
                string2 = "1";
                break;
            }
            case 384: {
                bl2 = true;
            }
            case 287: {
                if (bl) break;
                this.selectionBackgroundColor = n4;
                this.selectionBackgroundRgb = bl2;
                if (picobolChoice != null) {
                    Color color = this.getBackgroundColor(n4, bl2);
                    picobolChoice.setSelectionBackground(color);
                }
                string2 = "1";
                break;
            }
            case 385: {
                bl2 = true;
            }
            case 288: {
                if (bl) break;
                this.selectionForegroundColor = n4;
                this.selectionForegroundRgb = bl2;
                if (picobolChoice != null) {
                    Color color = this.getForegroundColor(n4, bl2);
                    picobolChoice.setSelectionForeground(color);
                }
                string2 = "1";
                break;
            }
            case 130: {
                if (bl) break;
                if (n4 > 0) {
                    this.removeitem(n4 - 1);
                }
                string2 = "1";
                break;
            }
            case 129: {
                String string4 = ScreenUtility.rightTrim(string);
                if (string4.length() > 0) {
                    this.additem(string4);
                }
                string2 = "" + this.queryIndex;
                break;
            }
            case 190: {
                if (bl) break;
                this.resetCombo = n4;
                if (this.resetCombo != 0) {
                    this.removeAll();
                }
                string2 = "1";
                break;
            }
            case 324: {
                this.placeholder = string.trim();
                if (picobolChoice != null) {
                    picobolChoice.setPlaceholder(this.placeholder);
                }
                string2 = "1";
                break;
            }
            case 147: {
                if (bl) break;
                this.maxText = n4;
                if (picobolChoice != null) {
                    picobolChoice.setMaxText(this.maxText);
                }
                string2 = "1";
                break;
            }
            case 386: {
                float f2 = -1.0f;
                boolean bl3 = false;
                try {
                    f2 = Float.parseFloat(string.replace(',', '.'));
                }
                catch (NumberFormatException numberFormatException) {
                    bl3 = true;
                }
                if (bl3) break;
                this.itemheight = f2;
                if (this.guiComponent == null) break;
                this.height = this.getGUIControlHeight(this.hsave);
                super.setSize(this.width, this.height, this.setoncompsave);
                break;
            }
            case 436: {
                this.setInputFilter(string);
                break;
            }
            default: {
                return super.setProp(n2, string, n3);
            }
        }
        return string2;
    }

    private void additem(String string) {
        PicobolChoice picobolChoice = (PicobolChoice)this.guiComponent;
        if ((string = ScreenUtility.rightTrim(string)).length() == 0) {
            return;
        }
        int n2 = 0;
        if (this.insertionIndex <= 0) {
            int n3 = this.getItemCount();
            n2 = this.unsorted ? n3 + 1 : this.getInsertionIndex(string) + 1;
        } else {
            n2 = this.insertionIndex;
            this.insertionIndex = 0;
        }
        if (picobolChoice != null) {
            if (!this.additemwithpopup && (this.additemwithpopup = picobolChoice.isPopupVisible())) {
                picobolChoice.hidePopup();
            }
            this.insertitem(string, n2 - 1);
        } else {
            this.items.add(n2 - 1, string);
        }
        this.queryIndex = n2;
    }

    private void insertitem(String string, int n2) {
        PicobolChoice picobolChoice = (PicobolChoice)this.guiComponent;
        picobolChoice.insertItemAt(string, n2);
        if (this.valueStr != null) {
            this.intSetValue(this.valueStr);
        }
    }

    private void additem0(String string) {
        PicobolChoice picobolChoice = (PicobolChoice)this.guiComponent;
        picobolChoice.addItem(string);
    }

    private void removeitem(int n2) {
        if (n2 < this.getItemCount()) {
            if (this.guiComponent != null) {
                PicobolChoice picobolChoice = (PicobolChoice)this.guiComponent;
                picobolChoice.removeItemAt(n2);
                if (this.lastselected == n2) {
                    this.lastselected = picobolChoice.getSelectedIndex();
                }
            } else {
                this.items.removeElementAt(n2);
            }
        }
    }

    @Override
    public void setRowsCols(float f2, float f3) {
        if (f2 > 0.0f) {
            this.rows = f2 < 2.0f ? 1.0f : f2 - 1.0f;
        }
        if (this.maxText == 0 && f3 > 0.0f) {
            this.maxText = (int)f3;
        }
    }

    @Override
    protected Rectangle paramdisplaysetSize(ParamElementSize paramElementSize) {
        if (paramElementSize.getlines == 0.0f) {
            this.rows = 4.0f;
        }
        return super.paramdisplaysetSize(paramElementSize);
    }

    @Override
    protected float parammodifyLines(ParamElementSize paramElementSize) {
        if (paramElementSize.getlines == 0.0f) {
            this.rows = 4.0f;
        }
        return super.parammodifyLines(paramElementSize);
    }

    @Override
    public void setStyle(int n2, boolean bl) {
        PicobolChoice picobolChoice = (PicobolChoice)this.guiComponent;
        if ((n2 & 0x200) == 512) {
            this.notifySelChange = bl;
        }
        if ((n2 & 0x100) == 256) {
            this.notifyDblClik = bl;
        }
        if ((n2 & 0x800) == 2048) {
            this.textToUpper = bl;
            boolean bl2 = this.textToLower = !bl;
            if (picobolChoice != null) {
                picobolChoice.setUpper(true);
                picobolChoice.setLower(false);
            }
        }
        if ((n2 & 0x1000) == 4096) {
            this.textToLower = bl;
            boolean bl3 = this.textToUpper = !bl;
            if (picobolChoice != null) {
                picobolChoice.setLower(true);
                picobolChoice.setUpper(false);
            }
        }
        if ((n2 & 0x2000) == 8192) {
            this.noAutosel = bl;
        }
        if ((n2 & 1) == 1) {
            this.unsorted = bl;
        }
        if ((n2 & 4) == 4) {
            this.dropList = bl;
        }
    }

    @Override
    public void setTitle(String string) {
    }

    private int getItemCount() {
        if (this.guiComponent != null) {
            return ((PicobolChoice)this.guiComponent).getItemCount();
        }
        return this.items.size();
    }

    @Override
    public String setValue(String string) {
        this.valueStr = string;
        if (this.guiComponent != null) {
            this.intSetValue(string);
            this.loadcursor();
        }
        return this.valueStr;
    }

    private void intSetValue(String string) {
        String string2 = ScreenUtility.rightTrim(string);
        if (string2.length() > 0) {
            this.setSelectedItem(string2);
        } else {
            this.setSelectedIndex(-1);
        }
    }

    private void setSelectedIndex(int n2) {
        this.lastselected = n2;
        ((PicobolChoice)this.guiComponent).select(n2);
    }

    private int getIndexOfExactItem(Object[] objectArray, String string) {
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (!objectArray[i2].toString().equals(string)) continue;
            return i2;
        }
        return -1;
    }

    private int getIndexOfExactItemIgnoreCase(Object[] objectArray, String string) {
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (!objectArray[i2].toString().equalsIgnoreCase(string)) continue;
            return i2;
        }
        return -1;
    }

    private int getIndexOfItemStartingWith(Object[] objectArray, String string) {
        string = string.toLowerCase();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (!objectArray[i2].toString().toLowerCase().startsWith(string)) continue;
            return i2;
        }
        return -1;
    }

    private int getIndexOfItem(Object[] objectArray, String string) {
        int n2 = this.getIndexOfExactItem(objectArray, string);
        if (n2 >= 0) {
            return n2;
        }
        n2 = this.getIndexOfExactItemIgnoreCase(objectArray, string);
        if (n2 >= 0) {
            return n2;
        }
        return this.getIndexOfItemStartingWith(objectArray, string);
    }

    private boolean setSelectedItem(final String string) {
        int n2;
        final PicobolChoice picobolChoice = (PicobolChoice)this.guiComponent;
        if (picobolChoice == null) {
            return false;
        }
        Object[] objectArray = new Object[picobolChoice.getItemCount()];
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            objectArray[n2] = picobolChoice.getItemAt(n2);
        }
        n2 = this.getIndexOfItem(objectArray, string);
        if (n2 != this.lastselected) {
            this.setSelectedIndex(n2);
        }
        if (!this.dropList) {
            new SwingWorker(true){

                @Override
                public void launch() {
                    picobolChoice.setText(string);
                }
            }.start();
        }
        return true;
    }

    private void removeAll() {
        if (this.guiComponent != null) {
            ((PicobolChoice)this.guiComponent).removeAllItems();
            this.lastselected = -1;
        } else {
            this.items.clear();
        }
        this.valueStr = "";
    }

    @Override
    public void destroy() {
        if (this.gf != null && this.gf.getCsProperty() != null) {
            this.gf.getCsProperty().removePropertyChangeListener(this.pcListener);
        }
        this.pcListener = null;
        super.destroy();
    }

    @Override
    public void handleResponse(int n2, RemoteRecordAccept remoteRecordAccept) {
        super.handleResponse(n2, remoteRecordAccept);
    }

    @Override
    public void setCols(float f2) {
    }

    @Override
    public void setRows(float f2) {
    }

    @Override
    public void setSize(int n2, int n3, boolean bl) {
        this.width = n2;
        if (this.itemheight == -1.0f || this.linesInCells || this.linesInPixel) {
            this.hsave = n3;
            this.setoncompsave = bl;
        }
        this.height = this.getGUIControlHeight(1.0f);
        if (this.rows == 0.0f) {
            this.rows = (int)((float)n3 / (float)this.font.getHeight()) - 1;
        }
        if (this.guiComponent != null && bl) {
            this.updateLayoutManager();
            this.guiComponent.setSize(this.width, this.height);
        }
    }

    @Override
    public boolean isInputField() {
        return true;
    }

    @Override
    protected float paramgetDefaultWidth(ParamElementSize paramElementSize, int n2) {
        if (paramElementSize.sizes > 0.0f) {
            return paramElementSize.sizes;
        }
        if (paramElementSize.ccOlen != -1) {
            return paramElementSize.ccOlen;
        }
        if (paramElementSize.ccIlen != -1) {
            return paramElementSize.ccIlen;
        }
        return super.paramgetDefaultWidth(paramElementSize, n2);
    }

    @Override
    public String getType() {
        return "combobox";
    }

    @Override
    public void endloadParams() {
        PicobolChoice picobolChoice = (PicobolChoice)this.guiComponent;
        if (picobolChoice != null && this.additemwithpopup) {
            picobolChoice.showPopup();
        }
        this.additemwithpopup = false;
    }

    @Override
    public void endClearOutAcceptEvents() {
        PicobolChoice picobolChoice = (PicobolChoice)this.guiComponent;
        if (picobolChoice != null) {
            picobolChoice.hidePopup();
        }
    }

    @Override
    public void endRepostOutAcceptEvents() {
        PicobolChoice picobolChoice = (PicobolChoice)this.guiComponent;
        if (picobolChoice != null) {
            picobolChoice.myshowPopup();
        }
    }

    @Override
    public void startCellEditing() {
        PicobolChoice picobolChoice = (PicobolChoice)this.guiComponent;
        if (picobolChoice != null) {
            picobolChoice.showPopup();
        }
    }

    private Color getOriginalBackground() {
        Color color = this.getBackground();
        if (color == null) {
            color = this.defaultBackground;
        }
        return color;
    }

    private Color getOriginalForeground() {
        Color color = this.getForeground();
        if (color == null) {
            color = this.defaultForeground;
        }
        return color;
    }

    private void restoreBF() {
        if (this.guiComponent != null) {
            Color color;
            if (this.configBcolor != -1 && (color = this.getOriginalBackground()) != null) {
                this.guiComponent.setBackground(color);
            }
            if ((this.configFcolor != -1 || this.configBcolor != -1) && (color = this.getOriginalForeground()) != null) {
                this.guiComponent.setForeground(color);
            }
        }
    }

    private void setconfigBF() {
        if (this.guiComponent != null) {
            if (this.configBcolor != -1) {
                if (this.defaultBackground == null) {
                    this.defaultBackground = ((PicobolChoice)this.guiComponent).background();
                }
                this.guiComponent.setBackground(this.gf.getRemotePalette().getDefaultColor(this.configBcolor));
            }
            if (this.configFcolor != -1) {
                if (this.defaultForeground == null) {
                    this.defaultForeground = ((PicobolChoice)this.guiComponent).foreground();
                }
                this.guiComponent.setForeground(this.gf.getRemotePalette().getDefaultColor(this.configFcolor));
            } else if (this.configBcolor != -1) {
                if (this.defaultForeground == null) {
                    this.defaultForeground = ((PicobolChoice)this.guiComponent).foreground();
                }
                this.guiComponent.setForeground(((PicobolChoice)this.guiComponent).foreground());
            }
        }
    }

    @Override
    protected boolean requestFocusLostComponent(RemoteBaseGUIControl remoteBaseGUIControl, MouseEvent mouseEvent, RemoteRecordAccept remoteRecordAccept) {
        if (remoteBaseGUIControl != this) {
            this.restoreBF();
        }
        return true;
    }

    @Override
    public void focusLost(CobolFocusEvent cobolFocusEvent) {
        this.restoreBF();
        super.focusLost(cobolFocusEvent);
    }

    @Override
    public void focusGained(CobolFocusEvent cobolFocusEvent) {
        if (cobolFocusEvent.isGoto()) {
            this.setconfigBF();
        }
        super.focusGained(cobolFocusEvent);
    }

    @Override
    public void setColorBackgroundIdx(int n2) {
        boolean bl = this.backgroundSet;
        super.setColorBackgroundIdx(n2);
        boolean bl2 = this.backgroundSet = this.getBackground() != null;
        if (bl != this.backgroundSet) {
            this.setDisabledFieldColor(this.disabledFieldColor);
        }
    }

    @Override
    public void setColorBackground(int n2, int n3, int n4) {
        boolean bl = this.backgroundSet;
        super.setColorBackground(n2, n3, n4);
        boolean bl2 = this.backgroundSet = this.getBackground() != null;
        if (bl != this.backgroundSet) {
            this.setDisabledFieldColor(this.disabledFieldColor);
        }
    }

    @Override
    public void setColorForegroundIdx(int n2) {
        boolean bl = this.foregroundSet;
        super.setColorForegroundIdx(n2);
        boolean bl2 = this.foregroundSet = this.getForeground() != null;
        if (bl != this.foregroundSet) {
            this.setDisabledFieldColor(this.disabledFieldColor);
        }
    }

    @Override
    public void setColorForeground(int n2, int n3, int n4) {
        boolean bl = this.foregroundSet;
        super.setColorForeground(n2, n3, n4);
        boolean bl2 = this.foregroundSet = this.getForeground() != null;
        if (bl != this.foregroundSet) {
            this.setDisabledFieldColor(this.disabledFieldColor);
        }
    }

    @Override
    public RemoteBaseGUIControl renderClone() {
        return this.renderClone(false, null);
    }

    @Override
    public RemoteBaseGUIControl renderClone(boolean bl, Dimension dimension) {
        RemoteComboBox remoteComboBox = null;
        try {
            remoteComboBox = (RemoteComboBox)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        remoteComboBox.setComponent(null);
        if (this.items != null && this.items.size() > 0) {
            remoteComboBox.copyitems(this.items);
            remoteComboBox.initialize();
        } else {
            remoteComboBox.initialize();
            remoteComboBox.copyitems2((PicobolChoice)this.guiComponent);
        }
        return remoteComboBox;
    }

    private void copyitems(Vector vector) {
        if (vector != null && vector.size() > 0) {
            this.items = new Vector();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.items.add((String)enumeration.nextElement());
            }
        }
    }

    public void copyitems2(PicobolChoice picobolChoice) {
        PicobolChoice picobolChoice2 = (PicobolChoice)this.guiComponent;
        picobolChoice2.copyItems(picobolChoice);
    }

    private int getInsertionIndex(String string) {
        int n2 = 0;
        int n3 = this.getItemCount() - 1;
        int n4 = n2 + (n3 - n2) / 2;
        PicobolChoice picobolChoice = (PicobolChoice)this.guiComponent;
        while (n2 <= n3) {
            String string2 = picobolChoice != null ? picobolChoice.getItemAt(n4).toString() : this.items.elementAt(n4);
            int n5 = string2.compareToIgnoreCase(string);
            if (n5 == 0) {
                return n4;
            }
            if (n5 > 0) {
                n3 = n4 - 1;
            } else {
                n2 = n4 + 1;
            }
            n4 = n2 + (n3 - n2) / 2;
        }
        return n4;
    }

    @Override
    public Rectangle getBoundsWithoutDefaultWidth() {
        Rectangle rectangle = super.getBounds();
        if (rectangle != null && rectangle.width > 0) {
            rectangle.width = (int)((float)rectangle.width - 8.0f);
            rectangle.width -= 2 * this.font.getWidth();
        }
        return rectangle;
    }

    @Override
    public JComponent getDragDropComponent() {
        PicobolChoice picobolChoice = (PicobolChoice)this.guiComponent;
        if (picobolChoice != null) {
            return picobolChoice.getDragDropComponent();
        }
        return null;
    }

    @Override
    public boolean isDnDStandard() {
        boolean bl = false;
        PicobolChoice picobolChoice = (PicobolChoice)this.guiComponent;
        if (picobolChoice != null && picobolChoice.isEditable()) {
            bl = true;
        }
        return bl;
    }

    @Override
    public void initializeDnDStandard() {
        PicobolChoice picobolChoice = (PicobolChoice)this.guiComponent;
        if (picobolChoice != null) {
            if (this.dragmode > 0) {
                picobolChoice.setDragComponent(this);
            } else {
                picobolChoice.setDragComponent(null);
            }
        }
    }

    private void setInputFilter(String string) {
        if (this.inputFilter == null || !this.inputFilter.equals(string)) {
            PicobolChoice picobolChoice = (PicobolChoice)this.guiComponent;
            this.inputFilter = string;
            if (picobolChoice != null) {
                picobolChoice.setInputFilter(this.inputFilter);
            }
        }
    }
}

