/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.CobolFocusEvent;
import com.iscobol.gui.ColorCmp;
import com.iscobol.gui.IsguiUtility;
import com.iscobol.gui.IsguiWorker;
import com.iscobol.gui.ParamsValues;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.LocalFontCmp;
import com.iscobol.gui.client.ZoomLayout;
import com.iscobol.gui.client.swing.CobolEventCouple;
import com.iscobol.gui.client.swing.DateEntry;
import com.iscobol.gui.client.swing.DateEntryChangeListener;
import com.iscobol.gui.client.swing.DateEntryEvent;
import com.iscobol.gui.client.swing.DateEntryListener;
import com.iscobol.gui.client.swing.DateEntryVetoException;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.OutAcceptEvent;
import com.iscobol.gui.client.swing.PicobolDateEntry;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import com.iscobol.gui.client.swing.SwingWorker;
import com.iscobol.rts.Factory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.border.MatteBorder;

public class RemoteDateEntry
extends RemoteBaseGUIControl
implements DateEntryChangeListener,
DateEntryListener {
    public static final int DEFAULT_WIDTH = 50;
    private Date value;
    private Date illegalDateVal;
    private Date maxVal;
    private Date minVal;
    private String displayFormat;
    private int valueFormat = -1;
    private int bitmapNumber;
    private int bitmapWidth;
    private int bitmapHeight;
    private Image image;
    private LocalFontCmp calendarFont;
    private boolean allowEmptyStyle;
    private boolean noF4Style;
    private boolean notifyChangeStyle;
    private boolean rightAlignStyle;
    private boolean showNoneStyle;
    private boolean timeStyle;
    private boolean centuryDateStyle;
    private boolean numericStyle;
    private boolean readOnlyStyle;
    private boolean longDateStyle;
    private boolean decBackVisibleStyle = true;
    private boolean decBordersVisibleStyle;
    private boolean weekOfYearVisibleStyle = true;
    private boolean noautoselStyle;
    private Color decBackColor;
    private ColorCmp decBackColorCmp;
    private int decBackColorIdx;
    private Color sunForeColor;
    private ColorCmp sunForeColorCmp;
    private int sunForeColorIdx;
    private Color wdForeColor;
    private ColorCmp wdForeColorCmp;
    private int wdForeColorIdx;
    private int maxDayChars;
    private Date newDate;
    private String timeStyleFormat;
    private String shortDateStyleFormat;
    private String centuryDateStyleFormat = "dd/MM/yyyy";
    private String longDateStyleFormat;
    private String valueStr;
    private boolean validateDate;
    private String validateErrMsg;
    private int _2DigitsYearStart;
    private PropertyChangeListener pcListener;
    private boolean selfAct;
    private boolean defaultShortcutsEnabled;
    private Color borderColor;
    private ColorCmp borderColorCmp;
    private int borderColorIdx;
    private String disabledFieldColor;
    private boolean backgroundSet;
    private boolean foregroundSet;

    public RemoteDateEntry(GuiFactoryImpl guiFactoryImpl) {
        super(guiFactoryImpl);
        this.setTimeStyleFormat(guiFactoryImpl.getCsProperty().get("iscobol.gui.date_entry.time", IsguiUtility.getDefaultTimeDateFormat()));
        this.setShortDateStyleFormat(guiFactoryImpl.getCsProperty().get("iscobol.gui.date_entry.display_format", IsguiUtility.getDefaultShortDateFormat()));
        this.setCenturyDateStyleFormat(guiFactoryImpl.getCsProperty().get("iscobol.gui.date_entry.century_date", IsguiUtility.getDefaultCenturyDateFormat()));
        this.setLongDateStyleFormat(guiFactoryImpl.getCsProperty().get("iscobol.gui.date_entry.long_date", IsguiUtility.getDefaultLongDateFormat()));
        this.defaultShortcutsEnabled = guiFactoryImpl.getCsProperty().get("iscobol.key.default_shortcuts_enabled", true);
        this.validateDate = guiFactoryImpl.getCsProperty().get("iscobol.gui.date_entry.validate", false);
        this.validateErrMsg = guiFactoryImpl.getCsProperty().get("iscobol.gui.date_entry.errormessage", Factory.getSysMsg("de_invalid_input"));
        this._2DigitsYearStart = guiFactoryImpl.getCsProperty().get("iscobol.gui.date_entry.cutoff", -1);
        this.disabledFieldColor = guiFactoryImpl.getCsProperty().get("iscobol.gui.disabled_field_color", null);
        this.pcListener = propertyChangeEvent -> {
            if (guiFactoryImpl != null) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("iscobol.gui.date_entry.time")) {
                    this.setTimeStyleFormat(guiFactoryImpl.getCsProperty().get(string, "HH:mm:ss"));
                } else if (string.equals("iscobol.gui.date_entry.display_format")) {
                    this.setShortDateStyleFormat(guiFactoryImpl.getCsProperty().get(string, "dd/MM/yyyy"));
                } else if (string.equals("iscobol.gui.date_entry.long_date")) {
                    this.setLongDateStyleFormat(guiFactoryImpl.getCsProperty().get(string, "EEEE dd MMMM yyyy"));
                } else if (string.equals("iscobol.gui.date_entry.century_date")) {
                    this.setCenturyDateStyleFormat(guiFactoryImpl.getCsProperty().get(string, "dd/MM/yyyy"));
                } else if (string.equals("iscobol.gui.date_entry.validate")) {
                    this.validateDate = guiFactoryImpl.getCsProperty().get("iscobol.gui.date_entry.validate", false);
                } else if (string.equals("iscobol.gui.date_entry.errormessage")) {
                    this.validateErrMsg = guiFactoryImpl.getCsProperty().get("iscobol.gui.date_entry.errormessage", Factory.getSysMsg("de_invalid_input"));
                } else if (string.equals("iscobol.gui.disabled_field_color")) {
                    this.setDisabledFieldColor(guiFactoryImpl.getCsProperty().get(string, null));
                } else if (string.equals("iscobol.gui.date_entry.cutoff")) {
                    this._2DigitsYearStart = guiFactoryImpl.getCsProperty().get("iscobol.gui.date_entry.cutoff", -1);
                    if (this.guiComponent != null) {
                        ((DateEntry)((Object)this.guiComponent)).set2DigitsYearStart(this._2DigitsYearStart);
                    }
                }
            }
        };
        guiFactoryImpl.getCsProperty().addPropertyChangeListener(this.pcListener);
    }

    @Override
    public void setColorBackgroundIdx(int n2) {
        boolean bl = this.backgroundSet;
        super.setColorBackgroundIdx(n2);
        boolean bl2 = this.backgroundSet = this.getBackground() != null;
        if (bl != this.backgroundSet) {
            this.setDisabledFieldColor(this.disabledFieldColor);
        }
    }

    @Override
    public void setColorBackground(int n2, int n3, int n4) {
        boolean bl = this.backgroundSet;
        super.setColorBackground(n2, n3, n4);
        boolean bl2 = this.backgroundSet = this.getBackground() != null;
        if (bl != this.backgroundSet) {
            this.setDisabledFieldColor(this.disabledFieldColor);
        }
    }

    @Override
    public void setColorForegroundIdx(int n2) {
        boolean bl = this.foregroundSet;
        super.setColorForegroundIdx(n2);
        boolean bl2 = this.foregroundSet = this.getForeground() != null;
        if (bl != this.foregroundSet) {
            this.setDisabledFieldColor(this.disabledFieldColor);
        }
    }

    @Override
    public void setColorForeground(int n2, int n3, int n4) {
        boolean bl = this.foregroundSet;
        super.setColorForeground(n2, n3, n4);
        boolean bl2 = this.foregroundSet = this.getForeground() != null;
        if (bl != this.foregroundSet) {
            this.setDisabledFieldColor(this.disabledFieldColor);
        }
    }

    private void setDisabledFieldColor(String string) {
        this.disabledFieldColor = string;
        if (this.guiComponent != null) {
            boolean[] blArray = new boolean[1];
            Color[] colorArray = this.getFieldColors(this.disabledFieldColor, blArray);
            DateEntry dateEntry = (DateEntry)((Object)this.guiComponent);
            if (blArray[0] || !this.backgroundSet) {
                dateEntry.setDisabledBackground(colorArray[0]);
            } else {
                dateEntry.setDisabledBackground(null);
            }
            if (blArray[0] || !this.foregroundSet) {
                dateEntry.setDisabledForeground(colorArray[1]);
            } else {
                dateEntry.setDisabledForeground(null);
            }
        }
    }

    @Override
    public void displayProp() {
    }

    @Override
    public float getDefaultHeight() {
        return 1.4f;
    }

    @Override
    public float getDefaultWidth() {
        return 9.0f;
    }

    @Override
    public int getGUIControlHeight(float f2) {
        if (this.font != null) {
            return (int)((float)this.font.getHeight() * f2);
        }
        return 20;
    }

    @Override
    protected boolean requestFocusLostComponent(RemoteBaseGUIControl remoteBaseGUIControl, MouseEvent mouseEvent, RemoteRecordAccept remoteRecordAccept) {
        return remoteBaseGUIControl != null && remoteBaseGUIControl.isSelfAct() || remoteBaseGUIControl == this || this.check(remoteBaseGUIControl);
    }

    private boolean check(RemoteBaseGUIControl remoteBaseGUIControl) {
        if (this.validateDate) {
            String string = ((PicobolDateEntry)this.guiComponent).getText();
            String string2 = ((PicobolDateEntry)this.guiComponent).getEmptyMaskPattern();
            if (string2 == null) {
                string2 = "";
            }
            if (!this.allowEmptyStyle || !string.equals(string2)) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.getDateFormat());
                simpleDateFormat.setLenient(false);
                Date date = null;
                try {
                    date = simpleDateFormat.parse(string, new ParsePosition(0));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (date == null) {
                    if (remoteBaseGUIControl != null) {
                        remoteBaseGUIControl.skipNextEvent();
                    }
                    JOptionPane.showMessageDialog(null, this.validateErrMsg, Factory.getSysMsg("de_error_msg_title"), 0);
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int getGUIControlWidth(float f2) {
        if (this.font != null) {
            return (int)((float)this.font.getWidth() * f2) + 50;
        }
        return 200;
    }

    @Override
    public String getProp(int n2) {
        switch (n2) {
            case 244: {
                return Integer.toString(this.getValueFormat());
            }
            case 65: {
                if (this.decBackColorCmp != null) {
                    return Integer.toString(this.decBackColorIdx >= 0 ? this.decBackColorIdx : this.decBackColorCmp.getForeground());
                }
                return null;
            }
            case 230: {
                if (this.sunForeColorCmp != null) {
                    return Integer.toString(this.sunForeColorIdx >= 0 ? this.sunForeColorIdx : this.sunForeColorCmp.getForeground());
                }
                return null;
            }
            case 248: {
                if (this.wdForeColorCmp != null) {
                    return Integer.toString(this.wdForeColorIdx >= 0 ? this.wdForeColorIdx : this.wdForeColorCmp.getForeground());
                }
                return null;
            }
            case 152: {
                if (this.minVal != null) {
                    return this.date2String(this.minVal);
                }
                return null;
            }
            case 148: {
                if (this.maxVal != null) {
                    return this.date2String(this.maxVal);
                }
                return null;
            }
            case 420: {
                if (this.illegalDateVal != null) {
                    return this.date2String(this.illegalDateVal);
                }
                return null;
            }
            case 325: {
                if (this.borderColorCmp == null) break;
                return Integer.toString(this.borderColorIdx >= 0 ? this.borderColorIdx : this.borderColorCmp.getForeground());
            }
        }
        return super.getProp(n2);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        RemoteBaseGUIControl remoteBaseGUIControl = null;
        RemoteDisplayWindow remoteDisplayWindow = (RemoteDisplayWindow)this.parentWindow;
        if (remoteDisplayWindow != null) {
            remoteBaseGUIControl = (RemoteBaseGUIControl)remoteDisplayWindow.getPreviousFocusOwner();
        }
        if (!(!this.isControlEditor() && remoteBaseGUIControl == this || this.getActiveAccept() || this.isSelfAct() || this.parentWindow == null || this.isExcludedEvent(3))) {
            this.parentWindow.setCmdGotoSent(true, this);
            this.bufferedOutAcceptEvent(new OutAcceptEvent(mouseEvent), false);
            return;
        }
        this.guiComponent.requestFocusInWindow();
        super.mousePressed(mouseEvent);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        PicobolDateEntry picobolDateEntry = (PicobolDateEntry)this.guiComponent;
        switch (keyEvent.getKeyCode()) {
            case 115: {
                if (this.noF4Style) break;
                picobolDateEntry.showPopup();
                return;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                return;
            }
            case 67: 
            case 86: 
            case 88: 
            case 89: 
            case 90: {
                if (!keyEvent.isControlDown() || !this.defaultShortcutsEnabled) break;
                return;
            }
        }
        super.keyPressed(keyEvent);
    }

    @Override
    public void initialize() {
        if (this.guiComponent != null) {
            return;
        }
        String string = this.getDateFormat();
        this.guiComponent = new PicobolDateEntry(this.numericStyle ? 1 : 0, string);
        super.intInitialize();
        PicobolDateEntry picobolDateEntry = (PicobolDateEntry)this.guiComponent;
        picobolDateEntry.setDefaultShortcutsEnabled(this.defaultShortcutsEnabled);
        if (this.name != null) {
            picobolDateEntry.setName(this.name);
        }
        picobolDateEntry.addOutAcceptListener(this);
        picobolDateEntry.setDateEntryListener(this);
        picobolDateEntry.setAllowEmpty(this.allowEmptyStyle);
        picobolDateEntry.set2DigitsYearStart(this._2DigitsYearStart);
        if (this.calendarFont != null) {
            picobolDateEntry.setCalendarFont(this.calendarFont.getFont());
        }
        if (this.numericStyle) {
            this.setDateFormat0(picobolDateEntry, string);
        } else {
            this.setDateFormat(picobolDateEntry, string);
        }
        if (this.rightAlignStyle) {
            picobolDateEntry.setRightAlignment(this.rightAlignStyle);
        }
        if (this.showNoneStyle) {
            picobolDateEntry.setShowNone(this.showNoneStyle);
        }
        if (this.value == null && !this.allowEmptyStyle) {
            if (this.valueStr != null && this.valueStr.length() == this.valueStr.trim().length()) {
                this.setValue(this.valueStr);
            } else {
                this.value = this.getInitialValue();
            }
        }
        picobolDateEntry.setDate(this.value);
        if (this.maxVal != null) {
            picobolDateEntry.setMaxSelectableDate(this.maxVal);
        }
        if (this.minVal != null) {
            picobolDateEntry.setMinSelectableDate(this.minVal);
        }
        if (this.illegalDateVal != null) {
            picobolDateEntry.setIllegalDate(this.illegalDateVal);
        }
        if (this.decBackColor != null) {
            picobolDateEntry.getJCalendar().setDecorationBackgroundColor(this.decBackColor);
        }
        if (this.sunForeColor != null) {
            picobolDateEntry.getJCalendar().setSundayForeground(this.sunForeColor);
        }
        if (this.wdForeColor != null) {
            picobolDateEntry.getJCalendar().setWeekdayForeground(this.wdForeColor);
        }
        if (!this.decBackVisibleStyle) {
            picobolDateEntry.getJCalendar().setDecorationBackgroundVisible(this.decBackVisibleStyle);
        }
        if (this.decBordersVisibleStyle) {
            picobolDateEntry.getJCalendar().setDecorationBordersVisible(this.decBordersVisibleStyle);
        }
        if (!this.weekOfYearVisibleStyle) {
            picobolDateEntry.getJCalendar().setWeekOfYearVisible(this.weekOfYearVisibleStyle);
        }
        picobolDateEntry.setReadOnly(this.readOnlyStyle);
        if (this.maxDayChars >= 0) {
            picobolDateEntry.getJCalendar().setMaxDayCharacters(this.maxDayChars);
        }
        picobolDateEntry.addKeyListener(this);
        picobolDateEntry.setChangeListener(this);
        if (this.valueStr != null) {
            this.setValue(this.valueStr);
        } else {
            picobolDateEntry.setShowNoneChecked(true);
        }
        this.guiComponent.setSelfAct(this.selfAct);
        this.setDisabledFieldColor(this.disabledFieldColor);
        this.setBoxedStyle();
    }

    private void setDateFormat(PicobolDateEntry picobolDateEntry, String string) {
        if (picobolDateEntry == null) {
            return;
        }
        this.setDateFormat0(picobolDateEntry, string);
        picobolDateEntry.setDateFormatString(string);
        if (this.tooltipText != null) {
            picobolDateEntry.setToolTipText(this.tooltipText);
        }
    }

    private void setDateFormat0(PicobolDateEntry picobolDateEntry, String string) {
        if (picobolDateEntry == null) {
            return;
        }
        picobolDateEntry.getCalendarButton().setVisible(!this.timeStyle);
    }

    private String getDateFormat() {
        if (this.displayFormat != null) {
            return this.displayFormat;
        }
        if (this.timeStyle) {
            return this.getTimeStyleFormat();
        }
        if (this.centuryDateStyle) {
            return this.getCenturyDateStyleFormat();
        }
        if (this.longDateStyle) {
            return this.getLongDateStyleFormat();
        }
        return this.getShortDateStyleFormat();
    }

    @Override
    public boolean isSelfAct() {
        return false;
    }

    @Override
    public void setBorder(boolean bl) {
    }

    @Override
    public void setElementAt(int[] nArray) {
    }

    @Override
    public void setImage(int n2, int n3, int n4, int n5) {
        Rectangle rectangle = this.getBounds();
        n2 = rectangle.width;
        n3 = rectangle.height;
        if (n2 != 0) {
            this.image = this.getLocalImage(n4);
            this.bitmapHeight = n3;
            PicobolDateEntry picobolDateEntry = (PicobolDateEntry)this.guiComponent;
            if (picobolDateEntry != null && this.image != null) {
                picobolDateEntry.setIcon(this.getIcon(this.bitmapNumber));
            }
        }
    }

    @Override
    public String setProp(Integer n2, String string, int n3) {
        String string2 = "0";
        int n4 = -1;
        boolean bl = false;
        try {
            n4 = (int)Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            bl = true;
        }
        boolean bl2 = false;
        PicobolDateEntry picobolDateEntry = (PicobolDateEntry)this.guiComponent;
        switch (n2) {
            case 420: {
                this.illegalDateVal = this.string2Date(string);
                if (picobolDateEntry == null) break;
                picobolDateEntry.setIllegalDate(this.illegalDateVal);
                break;
            }
            case 68: {
                String string3 = null;
                if (this.displayFormat != null && !this.displayFormat.equals(string.trim())) {
                    string3 = this.getValue();
                }
                this.displayFormat = string.trim();
                if (!this.numericStyle) {
                    this.setDateFormat(picobolDateEntry, this.getDateFormat());
                }
                if (string3 != null) {
                    this.setValue(string3);
                }
                string2 = "1";
                break;
            }
            case 244: {
                if (bl) break;
                this.valueFormat = n4;
                if (this.valueStr != null) {
                    this.setValue(this.valueStr);
                }
                string2 = "1";
                break;
            }
            case 25: {
                if (bl) break;
                this.calendarFont = (LocalFontCmp)this.gf.getClient().getId(n4);
                if (this.calendarFont != null && picobolDateEntry != null) {
                    picobolDateEntry.setCalendarFont(this.calendarFont.getFont());
                }
                string2 = "1";
                break;
            }
            case 20: {
                if (bl) break;
                this.bitmapWidth = n4;
                string2 = "1";
                break;
            }
            case 12: {
                if (bl) break;
                this.bitmapNumber = n4;
                if (picobolDateEntry != null && this.image != null) {
                    picobolDateEntry.setIcon(this.getIcon(this.bitmapNumber));
                }
                string2 = "1";
                break;
            }
            case 143: {
                if (bl) break;
                this.maxDayChars = n4;
                if (picobolDateEntry != null) {
                    picobolDateEntry.getJCalendar().setMaxDayCharacters(this.maxDayChars);
                }
                string2 = "1";
                break;
            }
            case 148: {
                this.maxVal = this.string2Date(string);
                if (picobolDateEntry == null) break;
                picobolDateEntry.setMaxSelectableDate(this.maxVal);
                break;
            }
            case 152: {
                this.minVal = this.string2Date(string);
                if (picobolDateEntry == null) break;
                picobolDateEntry.setMinSelectableDate(this.minVal);
                break;
            }
            case 65: 
            case 66: {
                bl2 = n2.equals(ParamsValues.getParamValue("DECORATION-BACKGROUND-RGB"));
                if (n4 < 0 || bl2) {
                    this.decBackColorCmp = new ColorCmp(true);
                    this.decBackColorIdx = -1;
                    this.decBackColorCmp.setForeRGB(n4);
                    this.decBackColor = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(this.decBackColorCmp.getForeground(), false));
                } else {
                    this.decBackColorCmp = new ColorCmp(n4);
                    this.decBackColorIdx = n4;
                    this.decBackColor = this.gf.getRemotePalette().getDefaultColor(this.decBackColorCmp.getForeground());
                }
                if (picobolDateEntry == null || this.decBackColor == null) break;
                picobolDateEntry.getJCalendar().setDecorationBackgroundColor(this.decBackColor);
                break;
            }
            case 230: 
            case 231: {
                bl2 = n2.equals(ParamsValues.getParamValue("SUNDAY-FOREGROUND-RGB"));
                if (n4 < 0 || bl2) {
                    this.sunForeColorCmp = new ColorCmp(true);
                    this.sunForeColorIdx = -1;
                    this.sunForeColorCmp.setForeRGB(n4);
                    this.sunForeColor = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(this.sunForeColorCmp.getForeground(), false));
                } else {
                    this.sunForeColorCmp = new ColorCmp(n4);
                    this.sunForeColorIdx = n4;
                    this.sunForeColor = this.gf.getRemotePalette().getDefaultColor(this.sunForeColorCmp.getForeground());
                }
                if (picobolDateEntry == null || this.sunForeColor == null) break;
                picobolDateEntry.getJCalendar().setSundayForeground(this.sunForeColor);
                break;
            }
            case 248: 
            case 249: {
                bl2 = n2.equals(ParamsValues.getParamValue("WEEKDAY-FOREGROUND-RGB"));
                if (n4 < 0 || bl2) {
                    this.wdForeColorCmp = new ColorCmp(true);
                    this.wdForeColorIdx = -1;
                    this.wdForeColorCmp.setForeRGB(n4);
                    this.wdForeColor = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(this.wdForeColorCmp.getForeground(), false));
                } else {
                    this.wdForeColorCmp = new ColorCmp(n4);
                    this.wdForeColorIdx = n4;
                    this.wdForeColor = this.gf.getRemotePalette().getDefaultColor(this.wdForeColorCmp.getForeground());
                }
                if (picobolDateEntry == null || this.wdForeColor == null) break;
                picobolDateEntry.getJCalendar().setWeekdayForeground(this.wdForeColor);
                break;
            }
            case 253: {
                this.guiComponent.requestFocusInWindow();
                new IsguiWorker(false, () -> ((DateEntry)((Object)this.guiComponent)).showPopup()).start();
                break;
            }
            case 254: {
                if (this.newDate == null || this.guiComponent == null) break;
                this.value = this.newDate;
                ((DateEntry)((Object)this.guiComponent)).setDate(this.newDate);
                if (!this.notifyChangeStyle) break;
                CobolEventCouple cobolEventCouple = new CobolEventCouple(this, new RemoteRecordAccept(6, 96, 4100, true, true, true));
                this.pushEvent(cobolEventCouple);
                break;
            }
            case 325: 
            case 326: {
                bl2 = n2.equals(ParamsValues.getParamValue("BORDER-COLOR-RGB"));
                if (n4 < 0 || bl2) {
                    this.borderColorCmp = new ColorCmp(true);
                    this.borderColorIdx = -1;
                    this.borderColorCmp.setForeRGB(n4);
                    this.borderColor = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(this.borderColorCmp.getForeground(), false));
                } else {
                    this.borderColorCmp = new ColorCmp(n4);
                    this.borderColorIdx = n4;
                    this.borderColor = this.gf.getRemotePalette().getDefaultColor(this.borderColorCmp.getForeground());
                }
                this.setBoxedStyle();
                break;
            }
            case 374: {
                this.handleBorderWidths(string);
                this.setBoxedStyle();
            }
        }
        return super.setProp(n2, string, n3);
    }

    private ImageIcon getIcon(int n2) {
        if (n2 > 0) {
            Image image = ScreenUtility.getImage(this.bitmapWidth, this.bitmapHeight, this.image, n2);
            if (image != null) {
                return new ImageIcon(image);
            }
            return null;
        }
        return null;
    }

    @Override
    public void setRowsCols(float f2, float f3) {
    }

    public String getTimeStyleFormat() {
        return this.timeStyleFormat;
    }

    public void setTimeStyleFormat(String string) {
        this.timeStyleFormat = string;
    }

    public String getShortDateStyleFormat() {
        return this.shortDateStyleFormat;
    }

    public void setShortDateStyleFormat(String string) {
        this.shortDateStyleFormat = string;
    }

    public String getCenturyDateStyleFormat() {
        return this.centuryDateStyleFormat;
    }

    public void setCenturyDateStyleFormat(String string) {
        this.centuryDateStyleFormat = string;
    }

    public String getLongDateStyleFormat() {
        return this.longDateStyleFormat;
    }

    public void setLongDateStyleFormat(String string) {
        this.longDateStyleFormat = string;
    }

    @Override
    public void setStyle(int n2, boolean bl) {
        PicobolDateEntry picobolDateEntry = (PicobolDateEntry)this.guiComponent;
        if ((n2 & 0x400000) == 0x400000) {
            this.selfAct = bl;
            if (this.getComponent() != null) {
                this.getComponent().setSelfAct(bl);
            }
        }
        if ((n2 & 4) == 4) {
            this.noF4Style = bl;
        }
        if ((n2 & 0x8000) == 32768) {
            this.notifyChangeStyle = bl;
        }
        if ((n2 & 0x10) == 16) {
            this.rightAlignStyle = bl;
            if (picobolDateEntry != null) {
                picobolDateEntry.setRightAlignment(bl);
            }
        }
        if ((n2 & 0x20) == 32) {
            this.showNoneStyle = bl;
            if (picobolDateEntry != null) {
                picobolDateEntry.setShowNone(bl);
            }
        }
        if ((n2 & 3) == 3) {
            this.timeStyle = bl;
            if (!this.numericStyle) {
                this.setDateFormat(picobolDateEntry, this.getDateFormat());
            }
        } else {
            if ((n2 & 2) == 2) {
                this.longDateStyle = bl;
                if (!this.numericStyle) {
                    this.setDateFormat(picobolDateEntry, this.getDateFormat());
                }
            }
            if ((n2 & 1) == 1) {
                this.centuryDateStyle = bl;
                if (!this.numericStyle) {
                    this.setDateFormat(picobolDateEntry, this.getDateFormat());
                }
            }
            if (!(this.longDateStyle || this.centuryDateStyle || this.numericStyle)) {
                this.setDateFormat(picobolDateEntry, this.getDateFormat());
            }
        }
        if ((n2 & 0x40) == 64) {
            this.decBackVisibleStyle = bl;
            if (picobolDateEntry != null) {
                picobolDateEntry.getJCalendar().setDecorationBackgroundVisible(this.decBackVisibleStyle);
            }
        }
        if ((n2 & 0x80) == 128) {
            this.decBordersVisibleStyle = bl;
            if (picobolDateEntry != null) {
                picobolDateEntry.getJCalendar().setDecorationBordersVisible(this.decBordersVisibleStyle);
            }
        }
        if ((n2 & 0x100) == 256) {
            this.weekOfYearVisibleStyle = bl;
            if (picobolDateEntry != null) {
                picobolDateEntry.getJCalendar().setWeekOfYearVisible(this.weekOfYearVisibleStyle);
            }
        }
        if ((n2 & 0x200) == 512) {
            this.noautoselStyle = bl;
        }
        if ((n2 & 0x20000) == 131072) {
            this.numericStyle = bl;
        }
        if ((n2 & 0x400) == 1024) {
            this.allowEmptyStyle = bl;
        }
        if ((n2 & 0x80000) == 524288) {
            this.readOnlyStyle = bl;
            if (picobolDateEntry != null) {
                picobolDateEntry.setReadOnly(this.readOnlyStyle);
            }
        }
    }

    @Override
    public void setTitle(String string) {
    }

    @Override
    public String getTitle() {
        return null;
    }

    private String zeroPad(int n2, String string) {
        int n3 = n2 - string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            string = "0" + string;
        }
        return string;
    }

    @Override
    public String getValue() {
        String string;
        if (this.guiComponent != null) {
            PicobolDateEntry picobolDateEntry = (PicobolDateEntry)this.guiComponent;
            if (!picobolDateEntry.isShowNoneChecked()) {
                string = this.timeStyle ? "9" : "0";
            } else {
                Date[] dateArray = new Date[1];
                new SwingWorker(true, () -> {
                    dateArray[0] = picobolDateEntry.getDate();
                }).start();
                this.value = dateArray[0];
                string = this.date2String(this.value);
            }
        } else {
            string = this.date2String(this.value);
        }
        return string;
    }

    private String date2String(Date date) {
        if (date == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        int n2 = this.getValueFormat();
        switch (n2) {
            case 0: {
                stringBuffer.append(this.zeroPad(4, Integer.toString(gregorianCalendar.get(1))));
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(2) + 1)));
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(5))));
                break;
            }
            case 1: {
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(1) % 100)));
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(2) + 1)));
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(5))));
                break;
            }
            case 4: {
                stringBuffer.append(this.zeroPad(4, Integer.toString(gregorianCalendar.get(1))));
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(2) + 1)));
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(5))));
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(11))));
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(12))));
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(13))));
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(14) / 10)));
                break;
            }
            case 5: {
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(2) + 1)));
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(5))));
                stringBuffer.append(this.zeroPad(4, Integer.toString(gregorianCalendar.get(1))));
                break;
            }
            case 6: {
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(2) + 1)));
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(5))));
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(1) % 100)));
                break;
            }
            case 7: {
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(2) + 1)));
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(5))));
                stringBuffer.append(this.zeroPad(4, Integer.toString(gregorianCalendar.get(1))));
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(11))));
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(12))));
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(13))));
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(14) / 10)));
                break;
            }
            case 8: {
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(5))));
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(2) + 1)));
                stringBuffer.append(this.zeroPad(4, Integer.toString(gregorianCalendar.get(1))));
                break;
            }
            case 9: {
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(5))));
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(2) + 1)));
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(1) % 100)));
                break;
            }
            case 10: {
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(5))));
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(2) + 1)));
                stringBuffer.append(this.zeroPad(4, Integer.toString(gregorianCalendar.get(1))));
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(11))));
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(12))));
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(13))));
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(14) / 10)));
                break;
            }
            case 2: {
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(11))));
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(12))));
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(13))));
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(14) / 10)));
                break;
            }
            case 3: {
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(11))));
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(12))));
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(13))));
                break;
            }
            case 11: {
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(11))));
                stringBuffer.append(this.zeroPad(2, Integer.toString(gregorianCalendar.get(12))));
            }
        }
        return stringBuffer.toString();
    }

    private int getValueFormat() {
        int n2 = this.valueFormat;
        if (n2 == -1) {
            n2 = this.timeStyle ? 3 : 0;
        }
        return n2;
    }

    private Date string2Date(String string) {
        String string2 = ScreenUtility.rightTrim(string);
        if (string2 != null) {
            string2 = string2.replaceAll("\\D", "");
        }
        Date date = null;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        long l2 = 0L;
        if (string2 != null) {
            try {
                l2 = Long.parseLong(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (l2 == 0L && !this.timeStyle) {
            if (this.allowEmptyStyle) {
                return null;
            }
            return gregorianCalendar.getTime();
        }
        int n2 = gregorianCalendar.get(1);
        gregorianCalendar.set(1, 0);
        gregorianCalendar.set(2, 0);
        gregorianCalendar.set(5, 0);
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        int n3 = this.getValueFormat();
        try {
            switch (n3) {
                case 0: {
                    string2 = this.adjustLen(string2, 8);
                    gregorianCalendar.set(1, Integer.parseInt(string2.substring(0, 4)));
                    gregorianCalendar.set(2, Integer.parseInt(string2.substring(4, 6)) - 1);
                    gregorianCalendar.set(5, Integer.parseInt(string2.substring(6, 8)));
                    date = gregorianCalendar.getTime();
                    break;
                }
                case 5: {
                    string2 = this.adjustLen(string2, 8);
                    gregorianCalendar.set(2, Integer.parseInt(string2.substring(0, 2)) - 1);
                    gregorianCalendar.set(5, Integer.parseInt(string2.substring(2, 4)));
                    gregorianCalendar.set(1, Integer.parseInt(string2.substring(4, 8)));
                    date = gregorianCalendar.getTime();
                    break;
                }
                case 8: {
                    string2 = this.adjustLen(string2, 8);
                    gregorianCalendar.set(5, Integer.parseInt(string2.substring(0, 2)));
                    gregorianCalendar.set(2, Integer.parseInt(string2.substring(2, 4)) - 1);
                    gregorianCalendar.set(1, Integer.parseInt(string2.substring(4, 8)));
                    date = gregorianCalendar.getTime();
                    break;
                }
                case 1: {
                    string2 = this.adjustLen(string2, 6);
                    gregorianCalendar.set(1, n2 - n2 % 100 + Integer.parseInt(string2.substring(0, 2)));
                    gregorianCalendar.set(2, Integer.parseInt(string2.substring(2, 4)) - 1);
                    gregorianCalendar.set(5, Integer.parseInt(string2.substring(4, 6)));
                    date = gregorianCalendar.getTime();
                    break;
                }
                case 6: {
                    string2 = this.adjustLen(string2, 6);
                    gregorianCalendar.set(2, Integer.parseInt(string2.substring(0, 2)) - 1);
                    gregorianCalendar.set(5, Integer.parseInt(string2.substring(2, 4)));
                    gregorianCalendar.set(1, n2 - n2 % 100 + Integer.parseInt(string2.substring(4, 6)));
                    date = gregorianCalendar.getTime();
                    break;
                }
                case 9: {
                    string2 = this.adjustLen(string2, 6);
                    gregorianCalendar.set(5, Integer.parseInt(string2.substring(0, 2)));
                    gregorianCalendar.set(2, Integer.parseInt(string2.substring(2, 4)) - 1);
                    gregorianCalendar.set(1, n2 - n2 % 100 + Integer.parseInt(string2.substring(4, 6)));
                    date = gregorianCalendar.getTime();
                    break;
                }
                case 4: {
                    string2 = this.adjustLen(string2, 16);
                    gregorianCalendar.set(1, Integer.parseInt(string2.substring(0, 4)));
                    gregorianCalendar.set(2, Integer.parseInt(string2.substring(4, 6)) - 1);
                    gregorianCalendar.set(5, Integer.parseInt(string2.substring(6, 8)));
                    gregorianCalendar.set(11, Integer.parseInt(string2.substring(8, 10)));
                    gregorianCalendar.set(12, Integer.parseInt(string2.substring(10, 12)));
                    gregorianCalendar.set(13, Integer.parseInt(string2.substring(12, 14)));
                    gregorianCalendar.set(14, Integer.parseInt(string2.substring(14, 16)) * 10);
                    date = gregorianCalendar.getTime();
                    break;
                }
                case 7: {
                    string2 = this.adjustLen(string2, 16);
                    gregorianCalendar.set(2, Integer.parseInt(string2.substring(0, 2)) - 1);
                    gregorianCalendar.set(5, Integer.parseInt(string2.substring(2, 4)));
                    gregorianCalendar.set(1, Integer.parseInt(string2.substring(4, 8)));
                    gregorianCalendar.set(11, Integer.parseInt(string2.substring(8, 10)));
                    gregorianCalendar.set(12, Integer.parseInt(string2.substring(10, 12)));
                    gregorianCalendar.set(13, Integer.parseInt(string2.substring(12, 14)));
                    gregorianCalendar.set(14, Integer.parseInt(string2.substring(14, 16)) * 10);
                    date = gregorianCalendar.getTime();
                    break;
                }
                case 10: {
                    string2 = this.adjustLen(string2, 16);
                    gregorianCalendar.set(5, Integer.parseInt(string2.substring(0, 2)));
                    gregorianCalendar.set(2, Integer.parseInt(string2.substring(2, 4)) - 1);
                    gregorianCalendar.set(1, Integer.parseInt(string2.substring(4, 8)));
                    gregorianCalendar.set(11, Integer.parseInt(string2.substring(8, 10)));
                    gregorianCalendar.set(12, Integer.parseInt(string2.substring(10, 12)));
                    gregorianCalendar.set(13, Integer.parseInt(string2.substring(12, 14)));
                    gregorianCalendar.set(14, Integer.parseInt(string2.substring(14, 16)) * 10);
                    date = gregorianCalendar.getTime();
                    break;
                }
                case 2: {
                    string2 = this.adjustLen(string2, 8);
                    gregorianCalendar.set(11, Integer.parseInt(string2.substring(0, 2)));
                    gregorianCalendar.set(12, Integer.parseInt(string2.substring(2, 4)));
                    gregorianCalendar.set(13, Integer.parseInt(string2.substring(4, 6)));
                    gregorianCalendar.set(14, Integer.parseInt(string2.substring(6, 8)) * 10);
                    date = gregorianCalendar.getTime();
                    break;
                }
                case 3: {
                    string2 = this.adjustLen(string2, 6);
                    gregorianCalendar.set(11, Integer.parseInt(string2.substring(0, 2)));
                    gregorianCalendar.set(12, Integer.parseInt(string2.substring(2, 4)));
                    gregorianCalendar.set(13, Integer.parseInt(string2.substring(4, 6)));
                    date = gregorianCalendar.getTime();
                    break;
                }
                case 11: {
                    string2 = this.adjustLen(string2, 4);
                    gregorianCalendar.set(11, Integer.parseInt(string2.substring(0, 2)));
                    gregorianCalendar.set(12, Integer.parseInt(string2.substring(2, 4)));
                    date = gregorianCalendar.getTime();
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return date;
    }

    private boolean isAll(String string, char c2) {
        if (string == null) {
            return false;
        }
        char[] cArray = string.trim().toCharArray();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] == c2) continue;
            return false;
        }
        return true;
    }

    @Override
    public String setValue(String string) {
        if (string != null && string.trim().length() == 0) {
            string = null;
        }
        this.valueStr = string;
        PicobolDateEntry picobolDateEntry = (PicobolDateEntry)this.guiComponent;
        if (picobolDateEntry != null) {
            Date date;
            this.value = date = this.string2Date(string);
            if (this.isAll(string, '0') && !this.timeStyle || this.isAll(string, '9') && this.timeStyle) {
                picobolDateEntry.setShowNoneChecked(false);
                if (this.allowEmptyStyle) {
                    new SwingWorker(true, () -> picobolDateEntry.setDate(this.value)).start();
                }
            } else if (this.value != null) {
                new SwingWorker(true, () -> {
                    boolean bl = this.notifyChangeStyle;
                    this.notifyChangeStyle = false;
                    try {
                        picobolDateEntry.setDate(this.value);
                    }
                    finally {
                        this.notifyChangeStyle = bl;
                    }
                    picobolDateEntry.setShowNoneChecked(true);
                }).start();
            }
        }
        return string;
    }

    private Date getInitialValue() {
        Date date = null;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.set(1, 0);
        gregorianCalendar2.set(2, 0);
        gregorianCalendar2.set(5, 0);
        gregorianCalendar2.set(11, 0);
        gregorianCalendar2.set(12, 0);
        gregorianCalendar2.set(13, 0);
        gregorianCalendar2.set(14, 0);
        int n2 = this.getValueFormat();
        switch (n2) {
            case 4: 
            case 7: 
            case 10: {
                gregorianCalendar2.set(11, gregorianCalendar.get(11));
                gregorianCalendar2.set(12, gregorianCalendar.get(12));
                gregorianCalendar2.set(13, gregorianCalendar.get(13));
                gregorianCalendar2.set(14, gregorianCalendar.get(14));
            }
            case 0: 
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                gregorianCalendar2.set(1, gregorianCalendar.get(1));
                gregorianCalendar2.set(2, gregorianCalendar.get(2));
                gregorianCalendar2.set(5, gregorianCalendar.get(5));
                date = gregorianCalendar2.getTime();
                break;
            }
            case 2: {
                gregorianCalendar2.set(14, gregorianCalendar.get(14));
            }
            case 3: {
                gregorianCalendar2.set(13, gregorianCalendar.get(13));
            }
            case 11: {
                gregorianCalendar2.set(11, gregorianCalendar.get(11));
                gregorianCalendar2.set(12, gregorianCalendar.get(12));
                date = gregorianCalendar2.getTime();
            }
        }
        return date;
    }

    @Override
    public void destroy() {
        if (this.guiComponent != null) {
            ((DateEntry)((Object)this.guiComponent)).dispose();
        }
        if (this.gf != null && this.gf.getCsProperty() != null) {
            this.gf.getCsProperty().removePropertyChangeListener(this.pcListener);
        }
        super.destroy();
    }

    public void handleResponse(int n2, int n3) {
    }

    @Override
    public void handleResponse(int n2, RemoteRecordAccept remoteRecordAccept) {
        super.handleResponse(n2, remoteRecordAccept);
    }

    @Override
    public void setCols(float f2) {
    }

    @Override
    public void setRows(float f2) {
    }

    @Override
    public void intFocusGained(boolean bl) {
    }

    @Override
    public boolean isInputField() {
        return true;
    }

    @Override
    public void focusGained(CobolFocusEvent cobolFocusEvent) {
        if (!cobolFocusEvent.isGoto() && !this.isControlEditor()) {
            RemoteDisplayWindow remoteDisplayWindow = (RemoteDisplayWindow)this.parentWindow;
            if (this.guiComponent != null && !this.noautoselStyle && remoteDisplayWindow.getPreviousFocusOwner() != this) {
                PicobolDateEntry picobolDateEntry = (PicobolDateEntry)this.guiComponent;
                new SwingWorker(false, () -> picobolDateEntry.selectAll()).start();
            }
        }
        super.focusGained(cobolFocusEvent);
    }

    @Override
    public void popupWillBecameVisible(DateEntryEvent dateEntryEvent) throws DateEntryVetoException {
        RemoteDisplayWindow remoteDisplayWindow = (RemoteDisplayWindow)this.parentWindow;
        RemoteBaseGUIControl remoteBaseGUIControl = (RemoteBaseGUIControl)remoteDisplayWindow.getFocusOwner();
        if (remoteBaseGUIControl != this) {
            remoteDisplayWindow.setFocusOwner(this);
            CobolEventCouple cobolEventCouple = new CobolEventCouple(this, new RemoteRecordAccept(16, 23, 0));
            this.pushEvent(cobolEventCouple);
            throw new DateEntryVetoException();
        }
    }

    @Override
    public void stateWillChange(DateEntryEvent dateEntryEvent) throws DateEntryVetoException {
        RemoteDisplayWindow remoteDisplayWindow = (RemoteDisplayWindow)this.parentWindow;
        RemoteBaseGUIControl remoteBaseGUIControl = (RemoteBaseGUIControl)remoteDisplayWindow.getFocusOwner();
        if (remoteBaseGUIControl != this) {
            remoteDisplayWindow.setFocusOwner(this);
            this.newDate = dateEntryEvent.getNewDate();
            CobolEventCouple cobolEventCouple = new CobolEventCouple(this, new RemoteRecordAccept(16, 24, 0));
            this.pushEvent(cobolEventCouple);
            throw new DateEntryVetoException();
        }
    }

    private boolean equals(Date date, Date date2) {
        if (date != null) {
            if (date2 != null) {
                return date.equals(date2);
            }
            return false;
        }
        return date2 == null;
    }

    @Override
    public void stateChanged(DateEntryEvent dateEntryEvent) {
        if (this.guiComponent == null) {
            return;
        }
        DateEntry dateEntry = (DateEntry)((Object)this.guiComponent);
        if (dateEntryEvent.getSource() == dateEntry.getShowNoneButton()) {
            if (this.notifyChangeStyle) {
                this.pushNtfChangedEvent();
            }
        } else {
            Date date;
            if (!this.allowEmptyStyle || (date = dateEntryEvent.getNewDate()) == null) {
                date = dateEntry.getDate();
            }
            if (!this.equals(date, this.value)) {
                this.value = date;
                if (this.notifyChangeStyle) {
                    this.pushNtfChangedEvent();
                }
            }
        }
    }

    private void pushNtfChangedEvent() {
        CobolEventCouple cobolEventCouple = new CobolEventCouple(this, new RemoteRecordAccept(6, 96, 4100, true, true, true));
        this.pushEvent(cobolEventCouple);
    }

    @Override
    public String getType() {
        return "dateentry";
    }

    @Override
    public void endClearOutAcceptEvents() {
        PicobolDateEntry picobolDateEntry = (PicobolDateEntry)this.guiComponent;
        if (picobolDateEntry != null) {
            picobolDateEntry.hidePopup();
        }
    }

    private String adjustLen(String string, int n2) {
        if (string == null) {
            string = "";
        }
        if (n2 > string.length()) {
            return "0000000000000000".substring(0, n2 - string.length()) + string;
        }
        if (n2 < string.length()) {
            return string.substring(string.length() - n2);
        }
        return string;
    }

    public void setDate(Date date) {
        if (this.guiComponent != null) {
            PicobolDateEntry picobolDateEntry = (PicobolDateEntry)this.guiComponent;
            new SwingWorker(true, () -> picobolDateEntry.setDate(date)).start();
        }
    }

    protected String getTextFormatted() {
        String string = "";
        if (this.guiComponent != null) {
            try {
                PicobolDateEntry picobolDateEntry = (PicobolDateEntry)this.guiComponent;
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.getDateFormat());
                Date date = picobolDateEntry.getDate();
                string = date != null ? simpleDateFormat.format(date) : picobolDateEntry.getText();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return string;
    }

    @Override
    public void putEditorValue(String string) {
        if (this.guiComponent != null) {
            PicobolDateEntry picobolDateEntry = (PicobolDateEntry)this.guiComponent;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.getDateFormat());
            Date date = simpleDateFormat.parse(string, new ParsePosition(0));
            if (date == null) {
                date = this.getInitialValue();
            }
            if (date != null) {
                this.setDate(date);
                picobolDateEntry.getJCalendar().setDate(date);
            }
        }
    }

    @Override
    public void startCellEditing() {
        PicobolDateEntry picobolDateEntry = (PicobolDateEntry)this.guiComponent;
        if (picobolDateEntry != null) {
            picobolDateEntry.showPopup();
        }
    }

    @Override
    public RemoteBaseGUIControl renderClone() {
        return this.renderClone(false, null);
    }

    @Override
    public RemoteBaseGUIControl renderClone(boolean bl, Dimension dimension) {
        PicobolDateEntry picobolDateEntry = (PicobolDateEntry)this.guiComponent;
        picobolDateEntry.removeKeyListener(this);
        picobolDateEntry.setChangeListener(null);
        RemoteDateEntry remoteDateEntry = null;
        try {
            remoteDateEntry = (RemoteDateEntry)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        remoteDateEntry.setComponent(null);
        remoteDateEntry.controlinfo = 0;
        remoteDateEntry.initialize();
        if (this.value != null) {
            remoteDateEntry.value = (Date)this.value.clone();
        }
        if (this.maxVal != null) {
            remoteDateEntry.maxVal = (Date)this.maxVal.clone();
        }
        if (this.minVal != null) {
            remoteDateEntry.minVal = (Date)this.minVal.clone();
        }
        if (this.illegalDateVal != null) {
            remoteDateEntry.illegalDateVal = (Date)this.illegalDateVal.clone();
        }
        if (this.newDate != null) {
            remoteDateEntry.newDate = (Date)this.newDate.clone();
        }
        return remoteDateEntry;
    }

    @Override
    protected void addZoomLayoutDataFonts(ZoomLayout.ZoomLayoutData zoomLayoutData) {
        super.addZoomLayoutDataFonts(zoomLayoutData);
        zoomLayoutData.putAdditionalOrigFont(new ZoomLayout.FontProvider(){

            @Override
            public void setFont(Font font) {
                ((DateEntry)((Object)RemoteDateEntry.this.guiComponent)).setCalendarFont(font);
            }

            @Override
            public Font getFont() {
                return ((DateEntry)((Object)RemoteDateEntry.this.guiComponent)).getCalendarFont();
            }
        });
    }

    @Override
    public Rectangle getBoundsWithoutDefaultWidth() {
        Rectangle rectangle = super.getBounds();
        if (rectangle != null && rectangle.width > 0) {
            rectangle.width -= 50;
        }
        return rectangle;
    }

    protected void setBoxedStyle() {
        DateEntry dateEntry = (DateEntry)((Object)this.guiComponent);
        if (dateEntry != null) {
            Object var2_2 = null;
            if (this.borderWidths != null && this.borderWidths.size() > 0) {
                dateEntry.setBorderW(new MatteBorder(this.getBorder(0), this.getBorder(1), this.getBorder(2), this.getBorder(3), this.borderColor != null ? this.borderColor : Color.darkGray));
            }
        }
    }

    @Override
    public JComponent getDragDropComponent() {
        DateEntry dateEntry = (DateEntry)((Object)this.guiComponent);
        if (dateEntry != null) {
            return dateEntry.getDragDropComponent();
        }
        return null;
    }

    @Override
    public boolean isDnDStandard() {
        return true;
    }

    @Override
    public void initializeDnDStandard() {
        DateEntry dateEntry = (DateEntry)((Object)this.guiComponent);
        if (dateEntry != null) {
            if (this.dragmode > 0) {
                dateEntry.setDragComponent(this);
            } else {
                dateEntry.setDragComponent(null);
            }
        }
    }
}

