/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.Constants;
import com.iscobol.gui.Events;
import com.iscobol.gui.ParamElementWindowLocation;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.LocalFontCmp;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.MyToolBar;
import com.iscobol.gui.client.swing.PopupListener;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteBaseGUIWindow;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import com.iscobol.gui.client.swing.RemoteMenu;
import com.iscobol.gui.client.swing.SwingFontCmp;
import com.iscobol.gui.client.swing.SwingWorker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class RemoteDisplayToolBar
extends RemoteBaseGUIWindow
implements Constants {
    public MyToolBar toolPanel;
    protected float cellWidth = 1.0f;
    protected float cellHeight = 1.0f;
    protected int fontId = -1;
    protected LocalFontCmp font;
    private int toolHeight;
    private int foregroundIndex = -1;
    private int backgroundIndex = -1;
    private String tooltipText;
    private int parentWindowId;
    private RemoteDisplayWindow parentWindow;
    private PopupListener popupListener;
    private RemoteMenu popupMenu;
    private boolean multilineStyle;
    private final boolean nativeToolBar;

    public RemoteDisplayToolBar(Events events, GuiFactoryImpl guiFactoryImpl, int n2) {
        this(events, guiFactoryImpl, n2, false);
    }

    public RemoteDisplayToolBar(Events events, GuiFactoryImpl guiFactoryImpl, int n2, boolean bl) {
        super(guiFactoryImpl);
        this.parentWindowId = n2;
        this.parentWindow = (RemoteDisplayWindow)guiFactoryImpl.getClient().getId(this.parentWindowId);
        this.events = events;
        this.nativeToolBar = guiFactoryImpl.getCsProperty().get("iscobol.gui.tool_bar.native", true);
        this.toolPanel = this.createToolBar(bl);
        if (this.toolPanel instanceof JToolBar) {
            JToolBar jToolBar = (JToolBar)((Object)this.toolPanel);
            jToolBar.setFloatable(false);
            jToolBar.setRollover(true);
        }
    }

    private MyToolBar createToolBar(boolean bl) {
        JComponent jComponent = this.nativeToolBar ? new NativeToolBar(bl) : new PanelToolBar(bl);
        return jComponent;
    }

    public MyToolBar getMainPanel() {
        return this.toolPanel;
    }

    @Override
    public int setFont(String string, int n2, int n3) {
        if (this.font != null && LocalFontCmp.equals(this.font, string, n2, n3)) {
            return this.fontId;
        }
        this.font = new SwingFontCmp(this.gf, string, n2, (float)n3, false);
        this.fontId = this.gf.getClient().setId(this.font);
        this.setCellWidth(this.font.getWidth());
        this.setCellHeight(this.font.getHeight());
        if (this.toolPanel != null) {
            this.toolPanel.setFont(this.font.getFont());
        }
        return this.fontId;
    }

    @Override
    public void setFont(int n2) {
        LocalFontCmp localFontCmp = (LocalFontCmp)this.gf.getClient().getId(n2);
        if (this.font != null && this.font.equals(localFontCmp)) {
            return;
        }
        this.fontId = n2;
        this.font = localFontCmp;
        this.setCellWidth(this.font.getWidth());
        this.setCellHeight(this.font.getHeight());
        if (this.toolPanel != null) {
            this.toolPanel.setFont(this.font.getFont());
        }
    }

    @Override
    public void setSize(float f2, float f3) {
        this.toolHeight = (int)(f3 * (float)this.getCellHeight());
    }

    @Override
    public void add(int n2, int n3, RemoteBaseGUIControl remoteBaseGUIControl) {
        RemoteBaseGUIControl remoteBaseGUIControl2 = (RemoteBaseGUIControl)this.gf.getClient().getId(n2);
        if (this.toolPanel != null && remoteBaseGUIControl2 != null && remoteBaseGUIControl2.getComponent() != null) {
            remoteBaseGUIControl2.setParentToolbar(this);
            if (remoteBaseGUIControl2.isContainer()) {
                this.setStyle(302);
            }
            if (remoteBaseGUIControl == null || !remoteBaseGUIControl.isContainer()) {
                remoteBaseGUIControl2.setLocation(remoteBaseGUIControl2.getBounds().x, remoteBaseGUIControl2.getBounds().y);
                if (n3 >= 0 && n3 < this.toolPanel.getComponentCount()) {
                    this.toolPanel.add((Component)((Object)remoteBaseGUIControl2.getComponent()), n3);
                } else {
                    this.toolPanel.add((Component)((Object)remoteBaseGUIControl2.getComponent()));
                }
                if (remoteBaseGUIControl2.isContainer()) {
                    this.parentWindow.addtolayout(remoteBaseGUIControl2);
                } else if (this.getLayout() != null) {
                    this.addtolayout(remoteBaseGUIControl2);
                }
            } else {
                remoteBaseGUIControl2.setLocation(remoteBaseGUIControl2.getBounds().x, remoteBaseGUIControl2.getBounds().y);
                remoteBaseGUIControl.add(remoteBaseGUIControl2, n3, this.childGraphics);
                this.parentWindow.addtolayout(remoteBaseGUIControl2);
            }
            this.childGraphics.put(remoteBaseGUIControl2.getComponent(), remoteBaseGUIControl2);
        }
    }

    @Override
    public void add(int n2, RemoteBaseGUIControl remoteBaseGUIControl) {
        this.add(n2, -1, remoteBaseGUIControl);
    }

    @Override
    public void remove(int n2) {
        this.remove(n2, true);
    }

    @Override
    public void remove(int n2, boolean bl) {
        RemoteBaseGUIControl remoteBaseGUIControl = (RemoteBaseGUIControl)this.gf.getClient().getId(n2);
        if (this.toolPanel != null && remoteBaseGUIControl != null && remoteBaseGUIControl.getComponent() != null) {
            final Component component = (Component)((Object)remoteBaseGUIControl.getComponent());
            if (bl) {
                new SwingWorker(true){

                    @Override
                    public void launch() {
                        RemoteDisplayToolBar.this.toolPanel.remove(component);
                        RemoteDisplayToolBar.this.childGraphics.remove(component);
                    }
                }.start();
            } else {
                this.toolPanel.remove(component);
                this.childGraphics.remove(component);
            }
        }
    }

    @Override
    public void setBackground(int n2, int n3, int n4) {
        if (this.toolPanel != null) {
            Color color = new Color(n2, n4, n3);
            this.toolPanel.setBackground(color);
        }
    }

    @Override
    public void setBackgroundIdx(int n2) {
        Color color;
        if (this.toolPanel != null && (color = this.gf.getRemotePalette().getDefaultColor(n2)) != null) {
            this.backgroundIndex = n2;
            this.toolPanel.setBackground(color);
        }
    }

    @Override
    public void setForeground(int n2, int n3, int n4) {
        if (this.toolPanel != null) {
            Color color = new Color(n2, n4, n3);
            this.toolPanel.setForeground(color);
        }
    }

    @Override
    public void setForegroundIdx(int n2) {
        Color color;
        if (this.toolPanel != null && (color = this.gf.getRemotePalette().getDefaultColor(n2)) != null) {
            this.foregroundIndex = n2;
            this.toolPanel.setForeground(color);
        }
    }

    @Override
    public void setLocation(int n2, int n3) {
    }

    @Override
    public int getCellHeight() {
        if (this.cellHeight < 1.0f) {
            return 1;
        }
        return (int)this.cellHeight;
    }

    @Override
    public float getCellHeightF() {
        return this.cellHeight;
    }

    @Override
    public int getCellWidth() {
        if (this.cellWidth < 1.0f) {
            return 1;
        }
        return (int)this.cellWidth;
    }

    @Override
    public float getCellWidthF() {
        return this.cellWidth;
    }

    @Override
    public void setCellHeight(float f2) {
        if (f2 >= 1.0f) {
            this.cellHeight = f2;
        }
    }

    @Override
    public void setCellWidth(float f2) {
        if (f2 >= 1.0f) {
            this.cellWidth = f2;
        }
    }

    @Override
    public void setCellWidth(String string, int n2, int n3) {
        this.cellWidth = new SwingFontCmp(this.gf, string, n2, (float)n3, false).getWidth();
    }

    @Override
    public void setCellHeight(String string, int n2, int n3) {
        this.cellHeight = new SwingFontCmp(this.gf, string, n2, (float)n3, false).getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        if (this.childGraphics != null) {
            Hashtable hashtable = this.childGraphics;
            synchronized (hashtable) {
                Enumeration enumeration = this.childGraphics.elements();
                while (enumeration.hasMoreElements()) {
                    RemoteBaseGUIControl remoteBaseGUIControl = (RemoteBaseGUIControl)enumeration.nextElement();
                    remoteBaseGUIControl.destroy();
                }
            }
            this.childGraphics = null;
        }
        if (this.toolPanel != null && this.popupListener != null) {
            this.toolPanel.removeMouseListener(this.popupListener);
        }
        this.gf.getClient().delId(this.terminalDisplayGateId);
        if (this.gf != null && this.gf.getClient() != null) {
            this.gf.getClient().delId(this.theObject);
        }
        this.theObject = 0;
        this.superdestroy();
        this.events = null;
        this.parentWindow = null;
        this.popupMenu = null;
        this.popupListener = null;
        this.toolPanel = null;
        this.destroyed = true;
    }

    @Override
    public Color getBackground() {
        if (this.toolPanel != null) {
            return this.toolPanel.getBackground();
        }
        return null;
    }

    @Override
    public int getBackgroundIdx() {
        return this.backgroundIndex;
    }

    @Override
    public Rectangle getMainBounds() {
        if (this.parentWindow != null) {
            Point point = this.parentWindow.getMainWindow().getPanel().getLocationOnScreen();
            Point point2 = this.toolPanel.getLocationOnScreen();
            return new Rectangle(point2.x - point.x, point2.y - point.y, this.parentWindow.getBounds().width, this.toolHeight);
        }
        return null;
    }

    @Override
    public Rectangle getBounds() {
        if (this.toolPanel != null) {
            return this.toolPanel.getBounds(null);
        }
        return null;
    }

    @Override
    public boolean getBoxed() {
        return false;
    }

    @Override
    public int getFont() {
        return this.fontId;
    }

    @Override
    public Color getForeground() {
        if (this.toolPanel != null) {
            return this.toolPanel.getForeground();
        }
        return null;
    }

    @Override
    public int getForegroundIdx() {
        return this.foregroundIndex;
    }

    @Override
    public Insets getInsets() {
        return null;
    }

    public int getMenu() {
        return 0;
    }

    @Override
    public String getTitle() {
        return null;
    }

    @Override
    public boolean getWrap() {
        return false;
    }

    @Override
    public boolean isGraphical() {
        return true;
    }

    @Override
    public boolean isMainApplicationWindow() {
        return false;
    }

    @Override
    public void setActiveWindow(boolean bl) {
    }

    @Override
    public void setAutoResize(boolean bl) {
    }

    @Override
    public void setDefaultLocation(int n2) {
    }

    public void setMaxHeight(int n2) {
    }

    @Override
    public void setMaxLines(int n2) {
    }

    @Override
    public void setMaxSize(int n2) {
    }

    public void setMaxWidth(int n2) {
    }

    public void setMinHeight(int n2) {
    }

    @Override
    public void setMinLines(int n2) {
    }

    @Override
    public void setMinSize(int n2) {
    }

    public void setMinWidth(int n2) {
    }

    public void setOffsetToolbar(int n2) {
    }

    @Override
    public void setPopupArea() {
    }

    @Override
    public void setResizable(boolean bl) {
    }

    @Override
    public void setScroll(boolean bl) {
    }

    @Override
    public void setTitle(String string) {
    }

    @Override
    public void setTitlePosition(int n2) {
    }

    @Override
    public void setVisible(boolean bl) {
    }

    @Override
    public void setEnabled(boolean bl) {
    }

    @Override
    public void setWithSystemMenu(boolean bl) {
    }

    @Override
    public void toFront() {
    }

    public void handleResponse(int n2, int n3) {
    }

    @Override
    public void handleResponse(int n2, RemoteRecordAccept remoteRecordAccept) {
    }

    @Override
    public boolean isInitialized() {
        return this.toolPanel != null;
    }

    public int getToolBarHeight() {
        return this.toolHeight;
    }

    @Override
    public void setAction(float f2) {
        switch ((int)f2) {
            case 21: {
                break;
            }
            case 20: {
                break;
            }
            case 22: {
                break;
            }
        }
    }

    @Override
    public void setTitleBar(boolean bl) {
    }

    @Override
    public void setToolTipText(String string) {
        this.tooltipText = ScreenUtility.rightTrim(string);
        this.toolPanel.setToolTipText(this.tooltipText.length() > 0 ? this.tooltipText : null);
    }

    @Override
    public void setPopupMenu(RemoteMenu remoteMenu) {
        if (this.popupMenu != null) {
            this.popupMenu.setParentWindow(-1);
        }
        if (this.popupListener != null) {
            this.toolPanel.removeMouseListener(this.popupListener);
        }
        this.popupMenu = remoteMenu;
        if (this.popupMenu != null) {
            this.popupMenu.setParentWindow(this.parentWindow.getId());
            this.popupListener = new PopupListener(this, this.popupMenu);
            this.toolPanel.addMouseListener(this.popupListener);
        } else {
            this.popupListener = null;
        }
    }

    public int getParentWindowId() {
        return this.parentWindowId;
    }

    @Override
    public void paramsetLocation(ParamElementWindowLocation paramElementWindowLocation) {
    }

    @Override
    public void setStyle(int n2) {
        switch (n2) {
            case 154: {
                if (!(this.toolPanel instanceof JToolBar)) break;
                ((JToolBar)((Object)this.toolPanel)).setFloatable(true);
                break;
            }
            case 302: {
                this.multilineStyle = true;
            }
        }
    }

    @Override
    public void unsetStyle(int n2) {
        switch (n2) {
            case 154: {
                if (!(this.toolPanel instanceof JToolBar)) break;
                ((JToolBar)((Object)this.toolPanel)).setFloatable(false);
                break;
            }
            case 302: {
                this.multilineStyle = false;
            }
        }
    }

    public boolean isMultiline() {
        return this.multilineStyle;
    }

    @Override
    public int[] componentgetControlSamePosition(RemoteBaseGUIControl remoteBaseGUIControl) {
        return this.getControlSamePosition(remoteBaseGUIControl, (Container)((Object)this.toolPanel));
    }

    @Override
    public int[] componentsetErase(int n2, int n3, int n4, Color color, int[] nArray) {
        return this.setErase((Container)((Object)this.toolPanel), n2, n3, n4, color, nArray);
    }

    @Override
    public void setParentWindow(RemoteBaseGUIControl remoteBaseGUIControl, int n2) {
        remoteBaseGUIControl.setParentToolbar(this);
        remoteBaseGUIControl.setParentWindow(this.parentWindowId);
    }

    @Override
    public void setParentWindow(RemoteBaseGUIControl remoteBaseGUIControl) {
        remoteBaseGUIControl.setParentToolbar(this);
        remoteBaseGUIControl.setParentWindow(this.parentWindowId);
    }

    @Override
    protected void repaintTerminal(Component component) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Integer n2) {
        if (this.childGraphics != null && this.childGraphics.contains(n2)) {
            Hashtable hashtable = this.childGraphics;
            synchronized (hashtable) {
                this.childGraphics.remove(n2);
            }
        }
    }

    @Override
    public void addMnemonic(char c2, RemoteBaseGUIControl remoteBaseGUIControl) {
        if (this.parentWindow != null) {
            this.parentWindow.addMnemonic(c2, remoteBaseGUIControl);
        }
    }

    @Override
    public void removeMnemonic(RemoteBaseGUIControl remoteBaseGUIControl) {
        if (this.parentWindow != null) {
            this.parentWindow.removeMnemonic(remoteBaseGUIControl);
        }
    }

    @Override
    public boolean enableKeyboard() {
        boolean bl = true;
        if (this.parentWindow != null) {
            bl = this.parentWindow.enableKeyboard();
        }
        return bl;
    }

    @Override
    protected Container getPanel() {
        return (Container)((Object)this.toolPanel);
    }

    public RemoteDisplayWindow getParentWindowDT() {
        return this.parentWindow;
    }

    public void setId(int n2) {
        this.theObject = n2;
    }

    public int getId() {
        return this.theObject;
    }

    private class NativeToolBar
    extends JToolBar
    implements MyToolBar {
        private static final long serialVersionUID = 1L;
        private final boolean ribbonContainer;

        NativeToolBar(boolean bl) {
            this.ribbonContainer = bl;
            if (!this.ribbonContainer) {
                super.setLayout(null);
            }
        }

        @Override
        public void updateUI() {
            LayoutManager layoutManager = super.getLayout();
            super.updateUI();
            super.setLayout(layoutManager);
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.ribbonContainer) {
                return super.getPreferredSize();
            }
            return this.getSize();
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            RemoteDisplayToolBar.this.gradientMgr.paint((Graphics2D)graphics, new Rectangle(0, 1, this.getWidth(), this.getHeight() - 2));
            if (!this.ribbonContainer) {
                graphics.setColor(Color.black);
                graphics.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, this.getHeight() - 1);
            }
        }
    }

    private class PanelToolBar
    extends JPanel
    implements MyToolBar {
        private static final long serialVersionUID = 1L;
        private final boolean ribbonContainer;

        PanelToolBar(boolean bl) {
            this.ribbonContainer = bl;
            if (!this.ribbonContainer) {
                super.setLayout(null);
            }
            RemoteDisplayToolBar.this.gradientMgr.addPropertyChangeListener(propertyChangeEvent -> this.repaint());
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.ribbonContainer) {
                return super.getPreferredSize();
            }
            return this.getSize();
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            RemoteDisplayToolBar.this.gradientMgr.paint((Graphics2D)graphics, new Rectangle(0, 1, this.getWidth(), this.getHeight() - 2));
            if (!this.ribbonContainer) {
                graphics.setColor(Color.black);
                graphics.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, this.getHeight() - 1);
            }
        }
    }
}

