/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.CobolFocusEvent;
import com.iscobol.gui.CobolFocusable;
import com.iscobol.gui.ColorCmp;
import com.iscobol.gui.IsguiUtility;
import com.iscobol.gui.IsguiWorker;
import com.iscobol.gui.ParamElementSize;
import com.iscobol.gui.ParamElementString;
import com.iscobol.gui.ParamVector;
import com.iscobol.gui.ParamsValues;
import com.iscobol.gui.PicobolTextEvent;
import com.iscobol.gui.PicobolTextListener;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.VirtualKeyboard;
import com.iscobol.gui.client.LocalFontCmp;
import com.iscobol.gui.client.spellchecker.SpellChecker;
import com.iscobol.gui.client.swing.CobolEventCouple;
import com.iscobol.gui.client.swing.EntryField;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.MsgBoxEvent;
import com.iscobol.gui.client.swing.OutAcceptEvent;
import com.iscobol.gui.client.swing.PicobolEntryField;
import com.iscobol.gui.client.swing.PopupListener;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import com.iscobol.gui.client.swing.RemoteGrid;
import com.iscobol.gui.client.swing.SwingFontCmp;
import com.iscobol.gui.client.swing.SwingWorker;
import com.iscobol.rts.Factory;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeListener;

public class RemoteEntryField
extends RemoteBaseGUIControl {
    private static final int DEFAULT_WIDTH_INSETS = 10;
    private static final int DEFAULT_HEIGHT_INSETS = 6;
    private static final int DEFAULT_SCROLLBAR_INSETS = 3;
    private static final int DEFAULT_ALIGNMENT = 2;
    public static final int ORIENTATION_NONE = 0;
    public static final int ORIENTATION_LEFT_TO_RIGHT = 1;
    public static final int ORIENTATION_RIGHT_TO_LEFT = 2;
    private static Comparator<String> ignoreCaseComparator = (string, string2) -> string.compareToIgnoreCase((String)string2);
    private boolean noWrap;
    private boolean multiline;
    private int textWrapping;
    private boolean isNumeric;
    private int autoDecimal;
    private boolean autoTermination;
    private boolean notifyChange;
    private boolean lower;
    private boolean upper;
    private boolean useReturn;
    private boolean useTab;
    private boolean readOnly;
    private boolean secure;
    private boolean noautosel;
    private boolean spinner;
    private boolean autoSpin;
    private boolean boxed;
    private boolean noBox;
    private boolean _3d;
    private boolean required;
    private boolean valueMultiple;
    private PicobolTextListener textListener;
    protected int maxText = -1;
    private int maxLines;
    private int cursorPos;
    private int cursorRowPos;
    private int cursorColPos;
    private int selStart;
    private int selStartRow;
    private int selStartCol;
    private int textOrientation = 0;
    private String selectionText = "";
    private float rows;
    private float cols;
    private boolean hasVScrollbar;
    private String textValue = "";
    private int action;
    private int alignment = 2;
    private int maxValue;
    private int minValue;
    private String formatString;
    private char fillChar = (char)32;
    private int formatType;
    protected int widthInset;
    protected int heightInset;
    private String placeholder;
    private Color placeholderColor;
    private int bitmapNumber;
    private int bitmapRollover;
    private int bitmapTrailingRollover;
    private int bitmapTrailing;
    private int bitmapDisabled;
    private int bitmapTrailingDisabled;
    private int bitmapWidth;
    private int bitmapHeight;
    private String bitmapHint;
    private String bitmapTrailingHint;
    private Image image;
    private boolean proposalsEnabled = true;
    private Vector proposals = new Vector();
    private int proposalIndex;
    private int visibleProposalCount = 5;
    private boolean proposalsUnsorted;
    private JPopupMenu proposalPopup;
    private JList proposalList;
    private int proposalAfterDigits;
    private String currText;
    private DefaultListModel matchingProposals;
    private Timer proposalTimer;
    private NotifyChangeTimer notifyChangeTimer;
    private PropertyChangeListener pcListener;
    private Integer configBcolor;
    private Integer configFcolor;
    private String disabledFieldColor;
    private String readOnlyFieldColor;
    private boolean useDefaultBorderWithBoxedStyle;
    private Color defaultBackground;
    private Color defaultForeground;
    private String validationRegexp;
    private int validationOpts;
    private String validationErrmsg;
    private boolean backgroundSet;
    private boolean foregroundSet;
    private String lineSeparator;
    private Color borderColor;
    private ColorCmp borderColorCmp;
    private int borderColorIdx;
    private String spellChecking;
    private boolean readOnlyCursor;
    private ChangeListener caretListener;
    private boolean caretListenerEnabled = true;
    private boolean defaultShortcutsEnabled;
    private String acceptedControlCharacters;
    private Integer iConfigFocusBorderColor;
    private String sConfigFocusBorder;
    private Color configFocusBorderColor;
    protected Border configFocusBorder;
    protected Border origBorder;
    private Vector<Integer> marginWidths = new Vector();
    private String fvalSW;
    private boolean checkSW;
    private String inputFilter;
    private int proposalFilterType = 1;
    private Pattern regex = null;
    private FastCellRenderer renderer;
    private String matchingTextColor;
    private Color defaultMatchingTextColorBackground;
    private Color matchingTextColorBackground = this.defaultMatchingTextColorBackground = new Color(255, 215, 50);
    private Color matchingTextColorForeground = null;
    private RolloverBorderManager borderManager;
    private boolean maxTextBytes = true;
    private int initialDelay;

    public RemoteEntryField(GuiFactoryImpl guiFactoryImpl) {
        super(guiFactoryImpl);
        this.proposalTimer = new Timer(500, actionEvent -> this.showProposalPopup(((EntryField)((Object)this.guiComponent)).getText()));
        this.proposalTimer.setRepeats(false);
        try {
            this.configBcolor = Integer.valueOf(guiFactoryImpl.getCsProperty().get("iscobol.gui.curr_bcolor", null));
        }
        catch (Exception exception) {
            try {
                this.configBcolor = Integer.valueOf(guiFactoryImpl.getCsProperty().get("iscobol.gui.curr_ef_bcolor", null));
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        try {
            this.configFcolor = Integer.valueOf(guiFactoryImpl.getCsProperty().get("iscobol.gui.curr_fcolor", null));
        }
        catch (Exception exception) {
            try {
                this.configFcolor = Integer.valueOf(guiFactoryImpl.getCsProperty().get("iscobol.gui.curr_ef_fcolor", null));
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
        try {
            this.iConfigFocusBorderColor = Integer.valueOf(guiFactoryImpl.getCsProperty().get("iscobol.gui.curr_border_color", null));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sConfigFocusBorder = guiFactoryImpl.getCsProperty().get("iscobol.gui.curr_border_width", null);
        this.configFocusBorderColor = this.iConfigFocusBorderColor != null ? guiFactoryImpl.getRemotePalette().getDefaultColor(this.iConfigFocusBorderColor) : (this.borderColor != null ? this.borderColor : Color.darkGray);
        this.setRolloverBorder();
        this.useDefaultBorderWithBoxedStyle = guiFactoryImpl.getCsProperty().get("iscobol.gui.native_style", false);
        this.disabledFieldColor = guiFactoryImpl.getCsProperty().get("iscobol.gui.disabled_field_color", null);
        this.readOnlyFieldColor = guiFactoryImpl.getCsProperty().get("iscobol.gui.entryfield.read_only_color", null);
        this.lineSeparator = guiFactoryImpl.getCsProperty().get("iscobol.gui.ef_lineseparator", null);
        this.readOnlyCursor = guiFactoryImpl.getCsProperty().get("iscobol.gui.entryfield.read_only_cursor_arrow", false);
        this.defaultShortcutsEnabled = guiFactoryImpl.getCsProperty().get("iscobol.key.default_shortcuts_enabled", true);
        this.acceptedControlCharacters = guiFactoryImpl.getCsProperty().get("iscobol.key.accepted_control_characters", null);
        this.maxTextBytes = guiFactoryImpl.getCsProperty().get("iscobol.gui.max_text_in_bytes", true);
        this.matchingTextColor = guiFactoryImpl.getCsProperty().get("iscobol.gui.matching_text_color", null);
        int n2 = guiFactoryImpl.getCsProperty().get("iscobol.gui.entryfield.notify_change_delay", 0);
        if (n2 > 0) {
            this.notifyChangeTimer = new NotifyChangeTimer(n2);
        }
        this.setPlaceholderColor();
        this.pcListener = propertyChangeEvent -> {
            if (guiFactoryImpl != null) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("iscobol.gui.curr_ef_bcolor") || string.equals("iscobol.gui.curr_bcolor")) {
                    try {
                        this.configBcolor = Integer.valueOf(guiFactoryImpl.getCsProperty().get(string, null));
                    }
                    catch (Exception exception) {}
                } else if (string.equals("iscobol.gui.curr_ef_fcolor") || string.equals("iscobol.gui.curr_fcolor")) {
                    try {
                        this.configFcolor = Integer.valueOf(guiFactoryImpl.getCsProperty().get(string, null));
                    }
                    catch (Exception exception) {}
                } else if (string.equals("iscobol.gui.rollover_border_color") || string.equals("iscobol.gui.rollover_border_width")) {
                    this.setRolloverBorder();
                } else if (string.equals("iscobol.gui.disabled_field_color")) {
                    this.setDisabledFieldColor(guiFactoryImpl.getCsProperty().get(string, null));
                } else if (string.equals("iscobol.gui.entryfield.read_only_color")) {
                    this.setReadOnlyFieldColor(guiFactoryImpl.getCsProperty().get(string, null));
                } else if (string.equals("iscobol.gui.placeholder_color")) {
                    this.setPlaceholderColor();
                } else if (string.equals("iscobol.key.accepted_control_characters")) {
                    this.acceptedControlCharacters = guiFactoryImpl.getCsProperty().get("iscobol.key.accepted_control_characters", null);
                    if (this.guiComponent != null) {
                        ((PicobolEntryField)this.guiComponent).setAcceptedControlCharacters(this.acceptedControlCharacters);
                    }
                } else if (string.equals("iscobol.gui.max_text_in_bytes")) {
                    this.maxTextBytes = guiFactoryImpl.getCsProperty().get("iscobol.gui.max_text_in_bytes", true);
                    if (this.guiComponent != null) {
                        ((PicobolEntryField)this.guiComponent).setMaxTextBytes(this.maxTextBytes);
                    }
                } else if (string.equals("iscobol.gui.entryfield.spell_checking_delay")) {
                    if (this.guiComponent != null) {
                        ((PicobolEntryField)this.guiComponent).setSpellCheckingDelay(guiFactoryImpl.getCsProperty().get("iscobol.gui.entryfield.spell_checking_delay", 500));
                    }
                } else if (string.equals("iscobol.gui.matching_text_color")) {
                    this.setMatchingTextColor(guiFactoryImpl.getCsProperty().get(string, null));
                }
            }
        };
        guiFactoryImpl.getCsProperty().addPropertyChangeListener(this.pcListener);
    }

    private void setRolloverBorder() {
        Integer n2 = null;
        try {
            n2 = Integer.valueOf(this.gf.getCsProperty().get("iscobol.gui.rollover_border_color", null));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = this.gf.getCsProperty().get("iscobol.gui.rollover_border_width", null);
        if (string != null && n2 == null) {
            n2 = -(Color.darkGray.getRGB() & 0xFFFFFF);
        }
        if (n2 != null) {
            Serializable serializable;
            Color color = this.gf.getRemotePalette().getDefaultColor(n2);
            int n3 = 1;
            int n4 = 1;
            int n5 = 1;
            int n6 = 1;
            if (string != null) {
                serializable = new Vector<Integer>();
                try {
                    this.handleBorderWidths(string, (Vector<Integer>)serializable);
                    if (((Vector)serializable).size() > 0) {
                        n3 = (Integer)((Vector)serializable).elementAt(0);
                    }
                    if (((Vector)serializable).size() > 1) {
                        n5 = (Integer)((Vector)serializable).elementAt(1);
                    }
                    if (((Vector)serializable).size() > 2) {
                        n4 = (Integer)((Vector)serializable).elementAt(2);
                    }
                    if (((Vector)serializable).size() > 3) {
                        n6 = (Integer)((Vector)serializable).elementAt(3);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            serializable = new MatteBorder(n3, n5, n4, n6, color);
            if (this.borderManager != null) {
                this.borderManager.mouseEnterBorder = serializable;
            } else {
                this.borderManager = new RolloverBorderManager((Border)((Object)serializable));
            }
        }
    }

    private void setPlaceholderColor() {
        try {
            int n2 = Integer.parseInt(this.gf.getCsProperty().get("iscobol.gui.placeholder_color", null));
            this.placeholderColor = this.getForegroundColor(n2, false);
        }
        catch (Exception exception) {
            this.placeholderColor = null;
        }
        if (this.guiComponent != null) {
            ((PicobolEntryField)this.guiComponent).setPlaceholderColor(this.placeholderColor);
        }
    }

    private void setDisabledFieldColor(String string) {
        this.disabledFieldColor = string;
        if (this.guiComponent != null) {
            boolean[] blArray = new boolean[1];
            Color[] colorArray = this.getFieldColors(this.disabledFieldColor, blArray);
            EntryField entryField = (EntryField)((Object)this.guiComponent);
            if (blArray[0] || !this.backgroundSet) {
                entryField.setDisabledBackground(colorArray[0]);
            } else {
                entryField.setDisabledBackground(null);
            }
            if (blArray[0] || !this.foregroundSet) {
                entryField.setDisabledForeground(colorArray[1]);
            } else {
                entryField.setDisabledForeground(null);
            }
        }
    }

    private void setReadOnlyFieldColor(String string) {
        this.readOnlyFieldColor = string;
        if (this.guiComponent != null) {
            boolean[] blArray = new boolean[1];
            Color[] colorArray = this.getFieldColors(this.readOnlyFieldColor, blArray);
            EntryField entryField = (EntryField)((Object)this.guiComponent);
            if (blArray[0] || !this.backgroundSet) {
                entryField.setReadOnlyBackground(colorArray[0]);
            } else {
                entryField.setReadOnlyBackground(null);
            }
            if (blArray[0] || !this.foregroundSet) {
                entryField.setReadOnlyForeground(colorArray[1]);
            } else {
                entryField.setReadOnlyForeground(null);
            }
        }
    }

    private void setMatchingTextColor(String string) {
        this.matchingTextColor = string;
        if (this.matchingTextColor != null) {
            boolean[] blArray = new boolean[1];
            Color[] colorArray = this.getFieldColors(this.matchingTextColor, blArray);
            this.matchingTextColorBackground = blArray[0] && colorArray[0] != null ? colorArray[0] : this.defaultMatchingTextColorBackground;
            this.matchingTextColorForeground = blArray[0] ? colorArray[1] : null;
        }
        if (this.matchingTextColorForeground == null) {
            this.matchingTextColorForeground = this.getForeground();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.parentWindow != null) {
            ((RemoteDisplayWindow)this.parentWindow).stopTimer();
        }
        switch (keyEvent.getKeyCode()) {
            case 8: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 127: {
                return;
            }
            case 38: {
                if (this.allowProposals()) {
                    if (this.proposalPopup != null && this.proposalPopup.isVisible()) {
                        this.selectItemUp();
                    } else {
                        this.showProposalPopup(((EntryField)((Object)this.guiComponent)).getText());
                    }
                    return;
                }
                if (!this.multiline) break;
                return;
            }
            case 40: {
                if (this.allowProposals()) {
                    if (this.proposalPopup != null && this.proposalPopup.isVisible()) {
                        this.selectItemDown();
                    } else {
                        this.showProposalPopup(((EntryField)((Object)this.guiComponent)).getText());
                    }
                    return;
                }
                if (!this.multiline) break;
                return;
            }
            case 33: 
            case 34: {
                if (!this.multiline) break;
                return;
            }
            case 10: {
                if (this.proposalPopup != null && this.proposalPopup.isVisible()) {
                    this.proposalPopup.setVisible(false);
                } else {
                    if (this.multiline && this.useReturn) {
                        return;
                    }
                    if (!this.multiline || !((PicobolEntryField)this.guiComponent).getUseReturn()) break;
                    return;
                }
            }
            case 9: {
                if (!this.useTab) break;
                return;
            }
            case 67: 
            case 86: 
            case 88: 
            case 89: 
            case 90: {
                if (!keyEvent.isControlDown() || !this.defaultShortcutsEnabled) break;
                return;
            }
        }
        super.keyPressed(keyEvent);
    }

    @Override
    protected boolean requestFocusLostComponent(RemoteBaseGUIControl remoteBaseGUIControl, MouseEvent mouseEvent, RemoteRecordAccept remoteRecordAccept) {
        if (!(remoteBaseGUIControl != null && remoteBaseGUIControl.isSelfAct() || this.check(remoteBaseGUIControl))) {
            return false;
        }
        if (remoteBaseGUIControl != this) {
            this.restoreBF();
        }
        return true;
    }

    private boolean check(RemoteBaseGUIControl remoteBaseGUIControl) {
        PicobolEntryField picobolEntryField = (PicobolEntryField)this.guiComponent;
        if (picobolEntryField == null) {
            return true;
        }
        String string = null;
        String string2 = picobolEntryField.getText();
        if (this.isNumeric) {
            if (!this.checkMinMax(string2)) {
                if (remoteBaseGUIControl != null) {
                    remoteBaseGUIControl.skipNextEvent();
                }
                return false;
            }
            if (this.autoDecimal > 0) {
                int n2 = string2.indexOf(46);
                if (n2 == -1) {
                    n2 = string2.indexOf(44);
                }
                if (n2 > -1) {
                    int n3 = string2.length() - 1 - n2 - this.autoDecimal;
                    if (n3 < 0) {
                        picobolEntryField.setAllText(string2 + ScreenUtility.getAll('0', -n3));
                    }
                } else {
                    picobolEntryField.setAllText(string2 + "." + ScreenUtility.getAll('0', this.autoDecimal));
                }
            }
        } else {
            if (this.required && picobolEntryField.getText().length() == 0) {
                string = Factory.getSysMsg("ef_input_required_msg");
                if (remoteBaseGUIControl != null) {
                    remoteBaseGUIControl.skipNextEvent();
                }
                if (this.msgboxlistener != null) {
                    this.msgboxlistener.sendMsgBox(new MsgBoxEvent(this.guiComponent, string, Factory.getSysMsg("ef_error_msg_title")));
                }
                return false;
            }
            if (this.validationRegexp != null) {
                String string3 = picobolEntryField.getText();
                int n4 = 0;
                if ((this.validationOpts & 1) == 1) {
                    n4 = 66;
                }
                if ((this.validationOpts & 2) == 2) {
                    string3 = Factory.leftTrim(string3);
                }
                if ((this.validationOpts & 4) == 4) {
                    string3 = Factory.rightTrim(string3);
                }
                if (!Pattern.compile(this.validationRegexp, n4).matcher(string3).matches()) {
                    string = this.validationErrmsg != null ? this.validationErrmsg : Factory.getSysMsg("ef_invalid_input");
                    if (remoteBaseGUIControl != null) {
                        remoteBaseGUIControl.skipNextEvent();
                    }
                    if (this.msgboxlistener != null) {
                        this.msgboxlistener.sendMsgBox(new MsgBoxEvent(this.guiComponent, string, Factory.getSysMsg("ef_error_msg_title")));
                    }
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public float getDefaultWidth() {
        return 8.0f;
    }

    @Override
    public float getDefaultHeight() {
        float f2 = 1.0f;
        return f2;
    }

    @Override
    public void focusGained(CobolFocusEvent cobolFocusEvent) {
        RemoteDisplayWindow remoteDisplayWindow = (RemoteDisplayWindow)this.parentWindow;
        if (cobolFocusEvent.isGoto()) {
            this.setconfigBF();
        }
        if (!(cobolFocusEvent.isGoto() && !cobolFocusEvent.isAltKey() || remoteDisplayWindow == null || this.guiComponent == null || this.noautosel && this.cursorPos != -1 || remoteDisplayWindow.getPreviousFocusOwner() == this)) {
            new SwingWorker(false, () -> {
                boolean bl = this.caretListenerEnabled;
                this.caretListenerEnabled = false;
                ((PicobolEntryField)this.guiComponent).selectAll();
                this.caretListenerEnabled = bl;
            }).start();
        }
        if (this.sConfigFocusBorder != null || this.iConfigFocusBorderColor != null) {
            PicobolEntryField picobolEntryField = (PicobolEntryField)this.guiComponent;
            if (this.sConfigFocusBorder != null) {
                if (this.borderWidths != null) {
                    this.borderWidths.clear();
                }
                this.handleBorderWidths(this.sConfigFocusBorder);
                this.configFocusBorder = new MatteBorder(this.getBorder(0), this.getBorder(1), this.getBorder(2), this.getBorder(3), this.configFocusBorderColor);
                this.borderWidths.clear();
                this.borderWidths = null;
                if (this.borderManager != null && this.borderManager.mouseExitBorder != null) {
                    this.borderManager.mouseExitBorder = this.configFocusBorder;
                } else {
                    picobolEntryField.setBorder(this.configFocusBorder);
                }
            } else {
                Border border = this.borderWidths == null ? BorderFactory.createLineBorder(this.configFocusBorderColor) : new MatteBorder(this.getBorder(0), this.getBorder(1), this.getBorder(2), this.getBorder(3), this.configFocusBorderColor);
                if (this.borderManager != null && this.borderManager.mouseExitBorder != null) {
                    this.borderManager.mouseExitBorder = border;
                } else {
                    picobolEntryField.setBorder(border);
                }
            }
        }
        super.focusGained(cobolFocusEvent);
    }

    @Override
    public void focusLost(CobolFocusEvent cobolFocusEvent) {
        PicobolEntryField picobolEntryField;
        this.restoreBF();
        if (!cobolFocusEvent.isGoto() && this.guiComponent != null && this.parentWindow != null && ((RemoteDisplayWindow)this.parentWindow).getFocusOwner() != this) {
            picobolEntryField = (PicobolEntryField)this.guiComponent;
            new IsguiWorker(false, () -> {
                if (picobolEntryField.getSelectedText().length() > 0) {
                    boolean bl = this.caretListenerEnabled;
                    this.caretListenerEnabled = false;
                    picobolEntryField.select(0, 0);
                    this.caretListenerEnabled = bl;
                }
            }).start();
        }
        super.focusLost(cobolFocusEvent);
        if (this.configFocusBorder != null || this.iConfigFocusBorderColor != null) {
            picobolEntryField = (PicobolEntryField)this.guiComponent;
            if (this.borderManager != null && this.borderManager.mouseExitBorder != null) {
                this.borderManager.mouseExitBorder = this.origBorder;
            } else {
                picobolEntryField.setBorder(this.origBorder);
            }
        }
    }

    @Override
    protected void intFocusGained(boolean bl) {
        if (!bl) {
            this.setconfigBF();
        }
    }

    @Override
    public void displayProp() {
    }

    @Override
    public int getGUIControlHeight(float f2) {
        int n2 = (int)((float)this.font.getHeight() * f2);
        if (!this.noBox) {
            this.heightInset = 6;
            n2 += this.heightInset;
        }
        if (this.hasVScrollbar) {
            this.heightInset += 3;
            n2 += 3;
        }
        if (f2 >= 2.0f) {
            this.multiline = true;
        }
        return n2;
    }

    @Override
    public int getGUIControlWidth(float f2) {
        int n2 = 0;
        n2 = (int)((float)this.font.getWidth() * f2);
        this.widthInset = 10;
        n2 += this.widthInset;
        if (this.hasVScrollbar) {
            n2 += 15;
        }
        if (this.spinner) {
            n2 += 15;
        }
        return n2;
    }

    @Override
    public String getProp(int n2) {
        PicobolEntryField picobolEntryField = (PicobolEntryField)this.guiComponent;
        switch (n2) {
            case 360: {
                return this.spellChecking;
            }
            case 299: {
                return this.validationErrmsg;
            }
            case 300: {
                return this.validationRegexp;
            }
            case 301: {
                return "" + this.validationOpts;
            }
            case 59: {
                this.updateCursorProps();
                return "" + this.cursorPos;
            }
            case 60: {
                this.updateCursorProps();
                return "" + this.cursorRowPos;
            }
            case 54: {
                this.updateCursorProps();
                return "" + this.cursorColPos;
            }
            case 214: {
                this.updateSelectionStartProps();
                return "" + this.selStart;
            }
            case 215: {
                this.updateSelectionStartProps();
                return "" + this.selStartRow;
            }
            case 213: {
                this.updateSelectionStartProps();
                return "" + this.selStartCol;
            }
            case 147: {
                return "" + (this.maxText == -1 ? 0 : this.maxText);
            }
            case 216: {
                return picobolEntryField.getSelectedText();
            }
            case 266: {
                if (this.proposalIndex > 0 && this.proposalIndex <= this.proposals.size()) {
                    return this.proposals.elementAt(this.proposalIndex - 1).toString();
                }
                return "";
            }
            case 269: {
                return "" + this.proposalIndex;
            }
            case 272: {
                return "" + this.proposalTimer.getInitialDelay();
            }
            case 271: {
                return "" + this.visibleProposalCount;
            }
            case 304: {
                return "" + this.textOrientation;
            }
            case 323: {
                return "" + this.proposalAfterDigits;
            }
            case 471: {
                return "" + this.proposalFilterType;
            }
            case 325: {
                if (this.borderColorCmp != null) {
                    return Integer.toString(this.borderColorIdx >= 0 ? this.borderColorIdx : this.borderColorCmp.getForeground());
                }
                return null;
            }
            case 12: {
                return "" + this.bitmapNumber;
            }
            case 14: {
                return "" + this.bitmapRollover;
            }
            case 364: {
                return "" + this.bitmapTrailingRollover;
            }
            case 362: {
                return this.bitmapHint;
            }
            case 363: {
                return this.bitmapTrailingHint;
            }
            case 8: {
                return "" + this.bitmapDisabled;
            }
            case 358: {
                return "" + this.bitmapTrailing;
            }
            case 359: {
                return "" + this.bitmapTrailingDisabled;
            }
            case 96: {
                return this.formatString;
            }
            case 324: {
                return this.placeholder;
            }
            case 366: {
                return this.notifyChangeTimer != null ? Integer.toString(this.notifyChangeTimer.getInitialDelay()) : "0";
            }
            case 422: {
                return this.borderToString(this.marginWidths);
            }
        }
        return super.getProp(n2);
    }

    @Override
    public String getTitle() {
        return null;
    }

    @Override
    public String getValue() {
        if (this.guiComponent == null) {
            return "";
        }
        PicobolEntryField picobolEntryField = (PicobolEntryField)this.guiComponent;
        String[] stringArray = new String[1];
        new SwingWorker(true, () -> {
            String string = this.getText();
            if (this.multiline && this.valueMultiple && string.length() > 0) {
                int[][] nArray = picobolEntryField.getLineOffsets();
                StringBuffer stringBuffer = new StringBuffer();
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    if (nArray[i2][0] >= string.length()) continue;
                    stringBuffer.append(string.substring(nArray[i2][0], Math.min(string.length(), nArray[i2][1] + 1)));
                    if (stringBuffer.charAt(stringBuffer.length() - 1) == '\n' || i2 >= nArray.length - 1) continue;
                    stringBuffer.append('\n');
                }
                string = stringBuffer.toString();
            }
            stringArray[0] = string;
        }).start();
        if (this.lineSeparator != null && this.lineSeparator.length() > 0) {
            return stringArray[0].replaceAll("(\r)?\n", this.lineSeparator);
        }
        return stringArray[0];
    }

    public String getValuenoSW() {
        if (this.guiComponent == null) {
            return "";
        }
        PicobolEntryField picobolEntryField = (PicobolEntryField)this.guiComponent;
        String[] stringArray = new String[1];
        String string = this.getText();
        if (this.multiline && this.valueMultiple && string.length() > 0) {
            int[][] nArray = picobolEntryField.getLineOffsets();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (nArray[i2][0] >= string.length()) continue;
                stringBuffer.append(string.substring(nArray[i2][0], Math.min(string.length(), nArray[i2][1] + 1)));
                if (stringBuffer.charAt(stringBuffer.length() - 1) == '\n' || i2 >= nArray.length - 1) continue;
                stringBuffer.append('\n');
            }
            string = stringBuffer.toString();
        }
        stringArray[0] = string;
        if (this.lineSeparator != null && this.lineSeparator.length() > 0) {
            return stringArray[0].replaceAll("(\r)?\n", this.lineSeparator);
        }
        return stringArray[0];
    }

    private String getText() {
        if (this.guiComponent == null) {
            return "";
        }
        return ((PicobolEntryField)this.guiComponent).getText();
    }

    @Override
    public void initialize() {
        PicobolEntryField picobolEntryField;
        if (this.guiComponent != null) {
            return;
        }
        String string = ScreenUtility.rightTrim(this.textValue);
        if (this.multiline) {
            this.guiComponent = new PicobolEntryField(this.gf, string, (int)this.rows, (int)this.cols);
            picobolEntryField = (PicobolEntryField)this.guiComponent;
            if (this.hasVScrollbar) {
                picobolEntryField.addVerticalScrollBar();
            }
        } else {
            this.guiComponent = this.spinner ? new PicobolEntryField(this.gf, this.autoSpin) : (this.formatString != null ? new PicobolEntryField(this.gf, this.formatType, this.formatString, this.fillChar) : (this.secure ? new PicobolEntryField(this.gf, '*') : new PicobolEntryField(this.gf)));
            picobolEntryField = (PicobolEntryField)this.guiComponent;
            picobolEntryField.setHorizontalAlignment(this.alignment);
        }
        if (!this.isNational) {
            picobolEntryField.setEncoding(this.gf.getIscobolEncoding());
        }
        picobolEntryField.setMaxTextBytes(this.maxTextBytes);
        picobolEntryField.setDefaultShortcutsEnabled(this.defaultShortcutsEnabled);
        picobolEntryField.setUpperLowerMethod(this.gf.getUpperLowerMethod());
        picobolEntryField.setAcceptedControlCharacters(this.acceptedControlCharacters);
        this.defaultBackground = this.guiComponent.getBackground();
        this.defaultForeground = this.guiComponent.getForeground();
        this.setTextWrapping(picobolEntryField, this.textWrapping);
        switch (this.textOrientation) {
            default: {
                break;
            }
            case 1: {
                picobolEntryField.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
                break;
            }
            case 2: {
                picobolEntryField.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            }
        }
        if (this.popupListener == null) {
            this.popupListener = new PopupListener(picobolEntryField);
        }
        this.guiComponent.addKeyListener(this);
        picobolEntryField.setNumeric(this.isNumeric);
        picobolEntryField.setMaxText(this.maxText < 0 ? 0 : this.maxText);
        if (this.upper) {
            picobolEntryField.setUpper(this.upper);
        } else if (this.lower) {
            picobolEntryField.setLower(this.lower);
        } else {
            picobolEntryField.setLower(this.gf.getGuiKdbLower());
            picobolEntryField.setUpper(this.gf.getGuiKdbUpper());
        }
        picobolEntryField.setReadOnly(this.readOnly, this.readOnlyCursor);
        picobolEntryField.setAuto(this.autoTermination);
        picobolEntryField.setMaxLines(this.maxLines);
        picobolEntryField.setUseTab(this.useTab);
        picobolEntryField.setUseReturn(this.useReturn);
        picobolEntryField.setPlaceholder(this.placeholder);
        picobolEntryField.setPlaceholderColor(this.placeholderColor);
        picobolEntryField.setSpellChecking(this.spellChecking);
        picobolEntryField.setSpellCheckingDelay(this.gf.getCsProperty().get("iscobol.gui.entryfield.spell_checking_delay", 500));
        picobolEntryField.setIconHint(this.bitmapHint);
        picobolEntryField.setIconTrailingHint(this.bitmapTrailingHint);
        if (this.maxValue != 0 || this.minValue != 0) {
            picobolEntryField.setMaxValue(this.maxValue);
            picobolEntryField.setMinValue(this.minValue);
        }
        picobolEntryField.setNoWrap(this.noWrap);
        this.setMargins(false);
        if (this._3d) {
            this.set3DStyle();
        } else if (this.gf.getFieldsUnboxed()) {
            if (this.boxed) {
                this.setBoxedStyle();
            } else {
                this.setNoboxStyle();
            }
        } else if (this.noBox) {
            this.setNoboxStyle();
        } else {
            this.setBoxedStyle();
        }
        this.textListener = new PicobolTextListener(){

            @Override
            public void textChanged(PicobolTextEvent picobolTextEvent) {
                if (RemoteEntryField.this.proposalsEnabled && RemoteEntryField.this.allowProposals()) {
                    if (RemoteEntryField.this.proposalPopup != null && RemoteEntryField.this.proposalPopup.isVisible()) {
                        RemoteEntryField.this.showProposalPopup(((EntryField)((Object)RemoteEntryField.this.guiComponent)).getText());
                    } else {
                        RemoteEntryField.this.proposalTimer.restart();
                    }
                }
                if (RemoteEntryField.this.notifyChange) {
                    short s2 = (short)(picobolTextEvent.getDetail() + 1);
                    if (RemoteEntryField.this.notifyChangeTimer != null) {
                        RemoteEntryField.this.notifyChangeTimer.setEd1(s2);
                        RemoteEntryField.this.notifyChangeTimer.restart();
                    } else {
                        RemoteEntryField.this.sendNtfChangeEvent(s2);
                    }
                }
                if (RemoteEntryField.this.autoDecimal > 0) {
                    int n2;
                    PicobolEntryField picobolEntryField = (PicobolEntryField)RemoteEntryField.this.guiComponent;
                    String string = picobolEntryField.getText();
                    if (!RemoteEntryField.this.checkMinMax(string)) {
                        return;
                    }
                    int n3 = string.indexOf(46);
                    if (n3 == -1) {
                        n3 = string.indexOf(44);
                    }
                    if (n3 > -1 && (n2 = string.length() - 1 - n3 - RemoteEntryField.this.autoDecimal) >= 0) {
                        RemoteEntryField.this.intKeyPressed(VirtualKeyboard.getStandardNext(), true, null);
                    }
                }
            }

            @Override
            public void valueIncrementing(PicobolTextEvent picobolTextEvent) {
                CobolEventCouple cobolEventCouple = new CobolEventCouple(RemoteEntryField.this, new RemoteRecordAccept(6, 96, 16416, false, false, true));
                RemoteEntryField.this.pushEvent(cobolEventCouple);
                if (RemoteEntryField.this.spinner) {
                    RemoteEntryField.this.handleMouseClicked(false);
                }
            }

            @Override
            public void valueDecrementing(PicobolTextEvent picobolTextEvent) {
                CobolEventCouple cobolEventCouple = new CobolEventCouple(RemoteEntryField.this, new RemoteRecordAccept(6, 96, 16417, false, false, true));
                RemoteEntryField.this.pushEvent(cobolEventCouple);
                if (RemoteEntryField.this.spinner) {
                    RemoteEntryField.this.handleMouseClicked(false);
                }
            }

            @Override
            public void inputTerminated(PicobolTextEvent picobolTextEvent) {
                RemoteEntryField.this.intKeyPressed(RemoteEntryField.this.gf.getRemoteVirtualKeyboard().getAutoTerminated(), true, null);
            }

            @Override
            public void inputTerminated(KeyEvent keyEvent) {
                RemoteEntryField.this.intKeyPressed(RemoteEntryField.this.gf.getRemoteVirtualKeyboard().mapKey(keyEvent), false, null);
            }

            @Override
            public void iconClicked(PicobolTextEvent picobolTextEvent) {
                CobolEventCouple cobolEventCouple = new CobolEventCouple(RemoteEntryField.this, new RemoteRecordAccept(7, 96, 16400, (short)(picobolTextEvent.getDetail() + 1), 0, false, false, true));
                RemoteEntryField.this.pushEvent(cobolEventCouple);
            }

            @Override
            public void iconDoubleClicked(PicobolTextEvent picobolTextEvent) {
                CobolEventCouple cobolEventCouple = new CobolEventCouple(RemoteEntryField.this, new RemoteRecordAccept(7, 96, 16401, (short)(picobolTextEvent.getDetail() + 1), 0, false, false, true));
                RemoteEntryField.this.pushEvent(cobolEventCouple);
            }
        };
        picobolEntryField.addTextListener(this.textListener);
        this.caretListener = changeEvent -> {
            if (this.caretListenerEnabled && this.cursorPos < 0) {
                this.cursorPos = 0;
            }
        };
        picobolEntryField.getTextComponent().getCaret().addChangeListener(this.caretListener);
        if (this.borderManager != null) {
            picobolEntryField.addMouseListener(this.borderManager);
        }
        super.intInitialize();
        if (this.inputFilter != null) {
            picobolEntryField.setInputFilter(this.inputFilter);
        }
        if (this.fvalSW == null && string.length() > 0) {
            this.setValue(string);
        }
        this.setDisabledFieldColor(this.disabledFieldColor);
        this.setReadOnlyFieldColor(this.readOnlyFieldColor);
        this.setMatchingTextColor(this.matchingTextColor);
        picobolEntryField.setMsgBoxListener(this.msgboxlistener);
    }

    private void sendNtfChangeEvent(short s2) {
        CobolEventCouple cobolEventCouple = new CobolEventCouple(this, new RemoteRecordAccept(6, 96, 4100, s2, 0, true, true, true));
        if (this.parentWindow != null) {
            ((RemoteDisplayWindow)this.parentWindow).setPreviousFocusOwner(this);
        }
        this.pushEvent(cobolEventCouple);
    }

    @Override
    public boolean isSelfAct() {
        return false;
    }

    private boolean allowProposals() {
        return this.proposals.size() > 0 && !this.multiline && this.autoDecimal == 0 && !this.readOnly && !this.secure && !this.spinner && !this.autoSpin && this.formatString == null;
    }

    private void selectItemDown() {
        EntryField entryField = (EntryField)((Object)this.guiComponent);
        entryField.removeTextListener(this.textListener);
        int n2 = this.proposalList.getSelectedIndex();
        if (n2 < this.matchingProposals.getSize() - 1) {
            this.selectItemAt(n2 + 1);
        } else {
            this.selectItemAt(-1);
        }
        entryField.addTextListener(this.textListener);
    }

    private void selectItemUp() {
        EntryField entryField = (EntryField)((Object)this.guiComponent);
        entryField.removeTextListener(this.textListener);
        int n2 = this.proposalList.getSelectedIndex();
        if (n2 < 0) {
            this.selectItemAt(this.matchingProposals.getSize() - 1);
        } else if (n2 > 0) {
            this.selectItemAt(n2 - 1);
        } else {
            this.selectItemAt(-1);
        }
        entryField.addTextListener(this.textListener);
    }

    private void selectItemAt(int n2) {
        EntryField entryField = (EntryField)((Object)this.guiComponent);
        if (n2 >= 0) {
            this.proposalList.setSelectedIndex(n2);
            this.proposalList.ensureIndexIsVisible(n2);
            entryField.setText(this.matchingProposals.elementAt(n2).toString());
        } else {
            this.proposalList.getSelectionModel().clearSelection();
            entryField.setText(this.currText);
        }
    }

    private void showProposalPopup(String string) {
        if (string.length() == 0) {
            if (this.proposalPopup != null && this.proposalPopup.isVisible()) {
                this.proposalPopup.setVisible(false);
            }
            return;
        }
        EntryField entryField = (EntryField)((Object)this.guiComponent);
        this.currText = string;
        try {
            this.regex = Pattern.compile("(?i)" + this.currText);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return;
        }
        this.matchingProposals = new DefaultListModel();
        int n2 = this.proposals.size();
        string = string.toLowerCase();
        if (this.proposalAfterDigits <= 1 || string.length() >= this.proposalAfterDigits) {
            for (int i2 = 0; i2 < n2; ++i2) {
                String string2 = this.proposals.elementAt(i2).toString();
                if (this.proposalFilterType != 0 && (this.proposalFilterType != 1 || !string2.toLowerCase().contains(string)) && (this.proposalFilterType != 2 || !string2.toLowerCase().startsWith(string))) continue;
                this.matchingProposals.addElement(string2);
            }
        }
        if (this.matchingProposals.size() == 0) {
            if (this.proposalPopup != null && this.proposalPopup.isVisible()) {
                this.proposalPopup.setVisible(false);
            }
            return;
        }
        this.proposalPopup = new JPopupMenu();
        this.proposalPopup.setLayout(new GridLayout(1, 0));
        this.proposalList = new JList(this.matchingProposals);
        this.proposalList.setForeground(entryField.getForeground());
        this.proposalList.setBackground(entryField.getBackground());
        Font font = entryField.getFont();
        this.proposalList.setFont(font);
        int n3 = this.proposalList.getFontMetrics(font).getHeight();
        this.proposalList.addMouseListener(IsguiUtility.mousePressedAdapter(mouseEvent -> {
            int n2 = this.proposalList.locationToIndex(mouseEvent.getPoint());
            if (n2 >= 0) {
                boolean bl = this.proposalsEnabled;
                this.proposalsEnabled = false;
                entryField.setText(this.matchingProposals.elementAt(n2).toString());
                this.proposalsEnabled = bl;
            }
            this.proposalPopup.setVisible(false);
        }));
        int n4 = Math.min(this.matchingProposals.size(), this.visibleProposalCount);
        this.proposalList.setVisibleRowCount(n4);
        this.proposalList.setFixedCellHeight(n3);
        JScrollPane jScrollPane = new JScrollPane(this.proposalList);
        Insets insets = jScrollPane.getInsets();
        jScrollPane.setPreferredSize(new Dimension(entryField.getWidth(), n4 * n3 + insets.top + insets.bottom));
        this.proposalPopup.add(jScrollPane);
        this.proposalList.addHierarchyListener(hierarchyEvent -> {
            if ((hierarchyEvent.getChangeFlags() & 4L) == 4L && this.proposalList.isShowing()) {
                SwingUtilities.invokeLater(() -> entryField.requestFocus());
            }
        });
        this.renderer = new FastCellRenderer();
        this.proposalList.setCellRenderer(this.renderer);
        this.proposalPopup.show(entryField, 0, entryField.getHeight() + 1);
    }

    private void setOrigBorder(PicobolEntryField picobolEntryField, Border border) {
        this.origBorder = border;
        picobolEntryField.setBorder(border);
    }

    @Override
    public void setBorder(boolean bl) {
    }

    @Override
    public void setElementAt(int[] nArray) {
    }

    @Override
    public void setImage(int n2, int n3, int n4, int n5) {
        Rectangle rectangle = this.getBounds();
        n2 = rectangle.width;
        n3 = rectangle.height;
        PicobolEntryField picobolEntryField = (PicobolEntryField)this.guiComponent;
        if (n2 != 0) {
            this.image = this.getLocalImage(n4);
            this.bitmapHeight = n3;
        } else {
            this.image = null;
        }
        if (picobolEntryField != null) {
            picobolEntryField.setIcon(this.getIcon(this.bitmapNumber));
            picobolEntryField.setIconDisabled(this.getIcon(this.bitmapDisabled));
            picobolEntryField.setIconTrailing(this.getIcon(this.bitmapTrailing));
            picobolEntryField.setIconTrailingDisabled(this.getIcon(this.bitmapTrailingDisabled));
            picobolEntryField.setIconRollover(this.getIcon(this.bitmapRollover));
            picobolEntryField.setIconTrailingRollover(this.getIcon(this.bitmapTrailingRollover));
        }
    }

    @Override
    public String setProp(Integer n2, String[] stringArray) {
        String string = "0";
        if (stringArray == null) {
            return "0";
        }
        if (n2 == 266) {
            this.resetProposals();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                this.addProposal(stringArray[i2]);
            }
            string = "1";
        }
        return string;
    }

    @Override
    public String setProp(Integer n2, String string, int n3) {
        String string2 = "0";
        int n4 = -1;
        boolean bl = false;
        PicobolEntryField picobolEntryField = (PicobolEntryField)this.guiComponent;
        try {
            n4 = (int)Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            bl = true;
        }
        boolean bl2 = false;
        switch (n2) {
            case 419: {
                if (bl) break;
                this.setTextWrapping(picobolEntryField, n4);
                string2 = "1";
                break;
            }
            case 366: {
                if (bl) break;
                if (this.notifyChangeTimer != null) {
                    this.notifyChangeTimer.stop();
                    this.notifyChangeTimer = null;
                }
                if (n4 > 0) {
                    this.notifyChangeTimer = new NotifyChangeTimer(n4);
                }
                string2 = "1";
                break;
            }
            case 360: {
                this.spellChecking = string;
                if (picobolEntryField != null) {
                    picobolEntryField.setSpellChecking(this.spellChecking);
                }
                string2 = SpellChecker.isSupported() ? "1" : "0";
                break;
            }
            case 20: {
                if (bl) break;
                this.bitmapWidth = n4;
                string2 = "1";
                break;
            }
            case 12: {
                if (bl) break;
                this.bitmapNumber = n4;
                if (picobolEntryField != null) {
                    picobolEntryField.setIcon(this.getIcon(this.bitmapNumber));
                }
                string2 = "1";
                break;
            }
            case 14: {
                if (bl) break;
                this.bitmapRollover = n4;
                if (picobolEntryField != null) {
                    picobolEntryField.setIconRollover(this.getIcon(this.bitmapRollover));
                }
                string2 = "1";
                break;
            }
            case 364: {
                if (bl) break;
                this.bitmapTrailingRollover = n4;
                if (picobolEntryField != null) {
                    picobolEntryField.setIconTrailingRollover(this.getIcon(this.bitmapTrailingRollover));
                }
                string2 = "1";
                break;
            }
            case 362: {
                this.bitmapHint = string;
                if (picobolEntryField != null) {
                    picobolEntryField.setIconHint(this.bitmapHint);
                }
                string2 = "1";
                break;
            }
            case 363: {
                this.bitmapTrailingHint = string;
                if (picobolEntryField != null) {
                    picobolEntryField.setIconTrailingHint(this.bitmapTrailingHint);
                }
                string2 = "1";
                break;
            }
            case 358: {
                if (bl) break;
                this.bitmapTrailing = n4;
                if (picobolEntryField != null) {
                    picobolEntryField.setIconTrailing(this.getIcon(this.bitmapTrailing));
                }
                string2 = "1";
                break;
            }
            case 8: {
                if (bl) break;
                this.bitmapDisabled = n4;
                if (picobolEntryField != null) {
                    picobolEntryField.setIconDisabled(this.getIcon(this.bitmapDisabled));
                }
                string2 = "1";
                break;
            }
            case 359: {
                if (bl) break;
                this.bitmapTrailingDisabled = n4;
                if (picobolEntryField != null) {
                    picobolEntryField.setIconTrailingDisabled(this.getIcon(this.bitmapTrailingDisabled));
                }
                string2 = "1";
                break;
            }
            case 325: 
            case 326: {
                bl2 = n2.equals(ParamsValues.getParamValue("BORDER-COLOR-RGB"));
                if (n4 < 0 || bl2) {
                    this.borderColorCmp = new ColorCmp(true);
                    this.borderColorIdx = -1;
                    this.borderColorCmp.setForeRGB(n4);
                    this.borderColor = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(this.borderColorCmp.getForeground(), false));
                } else {
                    this.borderColorCmp = new ColorCmp(n4);
                    this.borderColorIdx = n4;
                    this.borderColor = this.gf.getRemotePalette().getDefaultColor(this.borderColorCmp.getForeground());
                }
                if (!this.isBoxed()) break;
                this.setBoxedStyle();
                break;
            }
            case 299: {
                String string3;
                this.validationErrmsg = string != null && (string3 = string.trim()).length() > 0 ? string3 : null;
                string2 = "1";
                break;
            }
            case 300: {
                String string4;
                this.validationRegexp = string != null && (string4 = string.trim()).length() > 0 ? string4 : null;
                string2 = "1";
                break;
            }
            case 301: {
                if (n4 < 0) break;
                this.validationOpts = n4;
                string2 = "1";
                break;
            }
            case 266: {
                this.addProposal(string);
                string2 = "1";
                break;
            }
            case 268: {
                if (n4 <= 0 || bl || !this.removeProposal(n4 - 1)) break;
                string2 = "1";
                break;
            }
            case 323: {
                if (n4 == 0 || bl) break;
                this.proposalAfterDigits = n4;
                string2 = "1";
                break;
            }
            case 267: {
                if (n4 == 0 || bl) break;
                this.resetProposals();
                string2 = "1";
                break;
            }
            case 271: {
                if (n4 == 0 || bl) break;
                this.visibleProposalCount = Math.max(1, n4);
                string2 = "1";
                break;
            }
            case 269: {
                if (n4 == 0 || bl) break;
                this.proposalIndex = Math.max(0, n4);
                string2 = "1";
                break;
            }
            case 471: {
                if (n4 == this.proposalFilterType || bl) break;
                this.proposalFilterType = n4;
                string2 = "1";
                break;
            }
            case 272: {
                if (n4 == 0 || bl) break;
                n4 = Math.max(0, n4);
                this.proposalTimer.setInitialDelay(n4);
                if (n4 != this.initialDelay) {
                    this.initialDelay = n4;
                    this.proposalTimer.restart();
                }
                string2 = "1";
                break;
            }
            case 304: {
                if (n4 == 0 || bl) break;
                this.textOrientation = Math.max(0, n4);
                if (picobolEntryField != null) {
                    switch (this.textOrientation) {
                        default: {
                            picobolEntryField.setComponentOrientation(ComponentOrientation.UNKNOWN);
                            break;
                        }
                        case 1: {
                            picobolEntryField.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
                            break;
                        }
                        case 2: {
                            picobolEntryField.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                        }
                    }
                }
                string2 = "1";
                break;
            }
            case 145: {
                this.maxLines = n4;
                if (picobolEntryField != null) {
                    picobolEntryField.setMaxLines(this.maxLines);
                }
                string2 = "1";
                break;
            }
            case 147: {
                if (bl) break;
                this.maxText = n4;
                if (picobolEntryField != null) {
                    picobolEntryField.setMaxText(this.maxText);
                }
                string2 = "1";
                break;
            }
            case 216: {
                this.selectionText = string;
                if (picobolEntryField != null) {
                    boolean bl3 = this.caretListenerEnabled;
                    this.caretListenerEnabled = false;
                    picobolEntryField.replaceSelection(this.selectionText);
                    this.caretListenerEnabled = bl3;
                }
                string2 = "1";
                break;
            }
            case 59: {
                if (bl) break;
                this.cursorPos = n4;
                boolean bl4 = this.caretListenerEnabled;
                this.caretListenerEnabled = false;
                if (this.cursorPos == -1 && picobolEntryField != null) {
                    picobolEntryField.selectAll();
                } else {
                    this.setCursorPos();
                }
                this.caretListenerEnabled = bl4;
                string2 = "1";
                break;
            }
            case 60: {
                if (bl) break;
                this.cursorRowPos = n4;
                string2 = "1";
                break;
            }
            case 54: {
                if (bl) break;
                this.cursorColPos = n4;
                this.setCursorRowColPos();
                string2 = "1";
                break;
            }
            case 3: {
                if (bl) break;
                this.setStyle(147456, true);
                this.autoDecimal = n4;
                string2 = "1";
                break;
            }
            case 1: {
                if (bl) break;
                this.setAction(n4);
                string2 = "1";
                break;
            }
            case 148: {
                if (bl) break;
                this.maxValue = n4;
                if (picobolEntryField != null) {
                    picobolEntryField.setMaxValue(this.maxValue);
                }
                string2 = "1";
                break;
            }
            case 152: {
                if (bl) break;
                this.minValue = n4;
                if (picobolEntryField != null) {
                    picobolEntryField.setMinValue(this.minValue);
                }
                string2 = "1";
                break;
            }
            case 96: {
                this.formatString = string;
                if (picobolEntryField != null) {
                    picobolEntryField.setFormatString(ScreenUtility.rightTrim(this.formatString));
                }
                string2 = "1";
                break;
            }
            case 89: {
                if (string.length() <= 0) break;
                this.fillChar = string.charAt(0);
                if (picobolEntryField != null) {
                    picobolEntryField.setFillChar(this.fillChar);
                }
                string2 = "1";
                break;
            }
            case 97: {
                string = string.trim();
                this.formatType = string.equals("NUMERIC") ? 1 : (string.equals("DATE") ? 2 : 0);
                if (picobolEntryField != null) {
                    picobolEntryField.setFormatType(this.formatType);
                }
                string2 = "1";
                break;
            }
            case 257: {
                this.valueMultiple = Boolean.valueOf(string);
                break;
            }
            case 324: {
                this.placeholder = string.trim();
                if (picobolEntryField != null) {
                    picobolEntryField.setPlaceholder(this.placeholder);
                }
                string2 = "1";
                break;
            }
            case 374: {
                this.handleBorderWidths(string);
                if (!this.isBoxed() || this._3d) break;
                this.setBoxedStyle();
                break;
            }
            case 422: {
                try {
                    this.handleBorderWidths(string, this.marginWidths);
                }
                catch (NumberFormatException numberFormatException) {
                    this.marginWidths.clear();
                }
                this.setMargins(true);
                break;
            }
            case 436: {
                this.setInputFilter(string);
                break;
            }
            default: {
                return super.setProp(n2, string, n3);
            }
        }
        return string2;
    }

    private void setMargins(boolean bl) {
        PicobolEntryField picobolEntryField = (PicobolEntryField)this.guiComponent;
        if (picobolEntryField != null) {
            picobolEntryField.setMargins(new Insets(this.getBorder(this.marginWidths, 0), this.getBorder(this.marginWidths, 1), this.getBorder(this.marginWidths, 2), this.getBorder(this.marginWidths, 3)), bl);
        }
    }

    private void setTextWrapping(EntryField entryField, int n2) {
        this.textWrapping = n2;
        if (entryField != null && entryField.getTextComponent() instanceof JTextArea) {
            JTextArea jTextArea = (JTextArea)entryField.getTextComponent();
            switch (this.textWrapping) {
                default: {
                    jTextArea.setWrapStyleWord(!this.isNational);
                    break;
                }
                case 1: {
                    jTextArea.setWrapStyleWord(true);
                    break;
                }
                case 2: {
                    jTextArea.setWrapStyleWord(false);
                }
            }
        }
    }

    private ImageIcon getIcon(int n2) {
        if (n2 > 0) {
            Image image = ScreenUtility.getImage(this.bitmapWidth, this.bitmapHeight, this.image, n2);
            if (image != null) {
                return new ImageIcon(image);
            }
            return null;
        }
        return null;
    }

    @Override
    protected void setAction(int n2) {
        this.action = n2;
        PicobolEntryField picobolEntryField = (PicobolEntryField)this.guiComponent;
        if (picobolEntryField != null) {
            switch (this.action) {
                case 2: {
                    if (!picobolEntryField.hasSelection()) break;
                    picobolEntryField.copy();
                    break;
                }
                case 3: {
                    if (!ScreenUtility.canPaste(EntryField.class)) break;
                    picobolEntryField.paste();
                    break;
                }
                case 1: {
                    if (!picobolEntryField.hasSelection()) break;
                    picobolEntryField.cut();
                    break;
                }
                case 4: {
                    picobolEntryField.replaceSelection("");
                    break;
                }
                case 5: {
                    if (!picobolEntryField.canUndo()) break;
                    picobolEntryField.undo();
                    break;
                }
                case 6: {
                    if (!picobolEntryField.canRedo()) break;
                    picobolEntryField.redo();
                    break;
                }
                case 7: {
                    boolean bl = this.caretListenerEnabled;
                    this.caretListenerEnabled = false;
                    picobolEntryField.selectAll();
                    this.caretListenerEnabled = bl;
                    break;
                }
                default: {
                    super.setAction(n2);
                }
            }
        }
    }

    @Override
    public void setRowsCols(float f2, float f3) {
        this.rows = f2 < 1.0f ? 1.0f : f2;
        this.cols = f3 < 1.0f ? 1.0f : f3;
        if (this.maxText == -1 && f2 > 0.0f && f3 > 0.0f) {
            this.maxText = (int)f2 * (int)f3;
        }
    }

    @Override
    public void setCols(float f2) {
        this.setRowsCols(this.rows, f2);
    }

    @Override
    public void setRows(float f2) {
        this.setRowsCols(f2, this.cols);
    }

    @Override
    public void setnewStyle(long l2) {
        PicobolEntryField picobolEntryField = (PicobolEntryField)this.guiComponent;
        if ((l2 & 0x200000L) == 0x200000L) {
            if (!this.noWrap) {
                this.noWrap = true;
                if (picobolEntryField != null) {
                    picobolEntryField.setNoWrap(this.noWrap);
                }
            }
        } else if (this.noWrap) {
            this.noWrap = false;
            if (picobolEntryField != null) {
                picobolEntryField.setNoWrap(this.noWrap);
            }
        }
        this.hasVScrollbar = (l2 & 0xE0L) == 224L;
        if ((l2 & 0x20000L) == 131072L) {
            if (!this.isNumeric) {
                this.isNumeric = true;
                if (picobolEntryField != null) {
                    picobolEntryField.setNumeric(this.isNumeric);
                }
            }
        } else if (this.isNumeric) {
            this.isNumeric = false;
            if (picobolEntryField != null) {
                picobolEntryField.setNumeric(this.isNumeric);
            }
        }
        this.notifyChange = (l2 & 0x8000L) == 32768L;
        if ((l2 & 0x800L) == 2048L) {
            if (!this.lower) {
                this.lower = true;
                if (picobolEntryField != null) {
                    picobolEntryField.setLower(this.lower);
                }
            }
        } else if (this.lower) {
            this.lower = false;
            if (picobolEntryField != null) {
                picobolEntryField.setLower(this.lower);
            }
        }
        if ((l2 & 0x400L) == 1024L) {
            if (!this.upper) {
                this.upper = true;
                if (picobolEntryField != null) {
                    picobolEntryField.setUpper(this.upper);
                }
            }
        } else if (this.upper) {
            this.upper = false;
            if (picobolEntryField != null) {
                picobolEntryField.setUpper(this.upper);
            }
        }
        if ((l2 & 0x100L) == 256L) {
            if (!this.useReturn) {
                this.useReturn = true;
                if (picobolEntryField != null) {
                    picobolEntryField.setUseReturn(this.useReturn);
                }
            }
        } else if (this.useReturn) {
            this.useReturn = false;
            if (picobolEntryField != null) {
                picobolEntryField.setUseReturn(this.useReturn);
            }
        }
        if ((l2 & 0x200L) == 512L) {
            if (!this.useTab) {
                this.useTab = true;
                if (picobolEntryField != null) {
                    picobolEntryField.setUseTab(this.useTab);
                }
            }
        } else if (this.useTab) {
            this.useTab = false;
            if (picobolEntryField != null) {
                picobolEntryField.setUseTab(this.useTab);
            }
        }
        if ((l2 & 0x2000L) == 8192L) {
            if (!this.readOnly) {
                this.readOnly = true;
                if (picobolEntryField != null) {
                    picobolEntryField.setReadOnly(this.readOnly, this.readOnlyCursor);
                }
            }
        } else if (this.readOnly) {
            this.readOnly = false;
            if (picobolEntryField != null) {
                picobolEntryField.setReadOnly(this.readOnly, this.readOnlyCursor);
            }
        }
        this.multiline = (l2 & 0x20L) == 32L;
        if ((l2 & 0x10000L) == 65536L) {
            if (!this.secure) {
                this.secure = true;
                if (picobolEntryField != null && !this.multiline) {
                    picobolEntryField.setSecure(this.secure, '*');
                }
            }
        } else if (this.secure) {
            this.secure = false;
            if (picobolEntryField != null && !this.multiline) {
                picobolEntryField.setSecure(this.secure, '*');
            }
        }
        this.proposalsUnsorted = (l2 & 0x100000L) == 0x100000L;
        this.noautosel = (l2 & 0x1000L) == 4096L;
        if ((l2 & 0x4000L) == 16384L) {
            if (!this.autoTermination) {
                this.autoTermination = true;
                if (picobolEntryField != null) {
                    picobolEntryField.setAuto(this.autoTermination);
                }
            }
        } else if (this.autoTermination) {
            this.autoTermination = false;
            if (picobolEntryField != null) {
                picobolEntryField.setAuto(this.autoTermination);
            }
        }
        if (!this.multiline) {
            if ((l2 & 4L) == 4L) {
                if (this.alignment != 0) {
                    this.alignment = 0;
                    if (picobolEntryField != null && !this.multiline) {
                        picobolEntryField.setHorizontalAlignment(this.alignment);
                    }
                }
            } else if (this.alignment == 0) {
                this.alignment = 2;
                if (picobolEntryField != null) {
                    picobolEntryField.setHorizontalAlignment(this.alignment);
                }
            }
            if ((l2 & 2L) == 2L) {
                if (this.alignment != 4) {
                    this.alignment = 4;
                    if (picobolEntryField != null) {
                        picobolEntryField.setHorizontalAlignment(this.alignment);
                    }
                }
            } else if (this.alignment == 4) {
                this.alignment = 2;
                if (picobolEntryField != null) {
                    picobolEntryField.setHorizontalAlignment(this.alignment);
                }
            }
            if ((l2 & 1L) == 1L) {
                if (this.alignment != 2) {
                    this.alignment = 2;
                    if (picobolEntryField != null) {
                        picobolEntryField.setHorizontalAlignment(this.alignment);
                    }
                }
            } else if (this.alignment == 2) {
                this.alignment = 2;
                if (picobolEntryField != null) {
                    picobolEntryField.setHorizontalAlignment(this.alignment);
                }
            }
            if ((l2 & 0x40040L) == 262208L) {
                if (!this.autoSpin) {
                    this.autoSpin = true;
                    if (picobolEntryField != null) {
                        picobolEntryField.setAutoSpin(this.autoSpin);
                    }
                }
            } else if (this.autoSpin) {
                this.autoSpin = false;
                if (picobolEntryField != null) {
                    picobolEntryField.setAutoSpin(this.autoSpin);
                }
            }
        }
        this.spinner = (l2 & 0x40000L) == 262144L;
        if ((l2 & 8L) == 8L) {
            if (!this.boxed) {
                this.boxed = true;
                this.setBoxedStyle();
            }
        } else if (this.boxed) {
            this.boxed = false;
        }
        if ((l2 & 0x10L) == 16L) {
            if (!this.noBox) {
                this.noBox = true;
                this.setNoboxStyle();
            }
        } else if (this.noBox) {
            this.noBox = false;
        }
        if ((l2 & 0x2000000L) == 0x2000000L) {
            if (!this._3d) {
                this._3d = true;
                this.set3DStyle();
            }
        } else if (this._3d) {
            this._3d = false;
        }
        this.required = (l2 & 0x80000L) == 524288L;
    }

    @Override
    public void setStyle(int n2, boolean bl) {
        PicobolEntryField picobolEntryField = (PicobolEntryField)this.guiComponent;
        if ((n2 & 0x200000) == 0x200000) {
            this.noWrap = bl;
            if (picobolEntryField != null) {
                picobolEntryField.setNoWrap(this.noWrap);
            }
        }
        if ((n2 & 0xE0) == 224) {
            this.hasVScrollbar = bl;
        }
        if ((n2 & 0x20000) == 131072) {
            this.isNumeric = bl;
            if (picobolEntryField != null) {
                picobolEntryField.setNumeric(this.isNumeric);
            }
        }
        if ((n2 & 0x8000) == 32768) {
            this.notifyChange = bl;
        }
        if ((n2 & 0x800) == 2048) {
            this.lower = bl;
            if (picobolEntryField != null) {
                picobolEntryField.setLower(this.lower);
            }
        }
        if ((n2 & 0x400) == 1024) {
            this.upper = bl;
            if (picobolEntryField != null) {
                picobolEntryField.setUpper(this.upper);
            }
        }
        if ((n2 & 0x100) == 256) {
            this.useReturn = bl;
            if (picobolEntryField != null) {
                picobolEntryField.setUseReturn(this.useReturn);
            }
        }
        if ((n2 & 0x200) == 512) {
            this.useTab = bl;
            if (picobolEntryField != null) {
                picobolEntryField.setUseTab(this.useTab);
            }
        }
        if ((n2 & 0x2000) == 8192) {
            this.readOnly = bl;
            if (picobolEntryField != null) {
                picobolEntryField.setReadOnly(this.readOnly, this.readOnlyCursor);
            }
        }
        if ((n2 & 0x10000) == 65536) {
            this.secure = bl;
            if (picobolEntryField != null && !this.multiline) {
                picobolEntryField.setSecure(this.secure, '*');
            }
        }
        if ((n2 & 0x100000) == 0x100000) {
            this.proposalsUnsorted = bl;
        }
        if ((n2 & 0x4000) == 16384) {
            this.autoTermination = bl;
            if (picobolEntryField != null && !this.multiline) {
                picobolEntryField.setAuto(this.autoTermination);
            }
        }
        if ((n2 & 0x1000) == 4096) {
            this.noautosel = bl;
        }
        if ((n2 & 4) == 4 && !this.multiline) {
            this.alignment = bl ? 0 : 2;
            if (picobolEntryField != null && !this.multiline) {
                picobolEntryField.setHorizontalAlignment(this.alignment);
            }
        }
        if ((n2 & 2) == 2 && !this.multiline) {
            this.alignment = bl ? 4 : 2;
            if (picobolEntryField != null && !this.multiline) {
                picobolEntryField.setHorizontalAlignment(this.alignment);
            }
        }
        if ((n2 & 1) == 1 && !this.multiline) {
            this.alignment = bl ? 2 : 2;
            if (picobolEntryField != null) {
                picobolEntryField.setHorizontalAlignment(this.alignment);
            }
        }
        if ((n2 & 0x20) == 32) {
            this.multiline = bl;
        }
        if ((n2 & 0x40000) == 262144) {
            this.spinner = bl;
        }
        if ((n2 & 0x40040) == 262208) {
            this.autoSpin = bl;
            if (picobolEntryField != null && !this.multiline) {
                picobolEntryField.setAutoSpin(bl);
            }
        }
        if ((n2 & 8) == 8) {
            this.boxed = bl;
            if (bl) {
                this.setBoxedStyle();
            }
        }
        if ((n2 & 0x10) == 16) {
            this.noBox = bl;
            if (bl) {
                this.setNoboxStyle();
            }
        }
        if ((n2 & 0x2000000) == 0x2000000) {
            this._3d = bl;
            if (bl) {
                this.set3DStyle();
            }
        }
        if ((n2 & 0x80000) == 524288) {
            this.required = bl;
        }
    }

    @Override
    public void setTitle(String string) {
    }

    protected void setBoxedStyle() {
        PicobolEntryField picobolEntryField = (PicobolEntryField)this.guiComponent;
        if (picobolEntryField != null) {
            Border border = this.borderColor != null ? BorderFactory.createLineBorder(this.borderColor) : (this.useDefaultBorderWithBoxedStyle ? picobolEntryField.getDefaultBorder() : BorderFactory.createLineBorder(Color.darkGray));
            if (this.borderWidths != null && this.borderWidths.size() > 0) {
                this.setOrigBorder(picobolEntryField, new MatteBorder(this.getBorder(0), this.getBorder(1), this.getBorder(2), this.getBorder(3), this.borderColor != null ? this.borderColor : Color.darkGray));
            } else {
                this.setOrigBorder(picobolEntryField, border);
            }
        }
    }

    protected void setNoboxStyle() {
        PicobolEntryField picobolEntryField = (PicobolEntryField)this.guiComponent;
        if (picobolEntryField != null) {
            this.setOrigBorder(picobolEntryField, null);
        }
    }

    private void set3DStyle() {
        PicobolEntryField picobolEntryField = (PicobolEntryField)this.guiComponent;
        if (picobolEntryField != null) {
            this.setOrigBorder(picobolEntryField, BorderFactory.createLoweredBevelBorder());
        }
    }

    @Override
    public String refreshValue(String string) {
        return this.intsetValue(string, false);
    }

    @Override
    public String setValue(String string) {
        return this.intsetValue(string, true);
    }

    @Override
    protected void intsetValue(ParamVector paramVector, String string) {
        this.textValue = string;
        string = ScreenUtility.truncAtFirstLowValue(ScreenUtility.rightTrim(string));
        if (this.parentWindow != null) {
            this.fvalSW = string;
            this.checkSW = true;
            this.parentWindow.initializecontrolSW.add(this);
            if (string != null) {
                paramVector.addElement(new ParamElementString(1012, string));
            }
        } else {
            super.intsetValue(paramVector, string);
        }
    }

    private String intsetValue(String string, boolean bl) {
        boolean bl2;
        String string2;
        this.textValue = string;
        string = ScreenUtility.truncAtFirstLowValue(ScreenUtility.rightTrim(string));
        if (bl && this.guiComponent != null) {
            string2 = this.getValue();
            bl2 = ScreenUtility.rightTrim(string2).equals(string);
            if (bl2) {
                string = string2;
            }
        } else {
            bl2 = false;
        }
        string2 = string;
        PicobolEntryField picobolEntryField = (PicobolEntryField)this.guiComponent;
        if (this.guiComponent != null) {
            int n2 = picobolEntryField.getCaretPosition();
            new SwingWorker(true, () -> {
                boolean bl2 = this.caretListenerEnabled;
                this.caretListenerEnabled = false;
                picobolEntryField.setAllText(string2);
                if (!bl2 || n2 < 0) {
                    this.loadcursor();
                } else {
                    picobolEntryField.setCaretPosition(n2);
                }
                this.caretListenerEnabled = bl2;
            }).start();
        }
        return string2;
    }

    @Override
    public void initializecontrolSW() {
        if (this.fvalSW != null) {
            boolean bl;
            Object object;
            if (this.checkSW && this.guiComponent != null) {
                object = this.getValuenoSW();
                bl = ScreenUtility.rightTrim((String)object).equals(this.fvalSW);
                if (bl) {
                    this.fvalSW = object;
                }
            } else {
                bl = false;
            }
            object = (PicobolEntryField)this.guiComponent;
            int n2 = ((EntryField)object).getCaretPosition();
            boolean bl2 = this.caretListenerEnabled;
            this.caretListenerEnabled = false;
            ((EntryField)object).setAllText(this.fvalSW);
            if (!bl || n2 < 0) {
                this.loadcursor(true);
            } else {
                ((EntryField)object).setCaretPosition(n2);
            }
            this.caretListenerEnabled = bl2;
            this.fvalSW = null;
        }
    }

    private void addProposal(String string) {
        if (string == null) {
            return;
        }
        if ((string = ScreenUtility.rightTrim(string)).length() == 0) {
            return;
        }
        if (this.proposalIndex > 0) {
            if (this.proposalIndex <= this.proposals.size()) {
                this.proposals.add(this.proposalIndex - 1, string);
            } else {
                this.proposals.addElement(string);
            }
        } else if (this.proposalsUnsorted) {
            this.proposals.addElement(string);
        } else {
            this.proposals.add(ScreenUtility.getInsertionIndex(this.proposals, string, ignoreCaseComparator), string);
        }
    }

    private boolean removeProposal(int n2) {
        if (n2 >= 0 && n2 < this.proposals.size()) {
            this.proposals.removeElementAt(n2);
            return true;
        }
        return false;
    }

    private void resetProposals() {
        this.proposals.clear();
    }

    @Override
    public void destroy() {
        PicobolEntryField picobolEntryField;
        if (this.gf != null && this.gf.getCsProperty() != null) {
            this.gf.getCsProperty().removePropertyChangeListener(this.pcListener);
        }
        if ((picobolEntryField = (PicobolEntryField)this.guiComponent) != null && this.borderManager != null) {
            picobolEntryField.removeMouseListener(this.borderManager);
        }
        this.pcListener = null;
        if (picobolEntryField != null) {
            picobolEntryField.removeTextListener(this.textListener);
        }
        if (picobolEntryField != null && this.caretListener != null) {
            picobolEntryField.getTextComponent().getCaret().removeChangeListener(this.caretListener);
        }
        this.textListener = null;
        super.destroy();
    }

    public void handleResponse(int n2, int n3) {
    }

    @Override
    public void handleResponse(int n2, RemoteRecordAccept remoteRecordAccept) {
        super.handleResponse(n2, remoteRecordAccept);
        if ((remoteRecordAccept.getEventType() == 16416 || remoteRecordAccept.getEventType() == 16417) && this.autoSpin && n2 != 4) {
            PicobolEntryField picobolEntryField = (PicobolEntryField)this.guiComponent;
            new IsguiWorker(false, () -> picobolEntryField.updateValue()).start();
        }
    }

    private void setCursorRowColPos() {
        PicobolEntryField picobolEntryField = (PicobolEntryField)this.guiComponent;
        if (picobolEntryField != null) {
            if (this.cursorRowPos == 0) {
                this.cursorPos = 0;
                this.setCursorPos();
                return;
            }
            int[][] nArray = picobolEntryField.getLineOffsets();
            if (nArray.length == 0) {
                return;
            }
            this.cursorPos = 1;
            int n2 = 0;
            if (this.cursorRowPos > nArray.length) {
                n2 = nArray.length - 1;
                this.cursorPos = nArray[n2][1] + 1;
            } else {
                int n3;
                if (this.cursorRowPos > 0) {
                    n2 = this.cursorRowPos - 1;
                    this.cursorPos = nArray[n2][0];
                }
                this.cursorPos = this.cursorColPos > (n3 = nArray[n2][1] - nArray[n2][0]) ? (this.cursorPos += n3 + 1) : (this.cursorColPos > 0 ? (this.cursorPos += this.cursorColPos) : ++this.cursorPos);
            }
            this.setCursorPos();
        }
    }

    private void setCursorPos() {
        PicobolEntryField picobolEntryField;
        if (this.cursorPos == 0) {
            this.cursorPos = 1;
        }
        if ((picobolEntryField = (PicobolEntryField)this.guiComponent) != null) {
            boolean bl = this.caretListenerEnabled;
            this.caretListenerEnabled = false;
            try {
                picobolEntryField.setCaretPosition(this.cursorPos - 1);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                picobolEntryField.setCaretPosition(picobolEntryField.getText().length());
            }
            this.caretListenerEnabled = bl;
        }
    }

    private void updateCursorProps() {
        new SwingWorker(true, () -> {
            PicobolEntryField picobolEntryField = (PicobolEntryField)this.guiComponent;
            if (picobolEntryField != null) {
                int n2 = picobolEntryField.getCaretPosition();
                this.cursorPos = n2 + 1;
                int[][] nArray = picobolEntryField.getLineOffsets();
                int n3 = 0;
                int n4 = 0;
                while (n4 < nArray.length && n2 > nArray[n4][1]) {
                    ++n4;
                    ++n3;
                }
                this.cursorRowPos = n3 + 1;
                this.cursorColPos = n2;
                this.cursorColPos = n3 > 0 ? (this.cursorColPos -= nArray[n3 - 1][1]) : ++this.cursorColPos;
            }
        }).start();
    }

    private void updateSelectionStartProps() {
        PicobolEntryField picobolEntryField = (PicobolEntryField)this.guiComponent;
        if (picobolEntryField != null) {
            if (picobolEntryField.hasSelection()) {
                int n2 = picobolEntryField.getSelectionStart();
                if (n2 == picobolEntryField.getCaretPosition()) {
                    n2 = picobolEntryField.getSelectionEnd() - 1;
                }
                this.selStart = n2 + 1;
                int[][] nArray = picobolEntryField.getLineOffsets();
                int n3 = 0;
                int n4 = 0;
                while (n4 < nArray.length && n2 > nArray[n4][1]) {
                    ++n4;
                    ++n3;
                }
                this.selStartRow = n3 + 1;
                this.selStartCol = n2;
                this.selStartCol = n3 > 0 ? (this.selStartCol -= nArray[n3 - 1][1]) : ++this.selStartCol;
            } else {
                this.selStartRow = 0;
                this.selStartCol = 0;
                this.selStart = 0;
            }
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            boolean bl2 = this.caretListenerEnabled;
            this.caretListenerEnabled = false;
            this.loadcursor();
            this.caretListenerEnabled = bl2;
        }
    }

    @Override
    public void setSize(int n2, int n3, boolean bl) {
        super.setSize(n2, n3, bl);
        if (this.maxText == -1) {
            int n4 = (n3 - this.heightInset) / this.font.getHeight();
            if (n4 == 0) {
                n4 = 1;
            }
            this.maxText = (n2 - this.widthInset) / this.font.getWidth() * n4;
        }
    }

    @Override
    public boolean isInputField() {
        return true;
    }

    protected boolean isBoxed() {
        return this.boxed || !this._3d && !this.noBox && !this.gf.getFieldsUnboxed();
    }

    @Override
    protected float paramgetDefaultWidth(ParamElementSize paramElementSize, int n2) {
        if (paramElementSize.sizes > 0.0f) {
            return paramElementSize.sizes;
        }
        if (paramElementSize.ccPIClen != -1) {
            return paramElementSize.ccPIClen;
        }
        if (paramElementSize.ccOlen != -1) {
            return paramElementSize.ccOlen;
        }
        if (paramElementSize.ccIlen != -1) {
            return paramElementSize.ccIlen;
        }
        return super.paramgetDefaultWidth(paramElementSize, n2);
    }

    private void loadcursor() {
        this.loadcursor(false);
    }

    private void loadcursor(boolean bl) {
        if (this.guiComponent != null) {
            if (this.cursorRowPos > 0 || this.cursorColPos > 0) {
                this.guiComponent.validate();
                this.setCursorRowColPos();
            } else if (this.cursorPos > 0) {
                this.guiComponent.validate();
                this.setCursorPos();
            } else if (this.parentWindow != null && ((RemoteDisplayWindow)this.parentWindow).getPreviousFocusOwner() != this) {
                if (bl) {
                    ((PicobolEntryField)this.guiComponent).setCaretPosition(0);
                } else {
                    new SwingWorker(true, () -> ((PicobolEntryField)this.guiComponent).setCaretPosition(0)).start();
                }
            }
        }
    }

    @Override
    public String getType() {
        if (this.multiline) {
            return "textarea";
        }
        if (this.spinner) {
            return "spinner";
        }
        return "entryfield";
    }

    private void setconfigBF() {
        if (this.guiComponent != null && !this.readOnly) {
            if (this.configBcolor != null) {
                this.guiComponent.setBackground(this.gf.getRemotePalette().getDefaultColor(this.configBcolor));
            }
            if (this.configFcolor != null) {
                this.guiComponent.setForeground(this.gf.getRemotePalette().getDefaultColor(this.configFcolor));
            }
            if (this.configFocusBorder != null) {
                // empty if block
            }
        }
    }

    private void restoreBF() {
        if (this.guiComponent != null && !this.readOnly) {
            Color color;
            if (this.configBcolor != null && (color = this.getOriginalBackground()) != null) {
                this.guiComponent.setBackground(color);
            }
            if (this.configFcolor != null && (color = this.getOriginalForeground()) != null) {
                this.guiComponent.setForeground(color);
            }
        }
    }

    private Color getOriginalBackground() {
        Color color = this.getBackground();
        if (color == null) {
            color = this.defaultBackground;
        }
        return color;
    }

    private Color getOriginalForeground() {
        Color color = this.getForeground();
        if (color == null) {
            color = this.defaultForeground;
        }
        return color;
    }

    @Override
    public boolean bufferedOutAcceptEvent(OutAcceptEvent outAcceptEvent) {
        return this.bufferedOutAcceptEvent(outAcceptEvent, false);
    }

    @Override
    public void setColorBackgroundIdx(int n2) {
        boolean bl = this.backgroundSet;
        super.setColorBackgroundIdx(n2);
        boolean bl2 = this.backgroundSet = this.getBackground() != null;
        if (bl != this.backgroundSet) {
            this.setReadOnlyFieldColor(this.readOnlyFieldColor);
            this.setDisabledFieldColor(this.disabledFieldColor);
        }
    }

    @Override
    public void setColorBackground(int n2, int n3, int n4) {
        boolean bl = this.backgroundSet;
        super.setColorBackground(n2, n3, n4);
        boolean bl2 = this.backgroundSet = this.getBackground() != null;
        if (bl != this.backgroundSet) {
            this.setReadOnlyFieldColor(this.readOnlyFieldColor);
            this.setDisabledFieldColor(this.disabledFieldColor);
        }
    }

    @Override
    public void setColorForegroundIdx(int n2) {
        boolean bl = this.foregroundSet;
        super.setColorForegroundIdx(n2);
        boolean bl2 = this.foregroundSet = this.getForeground() != null;
        if (bl != this.foregroundSet) {
            this.setReadOnlyFieldColor(this.readOnlyFieldColor);
            this.setDisabledFieldColor(this.disabledFieldColor);
        }
    }

    @Override
    public void setColorForeground(int n2, int n3, int n4) {
        boolean bl = this.foregroundSet;
        super.setColorForeground(n2, n3, n4);
        boolean bl2 = this.foregroundSet = this.getForeground() != null;
        if (bl != this.foregroundSet) {
            this.setReadOnlyFieldColor(this.readOnlyFieldColor);
            this.setDisabledFieldColor(this.disabledFieldColor);
        }
    }

    @Override
    public void startCellEditing(boolean bl, MouseEvent mouseEvent) {
        PicobolEntryField picobolEntryField = (PicobolEntryField)this.guiComponent;
        if (picobolEntryField != null && picobolEntryField.getTextComponent() != null) {
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(SwingUtilities.convertMouseEvent((Component)mouseEvent.getSource(), mouseEvent, picobolEntryField.getTextComponent()));
        }
    }

    @Override
    public RemoteBaseGUIControl renderClone() {
        return this.renderClone(false, null);
    }

    @Override
    public RemoteBaseGUIControl renderClone(boolean bl, Dimension dimension) {
        RemoteEntryField remoteEntryField = null;
        try {
            remoteEntryField = (RemoteEntryField)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        remoteEntryField.setComponent(null);
        remoteEntryField.initialize();
        return remoteEntryField;
    }

    @Override
    public void intKeyPressed(int n2, boolean bl, String string) {
        RemoteDisplayWindow remoteDisplayWindow = (RemoteDisplayWindow)this.parentWindow;
        if (remoteDisplayWindow == null || (n2 & 0x300000) == 0x300000) {
            return;
        }
        if (VirtualKeyboard.isScreenEditing(n2) && this.isControlEditor() && bl && this.guiComponent != null) {
            if (((PicobolEntryField)this.guiComponent).getTextComponent() != null && ((PicobolEntryField)this.guiComponent).getTextComponent().getListeners(KeyListener.class) != null && ((KeyListener[])((PicobolEntryField)this.guiComponent).getTextComponent().getListeners(KeyListener.class)).length > 0) {
                KeyListener[] keyListenerArray = (KeyListener[])((PicobolEntryField)this.guiComponent).getTextComponent().getListeners(KeyListener.class);
                if (keyListenerArray != null) {
                    for (int i2 = 0; i2 < keyListenerArray.length; ++i2) {
                        keyListenerArray[i2].keyPressed(new KeyEvent((Component)((Object)this.guiComponent), 401, 0L, 0, 9, '\t'));
                    }
                    CobolFocusable cobolFocusable = remoteDisplayWindow.getFocusOwner();
                    if (cobolFocusable != null && cobolFocusable instanceof RemoteGrid) {
                        ((RemoteGrid)cobolFocusable).stopCellEditing();
                    }
                }
                return;
            }
        } else {
            super.intKeyPressed(n2, bl, string);
        }
    }

    @Override
    public Rectangle getBoundsWithoutDefaultWidth() {
        Rectangle rectangle = super.getBounds();
        if (rectangle != null && rectangle.width > 0) {
            rectangle.width -= 10;
        }
        return rectangle;
    }

    @Override
    public RemoteRecordAccept getDragRRA() {
        return new RemoteRecordAccept(7, 0, 17042, (short)this.cursorPos, 0, false, false, true);
    }

    @Override
    public RemoteRecordAccept getDropRRA(Point point) {
        return new RemoteRecordAccept(7, 0, 17043, (short)point.x, 0, false, false, true);
    }

    @Override
    public JComponent getDragDropComponent() {
        PicobolEntryField picobolEntryField = (PicobolEntryField)this.guiComponent;
        if (picobolEntryField != null) {
            return picobolEntryField.getDragDropComponent();
        }
        return null;
    }

    @Override
    public boolean isDnDStandard() {
        return true;
    }

    @Override
    public void initializeDnDStandard() {
        PicobolEntryField picobolEntryField = (PicobolEntryField)this.guiComponent;
        if (picobolEntryField != null) {
            if (this.dragmode > 0) {
                picobolEntryField.setDragComponent(this);
            } else {
                picobolEntryField.setDragComponent(null);
            }
        }
    }

    private void setInputFilter(String string) {
        if (this.inputFilter == null || !this.inputFilter.equals(string)) {
            PicobolEntryField picobolEntryField = (PicobolEntryField)this.guiComponent;
            this.inputFilter = string;
            if (picobolEntryField != null) {
                picobolEntryField.setInputFilter(this.inputFilter);
            }
        }
    }

    private boolean checkMinMax(String string) {
        if (this.minValue != 0 || this.maxValue != 0) {
            String string2 = null;
            double d2 = 0.0;
            try {
                d2 = Double.parseDouble(string.replace(',', '.'));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (d2 < (double)this.minValue || d2 > (double)this.maxValue) {
                string2 = Factory.getSysMsg("ef_out_of_range_msg_part1") + " " + this.minValue + " " + Factory.getSysMsg("ef_out_of_range_msg_part2") + " " + this.maxValue;
                if (this.msgboxlistener != null) {
                    this.msgboxlistener.sendMsgBox(new MsgBoxEvent(this.guiComponent, string2, Factory.getSysMsg("ef_error_msg_title")));
                }
                return false;
            }
        }
        return true;
    }

    protected LocalFontCmp getFontCmp() {
        EntryField entryField = (EntryField)((Object)this.guiComponent);
        Font font = entryField.getFont();
        if (font != null) {
            return new SwingFontCmp(this.gf, font);
        }
        return null;
    }

    private class FastCellRenderer
    extends JLabel
    implements ListCellRenderer {
        int matcherstart = -1;
        int matcherend = -1;
        String tmatcher = null;
        Matcher matcher = null;
        LocalFontCmp fcmp = null;

        private FastCellRenderer() {
        }

        @Override
        public void paint(Graphics graphics) {
            if (RemoteEntryField.this.proposalFilterType > 0) {
                this.fcmp = RemoteEntryField.this.getFontCmp();
                this.matcherstart = -1;
                this.matcherend = -1;
                this.tmatcher = null;
                this.matcher = null;
                this.matcher = RemoteEntryField.this.regex.matcher("");
                this.printMatcher(graphics, this.getText(), this.getWidth(), 0, this.fcmp.getAscent(), this.getHeight());
            } else {
                super.paint(graphics);
            }
        }

        private void printMatcher(Graphics graphics, String string, int n2, int n3, int n4, int n5) {
            int n6 = -1;
            int n7 = -1;
            String string2 = string;
            if (string2 != null && string2.length() > 0) {
                boolean bl = false;
                int n8 = -1;
                int n9 = -1;
                if (this.matcher != null) {
                    this.matcher.reset(string2);
                    if (this.matcher.find()) {
                        n8 = this.matcher.start();
                        n9 = this.matcher.end();
                        this.tmatcher = this.matcher.group();
                        bl = true;
                    }
                }
                if (bl) {
                    String string3 = "";
                    String string4 = "";
                    String string5 = "";
                    try {
                        string3 = string2.substring(0, n8);
                        string4 = string2.substring(n8, n9);
                        string5 = string2.substring(n9, string2.length());
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    FontMetrics fontMetrics = this.fcmp.getFontMetrics();
                    n6 = SwingUtilities.computeStringWidth(fontMetrics, string3);
                    n7 = SwingUtilities.computeStringWidth(fontMetrics, this.tmatcher);
                    graphics.setColor(this.getForeground());
                    graphics.drawString(string3, n3, n4);
                    graphics.setColor(RemoteEntryField.this.matchingTextColorBackground);
                    graphics.fillRect(n3 + n6, 0, n7, n5);
                    if (RemoteEntryField.this.matchingTextColorForeground != null) {
                        graphics.setColor(RemoteEntryField.this.matchingTextColorForeground);
                    } else {
                        graphics.setColor(this.getForeground());
                    }
                    graphics.drawString(string4, n3 + n6, n4);
                    graphics.setColor(this.getForeground());
                    graphics.drawString(string5, n3 + n6 + n7, n4);
                } else {
                    graphics.drawString(string2, n3, n4);
                }
            } else {
                graphics.drawString(string2, n3, n4);
            }
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
            Color color;
            Color color2;
            if (bl) {
                color2 = jList.getSelectionBackground();
                color = jList.getSelectionForeground();
            } else {
                color2 = jList.getBackground();
                color = jList.getForeground();
            }
            if (!jList.isEnabled()) {
                color2 = color2.darker();
                color = color.darker();
            }
            this.setBackground(color2);
            this.setForeground(color);
            this.setText((String)object);
            return this;
        }
    }

    private class RolloverBorderManager
    extends MouseAdapter {
        Border mouseEnterBorder;
        Border mouseExitBorder;

        RolloverBorderManager(Border border) {
            this.mouseEnterBorder = border;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (RemoteEntryField.this.guiComponent != null) {
                EntryField entryField = (EntryField)((Object)RemoteEntryField.this.guiComponent);
                this.mouseExitBorder = entryField.getBorder();
                entryField.setBorder(this.mouseEnterBorder);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (RemoteEntryField.this.guiComponent != null) {
                EntryField entryField = (EntryField)((Object)RemoteEntryField.this.guiComponent);
                entryField.setBorder(this.mouseExitBorder);
                this.mouseExitBorder = null;
            }
        }
    }

    private class NotifyChangeTimer
    extends Timer
    implements ActionListener {
        short ed1;

        public NotifyChangeTimer(int n2) {
            super(n2, null);
            this.setRepeats(false);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RemoteEntryField.this.sendNtfChangeEvent(this.ed1);
        }

        synchronized void setEd1(short s2) {
            this.ed1 = s2;
        }
    }
}

