/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.RemoteFileDialog;
import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import com.iscobol.gui.client.Client;
import com.iscobol.gui.client.KeyboardBuffer;
import com.iscobol.gui.client.swing.ImagePreview;
import com.iscobol.gui.client.swing.MyFilter;
import com.iscobol.rmi.server.UnicastRemoteObject;
import com.iscobol.rts.Factory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;

public class RemoteFileDialogImpl
extends UnicastRemoteObject
implements RemoteFileDialog,
HierarchyListener {
    private static final long serialVersionUID = 5653654635463L;
    private JFileChooser theDialog;
    private int mode;
    private int flags;
    private int returnCode = -1;
    private boolean acuCompatibility;
    private boolean multiSelection;
    private boolean checkReplace;
    private FileSystemView view = FileSystemView.getFileSystemView();
    private boolean internalFilterEnabled;
    private final AbstractGuiFactoryImpl gf;

    public RemoteFileDialogImpl() {
        this.gf = null;
    }

    public RemoteFileDialogImpl(boolean bl, boolean bl2, AbstractGuiFactoryImpl abstractGuiFactoryImpl) {
        this.acuCompatibility = bl;
        this.internalFilterEnabled = bl2;
        this.gf = abstractGuiFactoryImpl;
    }

    private boolean check() {
        File file;
        int n2;
        File file2 = this.theDialog.getSelectedFile();
        if (file2 == null) {
            return true;
        }
        if (this.checkReplace && (this.mode == 1 || this.mode == 3) && file2.exists() && (n2 = JOptionPane.showConfirmDialog(null, Factory.getSysMsg("replace_file"), null, 0)) != 0) {
            return false;
        }
        if (this.mode == 0 || this.mode == 1) {
            if ((this.flags & 0x800) != 0 && file2.getParentFile() != null && !file2.getParentFile().exists()) {
                JOptionPane.showMessageDialog(null, Factory.getSysMsg("path_dont_exist"), null, 2);
                return false;
            }
            if (file2.exists()) {
                if ((this.flags & 0x8000) != 0 && !file2.canWrite()) {
                    JOptionPane.showMessageDialog(null, Factory.getSysMsg("file_read_only"), null, 2);
                    return false;
                }
            } else if (this.mode == 0) {
                if ((this.flags & 0x2000) != 0) {
                    n2 = JOptionPane.showConfirmDialog(null, Factory.getSysMsg("create_file"), null, 0);
                    if (n2 != 0) {
                        return false;
                    }
                } else if ((this.flags & 0x1000) != 0) {
                    JOptionPane.showMessageDialog(null, Factory.getSysMsg("file_not_found"), null, 2);
                    return false;
                }
            }
        }
        if ((file = file2.getParentFile()) != null && !file.isDirectory()) {
            JOptionPane.showMessageDialog(null, Factory.getSysMsg("invalid_selection"), null, 2);
            return false;
        }
        return true;
    }

    @Override
    public void init(String string, int n2, String string2, int n3, int n4) throws IOException {
        final FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        this.theDialog = new JFileChooser(com.iscobol.rts.File.getcwd()){

            @Override
            public void approveSelection() {
                if (RemoteFileDialogImpl.this.check()) {
                    super.approveSelection();
                }
            }

            @Override
            public boolean accept(File file) {
                if ((RemoteFileDialogImpl.this.flags & 2) != 0 && fileSystemView.isComputerNode(file) && file.getPath().startsWith("\\\\")) {
                    return false;
                }
                return super.accept(file);
            }

            @Override
            protected JDialog createDialog(Component component) throws HeadlessException {
                JDialog jDialog = super.createDialog(component);
                if (RemoteFileDialogImpl.this.gf != null && RemoteFileDialogImpl.this.gf.getIcon() != null) {
                    jDialog.setIconImage(RemoteFileDialogImpl.this.gf.getIcon());
                }
                return jDialog;
            }
        };
        this.theDialog.setAcceptAllFileFilterUsed(Client.isWebClient());
        this.flags = n4;
        if ((this.flags & 1) == 1) {
            this.theDialog.setAccessory(new ImagePreview(this.theDialog));
        }
        this.theDialog.setDialogTitle(string);
        this.multiSelection = (n2 & 0x10) != 0;
        this.theDialog.setMultiSelectionEnabled(this.multiSelection);
        this.checkReplace = (n2 & 0x20) != 0 || (this.flags & 2) != 0;
        this.mode = n2 & 0xF;
        if (this.mode == 3 || this.mode == 2) {
            if ((this.flags & 0x4000) != 0) {
                this.theDialog.setFileSelectionMode(2);
            } else {
                this.theDialog.setFileSelectionMode(1);
            }
        } else {
            this.theDialog.setFileSelectionMode(0);
        }
        if (string2 != null) {
            FileSystemView fileSystemView2 = this.internalFilterEnabled ? this.view : null;
            MyFilter myFilter = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
            int n5 = 1;
            while (stringTokenizer.hasMoreTokens()) {
                FileFilter fileFilter;
                String string3 = stringTokenizer.nextToken();
                if (Client.isWebClient()) {
                    if (stringTokenizer.hasMoreTokens()) {
                        String string4 = stringTokenizer.nextToken();
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string4, ";");
                        ArrayList<String> arrayList = new ArrayList<String>();
                        while (stringTokenizer2.hasMoreTokens()) {
                            String string5 = stringTokenizer2.nextToken();
                            int n6 = string5.lastIndexOf(46);
                            if (n6 < 0 || (string5 = string5.substring(n6 + 1)).equals("") || string5.equals("*")) continue;
                            arrayList.add(string5);
                        }
                        fileFilter = !arrayList.isEmpty() ? new FileNameExtensionFilter(string3, arrayList.toArray(new String[arrayList.size()])) : null;
                    } else {
                        fileFilter = null;
                    }
                } else {
                    fileFilter = stringTokenizer.hasMoreTokens() ? new MyFilter(string3, stringTokenizer.nextToken(), fileSystemView2) : new MyFilter(string3, "*", fileSystemView2);
                }
                if (fileFilter != null) {
                    this.theDialog.addChoosableFileFilter(fileFilter);
                }
                if (myFilter == null) {
                    myFilter = fileFilter;
                }
                if (n5 == n3) {
                    myFilter = fileFilter;
                }
                ++n5;
            }
            if (myFilter != null) {
                this.theDialog.setFileFilter(myFilter);
            }
        } else if (this.internalFilterEnabled) {
            this.theDialog.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return RemoteFileDialogImpl.intAccept(file, RemoteFileDialogImpl.this.view);
                }

                @Override
                public String getDescription() {
                    return "";
                }
            });
        }
    }

    static boolean intAccept(File file, FileSystemView fileSystemView) {
        return fileSystemView.isFileSystem(file) || fileSystemView.isComputerNode(file) || file.isFile();
    }

    @Override
    public int getTheObjectId() throws IOException {
        return 0;
    }

    @Override
    public void setFile(String string) throws IOException {
        this.theDialog.setSelectedFile(new File(string));
    }

    @Override
    public String[] getFiles() throws IOException {
        if (this.returnCode == 0) {
            String[] stringArray;
            if (this.multiSelection) {
                File[] fileArray = this.theDialog.getSelectedFiles();
                if (fileArray == null) {
                    fileArray = new File[]{};
                }
                String[] stringArray2 = new String[fileArray.length];
                for (int i2 = 0; i2 < fileArray.length; ++i2) {
                    stringArray2[i2] = fileArray[i2].getName();
                }
                return stringArray2;
            }
            File file = this.theDialog.getSelectedFile();
            if (file != null) {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = file.getName();
            } else {
                stringArray = null;
            }
            return stringArray;
        }
        return null;
    }

    @Override
    public void setDirectory(String string) throws IOException {
        File file = string != null ? com.iscobol.rts.File.get(string) : this.getDefaultDirectory();
        this.theDialog.setCurrentDirectory(file);
    }

    private File getDefaultDirectory() {
        File file = new File(System.getProperty("user.dir", ".")).getAbsoluteFile();
        if (this.acuCompatibility) {
            File file2 = this.findComputerDirectory(file);
            return file2 != null ? file2 : file;
        }
        return file;
    }

    private File findComputerDirectory(File file) {
        File file2 = file;
        while (file2 != null && !this.view.isDrive(file2)) {
            file2 = this.view.getParentDirectory(file2);
        }
        if (file2 != null) {
            file2 = this.view.getParentDirectory(file2);
        }
        return file2;
    }

    @Override
    public String getDirectory() throws IOException {
        if (this.returnCode == 0) {
            File file = this.theDialog.getCurrentDirectory();
            File file2 = this.theDialog.getSelectedFile();
            if (file != null && file2 != null && file.toString().equals(file2.toString())) {
                return file2.toPath().getParent().toString();
            }
            return file != null ? file.getAbsolutePath() : null;
        }
        return null;
    }

    @Override
    public void show() throws IOException {
        KeyboardBuffer.enable(null);
        if (!Client.isWebClient()) {
            this.theDialog.addHierarchyListener(this);
        }
        if (this.mode == 1 || this.mode == 3) {
            this.multiSelection = false;
            this.returnCode = this.theDialog.showSaveDialog(null);
        } else {
            this.checkReplace = false;
            this.returnCode = this.theDialog.showOpenDialog(null);
        }
    }

    @Override
    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        if ((hierarchyEvent.getChangeFlags() & 4L) == 4L && this.theDialog.isDisplayable()) {
            Container container;
            for (container = this.theDialog.getParent(); container != null && !(container instanceof JDialog); container = container.getParent()) {
            }
            if (container != null) {
                final JDialog jDialog = (JDialog)container;
                final Dimension dimension = jDialog.getSize();
                jDialog.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentResized(ComponentEvent componentEvent) {
                        Dimension dimension2 = jDialog.getSize();
                        if (dimension2.width < dimension.width || dimension2.height < dimension.height) {
                            dimension2.width = Math.max(dimension.width, dimension2.width);
                            dimension2.height = Math.max(dimension.height, dimension2.height);
                            jDialog.setSize(dimension2);
                        }
                    }
                });
            }
        }
    }

    @Override
    public String[] createFile(String string, String string2) throws IOException {
        File file = string == null || new File(string2).isAbsolute() ? new File(string2) : new File(string, string2);
        return new String[]{file.getName(), file.getAbsolutePath()};
    }

    @Override
    public String createDir(String string) throws IOException {
        if (string != null) {
            return new File(string).getAbsolutePath();
        }
        return null;
    }
}

