/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.ParamElementSize;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.client.swing.CompositeLabel;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class RemoteLabel
extends RemoteBaseGUIControl {
    private boolean vertical;
    private boolean noKeyLetter;
    private boolean transparent;
    private boolean border;
    private String title = "";
    private boolean isLabelOffsetSet;
    private int labelOffset;
    private boolean centered;
    private boolean left;
    private boolean right;
    private boolean top;
    private boolean bottom;
    private boolean useDefaultBorderWithBoxedStyle;
    private final boolean alwaysShowPicobolLabel;

    public RemoteLabel(GuiFactoryImpl guiFactoryImpl) {
        super(guiFactoryImpl);
        this.useDefaultBorderWithBoxedStyle = guiFactoryImpl.getCsProperty().get("iscobol.gui.native_style", false);
        this.alwaysShowPicobolLabel = guiFactoryImpl.getCsProperty().get("iscobol.m25646", false);
    }

    @Override
    public float getDefaultWidth() {
        if (this.title.length() == 0) {
            return 0.0f;
        }
        return this.font.computeScreenWidth(this.title) / this.font.getWidth() + 1;
    }

    @Override
    public float getDefaultHeight() {
        if (this.vertical) {
            return 0.0f;
        }
        return 1.0f;
    }

    @Override
    public void setCols(float f2) {
    }

    @Override
    public void setRows(float f2) {
    }

    @Override
    public void setRowsCols(float f2, float f3) {
    }

    @Override
    public void initialize() {
        if (this.guiComponent != null) {
            return;
        }
        this.labelInit();
    }

    void labelInit() {
        CompositeLabel compositeLabel = new CompositeLabel(this.alwaysShowPicobolLabel);
        this.setComponent(compositeLabel);
        super.intInitialize();
        compositeLabel.setVertical(this.vertical);
        if (this.top) {
            compositeLabel.setTop(true);
        } else if (this.bottom) {
            compositeLabel.setBottom(true);
        }
        if (this.centered) {
            compositeLabel.setCentered(true);
        } else if (this.left) {
            compositeLabel.setLeft(true);
        } else if (this.right) {
            compositeLabel.setRight(true);
        }
        this.setTitle(this.title);
        this.setBorder(this.border);
        compositeLabel.setNoKeyLetter(this.noKeyLetter);
        compositeLabel.setTransparent(this.transparent);
    }

    @Override
    public int getGUIControlHeight(float f2) {
        int n2 = 0;
        if (this.font != null) {
            n2 = (int)((float)this.font.getHeight() * f2);
        }
        return n2;
    }

    @Override
    public int getGUIControlWidth(float f2) {
        int n2 = 0;
        if (this.font != null) {
            n2 = (int)((float)this.font.getWidth() * f2);
        }
        return n2;
    }

    @Override
    public float getSizes() {
        float f2 = super.getSizes();
        if (f2 == 0.0f) {
            Dimension dimension = this.guiComponent.getPreferredSize();
            f2 = dimension.width / this.font.getWidth();
        }
        return f2;
    }

    @Override
    public String getValue() {
        return null;
    }

    @Override
    public void setBorder(boolean bl) {
        this.border = bl;
        if (this.guiComponent != null && !this.useDefaultBorderWithBoxedStyle) {
            ((CompositeLabel)this.getComponent()).setBorder(bl);
        }
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String string) {
        this.title = string;
        if (this.guiComponent != null) {
            ((CompositeLabel)this.guiComponent).setTitle(string);
        }
    }

    @Override
    public void setStyle(int n2, boolean bl) {
        CompositeLabel compositeLabel = (CompositeLabel)this.guiComponent;
        if ((n2 & 0x1000) == 4096) {
            this.vertical = bl;
            if (compositeLabel != null) {
                compositeLabel.setVertical(bl);
            }
        }
        if ((n2 & 4) == 4) {
            this.centered = bl;
            if (compositeLabel != null) {
                compositeLabel.setCentered(bl);
            }
        }
        if ((n2 & 1) == 1) {
            this.left = bl;
            if (compositeLabel != null) {
                compositeLabel.setLeft(bl);
            }
        }
        if ((n2 & 2) == 2) {
            this.right = bl;
            if (compositeLabel != null) {
                compositeLabel.setRight(bl);
            }
        }
        if ((n2 & 0x100) == 256) {
            this.top = bl;
            if (compositeLabel != null) {
                compositeLabel.setTop(bl);
            }
        }
        if ((n2 & 0x200) == 512) {
            this.bottom = bl;
            if (compositeLabel != null) {
                compositeLabel.setBottom(bl);
            }
        }
        if ((n2 & 8) == 8) {
            this.noKeyLetter = bl;
            if (compositeLabel != null) {
                compositeLabel.setNoKeyLetter(bl);
            }
        }
        if ((n2 & 0x10) == 16) {
            this.transparent = bl;
            if (compositeLabel != null) {
                compositeLabel.setTransparent(bl);
            }
        }
    }

    @Override
    public boolean isSelfAct() {
        return false;
    }

    @Override
    public boolean isInputField() {
        return false;
    }

    @Override
    public void displayProp() {
    }

    @Override
    protected void intFocusGained(boolean bl) {
    }

    @Override
    public void setElementAt(int[] nArray) {
    }

    @Override
    public void setImage(int n2, int n3, int n4, int n5) {
    }

    @Override
    public String setProp(Integer n2, String string, int n3) {
        String string2 = "0";
        int n4 = -1;
        boolean bl = false;
        try {
            n4 = (int)Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            bl = true;
        }
        if (n2 == 133) {
            if (!bl) {
                if (this.guiComponent != null) {
                    this.y -= this.calcLabelOffsetPx(this.getLabelOffset());
                    this.labelOffset = n4;
                    this.isLabelOffsetSet = true;
                    this.setLocation(this.x, this.y);
                } else {
                    this.labelOffset = n4;
                    this.isLabelOffsetSet = true;
                }
                string2 = "1";
            }
        } else {
            return super.setProp(n2, string, n3);
        }
        return "";
    }

    int getLabelOffset() {
        if (this.isLabelOffsetSet) {
            return this.labelOffset;
        }
        if (this.parentWindow != null) {
            return this.parentWindow.getLabelOffset();
        }
        return 0;
    }

    @Override
    public String setValue(String string) {
        this.setTitle(string);
        return null;
    }

    @Override
    public void setLocation(int n2, int n3, boolean bl) {
        super.setLocation(n2, n3 + this.calcLabelOffsetPx(this.getLabelOffset()), bl);
    }

    @Override
    public Rectangle getBounds() {
        Rectangle rectangle = this.getRealBounds();
        rectangle.y -= this.calcLabelOffsetPx(this.getLabelOffset());
        return rectangle;
    }

    @Override
    public Rectangle getRealBounds() {
        Rectangle rectangle = this.guiComponent != null ? this.guiComponent.getBounds() : new Rectangle(this.x, this.y, this.width, this.height);
        return rectangle;
    }

    private int calcLabelOffsetPx(int n2) {
        return ((RemoteDisplayWindow)this.parentWindow).getCellHeight() * n2 / 100;
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    public void handleResponse(int n2, int n3) {
    }

    @Override
    public void handleResponse(int n2, RemoteRecordAccept remoteRecordAccept) {
        super.handleResponse(n2, remoteRecordAccept);
    }

    @Override
    protected float paramgetDefaultHeight(ParamElementSize paramElementSize, int n2) {
        if (this.vertical) {
            return this.paramgetDefaultDimension(paramElementSize, n2, false);
        }
        return super.paramgetDefaultHeight(paramElementSize, n2);
    }

    @Override
    protected float paramgetDefaultWidth(ParamElementSize paramElementSize, int n2) {
        if (this.vertical) {
            if (this.font != null) {
                return this.font.getHeight() / this.getParentBGW().getCellWidth();
            }
            return 1.7f;
        }
        return this.paramgetDefaultDimension(paramElementSize, n2, true);
    }

    private float paramgetDefaultDimension(ParamElementSize paramElementSize, int n2, boolean bl) {
        if (bl && (paramElementSize.sizes > 0.0f || !paramElementSize.sizesInCells)) {
            return paramElementSize.sizes;
        }
        if (!bl && paramElementSize.lines > 0.0f) {
            return paramElementSize.lines;
        }
        if (paramElementSize.title != null) {
            String string = paramElementSize.title;
            if (this.font == null) {
                if (bl) {
                    return string.length();
                }
                return string.length() * this.getParentBGW().getCellWidth() / this.getParentBGW().getCellHeight() + 1;
            }
            float f2 = 0.0f;
            f2 = bl ? this.font.computeScreenSizes(string) : (float)(this.font.computeScreenWidth(string) / this.font.getHeight() + 1);
            return f2;
        }
        if (paramElementSize.ccOlen != -1) {
            int n3 = Math.max(paramElementSize.ccOlen, paramElementSize.ccPIClen != -1 ? paramElementSize.ccPIClen : 0);
            if (bl) {
                return n3;
            }
            return n3 * this.getParentBGW().getCellWidth() / this.getParentBGW().getCellHeight() + 1;
        }
        return super.paramgetDefaultWidth(paramElementSize, n2);
    }

    @Override
    public String getType() {
        return "label";
    }

    @Override
    public void adjustBounds(Rectangle rectangle) {
        rectangle.y -= this.calcLabelOffsetPx(this.getLabelOffset());
    }

    @Override
    public Dimension loadDimension0(Dimension dimension) {
        if (this.title == null || this.title.length() == 0) {
            return null;
        }
        return super.loadDimension0(dimension);
    }

    @Override
    public void setCurrentColumn(float f2) {
        this.setcurrentcolumn = f2;
    }

    @Override
    public float getCurrentColumn() {
        if (this.setcurrentcolumn > 0.0f) {
            return this.setcurrentcolumn;
        }
        return super.getCurrentColumn();
    }

    @Override
    public JComponent getDragDropComponent() {
        if (this.guiComponent != null) {
            return (CompositeLabel)this.guiComponent;
        }
        return null;
    }

    @Override
    public void setDragMode(int n2) {
        super.setDragMode(n2);
        if (n2 > 0 && this.guiComponent != null) {
            ((CompositeLabel)this.guiComponent).setTransferHandler(new TransferHandler("text"));
            DragMouseAdapter dragMouseAdapter = new DragMouseAdapter();
            ((CompositeLabel)this.guiComponent).addMouseListener(dragMouseAdapter);
        }
    }

    private class DragMouseAdapter
    extends MouseAdapter {
        private DragMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            JComponent jComponent = (JComponent)mouseEvent.getSource();
            CompositeLabel compositeLabel = (CompositeLabel)RemoteLabel.this.guiComponent;
            TransferHandler transferHandler = compositeLabel.getTransferHandler();
            transferHandler.exportAsDrag(compositeLabel, mouseEvent, 1);
        }
    }
}

