/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.ColorCmp;
import com.iscobol.gui.IsguiWorker;
import com.iscobol.gui.MyTransferable;
import com.iscobol.gui.PagedListBoxEvent;
import com.iscobol.gui.PagedListBoxListener;
import com.iscobol.gui.ParamElementSize;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.LocalImage;
import com.iscobol.gui.client.ZoomLayout;
import com.iscobol.gui.client.swing.CobolEventCouple;
import com.iscobol.gui.client.swing.GradientManager;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.ListBox;
import com.iscobol.gui.client.swing.MassUpdatePanel;
import com.iscobol.gui.client.swing.NotifyMouseEvent;
import com.iscobol.gui.client.swing.NotifyMouseListener;
import com.iscobol.gui.client.swing.PicobolListBox;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import com.iscobol.gui.client.swing.SwingListBoxDataProvider;
import com.iscobol.gui.client.swing.SwingWorker;
import com.iscobol.gui.export.ExportUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;

public class RemoteListBox
extends RemoteBaseGUIControl
implements PagedListBoxListener,
NotifyMouseListener {
    private static final float DEFAULT_INSETS = 0.8f;
    private static final float DEFAULT_WIDTH = 8.0f;
    public static final int SINGLE_SELECTION = 1;
    public static final int SINGLE_INTERVAL_SELECTION = 2;
    public static final int MULTIPLE_INTERVAL_SELECTION = 4;
    private boolean notifySelChange;
    private boolean notifyDblClik;
    private boolean unsorted;
    private boolean noSearch;
    private boolean _3d;
    private boolean boxed;
    private boolean noBox;
    private boolean lower;
    private boolean upper;
    private boolean checkList;
    private int insertionIndex;
    private int[] lastSelectedIndices = new int[0];
    private String lastSelectionValue;
    private int selectionIndex = -1;
    private int queryIndex;
    private int resetList;
    private int thumbPosition;
    private boolean paged;
    private int sortOrder = -1;
    private int massUpdate;
    private Vector items = new Vector();
    private Vector dataColumns = new Vector();
    private Vector displayColumns = new Vector();
    private Vector alignments = new Vector();
    private Vector separators = new Vector();
    private Vector dividers = new Vector();
    private Vector rowColorPatterns = new Vector();
    private String valueStr = "";
    private boolean dataColumnsChanged;
    private boolean displayColumnsChanged;
    private boolean alignmentsChanged;
    private boolean separatorsChanged;
    private boolean dividersChanged;
    private boolean rowColorPatternsChanged;
    private int mousewheellinestoscroll = 1;
    private ListBox.ListItem curritem;
    private Color borderColor;
    private ColorCmp borderColorCmp;
    private int borderColorIdx;
    private Integer lmOnColumns;
    private PropertyChangeListener pcListener;
    private boolean pagedListenerAdded;
    private boolean useDefaultBorderWithBoxedStyle;
    private Border defaultBorder;
    private int selectionMode;
    private String exportFileName;
    private String exportFileFormat;
    private boolean exportFileopen;
    private boolean f4ShowsSearchBox;
    private final boolean acuCompatibility;
    private Integer selectionColor;
    private Integer selectionBackgroundColor;
    private Integer selectionForegroundColor;
    private boolean selectionBackgroundRgb;
    private boolean selectionForegroundRgb;
    private GradientManager gradientMgr = new GradientManager();
    private int searchpanel = 0;
    private String matchingTextColor;
    private boolean lastmousevalueisexit = true;

    public RemoteListBox(GuiFactoryImpl guiFactoryImpl) {
        super(guiFactoryImpl);
        this.useDefaultBorderWithBoxedStyle = guiFactoryImpl.getCsProperty().get("iscobol.gui.native_style", false);
        this.f4ShowsSearchBox = guiFactoryImpl.getCsProperty().get("iscobol.key.f4.system", true);
        this.acuCompatibility = guiFactoryImpl.getCsProperty().get("iscobol.properties.acu_compat", false);
        this.matchingTextColor = guiFactoryImpl.getCsProperty().get("iscobol.gui.matching_text_color", null);
        this.pcListener = propertyChangeEvent -> {
            if (guiFactoryImpl != null) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("iscobol.gui.list.lm_on_columns")) {
                    if (this.lmOnColumns != null) {
                        this.setLmOnColumns();
                    }
                } else if (string.equals("iscobol.gui.matching_text_color")) {
                    this.setMatchingTextColor(guiFactoryImpl.getCsProperty().get(string, null));
                } else if (string.equals("iscobol.key.f4.system")) {
                    this.setF4ShowsSearchBox(guiFactoryImpl.getCsProperty().get(string, true));
                }
            }
        };
        guiFactoryImpl.getCsProperty().addPropertyChangeListener(this.pcListener);
    }

    private void setF4ShowsSearchBox(boolean bl) {
        this.f4ShowsSearchBox = bl;
        if (this.guiComponent != null) {
            this.getListBox().setF4ShowsSearchBox(this.f4ShowsSearchBox);
        }
    }

    private PicobolListBox getListBox() {
        if (this.guiComponent != null) {
            return (PicobolListBox)((MassUpdatePanel)this.guiComponent).getComponent();
        }
        return null;
    }

    @Override
    public void displayProp() {
        Enumeration enumeration;
        boolean bl;
        PicobolListBox picobolListBox = this.getListBox();
        boolean bl2 = bl = this.dataColumnsChanged || this.displayColumnsChanged || this.separatorsChanged || this.dividersChanged || this.alignmentsChanged || this.rowColorPatternsChanged;
        if (this.dataColumnsChanged) {
            enumeration = this.dataColumns.elements();
            while (enumeration.hasMoreElements()) {
                picobolListBox.addDataColumn((Integer)enumeration.nextElement());
            }
            this.dataColumns.clear();
            this.dataColumnsChanged = false;
        }
        if (this.displayColumnsChanged) {
            enumeration = this.displayColumns.elements();
            while (enumeration.hasMoreElements()) {
                picobolListBox.addDisplayColumn((Integer)enumeration.nextElement());
            }
            this.displayColumns.clear();
            this.displayColumnsChanged = false;
        }
        if (this.separatorsChanged) {
            enumeration = this.separators.elements();
            while (enumeration.hasMoreElements()) {
                picobolListBox.addSeparator((Integer)enumeration.nextElement());
            }
            this.separators.clear();
            this.separatorsChanged = false;
        }
        if (this.dividersChanged) {
            enumeration = this.dividers.elements();
            while (enumeration.hasMoreElements()) {
                picobolListBox.addDivider((Integer)enumeration.nextElement());
            }
            this.dividers.clear();
            this.dividersChanged = false;
        }
        if (this.alignmentsChanged) {
            enumeration = this.alignments.elements();
            while (enumeration.hasMoreElements()) {
                picobolListBox.addAlignment((String)enumeration.nextElement());
            }
            this.alignments.clear();
            this.alignmentsChanged = false;
        }
        if (this.rowColorPatternsChanged) {
            picobolListBox.setRowColorPattern(this.rowColorPatterns);
        }
        if (bl) {
            this.getListBox().buildColumns();
        }
    }

    @Override
    public float getDefaultHeight() {
        return 0.8f;
    }

    @Override
    public float getDefaultWidth() {
        return 8.0f;
    }

    private Insets getBorderInsets() {
        if (this.guiComponent != null) {
            PicobolListBox picobolListBox = this.getListBox();
            Border border = picobolListBox.getBorder();
            if (border != null) {
                return border.getBorderInsets(picobolListBox);
            }
            return new Insets(0, 0, 0, 0);
        }
        Border border = this.createBorder();
        if (border != null) {
            return border.getBorderInsets(new JList());
        }
        return new Insets(0, 0, 0, 0);
    }

    @Override
    public int getGUIControlHeight(float f2) {
        int n2 = Math.round((float)this.font.getHeight() * f2);
        Insets insets = this.getBorderInsets();
        return n2 += insets.top + insets.bottom;
    }

    @Override
    public int getGUIControlWidth(float f2) {
        int n2 = this.font.computeScreenWidth("0");
        if (this.font.getCellWidth() > 0) {
            n2 = this.font.getCellWidth();
        }
        int n3 = Math.round((float)n2 * f2);
        n3 += ListBox.BUTTON_PANEL_WIDTH;
        Insets insets = this.getBorderInsets();
        n3 += insets.right + insets.left;
        for (int i2 = 0; i2 < this.dividers.size(); ++i2) {
            n3 += ((Integer)this.dividers.elementAt(i2)).intValue();
        }
        return n3;
    }

    @Override
    public String getProp(int n2) {
        if (this.guiComponent == null) {
            return "";
        }
        PicobolListBox picobolListBox = this.getListBox();
        switch (n2) {
            case 2075: {
                return "" + this.gradientMgr.getOrientation();
            }
            case 2076: {
                return this.gradientMgr.getColor1AsString();
            }
            case 2078: {
                return this.gradientMgr.getColor2AsString();
            }
            case 355: {
                return this.exportFileFormat != null ? this.exportFileFormat : "";
            }
            case 354: {
                return this.exportFileName != null ? this.exportFileName : "";
            }
            case 426: {
                return this.exportFileopen ? "1" : "0";
            }
            case 330: {
                StringBuffer stringBuffer = new StringBuffer();
                int[] nArray = picobolListBox.getSelectedIndicesModel();
                if (nArray.length > 0) {
                    stringBuffer.append(nArray[0] + 1);
                }
                for (int i2 = 1; i2 < nArray.length; ++i2) {
                    stringBuffer.append(' ');
                    stringBuffer.append(nArray[i2] + 1);
                }
                return stringBuffer.toString();
            }
            case 329: {
                return "" + this.selectionMode;
            }
            case 132: {
                if (this.queryIndex > 0 && this.queryIndex <= picobolListBox.getItemCount()) {
                    return picobolListBox.getItemAt(this.queryIndex - 1);
                }
                return null;
            }
            case 210: {
                if (this.paged) {
                    return picobolListBox.getSearchText();
                }
                return "";
            }
            case 212: {
                int n3 = picobolListBox.getSelectedIndexModel();
                if (n3 > -1) {
                    ++n3;
                }
                return "" + n3;
            }
            case 238: {
                this.thumbPosition = picobolListBox.getThumbPosition();
                return "" + this.thumbPosition;
            }
            case 283: {
                return "" + this.mousewheellinestoscroll;
            }
            case 287: {
                if (!this.checkList && !this.selectionBackgroundRgb && this.selectionBackgroundColor != null) {
                    return this.selectionBackgroundColor.toString();
                }
                ColorCmp colorCmp = new ColorCmp(true);
                colorCmp.setBackRGB(picobolListBox.getSelectionBackground().getRGB());
                Color color = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(colorCmp.getBackground(), false));
                return Integer.toString(color != null ? color.getRGB() : 0);
            }
            case 288: {
                if (!this.checkList && !this.selectionForegroundRgb && this.selectionForegroundColor != null) {
                    return this.selectionForegroundColor.toString();
                }
                ColorCmp colorCmp = new ColorCmp(true);
                colorCmp.setForeRGB(picobolListBox.getSelectionForeground().getRGB());
                Color color = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(colorCmp.getForeground(), false));
                return Integer.toString(color != null ? color.getRGB() : 0);
            }
            case 383: {
                if (this.selectionColor != null) {
                    return this.selectionColor.toString();
                }
                return "0";
            }
            case 325: {
                if (this.borderColorCmp != null) {
                    return Integer.toString(this.borderColorIdx >= 0 ? this.borderColorIdx : this.borderColorCmp.getForeground());
                }
                return null;
            }
            case 369: {
                if (this.curritem != null) {
                    return Integer.toString(this.curritem.getColor());
                }
                return null;
            }
            case 372: {
                if (this.curritem != null) {
                    return Integer.toString(this.curritem.getForegroundColor());
                }
                return null;
            }
            case 370: {
                if (this.curritem != null) {
                    return Integer.toString(this.curritem.getBackgroundColor());
                }
                return null;
            }
        }
        return super.getProp(n2);
    }

    @Override
    public Object getPropObject(int n2) {
        Object object = null;
        PicobolListBox picobolListBox = this.getListBox();
        switch (n2) {
            case 115: {
                object = picobolListBox.getHiddenDataItemAt(this.queryIndex - 1);
            }
        }
        return object;
    }

    @Override
    public String getTitle() {
        return null;
    }

    @Override
    public String getValue() {
        if (this.guiComponent == null) {
            return "";
        }
        PicobolListBox picobolListBox = this.getListBox();
        String string = picobolListBox.getSelectedIndexModel() >= 0 ? picobolListBox.getSelectedValueModel() : "";
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed() && mouseEvent.getClickCount() == 2 && this.notifyDblClik) {
            this.selectionIndex = this.getListBox().getSelectedIndexModel() + 1;
            CobolEventCouple cobolEventCouple = new CobolEventCouple(this, new RemoteRecordAccept(16, 18, (short)this.selectionIndex));
            this.pushEvent(cobolEventCouple);
            mouseEvent.consume();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 40: {
                return;
            }
            case 115: {
                if (!this.paged || this.noSearch || !this.f4ShowsSearchBox) break;
                return;
            }
        }
        super.keyPressed(keyEvent);
    }

    private void responseOnAction(int n2) {
        if ((RemoteDisplayWindow)this.parentWindow != null) {
            ((RemoteDisplayWindow)this.parentWindow).stopTimer();
        }
        PicobolListBox picobolListBox = this.getListBox();
        if (n2 == 1) {
            int[] nArray = picobolListBox.getSelectedIndices();
            boolean bl = this.equal(this.lastSelectedIndices, nArray);
            if (this.notifySelChange && !bl) {
                short s2 = 0;
                int n3 = picobolListBox.getLastMouseSelectedIndex();
                if (n3 >= -1) {
                    s2 = (short)(n3 + 1);
                } else {
                    int n4;
                    int n5 = this.lastSelectedIndices != null ? this.lastSelectedIndices.length : 0;
                    int n6 = n4 = nArray != null ? nArray.length : 0;
                    if (n5 == n4) {
                        s2 = (short)(nArray[0] + 1);
                    } else if (n5 > n4) {
                        if (n4 > 0) {
                            for (int n7 : this.lastSelectedIndices) {
                                boolean bl2 = false;
                                for (int n8 : nArray) {
                                    if (n7 != n8) continue;
                                    bl2 = true;
                                    break;
                                }
                                if (bl2) continue;
                                s2 = (short)(n7 + 1);
                                break;
                            }
                        } else {
                            s2 = (short)(this.lastSelectedIndices[0] + 1);
                        }
                    } else if (n5 > 0) {
                        for (int n9 : nArray) {
                            boolean bl3 = false;
                            for (int n10 : this.lastSelectedIndices) {
                                if (n9 != n10) continue;
                                bl3 = true;
                                break;
                            }
                            if (bl3) continue;
                            s2 = (short)(n9 + 1);
                            break;
                        }
                    } else {
                        s2 = (short)(nArray[0] + 1);
                    }
                }
                s2 = (short)(picobolListBox.convertRowIndexToModel(s2 - 1) + 1);
                CobolEventCouple cobolEventCouple = new CobolEventCouple(this, new RemoteRecordAccept(6, 96, 4099, s2, 0, true, true, true));
                this.pushEvent(cobolEventCouple);
            }
            if (!bl) {
                this.setSelectionIndices(nArray);
            }
            this.valueStr = this.lastSelectedIndices.length > 0 ? picobolListBox.getItemAt(this.lastSelectedIndices[this.lastSelectedIndices.length - 1]) : "";
        }
    }

    private boolean equal(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] == nArray2[i2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void initialize() {
        Object object;
        if (this.guiComponent != null) {
            return;
        }
        PicobolListBox picobolListBox = new PicobolListBox(this.gf, this.paged, this.noSearch, this.checkList, this.useDefaultBorderWithBoxedStyle, this.gradientMgr);
        picobolListBox.setUpperLowerMethod(this.gf.getUpperLowerMethod());
        picobolListBox.setPW(this.getParentWindow().getMainWindow().getMyWindow().getRootWindow());
        MassUpdatePanel massUpdatePanel = new MassUpdatePanel(picobolListBox);
        massUpdatePanel.setMassUpdate(this.massUpdate != 0);
        this.guiComponent = massUpdatePanel;
        if (this.useDefaultBorderWithBoxedStyle) {
            this.defaultBorder = new JTextField().getBorder();
        }
        super.intInitialize();
        this.intSetBorder();
        this.guiComponent.setSize(this.width, this.height);
        picobolListBox.setUnsorted(this.unsorted);
        if (this.upper) {
            picobolListBox.setUpper(this.upper);
        } else if (this.lower) {
            picobolListBox.setLower(this.lower);
        } else {
            picobolListBox.setLower(this.gf.getGuiKdbLower());
            picobolListBox.setUpper(this.gf.getGuiKdbUpper());
        }
        picobolListBox.setF4ShowsSearchBox(this.f4ShowsSearchBox);
        if (this.selectionColor != null) {
            object = this.getColors(this.selectionColor);
            picobolListBox.setSelectionBackground(object[0]);
            picobolListBox.setSelectionForeground(object[1]);
        } else {
            if (this.selectionBackgroundColor != null) {
                object = this.getBackgroundColor(this.selectionBackgroundColor, this.selectionBackgroundRgb);
                picobolListBox.setSelectionBackground((Color)object);
            }
            if (this.selectionForegroundColor != null) {
                object = this.getForegroundColor(this.selectionForegroundColor, this.selectionForegroundRgb);
                picobolListBox.setSelectionForeground((Color)object);
            }
        }
        picobolListBox.addItemListener(itemEvent -> this.responseOnAction(itemEvent.getStateChange()));
        picobolListBox.addKeyListener(this);
        if (this.paged) {
            picobolListBox.addPagedListBoxListener(this);
            this.pagedListenerAdded = true;
        }
        this.setSelectionMode(this.selectionMode);
        if (this.items.size() > 0) {
            Enumeration enumeration = this.items.elements();
            while (enumeration.hasMoreElements()) {
                picobolListBox.addItem((ListBox.ListItem)enumeration.nextElement(), -1);
            }
            this.items.clear();
        }
        if (this.sortOrder != -1) {
            picobolListBox.setSortOrder(this.sortOrder);
        }
        if (this.selectionIndex > 0 && this.selectionIndex <= picobolListBox.getItemCount()) {
            this.select(this.selectionIndex - 1);
        }
        if (this.valueStr != null) {
            this.setValue(this.valueStr);
        }
        picobolListBox.setThumbPosition(this.thumbPosition);
        picobolListBox.setMouseWheelLinesToScroll(this.mousewheellinestoscroll);
        this.setLmOnColumns();
        if (this.searchpanel != 0) {
            picobolListBox.setSearchPanel(this.searchpanel);
        }
        if (this.notifymouse) {
            picobolListBox.addNotifyMouseListener(this);
        }
        this.setMatchingTextColor(this.matchingTextColor);
    }

    private void setLmOnColumns() {
        PicobolListBox picobolListBox = this.getListBox();
        if (picobolListBox != null) {
            if (this.lmOnColumns != null) {
                picobolListBox.setLmOnColumns(this.lmOnColumns > 0);
            } else {
                picobolListBox.setLmOnColumns(this.gf.getCsProperty().get("iscobol.gui.list.lm_on_columns", 1) > 0);
            }
        }
    }

    @Override
    public void search(PagedListBoxEvent pagedListBoxEvent) {
        String string = pagedListBoxEvent.getSearchText();
        CobolEventCouple cobolEventCouple = new CobolEventCouple(this, new RemoteRecordAccept(6, 96, 4107, (short)string.length(), 0, true, true, true));
        this.pushEvent(cobolEventCouple);
    }

    @Override
    public void firstItem(PagedListBoxEvent pagedListBoxEvent) {
        if (pagedListBoxEvent.getCause() == 0) {
            this.lastSelectionValue = null;
            if (this.getListBox().getItemCount() > 0) {
                this.lastSelectedIndices = new int[]{0};
            }
        }
        CobolEventCouple cobolEventCouple = new CobolEventCouple(this, new RemoteRecordAccept(6, 96, 4105, true, true, true));
        this.pushEvent(cobolEventCouple);
    }

    @Override
    public void lastItem(PagedListBoxEvent pagedListBoxEvent) {
        if (pagedListBoxEvent.getCause() == 0) {
            this.lastSelectionValue = null;
            int n2 = this.getListBox().getItemCount();
            if (n2 > 0) {
                this.lastSelectedIndices = new int[]{n2 - 1};
            }
        }
        CobolEventCouple cobolEventCouple = new CobolEventCouple(this, new RemoteRecordAccept(6, 96, 4106, true, true, true));
        this.pushEvent(cobolEventCouple);
    }

    @Override
    public void prevItem(PagedListBoxEvent pagedListBoxEvent) {
        if (pagedListBoxEvent.getCause() == 0) {
            this.lastSelectionValue = null;
        }
        CobolEventCouple cobolEventCouple = new CobolEventCouple(this, new RemoteRecordAccept(6, 96, 4102, true, true, true));
        this.pushEvent(cobolEventCouple);
    }

    @Override
    public void nextItem(PagedListBoxEvent pagedListBoxEvent) {
        if (pagedListBoxEvent.getCause() == 0) {
            this.lastSelectionValue = null;
        }
        CobolEventCouple cobolEventCouple = new CobolEventCouple(this, new RemoteRecordAccept(6, 96, 4101, true, true, true));
        this.pushEvent(cobolEventCouple);
    }

    @Override
    public void prevPage(PagedListBoxEvent pagedListBoxEvent) {
        if (pagedListBoxEvent.getCause() == 0) {
            this.lastSelectionValue = null;
        }
        CobolEventCouple cobolEventCouple = new CobolEventCouple(this, new RemoteRecordAccept(6, 96, 4104, true, true, true));
        this.pushEvent(cobolEventCouple);
    }

    @Override
    public void nextPage(PagedListBoxEvent pagedListBoxEvent) {
        if (pagedListBoxEvent.getCause() == 0) {
            this.lastSelectionValue = null;
        }
        CobolEventCouple cobolEventCouple = new CobolEventCouple(this, new RemoteRecordAccept(6, 96, 4103, true, true, true));
        this.pushEvent(cobolEventCouple);
    }

    @Override
    protected void intFocusGained(boolean bl) {
    }

    @Override
    public boolean isSelfAct() {
        return false;
    }

    @Override
    public void setBorder(boolean bl) {
    }

    @Override
    public void setElementAt(int n2) {
        this.queryIndex = n2;
        this.setCurrentItem(n2);
    }

    @Override
    public void setElementAt(int[] nArray) {
        this.setElementAt(nArray[0]);
    }

    @Override
    public void setImage(int n2, int n3, int n4, int n5) {
    }

    private void setDataColumn(int n2) {
        if (n2 == 0) {
            this.removeDataColumns();
        } else {
            this.addDataColumn(n2);
        }
    }

    private void setDisplayColumn(int n2) {
        if (n2 == 0) {
            this.removeDisplayColumns();
        } else {
            this.addDisplayColumn(n2);
        }
    }

    private void setSeparation(int n2) {
        if (n2 == -1) {
            this.removeSeparations();
        } else {
            this.addSeparator(n2);
        }
    }

    private void setDivider(int n2) {
        if (n2 == -1) {
            this.removeDividers();
        } else {
            this.addDivider(n2);
        }
    }

    private void setRowColorPattern(int n2) {
        if (n2 == -1) {
            this.removeRowColorPatterns();
        } else {
            this.addRowColorPattern(this.getColors(n2));
        }
    }

    private void setRowForegroundColorPattern(int n2, boolean bl) {
        if (n2 == -1) {
            this.removeRowColorPatterns();
        } else {
            this.addRowForegroundColorPattern(this.getForegroundColor(n2, bl));
        }
    }

    private void setRowBackgroundColorPattern(int n2, boolean bl) {
        if (n2 == -1) {
            this.removeRowColorPatterns();
        } else {
            this.addRowBackgroundColorPattern(this.getBackgroundColor(n2, bl));
        }
    }

    @Override
    public String setProp(int n2, int[] nArray) {
        int n3 = 0;
        switch (n2) {
            case 67: {
                boolean bl = false;
                int n4 = 0;
                if (nArray.length == this.displayColumns.size()) {
                    for (n3 = 0; !bl && n3 < nArray.length; ++n3) {
                        n4 = (Integer)this.displayColumns.elementAt(n3);
                        if (nArray[n3] == n4) continue;
                        bl = true;
                    }
                } else {
                    bl = true;
                }
                if (!bl) break;
                this.removeDisplayColumns();
                this.setDisplayColumn(1);
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    if (nArray[n3] == 1) continue;
                    this.setDisplayColumn(nArray[n3]);
                }
                break;
            }
            case 63: {
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    this.setDataColumn(nArray[n3]);
                }
                break;
            }
            case 217: {
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    this.setSeparation(nArray[n3]);
                }
                break;
            }
            case 71: {
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    this.setDivider(nArray[n3]);
                }
                break;
            }
            case 199: {
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    this.setRowColorPattern(nArray[n3]);
                }
                break;
            }
            case 204: {
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    this.setRowForegroundColorPattern(nArray[n3], false);
                }
                break;
            }
            case 205: {
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    this.setRowForegroundColorPattern(nArray[n3], true);
                }
                break;
            }
            case 196: {
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    this.setRowBackgroundColorPattern(nArray[n3], false);
                }
                break;
            }
            case 197: {
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    this.setRowBackgroundColorPattern(nArray[n3], true);
                }
                break;
            }
        }
        return "1";
    }

    @Override
    public String setProp(Integer n2, String[] stringArray) {
        PicobolListBox picobolListBox = this.getListBox();
        String string = "0";
        if (stringArray == null) {
            return "0";
        }
        int n3 = 0;
        switch (n2) {
            case 129: {
                boolean bl = this.notifySelChange;
                this.notifySelChange = false;
                for (n3 = 0; n3 < stringArray.length; ++n3) {
                    stringArray[n3] = ScreenUtility.rightTrim(stringArray[n3]);
                    if (stringArray[n3].length() <= 0) continue;
                    this.curritem = new ListBox.ListItem(stringArray[n3]);
                    if (this.guiComponent == null) {
                        this.items.add(this.curritem);
                        continue;
                    }
                    picobolListBox.addItem(this.curritem, -1);
                }
                this.notifySelChange = bl;
                string = "1";
                break;
            }
            case 2: 
            case 63: 
            case 67: 
            case 71: 
            case 196: 
            case 197: 
            case 199: 
            case 204: 
            case 205: 
            case 217: {
                for (n3 = 0; n3 < stringArray.length; ++n3) {
                    this.setProp(n2, stringArray[n3], stringArray[n3].length());
                }
                break;
            }
        }
        return string;
    }

    private ListBox.ListItem rightTrim(ListBox.ListItem listItem) {
        ListBox.ListItem listItem2;
        int n2;
        for (n2 = listItem.text.length() - 1; n2 >= 0 && listItem.text.charAt(n2) == ' '; --n2) {
        }
        int n3 = listItem.text.length() - 1 - n2;
        if (n3 > 0) {
            byte[] byArray = new byte[listItem.bytes.length - n3];
            System.arraycopy(listItem.bytes, 0, byArray, 0, byArray.length);
            listItem2 = new ListBox.ListItem(byArray);
        } else {
            listItem2 = listItem;
        }
        return listItem2;
    }

    @Override
    public String setProp(Integer n2, byte[] byArray, int n3) {
        String string = "0";
        PicobolListBox picobolListBox = this.getListBox();
        switch (n2) {
            case 129: {
                ListBox.ListItem listItem = new ListBox.ListItem(byArray);
                this.curritem = listItem = this.rightTrim(listItem);
                if (listItem.text.length() > 0) {
                    if (this.guiComponent == null) {
                        this.items.add(listItem);
                    } else {
                        boolean bl = this.notifySelChange;
                        this.notifySelChange = false;
                        int n4 = this.lastSelectedIndices.length > 0 ? this.lastSelectedIndices[0] : -1;
                        String string2 = null;
                        if (!this.paged || this.noSearch || !picobolListBox.isSearchBoxVisible()) {
                            string2 = this.lastSelectionValue;
                        }
                        picobolListBox.addItem(listItem, this.insertionIndex - 1);
                        if (!(this.paged && !this.noSearch && picobolListBox.isSearchBoxVisible() && picobolListBox.findAndSelectSearchedText(false) || string2 != null && picobolListBox.setSelectedValue(string2) >= 0)) {
                            if (n4 > -1) {
                                this.select(n4);
                            } else if (this.acuCompatibility && this.paged && this.valueStr.length() > 0) {
                                picobolListBox.setSelectedValue(ScreenUtility.rightTrim(this.valueStr));
                            }
                        }
                        this.insertionIndex = 0;
                        this.notifySelChange = bl;
                    }
                }
                string = "1";
                break;
            }
            case 132: {
                if (picobolListBox != null && this.queryIndex > 0 && this.queryIndex <= picobolListBox.getItemCount()) {
                    ListBox.ListItem listItem = new ListBox.ListItem(byArray);
                    this.curritem = listItem = this.rightTrim(listItem);
                    picobolListBox.removeItem(this.queryIndex - 1);
                    picobolListBox.addItem(listItem, this.queryIndex - 1);
                }
                string = "1";
                break;
            }
            case 115: {
                if (this.curritem != null) {
                    this.curritem.setHiddenData(byArray);
                }
                string = "1";
            }
        }
        return string;
    }

    @Override
    public String setProp(Integer n2, String string, int n3) {
        PicobolListBox picobolListBox = this.getListBox();
        String string2 = "0";
        int n4 = -1;
        boolean bl = false;
        try {
            n4 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            bl = true;
        }
        boolean bl2 = false;
        switch (n2) {
            case 2086: {
                Object object = this.gf.getClient().getId(n4);
                this.gradientMgr.setImage(object instanceof LocalImage ? ((LocalImage)object).getImage() : null);
                break;
            }
            case 2087: {
                this.gradientMgr.setImageScale(n4);
                break;
            }
            case 2076: {
                this.gradientMgr.setColor1(n4, false, this.gf);
                break;
            }
            case 2077: {
                this.gradientMgr.setColor1(n4, true, this.gf);
                break;
            }
            case 2078: {
                this.gradientMgr.setColor2(n4, false, this.gf);
                break;
            }
            case 2079: {
                this.gradientMgr.setColor2(n4, true, this.gf);
                break;
            }
            case 2075: {
                this.gradientMgr.setOrientation(n4);
                break;
            }
            case 355: {
                this.exportFileFormat = string != null ? string.trim() : null;
                break;
            }
            case 354: {
                this.exportFileName = string != null ? string.trim() : null;
                break;
            }
            case 426: {
                this.exportFileopen = n4 >= 1;
                break;
            }
            case 1: {
                if (bl) break;
                this.setAction(n4);
                string2 = "1";
                break;
            }
            case 329: {
                this.setSelectionMode(n4);
                string2 = "1";
                break;
            }
            case 310: {
                this.lmOnColumns = n4;
                this.setLmOnColumns();
                break;
            }
            case 326: {
                bl2 = true;
            }
            case 325: {
                if (n4 < 0 || bl2) {
                    this.borderColorCmp = new ColorCmp(true);
                    this.borderColorIdx = -1;
                    this.borderColorCmp.setForeRGB(n4);
                    this.borderColor = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(this.borderColorCmp.getForeground(), false));
                } else {
                    this.borderColorCmp = new ColorCmp(n4);
                    this.borderColorIdx = n4;
                    this.borderColor = this.gf.getRemotePalette().getDefaultColor(this.borderColorCmp.getForeground());
                }
                if (!this.isBoxed()) break;
                this.intSetBorder();
                break;
            }
            case 124: {
                if (bl) break;
                this.insertionIndex = n4;
                string2 = "1";
                break;
            }
            case 177: {
                if (bl) break;
                this.queryIndex = n4;
                this.setCurrentItem(n4);
                string2 = "1";
                break;
            }
            case 142: {
                if (bl) break;
                this.massUpdate = n4;
                if (this.massUpdate != 0 && !this.isVisible() && this.parentWindow != null) {
                    this.parentWindow.showVisible(this);
                }
                if (picobolListBox != null) {
                    boolean bl3 = this.massUpdate != 0;
                    boolean bl4 = this.parentWindow != null && ((RemoteDisplayWindow)this.parentWindow).getFocusOwner() == this;
                    new IsguiWorker(true, () -> {
                        ((MassUpdatePanel)this.guiComponent).setMassUpdate(bl3);
                        if (bl4) {
                            this.guiComponent.requestFocus();
                        }
                    }).start();
                }
                string2 = "1";
                break;
            }
            case 212: {
                if (bl) break;
                this.selectionIndex = n4;
                if (this.selectionIndex == -1) {
                    this.deselect();
                } else {
                    this.select();
                }
                string2 = "1";
                break;
            }
            case 190: {
                if (bl) break;
                this.resetList = n4;
                if (this.resetList != 0) {
                    this.removeAll();
                }
                this.curritem = null;
                string2 = "1";
                break;
            }
            case 238: {
                if (bl) break;
                this.thumbPosition = n4;
                if (picobolListBox != null) {
                    picobolListBox.setThumbPosition(this.thumbPosition);
                }
                string2 = "1";
                break;
            }
            case 224: {
                if (bl) break;
                this.sortOrder = n4;
                this.setSortOrder();
                string2 = "1";
                break;
            }
            case 63: {
                if (bl) break;
                this.setDataColumn(n4);
                string2 = "1";
                break;
            }
            case 67: {
                if (bl) break;
                this.setDisplayColumn(n4);
                string2 = "1";
                break;
            }
            case 2: {
                String string3 = string.trim();
                if (string3.length() == 0) {
                    this.removeAlignments();
                } else {
                    this.addAlignment(string3);
                }
                string2 = "1";
                break;
            }
            case 217: {
                if (bl) break;
                this.setSeparation(n4);
                string2 = "1";
                break;
            }
            case 71: {
                if (bl) break;
                this.setDivider(n4);
                string2 = "1";
                break;
            }
            case 199: {
                if (bl) break;
                this.setRowColorPattern(n4);
                string2 = "1";
                break;
            }
            case 204: {
                if (bl) break;
                this.setRowForegroundColorPattern(n4, false);
                string2 = "1";
                break;
            }
            case 205: {
                if (bl) break;
                this.setRowForegroundColorPattern(n4, true);
                string2 = "1";
                break;
            }
            case 196: {
                if (bl) break;
                this.setRowBackgroundColorPattern(n4, false);
                string2 = "1";
                break;
            }
            case 197: {
                if (bl) break;
                this.setRowBackgroundColorPattern(n4, true);
                string2 = "1";
                break;
            }
            case 188: {
                this.removeDataColumns();
                this.removeDisplayColumns();
                this.removeAlignments();
                this.removeDividers();
                this.removeSeparations();
                string2 = "1";
                break;
            }
            case 130: {
                if (bl) break;
                if (n4 > 0) {
                    this.removeItem(n4 - 1);
                }
                string2 = "1";
                break;
            }
            case 129: {
                String string4 = ScreenUtility.rightTrim(string);
                if (string4.length() > 0) {
                    ListBox.ListItem listItem;
                    this.curritem = listItem = new ListBox.ListItem(string4);
                    if (this.guiComponent == null) {
                        this.items.add(listItem);
                    } else {
                        boolean bl5 = this.notifySelChange;
                        this.notifySelChange = false;
                        int n5 = this.lastSelectedIndices.length > 0 ? this.lastSelectedIndices[0] : -1;
                        String string5 = this.lastSelectionValue;
                        picobolListBox.addItem(listItem, this.insertionIndex - 1);
                        PicobolListBox picobolListBox2 = this.getListBox();
                        if (this.paged && !this.noSearch && picobolListBox2.isSearchBoxVisible()) {
                            picobolListBox2.findAndSelectSearchedText(false);
                        } else if (string5 != null) {
                            picobolListBox.setSelectedValue(string5);
                        } else if (n5 > -1) {
                            this.select(n5);
                        } else if (this.acuCompatibility && this.paged && this.valueStr.length() > 0) {
                            picobolListBox.setSelectedValue(ScreenUtility.rightTrim(this.valueStr));
                        }
                        this.insertionIndex = 0;
                        this.notifySelChange = bl5;
                    }
                }
                string2 = "1";
                break;
            }
            case 132: {
                if (picobolListBox != null && this.queryIndex > 0 && this.queryIndex <= picobolListBox.getItemCount()) {
                    String string6 = ScreenUtility.rightTrim(string);
                    picobolListBox.removeItem(this.queryIndex - 1);
                    this.curritem = new ListBox.ListItem(string6);
                    picobolListBox.addItem(this.curritem, this.queryIndex - 1);
                }
                string2 = "1";
                break;
            }
            case 283: {
                this.mousewheellinestoscroll = n4;
                if (picobolListBox == null) break;
                picobolListBox.setMouseWheelLinesToScroll(this.mousewheellinestoscroll);
                break;
            }
            case 115: {
                if (this.curritem == null) break;
                this.curritem.setHiddenData(string);
                break;
            }
            case 369: {
                if (bl) break;
                if (this.curritem != null) {
                    this.curritem.setColor(n4);
                    Color[] colorArray = this.getColors(n4);
                    this.curritem.setBackground(colorArray[0]);
                    this.curritem.setForeground(colorArray[1]);
                    if (picobolListBox != null) {
                        picobolListBox.refreshItem(this.curritem);
                    }
                }
                string2 = "1";
                break;
            }
            case 371: {
                bl2 = true;
            }
            case 370: {
                if (bl) break;
                if (this.curritem != null) {
                    this.curritem.setBackgroundColor(n4);
                    Color color = this.getBackgroundColor(n4, bl2);
                    this.curritem.setBackground(color);
                    if (picobolListBox != null) {
                        picobolListBox.refreshItem(this.curritem);
                    }
                }
                string2 = "1";
                break;
            }
            case 373: {
                bl2 = true;
            }
            case 372: {
                if (bl) break;
                if (this.curritem != null) {
                    this.curritem.setForegroundColor(n4);
                    Color color = this.getForegroundColor(n4, bl2);
                    this.curritem.setForeground(color);
                    if (picobolListBox != null) {
                        picobolListBox.refreshItem(this.curritem);
                    }
                }
                string2 = "1";
                break;
            }
            case 383: {
                if (bl || this.checkList) break;
                this.selectionColor = n4;
                if (picobolListBox != null) {
                    Color[] colorArray = this.getColors(n4);
                    picobolListBox.setSelectionBackground(colorArray[0]);
                    picobolListBox.setSelectionForeground(colorArray[1]);
                }
                string2 = "1";
                break;
            }
            case 384: {
                bl2 = true;
            }
            case 287: {
                if (bl || this.checkList) break;
                this.selectionBackgroundColor = n4;
                this.selectionBackgroundRgb = bl2;
                if (picobolListBox != null) {
                    Color color = this.getBackgroundColor(n4, bl2);
                    picobolListBox.setSelectionBackground(color);
                }
                string2 = "1";
                break;
            }
            case 385: {
                bl2 = true;
            }
            case 288: {
                if (bl || this.checkList) break;
                this.selectionForegroundColor = n4;
                this.selectionForegroundRgb = bl2;
                if (picobolListBox != null) {
                    Color color = this.getForegroundColor(n4, bl2);
                    picobolListBox.setSelectionForeground(color);
                }
                string2 = "1";
                break;
            }
            case 374: {
                this.handleBorderWidths(string);
                if (!this.isBoxed()) break;
                this.setBoxedStyle();
                break;
            }
            case 330: {
                if (string != null) {
                    int n6;
                    if (string.trim().length() == 0) {
                        if (picobolListBox != null) {
                            picobolListBox.clearSelection();
                        }
                        string2 = "1";
                        break;
                    }
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    int n7 = n6 = picobolListBox != null ? picobolListBox.getItemCount() : 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        try {
                            int n8 = Integer.parseInt(stringTokenizer.nextToken());
                            if (n8 <= 0 || n8 > n6) continue;
                            arrayList.add(n8 - 1);
                        }
                        catch (NumberFormatException numberFormatException) {
                            arrayList.clear();
                            break;
                        }
                    }
                    if (arrayList.size() > 0) {
                        if (picobolListBox != null) {
                            int[] nArray = new int[arrayList.size()];
                            for (int i2 = 0; i2 < nArray.length; ++i2) {
                                nArray[i2] = (Integer)arrayList.get(i2);
                            }
                            picobolListBox.select(nArray);
                        }
                        string2 = "1";
                        break;
                    }
                    string2 = "0";
                    break;
                }
                string2 = "0";
                break;
            }
            case 393: {
                this.searchpanel = n4;
                if (picobolListBox == null) break;
                picobolListBox.setSearchPanel(n4);
                break;
            }
            default: {
                return super.setProp(n2, string, n3);
            }
        }
        return string2;
    }

    protected void setBoxedStyle() {
        if (this.guiComponent != null) {
            Border border = this.borderColor != null ? BorderFactory.createLineBorder(this.borderColor) : (this.useDefaultBorderWithBoxedStyle ? this.defaultBorder : BorderFactory.createLineBorder(Color.darkGray));
            if (this.borderWidths != null && this.borderWidths.size() > 0) {
                this.getListBox().setBorder(new MatteBorder(this.getBorder(0), this.getBorder(1), this.getBorder(2), this.getBorder(3), this.borderColor != null ? this.borderColor : Color.darkGray));
            } else {
                this.getListBox().setBorder(border);
            }
        }
    }

    @Override
    protected void setAction(int n2) {
        if (this.guiComponent == null) {
            return;
        }
        switch (n2) {
            case 2: {
                this.Copy();
                break;
            }
            case 33: {
                SwingUtilities.invokeLater(() -> {
                    this.Export();
                    CobolEventCouple cobolEventCouple = new CobolEventCouple(this, new RemoteRecordAccept(7, 0, 31, 0, 0, false, false, true));
                    this.pushEvent(cobolEventCouple);
                });
                break;
            }
            default: {
                super.setAction(n2);
            }
        }
    }

    private void Copy() {
        int n2;
        ListBox.ListItem[] listItemArray;
        Color color;
        Color color2;
        PicobolListBox picobolListBox = this.getListBox();
        int[] nArray = picobolListBox.getSelectedIndices();
        if (this.selectionMode <= 0 || nArray.length == 0) {
            color2 = picobolListBox.getBackground();
            color = picobolListBox.getForeground();
            listItemArray = new ListBox.ListItem[picobolListBox.getItemCount()];
            for (n2 = 0; n2 < listItemArray.length; ++n2) {
                listItemArray[n2] = picobolListBox.getListItemAt(n2);
            }
        } else {
            color2 = picobolListBox.getSelectionBackground();
            color = picobolListBox.getSelectionForeground();
            listItemArray = new ListBox.ListItem[nArray.length];
            for (n2 = 0; n2 < listItemArray.length; ++n2) {
                listItemArray[n2] = picobolListBox.getListItemAt(nArray[n2]);
            }
        }
        if (listItemArray.length == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = System.getProperty("line.separator", "\n");
        stringBuffer.append("<html>");
        stringBuffer.append("<body>");
        stringBuffer.append("<table style=\"font-family:");
        stringBuffer.append(this.font.getFamily());
        stringBuffer.append("; font-size:");
        stringBuffer.append(this.font.getSize());
        stringBuffer.append("pt;");
        if (this.font.isBold()) {
            stringBuffer.append(" font-weight:bold;");
        }
        if (this.font.isItalic()) {
            stringBuffer.append(" font-style:italic;");
        }
        stringBuffer.append(" background-color:#");
        stringBuffer.append(this.toHexString(color2));
        stringBuffer.append("; color:#");
        stringBuffer.append(this.toHexString(color));
        stringBuffer.append(";\">");
        int n3 = this.font.getHeight();
        ListBox.Column[] columnArray = picobolListBox.getColumns();
        for (int i2 = 0; i2 < listItemArray.length; ++i2) {
            String[] stringArray = picobolListBox.buildTokens(listItemArray[i2]);
            stringBuffer.append("<tr height=\"");
            stringBuffer.append(n3);
            stringBuffer.append("\">");
            for (int i3 = 0; i3 < columnArray.length; ++i3) {
                stringBuffer.append("<td width=\"");
                stringBuffer.append(columnArray[i3].width);
                stringBuffer.append("\">");
                String string2 = i3 < stringArray.length ? stringArray[i3] : "";
                stringBuffer2.append(string2);
                if (columnArray[i3].separator > 0 || columnArray[i3].alignment != 0) {
                    stringBuffer.append("<div style=\"");
                    if (columnArray[i3].separator > 0) {
                        stringBuffer.append("text-indent:");
                        stringBuffer.append(columnArray[i3].separator);
                        stringBuffer.append("px; ");
                    }
                    switch (columnArray[i3].alignment) {
                        case 1: {
                            stringBuffer.append("text-align:center;");
                            break;
                        }
                        case 2: {
                            stringBuffer.append("text-align:right;");
                        }
                    }
                    stringBuffer.append("\">");
                    stringBuffer.append(string2);
                    stringBuffer.append("</div>");
                } else {
                    stringBuffer.append(string2);
                }
                stringBuffer.append("</td>");
            }
            stringBuffer.append("</tr>");
            stringBuffer2.append(string);
        }
        stringBuffer.append("</table>");
        stringBuffer.append("</body>");
        stringBuffer.append("</html>");
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new MyTransferable(stringBuffer2.toString(), stringBuffer.toString()), null);
    }

    private void Export() {
        PicobolListBox picobolListBox = this.getListBox();
        ExportUtilities.exportExcel(false, picobolListBox, this.exportFileName, this.exportFileFormat, "isCobolListBox", "com.iscobol.misc.export.xls.XLSListBoxExporter", "com.iscobol.misc.export.xlsx.XLSXListBoxExporter", "List-Box", new SwingListBoxDataProvider(picobolListBox, this.selectionMode), this.exportFileopen, this.getGuiFactory().getIcon());
    }

    private String toHexString(Color color) {
        String string = Integer.toHexString(color.getRGB() & 0xFFFFFF);
        int n2 = 6 - string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            string = "0" + string;
        }
        return string;
    }

    protected boolean isBoxed() {
        return this.boxed || !this._3d && !this.noBox;
    }

    @Override
    public void setCols(float f2) {
    }

    @Override
    public void setRows(float f2) {
    }

    @Override
    public void setRowsCols(float f2, float f3) {
    }

    @Override
    public void setStyle(int n2, boolean bl) {
        PicobolListBox picobolListBox = this.getListBox();
        if ((n2 & 0x200) == 512) {
            this.notifySelChange = bl;
        }
        if ((n2 & 0x100) == 256) {
            this.notifyDblClik = bl;
        }
        if ((n2 & 1) == 1) {
            this.unsorted = bl;
        }
        if ((n2 & 0x400) == 1024) {
            this.paged = bl;
            if (picobolListBox != null) {
                picobolListBox.setPaged(this.paged);
                if (this.paged && !this.pagedListenerAdded) {
                    picobolListBox.addPagedListBoxListener(this);
                    this.pagedListenerAdded = true;
                }
            }
        }
        if ((n2 & 0x2000) == 8192) {
            this.noSearch = bl;
            if (picobolListBox != null) {
                picobolListBox.setNoSearch(this.noSearch);
            }
        }
        if ((n2 & 2) == 2) {
            this.noBox = bl;
        }
        if ((n2 & 4) == 4) {
            this.boxed = bl;
        }
        if ((n2 & 0x2000000) == 0x2000000) {
            this._3d = bl;
        }
        if ((n2 & 0x1000) == 4096) {
            this.lower = bl;
        }
        if ((n2 & 0x800) == 2048) {
            this.upper = bl;
        }
        if ((n2 & 0x8000) == 32768) {
            this.checkList = bl;
            if (picobolListBox != null) {
                picobolListBox.setCheckList(this.checkList);
            }
        }
    }

    @Override
    public void setTitle(String string) {
    }

    @Override
    public String setValue(String string) {
        this.valueStr = string;
        if (this.guiComponent != null && string != null) {
            int n2;
            PicobolListBox picobolListBox = this.getListBox();
            string = ScreenUtility.rightTrim(string);
            if (picobolListBox.getItemCount() > 0 && (n2 = picobolListBox.setSelectedValue(string)) >= 0) {
                this.setSelectionIndices(new int[]{n2});
                return string;
            }
            this.deselect();
            return null;
        }
        return null;
    }

    private void removeAll() {
        this.items.clear();
        if (this.guiComponent != null) {
            PicobolListBox picobolListBox = this.getListBox();
            picobolListBox.removeAllItems();
        }
    }

    private void removeItem(int n2) {
        PicobolListBox picobolListBox = this.getListBox();
        if (picobolListBox != null && n2 >= 0 && n2 < picobolListBox.getItemCount()) {
            picobolListBox.removeItem(n2);
        }
    }

    private void deselect() {
        if (this.guiComponent != null) {
            this.setSelectionIndices(new int[0]);
            this.getListBox().clearSelection();
        }
    }

    private void select() {
        if (this.guiComponent != null) {
            PicobolListBox picobolListBox = this.getListBox();
            if (this.selectionIndex > 0 && this.selectionIndex <= picobolListBox.getItemCount()) {
                int n2 = this.selectionIndex;
                if (!picobolListBox.isVisible()) {
                    this.parentWindow.showVisible(this);
                }
                new SwingWorker(true, () -> {
                    picobolListBox.select(n2 - 1);
                    this.setSelectionIndices(new int[]{n2 - 1});
                    this.valueStr = picobolListBox.getItemAt(this.lastSelectedIndices[0]);
                }).start();
            }
        }
    }

    private void select(int n2) {
        if (this.guiComponent != null) {
            PicobolListBox picobolListBox = this.getListBox();
            if (n2 >= 0 && n2 < picobolListBox.getItemCount()) {
                new SwingWorker(true, () -> picobolListBox.select(n2)).start();
            }
        }
    }

    public void addDataColumn(int n2) {
        this.dataColumns.addElement(n2);
        this.dataColumnsChanged = true;
    }

    public void addDisplayColumn(int n2) {
        this.displayColumns.addElement(n2);
        this.displayColumnsChanged = true;
    }

    public void addDivider(int n2) {
        this.dividers.addElement(n2);
        this.dividersChanged = true;
    }

    public void addRowColorPattern(Color[] colorArray) {
        this.rowColorPatterns.add(colorArray);
        this.rowColorPatternsChanged = true;
    }

    public void addRowForegroundColorPattern(Color color) {
        boolean bl = false;
        for (int i2 = 0; i2 < this.rowColorPatterns.size() && !bl; ++i2) {
            Color[] colorArray = (Color[])this.rowColorPatterns.elementAt(i2);
            if (colorArray[1] != null) continue;
            colorArray[1] = color;
            bl = true;
        }
        if (!bl) {
            this.rowColorPatterns.add(new Color[]{null, color});
        }
        this.rowColorPatternsChanged = true;
    }

    public void addRowBackgroundColorPattern(Color color) {
        boolean bl = false;
        for (int i2 = 0; i2 < this.rowColorPatterns.size() && !bl; ++i2) {
            Color[] colorArray = (Color[])this.rowColorPatterns.elementAt(i2);
            if (colorArray[0] != null) continue;
            colorArray[0] = color;
            bl = true;
        }
        if (!bl) {
            this.rowColorPatterns.add(new Color[]{color, null});
        }
        this.rowColorPatternsChanged = true;
    }

    public void addAlignment(String string) {
        this.alignments.addElement(string.toUpperCase());
        this.alignmentsChanged = true;
    }

    public void addSeparator(int n2) {
        this.separators.addElement(n2);
        this.separatorsChanged = true;
    }

    private void removeDataColumns() {
        this.dataColumns.clear();
        if (this.guiComponent != null) {
            this.getListBox().resetDataColumns();
        }
        this.dataColumnsChanged = true;
    }

    private void removeDisplayColumns() {
        this.displayColumns.clear();
        if (this.guiComponent != null) {
            this.getListBox().resetDisplayColumns();
        }
        this.displayColumnsChanged = true;
    }

    private void removeAlignments() {
        this.alignments.clear();
        if (this.guiComponent != null) {
            this.getListBox().resetAlignments();
        }
        this.alignmentsChanged = true;
    }

    private void removeSeparations() {
        this.separators.clear();
        if (this.guiComponent != null) {
            this.getListBox().resetSeparators();
        }
        this.separatorsChanged = true;
    }

    private void removeDividers() {
        this.dividers.clear();
        if (this.guiComponent != null) {
            this.getListBox().resetDividers();
        }
        this.dividersChanged = true;
    }

    private void removeRowColorPatterns() {
        this.rowColorPatterns.clear();
        if (this.guiComponent != null) {
            this.getListBox().setRowColorPattern(null);
        }
        this.rowColorPatternsChanged = true;
    }

    private void setSortOrder() {
        if (this.guiComponent != null) {
            this.getListBox().setSortOrder(this.sortOrder);
        }
    }

    @Override
    protected boolean requestFocusLostComponent(RemoteBaseGUIControl remoteBaseGUIControl, MouseEvent mouseEvent, RemoteRecordAccept remoteRecordAccept) {
        if (this.guiComponent != null) {
            this.getListBox().hideSearchBox();
        }
        return true;
    }

    private void intSetBorder() {
        if (this.guiComponent == null) {
            return;
        }
        Border border = this.createBorder();
        this.getListBox().setBorder(border);
    }

    private Border createBorder() {
        Object object = this._3d ? BorderFactory.createLoweredBevelBorder() : (this.noBox ? null : (this.useDefaultBorderWithBoxedStyle ? (this.borderColor != null ? BorderFactory.createLineBorder(this.borderColor) : this.defaultBorder) : (this.borderWidths != null && this.borderWidths.size() > 0 ? new MatteBorder(this.getBorder(0), this.getBorder(1), this.getBorder(2), this.getBorder(3), this.borderColor != null ? this.borderColor : Color.darkGray) : BorderFactory.createLineBorder(this.borderColor != null ? this.borderColor : Color.black))));
        return object;
    }

    @Override
    public void destroy() {
        if (this.gf != null && this.gf.getCsProperty() != null) {
            this.gf.getCsProperty().removePropertyChangeListener(this.pcListener);
        }
        PicobolListBox picobolListBox = this.getListBox();
        this.pcListener = null;
        if (this.guiComponent != null) {
            this.getListBox().dispose();
        }
        super.destroy();
    }

    @Override
    public void handleResponse(int n2, RemoteRecordAccept remoteRecordAccept) {
        super.handleResponse(n2, remoteRecordAccept);
        if (remoteRecordAccept.getEventType() == 4105 || remoteRecordAccept.getEventType() == 4106) {
            this.guiComponent.repaint();
        }
    }

    @Override
    public boolean isInputField() {
        return true;
    }

    @Override
    protected float paramgetDefaultHeight(ParamElementSize paramElementSize, int n2) {
        return 5.0f;
    }

    @Override
    protected float paramgetDefaultWidth(ParamElementSize paramElementSize, int n2) {
        if (paramElementSize.sizes > 0.0f) {
            return paramElementSize.sizes;
        }
        if (paramElementSize.ccPIClen != -1) {
            return paramElementSize.ccPIClen;
        }
        if (paramElementSize.ccOlen != -1) {
            return paramElementSize.ccOlen;
        }
        if (paramElementSize.ccIlen != -1) {
            return paramElementSize.ccIlen;
        }
        return super.paramgetDefaultWidth(paramElementSize, n2);
    }

    @Override
    public String getType() {
        return "listbox";
    }

    @Override
    public Point getReferencedPopupLocation(MouseEvent mouseEvent) {
        if (this.guiComponent != null) {
            return this.getListBox().getReferencedPopupLocation(mouseEvent);
        }
        return super.getReferencedPopupLocation(mouseEvent);
    }

    private void setCurrentItem(int n2) {
        PicobolListBox picobolListBox = this.getListBox();
        if (picobolListBox == null) {
            if (this.items != null && n2 > 0 && n2 <= this.items.size()) {
                this.curritem = (ListBox.ListItem)this.items.elementAt(n2 - 1);
            }
        } else {
            this.curritem = picobolListBox.getListItemAt(n2 - 1);
        }
    }

    @Override
    public void startCellEditing(boolean bl, MouseEvent mouseEvent) {
        PicobolListBox picobolListBox = this.getListBox();
        if (picobolListBox != null) {
            picobolListBox.setFocusable(true);
            picobolListBox.requestFocusInWindow();
            if (!this.checkList && bl) {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(SwingUtilities.convertMouseEvent((Component)mouseEvent.getSource(), mouseEvent, picobolListBox.getList()));
            }
        }
    }

    @Override
    public RemoteBaseGUIControl renderClone() {
        return this.renderClone(false, null);
    }

    @Override
    public RemoteBaseGUIControl renderClone(boolean bl, Dimension dimension) {
        RemoteListBox remoteListBox = null;
        try {
            remoteListBox = (RemoteListBox)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        remoteListBox.setComponent(null);
        if (this.items != null && this.items.size() > 0) {
            remoteListBox.copyitems(this.items);
            remoteListBox.initialize();
        } else {
            remoteListBox.initialize();
            remoteListBox.copyitems2(this.getListBox());
        }
        return remoteListBox;
    }

    private void copyitems(Vector vector) {
        if (vector != null && vector.size() > 0) {
            this.items = new Vector();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.items.add((String)enumeration.nextElement());
            }
        }
    }

    public void copyitems2(PicobolListBox picobolListBox) {
        PicobolListBox picobolListBox2 = this.getListBox();
        picobolListBox2.copyItems(picobolListBox);
    }

    private void setSelectionMode(int n2) {
        PicobolListBox picobolListBox = this.getListBox();
        int n3 = -1;
        switch (n2) {
            default: {
                n3 = 0;
                break;
            }
            case 2: {
                n3 = 1;
                break;
            }
            case 4: {
                n3 = 2;
            }
        }
        this.selectionMode = n2;
        if (picobolListBox != null) {
            picobolListBox.setSelectionMode(n3);
        }
    }

    @Override
    public Rectangle getBoundsWithoutDefaultWidth() {
        Rectangle rectangle = super.getBounds();
        if (rectangle != null && rectangle.width > 0) {
            rectangle.width -= ListBox.BUTTON_PANEL_WIDTH;
        }
        return rectangle;
    }

    @Override
    protected void addZoomLayoutDataFonts(ZoomLayout.ZoomLayoutData zoomLayoutData) {
        super.addZoomLayoutDataFonts(zoomLayoutData);
        zoomLayoutData.putAdditionalOrigFont(new ZoomLayout.FontProvider(){

            @Override
            public void setFont(Font font) {
                if (RemoteListBox.this.getListBox().getFindPanel() != null) {
                    RemoteListBox.this.getListBox().setFontFindComponents(font);
                }
            }

            @Override
            public Font getFont() {
                return RemoteListBox.this.getListBox().getFontFindComponents();
            }
        });
    }

    private void setSelectionIndices(int[] nArray) {
        this.lastSelectedIndices = nArray;
        this.lastSelectionValue = this.lastSelectedIndices.length > 0 ? this.getListBox().getItemAt(this.lastSelectedIndices[0]) : null;
    }

    @Override
    public RemoteRecordAccept getDropRRA(Point point) {
        return this.getDropRRA(point, null);
    }

    @Override
    public RemoteRecordAccept getDropRRA(Point point, Component component) {
        PicobolListBox picobolListBox = this.getListBox();
        int n2 = picobolListBox.getDropRow(point);
        return new RemoteRecordAccept(7, 0, 17043, (short)(n2 + 1), 0, false, false, true);
    }

    @Override
    public RemoteRecordAccept getDragRRA() {
        PicobolListBox picobolListBox = this.getListBox();
        return new RemoteRecordAccept(7, 0, 17042, (short)(picobolListBox.getSelectedIndexModel() + 1), 0, false, false, true);
    }

    @Override
    public JComponent getDragDropComponent() {
        PicobolListBox picobolListBox = this.getListBox();
        if (picobolListBox != null) {
            return picobolListBox.getDragDropComponent();
        }
        return null;
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.checkList) {
            if (!this.lastmousevalueisexit) {
                super.mouseExited(mouseEvent);
            }
            this.lastmousevalueisexit = true;
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void sendNotifyMouseData(NotifyMouseEvent notifyMouseEvent) {
        if (notifyMouseEvent.getMsg() != 17024 || !this.lastmousevalueisexit) {
            this.sendMsgNotifyMouse(notifyMouseEvent.getMsg(), notifyMouseEvent.getData1(), notifyMouseEvent.getData2(), true);
        }
        this.lastmousevalueisexit = notifyMouseEvent.getMsg() == 17024;
    }

    private void setMatchingTextColor(String string) {
        this.matchingTextColor = string;
        PicobolListBox picobolListBox = this.getListBox();
        if (picobolListBox != null && this.matchingTextColor != null) {
            boolean[] blArray = new boolean[1];
            Color[] colorArray = this.getFieldColors(this.matchingTextColor, blArray);
            if (blArray[0] && colorArray[0] != null) {
                picobolListBox.setMatchingTextColorBackground(colorArray[0]);
            } else {
                picobolListBox.setMatchingTextColorBackground(null);
            }
            if (blArray[0]) {
                picobolListBox.setMatchingTextColorForeground(colorArray[1]);
            } else {
                picobolListBox.setMatchingTextColorForeground(null);
            }
        }
    }
}

