/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.client.PlaySound;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

class RemotePlaySound
implements PlaySound,
LineListener {
    private InputStream iStream;
    private int flags;
    private Clip clip;
    private static RemotePlaySound currentPlaying;

    public RemotePlaySound(byte[] byArray, int n2) {
        if (byArray.length == 0 && currentPlaying != null) {
            currentPlaying.stop();
            currentPlaying = null;
        } else {
            this.iStream = new ByteArrayInputStream(byArray);
            this.flags = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean start() {
        if (this.clip == null) {
            this.clip = RemotePlaySound.getClip(this.iStream);
        }
        if (this.clip == null) {
            return false;
        }
        this.clip.addLineListener(this);
        if ((this.flags & 4) != 0 && currentPlaying != null) {
            currentPlaying.stop();
        }
        RemotePlaySound remotePlaySound = this;
        synchronized (remotePlaySound) {
            if ((this.flags & 2) != 0) {
                this.clip.loop(-1);
                if ((this.flags & 1) != 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } else {
                this.clip.start();
                if ((this.flags & 1) != 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        return true;
    }

    private static synchronized Clip getClip(InputStream inputStream) {
        Clip clip = null;
        if (inputStream == null) {
            return clip;
        }
        try {
            Object object;
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(inputStream);
            Object object2 = audioInputStream.getFormat();
            if (((AudioFormat)object2).getEncoding() == AudioFormat.Encoding.ULAW || ((AudioFormat)object2).getEncoding() == AudioFormat.Encoding.ALAW) {
                object = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, ((AudioFormat)object2).getSampleRate(), ((AudioFormat)object2).getSampleSizeInBits() * 2, ((AudioFormat)object2).getChannels(), ((AudioFormat)object2).getFrameSize() * 2, ((AudioFormat)object2).getFrameRate(), true);
                audioInputStream = AudioSystem.getAudioInputStream((AudioFormat)object, audioInputStream);
                object2 = object;
            }
            object = new DataLine.Info(Clip.class, audioInputStream.getFormat(), (int)audioInputStream.getFrameLength() * ((AudioFormat)object2).getFrameSize());
            clip = (Clip)AudioSystem.getLine((Line.Info)object);
            clip.open(audioInputStream);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
        }
        catch (LineUnavailableException lineUnavailableException) {
        }
        catch (IOException iOException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return clip;
    }

    @Override
    public void stop() {
        if (this.clip != null) {
            this.clip.stop();
            this.clip.setFramePosition(0);
        }
    }

    @Override
    public void close() {
        if (this.clip != null) {
            this.clip.close();
            this.clip = null;
        }
    }

    public void finalize() {
        this.close();
    }

    @Override
    public synchronized void update(LineEvent lineEvent) {
        if (lineEvent.getType() == LineEvent.Type.STOP) {
            this.notify();
            currentPlaying = null;
        } else if (lineEvent.getType() == LineEvent.Type.START) {
            currentPlaying = this;
        }
    }
}

