/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.RemoteProgressDialog;
import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import com.iscobol.gui.client.ClientRemoteObject;
import com.iscobol.gui.client.KeyboardBuffer;
import com.iscobol.gui.client.LocalImage;
import com.iscobol.gui.client.swing.BorderedFrame;
import com.iscobol.rts.Factory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class RemoteProgressDialogImpl
extends ClientRemoteObject
implements RemoteProgressDialog {
    private Window progressDialog;
    private ProgressDialogPanel panel;
    private boolean autoTime;
    private boolean noTime;
    private String cancelMessage;
    private long time;

    public RemoteProgressDialogImpl() throws IOException {
    }

    public RemoteProgressDialogImpl(String string, String string2, int n2, LocalImage localImage, BorderedFrame borderedFrame, AbstractGuiFactoryImpl abstractGuiFactoryImpl) throws IOException {
        Window window;
        if (string == null) {
            string = "W$PROGRESSDIALOG";
        }
        if (string2 == null) {
            string2 = "";
        }
        this.cancelMessage = string2;
        this.autoTime = (n2 & 2) == 2;
        this.noTime = (n2 & 4) == 4;
        boolean bl = (n2 & 1) == 1;
        boolean bl2 = (n2 & 0x10) == 16;
        JFrame jFrame = null;
        JDialog jDialog = null;
        if (bl) {
            if (borderedFrame != null) {
                if (borderedFrame.isJFrame()) {
                    jDialog = new JDialog(borderedFrame.getJFrame(), string, true);
                    this.progressDialog = jDialog;
                    window = borderedFrame.getJFrame();
                } else {
                    jDialog = new JDialog(borderedFrame.getJDialog(), string, true);
                    this.progressDialog = jDialog;
                    window = borderedFrame.getJDialog();
                }
            } else {
                jDialog = new JDialog((Frame)null, string, true);
                this.progressDialog = jDialog;
                window = null;
            }
        } else {
            jFrame = new JFrame(string);
            this.progressDialog = jFrame;
            window = null;
        }
        if (abstractGuiFactoryImpl != null && abstractGuiFactoryImpl.getIcon() != null) {
            if (jFrame != null) {
                jFrame.setIconImage(abstractGuiFactoryImpl.getIcon());
            } else {
                jDialog.setIconImage(abstractGuiFactoryImpl.getIcon());
            }
        }
        this.panel = new ProgressDialogPanel(localImage != null ? localImage.getImage() : null, bl2, this.cancelMessage);
        this.progressDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                RemoteProgressDialogImpl.this.panel.setCanceled();
            }
        });
        if (jFrame != null) {
            jFrame.setDefaultCloseOperation(0);
            jFrame.getContentPane().setLayout(new BorderLayout());
            jFrame.getContentPane().add((Component)this.panel, "Center");
            jFrame.setResizable(false);
        } else {
            jDialog.setDefaultCloseOperation(0);
            jDialog.getContentPane().setLayout(new BorderLayout());
            jDialog.getContentPane().add((Component)this.panel, "Center");
            jDialog.setResizable(false);
        }
        this.progressDialog.pack();
        this.progressDialog.setLocationRelativeTo(window);
        Runnable runnable = () -> this.progressDialog.setVisible(true);
        KeyboardBuffer.setBufferOff();
        if (bl) {
            new Thread(runnable).start();
        } else {
            runnable.run();
        }
        this.time = System.currentTimeMillis();
    }

    protected boolean isDestroyed() {
        return this.progressDialog == null;
    }

    @Override
    public void destroy() throws IOException {
        if (!this.isDestroyed()) {
            this.progressDialog.dispose();
            this.progressDialog = null;
            this.panel = null;
            this.time = 0L;
            KeyboardBuffer.setBufferOn();
        }
    }

    @Override
    public void setProgress(int n2, int n3) throws IOException {
        if (!this.isDestroyed()) {
            n3 = Math.max(1, n3);
            n2 = Math.min(n2, n3);
            int n4 = Math.round((float)n2 / (float)n3 * 100.0f);
            this.panel.progress.setValue(n4);
            if (this.autoTime && !this.noTime && n4 > 0) {
                long l2;
                long l3 = System.currentTimeMillis() - this.time;
                long l4 = Math.round((double)l3 * (double)(100 - n4) / (double)n4);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("About ");
                long l5 = l4 / 3600000L;
                if (l5 > 0L) {
                    stringBuilder.append(l5).append(" hour");
                    if (l5 > 1L) {
                        stringBuilder.append("s");
                    }
                    stringBuilder.append(" ");
                    l4 %= 3600000L;
                }
                if ((l2 = l4 / 60000L) > 0L) {
                    stringBuilder.append(l2).append(" minute");
                    if (l2 > 1L) {
                        stringBuilder.append("s");
                    }
                    stringBuilder.append(" ");
                    l4 %= 60000L;
                }
                long l6 = l4 / 1000L;
                stringBuilder.append(l6).append(" second");
                if (l6 != 1L) {
                    stringBuilder.append("s");
                }
                stringBuilder.append(" remaining");
                this.panel.line3.setText(stringBuilder.toString());
            }
        }
    }

    @Override
    public boolean queryCancel() throws IOException {
        if (!this.isDestroyed()) {
            return this.panel.canceled;
        }
        return false;
    }

    @Override
    public void setLine(String string, int n2, boolean bl) throws IOException {
        if (!this.isDestroyed() && string != null) {
            switch (n2) {
                case 1: {
                    this.panel.line1.setText(string);
                    break;
                }
                case 2: {
                    this.panel.line2.setText(string);
                    break;
                }
                case 3: {
                    if (this.autoTime || this.panel.canceled && this.cancelMessage.length() != 0) break;
                    this.panel.line3.setText(string);
                }
            }
        }
    }

    @Override
    public void resetTimer() throws IOException {
        if (!this.isDestroyed()) {
            this.time = System.currentTimeMillis();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        int n2;
        Class<?> clazz = Class.forName("com.iscobol.updater.NotificationWindow");
        RemoteProgressDialogImpl remoteProgressDialogImpl = new RemoteProgressDialogImpl("Test", "Canceled.", 2, new LocalImage(Toolkit.getDefaultToolkit().createImage(clazz.getResource("deficon64x64.png")), 0, 1), null, null);
        remoteProgressDialogImpl.setLine("Download...", 1, false);
        remoteProgressDialogImpl.setLine("File 'test.cbl'", 2, false);
        for (n2 = 100; n2 <= 300; n2 += 100) {
            Thread.sleep(1000L);
            if (remoteProgressDialogImpl.queryCancel()) break;
            remoteProgressDialogImpl.setProgress(n2, 1000);
            remoteProgressDialogImpl.setLine("Completed " + Math.round((float)n2 / 1000.0f * 100.0f) + "%", 3, false);
        }
        while (n2 <= 1000) {
            Thread.sleep(4000L);
            if (remoteProgressDialogImpl.queryCancel()) break;
            remoteProgressDialogImpl.setProgress(n2, 1000);
            remoteProgressDialogImpl.setLine("Completed " + Math.round((float)n2 / 1000.0f * 100.0f) + "%", 3, false);
            n2 += 100;
        }
        Thread.sleep(1000L);
        remoteProgressDialogImpl.setLine("Finish.", 3, false);
        Thread.sleep(2000L);
        remoteProgressDialogImpl.destroy();
    }

    private static class ProgressDialogPanel
    extends JPanel {
        JLabel line1;
        JLabel line2;
        JLabel line3;
        JLabel customIcon;
        JProgressBar progress;
        JButton cancel;
        boolean canceled;
        String cancelMessage;

        public ProgressDialogPanel(Image image, boolean bl, String string) {
            this.cancelMessage = string;
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(new BorderLayout(5, 10));
            this.line1 = new JLabel();
            this.line1.setFont(new Font("Dialog", 1, 20));
            this.line1.setPreferredSize(new Dimension(0, 40));
            jPanel.add((Component)this.line1, "Center");
            this.customIcon = new JLabel();
            if (image != null) {
                this.customIcon.setIcon(new ImageIcon(image));
            }
            jPanel.add((Component)this.customIcon, "East");
            jPanel.setPreferredSize(new Dimension(550, 100));
            jPanel.setBackground(Color.white);
            jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.darkGray), BorderFactory.createEmptyBorder(8, 10, 8, 10)));
            this.add((Component)jPanel, "North");
            JPanel jPanel2 = new JPanel(new BorderLayout(5, 10));
            JPanel jPanel3 = new JPanel(new GridLayout(2, 0, 5, 10));
            jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
            this.line2 = new JLabel();
            this.line2.setFont(new Font("Dialog", 0, 12));
            this.line2.setText("");
            this.line2.setPreferredSize(new Dimension(0, 20));
            jPanel3.add(this.line2);
            this.line3 = new JLabel();
            this.line3.setFont(new Font("Dialog", 0, 12));
            this.line3.setText("");
            this.line3.setPreferredSize(new Dimension(0, 20));
            jPanel3.add(this.line3);
            jPanel2.add((Component)jPanel3, "North");
            this.progress = new JProgressBar(0);
            this.progress.setPreferredSize(new Dimension(0, 25));
            if (bl) {
                this.progress.setIndeterminate(true);
            } else {
                this.progress.setMinimum(0);
                this.progress.setMaximum(100);
                this.progress.setValue(0);
            }
            jPanel2.add((Component)this.progress, "Center");
            jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            this.add((Component)jPanel2, "Center");
            JPanel jPanel4 = new JPanel(new BorderLayout());
            this.cancel = new JButton(Factory.getSysMsg("msg_cancel"));
            jPanel4.add((Component)this.cancel, "East");
            jPanel4.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
            this.add((Component)jPanel4, "South");
            this.cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.setCanceled();
                }
            });
        }

        void setCanceled() {
            this.canceled = true;
            this.cancel.setEnabled(false);
            this.progress.setIndeterminate(true);
            if (this.cancelMessage != null && this.cancelMessage.length() > 0) {
                this.line3.setText(this.cancelMessage);
            }
        }
    }
}

