/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.CobolFocusEvent;
import com.iscobol.gui.ColorCmp;
import com.iscobol.gui.Constants;
import com.iscobol.gui.ParamElementSize;
import com.iscobol.gui.ParamsValues;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.client.swing.CobolEventCouple;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.PicobolButton;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import com.iscobol.gui.client.swing.RemoteTab;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class RemotePushButton
extends RemoteBaseGUIControl
implements Constants {
    public static final int BORDER_SZ_PX = 8;
    public static final int BORDER_LN_PX = 8;
    public static final int DEFAULT_TEXTBUTTON_WIDTH = 8;
    private static final int DEFAULT_ALIGNMENT = 0;
    private boolean noAutoDef;
    private boolean defaultButton;
    private boolean escapeButton;
    private boolean selfAct;
    private boolean flat;
    private boolean transparent;
    private String title;
    private float rows;
    private int bitmapNumber;
    private int bitmapDisabled;
    private int bitmapPressed;
    private int bitmapRollover;
    private int bitmapWidth;
    private boolean multiline;
    private int titlePosition;
    private ActionListener al;
    private Image image;
    private int imageId = -1;
    private Dimension scalebitmaptosize;
    private RemoteBaseGUIControl thisonribbonheader;
    private int alignmentH = 0;
    private int alignmentV = 0;
    private boolean bitmapScaleBestQuality;
    private PropertyChangeListener pcListener;
    private Color borderColor;
    private ColorCmp borderColorCmp;
    private int borderColorIdx;
    private Color rolloverBorderColor;
    private ColorCmp rolloverBorderColorCmp;
    private int rolloverBorderColorIdx;
    private Integer disabledColor;
    private Integer disabledBackgroundColor;
    private Integer disabledForegroundColor;
    private boolean disabledBackgroundRgb;
    private boolean disabledForegroundRgb;
    private Integer rolloverColor;
    private Integer rolloverBackgroundColor;
    private Integer rolloverForegroundColor;
    private boolean rolloverBackgroundRgb;
    private boolean rolloverForegroundRgb;
    private int transparentColor = -1;
    private int bitmapScale;
    private final boolean m25647;

    public RemotePushButton(GuiFactoryImpl guiFactoryImpl) {
        super(guiFactoryImpl);
        this.m25647 = guiFactoryImpl.getCsProperty().get("iscobol.m25647", false);
        this.bitmapScaleBestQuality = guiFactoryImpl.getCsProperty().get("iscobol.bitmap_scale.best_quality", false);
        this.pcListener = propertyChangeEvent -> {
            String string;
            if (guiFactoryImpl != null && (string = propertyChangeEvent.getPropertyName()).equals("iscobol.bitmap_scale.best_quality")) {
                this.bitmapScaleBestQuality = guiFactoryImpl.getCsProperty().get("iscobol.bitmap_scale.best_quality", false);
            }
        };
        guiFactoryImpl.getCsProperty().addPropertyChangeListener(this.pcListener);
    }

    @Override
    protected void intFocusGained(boolean bl) {
    }

    @Override
    public void setRowsCols(float f2, float f3) {
        this.rows = f2;
    }

    @Override
    public void setTitle(String string) {
        this.title = string;
        if (this.guiComponent != null && string != null) {
            PicobolButton picobolButton = (PicobolButton)this.guiComponent;
            picobolButton.setTitle(string);
            if (picobolButton.getMnemonicChar() > '\u0000' && this.parentWindow != null) {
                this.parentWindow.removeMnemonic(this);
                this.parentWindow.addMnemonic(picobolButton.getMnemonicChar(), this);
            }
        }
    }

    @Override
    public void setBorder(boolean bl) {
    }

    @Override
    public int getGUIControlHeight(float f2) {
        int n2 = 0;
        if (this.bitmapStyle) {
            n2 = (int)f2;
        } else if (this.font != null) {
            n2 = (int)((float)this.font.getHeight() * f2) + 8;
        }
        return n2;
    }

    @Override
    public int getGUIControlWidth(float f2) {
        int n2 = 0;
        if (this.bitmapStyle) {
            n2 = (int)f2;
        } else if (this.font != null) {
            n2 = (int)((float)this.font.getWidth() * f2) + 8;
        }
        return n2;
    }

    @Override
    public float getDefaultWidth() {
        if (this.bitmapStyle) {
            return 16.0f;
        }
        return 8.0f;
    }

    @Override
    public float getDefaultHeight() {
        if (this.bitmapStyle) {
            return 15.0f;
        }
        return 1.0f;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getValue() {
        return this.title;
    }

    private void setDefaultButton(boolean bl) {
        this.defaultButton = bl;
        if (bl && this.parentWindow != null) {
            this.parentWindow.setDefaultButton(this);
        }
    }

    private void setEscapeButton(boolean bl) {
        this.escapeButton = bl;
        if (bl && this.parentWindow != null) {
            this.parentWindow.setEscapeButton(this);
        }
    }

    @Override
    public void setStyle(int n2, boolean bl) {
        PicobolButton picobolButton = (PicobolButton)this.guiComponent;
        if ((n2 & 4) == 4) {
            if (bl && (this.title == null || this.title.length() == 0)) {
                this.setTitle("OK");
            }
            this.setStyle(1, bl);
        }
        if ((n2 & 8) == 8) {
            if (bl && (this.title == null || this.title.length() == 0)) {
                this.setTitle("CANCEL");
            }
            this.setStyle(2, bl);
        }
        if ((n2 & 1) == 1) {
            this.setDefaultButton(bl);
        }
        if ((n2 & 2) == 2) {
            this.setEscapeButton(bl);
        }
        if ((n2 & 0x10) == 16) {
            this.noAutoDef = bl;
        }
        if ((n2 & 0x400) == 1024) {
            this.multiline = bl;
            if (picobolButton != null) {
                picobolButton.setMultiline(bl);
            }
        }
        if ((n2 & 0x400000) == 0x400000) {
            this.selfAct = bl;
            if (this.getComponent() != null) {
                this.getComponent().setSelfAct(bl);
            }
        }
        if ((n2 & 0x8000) == 32768) {
            this.bitmapStyle = bl;
            if (picobolButton != null) {
                picobolButton.setHasBitmap(bl);
            }
        }
        if ((n2 & 0x800000) == 0x800000) {
            this.transparent = bl;
            if (picobolButton != null) {
                picobolButton.setTransparent(bl);
            }
        }
        if ((n2 & 0x800) == 2048) {
            this.flat = bl;
            if (picobolButton != null) {
                picobolButton.setFlat(bl);
            }
        }
        if ((n2 & 0x10000) == 65536) {
            RemoteBaseGUIControl remoteBaseGUIControl = null;
            this.onheader = bl;
            if (picobolButton != null && (this.uponCtrlsrvid >= 0 || this.tabGroup >= 0) && this.parentWindow != null && ((remoteBaseGUIControl = this.parentWindow.getBGC(this.uponCtrlsrvid)) != null || (remoteBaseGUIControl = this.parentWindow.getBGC(this.tabGroup)) != null) && remoteBaseGUIControl instanceof RemoteTab && ((RemoteTab)remoteBaseGUIControl).isRibbon()) {
                if (this.onheader) {
                    this.thisonribbonheader = ((RemoteTab)remoteBaseGUIControl).addOnHeader(this);
                } else if (this.thisonribbonheader != null) {
                    ((RemoteTab)remoteBaseGUIControl).removeOnHeader(this.thisonribbonheader);
                    this.thisonribbonheader = null;
                }
            }
        }
        if ((n2 & 0x20000) == 131072 && !this.multiline) {
            this.alignmentH = bl ? 0 : 0;
            if (picobolButton != null && !this.multiline) {
                picobolButton.setHorizontalAlignment(this.alignmentH);
            }
        }
        if ((n2 & 0x40000) == 262144 && !this.multiline) {
            this.alignmentH = bl ? 4 : 0;
            if (picobolButton != null && !this.multiline) {
                picobolButton.setHorizontalAlignment(this.alignmentH);
            }
        }
        if ((n2 & 0x80000) == 524288 && !this.multiline) {
            this.alignmentH = bl ? 2 : 0;
            if (picobolButton != null) {
                picobolButton.setHorizontalAlignment(this.alignmentH);
            }
        }
        if ((n2 & 0x100000) == 0x100000 && !this.multiline) {
            this.alignmentV = bl ? 1 : 0;
            if (picobolButton != null) {
                picobolButton.setVerticalAlignment(this.alignmentV);
            }
        }
        if ((n2 & 0x200000) == 0x200000 && !this.multiline) {
            this.alignmentV = bl ? 3 : 0;
            if (picobolButton != null) {
                picobolButton.setVerticalAlignment(this.alignmentV);
            }
        }
    }

    @Override
    public String setProp(Integer n2, String string, int n3) {
        String string2 = "0";
        int n4 = -1;
        boolean bl = false;
        boolean bl2 = false;
        try {
            n4 = (int)Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            bl = true;
        }
        PicobolButton picobolButton = (PicobolButton)this.guiComponent;
        switch (n2) {
            case 295: {
                if (bl) break;
                this.bitmapScale = n4;
                if (picobolButton == null) break;
                picobolButton.setBitmapScale(this.bitmapScale);
                break;
            }
            case 242: {
                if (bl) break;
                this.transparentColor = n4;
                if (picobolButton == null) break;
                picobolButton.setTransparentColor(this.transparentColor);
                break;
            }
            case 409: {
                if (bl) break;
                this.disabledColor = n4;
                if (picobolButton != null) {
                    Color[] colorArray = this.getColors(n4);
                    picobolButton.setDisabledBackground(colorArray[0]);
                    picobolButton.setDisabledForeground(colorArray[1]);
                }
                string2 = "1";
                break;
            }
            case 411: {
                bl2 = true;
            }
            case 410: {
                if (bl) break;
                this.disabledBackgroundColor = n4;
                this.disabledBackgroundRgb = bl2;
                if (picobolButton != null) {
                    Color color = this.getBackgroundColor(n4, bl2);
                    picobolButton.setDisabledBackground(color);
                }
                string2 = "1";
                break;
            }
            case 413: {
                bl2 = true;
            }
            case 412: {
                if (bl) break;
                this.disabledForegroundColor = n4;
                this.disabledForegroundRgb = bl2;
                if (picobolButton != null) {
                    Color color = this.getForegroundColor(n4, bl2);
                    picobolButton.setDisabledForeground(color);
                }
                string2 = "1";
                break;
            }
            case 414: {
                if (bl) break;
                this.rolloverColor = n4;
                if (picobolButton != null) {
                    Color[] colorArray = this.getColors(n4);
                    picobolButton.setRolloverBackground(colorArray[0]);
                    picobolButton.setRolloverForeground(colorArray[1]);
                }
                string2 = "1";
                break;
            }
            case 416: {
                bl2 = true;
            }
            case 415: {
                if (bl) break;
                this.rolloverBackgroundColor = n4;
                this.rolloverBackgroundRgb = bl2;
                if (picobolButton != null) {
                    Color color = this.getBackgroundColor(n4, bl2);
                    picobolButton.setRolloverBackground(color);
                }
                string2 = "1";
                break;
            }
            case 418: {
                bl2 = true;
            }
            case 417: {
                if (bl) break;
                this.rolloverForegroundColor = n4;
                this.rolloverForegroundRgb = bl2;
                if (picobolButton != null) {
                    Color color = this.getForegroundColor(n4, bl2);
                    picobolButton.setRolloverForeground(color);
                }
                string2 = "1";
                break;
            }
            case 7: 
            case 12: {
                if (bl) break;
                this.bitmapNumber = n4;
                if (picobolButton != null) {
                    picobolButton.setBitmapNumber(this.bitmapNumber);
                }
                string2 = "1";
                break;
            }
            case 8: {
                if (bl) break;
                this.bitmapDisabled = n4;
                if (picobolButton != null) {
                    picobolButton.setBitmapDisabled(this.bitmapDisabled);
                }
                string2 = "1";
                break;
            }
            case 13: {
                if (bl) break;
                this.bitmapPressed = n4;
                if (picobolButton != null) {
                    picobolButton.setBitmapPressed(this.bitmapPressed);
                }
                string2 = "1";
                break;
            }
            case 14: {
                if (bl) break;
                this.bitmapRollover = n4;
                if (picobolButton != null) {
                    picobolButton.setBitmapRollover(this.bitmapRollover);
                }
                string2 = "1";
                break;
            }
            case 240: {
                if (bl) break;
                this.titlePosition = n4;
                if (picobolButton != null) {
                    picobolButton.setTitlePosition(this.titlePosition);
                }
                string2 = "1";
                break;
            }
            case 20: {
                if (bl) break;
                this.bitmapWidth = n4;
                if (picobolButton != null) {
                    picobolButton.setBitmapWidth(this.bitmapWidth);
                }
                string2 = "1";
                break;
            }
            case 325: 
            case 326: {
                bl2 = n2.equals(ParamsValues.getParamValue("BORDER-COLOR-RGB"));
                if (n4 < 0 || bl2) {
                    this.borderColorCmp = new ColorCmp(true);
                    this.borderColorIdx = -1;
                    this.borderColorCmp.setForeRGB(n4);
                    this.borderColor = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(this.borderColorCmp.getForeground(), false));
                } else {
                    this.borderColorCmp = new ColorCmp(n4);
                    this.borderColorIdx = n4;
                    this.borderColor = this.gf.getRemotePalette().getDefaultColor(this.borderColorCmp.getForeground());
                }
                this.setBoxedStyle();
                break;
            }
            case 374: {
                this.handleBorderWidths(string);
                this.setBoxedStyle();
                break;
            }
            case 427: 
            case 428: {
                bl2 = n2.equals(ParamsValues.getParamValue("ROLLOVER-BORDER-COLOR-RGB"));
                if (n4 < 0 || bl2) {
                    this.rolloverBorderColorCmp = new ColorCmp(true);
                    this.rolloverBorderColorIdx = -1;
                    this.rolloverBorderColorCmp.setForeRGB(n4);
                    this.rolloverBorderColor = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(this.rolloverBorderColorCmp.getForeground(), false));
                } else {
                    this.rolloverBorderColorCmp = new ColorCmp(n4);
                    this.rolloverBorderColorIdx = n4;
                    this.rolloverBorderColor = this.gf.getRemotePalette().getDefaultColor(this.rolloverBorderColorCmp.getForeground());
                }
                this.setRolloverBorderColor();
                break;
            }
            default: {
                return super.setProp(n2, string, n3);
            }
        }
        return string2;
    }

    @Override
    public void displayProp() {
    }

    @Override
    public boolean isInputField() {
        return true;
    }

    @Override
    public boolean isSelfAct() {
        if (this.guiComponent != null) {
            return this.guiComponent.getSelfAct();
        }
        return this.selfAct;
    }

    @Override
    public String getProp(int n2) {
        PicobolButton picobolButton = (PicobolButton)this.guiComponent;
        switch (n2) {
            case 242: {
                return "" + this.transparentColor;
            }
            case 325: {
                if (this.borderColorCmp == null) break;
                return Integer.toString(this.borderColorIdx >= 0 ? this.borderColorIdx : this.borderColorCmp.getForeground());
            }
            case 427: {
                if (this.rolloverBorderColorCmp == null) break;
                return Integer.toString(this.rolloverBorderColorIdx >= 0 ? this.rolloverBorderColorIdx : this.rolloverBorderColorCmp.getForeground());
            }
            case 410: {
                if (!this.disabledBackgroundRgb && this.disabledBackgroundColor != null) {
                    return this.disabledBackgroundColor.toString();
                }
                if (picobolButton == null || picobolButton.getDisabledBackground() == null) break;
                ColorCmp colorCmp = new ColorCmp(true);
                colorCmp.setBackRGB(picobolButton.getDisabledBackground().getRGB());
                Color color = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(colorCmp.getBackground(), false));
                return Integer.toString(color != null ? color.getRGB() : 0);
            }
            case 412: {
                if (!this.disabledForegroundRgb && this.disabledForegroundColor != null) {
                    return this.disabledForegroundColor.toString();
                }
                if (picobolButton == null || picobolButton.getDisabledForeground() == null) break;
                ColorCmp colorCmp = new ColorCmp(true);
                colorCmp.setForeRGB(picobolButton.getDisabledForeground().getRGB());
                Color color = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(colorCmp.getForeground(), false));
                return Integer.toString(color != null ? color.getRGB() : 0);
            }
            case 409: {
                if (this.disabledColor != null) {
                    return this.disabledColor.toString();
                }
                return "0";
            }
            case 415: {
                if (!this.rolloverBackgroundRgb && this.rolloverBackgroundColor != null) {
                    return this.rolloverBackgroundColor.toString();
                }
                if (picobolButton == null || picobolButton.getRolloverBackground() == null) break;
                ColorCmp colorCmp = new ColorCmp(true);
                colorCmp.setBackRGB(picobolButton.getRolloverBackground().getRGB());
                Color color = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(colorCmp.getBackground(), false));
                return Integer.toString(color != null ? color.getRGB() : 0);
            }
            case 417: {
                if (!this.rolloverForegroundRgb && this.rolloverForegroundColor != null) {
                    return this.rolloverForegroundColor.toString();
                }
                if (picobolButton == null || picobolButton.getRolloverForeground() == null) break;
                ColorCmp colorCmp = new ColorCmp(true);
                colorCmp.setForeRGB(picobolButton.getRolloverForeground().getRGB());
                Color color = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(colorCmp.getForeground(), false));
                return Integer.toString(color != null ? color.getRGB() : 0);
            }
            case 414: {
                if (this.rolloverColor != null) {
                    return this.rolloverColor.toString();
                }
                return "0";
            }
        }
        return super.getProp(n2);
    }

    @Override
    public void setElementAt(int[] nArray) {
    }

    @Override
    public String setValue(String string) {
        this.setTitle(string);
        return null;
    }

    @Override
    public void focusGained(CobolFocusEvent cobolFocusEvent) {
        RemoteDisplayWindow remoteDisplayWindow = (RemoteDisplayWindow)this.parentWindow;
        if (!(remoteDisplayWindow == null || cobolFocusEvent.isGoto() || this.noAutoDef || this.defaultButton)) {
            remoteDisplayWindow.setTemporaryDefaultButton(this);
        }
        super.focusGained(cobolFocusEvent);
    }

    @Override
    public void focusLost(CobolFocusEvent cobolFocusEvent) {
        RemoteDisplayWindow remoteDisplayWindow = (RemoteDisplayWindow)this.parentWindow;
        if (remoteDisplayWindow != null && remoteDisplayWindow.getTemporaryDefaultButton() == this) {
            remoteDisplayWindow.setTemporaryDefaultButton(null);
        }
        super.focusLost(cobolFocusEvent);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.isMenuKeyPressed(keyEvent)) {
            this.skipNextEvent = true;
            return;
        }
        switch (keyEvent.getKeyCode()) {
            case 10: {
                if (!this.gf.getRemoteVirtualKeyboard().isPushButtonActivatedByEnter() || !this.defaultButton && (this.parentWindow == null || this.parentWindow.getTemporaryDefaultButton() != this)) break;
                this.skipNextEvent = false;
                return;
            }
        }
        super.keyPressed(keyEvent);
    }

    private void responseOnAction(int n2) {
        if ((RemoteDisplayWindow)this.parentWindow != null) {
            ((RemoteDisplayWindow)this.parentWindow).stopTimer();
        }
        RemoteRecordAccept remoteRecordAccept = new RemoteRecordAccept(16, 17, n2);
        CobolEventCouple cobolEventCouple = new CobolEventCouple(this, remoteRecordAccept);
        if (this.hasClickOverrideFocusChange()) {
            cobolEventCouple.getRemoteRecordAccept().setResponse(true);
            cobolEventCouple.getRemoteRecordAccept().setWait(true);
        }
        this.pushEvent(cobolEventCouple, 4);
    }

    @Override
    public void initialize() {
        Object object;
        if (this.guiComponent != null) {
            return;
        }
        this.guiComponent = new PicobolButton();
        PicobolButton picobolButton = (PicobolButton)this.guiComponent;
        this.al = actionEvent -> {
            if (!this.skipNextEvent) {
                this.responseOnAction(actionEvent.getID());
            }
            this.skipNextEvent = false;
        };
        picobolButton.addActionListener(this.al);
        super.intInitialize();
        picobolButton.setScaleBitmapToSize(this.scalebitmaptosize, this.bitmapScaleBestQuality);
        picobolButton.setMultiline(this.multiline || this.m25647 && this.rows >= 2.0f);
        picobolButton.setHasBitmap(this.bitmapStyle);
        if (this.image == null && this.imageId >= 0) {
            this.setImage(1, 1, this.imageId, 1);
        }
        if (this.titlePosition > 0) {
            picobolButton.setTitlePosition(this.titlePosition);
        }
        if (this.title != null) {
            this.setTitle(this.title);
        }
        picobolButton.setBitmapWidth(this.bitmapWidth);
        picobolButton.setBitmapNumber(this.bitmapNumber);
        picobolButton.setBitmapDisabled(this.bitmapDisabled);
        picobolButton.setBitmapRollover(this.bitmapRollover);
        picobolButton.setBitmapPressed(this.bitmapPressed);
        picobolButton.setBitmapScale(this.bitmapScale);
        if (this.disabledColor != null) {
            object = this.getColors(this.disabledColor);
            picobolButton.setDisabledBackground(object[0]);
            picobolButton.setDisabledForeground(object[1]);
        } else {
            if (this.disabledBackgroundColor != null) {
                object = this.getBackgroundColor(this.disabledBackgroundColor, this.disabledBackgroundRgb);
                picobolButton.setDisabledBackground((Color)object);
            }
            if (this.disabledForegroundColor != null) {
                object = this.getForegroundColor(this.disabledForegroundColor, this.disabledForegroundRgb);
                picobolButton.setDisabledForeground((Color)object);
            }
        }
        if (this.rolloverColor != null) {
            object = this.getColors(this.rolloverColor);
            picobolButton.setRolloverBackground(object[0]);
            picobolButton.setRolloverForeground(object[1]);
        } else {
            if (this.rolloverBackgroundColor != null) {
                object = this.getBackgroundColor(this.rolloverBackgroundColor, this.rolloverBackgroundRgb);
                picobolButton.setRolloverBackground((Color)object);
            }
            if (this.rolloverForegroundColor != null) {
                object = this.getForegroundColor(this.rolloverForegroundColor, this.rolloverForegroundRgb);
                picobolButton.setRolloverForeground((Color)object);
            }
        }
        this.setRolloverBorderColor();
        this.guiComponent.addKeyListener(this);
        this.guiComponent.setSelfAct(this.selfAct);
        if (this.defaultButton) {
            this.parentWindow.setDefaultButton(this);
        }
        picobolButton.setTransparent(this.transparent);
        picobolButton.setFlat(this.flat);
        this.usedtorender = true;
        if (this.alignmentH != 0) {
            picobolButton.setHorizontalAlignment(this.alignmentH);
        }
        if (this.alignmentV != 0) {
            picobolButton.setVerticalAlignment(this.alignmentV);
        }
        this.setBoxedStyle();
    }

    @Override
    public void setImage(int n2, int n3, int n4, int n5) {
        Rectangle rectangle = this.getBounds();
        n2 = rectangle.width;
        n3 = rectangle.height;
        this.imageId = n4;
        if (n2 == 0 || !this.bitmapStyle) {
            return;
        }
        this.image = this.getLocalImage(this.imageId);
        if (this.bitmapWidth == 0) {
            this.bitmapWidth = n2;
        }
        PicobolButton picobolButton = (PicobolButton)this.guiComponent;
        if (this.guiComponent != null) {
            picobolButton.setImage(this.image, this.bitmapWidth, n3, this.transparentColor);
            if (this.image != null && this.title != null) {
                picobolButton.setHasBitmap(this.bitmapStyle);
                picobolButton.setTitle(this.title);
            }
        }
    }

    @Override
    protected void processMnemonic(char c2) {
        super.processMnemonic(c2);
        PicobolButton picobolButton = (PicobolButton)this.guiComponent;
        if (picobolButton != null) {
            new Thread(() -> picobolButton.doClick(100)).start();
        }
    }

    @Override
    public void destroy() {
        if (this.gf != null && this.gf.getCsProperty() != null) {
            this.gf.getCsProperty().removePropertyChangeListener(this.pcListener);
        }
        this.pcListener = null;
        PicobolButton picobolButton = (PicobolButton)this.guiComponent;
        if (picobolButton != null) {
            picobolButton.removeActionListener(this.al);
            this.al = null;
        }
        if (this.parentWindow != null) {
            if (this.defaultButton) {
                this.parentWindow.removeDefaultButton(this);
            }
            if (this.escapeButton) {
                this.parentWindow.removeEscapeButton(this);
            }
        }
        RemoteBaseGUIControl remoteBaseGUIControl = null;
        if (picobolButton != null && (this.uponCtrlsrvid >= 0 || this.tabGroup >= 0) && this.parentWindow != null && ((remoteBaseGUIControl = this.parentWindow.getBGC(this.uponCtrlsrvid)) != null || (remoteBaseGUIControl = this.parentWindow.getBGC(this.tabGroup)) != null) && remoteBaseGUIControl instanceof RemoteTab && ((RemoteTab)remoteBaseGUIControl).isRibbon()) {
            ((RemoteTab)remoteBaseGUIControl).removeOnHeader(this.thisonribbonheader);
        }
        this.thisonribbonheader = null;
        super.destroy();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.parentWindow != null) {
            if (this.defaultButton) {
                this.parentWindow.updateDefaultButton();
            }
            if (this.escapeButton) {
                this.parentWindow.updateEscapeButton();
            }
        }
    }

    @Override
    public void handleResponse(int n2, RemoteRecordAccept remoteRecordAccept) {
        if (remoteRecordAccept.getEventType() == 17042 && n2 == 4) {
            this.parentWindow.setDragFailed(true);
        } else if (remoteRecordAccept.getEventType() == 17043) {
            this.parentWindow.setDragFailed(false);
        }
    }

    @Override
    public void setCols(float f2) {
    }

    @Override
    public void setRows(float f2) {
    }

    @Override
    public void setSize(int n2, int n3, boolean bl) {
        int n4 = this.width;
        int n5 = this.height;
        this.width = n2;
        this.height = n3;
        if (this.guiComponent != null && bl) {
            this.updateLayoutManager();
            this.guiComponent.setSize(this.width, this.height);
        } else if (!(this.isVisible() || this.guiComponent == null || bl || n4 == n2 && n5 == n3)) {
            this.addLayoutManager();
        }
    }

    @Override
    public Rectangle getRealBounds() {
        Rectangle rectangle = this.guiComponent != null ? this.guiComponent.getBounds() : new Rectangle(this.x, this.y, this.width, this.height);
        return rectangle;
    }

    @Override
    public Rectangle getBounds() {
        Rectangle rectangle = this.getRealBounds();
        if (this.bitmapStyle) {
            if (!this.sizesInPixel) {
                rectangle.width -= 8;
            }
            if (!this.linesInPixel) {
                rectangle.height -= 7;
            }
        }
        return rectangle;
    }

    @Override
    public Rectangle getBoundsWithoutDefaultWidth() {
        Rectangle rectangle = this.getBounds();
        if (!this.bitmapStyle && rectangle != null && rectangle.width > 0) {
            rectangle.width -= 8;
        }
        return rectangle;
    }

    @Override
    protected float paramgetDefaultWidth(ParamElementSize paramElementSize, int n2) {
        if (paramElementSize.sizes > 0.0f) {
            return paramElementSize.sizes;
        }
        if (this.bitmapStyle) {
            return 16.0f;
        }
        return 8.0f;
    }

    @Override
    protected float paramgetDefaultHeight(ParamElementSize paramElementSize, int n2) {
        if (this.bitmapStyle) {
            return 15.0f;
        }
        return super.paramgetDefaultHeight(paramElementSize, n2);
    }

    @Override
    public String getType() {
        return "pushbutton";
    }

    @Override
    public boolean canBecomeDefaultButton() {
        RemoteDisplayWindow remoteDisplayWindow = (RemoteDisplayWindow)this.parentWindow;
        return remoteDisplayWindow != null && (!this.noAutoDef && !this.defaultButton || this.defaultButton);
    }

    @Override
    public void startCellEditing() {
        RemoteRecordAccept remoteRecordAccept = new RemoteRecordAccept(16, 17, 1001);
        CobolEventCouple cobolEventCouple = new CobolEventCouple(this, remoteRecordAccept);
        this.pushEvent(cobolEventCouple, 4);
    }

    @Override
    public RemoteBaseGUIControl renderClone() {
        return this.renderClone(true, null);
    }

    @Override
    public RemoteBaseGUIControl renderClone(boolean bl, Dimension dimension) {
        PicobolButton picobolButton = (PicobolButton)this.guiComponent;
        this.scalebitmaptosize = dimension;
        if (bl) {
            picobolButton.removeActionListener(this.al);
        }
        this.image = null;
        RemotePushButton remotePushButton = null;
        try {
            remotePushButton = (RemotePushButton)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        remotePushButton.setComponent(null);
        if (this.bitmapNumber == 0 && this.imageId >= 0) {
            remotePushButton.setProp(new Integer(12), "1", 0);
        }
        if (dimension != null) {
            remotePushButton.setProp(new Integer(240), "0", 0);
        }
        remotePushButton.initialize();
        if (this.popupMenu != null) {
            remotePushButton.popupMenu = null;
            remotePushButton.setPopupMenu(this.popupMenu);
        }
        return remotePushButton;
    }

    @Override
    protected void putOnHeader() {
        this.setStyle(65536, true);
    }

    public void fireactionevent() {
        PicobolButton picobolButton = (PicobolButton)this.guiComponent;
        ActionListener[] actionListenerArray = picobolButton.getActionListeners();
        for (int i2 = 0; i2 < actionListenerArray.length; ++i2) {
            if (this.skipNextEvent || picobolButton.getModel().isPressed() || picobolButton.getModel().isArmed()) continue;
            actionListenerArray[i2].actionPerformed(new ActionEvent(picobolButton, 1001, picobolButton.getActionCommand()));
        }
    }

    public String getTitle(String string) {
        String string2 = string;
        if (!(this.bitmapStyle && this.titlePosition <= 0 || this.title == null)) {
            string2 = this.title;
        }
        return string2;
    }

    @Override
    public void adjustBounds(Rectangle rectangle) {
        if (this.bitmapStyle) {
            if (!this.sizesInPixel) {
                rectangle.width -= 8;
            }
            if (!this.linesInPixel) {
                rectangle.height -= 7;
            }
        }
    }

    protected void setBoxedStyle() {
        PicobolButton picobolButton = (PicobolButton)this.guiComponent;
        if (picobolButton != null && this.borderWidths != null && this.borderWidths.size() > 0) {
            picobolButton.setCustomBorder(this.borderWidths, this.borderColor);
        }
    }

    private void setRolloverBorderColor() {
        PicobolButton picobolButton = (PicobolButton)this.guiComponent;
        if (picobolButton != null) {
            picobolButton.setRolloverBorderColor(this.rolloverBorderColor);
        }
    }

    @Override
    public JComponent getDragDropComponent() {
        return (PicobolButton)this.guiComponent;
    }

    static {
        UIManager.put("Button.defaultButtonFollowsFocus", Boolean.FALSE);
    }
}

