/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.ColorCmp;
import com.iscobol.gui.ParamElementSize;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.client.swing.CobolEventCouple;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.PicobolRadioButton;
import com.iscobol.gui.client.swing.RadioButtonGroup;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteBaseGUIWindow;
import com.iscobol.gui.client.swing.RemoteDisplayToolBar;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import com.iscobol.gui.client.swing.RemoteTab;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import javax.swing.JComponent;

public class RemoteRadioButton
extends RemoteBaseGUIControl {
    private static final float DEFAULT_WIDTH_INSETS = 17.0f;
    private static final float MINIMUM_HEIGHT = 15.0f;
    private String title;
    private boolean transparent;
    private boolean selfAct;
    private boolean leftText;
    private int groupValue;
    private String groupValueAlpha;
    private int groupID = 1;
    private boolean noGroupTab;
    private float rows;
    private int bitmapNumber;
    private int bitmapDisabled;
    private int bitmapDisabledSelected;
    private int bitmapPressed;
    private int bitmapSelected;
    private int bitmapRollover;
    private int bitmapRolloverSelected;
    private int bitmapWidth;
    private boolean flat;
    private boolean multiline;
    private boolean vtop;
    private String valueStr;
    private RadioButtonGroup rbGroup;
    private int titlePosition;
    private int leftTextAlign;
    private Integer disabledColor;
    private Integer disabledBackgroundColor;
    private Integer disabledForegroundColor;
    private boolean disabledBackgroundRgb;
    private boolean disabledForegroundRgb;
    private Integer rolloverColor;
    private Integer rolloverBackgroundColor;
    private Integer rolloverForegroundColor;
    private boolean rolloverBackgroundRgb;
    private boolean rolloverForegroundRgb;
    private final boolean iconsScaling;
    private int bitmapScale;
    private final boolean m25647;

    private RadioButtonGroup getRadioButtonGroup(int n2) {
        Hashtable hashtable = null;
        if (this.parentToolbar != null) {
            hashtable = this.parentToolbar.getRadioButtonGroupList();
        } else if (this.parentWindow != null) {
            hashtable = this.parentWindow.getRadioButtonGroupList();
        }
        Integer n3 = new Integer(n2);
        if (hashtable != null) {
            if (hashtable.containsKey(n3)) {
                return (RadioButtonGroup)hashtable.get(n3);
            }
            RadioButtonGroup radioButtonGroup = new RadioButtonGroup();
            hashtable.put(n3, radioButtonGroup);
            return radioButtonGroup;
        }
        return new RadioButtonGroup();
    }

    public RemoteRadioButton(GuiFactoryImpl guiFactoryImpl) {
        super(guiFactoryImpl);
        this.m25647 = guiFactoryImpl.getCsProperty().get("iscobol.m25647", false);
        this.iconsScaling = guiFactoryImpl.getCsProperty().get("iscobol.gui.icons_scaling", false);
    }

    @Override
    public void displayProp() {
    }

    @Override
    public float getDefaultWidth() {
        if (this.bitmapStyle) {
            return 16.0f;
        }
        if (this.title != null && this.title.length() > 0) {
            return (float)(this.font.computeScreenWidth(this.title) / this.font.computeScreenWidth("0")) + 1.3f;
        }
        return 0.0f;
    }

    @Override
    public float getDefaultHeight() {
        if (this.bitmapStyle) {
            return 15.0f;
        }
        return 1.0f;
    }

    @Override
    public int getGUIControlHeight(float f2) {
        int n2 = this.bitmapStyle ? (int)f2 : (int)((float)this.font.getHeight() * f2);
        if ((float)n2 < 15.0f) {
            n2 = 15;
        }
        return n2;
    }

    @Override
    public int getGUIControlWidth(float f2) {
        int n2 = 0;
        if (this.bitmapStyle) {
            n2 = (int)f2;
        } else if (f2 > 0.0f) {
            n2 = (int)((float)this.font.getWidth() * f2 + 17.0f);
        }
        return n2;
    }

    @Override
    public float getSizes() {
        float f2 = super.getSizes();
        if (f2 == 0.0f) {
            Dimension dimension = this.guiComponent.getPreferredSize();
            f2 = this.bitmapStyle ? (float)dimension.width : ((float)dimension.width - 17.0f) / (float)this.font.getWidth();
        }
        return f2;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String setValue(String string) {
        this.valueStr = string;
        if (this.valueStr == null || this.guiComponent == null) {
            return null;
        }
        int n2 = -1;
        String string2 = null;
        try {
            n2 = Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            string2 = string.trim();
        }
        if (string2 == null) {
            if (this.rbGroup == null || this.groupValue == 0) {
                this.setState(n2 > 0);
            } else if (n2 == this.groupValue) {
                this.setState(n2 > 0);
            } else {
                ((PicobolRadioButton)this.guiComponent).setSelected(false);
            }
        } else if (string2 != null && string2.equals(this.groupValueAlpha)) {
            this.setState(true);
        } else {
            ((PicobolRadioButton)this.guiComponent).setSelected(false);
        }
        return null;
    }

    @Override
    public String getValue() {
        RemoteRadioButton remoteRadioButton;
        RemoteRadioButton remoteRadioButton2;
        String string = this.groupValueAlpha == null ? (this.rbGroup == null || this.groupValue == 0 ? this.getItemValue() : ((remoteRadioButton2 = this.rbGroup.getSelectedRadioButton()) == null ? "0" : remoteRadioButton2.getItemValue())) : ((remoteRadioButton = this.rbGroup.getSelectedRadioButton()) == null ? " " : remoteRadioButton.getItemValue());
        this.valueStr = string;
        return string;
    }

    private String getItemValue() {
        String string = "0";
        if (this.getState()) {
            string = this.groupValueAlpha == null ? (this.groupValue == 0 ? "1" : Integer.toString(this.groupValue)) : this.groupValueAlpha;
        }
        return string;
    }

    @Override
    public void initialize() {
        Object object;
        if (this.guiComponent != null) {
            return;
        }
        this.guiComponent = new PicobolRadioButton();
        PicobolRadioButton picobolRadioButton = (PicobolRadioButton)this.guiComponent;
        picobolRadioButton.addOutAcceptListener(this);
        super.intInitialize();
        picobolRadioButton.setMultiline(this.multiline || this.m25647 && this.rows >= 2.0f);
        picobolRadioButton.setHasBitmap(this.bitmapStyle);
        if (!this.bitmapStyle && this.leftText) {
            picobolRadioButton.setLeftText(this.leftText);
        }
        if (this.titlePosition > 0) {
            picobolRadioButton.setTitlePosition(this.titlePosition);
        }
        picobolRadioButton.setLeftTextAlignment(this.leftTextAlign);
        picobolRadioButton.setVTop(this.vtop);
        if (this.title != null) {
            this.setTitle(this.title);
        }
        picobolRadioButton.setBitmapWidth(this.bitmapWidth);
        picobolRadioButton.setBitmapNumber(this.bitmapNumber);
        picobolRadioButton.setBitmapDisabled(this.bitmapDisabled);
        picobolRadioButton.setBitmapDisabledSelected(this.bitmapDisabledSelected);
        picobolRadioButton.setBitmapRollover(this.bitmapRollover);
        picobolRadioButton.setBitmapPressed(this.bitmapPressed);
        picobolRadioButton.setBitmapSelected(this.bitmapSelected);
        picobolRadioButton.setBitmapRolloverSelected(this.bitmapRolloverSelected);
        this.guiComponent.setSelfAct(this.selfAct);
        this.setValue(this.valueStr);
        picobolRadioButton.setFlat(this.flat);
        picobolRadioButton.setOpaque(!this.transparent);
        if (this.disabledColor != null) {
            object = this.getColors(this.disabledColor);
            picobolRadioButton.setDisabledBackground(object[0]);
            picobolRadioButton.setDisabledForeground(object[1]);
        } else {
            if (this.disabledBackgroundColor != null) {
                object = this.getBackgroundColor(this.disabledBackgroundColor, this.disabledBackgroundRgb);
                picobolRadioButton.setDisabledBackground((Color)object);
            }
            if (this.disabledForegroundColor != null) {
                object = this.getForegroundColor(this.disabledForegroundColor, this.disabledForegroundRgb);
                picobolRadioButton.setDisabledForeground((Color)object);
            }
        }
        if (this.rolloverColor != null) {
            object = this.getColors(this.rolloverColor);
            picobolRadioButton.setRolloverBackground(object[0]);
            picobolRadioButton.setRolloverForeground(object[1]);
        } else {
            if (this.rolloverBackgroundColor != null) {
                object = this.getBackgroundColor(this.rolloverBackgroundColor, this.rolloverBackgroundRgb);
                picobolRadioButton.setRolloverBackground((Color)object);
            }
            if (this.rolloverForegroundColor != null) {
                object = this.getForegroundColor(this.rolloverForegroundColor, this.rolloverForegroundRgb);
                picobolRadioButton.setRolloverForeground((Color)object);
            }
        }
        picobolRadioButton.setBitmapScale(this.bitmapScale);
        picobolRadioButton.setScaleDefaultIcon(this.iconsScaling);
        picobolRadioButton.addActionListener(actionEvent -> {
            if (this.skipNextEvent) {
                this.setState(!picobolRadioButton.isSelected());
            } else {
                this.responseOnAction(actionEvent);
            }
            this.skipNextEvent = false;
        });
        this.guiComponent.addKeyListener(this);
    }

    @Override
    public void setParentToolbar(RemoteDisplayToolBar remoteDisplayToolBar) {
        RemoteBaseGUIWindow remoteBaseGUIWindow = this.getContainer();
        super.setParentToolbar(remoteDisplayToolBar);
        RemoteBaseGUIWindow remoteBaseGUIWindow2 = this.getContainer();
        if (remoteBaseGUIWindow2 != null && remoteBaseGUIWindow2 != remoteBaseGUIWindow) {
            this.setGroupID(this.groupID);
            this.setValue(this.valueStr);
        }
    }

    @Override
    public void setParentWindow(int n2) {
        RemoteBaseGUIWindow remoteBaseGUIWindow = this.getContainer();
        super.setParentWindow(n2);
        RemoteBaseGUIWindow remoteBaseGUIWindow2 = this.getContainer();
        if (remoteBaseGUIWindow2 != null && remoteBaseGUIWindow2 != remoteBaseGUIWindow) {
            this.setGroupID(this.groupID);
            this.setValue(this.valueStr);
        }
    }

    private void setGroupID(int n2) {
        this.groupID = n2;
        if (this.groupID > 0) {
            if (this.rbGroup != null) {
                this.rbGroup.removeElement(this);
            }
            this.rbGroup = this.getRadioButtonGroup(this.groupID);
            this.rbGroup.addElement(this);
        } else {
            this.rbGroup = null;
        }
    }

    void responseOnAction(ActionEvent actionEvent) {
        if ((RemoteDisplayWindow)this.parentWindow != null) {
            ((RemoteDisplayWindow)this.parentWindow).stopTimer();
        }
        CobolEventCouple cobolEventCouple = new CobolEventCouple(this, new RemoteRecordAccept(16, 17, actionEvent.getID()));
        if (this.hasClickOverrideFocusChange() || (!this.getActiveAccept() || this.isProtectedField()) && !this.isSelfAct()) {
            if (this.hasClickOverrideFocusChange()) {
                cobolEventCouple.getRemoteRecordAccept().setResponse(true);
                cobolEventCouple.getRemoteRecordAccept().setWait(true);
            }
            this.setState(!((PicobolRadioButton)this.guiComponent).isSelected());
        } else {
            this.setState(true);
        }
        this.pushEvent(cobolEventCouple, 4);
    }

    void setState(boolean bl) {
        PicobolRadioButton picobolRadioButton = (PicobolRadioButton)this.guiComponent;
        if (picobolRadioButton != null && this.rbGroup != null) {
            if (bl) {
                this.rbGroup.setSelectedRadioButton(this);
            } else if (this.rbGroup.getSelectedRadioButton() == this) {
                bl = true;
            }
            picobolRadioButton.setSelected(bl);
        }
    }

    boolean getState() {
        if (this.guiComponent == null) {
            return false;
        }
        return ((PicobolRadioButton)this.getComponent()).isSelected();
    }

    @Override
    protected void intFocusGained(boolean bl) {
    }

    @Override
    public boolean isSelfAct() {
        if (this.guiComponent != null) {
            return this.guiComponent.getSelfAct();
        }
        return this.selfAct;
    }

    @Override
    public void setBorder(boolean bl) {
    }

    @Override
    public void setElementAt(int[] nArray) {
    }

    @Override
    public void setImage(int n2, int n3, int n4, int n5) {
        Rectangle rectangle = this.getBounds();
        n2 = rectangle.width;
        n3 = rectangle.height;
        if (n2 == 0 || !this.bitmapStyle) {
            return;
        }
        Image image = this.getLocalImage(n4);
        if (this.bitmapWidth == 0) {
            this.bitmapWidth = n2;
        }
        PicobolRadioButton picobolRadioButton = (PicobolRadioButton)this.guiComponent;
        if (this.guiComponent != null) {
            picobolRadioButton.setImage(image, this.bitmapWidth, n3);
            if (image != null && this.title != null) {
                picobolRadioButton.setHasBitmap(this.bitmapStyle);
                picobolRadioButton.setTitle(this.title);
            }
        }
    }

    @Override
    public void setRowsCols(float f2, float f3) {
        this.rows = f2;
    }

    @Override
    public void setStyle(int n2, boolean bl) {
        PicobolRadioButton picobolRadioButton = (PicobolRadioButton)this.guiComponent;
        if ((n2 & 0x10000) == 65536) {
            this.transparent = bl;
            if (this.guiComponent != null) {
                ((PicobolRadioButton)this.guiComponent).setOpaque(!this.transparent);
            }
        }
        if ((n2 & 0x400000) == 0x400000) {
            this.selfAct = bl;
            if (this.getComponent() != null) {
                this.getComponent().setSelfAct(bl);
            }
        }
        if ((n2 & 0x400) == 1024) {
            this.multiline = bl;
            if (picobolRadioButton != null) {
                picobolRadioButton.setMultiline(bl);
            }
        }
        if ((n2 & 0x200) == 512) {
            this.vtop = bl;
            if (picobolRadioButton != null) {
                picobolRadioButton.setVTop(bl);
            }
        }
        if ((n2 & 0x8000) == 32768) {
            this.bitmapStyle = bl;
            if (picobolRadioButton != null) {
                picobolRadioButton.setHasBitmap(bl);
            }
        }
        if ((n2 & 1) == 1) {
            this.noGroupTab = bl;
        }
        if ((n2 & 2) == 2) {
            this.leftText = bl;
            if (picobolRadioButton != null) {
                picobolRadioButton.setLeftText(bl);
            }
        }
        if ((n2 & 0x800) == 2048) {
            this.flat = bl;
            if (picobolRadioButton != null) {
                picobolRadioButton.setFlat(bl);
            }
        }
    }

    @Override
    public void setTitle(String string) {
        this.title = string;
        if (this.guiComponent != null && string != null) {
            PicobolRadioButton picobolRadioButton = (PicobolRadioButton)this.guiComponent;
            picobolRadioButton.setTitle(string);
            if (picobolRadioButton.getMnemonicChar() > '\u0000' && this.parentWindow != null) {
                this.parentWindow.removeMnemonic(this);
                this.parentWindow.addMnemonic(picobolRadioButton.getMnemonicChar(), this);
            }
        }
    }

    @Override
    public String setProp(Integer n2, String string, int n3) {
        String string2 = "0";
        int n4 = 0;
        boolean bl = false;
        try {
            n4 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            bl = true;
        }
        boolean bl2 = false;
        PicobolRadioButton picobolRadioButton = (PicobolRadioButton)this.guiComponent;
        switch (n2) {
            case 295: {
                if (bl) break;
                this.bitmapScale = n4;
                if (picobolRadioButton == null) break;
                picobolRadioButton.setBitmapScale(n4);
                break;
            }
            case 409: {
                if (bl) break;
                this.disabledColor = n4;
                if (picobolRadioButton != null) {
                    Color[] colorArray = this.getColors(n4);
                    picobolRadioButton.setDisabledBackground(colorArray[0]);
                    picobolRadioButton.setDisabledForeground(colorArray[1]);
                }
                string2 = "1";
                break;
            }
            case 411: {
                bl2 = true;
            }
            case 410: {
                if (bl) break;
                this.disabledBackgroundColor = n4;
                this.disabledBackgroundRgb = bl2;
                if (picobolRadioButton != null) {
                    Color color = this.getBackgroundColor(n4, bl2);
                    picobolRadioButton.setDisabledBackground(color);
                }
                string2 = "1";
                break;
            }
            case 413: {
                bl2 = true;
            }
            case 412: {
                if (bl) break;
                this.disabledForegroundColor = n4;
                this.disabledForegroundRgb = bl2;
                if (picobolRadioButton != null) {
                    Color color = this.getForegroundColor(n4, bl2);
                    picobolRadioButton.setDisabledForeground(color);
                }
                string2 = "1";
                break;
            }
            case 414: {
                if (bl) break;
                this.rolloverColor = n4;
                if (picobolRadioButton != null) {
                    Color[] colorArray = this.getColors(n4);
                    picobolRadioButton.setRolloverBackground(colorArray[0]);
                    picobolRadioButton.setRolloverForeground(colorArray[1]);
                }
                string2 = "1";
                break;
            }
            case 416: {
                bl2 = true;
            }
            case 415: {
                if (bl) break;
                this.rolloverBackgroundColor = n4;
                this.rolloverBackgroundRgb = bl2;
                if (picobolRadioButton != null) {
                    Color color = this.getBackgroundColor(n4, bl2);
                    picobolRadioButton.setRolloverBackground(color);
                }
                string2 = "1";
                break;
            }
            case 418: {
                bl2 = true;
            }
            case 417: {
                if (bl) break;
                this.rolloverForegroundColor = n4;
                this.rolloverForegroundRgb = bl2;
                if (picobolRadioButton != null) {
                    Color color = this.getForegroundColor(n4, bl2);
                    picobolRadioButton.setRolloverForeground(color);
                }
                string2 = "1";
                break;
            }
            case 320: {
                if (bl) break;
                this.leftTextAlign = n4;
                if (picobolRadioButton != null) {
                    picobolRadioButton.setLeftTextAlignment(this.leftTextAlign);
                }
                string2 = "1";
                break;
            }
            case 104: {
                if (!bl) {
                    this.groupValue = n4;
                    this.groupValueAlpha = null;
                    string2 = "1";
                    break;
                }
                this.groupValueAlpha = string;
                this.groupValue = this.rbGroup != null ? this.rbGroup.size() : 0;
                string2 = "1";
                break;
            }
            case 103: {
                if (bl) break;
                this.setGroupID(n4);
                string2 = "1";
                break;
            }
            case 7: 
            case 12: {
                if (bl) break;
                this.bitmapNumber = n4;
                if (picobolRadioButton != null) {
                    picobolRadioButton.setBitmapNumber(this.bitmapNumber);
                }
                string2 = "1";
                break;
            }
            case 8: {
                if (bl) break;
                this.bitmapDisabled = n4;
                if (picobolRadioButton != null) {
                    picobolRadioButton.setBitmapDisabled(this.bitmapDisabled);
                }
                string2 = "1";
                break;
            }
            case 13: {
                if (bl) break;
                this.bitmapPressed = n4;
                if (picobolRadioButton != null) {
                    picobolRadioButton.setBitmapPressed(this.bitmapPressed);
                }
                string2 = "1";
                break;
            }
            case 14: {
                if (bl) break;
                this.bitmapRollover = n4;
                if (picobolRadioButton != null) {
                    picobolRadioButton.setBitmapRollover(this.bitmapRollover);
                }
                string2 = "1";
                break;
            }
            case 16: {
                if (bl) break;
                this.bitmapSelected = n4;
                if (picobolRadioButton != null) {
                    picobolRadioButton.setBitmapSelected(this.bitmapSelected);
                }
                string2 = "1";
                break;
            }
            case 15: {
                if (bl) break;
                this.bitmapRolloverSelected = n4;
                if (picobolRadioButton != null) {
                    picobolRadioButton.setBitmapRolloverSelected(this.bitmapRolloverSelected);
                }
                string2 = "1";
                break;
            }
            case 240: {
                if (bl) break;
                this.titlePosition = n4;
                if (picobolRadioButton != null) {
                    picobolRadioButton.setTitlePosition(this.titlePosition);
                }
                string2 = "1";
                break;
            }
            case 20: {
                if (bl) break;
                this.bitmapWidth = n4;
                if (picobolRadioButton != null) {
                    picobolRadioButton.setBitmapWidth(this.bitmapWidth);
                }
                string2 = "1";
                break;
            }
            case 294: {
                if (bl) break;
                this.bitmapDisabledSelected = n4;
                if (picobolRadioButton != null) {
                    picobolRadioButton.setBitmapDisabledSelected(this.bitmapDisabledSelected);
                }
                string2 = "1";
                break;
            }
            default: {
                return super.setProp(n2, string, n3);
            }
        }
        return string2;
    }

    @Override
    public void destroy() {
        if (this.groupID > 0 && this.rbGroup != null) {
            this.rbGroup.removeElement(this);
        }
        super.destroy();
    }

    public void handleResponse(int n2, int n3) {
    }

    @Override
    public void handleResponse(int n2, RemoteRecordAccept remoteRecordAccept) {
        boolean bl = false;
        super.handleResponse(n2, remoteRecordAccept);
        RemoteBaseGUIControl remoteBaseGUIControl = this.getUponCtrl();
        if (remoteBaseGUIControl != null && remoteBaseGUIControl instanceof RemoteTab && ((RemoteTab)remoteBaseGUIControl).isRibbon()) {
            bl = true;
        }
        if (this.hasClickOverrideFocusChange() && (this.getActiveAccept() || bl) && (n2 == 0 || n2 == 1 || n2 == 2) && remoteRecordAccept.getEventType() == 17) {
            this.setState(true);
        }
    }

    @Override
    public void setCols(float f2) {
    }

    @Override
    public void setRows(float f2) {
    }

    @Override
    public void setSize(int n2, int n3, boolean bl) {
        this.width = n2;
        this.height = n3;
        if (this.guiComponent != null && bl) {
            this.updateLayoutManager();
            this.guiComponent.setSize(this.width, this.height);
        }
    }

    @Override
    public Rectangle getRealBounds() {
        Rectangle rectangle = this.guiComponent != null ? this.guiComponent.getBounds() : new Rectangle(this.x, this.y, this.width, this.height);
        return rectangle;
    }

    @Override
    protected boolean hasToSetAllData() {
        return true;
    }

    @Override
    public Rectangle getBounds() {
        Rectangle rectangle = this.getRealBounds();
        if (this.bitmapStyle) {
            if (!this.sizesInPixel) {
                rectangle.width -= 8;
            }
            if (!this.linesInPixel) {
                rectangle.height -= 7;
            }
        }
        return rectangle;
    }

    @Override
    public Rectangle getBoundsWithoutDefaultWidth() {
        Rectangle rectangle = this.getBounds();
        if (!this.bitmapStyle && rectangle != null && rectangle.width > 0) {
            rectangle.width = (int)((float)rectangle.width - 17.0f);
        }
        return rectangle;
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl && this.guiComponent != null && this.rbGroup != null && this.rbGroup.getSelectedRadioButton() == null && this.rbGroup.size() > 0) {
            RemoteRadioButton remoteRadioButton = this.rbGroup.getElementAt(0);
            if (remoteRadioButton.valueStr == null) {
                this.rbGroup.getElementAt(0).setState(true);
            }
        }
    }

    @Override
    public boolean isInputField() {
        return true;
    }

    @Override
    protected void processMnemonic(char c2) {
        super.processMnemonic(c2);
        PicobolRadioButton picobolRadioButton = (PicobolRadioButton)this.guiComponent;
        if (picobolRadioButton != null) {
            picobolRadioButton.doClick(100);
        }
    }

    @Override
    protected float paramgetDefaultWidth(ParamElementSize paramElementSize, int n2) {
        String string = null;
        if (paramElementSize.sizes > 0.0f) {
            return paramElementSize.sizes;
        }
        if (!this.bitmapStyle) {
            if (paramElementSize.sizesInPixel || this.bitmapStyle && !paramElementSize.sizesInCells || paramElementSize.sizesInCells) {
                if (this.title != null) {
                    string = this.title;
                }
                if (string != null) {
                    if (this.font != null) {
                        return (float)(this.font.computeScreenWidth(string) / this.font.computeScreenWidth("0")) + 1.2f;
                    }
                    return this.title.length();
                }
            } else {
                return 0.0f;
            }
        }
        return super.paramgetDefaultWidth(paramElementSize, n2);
    }

    @Override
    public String getType() {
        return "radiobutton";
    }

    @Override
    public String getProp(int n2) {
        PicobolRadioButton picobolRadioButton = (PicobolRadioButton)this.guiComponent;
        switch (n2) {
            case 103: {
                return "" + this.groupID;
            }
            case 104: {
                if (this.groupValueAlpha == null) {
                    return "" + this.groupValue;
                }
                return "" + this.groupValueAlpha;
            }
            case 410: {
                if (!this.disabledBackgroundRgb && this.disabledBackgroundColor != null) {
                    return this.disabledBackgroundColor.toString();
                }
                if (picobolRadioButton == null || picobolRadioButton.getDisabledBackground() == null) break;
                ColorCmp colorCmp = new ColorCmp(true);
                colorCmp.setBackRGB(picobolRadioButton.getDisabledBackground().getRGB());
                Color color = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(colorCmp.getBackground(), false));
                return Integer.toString(color != null ? color.getRGB() : 0);
            }
            case 412: {
                if (!this.disabledForegroundRgb && this.disabledForegroundColor != null) {
                    return this.disabledForegroundColor.toString();
                }
                if (picobolRadioButton == null || picobolRadioButton.getDisabledForeground() == null) break;
                ColorCmp colorCmp = new ColorCmp(true);
                colorCmp.setForeRGB(picobolRadioButton.getDisabledForeground().getRGB());
                Color color = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(colorCmp.getForeground(), false));
                return Integer.toString(color != null ? color.getRGB() : 0);
            }
            case 409: {
                if (this.disabledColor != null) {
                    return this.disabledColor.toString();
                }
                return "0";
            }
            case 415: {
                if (!this.rolloverBackgroundRgb && this.rolloverBackgroundColor != null) {
                    return this.rolloverBackgroundColor.toString();
                }
                if (picobolRadioButton == null || picobolRadioButton.getRolloverBackground() == null) break;
                ColorCmp colorCmp = new ColorCmp(true);
                colorCmp.setBackRGB(picobolRadioButton.getRolloverBackground().getRGB());
                Color color = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(colorCmp.getBackground(), false));
                return Integer.toString(color != null ? color.getRGB() : 0);
            }
            case 417: {
                if (!this.rolloverForegroundRgb && this.rolloverForegroundColor != null) {
                    return this.rolloverForegroundColor.toString();
                }
                if (picobolRadioButton == null || picobolRadioButton.getRolloverForeground() == null) break;
                ColorCmp colorCmp = new ColorCmp(true);
                colorCmp.setForeRGB(picobolRadioButton.getRolloverForeground().getRGB());
                Color color = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(colorCmp.getForeground(), false));
                return Integer.toString(color != null ? color.getRGB() : 0);
            }
            case 414: {
                if (this.rolloverColor != null) {
                    return this.rolloverColor.toString();
                }
                return "0";
            }
        }
        return super.getProp(n2);
    }

    @Override
    public boolean getNoGroupTab() {
        return this.noGroupTab;
    }

    @Override
    public boolean hasNextInGroupNV() {
        return true;
    }

    @Override
    protected boolean mustreceivepressed() {
        return true;
    }

    @Override
    public void adjustBounds(Rectangle rectangle) {
        if (this.bitmapStyle) {
            if (!this.sizesInPixel) {
                rectangle.width -= 8;
            }
            if (!this.linesInPixel) {
                rectangle.height -= 7;
            }
        }
    }

    @Override
    public boolean haveSameGroupValue(String string, int n2) {
        boolean bl = false;
        bl = this.groupValueAlpha != null ? this.getControlValue() == n2 : super.haveSameGroupValue(string, n2);
        return bl;
    }

    @Override
    public int getControlValue() {
        return this.groupValue;
    }

    @Override
    public JComponent getDragDropComponent() {
        return (PicobolRadioButton)this.guiComponent;
    }
}

