/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.client.swing.CobolEventCouple;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.PicobolScrollBar;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;

public class RemoteScrollBar
extends RemoteBaseGUIControl {
    private int minValue = 0;
    private int maxValue = 100;
    private int pageSize = 0;
    private boolean horizontalStyle;
    private boolean thumbTrackStyle;
    private int scrollValue = this.minValue;
    private boolean isProgramEvt;

    public RemoteScrollBar(GuiFactoryImpl guiFactoryImpl) {
        super(guiFactoryImpl);
    }

    @Override
    public void displayProp() {
    }

    @Override
    public float getDefaultHeight() {
        if (this.horizontalStyle) {
            return 1.5f;
        }
        return 0.0f;
    }

    @Override
    public float getDefaultWidth() {
        if (this.horizontalStyle) {
            return 0.0f;
        }
        return 2.7f;
    }

    @Override
    public int getGUIControlHeight(float f2) {
        if (this.font != null) {
            return (int)((float)this.font.getHeight() * f2);
        }
        return 20;
    }

    @Override
    public int getGUIControlWidth(float f2) {
        if (this.font != null) {
            return (int)((float)this.font.getWidth() * f2);
        }
        return 20;
    }

    @Override
    public String getTitle() {
        return "";
    }

    @Override
    public String getValue() {
        if (this.guiComponent == null) {
            return "";
        }
        return Integer.toString(((PicobolScrollBar)this.guiComponent).getValue());
    }

    @Override
    public void initialize() {
        if (this.guiComponent != null) {
            return;
        }
        this.guiComponent = new PicobolScrollBar();
        this.guiComponent.addKeyListener(this);
        PicobolScrollBar picobolScrollBar = (PicobolScrollBar)this.guiComponent;
        this.setHorizontal(this.horizontalStyle);
        super.intInitialize();
        picobolScrollBar.setMinimum(this.minValue);
        picobolScrollBar.setMaximum(this.maxValue);
        picobolScrollBar.setVisibleAmount(this.pageSize);
        picobolScrollBar.setValue(this.scrollValue);
        picobolScrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (RemoteScrollBar.this.isProgramEvt) {
                    RemoteScrollBar.this.isProgramEvt = false;
                } else {
                    RemoteScrollBar.this.responseOnAction(adjustmentEvent.getValue());
                }
            }
        });
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                return;
            }
        }
        super.keyPressed(keyEvent);
    }

    private void responseOnAction(int n2) {
        PicobolScrollBar picobolScrollBar = (PicobolScrollBar)this.guiComponent;
        ((RemoteDisplayWindow)this.parentWindow).stopTimer();
        if (n2 != this.scrollValue) {
            CobolEventCouple cobolEventCouple = new CobolEventCouple(this, new RemoteRecordAccept(7, 0, 16389, 0, n2, false, false, true));
            this.pushEvent(cobolEventCouple);
        }
    }

    @Override
    public boolean isSelfAct() {
        return false;
    }

    @Override
    public void setBorder(boolean bl) {
    }

    @Override
    public void setElementAt(int[] nArray) {
    }

    @Override
    public void setImage(int n2, int n3, int n4, int n5) {
    }

    @Override
    public String setProp(Integer n2, String string, int n3) {
        PicobolScrollBar picobolScrollBar = (PicobolScrollBar)this.guiComponent;
        String string2 = "0";
        int n4 = -1;
        boolean bl = false;
        try {
            n4 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            bl = true;
        }
        switch (n2) {
            case 148: {
                if (bl) break;
                this.maxValue = n4;
                if (picobolScrollBar != null) {
                    picobolScrollBar.setMaximum(this.maxValue);
                }
                string2 = "1";
                break;
            }
            case 152: {
                if (bl) break;
                this.minValue = n4;
                if (picobolScrollBar != null) {
                    picobolScrollBar.setMinimum(this.minValue);
                }
                string2 = "1";
                break;
            }
            case 162: {
                if (bl) break;
                this.pageSize = n4;
                if (picobolScrollBar != null) {
                    picobolScrollBar.setVisibleAmount(this.pageSize);
                }
                string2 = "1";
                break;
            }
            default: {
                return super.setProp(n2, string, n3);
            }
        }
        return string2;
    }

    @Override
    public void setRowsCols(float f2, float f3) {
    }

    @Override
    public void setStyle(int n2, boolean bl) {
        if ((n2 & 1) == 1) {
            this.setHorizontal(bl);
        }
        if ((n2 & 2) == 2) {
            this.thumbTrackStyle = bl;
        }
    }

    @Override
    public void setTitle(String string) {
    }

    private void setHorizontal(boolean bl) {
        this.horizontalStyle = bl;
        PicobolScrollBar picobolScrollBar = (PicobolScrollBar)this.guiComponent;
        if (picobolScrollBar != null) {
            picobolScrollBar.setOrientation(this.horizontalStyle ? 0 : 1);
        }
    }

    @Override
    public String setValue(String string) {
        try {
            this.scrollValue = Integer.parseInt(string.trim());
            this.setValue(this.scrollValue);
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private void setValue(int n2) {
        PicobolScrollBar picobolScrollBar = (PicobolScrollBar)this.guiComponent;
        if (picobolScrollBar != null && picobolScrollBar.getValue() != this.scrollValue) {
            this.isProgramEvt = true;
            ((PicobolScrollBar)this.guiComponent).setValue(this.scrollValue);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    public void handleResponse(int n2, int n3) {
    }

    @Override
    public void handleResponse(int n2, RemoteRecordAccept remoteRecordAccept) {
        PicobolScrollBar picobolScrollBar = (PicobolScrollBar)this.guiComponent;
        if (picobolScrollBar != null && picobolScrollBar.getValue() != this.scrollValue) {
            this.isProgramEvt = true;
            picobolScrollBar.setValue(this.scrollValue);
        }
    }

    @Override
    public void setCols(float f2) {
    }

    @Override
    public void setRows(float f2) {
    }

    @Override
    public void intFocusGained(boolean bl) {
    }

    @Override
    public void setSize(int n2, int n3, boolean bl) {
        super.setSize(n2, n3, bl);
        if (this.guiComponent != null && bl) {
            this.guiComponent.doLayout();
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl && this.parentWindow != null && (this.width == 0 || this.height == 0)) {
            Rectangle rectangle = ((RemoteDisplayWindow)this.parentWindow).getBounds();
            if (this.width == 0) {
                this.width = rectangle.width - this.x;
            }
            if (this.height == 0) {
                this.height = rectangle.height - this.y;
            }
            this.setSize(this.width, this.height);
        }
    }

    @Override
    public boolean isInputField() {
        return true;
    }

    @Override
    public String getType() {
        if (this.horizontalStyle) {
            return "hscrollbar";
        }
        return "vscrollbar";
    }
}

