/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.client.swing.CobolEventCouple;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.PicobolSlider;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RemoteSlider
extends RemoteBaseGUIControl {
    private int minValue;
    private int maxValue = 100;
    private int pageSize;
    private int majorTickSp;
    private int minorTickSp;
    private int labelsIncrement;
    private boolean horizontalStyle;
    private boolean invertedStyle;
    private boolean showTicksStyle;
    private boolean showLabelsStyle;
    private int sliderValue = this.minValue;
    private boolean transparent;

    public RemoteSlider(GuiFactoryImpl guiFactoryImpl) {
        super(guiFactoryImpl);
    }

    @Override
    public void displayProp() {
    }

    @Override
    public float getDefaultHeight() {
        if (this.horizontalStyle) {
            return 1.5f;
        }
        return 0.0f;
    }

    @Override
    public float getDefaultWidth() {
        if (this.horizontalStyle) {
            return 0.0f;
        }
        return 2.7f;
    }

    @Override
    public int getGUIControlHeight(float f2) {
        if (this.font != null) {
            return (int)((float)this.font.getHeight() * f2);
        }
        return 20;
    }

    @Override
    public int getGUIControlWidth(float f2) {
        if (this.font != null) {
            return (int)((float)this.font.getWidth() * f2);
        }
        return 20;
    }

    @Override
    public String getTitle() {
        return "";
    }

    @Override
    public String getValue() {
        return "" + this.sliderValue;
    }

    @Override
    public void initialize() {
        if (this.guiComponent != null) {
            return;
        }
        this.guiComponent = new PicobolSlider();
        this.guiComponent.addKeyListener(this);
        PicobolSlider picobolSlider = (PicobolSlider)this.guiComponent;
        this.setHorizontal(this.horizontalStyle);
        picobolSlider.setInverted(this.invertedStyle);
        picobolSlider.setPaintTicks(this.showTicksStyle);
        picobolSlider.setPaintLabels(this.showLabelsStyle);
        super.intInitialize();
        picobolSlider.setMinimum(this.minValue);
        picobolSlider.setMaximum(this.maxValue);
        picobolSlider.setExtent(this.pageSize);
        picobolSlider.setMinorTickSpacing(this.minorTickSp);
        picobolSlider.setMajorTickSpacing(this.majorTickSp);
        if (this.transparent) {
            picobolSlider.setOpaque(false);
        }
        if (this.labelsIncrement > 0) {
            picobolSlider.setLabelTable(picobolSlider.createStandardLabels(this.labelsIncrement));
        }
        picobolSlider.setValue(this.sliderValue);
        picobolSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                RemoteSlider.this.responseOnAction(jSlider.getValue());
            }
        });
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                return;
            }
        }
        super.keyPressed(keyEvent);
    }

    private void responseOnAction(int n2) {
        PicobolSlider picobolSlider = (PicobolSlider)this.guiComponent;
        if ((RemoteDisplayWindow)this.parentWindow != null) {
            ((RemoteDisplayWindow)this.parentWindow).stopTimer();
        }
        if (n2 != this.sliderValue) {
            this.sliderValue = n2;
            CobolEventCouple cobolEventCouple = new CobolEventCouple(this, new RemoteRecordAccept(7, 0, 17001, 0, n2, false, false, true));
            this.pushEvent(cobolEventCouple);
        }
    }

    @Override
    public boolean isSelfAct() {
        return false;
    }

    @Override
    public void setBorder(boolean bl) {
    }

    @Override
    public void setElementAt(int[] nArray) {
    }

    @Override
    public void setImage(int n2, int n3, int n4, int n5) {
    }

    @Override
    public String setProp(Integer n2, String string, int n3) {
        PicobolSlider picobolSlider = (PicobolSlider)this.guiComponent;
        String string2 = "0";
        int n4 = -1;
        boolean bl = false;
        try {
            n4 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            bl = true;
        }
        switch (n2) {
            case 148: {
                if (bl) break;
                this.maxValue = n4;
                if (picobolSlider != null) {
                    picobolSlider.setMaximum(this.maxValue);
                }
                string2 = "1";
                break;
            }
            case 152: {
                if (bl) break;
                this.minValue = n4;
                if (picobolSlider != null) {
                    picobolSlider.setMinimum(this.minValue);
                }
                string2 = "1";
                break;
            }
            case 162: {
                if (bl) break;
                this.pageSize = n4;
                if (picobolSlider != null) {
                    picobolSlider.setExtent(this.pageSize);
                }
                string2 = "1";
                break;
            }
            case 151: {
                if (bl) break;
                this.minorTickSp = n4;
                if (picobolSlider != null) {
                    picobolSlider.setMinorTickSpacing(this.minorTickSp);
                }
                string2 = "1";
                break;
            }
            case 141: {
                if (bl) break;
                this.majorTickSp = n4;
                if (picobolSlider != null) {
                    picobolSlider.setMajorTickSpacing(this.majorTickSp);
                }
                string2 = "1";
                break;
            }
            case 134: {
                if (bl) break;
                this.labelsIncrement = n4;
                if (picobolSlider != null) {
                    picobolSlider.setLabelTable(picobolSlider.createStandardLabels(this.labelsIncrement));
                }
                string2 = "1";
                break;
            }
            default: {
                return super.setProp(n2, string, n3);
            }
        }
        return string2;
    }

    @Override
    public void setRowsCols(float f2, float f3) {
    }

    @Override
    public void setStyle(int n2, boolean bl) {
        PicobolSlider picobolSlider = (PicobolSlider)this.guiComponent;
        if ((n2 & 1) == 1) {
            this.setHorizontal(bl);
        }
        if ((n2 & 2) == 2) {
            this.invertedStyle = bl;
            if (picobolSlider != null) {
                picobolSlider.setInverted(bl);
            }
        }
        if ((n2 & 4) == 4) {
            this.showTicksStyle = bl;
            if (picobolSlider != null) {
                picobolSlider.setPaintTicks(bl);
            }
        }
        if ((n2 & 8) == 8) {
            this.showLabelsStyle = bl;
            if (picobolSlider != null) {
                picobolSlider.setPaintLabels(bl);
            }
        }
        if ((n2 & 0x20) == 32) {
            this.transparent = bl;
            if (picobolSlider != null) {
                picobolSlider.setOpaque(!bl);
            }
        }
    }

    @Override
    public void setTitle(String string) {
    }

    private void setHorizontal(boolean bl) {
        this.horizontalStyle = bl;
        PicobolSlider picobolSlider = (PicobolSlider)this.guiComponent;
        if (picobolSlider != null) {
            picobolSlider.setOrientation(this.horizontalStyle ? 0 : 1);
        }
    }

    @Override
    public String setValue(String string) {
        try {
            this.sliderValue = Integer.parseInt(string.trim());
            this.setValue(this.sliderValue);
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private void setValue(int n2) {
        PicobolSlider picobolSlider = (PicobolSlider)this.guiComponent;
        if (picobolSlider != null && picobolSlider.getValue() != this.sliderValue) {
            picobolSlider.setValue(this.sliderValue);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    public void handleResponse(int n2, int n3) {
    }

    @Override
    public void handleResponse(int n2, RemoteRecordAccept remoteRecordAccept) {
    }

    @Override
    public void setCols(float f2) {
    }

    @Override
    public void setRows(float f2) {
    }

    @Override
    public void intFocusGained(boolean bl) {
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl && this.parentWindow != null && (this.width == 0 || this.height == 0)) {
            Rectangle rectangle = ((RemoteDisplayWindow)this.parentWindow).getBounds();
            if (this.width == 0) {
                this.width = rectangle.width - this.x;
            }
            if (this.height == 0) {
                this.height = rectangle.height - this.y;
            }
            super.setSize(this.width, this.height);
            this.guiComponent.doLayout();
        }
    }

    @Override
    public boolean isInputField() {
        return true;
    }

    @Override
    public String getType() {
        if (this.horizontalStyle) {
            return "hslider";
        }
        return "vslider";
    }
}

