/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.CobolFocusEvent;
import com.iscobol.gui.ParamElementSize;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.client.IscobolLayout;
import com.iscobol.gui.client.Justification;
import com.iscobol.gui.client.PicobolWidget;
import com.iscobol.gui.client.TerminalModel;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;

public class RemoteTerminalDisplay
extends RemoteBaseGUIControl {
    protected boolean isNumeric;
    protected boolean isUnderline;
    protected boolean isBlink;
    protected boolean isBold;
    private boolean isAll;
    protected Justification just = Justification.None;
    private boolean graphics;
    private String value;
    protected int linet = -1;
    protected int colt = -1;
    protected int lent = -1;
    private static final String HLINE = new String(new char[]{'\u0003'});
    private static final String VLINE = new String(new char[]{'\f'});
    private static final String ULCORNER = new String(new char[]{'\u0006'});
    private static final String URCORNER = new String(new char[]{'\u0005'});
    private static final String LLCORNER = new String(new char[]{'\n'});
    private static final String LRCORNER = new String(new char[]{'\t'});
    private static final String BTEE = new String(new char[]{'\u000b'});
    private static final String TTEE = new String(new char[]{'\u0007'});
    private static final String LTEE = new String(new char[]{'\u000e'});
    private static final String RTEE = new String(new char[]{'\r'});
    private static final String PLUS = new String(new char[]{'\u000f'});

    public RemoteTerminalDisplay(GuiFactoryImpl guiFactoryImpl) {
        super(guiFactoryImpl);
        this.temporary = true;
    }

    @Override
    public void initialize() {
        if (this.getComponent() == null) {
            this.setComponent(new MyComponent());
        }
        this.intInitialize();
    }

    @Override
    protected void intFocusGained(boolean bl) {
    }

    @Override
    public void displayProp() {
    }

    @Override
    public int getGUIControlHeight(float f2) {
        return 1;
    }

    @Override
    public int getGUIControlWidth(float f2) {
        return (int)f2;
    }

    @Override
    public float getDefaultWidth() {
        return 0.0f;
    }

    @Override
    public float getDefaultHeight() {
        return 0.0f;
    }

    @Override
    public String getTitle() {
        return this.getValue();
    }

    private static String justRight(String string, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "";
        if (string != null) {
            string2 = string.trim();
        }
        for (int i2 = string2.length(); i2 < n2; ++i2) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    private String justCentered(String string, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "";
        if (string != null) {
            string2 = string.trim();
        }
        n2 /= 2;
        for (int i2 = string2.length() / 2; i2 < n2; ++i2) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    private static String fillAll(String string, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            do {
                stringBuffer.append(string);
            } while (stringBuffer.length() < n2);
        }
        stringBuffer.setLength(n2);
        return stringBuffer.toString();
    }

    @Override
    public String getValue() {
        if (this.isAll) {
            this.value = RemoteTerminalDisplay.fillAll(this.value, this.getLength());
            this.isAll = false;
        }
        return this.value;
    }

    @Override
    public void setTitle(String string) {
        this.setValue(string);
    }

    @Override
    public boolean isSelfAct() {
        return false;
    }

    @Override
    public void setBorder(boolean bl) {
    }

    @Override
    public void setImage(int n2, int n3, int n4, int n5) {
    }

    @Override
    public void setElementAt(int[] nArray) {
    }

    @Override
    public String setValue(String string) {
        this.value = string;
        return null;
    }

    @Override
    public void setRowsCols(float f2, float f3) {
    }

    @Override
    public void setRows(float f2) {
    }

    @Override
    public void setCols(float f2) {
    }

    @Override
    public boolean isInputField() {
        return false;
    }

    public void handleResponse(int n2, int n3) {
    }

    @Override
    public void handleResponse(int n2, RemoteRecordAccept remoteRecordAccept) {
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    private static void displayGraphics(RemoteDisplayWindow remoteDisplayWindow, int n2, int n3, String string, int n4, Color color, int n5, Color color2, Justification justification) {
        n4 = Math.min(n4, string.length());
        for (int i2 = 0; i2 < n4; ++i2) {
            int n6 = 0x20000000;
            String string2 = string.substring(i2, i2 + 1);
            switch (string2.charAt(0)) {
                case 'J': 
                case 'j': {
                    string2 = LRCORNER;
                    break;
                }
                case 'K': 
                case 'k': {
                    string2 = URCORNER;
                    break;
                }
                case 'L': 
                case 'l': {
                    string2 = ULCORNER;
                    break;
                }
                case 'M': 
                case 'm': {
                    string2 = LLCORNER;
                    break;
                }
                case 'N': 
                case 'n': {
                    string2 = PLUS;
                    break;
                }
                case 'Q': 
                case 'q': {
                    string2 = HLINE;
                    break;
                }
                case 'T': 
                case 't': {
                    string2 = LTEE;
                    break;
                }
                case 'U': 
                case 'u': {
                    string2 = RTEE;
                    break;
                }
                case 'V': 
                case 'v': {
                    string2 = BTEE;
                    break;
                }
                case 'W': 
                case 'w': {
                    string2 = TTEE;
                    break;
                }
                case 'X': 
                case 'x': {
                    string2 = VLINE;
                    break;
                }
                default: {
                    n6 = 0;
                }
            }
            Rectangle rectangle = remoteDisplayWindow.mainWindow.display(n2 + i2, n3, string2, 1, color, n5 + n6, color2, justification);
            remoteDisplayWindow.setDoRepaint(rectangle);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            int n2;
            RemoteDisplayWindow remoteDisplayWindow = (RemoteDisplayWindow)this.parentWindow;
            String string = this.getNoecho() ? "" : this.getValue();
            int n3 = n2 = this.isUnderline ? 0x2000000 : 0;
            if (this.beep) {
                Toolkit.getDefaultToolkit().beep();
            }
            if (this.graphics) {
                RemoteTerminalDisplay.displayGraphics(remoteDisplayWindow, this.getColumn(), this.getLine(), string, this.getLength(), this.getColorForeground(), n2, this.getColorBackground(), this.just);
            } else if (this.getLength() > 0 || string != null && string.length() > 0) {
                Rectangle rectangle = remoteDisplayWindow.mainWindow.display(this.getColumn(), this.getLine(), string, this.getLength(), this.getColorForeground(), n2, this.getColorBackground(), this.just, this.isNational);
                remoteDisplayWindow.setDoRepaint(rectangle);
            }
        }
    }

    @Override
    public void setStyle(int n2, boolean bl) {
        if ((n2 & 0x100) == 256) {
            this.setIsNumeric(bl);
        }
        if ((n2 & 0x1000) == 4096) {
            this.setUnderline(bl);
        }
        if ((n2 & 8) == 8) {
            this.setBlink(bl);
        }
        if ((n2 & 0x80000) == 524288) {
            this.setAll(bl);
        }
        if ((n2 & 0x80) == 128) {
            this.setNoecho(bl);
        }
        if ((n2 & 0x400) == 1024) {
            this.setJust(1024);
        }
        if ((n2 & 0x20) == 32) {
            this.setJust(32);
        }
        if ((n2 & 0x10) == 16) {
            this.setJust(16);
        }
        if ((n2 & 2) == 2) {
            this.setBeep(bl);
        }
        if ((n2 & 0x800) == 2048) {
            this.graphics = true;
        }
    }

    public void setIsNumeric(boolean bl) {
        this.isNumeric = bl;
    }

    @Override
    public void setNoecho(boolean bl) {
        super.setNoecho(bl);
    }

    public void setUnderline(boolean bl) {
        this.isUnderline = bl;
    }

    public void setBold(boolean bl) {
        this.isBold = bl;
    }

    public void setBlink(boolean bl) {
        this.isBlink = bl;
    }

    public void setAll(boolean bl) {
        this.isAll = bl;
    }

    public void setJust(int n2) {
        switch (n2) {
            case 1024: {
                this.just = Justification.Right;
                break;
            }
            case 16: {
                this.just = Justification.Center;
                break;
            }
            case 32: {
                this.just = Justification.Left;
                break;
            }
            default: {
                this.just = Justification.None;
            }
        }
    }

    @Override
    public void focusGained(CobolFocusEvent cobolFocusEvent) {
        super.focusGained(cobolFocusEvent);
    }

    @Override
    public void focusLost(CobolFocusEvent cobolFocusEvent) {
        super.focusLost(cobolFocusEvent);
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    @Override
    protected float paramgetDefaultHeight(ParamElementSize paramElementSize, int n2) {
        return super.paramgetDefaultHeight(paramElementSize, n2);
    }

    @Override
    protected float paramgetDefaultWidth(ParamElementSize paramElementSize, int n2) {
        if (paramElementSize.sizes > 0.0f || !paramElementSize.sizesInCells) {
            return paramElementSize.sizes;
        }
        if (paramElementSize.title != null) {
            int n3 = paramElementSize.title.length();
            if (!this.isNational) {
                try {
                    TerminalModel terminalModel = this.getParentWindow().getMainWindow().getCharTerminal().getTerminalModel();
                    if (terminalModel.isDoubleByteCompat()) {
                        char[] cArray = paramElementSize.title.toCharArray();
                        for (int i2 = 0; i2 < cArray.length; ++i2) {
                            if (!terminalModel.dblWidth(cArray[i2])) continue;
                            ++n3;
                        }
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            return n3;
        }
        if (paramElementSize.ccPIClen != -1) {
            return paramElementSize.ccPIClen;
        }
        if (paramElementSize.ccOlen != -1) {
            return paramElementSize.ccOlen;
        }
        return super.paramgetDefaultWidth(paramElementSize, n2);
    }

    @Override
    public Dimension loadDimension0() {
        return null;
    }

    @Override
    public Dimension loadDimension0(Dimension dimension) {
        return null;
    }

    @Override
    protected void clear() {
        super.clear();
        this.isNumeric = false;
        this.isUnderline = false;
        this.isBlink = false;
        this.isBold = false;
        this.isAll = false;
        this.just = Justification.None;
        this.value = null;
        this.graphics = false;
        this.linet = -1;
        this.colt = -1;
        this.lent = -1;
    }

    @Override
    protected String getLayoutData(IscobolLayout iscobolLayout) {
        return null;
    }

    @Override
    public String getType() {
        return "terminaldisplay";
    }

    @Override
    public void setLocation(int n2, int n3, boolean bl) {
        if (this.y != n3) {
            this.linet = -1;
        }
        if (this.x != n2) {
            this.colt = -1;
        }
        super.setLocation(n2, n3, bl);
    }

    @Override
    public void setControlInfo(int n2) {
        super.setControlInfo(n2);
        this.isNational = (n2 & 0x800) == 2048;
    }

    @Override
    int getLine() {
        if (this.linet == -1) {
            this.linet = super.getLine();
        }
        return this.linet;
    }

    @Override
    protected int getColumn() {
        if (this.colt == -1) {
            this.colt = super.getColumn();
        }
        return this.colt;
    }

    @Override
    public void setSize(int n2, int n3, boolean bl) {
        if (this.width != n2) {
            this.lent = -1;
        }
        super.setSize(n2, n3, bl);
    }

    @Override
    protected int getLength() {
        if (this.lent == -1) {
            this.lent = super.getLength();
        }
        return this.lent;
    }

    @Override
    public boolean isTerminalEmulation() {
        return true;
    }

    static class MyComponent
    extends Component
    implements PicobolWidget {
        MyComponent() {
        }

        @Override
        public void setActiveAccept(boolean bl) {
        }

        @Override
        public void asyncProcessEvent(AWTEvent aWTEvent) {
        }

        @Override
        public boolean getActiveAccept() {
            return false;
        }

        @Override
        public void setSelfAct(boolean bl) {
        }

        @Override
        public boolean getSelfAct() {
            return false;
        }

        @Override
        public void paint(Graphics graphics) {
        }

        @Override
        public void setSize(int n2, int n3) {
        }

        @Override
        public void setLocation(int n2, int n3) {
        }

        @Override
        public void setBounds(int n2, int n3, int n4, int n5) {
        }
    }
}

