/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.Constants;
import com.iscobol.gui.IsguiWorker;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.client.PicobolWidget;
import com.iscobol.gui.client.swing.CobolEvent;
import com.iscobol.gui.client.swing.CobolEventCouple;
import com.iscobol.gui.client.swing.CobolEventListener;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.PicobolPanel;
import com.iscobol.gui.client.swing.PicobolWebBrowser;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteMenu;
import com.iscobol.gui.client.swing.SearchKeyEvent;
import com.iscobol.gui.client.swing.SearchKeyEventListener;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.OSValidator;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class RemoteWebBrowser
extends RemoteBaseGUIControl
implements Constants {
    public static final String JDIC_WEBBROWSER_CLASSNAME = "com.iscobol.gui.client.swing.JDICWebBrowser";
    private static final String DJ_WEBBROWSER_OLDCLASSNAME = "com.iscobol.dj.DJWebBrowser";
    public static final String DJ_WEBBROWSER_CLASSNAME = "com.iscobol.browser.dj.DJWebBrowser";
    private static final String JAVAFX_WEBBROWSER_OLDCLASSNAME = "com.iscobol.fx.JFXWebBrowser";
    public static final String JAVAFX_WEBBROWSER_CLASSNAME = "com.iscobol.browser.fx.JFXWebBrowser";
    public static final String DEFAULT_SEARCH_URL = "www.google.com";
    public static final String DEFAULT_HOME_URL = "www.veryant.com";
    private float rows;
    private float cols;
    private String value;
    private String fileName;
    private PicobolWebBrowser webBrowser;
    private boolean useReturn;
    private boolean useTab;
    private boolean useAlt;
    private boolean noMsgBeforeNavigate;
    private String searchUrl;
    private String homeUrl;
    private String webBrowserClassName;
    private Map<String, String> webBrowserAttrs;
    private PropertyChangeListener pcListener;
    private CobolEventListener ceListener;
    private SearchKeyEventListener shListener;

    public RemoteWebBrowser(final GuiFactoryImpl guiFactoryImpl) {
        super(guiFactoryImpl);
        this.noMsgBeforeNavigate = guiFactoryImpl.getCsProperty().get("iscobol.gui.webbrowser.no_msg_before_navigate", false);
        this.searchUrl = guiFactoryImpl.getCsProperty().get("iscobol.gui.web_browser.search", DEFAULT_SEARCH_URL);
        this.homeUrl = guiFactoryImpl.getCsProperty().get("iscobol.gui.web_browser.home", DEFAULT_HOME_URL);
        this.webBrowserClassName = guiFactoryImpl.getCsProperty().get("iscobol.gui.webbrowser.class", DJ_WEBBROWSER_CLASSNAME);
        if (DJ_WEBBROWSER_OLDCLASSNAME.equals(this.webBrowserClassName)) {
            this.webBrowserClassName = DJ_WEBBROWSER_CLASSNAME;
        } else if (JAVAFX_WEBBROWSER_OLDCLASSNAME.equals(this.webBrowserClassName)) {
            this.webBrowserClassName = JAVAFX_WEBBROWSER_CLASSNAME;
        }
        int n2 = this.webBrowserClassName.indexOf(63);
        if (n2 >= 0) {
            String string = this.webBrowserClassName.substring(n2 + 1);
            this.webBrowserAttrs = new HashMap<String, String>();
            this.webBrowserClassName = this.webBrowserClassName.substring(0, n2);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                n2 = string2.indexOf(61);
                if (n2 >= 0) {
                    this.webBrowserAttrs.put(string2.substring(0, n2), string2.substring(n2 + 1));
                    continue;
                }
                this.webBrowserAttrs.put(string2, "");
            }
        }
        this.pcListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("iscobol.gui.webbrowser.no_msg_before_navigate")) {
                    RemoteWebBrowser.this.noMsgBeforeNavigate = guiFactoryImpl.getCsProperty().get("iscobol.gui.webbrowser.no_msg_before_navigate", false);
                } else if (string.equals("iscobol.gui.web_browser.search")) {
                    RemoteWebBrowser.this.searchUrl = guiFactoryImpl.getCsProperty().get("iscobol.gui.web_browser.search", RemoteWebBrowser.DEFAULT_SEARCH_URL);
                } else if (string.equals("iscobol.gui.web_browser.home")) {
                    RemoteWebBrowser.this.homeUrl = guiFactoryImpl.getCsProperty().get("iscobol.gui.web_browser.home", RemoteWebBrowser.DEFAULT_HOME_URL);
                }
            }
        };
        guiFactoryImpl.getCsProperty().addPropertyChangeListener(this.pcListener);
    }

    @Override
    public float getDefaultWidth() {
        return 1.0f;
    }

    @Override
    public float getDefaultHeight() {
        return 1.0f;
    }

    @Override
    public void setCols(float f2) {
        this.setRowsCols(this.rows, f2);
    }

    @Override
    public void setRows(float f2) {
        this.setRowsCols(f2, this.cols);
    }

    @Override
    public void setRowsCols(float f2, float f3) {
        this.rows = f2;
        this.cols = f3;
    }

    @Override
    public void initialize() {
        if (this.guiComponent != null) {
            return;
        }
        this.init();
    }

    private static URL getUrl(String string) {
        URL uRL;
        block9: {
            uRL = null;
            if (string != null) {
                boolean bl = OSValidator.isWindows();
                String string2 = string.toLowerCase();
                if (bl && string2.startsWith("file:")) {
                    string = string2;
                }
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    if (string.indexOf("://") != -1) break block9;
                    File file = new File(string);
                    if (file != null && file.exists()) {
                        String string3 = OSValidator.isWindows() ? "file:///" + string2 : "file://" + string;
                        try {
                            uRL = new URL(string3);
                        }
                        catch (MalformedURLException malformedURLException2) {}
                    }
                    try {
                        uRL = new URL("http://" + string);
                    }
                    catch (MalformedURLException malformedURLException3) {
                        // empty catch block
                    }
                }
            }
        }
        return uRL;
    }

    void init() {
        URL uRL = RemoteWebBrowser.getUrl(this.value);
        Class<?> clazz = null;
        try {
            clazz = Class.forName(this.webBrowserClassName);
            if (clazz != null) {
                if (this.webBrowserAttrs != null) {
                    try {
                        this.webBrowser = (PicobolWebBrowser)clazz.getConstructor(Map.class).newInstance(this.webBrowserAttrs);
                    }
                    catch (Exception exception) {
                        this.webBrowser = (PicobolWebBrowser)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                } else {
                    this.webBrowser = (PicobolWebBrowser)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
        }
        catch (Exception exception) {
            throw new IscobolRuntimeException(exception);
        }
        this.webBrowser.setFileName(this.fileName);
        this.webBrowser.setNoMsgBeforeNavigate(this.noMsgBeforeNavigate);
        if (uRL != null) {
            this.webBrowser.setURL(uRL);
        } else if (this.value != null && this.value.length() > 0) {
            this.webBrowser.setValue(this.value);
        }
        this.setComponent(new PicobolPanel((PicobolWidget)((Object)this.webBrowser)));
        this.ceListener = new CobolEventListener(){

            @Override
            public void cobolEvent(CobolEvent cobolEvent) {
                CobolEventCouple cobolEventCouple = new CobolEventCouple(RemoteWebBrowser.this, new RemoteRecordAccept(cobolEvent.getType(), 0, cobolEvent.getId(), 0, 0, false, false, cobolEvent.getId() == 16429));
                RemoteWebBrowser.this.pushEvent(cobolEventCouple);
            }
        };
        this.webBrowser.addCobolEventListener(this.ceListener);
        this.shListener = new SearchKeyEventListener(){

            @Override
            public boolean isSearchKeyEvent(SearchKeyEvent searchKeyEvent) {
                return RemoteWebBrowser.this.gf.getRemoteVirtualKeyboard().isSearchKey(searchKeyEvent.getCode(), searchKeyEvent.isShiftDown(), searchKeyEvent.isControlDown(), searchKeyEvent.isAltDown(), "web-browser");
            }
        };
        this.webBrowser.addSearchKeyEventListener(this.shListener);
        this.guiComponent.addKeyListener(this);
        super.intInitialize();
    }

    @Override
    public int getGUIControlHeight(float f2) {
        int n2 = 0;
        if (this.font != null) {
            n2 = (int)((float)this.font.getHeight() * f2);
        }
        return n2;
    }

    @Override
    public int getGUIControlWidth(float f2) {
        int n2 = 0;
        if (this.font != null) {
            n2 = (int)((float)this.font.getWidth() * f2);
        }
        return n2;
    }

    @Override
    public String getValue() {
        return this.webBrowser == null || this.webBrowser.getURL() == null ? this.value : this.webBrowser.getURL().toString();
    }

    @Override
    public String setValue(String string) {
        this.value = string;
        if (this.webBrowser != null) {
            URL uRL = RemoteWebBrowser.getUrl(this.value);
            if (uRL != null) {
                this.webBrowser.setURL(uRL);
                return string;
            }
            if (string != null && string.length() > 0) {
                this.webBrowser.setValue(string);
                return string;
            }
            return null;
        }
        return null;
    }

    @Override
    public void setTitle(String string) {
    }

    @Override
    public void setStyle(int n2, boolean bl) {
        if ((n2 & 0x100) == 256) {
            this.useReturn = bl;
        }
        if ((n2 & 0x200) == 512) {
            this.useTab = bl;
        }
        if ((n2 & 0x400) == 1024) {
            this.useAlt = bl;
        }
        if ((n2 & 0x800) == 2048) {
            this.noMsgBeforeNavigate = bl;
            if (this.guiComponent != null) {
                ((PicobolWebBrowser)((Object)this.guiComponent)).setNoMsgBeforeNavigate(bl);
            }
        }
    }

    @Override
    public String getTitle() {
        if (this.webBrowser != null && this.webBrowser.getTitle() != null) {
            return this.webBrowser.getTitle();
        }
        return "";
    }

    @Override
    protected void intFocusGained(boolean bl) {
    }

    @Override
    public void setElementAt(int[] nArray) {
    }

    @Override
    public void setImage(int n2, int n3, int n4, int n5) {
    }

    @Override
    public void setSize(int n2, int n3, boolean bl) {
        super.setSize(n2, n3, bl);
        if (this.guiComponent != null && bl) {
            ((PicobolPanel)this.guiComponent).doLayout();
        }
    }

    @Override
    public void setBorder(boolean bl) {
    }

    @Override
    public boolean isSelfAct() {
        return false;
    }

    @Override
    public boolean isInputField() {
        boolean bl = false;
        if (this.webBrowserClassName == null || !this.webBrowserClassName.equalsIgnoreCase(JAVAFX_WEBBROWSER_CLASSNAME)) {
            // empty if block
        }
        bl = true;
        return bl;
    }

    @Override
    public void displayProp() {
    }

    @Override
    public String getProp(int n2) {
        switch (n2) {
            case 282: {
                return this.fileName != null ? this.fileName : "";
            }
            case 24: {
                if (this.webBrowser != null) {
                    return this.webBrowser.isBusy() ? "1" : "0";
                }
                return "0";
            }
            case 155: {
                if (this.webBrowser != null) {
                    String string = this.webBrowser.getURLString();
                    if (string != null) {
                        return string;
                    }
                    URL uRL = this.webBrowser.getURL();
                    if (uRL != null) {
                        return uRL.toString();
                    }
                    return "";
                }
                return "";
            }
            case 228: {
                return this.webBrowser != null ? this.webBrowser.getStatusText() : "";
            }
            case 175: {
                return this.webBrowser != null ? this.webBrowser.getProgress() : "0";
            }
            case 146: {
                return "100";
            }
        }
        return super.getProp(n2);
    }

    @Override
    public String setProp(Integer n2, String string, int n3) {
        int n4;
        try {
            n4 = Integer.parseInt(string.trim());
        }
        catch (Exception exception) {
            n4 = -1;
        }
        switch (n2) {
            case 102: {
                if (this.webBrowser != null && n4 == 1 && this.searchUrl != null) {
                    this.webBrowser.setValue(this.searchUrl);
                    return "1";
                }
                return "0";
            }
            case 101: {
                if (this.webBrowser != null && n4 == 1 && this.homeUrl != null) {
                    this.webBrowser.setValue(this.homeUrl);
                    return "1";
                }
                return "0";
            }
            case 311: {
                if (this.webBrowser != null && n4 == 1) {
                    this.webBrowser.selectAll();
                    return "1";
                }
                return "0";
            }
            case 312: {
                if (this.webBrowser != null && n4 == 1) {
                    this.webBrowser.copySelection();
                    return "1";
                }
                return "0";
            }
            case 99: {
                if (this.webBrowser != null && n4 == 1) {
                    this.webBrowser.back();
                    return "1";
                }
                return "0";
            }
            case 100: {
                if (this.webBrowser != null && n4 == 1) {
                    this.webBrowser.forward();
                    return "1";
                }
                return "0";
            }
            case 181: {
                if (this.webBrowser != null && n4 == 1) {
                    this.webBrowser.refresh();
                    return "1";
                }
                return "0";
            }
            case 229: {
                if (this.webBrowser != null && n4 == 1) {
                    this.webBrowser.stop();
                    return "1";
                }
                return "0";
            }
            case 278: {
                if (this.webBrowser != null && n4 == 1) {
                    this.webBrowser.printContent(true);
                    return "1";
                }
                return "0";
            }
            case 279: {
                if (this.webBrowser != null && n4 == 1) {
                    this.webBrowser.printNoPrompt(true);
                    return "1";
                }
                return "0";
            }
            case 280: {
                if (this.webBrowser != null && n4 == 1) {
                    this.webBrowser.saveAs(true);
                    return "1";
                }
                return "0";
            }
            case 281: {
                if (this.webBrowser != null && n4 == 1) {
                    this.webBrowser.saveAsNoPrompt(true);
                    return "1";
                }
                return "0";
            }
            case 282: {
                String string2 = this.fileName = string != null ? string.trim() : null;
                if (this.webBrowser != null) {
                    this.webBrowser.setFileName(this.fileName);
                }
                return "1";
            }
        }
        return super.setProp(n2, string, n3);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 10: {
                if (!this.useReturn) break;
                return;
            }
            case 9: {
                if (!this.useTab) break;
                return;
            }
            default: {
                if (!keyEvent.isAltDown() || !this.useAlt) break;
                return;
            }
        }
        super.keyPressed(keyEvent);
    }

    public void handleResponse(int n2, int n3) {
    }

    @Override
    public void handleResponse(int n2, RemoteRecordAccept remoteRecordAccept) {
        if (this.webBrowser != null && remoteRecordAccept.getEventType() == 16429) {
            if (n2 == 4 || n2 == 7) {
                this.webBrowser.abortOpenURL();
            } else {
                this.webBrowser.doOpenURL();
            }
        }
    }

    @Override
    public String getType() {
        return "webbrowser";
    }

    @Override
    public void destroy() {
        if (this.gf != null && this.gf.getCsProperty() != null) {
            this.gf.getCsProperty().removePropertyChangeListener(this.pcListener);
        }
        this.pcListener = null;
        if (this.guiComponent != null) {
            this.guiComponent.removeKeyListener(this);
        }
        if (this.webBrowser != null) {
            if (this.ceListener != null) {
                this.webBrowser.removeCobolEventListener(this.ceListener);
            }
            if (this.shListener != null) {
                this.webBrowser.removeSearchKeyEventListener(this.shListener);
            }
            try {
                new IsguiWorker(true, () -> this.webBrowser.destroy()).start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        super.destroy();
    }

    @Override
    public void setPopupMenu(RemoteMenu remoteMenu) {
        super.setPopupMenu(remoteMenu);
        this.webBrowser.setPopupMenuEnabled(remoteMenu != null);
    }
}

