/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.client.IscobolLayout;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import com.iscobol.gui.client.swing.RemoteScrollPaneOrig;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class ScrollPaneOrig
extends JPanel {
    private JPanel panel;
    private MyScrollPane scrollpane;
    private int scw;
    private int sch;
    private int w;
    private int h;
    private RemoteScrollPaneOrig parentRbgc;
    private boolean transparent;

    public ScrollPaneOrig(boolean bl, String string, String string2, RemoteScrollPaneOrig remoteScrollPaneOrig) {
        this.parentRbgc = remoteScrollPaneOrig;
        this.panel = new JPanel();
        this.panel.setLayout(null);
        this.scrollpane = new MyScrollPane(this.panel, 20, 30);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollpane, "Center");
        super.setFocusable(false);
        this.scrollpane.setBorder(null);
        this.panel.setBorder(null);
        this.parentRbgc.gradientMgr.addPropertyChangeListener(propertyChangeEvent -> {
            this.setOpaque();
            this.scrollpane.getViewport().repaint();
        });
        AdjustmentListener adjustmentListener = adjustmentEvent -> {
            this.panel.repaint();
            this.scrollpane.repaint();
            this.repaint();
        };
        this.scrollpane.getVerticalScrollBar().addAdjustmentListener(adjustmentListener);
        this.scrollpane.getHorizontalScrollBar().addAdjustmentListener(adjustmentListener);
        this.setOpaque();
    }

    @Override
    public void setBounds(int n2, int n3, int n4, int n5) {
        float f2 = ((float)n4 - (float)this.scw) / (float)this.scw * 100.0f;
        float f3 = ((float)n5 - (float)this.sch) / (float)this.sch * 100.0f;
        Rectangle rectangle = this.panel.getBounds();
        if (this.scw == 0) {
            this.scw = n4;
        }
        if (this.sch == 0) {
            this.sch = n5;
        }
        super.setBounds(n2, n3, n4, n5);
        if (this.scrollpane != null) {
            this.scrollpane.setBounds(0, 0, n4, n5);
        }
        if (this.panel != null) {
            float f4 = (float)this.w + (float)this.w * f2 / 100.0f;
            float f5 = (float)this.h + (float)this.h * f3 / 100.0f;
            this.panel.setPreferredSize(new Dimension((int)f4, (int)f5));
        }
    }

    @Override
    public void setSize(int n2, int n3) {
        super.setSize(n2, n3);
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.panel != null) {
            this.panel.setBackground(color);
        }
    }

    @Override
    public Color getBackground() {
        if (this.panel == null) {
            return super.getBackground();
        }
        return this.panel.getBackground();
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.panel != null) {
            this.panel.setForeground(color);
        }
    }

    @Override
    public Color getForeground() {
        if (this.panel == null) {
            return super.getForeground();
        }
        return this.panel.getForeground();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.panel != null) {
            this.panel.setFont(font);
        }
    }

    @Override
    public Font getFont() {
        if (this.panel == null) {
            return super.getFont();
        }
        return this.panel.getFont();
    }

    @Override
    public void setEnabled(boolean bl) {
        Object object;
        if (this.panel != null) {
            object = this.panel.getComponents();
            for (int i2 = 0; i2 < ((Component[])object).length; ++i2) {
                object[i2].setEnabled(bl);
            }
            this.panel.setEnabled(bl);
        }
        if (this.scrollpane != null) {
            JScrollBar jScrollBar;
            this.scrollpane.setEnabled(bl);
            object = this.scrollpane.getVerticalScrollBar();
            if (object != null) {
                ((JScrollBar)object).setEnabled(bl);
            }
            if ((jScrollBar = this.scrollpane.getHorizontalScrollBar()) != null) {
                jScrollBar.setEnabled(bl);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.panel == null) {
            return super.isEnabled();
        }
        return this.panel.isEnabled();
    }

    @Override
    public void setOpaque(boolean bl) {
        super.setOpaque(bl);
        if (this.scrollpane != null) {
            this.scrollpane.setOpaque(bl);
            this.scrollpane.getViewport().setOpaque(bl);
        }
        if (this.panel != null) {
            this.panel.setOpaque(bl);
        }
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setTransparent(boolean bl) {
        this.transparent = bl;
        this.setOpaque();
    }

    private void setOpaque() {
        this.setOpaque(!this.transparent && !this.parentRbgc.gradientMgr.isPaintGradient());
    }

    public void destroy(Hashtable hashtable) {
        super.removeAll();
        if (this.panel != null) {
            this.panel.removeAll();
        }
    }

    @Override
    public void setFocusable(boolean bl) {
        if (this.panel == null) {
            super.setFocusable(bl);
        } else {
            this.panel.setFocusable(bl);
        }
    }

    @Override
    public void requestFocus() {
        if (this.panel == null) {
            super.requestFocus();
        } else {
            this.panel.requestFocus();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.panel == null) {
            return super.requestFocusInWindow();
        }
        return this.panel.requestFocusInWindow();
    }

    @Override
    public void setToolTipText(String string) {
        if (this.panel != null) {
            this.panel.setToolTipText(string);
        }
    }

    protected void resetLayoutManager() {
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager instanceof IscobolLayout) {
            ((IscobolLayout)layoutManager).setOriginalContainerSize(null);
        }
    }

    public Point convertXY(String string, Point point, Rectangle rectangle) {
        Point point2 = this.getLocation();
        if (rectangle != null) {
            point2 = new Point(rectangle.x, rectangle.y);
        }
        point.y -= point2.y;
        point.x -= point2.x;
        point.y += 5;
        return point;
    }

    public void add(RemoteBaseGUIControl remoteBaseGUIControl, int n2, Hashtable hashtable) {
        LayoutManager layoutManager = null;
        Component component = (Component)((Object)remoteBaseGUIControl.getComponent());
        RemoteBaseGUIControl remoteBaseGUIControl2 = null;
        Component[] componentArray = this.panel.getComponents();
        for (n2 = 0; n2 < componentArray.length; ++n2) {
            if (componentArray[n2] == remoteBaseGUIControl.getComponent()) {
                return;
            }
            remoteBaseGUIControl2 = (RemoteBaseGUIControl)hashtable.get(componentArray[n2]);
            if (RemoteDisplayWindow.shouldInsertBefore(remoteBaseGUIControl, remoteBaseGUIControl2)) break;
        }
        Point point = component.getLocation();
        Dimension dimension = component.getSize();
        if (point.x + dimension.width > this.w || point.y + dimension.height > this.h) {
            if (point.x + dimension.width > this.w) {
                this.w = point.x + dimension.width;
            }
            if (point.y + dimension.height > this.h) {
                this.h = point.y + dimension.height;
            }
            this.panel.setPreferredSize(new Dimension(this.w, this.h));
        }
        this.panel.add(component, n2);
        if (remoteBaseGUIControl.getParentWindow() != null && (layoutManager = this.panel.getLayout()) instanceof IscobolLayout) {
            remoteBaseGUIControl.getParentWindow().addtolayout(remoteBaseGUIControl, layoutManager);
        }
        if (remoteBaseGUIControl != null && !this.isEnabled()) {
            remoteBaseGUIControl.setEnabled(false);
        }
    }

    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public void scrollRectToVisible(Rectangle rectangle) {
        if (this.panel != null) {
            this.panel.scrollRectToVisible(rectangle);
        }
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        if (this.scrollpane != null) {
            this.scrollpane.addMouseListener(mouseListener);
        } else {
            super.addMouseListener(mouseListener);
        }
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        if (this.scrollpane != null) {
            this.scrollpane.removeMouseListener(mouseListener);
        } else {
            super.removeMouseListener(mouseListener);
        }
    }

    private class MyScrollPane
    extends JScrollPane {
        MyScrollPane(Component component, int n2, int n3) {
            super(component, n2, n3);
        }

        @Override
        protected JViewport createViewport() {
            return new JViewport(){

                @Override
                public void paintComponent(Graphics graphics) {
                    if (((ScrollPaneOrig)ScrollPaneOrig.this).parentRbgc.gradientMgr.isPaintGradient()) {
                        JScrollBar jScrollBar;
                        Dimension dimension = this.getSize();
                        JScrollBar jScrollBar2 = MyScrollPane.this.getVerticalScrollBar();
                        if (jScrollBar2.isVisible()) {
                            dimension.width += jScrollBar2.getSize().width;
                        }
                        if ((jScrollBar = MyScrollPane.this.getHorizontalScrollBar()).isVisible()) {
                            dimension.height += jScrollBar.getSize().height;
                        }
                        ((ScrollPaneOrig)ScrollPaneOrig.this).parentRbgc.gradientMgr.paint((Graphics2D)graphics, new Rectangle(new Point(0, 0), dimension));
                    }
                    super.paintComponent(graphics);
                }
            };
        }
    }
}

