/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.rts.Factory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SearchPanel
extends JPanel {
    private static final String placeholder = Factory.getSysMsg("enter_text_to_search");
    private static final String CS_IMAGE = "vV.png";
    private static final String CIS_IMAGE = "vV2.png";
    private JTextField searchText;
    private JButton closeBtn;
    private JCheckBox filterBtn;
    private JButton prevBtn;
    private JButton nextBtn;
    private JButton cleanBtn;
    private JButton caseBtn;
    private JPanel leftPanel;
    private JPanel rightPanel;
    private boolean showFilterBtn;
    private boolean filterItems = true;
    private boolean filterCaseSensitive;
    private boolean showCSBtn;
    private boolean showCleanBtn;
    private boolean showNavBtns;
    private boolean showCloseBtn = true;
    private String filterText;
    private Vector<Notifier> spNotifiers = new Vector();

    public SearchPanel(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        super(new BorderLayout(0, 0));
        int n2;
        this.filterItems = bl2;
        this.showFilterBtn = bl;
        this.filterCaseSensitive = bl4;
        this.showCSBtn = bl3;
        this.showCleanBtn = bl5;
        this.showNavBtns = bl6;
        this.searchText = new JTextField(){

            @Override
            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                if (this.getText().length() == 0) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    graphics2D.setColor(this.getDisabledTextColor());
                    int n2 = this.getInsets().left;
                    graphics2D.drawString(placeholder, n2, graphics.getFontMetrics().getMaxAscent() + this.getInsets().top);
                }
            }
        };
        this.leftPanel = new JPanel(new GridLayout(0, this.getLeftComponentCount()));
        this.closeBtn = new JButton(new ImageIcon(this.getClass().getResource("cancelfind.png")));
        Insets insets = new Insets(0, 1, 0, 1);
        this.closeBtn.setMargin(insets);
        this.closeBtn.setIconTextGap(0);
        this.closeBtn.setFocusable(false);
        this.leftPanel.add(this.closeBtn);
        this.filterBtn = new JCheckBox(new ImageIcon(this.getClass().getResource("funnel.png")));
        this.filterBtn.setFocusable(false);
        this.filterBtn.addActionListener(actionEvent -> {
            boolean bl = this.filterBtn.isSelected();
            if (bl) {
                this.filterBtn.setBorder(BorderFactory.createLoweredBevelBorder());
                this.filterBtn.setBorderPainted(true);
            } else {
                this.filterBtn.setBorder(BorderFactory.createRaisedBevelBorder());
                this.filterBtn.setBorderPainted(false);
            }
            this.intSetFilterItems(bl);
        });
        this.filterBtn.setSelected(true);
        this.filterBtn.setBorder(BorderFactory.createLoweredBevelBorder());
        this.filterBtn.setBorderPainted(true);
        if (this.showFilterBtn) {
            this.leftPanel.add(this.filterBtn);
        }
        this.rightPanel = new JPanel(new GridLayout(0, (n2 = this.getRightComponentCount()) > 0 ? n2 : 1));
        this.prevBtn = new JButton(new ImageIcon(this.getClass().getResource("chevron_left2.png")));
        this.prevBtn.setMargin(insets);
        this.prevBtn.setIconTextGap(0);
        this.prevBtn.setFocusable(false);
        this.prevBtn.addActionListener(actionEvent -> {
            for (Notifier notifier : this.spNotifiers) {
                notifier.previousMatch();
            }
        });
        if (this.showNavBtns) {
            this.rightPanel.add(this.prevBtn);
        }
        this.nextBtn = new JButton(new ImageIcon(this.getClass().getResource("chevron_right2.png")));
        this.nextBtn.setMargin(insets);
        this.nextBtn.setIconTextGap(0);
        this.nextBtn.setFocusable(false);
        this.nextBtn.addActionListener(actionEvent -> {
            for (Notifier notifier : this.spNotifiers) {
                notifier.nextMatch();
            }
        });
        if (this.showNavBtns) {
            this.rightPanel.add(this.nextBtn);
        }
        this.cleanBtn = new JButton(new ImageIcon(this.getClass().getResource("cleanfind.png")));
        this.cleanBtn.setMargin(insets);
        this.cleanBtn.setIconTextGap(0);
        this.cleanBtn.setFocusable(false);
        this.cleanBtn.addActionListener(actionEvent -> this.searchText.setText(""));
        if (this.showCleanBtn) {
            this.rightPanel.add(this.cleanBtn);
        }
        this.caseBtn = new JButton(new ImageIcon(this.getClass().getResource(this.filterCaseSensitive ? CS_IMAGE : CIS_IMAGE)));
        this.caseBtn.setMargin(insets);
        this.caseBtn.setIconTextGap(0);
        this.caseBtn.setFocusable(false);
        this.caseBtn.setActionCommand(this.filterCaseSensitive ? CIS_IMAGE : CS_IMAGE);
        this.caseBtn.addActionListener(actionEvent -> {
            String string = this.caseBtn.getActionCommand();
            this.caseBtn.setIcon(new ImageIcon(this.getClass().getResource(string)));
            boolean bl = CS_IMAGE.equals(string);
            if (bl) {
                this.caseBtn.setActionCommand(CIS_IMAGE);
            } else {
                this.caseBtn.setActionCommand(CS_IMAGE);
            }
            this.intSetFilterCaseSensitive(bl);
        });
        if (this.showCSBtn) {
            this.rightPanel.add(this.caseBtn);
        }
        this.add((Component)this.searchText, "Center");
        this.add((Component)this.leftPanel, "West");
        if (bl7 && n2 > 0) {
            this.add((Component)this.rightPanel, "East");
        }
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.searchText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                SearchPanel.this.setFilterText(SearchPanel.this.searchText.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                SearchPanel.this.setFilterText(SearchPanel.this.searchText.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        this.searchText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    for (Notifier notifier : SearchPanel.this.spNotifiers) {
                        notifier.escapeKeyPressed();
                    }
                }
            }
        });
        this.closeBtn.addActionListener(actionEvent -> {
            for (Notifier notifier : this.spNotifiers) {
                notifier.closeButtonPressed();
            }
        });
    }

    private int getLeftComponentCount() {
        int n2 = 0;
        if (this.showCloseBtn) {
            ++n2;
        }
        if (this.showFilterBtn) {
            ++n2;
        }
        return n2;
    }

    private int getRightComponentCount() {
        int n2 = 0;
        if (this.showNavBtns) {
            n2 += 2;
        }
        if (this.showCSBtn) {
            ++n2;
        }
        if (this.showCleanBtn) {
            ++n2;
        }
        return n2;
    }

    public void resetSearchText() {
        this.searchText.setText("");
    }

    public void setFocus() {
        this.searchText.requestFocus();
    }

    public void setShowCloseButton(boolean bl) {
        if (this.showCloseBtn != bl) {
            this.showCloseBtn = bl;
            this.updateLeftPanel(this.showCloseBtn);
        }
    }

    public boolean isShowCloseButton() {
        return this.showCloseBtn;
    }

    public void setSearchTextFont(Font font) {
        this.searchText.setFont(font);
    }

    public Font getSearchTextFont() {
        return this.searchText.getFont();
    }

    public JTextField getSearchText() {
        return this.searchText;
    }

    private void setFilterText(String string) {
        this.filterText = string;
        for (Notifier notifier : this.spNotifiers) {
            notifier.filterTextChanged(this.filterText);
        }
    }

    public String getFilterText() {
        return this.filterText;
    }

    public boolean isFilterItems() {
        return this.filterItems;
    }

    public boolean isFilterCaseSensitive() {
        return this.filterCaseSensitive;
    }

    private void intSetFilterItems(boolean bl) {
        this.filterItems = bl;
        for (Notifier notifier : this.spNotifiers) {
            notifier.filterItemsChanged(this.filterItems);
        }
    }

    public void setFilterItems(boolean bl) {
        if (this.filterItems != bl) {
            this.filterBtn.setSelected(bl);
            this.filterBtn.setBorderPainted(bl);
            if (bl) {
                this.filterBtn.setBorder(BorderFactory.createLoweredBevelBorder());
            } else {
                this.filterBtn.setBorder(BorderFactory.createRaisedBevelBorder());
            }
            this.intSetFilterItems(bl);
        }
    }

    public boolean isShowFilterButton() {
        return this.showFilterBtn;
    }

    public void setShowFilterButton(boolean bl) {
        if (this.showFilterBtn != bl) {
            this.showFilterBtn = bl;
            this.updateLeftPanel(this.showFilterBtn);
        }
    }

    public boolean isShowCaseSensitiveButton() {
        return this.showCSBtn;
    }

    public void setShowCaseSensitiveButton(boolean bl) {
        if (this.showCSBtn != bl) {
            this.showCSBtn = bl;
            this.updateRightPanel(this.showCSBtn);
        }
    }

    private void updateLeftPanel(boolean bl) {
        int n2 = this.getLeftComponentCount();
        this.leftPanel.removeAll();
        if (n2 > 0) {
            ((GridLayout)this.leftPanel.getLayout()).setColumns(n2);
        }
        if (this.showCloseBtn) {
            this.leftPanel.add(this.closeBtn);
        }
        if (this.showFilterBtn) {
            this.leftPanel.add(this.filterBtn);
        }
        if (bl) {
            if (n2 == 1) {
                this.add((Component)this.leftPanel, "West");
            }
        } else if (n2 == 0) {
            this.remove(this.leftPanel);
        }
        this.doLayout();
    }

    private void updateRightPanel(boolean bl) {
        int n2 = this.getRightComponentCount();
        this.rightPanel.removeAll();
        if (n2 > 0) {
            ((GridLayout)this.rightPanel.getLayout()).setColumns(n2);
        }
        if (this.showNavBtns) {
            this.rightPanel.add(this.prevBtn);
            this.rightPanel.add(this.nextBtn);
        }
        if (this.showCleanBtn) {
            this.rightPanel.add(this.cleanBtn);
        }
        if (this.showCSBtn) {
            this.rightPanel.add(this.caseBtn);
        }
        if (bl) {
            if (n2 == 1) {
                this.add((Component)this.rightPanel, "East");
            }
        } else if (n2 == 0) {
            this.remove(this.rightPanel);
        }
        this.doLayout();
    }

    public boolean isShowCleanButton() {
        return this.showCleanBtn;
    }

    public void setShowCleanButton(boolean bl) {
        if (this.showCleanBtn != bl) {
            this.showCleanBtn = bl;
            this.updateRightPanel(this.showCleanBtn);
        }
    }

    public boolean isShowNavigationButtons() {
        return this.showNavBtns;
    }

    public void setShowNavigationButtons(boolean bl) {
        if (this.showNavBtns != bl) {
            this.showNavBtns = bl;
            this.updateRightPanel(this.showNavBtns);
        }
    }

    public void setFilterCaseSensitive(boolean bl) {
        if (this.filterCaseSensitive != bl) {
            this.caseBtn.setIcon(new ImageIcon(this.getClass().getResource(bl ? CS_IMAGE : CIS_IMAGE)));
            this.caseBtn.setActionCommand(bl ? CIS_IMAGE : CS_IMAGE);
            this.intSetFilterCaseSensitive(bl);
        }
    }

    private void intSetFilterCaseSensitive(boolean bl) {
        this.filterCaseSensitive = bl;
        for (Notifier notifier : this.spNotifiers) {
            notifier.filterCaseSensitiveChanged(this.filterCaseSensitive);
        }
    }

    public void addSearchPanelNotifier(Notifier notifier) {
        this.spNotifiers.addElement(notifier);
    }

    public void removeSearchPanelNotifier(Notifier notifier) {
        this.spNotifiers.removeElement(notifier);
    }

    public void setSettings(boolean[] blArray) {
        this.setFilterItems(blArray[0]);
        this.setShowFilterButton(blArray[1]);
        this.setShowNavigationButtons(blArray[2]);
        this.setShowCleanButton(blArray[3]);
        this.setFilterCaseSensitive(blArray[4]);
        this.setShowCaseSensitiveButton(blArray[5]);
    }

    public static boolean[] setSettings(String string, SearchPanel searchPanel) {
        boolean[] blArray = new boolean[]{true, false, false, true, false, true};
        block0 : switch (string.length()) {
            case 4: {
                switch (string.charAt(3)) {
                    default: {
                        blArray[4] = false;
                        blArray[5] = false;
                        if (searchPanel == null) break;
                        searchPanel.setFilterCaseSensitive(false);
                        searchPanel.setShowCaseSensitiveButton(false);
                        break;
                    }
                    case '1': {
                        blArray[4] = true;
                        blArray[5] = false;
                        if (searchPanel == null) break;
                        searchPanel.setFilterCaseSensitive(true);
                        searchPanel.setShowCaseSensitiveButton(false);
                        break;
                    }
                    case '2': {
                        blArray[4] = false;
                        blArray[5] = true;
                        if (searchPanel == null) break;
                        searchPanel.setFilterCaseSensitive(false);
                        searchPanel.setShowCaseSensitiveButton(true);
                        break;
                    }
                    case '3': {
                        blArray[4] = true;
                        blArray[5] = true;
                        if (searchPanel == null) break;
                        searchPanel.setFilterCaseSensitive(true);
                        searchPanel.setShowCaseSensitiveButton(true);
                    }
                }
            }
            case 3: {
                switch (string.charAt(2)) {
                    default: {
                        blArray[3] = false;
                        if (searchPanel == null) break;
                        searchPanel.setShowCleanButton(false);
                        break;
                    }
                    case '1': {
                        blArray[3] = true;
                        if (searchPanel == null) break;
                        searchPanel.setShowCleanButton(true);
                    }
                }
            }
            case 2: {
                switch (string.charAt(1)) {
                    default: {
                        blArray[2] = false;
                        if (searchPanel == null) break;
                        searchPanel.setShowNavigationButtons(false);
                        break;
                    }
                    case '1': {
                        blArray[2] = true;
                        if (searchPanel == null) break;
                        searchPanel.setShowNavigationButtons(true);
                    }
                }
            }
            case 1: {
                switch (string.charAt(0)) {
                    default: {
                        blArray[0] = false;
                        blArray[1] = false;
                        if (searchPanel == null) break block0;
                        searchPanel.setFilterItems(false);
                        searchPanel.setShowFilterButton(false);
                        break block0;
                    }
                    case '1': {
                        blArray[0] = true;
                        blArray[1] = false;
                        if (searchPanel == null) break block0;
                        searchPanel.setFilterItems(true);
                        searchPanel.setShowFilterButton(false);
                        break block0;
                    }
                    case '2': {
                        blArray[0] = false;
                        blArray[1] = true;
                        if (searchPanel == null) break block0;
                        searchPanel.setFilterItems(false);
                        searchPanel.setShowFilterButton(true);
                        break block0;
                    }
                    case '3': 
                }
                blArray[0] = true;
                blArray[1] = true;
                if (searchPanel == null) break;
                searchPanel.setFilterItems(true);
                searchPanel.setShowFilterButton(true);
            }
        }
        return blArray;
    }

    public void setSearchPanelSetting(short s2, boolean bl) {
        switch (s2) {
            case 0: {
                this.setFilterItems(bl);
                break;
            }
            case 1: {
                this.setShowFilterButton(bl);
                break;
            }
            case 2: {
                this.setShowNavigationButtons(bl);
                break;
            }
            case 3: {
                this.setShowCleanButton(bl);
                break;
            }
            case 4: {
                this.setFilterCaseSensitive(bl);
                break;
            }
            case 5: {
                this.setShowCaseSensitiveButton(bl);
            }
        }
    }

    public static interface Notifier {
        default public void nextMatch() {
        }

        default public void previousMatch() {
        }

        default public void escapeKeyPressed() {
        }

        default public void closeButtonPressed() {
        }

        default public void filterTextChanged(String string) {
        }

        default public void filterItemsChanged(boolean bl) {
        }

        default public void filterCaseSensitiveChanged(boolean bl) {
        }
    }
}

