/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.ColorCmp;
import com.iscobol.gui.client.LocalFontCmp;
import com.iscobol.gui.client.swing.GridCell;
import com.iscobol.gui.client.swing.GridViewS;
import com.iscobol.gui.export.GridDataProvider;
import java.awt.Color;
import java.awt.Font;

public class SwingGridDataProvider
implements GridDataProvider {
    private GridViewS grid;
    private int[] modelRowsIndexes;
    private int[] modelColumnsIndexes;
    private GridCell lastCell;
    private int[] columnAlignments;
    private int[] columnDividers;
    private int[] columnDataTypes;
    private String[] columnDateFormats;
    private int lastRow = -1;
    private int lastColumn = -1;
    private Color dividerColor;
    private Color headingDividerColor;

    public SwingGridDataProvider(GridViewS gridViewS) {
        this.grid = gridViewS;
        this.loadData();
    }

    private void loadData() {
        int n2;
        int n3;
        int n4 = this.grid.gridarray.size() + this.grid.headarraycell.size();
        int n5 = 0;
        int n6 = this.grid.getNumColHeadings();
        for (n3 = 0; n3 < n4; ++n3) {
            if (n3 >= n6 && this.grid.hiderowscols != null && this.grid.hiderowscols.isRowHide(n3 - n6)) continue;
            ++n5;
        }
        this.modelRowsIndexes = new int[n5];
        for (n3 = 0; n3 < n5; ++n3) {
            this.modelRowsIndexes[n3] = n3 < this.grid.getNumColHeadings() ? n3 : this.grid.getAbsoluteRowNoHeaderModel(n3);
        }
        n3 = this.grid.getDataColumnSize();
        int n7 = 0;
        int n8 = this.grid.getNumRowHeadings();
        for (n2 = 0; n2 < n3; ++n2) {
            if (n2 >= n8 && this.grid.hiderowscols != null && this.grid.hiderowscols.isColumnHide(n2)) continue;
            ++n7;
        }
        this.modelColumnsIndexes = new int[n7];
        this.columnAlignments = new int[n7];
        this.columnDividers = new int[n7];
        this.columnDataTypes = new int[n7];
        this.columnDateFormats = new String[n7];
        for (n2 = 0; n2 < n7; ++n2) {
            this.modelColumnsIndexes[n2] = n2 < n8 ? n2 : this.grid.getModel().convertColumnIndexToModel(n2);
            String string = this.grid.getAlignmentCell(null, this.modelColumnsIndexes[n2]);
            this.columnAlignments[n2] = "R".equalsIgnoreCase(string) ? 4 : ("C".equalsIgnoreCase(string) ? 0 : 2);
            this.columnDividers[n2] = this.grid.getDividersCell(null, this.modelColumnsIndexes[n2]);
            GridViewS.DataType dataType = this.grid.getDataType(this.modelColumnsIndexes[n2]);
            if (dataType != null) {
                if (dataType.isNumeric()) {
                    this.columnDataTypes[n2] = 2;
                    continue;
                }
                if (dataType.getSDF() != null) {
                    this.columnDataTypes[n2] = 3;
                    this.columnDateFormats[n2] = dataType.getSDF().toPattern();
                    continue;
                }
                this.columnDataTypes[n2] = 1;
                continue;
            }
            this.columnDataTypes[n2] = 0;
        }
        n2 = this.grid.getDividerColor();
        this.dividerColor = n2 >= 0 ? this.grid.parent.getGuiFactory().getRemotePalette().getDefaultColor(n2 - 1) : new Color(-n2);
        n2 = this.grid.getHeadingDividerColor();
        this.headingDividerColor = n2 >= 0 ? this.grid.parent.getGuiFactory().getRemotePalette().getDefaultColor(n2 - 1) : new Color(-n2);
    }

    @Override
    public int getColumnCount() {
        return this.modelColumnsIndexes.length;
    }

    @Override
    public int getColumnWidth(int n2) {
        return this.grid.getColWidth(n2);
    }

    @Override
    public int getRowCount() {
        return this.modelRowsIndexes.length;
    }

    @Override
    public int getRowHeight(int n2) {
        int n3 = this.modelRowsIndexes[n2];
        int n4 = this.grid.getNumColHeadings();
        if (n3 < n4) {
            return this.grid.getRowHeightData();
        }
        return this.grid.getRowHeightData(this.grid.getModel().convertRowIndexToView(n3 - n4)) + this.grid.getRowHeightDividers();
    }

    @Override
    public Color[] getCellColor(int n2, int n3) {
        boolean bl = this.grid.isInHeader(this.modelRowsIndexes[n2], this.modelColumnsIndexes[n3]);
        boolean bl2 = false;
        if (!bl) {
            bl2 = this.grid.isInRegion(n2 + this.grid.getNumColHeadings(), n3);
        }
        ColorCmp colorCmp = this.grid.getCellColor(this.getGridCell(n2, n3), this.modelRowsIndexes[n2], this.modelColumnsIndexes[n3], false, false, bl, bl2, false, false, n2);
        Color[] colorArray = new Color[]{colorCmp != null && colorCmp.isBackgroundSet() ? this.grid.getColor(ColorCmp.getRealColor(colorCmp.getBackground(), this.grid.getBackIntensity(colorCmp))) : this.grid.getJTable().getBackground(), colorCmp != null && colorCmp.isForegroundSet() ? this.grid.getColor(ColorCmp.getRealColor(colorCmp.getForeground(), this.grid.getForeIntensity(colorCmp))) : this.grid.getJTable().getForeground()};
        return colorArray;
    }

    @Override
    public Font getCellFont(int n2, int n3) {
        LocalFontCmp localFontCmp = this.grid.getCellFont(this.getGridCell(n2, n3), this.modelRowsIndexes[n2], this.modelColumnsIndexes[n3]);
        if (localFontCmp != null && localFontCmp.getFont() != null) {
            return localFontCmp.getFont();
        }
        return this.grid.getJTable().getFont();
    }

    @Override
    public int getColumnAlignment(int n2) {
        return this.columnAlignments[n2];
    }

    @Override
    public int getColumnDivider(int n2) {
        return this.columnDividers[n2];
    }

    @Override
    public int getColumnDataType(int n2) {
        return this.columnDataTypes[n2];
    }

    @Override
    public String getColumnDateFormat(int n2) {
        return this.columnDateFormats[n2];
    }

    @Override
    public Color getDividerColor(int n2, int n3) {
        if (n2 < this.grid.getNumColHeadings() || n3 < this.grid.getNumRowHeadings()) {
            return this.headingDividerColor;
        }
        return this.dividerColor;
    }

    @Override
    public String getCellData(int n2, int n3) {
        return this.grid.getCellData(this.modelRowsIndexes[n2], this.modelColumnsIndexes[n3]);
    }

    @Override
    public int getRowsDivider() {
        return this.grid.getRowHeightDividers();
    }

    private GridCell getGridCell(int n2, int n3) {
        if (n2 != this.lastRow || n3 != this.lastColumn) {
            this.lastRow = n2;
            this.lastColumn = n3;
            int n4 = this.grid.getNumColHeadings();
            this.lastCell = this.modelRowsIndexes[n2] < n4 ? (GridCell)this.grid.getValueAtHead(this.modelRowsIndexes[n2], this.modelColumnsIndexes[n3]) : this.grid.getValueAt(this.modelRowsIndexes[n2] - n4, this.modelColumnsIndexes[n3]);
        }
        return this.lastCell;
    }

    @Override
    public int getHeadingColumnCount() {
        return this.grid.getNumColHeadings();
    }

    @Override
    public int getHeadingRowCount() {
        return this.grid.getNumRowHeadings();
    }

    @Override
    public int getCellColumnSpan(int n2, int n3) {
        int n4 = 1;
        Object object = this.grid.getHeaderValueAt(n2, n3);
        if (object instanceof GridCell) {
            n4 = ((GridCell)object).getCellColumnsSpan();
        }
        return Math.max(1, n4);
    }

    @Override
    public int getCellRowSpan(int n2, int n3) {
        int n4 = 1;
        Object object = this.grid.getHeaderValueAt(n2, n3);
        if (object instanceof GridCell) {
            n4 = ((GridCell)object).getCellRowsSpan();
        }
        return Math.max(1, n4);
    }
}

