/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.client.swing.ListBox;
import com.iscobol.gui.export.ListBoxDataProvider;
import com.iscobol.rts.Factory;
import java.awt.Color;
import java.awt.Font;
import java.util.HashSet;
import java.util.Set;

public class SwingListBoxDataProvider
implements ListBoxDataProvider {
    private ListBox list;
    private ListBox.Column[] columns;
    private Set selIdxs = new HashSet();

    public SwingListBoxDataProvider(ListBox listBox, int n2) {
        this.list = listBox;
        this.columns = listBox.getColumns();
        if (n2 > 0) {
            int[] nArray = listBox.getSelectedIndices();
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                this.selIdxs.add(nArray[i2]);
            }
        }
    }

    @Override
    public int getColumnCount() {
        return this.columns != null ? this.columns.length : 0;
    }

    @Override
    public int getColumnWidth(int n2) {
        return n2 < this.getColumnCount() ? this.columns[n2].width : 0;
    }

    @Override
    public int getRowCount() {
        return this.list.getModelItemCount();
    }

    @Override
    public int getRowHeight(int n2) {
        return this.list.getFixedCellHeight();
    }

    @Override
    public Color getBackgroundColor(int n2) {
        if (this.selIdxs.contains(n2)) {
            return this.list.getSelectionBackground();
        }
        Color color = this.list.getBackgroundColor(this.list.getModelListItemAt(n2), n2);
        return color != null ? color : this.list.getBackground();
    }

    @Override
    public Color getForegroundColor(int n2) {
        if (this.selIdxs.contains(n2)) {
            return this.list.getSelectionForeground();
        }
        Color color = this.list.getForegroundColor(this.list.getModelListItemAt(n2), n2);
        return color != null ? color : this.list.getForeground();
    }

    @Override
    public Font getFont() {
        return this.list.getFont();
    }

    @Override
    public int getColumnAlignment(int n2) {
        return n2 < this.getColumnCount() ? this.columns[n2].alignment : 0;
    }

    @Override
    public String[] getCellData(int n2) {
        String[] stringArray = this.list.buildTokens(this.list.getModelListItemAt(n2));
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = Factory.rightTrim(stringArray[i2]);
        }
        return stringArray;
    }

    @Override
    public int getColumnDivider(int n2) {
        return n2 < this.getColumnCount() ? this.columns[n2].divider : 0;
    }

    @Override
    public Color getDividerColor() {
        return Color.black;
    }
}

