/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.client.TabWillChangeListener;
import com.iscobol.gui.client.swing.GradientManager;
import com.iscobol.gui.client.swing.PicobolTabNative;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteTab;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class Tab
extends JPanel {
    private static final long serialVersionUID = 0L;
    private PicobolTabNative tabPane = null;
    private JPanel borderedPane;
    private Color tabbg;
    private Color tabfg;
    private Color activetabbg;
    private Color activetabfg;
    private int[] borderwidth;
    private int[] activeborderwidth;
    private Color tabborderforegroundcolor;
    private Color activetabborderforegroundcolor;
    private boolean istabbuttons;
    private GradientManager gradientMgr;

    public Tab(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, RemoteTab remoteTab) {
        this.istabbuttons = bl4;
        this.gradientMgr = remoteTab.gradientMgr;
        this.tabPane = new PicobolTabNative(bl, false, false, bl2, bl3, bl4, null, null, remoteTab);
        this.setLayout(new BorderLayout(0, 0));
        this.borderedPane = new JPanel(){

            @Override
            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Tab.this.gradientMgr.paint((Graphics2D)graphics, new Rectangle(0, 0, this.getWidth(), this.getHeight()));
            }
        };
        if (this.tabbg != null) {
            this.tabPane.setTabBackgroundColor(this.tabbg);
        }
        if (this.tabfg != null) {
            this.tabPane.setTabForegroundColor(this.tabfg);
        }
        if (this.activetabbg != null) {
            this.tabPane.setActiveTabBackgroundColor(this.activetabbg);
        }
        if (this.activetabfg != null) {
            this.tabPane.setActiveTabForegroundColor(this.activetabfg);
        }
        if (!bl5 && !bl4) {
            if (bl3) {
                this.borderedPane.setBorder(BorderFactory.createEtchedBorder(1));
            } else {
                this.borderedPane.setBorder(BorderFactory.createRaisedBevelBorder());
            }
        }
        this.tabPane.setBorderWidth(this.borderwidth);
        this.tabPane.setActiveBorderWidth(this.borderwidth);
        this.tabPane.setBorderForegroundColor(this.tabborderforegroundcolor);
        this.tabPane.setActiveBorderForegroundColor(this.activetabborderforegroundcolor);
        this.borderedPane.setLayout(null);
        this.borderedPane.setOpaque(false);
        this.setOpaque(false);
        this.gradientMgr.addPropertyChangeListener(propertyChangeEvent -> {
            this.borderedPane.setOpaque(this.gradientMgr.isPaintGradient());
            this.setOpaque(this.gradientMgr.isPaintGradient());
            this.borderedPane.repaint();
        });
    }

    public JPanel getBorderedPane() {
        return this.borderedPane;
    }

    public void addTabWillChangeListener(TabWillChangeListener tabWillChangeListener) {
        this.tabPane.addTabWillChangeListener(tabWillChangeListener);
    }

    public void removeTabWillChangeListener(TabWillChangeListener tabWillChangeListener) {
        this.tabPane.removeTabWillChangeListener(tabWillChangeListener);
    }

    public void setImage(Image image) {
        this.tabPane.setImage(image);
    }

    public Image getImage() {
        return this.tabPane.getImage();
    }

    public void setBitmapWidth(int n2) {
        this.tabPane.setBitmapWidth(n2);
    }

    public int getBitmapWidth() {
        return this.tabPane.getBitmapWidth();
    }

    public int addTab(RemoteTab remoteTab, String string, int n2, JTabbedPane jTabbedPane, int n3, int n4) {
        MyPanel myPanel = null;
        myPanel = n2 >= 0 && n2 < this.tabPane.getTabCount() ? new MyPanel(n2) : new MyPanel(this.tabPane.getTabCount());
        if (!this.istabbuttons) {
            myPanel.setBorder(BorderFactory.createEtchedBorder(1));
        }
        return this.tabPane.addTab(string, n2, myPanel, jTabbedPane);
    }

    public int myremoveTabAt(int n2) {
        MyPanel myPanel = (MyPanel)this.tabPane.getComponentAt(n2);
        this.tabPane.removeTabAt(n2);
        return myPanel.getPosition();
    }

    @Override
    public void setFont(Font font) {
        if (this.tabPane != null) {
            this.tabPane.setFont(font);
        } else {
            super.setFont(font);
        }
    }

    @Override
    public Font getFont() {
        if (this.tabPane == null) {
            return super.getFont();
        }
        return this.tabPane.getFont();
    }

    public int getSelectedIndex() {
        return this.tabPane.getSelectedIndex();
    }

    public void setBitmapNumberAt(int n2, int n3) {
        this.tabPane.setBitmapNumberAt(n2, n3);
    }

    public void setIconAt(int n2, ImageIcon imageIcon) {
        this.tabPane.setIconAt(n2, imageIcon);
    }

    public JTabbedPane getTabbedPane() {
        return this.tabPane;
    }

    public String mygetTitleAt(int n2) {
        return this.tabPane.mygetTitleAt(n2);
    }

    public void setEnabledAt(int n2, boolean bl) {
        this.tabPane.setEnabledAt(n2, bl);
    }

    public boolean isEnabledAt(int n2) {
        return this.tabPane.isEnabledAt(n2);
    }

    public void mysetTitleAt(int n2, String string, JTabbedPane jTabbedPane) {
        this.tabPane.mysetTitleAt(n2, string, jTabbedPane);
    }

    public int getTabCount() {
        return this.tabPane.getTabCount();
    }

    @Override
    public void setBackground(Color color) {
        if (this.tabPane == null) {
            super.setBackground(color);
        } else {
            super.setBackground(color);
            this.tabPane.setBackground(color);
            for (int i2 = 0; i2 < this.getTabCount(); ++i2) {
                this.tabPane.getComponentAt(i2).setBackground(color);
            }
            this.borderedPane.setBackground(color);
        }
    }

    @Override
    public Color getBackground() {
        if (this.tabPane == null) {
            return super.getBackground();
        }
        return this.tabPane.getBackground();
    }

    @Override
    public void setForeground(Color color) {
        if (this.tabPane == null) {
            super.setForeground(color);
        } else {
            this.tabPane.setForeground(color);
            for (int i2 = 0; i2 < this.getTabCount(); ++i2) {
                this.tabPane.getComponentAt(i2).setForeground(color);
            }
        }
    }

    @Override
    public Color getForeground() {
        if (this.tabPane == null) {
            return super.getForeground();
        }
        return this.tabPane.getForeground();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.tabPane.setEnabled(bl);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.tabPane.setVisible(bl);
        this.borderedPane.setVisible(bl);
    }

    public void setTabPlacement(int n2) {
        this.tabPane.setTabPlacement(n2);
        this.removeAll();
        switch (n2) {
            case 1: {
                this.add((Component)this.tabPane, "North");
                break;
            }
            case 3: {
                this.add((Component)this.tabPane, "South");
                break;
            }
            case 2: {
                this.add((Component)this.tabPane, "West");
                break;
            }
            case 4: {
                this.add((Component)this.tabPane, "East");
            }
        }
        this.add((Component)this.borderedPane, "Center");
    }

    public void removeAllTabs() {
        this.tabPane.removeAll();
    }

    public void setMnemonicAt(int n2, int n3) {
        this.tabPane.setMnemonicAt(n2, n3);
    }

    public void setDisplayedMnemonicIndexAt(int n2, int n3) {
        this.tabPane.setDisplayedMnemonicIndexAt(n2, n3);
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        if (this.tabPane != null) {
            this.tabPane.addMouseListener(mouseListener);
        } else {
            super.addMouseListener(mouseListener);
        }
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        if (this.tabPane != null) {
            this.tabPane.removeMouseListener(mouseListener);
        } else {
            super.removeMouseListener(mouseListener);
        }
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        this.tabPane.addKeyListener(keyListener);
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        this.tabPane.removeKeyListener(keyListener);
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
        if (this.tabPane == null) {
            super.addFocusListener(focusListener);
        } else {
            this.tabPane.addFocusListener(focusListener);
        }
    }

    @Override
    public void removeFocusListener(FocusListener focusListener) {
        this.tabPane.removeFocusListener(focusListener);
    }

    @Override
    public void requestFocus() {
        this.tabPane.requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.tabPane.requestFocusInWindow();
    }

    @Override
    public void setFocusable(boolean bl) {
        this.tabPane.setFocusable(bl);
    }

    public void selectIndex(int n2) {
        this.tabPane.selectIndex(n2);
    }

    public Rectangle getButtonsBounds() {
        Rectangle rectangle = this.getBounds();
        rectangle.height = this.tabPane.getButtonsHeight();
        return rectangle;
    }

    public JTabbedPane getJTabbedPane() {
        return this.tabPane;
    }

    public Integer getPosition(Integer n2) {
        for (int i2 = 0; i2 < this.tabPane.getTabCount() && this.tabPane.getComponentAt(i2) != null; ++i2) {
            if (n2.intValue() != ((MyPanel)this.tabPane.getComponentAt(i2)).getPosition()) continue;
            return new Integer(i2);
        }
        return new Integer(-1);
    }

    public void setTextNoRotate(boolean bl) {
        this.tabPane.setTextNoRotate(bl);
    }

    @Override
    public void setToolTipText(String string) {
        this.tabPane.setToolTipText(string);
        this.borderedPane.setToolTipText(string);
    }

    public ImageIcon toGray(Icon icon) {
        return this.tabPane.toGray(icon);
    }

    public void destroy() {
    }

    public void mydoLayout() {
        this.tabPane.mydoLayout();
    }

    public void add(RemoteBaseGUIControl remoteBaseGUIControl, int n2, int n3, Hashtable hashtable) {
    }

    public boolean modifypanels() {
        return false;
    }

    public void setActiveAccept(boolean bl) {
        this.tabPane.setActiveAccept(bl);
    }

    @Override
    public void setName(String string) {
        if (this.tabPane != null) {
            this.tabPane.setName(string);
        }
    }

    public void setTabBackgroundColor(Color color) {
        this.tabbg = color;
        if (this.tabPane != null) {
            this.tabPane.setTabBackgroundColor(color);
        }
    }

    public void setTabForegroundColor(Color color) {
        this.tabfg = color;
        if (this.tabPane != null) {
            this.tabPane.setTabForegroundColor(color);
        }
    }

    public void setActiveTabBackgroundColor(Color color) {
        this.activetabbg = color;
        if (this.tabPane != null) {
            this.tabPane.setActiveTabBackgroundColor(color);
        }
    }

    public void setActiveTabForegroundColor(Color color) {
        this.activetabfg = color;
        if (this.tabPane != null) {
            this.tabPane.setActiveTabForegroundColor(color);
        }
    }

    public void setBorderWidth(int[] nArray) {
        this.borderwidth = nArray;
        if (this.tabPane != null) {
            this.tabPane.setBorderWidth(nArray);
        }
    }

    public void setActiveBorderWidth(int[] nArray) {
        this.activeborderwidth = nArray;
        if (this.tabPane != null) {
            this.tabPane.setActiveBorderWidth(nArray);
        }
    }

    public void setBorderForegroundColor(Color color) {
        this.tabborderforegroundcolor = color;
        if (this.tabPane != null) {
            this.tabPane.setBorderForegroundColor(this.tabborderforegroundcolor);
        }
    }

    public void setActiveBorderForegroundColor(Color color) {
        this.activetabborderforegroundcolor = color;
        if (this.tabPane != null) {
            this.tabPane.setActiveBorderForegroundColor(this.activetabborderforegroundcolor);
        }
    }

    public void addTabWidths(int n2, int n3, int n4, Integer n5) {
        if (this.tabPane != null) {
            this.tabPane.addTabWidths(n2, n3, n4, n5);
        }
    }

    @Override
    public void setSize(int n2, int n3) {
        super.setSize(n2, n3);
        if (this.tabPane != null) {
            this.tabPane.setSize(n2, n3);
        }
    }

    private class MyPanel
    extends JPanel {
        int position;

        public MyPanel(int n2) {
            this.position = n2;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = new Dimension();
            switch (Tab.this.tabPane.getTabPlacement()) {
                case 1: 
                case 3: {
                    dimension.height = 1;
                    dimension.width = ((Tab)Tab.this).tabPane.getSize().width;
                    break;
                }
                case 2: 
                case 4: {
                    dimension.width = 1;
                    dimension.height = ((Tab)Tab.this).tabPane.getSize().height;
                }
            }
            return dimension;
        }

        public int getPosition() {
            return this.position;
        }
    }
}

