/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;

public class TextIcon
implements PropertyChangeListener,
Icon {
    static final double NINETY_DEGREES = Math.toRadians(90.0);
    static final int bufSpace = 5;
    String label;
    String[] charStrings;
    int[] charWidths;
    int[] position;
    int width;
    int height;
    int charHeight;
    int descent;
    int rotation;
    Component component;
    Color fg;
    static final int POSITION_NORMAL = 0;
    static final int POSITION_TOP_RIGHT = 1;
    static final int POSITION_FAR_TOP_RIGHT = 2;
    public static final int ROTATE_DEFAULT = 0;
    public static final int ROTATE_NONE = 1;
    public static final int ROTATE_LEFT = 2;
    public static final int ROTATE_RIGHT = 4;
    static final String sDrawsInTopRight = "\u3041\u3043\u3045\u3047\u3049\u3063\u3083\u3085\u3087\u308e\u30a1\u30a3\u30a5\u30a7\u30a9\u30c3\u30e3\u30e5\u30e7\u30ee\u30f5\u30f6";
    static final String sDrawsInFarTopRight = "\u3001\u3002";
    static final int DEFAULT_CJK = 1;
    static final int LEGAL_ROMAN = 7;
    static final int DEFAULT_ROMAN = 4;
    static final int LEGAL_MUST_ROTATE = 6;
    static final int DEFAULT_MUST_ROTATE = 2;

    public TextIcon(Component component, String string, int n2) {
        this.component = component;
        this.label = string;
        this.rotation = TextIcon.verifyRotation(this.label, n2);
        this.calcDimensions();
        this.component.addPropertyChangeListener(this);
    }

    public void setLabel(String string) {
        this.label = string;
        this.rotation = TextIcon.verifyRotation(this.label, this.rotation);
        this.recalcDimensions();
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("font".equals(string)) {
            this.recalcDimensions();
        }
    }

    void recalcDimensions() {
        int n2 = this.getIconWidth();
        int n3 = this.getIconHeight();
        this.calcDimensions();
        if (n2 != this.getIconWidth() || n3 != this.getIconHeight()) {
            this.component.invalidate();
        }
    }

    void calcDimensions() {
        FontMetrics fontMetrics = this.component.getFontMetrics(this.component.getFont());
        this.charHeight = fontMetrics.getAscent() + fontMetrics.getDescent();
        this.descent = fontMetrics.getDescent();
        if (this.rotation == 1) {
            int n2 = this.label.length();
            char[] cArray = new char[n2];
            this.label.getChars(0, n2, cArray, 0);
            this.width = 0;
            this.charStrings = new String[n2];
            this.charWidths = new int[n2];
            this.position = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = cArray[i2];
                this.charWidths[i2] = fontMetrics.charWidth(c2);
                if (this.charWidths[i2] > this.width) {
                    this.width = this.charWidths[i2];
                }
                this.charStrings[i2] = new String(cArray, i2, 1);
                this.position[i2] = sDrawsInTopRight.indexOf(c2) >= 0 ? 1 : (sDrawsInFarTopRight.indexOf(c2) >= 0 ? 2 : 0);
            }
            this.height = this.charHeight * n2 + this.descent;
        } else {
            this.width = this.charHeight;
            this.height = fontMetrics.stringWidth(this.label) + 10;
        }
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
        if (component.isEnabled()) {
            graphics.setColor(this.fg != null ? this.fg : component.getForeground());
        } else {
            graphics.setColor(Color.lightGray);
        }
        graphics.setFont(component.getFont());
        if (this.rotation == 1) {
            this.addRenderingHints(graphics);
            int n4 = n3 + this.charHeight;
            for (int i2 = 0; i2 < this.charStrings.length; ++i2) {
                switch (this.position[i2]) {
                    case 0: {
                        graphics.drawString(this.charStrings[i2], n2 + (this.width - this.charWidths[i2]) / 2, n4);
                        break;
                    }
                    case 1: {
                        int n5 = this.charHeight / 3;
                        graphics.drawString(this.charStrings[i2], n2 + n5 / 2, n4 - n5);
                        break;
                    }
                    case 2: {
                        int n5 = this.charHeight - this.charHeight / 3;
                        graphics.drawString(this.charStrings[i2], n2 + n5 / 2, n4 - n5);
                    }
                }
                n4 += this.charHeight;
            }
        } else if (this.rotation == 2) {
            graphics.translate(n2 + this.width, n3 + this.height);
            ((Graphics2D)graphics).rotate(-NINETY_DEGREES);
            graphics.drawString(this.label, 5, -this.descent);
            ((Graphics2D)graphics).rotate(NINETY_DEGREES);
            graphics.translate(-(n2 + this.width), -(n3 + this.height));
        } else if (this.rotation == 4) {
            graphics.translate(n2, n3);
            ((Graphics2D)graphics).rotate(NINETY_DEGREES);
            graphics.drawString(this.label, 5, -this.descent);
            ((Graphics2D)graphics).rotate(-NINETY_DEGREES);
            graphics.translate(-n2, -n3);
        }
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    public static int verifyRotation(String string, int n2) {
        int n3;
        boolean bl = false;
        boolean bl2 = false;
        int n4 = string.length();
        char[] cArray = new char[n4];
        string.getChars(0, n4, cArray, 0);
        for (n3 = 0; n3 < n4; ++n3) {
            char c2 = cArray[n3];
            if (c2 >= '\u4e00' && c2 <= '\u9fff' || c2 >= '\u3400' && c2 <= '\u4dff' || c2 >= '\uf900' && c2 <= '\ufaff' || c2 >= '\u3040' && c2 <= '\u309f' || c2 >= '\u30a0' && c2 <= '\u30ff') {
                bl = true;
            }
            if (!(c2 >= '\u0590' && c2 <= '\u05ff' || c2 >= '\u0600' && c2 <= '\u06ff') && (c2 < '\u0700' || c2 > '\u074f')) continue;
            bl2 = true;
        }
        if (bl) {
            return 1;
        }
        int n5 = n3 = bl2 ? 6 : 7;
        if ((n2 & n3) > 0) {
            return n2;
        }
        return bl2 ? 2 : 4;
    }

    protected void addRenderingHints(Graphics graphics) {
    }

    public void setForeground(Color color) {
        this.fg = color;
    }
}

